/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.CustomFoldRegion;
import com.intellij.openapi.editor.CustomFoldRegionRenderer;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.impl.EditorComponentImpl;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.FoldRegionImpl;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.util.DocumentUtil;
import java.awt.Point;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CustomFoldRegionImpl
extends FoldRegionImpl
implements CustomFoldRegion {
    private final CustomFoldRegionRenderer myRenderer;
    private int myWidthInPixels;
    private int myHeightInPixels;
    private GutterIconRenderer myGutterIconRenderer;

    CustomFoldRegionImpl(@NotNull EditorImpl editor, int startOffset, int endOffset, @NotNull CustomFoldRegionRenderer renderer) {
        if (editor == null) {
            CustomFoldRegionImpl.$$$reportNull$$$0(0);
        }
        if (renderer == null) {
            CustomFoldRegionImpl.$$$reportNull$$$0(1);
        }
        super(editor, startOffset, endOffset, "", null, true);
        this.myRenderer = renderer;
        this.doUpdate();
    }

    @Override
    void alignToValidBoundaries() {
        DocumentEx document = this.getDocument();
        int startOffset = this.intervalStart();
        int endOffset = this.intervalEnd();
        if (startOffset == DocumentUtil.getLineStartOffset(startOffset, document) && endOffset == DocumentUtil.getLineEndOffset(endOffset, document)) {
            this.myEditor.getFoldingModel().myAffectedCustomRegions.add(this);
        } else {
            this.invalidate("Line alignment broken");
        }
    }

    @NotNull
    public CustomFoldRegionRenderer getRenderer() {
        CustomFoldRegionRenderer customFoldRegionRenderer = this.myRenderer;
        if (customFoldRegionRenderer == null) {
            CustomFoldRegionImpl.$$$reportNull$$$0(2);
        }
        return customFoldRegionRenderer;
    }

    public int getWidthInPixels() {
        return this.myWidthInPixels;
    }

    public int getHeightInPixels() {
        return this.myHeightInPixels;
    }

    @Nullable
    public GutterIconRenderer getGutterIconRenderer() {
        return this.myGutterIconRenderer;
    }

    public void update() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.myEditor.isDisposed() || !this.isValid()) {
            return;
        }
        if (this.myEditor.getDocument().isInEventsHandling()) {
            throw new IllegalStateException("Custom fold region shouldn't be updated during document change");
        }
        int oldWidth = this.myWidthInPixels;
        int oldHeight = this.myHeightInPixels;
        GutterIconRenderer oldIconRenderer = this.myGutterIconRenderer;
        this.doUpdate();
        int changeFlags = 0;
        if (oldWidth != this.myWidthInPixels) {
            changeFlags |= 1;
        }
        if (oldHeight != this.myHeightInPixels) {
            changeFlags |= 2;
        }
        if (!Objects.equals(oldIconRenderer, this.myGutterIconRenderer)) {
            changeFlags |= 4;
        }
        if (changeFlags != 0) {
            this.myEditor.getFoldingModel().notifyListenersOnPropertiesChange(this, changeFlags);
        } else {
            this.repaint();
        }
    }

    public void repaint() {
        if (this.isValid() && !this.myEditor.isDisposed()) {
            if (this.myEditor.getFoldingModel().isInBatchFoldingOperation()) {
                this.myEditor.getFoldingModel().myRepaintRequested = true;
            } else {
                Point location;
                EditorComponentImpl component2 = this.myEditor.getContentComponent();
                if (component2.isShowing() && (location = this.getLocation()) != null) {
                    component2.repaint(0, location.y, component2.getWidth(), this.myHeightInPixels);
                }
            }
        }
    }

    private void doUpdate() {
        this.myWidthInPixels = Math.max(0, this.myRenderer.calcWidthInPixels((CustomFoldRegion)this));
        this.myHeightInPixels = Math.max(this.myEditor.getLineHeight(), this.myRenderer.calcHeightInPixels((CustomFoldRegion)this));
        this.myGutterIconRenderer = this.myRenderer.calcGutterIconRenderer((CustomFoldRegion)this);
    }

    public Point getLocation() {
        int startOffset = this.getStartOffset();
        FoldRegion visibleRegion = this.myEditor.getFoldingModel().getCollapsedRegionAtOffset(startOffset);
        return visibleRegion == this ? new Point(this.myEditor.getContentComponent().getInsets().left, this.myEditor.visualLineToY(this.myEditor.offsetToVisualLine(startOffset))) : null;
    }

    @Override
    public String toString() {
        return super.toString() + ", renderer: " + this.myRenderer + ", size: " + this.myWidthInPixels + "x" + this.myHeightInPixels;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderer";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/impl/CustomFoldRegionImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/impl/CustomFoldRegionImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getRenderer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

