/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.codeInsight.daemon.GutterMark;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.TextAnnotationGutterProvider;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.impl.EditorGutterComponentImpl;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.markup.ActiveGutterRenderer;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.LineMarkerRenderer;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.JBColor;
import com.intellij.ui.paint.LinePainter2D;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.accessibility.SimpleAccessible;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.function.Consumer;
import javax.accessibility.AccessibleContext;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.LayoutFocusTraversalPolicy;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class AccessibleGutterLine
extends JPanel {
    private final EditorGutterComponentImpl myGutter;
    private AccessibleGutterElement mySelectedElement;
    private final int myLogicalLineNum;
    private final int myVisualLineNum;
    private static boolean actionHandlerInstalled;

    public static AccessibleGutterLine createAndActivate(@NotNull EditorGutterComponentImpl gutter) {
        if (gutter == null) {
            AccessibleGutterLine.$$$reportNull$$$0(0);
        }
        return new AccessibleGutterLine(gutter);
    }

    public void escape(boolean requestFocusToEditor) {
        this.myGutter.remove(this);
        this.myGutter.repaint();
        this.myGutter.setCurrentAccessibleLine(null);
        if (requestFocusToEditor) {
            IdeFocusManager.getGlobalInstance().requestFocus((Component)this.myGutter.getEditor().getContentComponent(), true);
        }
    }

    @Override
    public void paint(Graphics g) {
        this.mySelectedElement.paint(g);
    }

    public static void installListeners(final @NotNull EditorGutterComponentImpl gutter) {
        if (gutter == null) {
            AccessibleGutterLine.$$$reportNull$$$0(1);
        }
        if (!actionHandlerInstalled) {
            actionHandlerInstalled = true;
            EditorActionManager.getInstance().setActionHandler("EditorShowGutterIconTooltip", new EditorActionHandler(){

                protected void doExecute(@NotNull Editor editor, @Nullable Caret caret, DataContext dataContext) {
                    AccessibleGutterLine line;
                    if (editor == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if ((line = ((EditorGutterComponentImpl)editor.getGutter()).getCurrentAccessibleLine()) != null) {
                        line.showTooltipIfPresent();
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/editor/impl/AccessibleGutterLine$1", "doExecute"));
                }
            });
        }
        gutter.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                gutter.setCurrentAccessibleLine(AccessibleGutterLine.createAndActivate(gutter));
            }
        });
        gutter.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                gutter.escapeCurrentAccessibleLine();
            }
        });
        gutter.getEditor().getCaretModel().addCaretListener(new CaretListener(){

            public void caretPositionChanged(@NotNull CaretEvent event) {
                AccessibleGutterLine line;
                if (event == null) {
                    4.$$$reportNull$$$0(0);
                }
                if ((line = gutter.getCurrentAccessibleLine()) != null) {
                    line.maybeLineChanged();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/editor/impl/AccessibleGutterLine$4", "caretPositionChanged"));
            }
        });
    }

    private void moveRight() {
        IdeFocusManager.getGlobalInstance().requestFocus(this.getFocusTraversalPolicy().getComponentAfter(this, this.mySelectedElement), true);
    }

    @NotNull
    private static AnActionEvent convertAnActionEventToMouseAnActionEvent(@NotNull AnActionEvent e, @NotNull Component component2) {
        if (e == null) {
            AccessibleGutterLine.$$$reportNull$$$0(2);
        }
        if (component2 == null) {
            AccessibleGutterLine.$$$reportNull$$$0(3);
        }
        int x = component2.getX() + component2.getWidth() / 2;
        int y = component2.getY() + component2.getHeight() / 2;
        return new AnActionEvent((InputEvent)new MouseEvent(component2, 500, 0L, 0, x, y, 1, false), e.getDataContext(), e.getPlace(), e.getPresentation(), e.getActionManager(), e.getModifiers());
    }

    private void pressEnter(AnActionEvent e) {
        Component focusOwner = IdeFocusManager.getGlobalInstance().getFocusOwner();
        if (focusOwner instanceof AccessibleGutterElement) {
            ((AccessibleGutterElement)focusOwner).myAccessible.performAction(AccessibleGutterLine.convertAnActionEventToMouseAnActionEvent(e, focusOwner));
        }
    }

    private void moveLeft() {
        IdeFocusManager.getGlobalInstance().requestFocus(this.getFocusTraversalPolicy().getComponentBefore(this, this.mySelectedElement), true);
    }

    public void showTooltipIfPresent() {
        this.mySelectedElement.showTooltip();
    }

    private AccessibleGutterLine(@NotNull EditorGutterComponentImpl gutter) {
        if (gutter == null) {
            AccessibleGutterLine.$$$reportNull$$$0(4);
        }
        super(null);
        EditorImpl editor = gutter.getEditor();
        int lineHeight = editor.getLineHeight();
        this.myGutter = gutter;
        this.myLogicalLineNum = editor.getCaretModel().getPrimaryCaret().getLogicalPosition().line;
        this.myVisualLineNum = editor.getCaretModel().getPrimaryCaret().getVisualPosition().line;
        if (this.myGutter.isLineNumbersShown()) {
            this.addNewElement(new MySimpleAccessible(){

                @NotNull
                public String getAccessibleName() {
                    String string = IdeBundle.message((String)"accessible.name.line", (Object[])new Object[]{AccessibleGutterLine.this.myLogicalLineNum + 1});
                    if (string == null) {
                        5.$$$reportNull$$$0(0);
                    }
                    return string;
                }

                public String getAccessibleTooltipText() {
                    return null;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/AccessibleGutterLine$5", "getAccessibleName"));
                }
            }, this.myGutter.getLineNumberAreaOffset(), 0, this.myGutter.getLineNumberAreaWidth(), lineHeight);
        }
        if (this.myGutter.isAnnotationsShown()) {
            int x2 = this.myGutter.getAnnotationsAreaOffset();
            int width = 0;
            String tooltipText = null;
            final StringBuilder buf = new StringBuilder();
            for (int i2 = 0; i2 < this.myGutter.myTextAnnotationGutters.size(); ++i2) {
                TextAnnotationGutterProvider gutterProvider = this.myGutter.myTextAnnotationGutters.get(i2);
                if (tooltipText == null) {
                    tooltipText = gutterProvider.getToolTip(this.myLogicalLineNum, (Editor)editor);
                }
                int annotationSize = this.myGutter.myTextAnnotationGutterSizes.getInt(i2);
                buf.append((String)ObjectUtils.notNull((Object)gutterProvider.getLineText(this.myLogicalLineNum, (Editor)editor), (Object)""));
                width += annotationSize;
            }
            if (buf.length() > 0) {
                final String tt = tooltipText;
                this.addNewElement(new MySimpleAccessible(){

                    @NotNull
                    public String getAccessibleName() {
                        String string = IdeBundle.message((String)"accessible.name.annotation", (Object[])new Object[]{buf.toString()});
                        if (string == null) {
                            6.$$$reportNull$$$0(0);
                        }
                        return string;
                    }

                    public String getAccessibleTooltipText() {
                        return tt;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/AccessibleGutterLine$6", "getAccessibleName"));
                    }
                }, x2, 0, width, lineHeight);
            }
        }
        if (this.myGutter.areIconsShown()) {
            List<GutterMark> row2 = this.myGutter.getGutterRenderers(this.myVisualLineNum);
            this.myGutter.processIconsRow(this.myVisualLineNum, row2, (x, y, renderer) -> {
                Icon icon2 = this.myGutter.scaleIcon(renderer.getIcon());
                this.addNewElement(new MySimpleAccessible(){
                    final AnAction myAction;
                    {
                        this.myAction = ((GutterIconRenderer)renderer).getClickAction();
                    }

                    @Override
                    public void performAction(@NotNull AnActionEvent e) {
                        if (e == null) {
                            7.$$$reportNull$$$0(0);
                        }
                        this.myAction.actionPerformed(e);
                    }

                    @NotNull
                    public String getAccessibleName() {
                        if (renderer instanceof SimpleAccessible) {
                            String string = ((SimpleAccessible)renderer).getAccessibleName();
                            if (string == null) {
                                7.$$$reportNull$$$0(1);
                            }
                            return string;
                        }
                        String string = IdeBundle.message((String)"accessible.name.icon", (Object[])new Object[]{renderer.getClass().getSimpleName()});
                        if (string == null) {
                            7.$$$reportNull$$$0(2);
                        }
                        return string;
                    }

                    public String getAccessibleTooltipText() {
                        return renderer.getTooltipText();
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        RuntimeException runtimeException;
                        Object[] objectArray;
                        Object[] objectArray2;
                        int n2;
                        String string;
                        switch (n) {
                            default: {
                                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                                break;
                            }
                            case 1: 
                            case 2: {
                                string = "@NotNull method %s.%s must not return null";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                n2 = 3;
                                break;
                            }
                            case 1: 
                            case 2: {
                                n2 = 2;
                                break;
                            }
                        }
                        Object[] objectArray3 = new Object[n2];
                        switch (n) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "e";
                                break;
                            }
                            case 1: 
                            case 2: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "com/intellij/openapi/editor/impl/AccessibleGutterLine$7";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[1] = "com/intellij/openapi/editor/impl/AccessibleGutterLine$7";
                                break;
                            }
                            case 1: 
                            case 2: {
                                objectArray = objectArray2;
                                objectArray2[1] = "getAccessibleName";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                objectArray = objectArray;
                                objectArray[2] = "performAction";
                                break;
                            }
                            case 1: 
                            case 2: {
                                break;
                            }
                        }
                        String string2 = String.format(string, objectArray);
                        switch (n) {
                            default: {
                                runtimeException = new IllegalArgumentException(string2);
                                break;
                            }
                            case 1: 
                            case 2: {
                                runtimeException = new IllegalStateException(string2);
                                break;
                            }
                        }
                        throw runtimeException;
                    }
                }, x, 0, icon2.getIconWidth(), lineHeight);
            });
        }
        if (this.myGutter.isLineMarkersShown()) {
            int firstVisibleOffset = editor.visualLineStartOffset(this.myVisualLineNum);
            int lastVisibleOffset = editor.visualLineStartOffset(this.myVisualLineNum + 1);
            this.myGutter.processRangeHighlighters(firstVisibleOffset, lastVisibleOffset, highlighter -> {
                Rectangle bounds2;
                Rectangle rect;
                LineMarkerRenderer renderer = highlighter.getLineMarkerRenderer();
                if (renderer instanceof ActiveGutterRenderer && (rect = this.myGutter.getLineRendererRectangle(highlighter)) != null && (bounds2 = ((ActiveGutterRenderer)renderer).calcBounds((Editor)editor, this.myVisualLineNum, rect)) != null) {
                    this.addNewElement(new MySimpleAccessibleDelegat((SimpleAccessible)((ActiveGutterRenderer)renderer)), bounds2.x, 0, bounds2.width, bounds2.height);
                }
            });
        }
        this.setOpaque(false);
        this.setFocusable(false);
        this.setFocusCycleRoot(true);
        this.setFocusTraversalPolicyProvider(true);
        this.setFocusTraversalPolicy(new LayoutFocusTraversalPolicy());
        this.setBounds(0, editor.visualLineToY(this.myVisualLineNum), this.myGutter.getWhitespaceSeparatorOffset(), lineHeight);
        this.myGutter.add(this);
        this.mySelectedElement = (AccessibleGutterElement)this.getFocusTraversalPolicy().getFirstComponent(this);
        if (this.mySelectedElement == null) {
            Rectangle b = this.getBounds();
            this.mySelectedElement = this.addNewElement(new MySimpleAccessible(){

                @NotNull
                public String getAccessibleName() {
                    String string = IdeBundle.message((String)"accessible.name.empty", (Object[])new Object[0]);
                    if (string == null) {
                        8.$$$reportNull$$$0(0);
                    }
                    return string;
                }

                public String getAccessibleTooltipText() {
                    return null;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/AccessibleGutterLine$8", "getAccessibleName"));
                }
            }, 0, 0, b.width, b.height);
        }
        this.installActionHandler(CommonShortcuts.ESCAPE, () -> this.escape(true));
        this.installActionHandler(CommonShortcuts.ENTER, this::pressEnter);
        this.installActionHandler((ShortcutSet)MyShortcuts.MOVE_RIGHT, this::moveRight);
        this.installActionHandler((ShortcutSet)MyShortcuts.MOVE_LEFT, this::moveLeft);
        IdeFocusManager.getGlobalInstance().requestFocus((Component)this.mySelectedElement, true);
    }

    private void installActionHandler(ShortcutSet shortcut, Runnable action2) {
        DumbAwareAction.create(e -> action2.run()).registerCustomShortcutSet(shortcut, (JComponent)this);
    }

    private void installActionHandler(ShortcutSet shortcut, Consumer<? super AnActionEvent> action2) {
        DumbAwareAction.create(e -> action2.accept((AnActionEvent)e)).registerCustomShortcutSet(shortcut, (JComponent)this);
    }

    @NotNull
    private AccessibleGutterElement addNewElement(@NotNull MySimpleAccessible accessible, int x, int y, int width, int height) {
        if (accessible == null) {
            AccessibleGutterLine.$$$reportNull$$$0(5);
        }
        AccessibleGutterElement obj2 = new AccessibleGutterElement(accessible, new Rectangle(x, y, width, height));
        this.add(obj2);
        AccessibleGutterElement accessibleGutterElement = obj2;
        if (accessibleGutterElement == null) {
            AccessibleGutterLine.$$$reportNull$$$0(6);
        }
        return accessibleGutterElement;
    }

    @Override
    public void removeNotify() {
        this.repaint();
        super.removeNotify();
    }

    private void maybeLineChanged() {
        if (this.myLogicalLineNum == this.myGutter.getEditor().getCaretModel().getPrimaryCaret().getLogicalPosition().line) {
            return;
        }
        this.myGutter.remove(this);
        this.myGutter.setCurrentAccessibleLine(AccessibleGutterLine.createAndActivate(this.myGutter));
    }

    @Override
    public void repaint() {
        if (this.myGutter == null) {
            return;
        }
        int y = this.myGutter.getEditor().visualLineToY(this.myVisualLineNum);
        this.myGutter.repaint(0, y, this.myGutter.getWhitespaceSeparatorOffset(), y + this.myGutter.getEditor().getLineHeight());
    }

    private boolean isActive() {
        return this == this.myGutter.getCurrentAccessibleLine();
    }

    public static boolean isAccessibleGutterElement(Object element2) {
        return element2 instanceof MySimpleAccessible;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gutter";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accessible";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/impl/AccessibleGutterLine";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/impl/AccessibleGutterLine";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "addNewElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createAndActivate";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "installListeners";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "convertAnActionEventToMouseAnActionEvent";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addNewElement";
                break;
            }
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class MySimpleAccessibleDelegat
    implements MySimpleAccessible {
        @NotNull
        private final SimpleAccessible simpleAccessible;

        private MySimpleAccessibleDelegat(@NotNull SimpleAccessible accessible) {
            if (accessible == null) {
                MySimpleAccessibleDelegat.$$$reportNull$$$0(0);
            }
            this.simpleAccessible = accessible;
        }

        @Nls
        @NotNull
        public String getAccessibleName() {
            String string = this.simpleAccessible.getAccessibleName();
            if (string == null) {
                MySimpleAccessibleDelegat.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Nullable
        @Nls(capitalization=Nls.Capitalization.Sentence)
        public String getAccessibleTooltipText() {
            return this.simpleAccessible.getAccessibleTooltipText();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "accessible";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/editor/impl/AccessibleGutterLine$MySimpleAccessibleDelegat";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/editor/impl/AccessibleGutterLine$MySimpleAccessibleDelegat";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAccessibleName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static interface MySimpleAccessible
    extends SimpleAccessible {
        default public void performAction(@NotNull AnActionEvent e) {
            if (e == null) {
                MySimpleAccessible.$$$reportNull$$$0(0);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/editor/impl/AccessibleGutterLine$MySimpleAccessible", "performAction"));
        }
    }

    private class AccessibleGutterElement
    extends JLabel {
        @NotNull
        private final MySimpleAccessible myAccessible;

        AccessibleGutterElement(@NotNull MySimpleAccessible accessible, Rectangle bounds2) {
            if (accessible == null) {
                AccessibleGutterElement.$$$reportNull$$$0(0);
            }
            if (bounds2 == null) {
                AccessibleGutterElement.$$$reportNull$$$0(1);
            }
            this.myAccessible = accessible;
            this.setFocusable(true);
            this.setBounds(bounds2.x, bounds2.y, bounds2.width, AccessibleGutterLine.this.myGutter.getEditor().getLineHeight());
            this.setOpaque(false);
            this.setText(this.myAccessible.getAccessibleName());
            this.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent e) {
                    AccessibleGutterLine.this.mySelectedElement = AccessibleGutterElement.this;
                    AccessibleGutterElement.this.getParent().repaint();
                }

                @Override
                public void focusLost(FocusEvent e) {
                    if (!(e.getOppositeComponent() instanceof AccessibleGutterElement) && AccessibleGutterLine.this.isActive()) {
                        AccessibleGutterLine.this.escape(false);
                    }
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void paint(Graphics g) {
            if (AccessibleGutterLine.this.mySelectedElement != this) {
                return;
            }
            Color oldColor = g.getColor();
            try {
                g.setColor((Color)JBColor.blue);
                Point parentLoc = this.getParent().getLocation();
                Rectangle bounds2 = this.getBounds();
                bounds2.setLocation(parentLoc.x + bounds2.x, parentLoc.y + bounds2.y);
                int y = bounds2.y + bounds2.height - JBUIScale.scale((int)1);
                LinePainter2D.paint((Graphics2D)((Graphics2D)g), (double)bounds2.x, (double)y, (double)(bounds2.x + bounds2.width), (double)y, (LinePainter2D.StrokeType)LinePainter2D.StrokeType.INSIDE, (double)JBUIScale.scale((int)1));
            }
            finally {
                g.setColor(oldColor);
            }
        }

        public void showTooltip() {
            if (this.myAccessible.getAccessibleTooltipText() != null) {
                Rectangle bounds2 = this.getBounds();
                Rectangle pBounds = this.getParent().getBounds();
                int x = pBounds.x + bounds2.x + bounds2.width / 2;
                int y = pBounds.y + bounds2.y + bounds2.height / 2;
                AccessibleGutterLine.this.myGutter.showToolTip(this.myAccessible.getAccessibleTooltipText(), new Point(x, y), Balloon.Position.atRight);
            }
        }

        @Override
        public AccessibleContext getAccessibleContext() {
            if (this.accessibleContext == null) {
                this.accessibleContext = new JLabel.AccessibleJLabel(){

                    @Override
                    public String getAccessibleName() {
                        return AccessibleGutterElement.this.getText();
                    }
                };
            }
            return this.accessibleContext;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "accessible";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "bounds";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/editor/impl/AccessibleGutterLine$AccessibleGutterElement";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class MyShortcuts {
        static final CustomShortcutSet MOVE_RIGHT = new CustomShortcutSet(new Shortcut[]{new KeyboardShortcut(KeyStroke.getKeyStroke(39, 0), null), new KeyboardShortcut(KeyStroke.getKeyStroke(9, 0), null)});
        static final CustomShortcutSet MOVE_LEFT = new CustomShortcutSet(new Shortcut[]{new KeyboardShortcut(KeyStroke.getKeyStroke(37, 0), null), new KeyboardShortcut(KeyStroke.getKeyStroke(9, 64), null)});

        private MyShortcuts() {
        }
    }
}

