/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.ex.util;

import com.intellij.diagnostic.AttachmentFactory;
import com.intellij.diagnostic.Dumpable;
import com.intellij.ide.DataManager;
import com.intellij.ide.ui.UISettings;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.CommandEvent;
import com.intellij.openapi.command.CommandListener;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretActionListener;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.CustomFoldRegion;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorBundle;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.FoldingModel;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.ScrollingModel;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.SoftWrap;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.SelectionEvent;
import com.intellij.openapi.editor.event.SelectionListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.EditorInlayFoldingMapper;
import com.intellij.openapi.editor.impl.ComplementaryFontsRegistry;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.FontInfo;
import com.intellij.openapi.editor.impl.InlayModelImpl;
import com.intellij.openapi.editor.impl.Interval;
import com.intellij.openapi.editor.impl.ScrollingModelImpl;
import com.intellij.openapi.editor.impl.view.VisualLinesIterator;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.editor.textarea.TextComponentEditor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.impl.text.TextEditorImpl;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.ScalableIcon;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.DocumentUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.util.Arrays;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JPasswordField;
import javax.swing.JScrollBar;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class EditorUtil {
    private static final Logger LOG = Logger.getInstance(EditorUtil.class);

    private EditorUtil() {
    }

    public static boolean isRealFileEditor(@Nullable Editor editor) {
        return editor != null && TextEditorProvider.getInstance().getTextEditor(editor) instanceof TextEditorImpl;
    }

    public static boolean isPasswordEditor(@Nullable Editor editor) {
        return editor != null && editor.getContentComponent() instanceof JPasswordField;
    }

    @Nullable
    public static EditorEx getEditorEx(@Nullable FileEditor fileEditor) {
        Editor editor = fileEditor instanceof TextEditor ? ((TextEditor)fileEditor).getEditor() : null;
        return editor instanceof EditorEx ? (EditorEx)editor : null;
    }

    public static int getLastVisualLineColumnNumber(@NotNull Editor editor, int line) {
        if (editor == null) {
            EditorUtil.$$$reportNull$$$0(0);
        }
        if (editor instanceof EditorImpl) {
            EditorImpl editorImpl = (EditorImpl)editor;
            int lineEndOffset = line >= editorImpl.getVisibleLineCount() ? editor.getDocument().getTextLength() : new VisualLinesIterator(editorImpl, line).getVisualLineEndOffset();
            return editor.offsetToVisualPosition((int)lineEndOffset, (boolean)true, (boolean)true).column;
        }
        Document document = editor.getDocument();
        int lastLine = document.getLineCount() - 1;
        if (lastLine < 0) {
            return 0;
        }
        VisualPosition visStart = new VisualPosition(line, 0);
        LogicalPosition logStart = editor.visualToLogicalPosition(visStart);
        int lastLogLine = logStart.line;
        while (lastLogLine < document.getLineCount() - 1) {
            logStart = new LogicalPosition(logStart.line + 1, logStart.column);
            VisualPosition tryVisible = editor.logicalToVisualPosition(logStart);
            if (tryVisible.line != visStart.line) break;
            lastLogLine = logStart.line;
        }
        int resultLogLine = Math.min(lastLogLine, lastLine);
        VisualPosition resVisStart = editor.offsetToVisualPosition(document.getLineStartOffset(resultLogLine));
        VisualPosition resVisEnd = editor.offsetToVisualPosition(document.getLineEndOffset(resultLogLine));
        if (resVisStart.line == resVisEnd.line) {
            return resVisEnd.column;
        }
        int visualLinesToSkip = line - resVisStart.line;
        List softWraps = editor.getSoftWrapModel().getSoftWrapsForLine(resultLogLine);
        for (int i2 = 0; i2 < softWraps.size(); ++i2) {
            SoftWrap softWrap = (SoftWrap)softWraps.get(i2);
            CharSequence text2 = document.getCharsSequence();
            if (visualLinesToSkip <= 0) {
                VisualPosition visual = editor.offsetToVisualPosition(softWrap.getStart() - 1);
                int result2 = visual.column;
                int x = editor.visualPositionToXY((VisualPosition)visual).x;
                return result2 + EditorUtil.textWidthInColumns(editor, text2, softWrap.getStart() - 1, softWrap.getStart(), x);
            }
            int softWrapLineFeeds = StringUtil.countNewLines((CharSequence)softWrap.getText());
            if (softWrapLineFeeds < visualLinesToSkip) {
                visualLinesToSkip -= softWrapLineFeeds;
                continue;
            }
            if (softWrapLineFeeds == visualLinesToSkip) {
                if (i2 >= softWraps.size() - 1) {
                    return resVisEnd.column;
                }
                SoftWrap nextSoftWrap = (SoftWrap)softWraps.get(i2 + 1);
                VisualPosition visual = editor.offsetToVisualPosition(nextSoftWrap.getStart() - 1);
                int result3 = visual.column;
                int x = editor.visualPositionToXY((VisualPosition)visual).x;
                result3 += EditorUtil.textWidthInColumns(editor, text2, nextSoftWrap.getStart() - 1, nextSoftWrap.getStart(), x);
                int lineFeedIndex = StringUtil.indexOf((CharSequence)nextSoftWrap.getText(), (char)'\n');
                return result3 += EditorUtil.textWidthInColumns(editor, nextSoftWrap.getText(), 0, lineFeedIndex, 0);
            }
            int softWrapStartOffset = 0;
            int softWrapEndOffset = 0;
            int softWrapTextLength = softWrap.getText().length();
            while (visualLinesToSkip-- > 0) {
                softWrapStartOffset = softWrapEndOffset + 1;
                if (softWrapStartOffset >= softWrapTextLength) {
                    assert (false);
                    return resVisEnd.column;
                }
                softWrapEndOffset = StringUtil.indexOf((CharSequence)softWrap.getText(), (char)'\n', (int)softWrapStartOffset, (int)softWrapTextLength);
                if (softWrapEndOffset >= 0) continue;
                assert (false);
                return resVisEnd.column;
            }
            VisualPosition visual = editor.offsetToVisualPosition(softWrap.getStart() - 1);
            int result4 = visual.column;
            int x = editor.visualPositionToXY((VisualPosition)visual).x;
            result4 += EditorUtil.textWidthInColumns(editor, text2, softWrap.getStart() - 1, softWrap.getStart(), x);
            return result4 += EditorUtil.calcColumnNumber(editor, softWrap.getText(), softWrapStartOffset, softWrapEndOffset);
        }
        String editorInfo = "editor's class: " + editor.getClass() + ", all soft wraps: " + editor.getSoftWrapModel().getSoftWrapsForRange(0, document.getTextLength()) + ", fold regions: " + Arrays.toString(editor.getFoldingModel().getAllFoldRegions());
        LOG.error("Can't calculate last visual column", new Throwable(), new Attachment[]{AttachmentFactory.createContext(String.format("Target visual line: %d, mapped logical line: %d, visual lines range for the mapped logical line: [%s]-[%s], soft wraps for the target logical line: %s. Editor info: %s", line, resultLogLine, resVisStart, resVisEnd, softWraps, editorInfo), new Object[0])});
        return resVisEnd.column;
    }

    public static int getVisualLineEndOffset(@NotNull Editor editor, int line) {
        if (editor == null) {
            EditorUtil.$$$reportNull$$$0(1);
        }
        VisualPosition endLineVisualPosition = new VisualPosition(line, EditorUtil.getLastVisualLineColumnNumber(editor, line));
        return editor.visualPositionToOffset(endLineVisualPosition);
    }

    public static float calcVerticalScrollProportion(@NotNull Editor editor) {
        if (editor == null) {
            EditorUtil.$$$reportNull$$$0(2);
        }
        Rectangle viewArea = editor.getScrollingModel().getVisibleAreaOnScrollingFinished();
        if (viewArea.height == 0) {
            return 0.0f;
        }
        LogicalPosition pos = editor.getCaretModel().getLogicalPosition();
        Point location = editor.logicalPositionToXY(pos);
        return (float)(location.y - viewArea.y) / (float)viewArea.height;
    }

    public static void setVerticalScrollProportion(@NotNull Editor editor, float proportion) {
        if (editor == null) {
            EditorUtil.$$$reportNull$$$0(3);
        }
        Rectangle viewArea = editor.getScrollingModel().getVisibleArea();
        LogicalPosition caretPosition = editor.getCaretModel().getLogicalPosition();
        Point caretLocation = editor.logicalPositionToXY(caretPosition);
        int yPos = caretLocation.y;
        yPos = (int)((float)yPos - (float)viewArea.height * proportion);
        editor.getScrollingModel().scrollVertically(yPos);
    }

    public static int calcRelativeCaretPosition(@NotNull Editor editor) {
        if (editor == null) {
            EditorUtil.$$$reportNull$$$0(4);
        }
        int caretY = editor.visualLineToY(editor.getCaretModel().getVisualPosition().line);
        int viewAreaPosition = editor.getScrollingModel().getVisibleAreaOnScrollingFinished().y;
        return caretY - viewAreaPosition;
    }

    public static void setRelativeCaretPosition(@NotNull Editor editor, int position) {
        if (editor == null) {
            EditorUtil.$$$reportNull$$$0(5);
        }
        int caretY = editor.visualLineToY(editor.getCaretModel().getVisualPosition().line);
        editor.getScrollingModel().scrollVertically(caretY - position);
    }

    public static void fillVirtualSpaceUntilCaret(@NotNull Editor editor) {
        if (editor == null) {
            EditorUtil.$$$reportNull$$$0(6);
        }
        LogicalPosition position = editor.getCaretModel().getLogicalPosition();
        EditorUtil.fillVirtualSpaceUntil(editor, position.column, position.line);
    }

    public static void fillVirtualSpaceUntil(@NotNull Editor editor, int columnNumber, int lineNumber) {
        if (editor == null) {
            EditorUtil.$$$reportNull$$$0(7);
        }
        int offset = editor.logicalPositionToOffset(new LogicalPosition(lineNumber, columnNumber));
        String filler = EditorModificationUtil.calcStringToFillVirtualSpace((Editor)editor);
        if (!filler.isEmpty()) {
            WriteAction.run(() -> {
                editor.getDocument().insertString(offset, (CharSequence)filler);
                editor.getCaretModel().moveToOffset(offset + filler.length());
            });
        }
    }

    private static int getTabLength(int colNumber, int tabSize) {
        if (tabSize <= 0) {
            tabSize = 1;
        }
        return tabSize - colNumber % tabSize;
    }

    public static int calcColumnNumber(@NotNull Editor editor, @NotNull CharSequence text2, int start2, int offset) {
        if (editor == null) {
            EditorUtil.$$$reportNull$$$0(8);
        }
        if (text2 == null) {
            EditorUtil.$$$reportNull$$$0(9);
        }
        return EditorUtil.calcColumnNumber(editor, text2, start2, offset, EditorUtil.getTabSize(editor));
    }

    public static int calcColumnNumber(@Nullable Editor editor, @NotNull CharSequence text2, int start2, int offset, int tabSize) {
        int i2;
        if (text2 == null) {
            EditorUtil.$$$reportNull$$$0(10);
        }
        if (editor instanceof TextComponentEditor) {
            return offset - start2;
        }
        boolean useOptimization = true;
        if (editor != null) {
            SoftWrap softWrap = editor.getSoftWrapModel().getSoftWrap(start2);
            boolean bl = useOptimization = softWrap == null;
        }
        if (useOptimization) {
            boolean hasNonTabs = false;
            for (i2 = start2; i2 < offset; ++i2) {
                if (text2.charAt(i2) == '\t') {
                    if (!hasNonTabs) continue;
                    useOptimization = false;
                    break;
                }
                hasNonTabs = true;
            }
        }
        if (editor != null && useOptimization) {
            Document document = editor.getDocument();
            if (start2 < offset - 1 && document.getLineNumber(start2) != document.getLineNumber(offset - 1)) {
                String editorInfo = editor instanceof EditorImpl ? ". Editor info: " + ((EditorImpl)editor).dumpState() : "";
                Object documentInfo = text2 instanceof Dumpable ? ((Dumpable)text2).dumpState() : "Text holder class: " + text2.getClass();
                LOG.error("detected incorrect offset -> column number calculation", new Throwable(), new Attachment[]{AttachmentFactory.createContext("start: " + start2 + ", given offset: " + offset + ", given tab size: " + tabSize + ". " + (String)documentInfo + editorInfo, new Object[0])});
            }
        }
        int shift = 0;
        for (i2 = start2; i2 < offset; ++i2) {
            char c = text2.charAt(i2);
            if (c != '\t') continue;
            shift += EditorUtil.getTabLength(i2 + shift - start2, tabSize) - 1;
        }
        return offset - start2 + shift;
    }

    @NotNull
    public static FontInfo fontForChar(char c, @JdkConstants.FontStyle int style, @NotNull Editor editor) {
        if (editor == null) {
            EditorUtil.$$$reportNull$$$0(11);
        }
        EditorColorsScheme colorsScheme = editor.getColorsScheme();
        FontInfo fontInfo = ComplementaryFontsRegistry.getFontAbleToDisplay(c, style, colorsScheme.getFontPreferences(), FontInfo.getFontRenderContext(editor.getContentComponent()));
        if (fontInfo == null) {
            EditorUtil.$$$reportNull$$$0(12);
        }
        return fontInfo;
    }

    public static Icon scaleIconAccordingEditorFont(Icon icon2, Editor editor) {
        float scale;
        if (Registry.is((String)"editor.scale.gutter.icons") && editor instanceof EditorImpl && icon2 instanceof ScalableIcon && Math.abs(1.0f - (scale = ((EditorImpl)editor).getScale())) > 0.1f) {
            return ((ScalableIcon)icon2).scale(scale);
        }
        return icon2;
    }

    public static int charWidth(char c, @JdkConstants.FontStyle int fontType, @NotNull Editor editor) {
        if (editor == null) {
            EditorUtil.$$$reportNull$$$0(13);
        }
        return EditorUtil.fontForChar(c, fontType, editor).charWidth(c);
    }

    public static int getSpaceWidth(@JdkConstants.FontStyle int fontType, @NotNull Editor editor) {
        int width;
        if (editor == null) {
            EditorUtil.$$$reportNull$$$0(14);
        }
        return (width = EditorUtil.charWidth(' ', fontType, editor)) > 0 ? width : 1;
    }

    public static int getPlainSpaceWidth(@NotNull Editor editor) {
        if (editor == null) {
            EditorUtil.$$$reportNull$$$0(15);
        }
        return EditorUtil.getSpaceWidth(0, editor);
    }

    public static int getTabSize(@NotNull Editor editor) {
        if (editor == null) {
            EditorUtil.$$$reportNull$$$0(16);
        }
        return editor.getSettings().getTabSize(editor.getProject());
    }

    public static int nextTabStop(int x, @NotNull Editor editor) {
        int tabSize;
        if (editor == null) {
            EditorUtil.$$$reportNull$$$0(17);
        }
        if ((tabSize = EditorUtil.getTabSize(editor)) <= 0) {
            tabSize = 1;
        }
        return EditorUtil.nextTabStop(x, editor, tabSize);
    }

    public static int nextTabStop(int x, @NotNull Editor editor, int tabSize) {
        if (editor == null) {
            EditorUtil.$$$reportNull$$$0(18);
        }
        int leftInset = editor.getContentComponent().getInsets().left;
        return EditorUtil.nextTabStop(x - leftInset, EditorUtil.getSpaceWidth(0, editor), tabSize) + leftInset;
    }

    public static int nextTabStop(int x, int plainSpaceWidth, int tabSize) {
        if (tabSize <= 0) {
            return x + plainSpaceWidth;
        }
        int nTabs = x / (tabSize *= plainSpaceWidth);
        return (nTabs + 1) * tabSize;
    }

    public static float nextTabStop(float x, float plainSpaceWidth, int tabSize) {
        if (tabSize <= 0) {
            return x + plainSpaceWidth;
        }
        float tabSizePixels = (float)tabSize * plainSpaceWidth;
        int nTabs = (int)((x + plainSpaceWidth / 2.0f) / tabSizePixels);
        return (float)(nTabs + 1) * tabSizePixels;
    }

    public static int textWidthInColumns(@NotNull Editor editor, @NotNull CharSequence text2, int start2, int end, int x) {
        if (editor == null) {
            EditorUtil.$$$reportNull$$$0(19);
        }
        if (text2 == null) {
            EditorUtil.$$$reportNull$$$0(20);
        }
        int startToUse = start2;
        int lastTabSymbolIndex = -1;
        block8: for (int i2 = end - 1; i2 >= start2; --i2) {
            switch (text2.charAt(i2)) {
                case '\n': {
                    startToUse = i2 + 1;
                    break block8;
                }
                case '\t': {
                    if (lastTabSymbolIndex < 0) {
                        lastTabSymbolIndex = i2;
                    }
                }
                default: {
                    continue block8;
                }
            }
        }
        if (lastTabSymbolIndex < 0) {
            return end - startToUse;
        }
        int result2 = 0;
        int spaceSize = EditorUtil.getSpaceWidth(0, editor);
        block9: for (int i3 = startToUse; i3 <= lastTabSymbolIndex; ++i3) {
            SoftWrap softWrap = editor.getSoftWrapModel().getSoftWrap(i3);
            if (softWrap != null) {
                x = softWrap.getIndentInPixels();
            }
            char c = text2.charAt(i3);
            int prevX = x;
            switch (c) {
                case '\t': {
                    x = EditorUtil.nextTabStop(x, editor);
                    result2 += EditorUtil.columnsNumber(x - prevX, spaceSize);
                    continue block9;
                }
                case '\n': {
                    result2 = 0;
                    x = 0;
                    continue block9;
                }
                default: {
                    x += EditorUtil.charWidth(c, 0, editor);
                    ++result2;
                }
            }
        }
        return result2 += end - lastTabSymbolIndex - 1;
    }

    public static int columnsNumber(int width, int plainSpaceSize) {
        int result2 = width / plainSpaceSize;
        if (width % plainSpaceSize > 0) {
            ++result2;
        }
        return result2;
    }

    public static int columnsNumber(float width, float plainSpaceSize) {
        return (int)Math.ceil(width / plainSpaceSize);
    }

    public static int textWidth(@NotNull Editor editor, @NotNull CharSequence text2, int start2, int end, @JdkConstants.FontStyle int fontType, int x) {
        if (editor == null) {
            EditorUtil.$$$reportNull$$$0(21);
        }
        if (text2 == null) {
            EditorUtil.$$$reportNull$$$0(22);
        }
        int result2 = 0;
        for (int i2 = start2; i2 < end; ++i2) {
            char c = text2.charAt(i2);
            if (c != '\t') {
                FontInfo font = EditorUtil.fontForChar(c, fontType, editor);
                result2 += font.charWidth(c);
                continue;
            }
            result2 += EditorUtil.nextTabStop(x + result2, editor) - result2 - x;
        }
        return result2;
    }

    public static Pair<LogicalPosition, LogicalPosition> calcCaretLineRange(@NotNull Editor editor) {
        if (editor == null) {
            EditorUtil.$$$reportNull$$$0(23);
        }
        return EditorUtil.calcSurroundingRange(editor, editor.getCaretModel().getVisualPosition(), editor.getCaretModel().getVisualPosition());
    }

    public static Pair<LogicalPosition, LogicalPosition> calcCaretLineRange(@NotNull Caret caret) {
        if (caret == null) {
            EditorUtil.$$$reportNull$$$0(24);
        }
        return EditorUtil.calcSurroundingRange(caret.getEditor(), caret.getVisualPosition(), caret.getVisualPosition());
    }

    public static Pair<LogicalPosition, LogicalPosition> calcSurroundingRange(@NotNull Editor editor, @NotNull VisualPosition start2, @NotNull VisualPosition end) {
        if (editor == null) {
            EditorUtil.$$$reportNull$$$0(25);
        }
        if (start2 == null) {
            EditorUtil.$$$reportNull$$$0(26);
        }
        if (end == null) {
            EditorUtil.$$$reportNull$$$0(27);
        }
        Document document = editor.getDocument();
        FoldingModel foldingModel = editor.getFoldingModel();
        LogicalPosition first = editor.visualToLogicalPosition(new VisualPosition(start2.line, 0));
        int line = first.line;
        int offset = document.getLineStartOffset(line);
        while (offset >= 0) {
            FoldRegion foldRegion = foldingModel.getCollapsedRegionAtOffset(offset);
            if (foldRegion == null) {
                first = new LogicalPosition(line, 0);
                break;
            }
            int foldEndLine = document.getLineNumber(foldRegion.getStartOffset());
            if (foldEndLine <= line) {
                first = new LogicalPosition(line, 0);
                break;
            }
            line = foldEndLine;
            offset = document.getLineStartOffset(line);
        }
        LogicalPosition second = editor.visualToLogicalPosition(new VisualPosition(end.line, 0));
        int line2 = second.line;
        int offset2 = document.getLineEndOffset(line2);
        while (offset2 <= document.getTextLength()) {
            FoldRegion foldRegion = foldingModel.getCollapsedRegionAtOffset(offset2);
            if (foldRegion == null) {
                second = new LogicalPosition(line2 + 1, 0);
                break;
            }
            int foldEndLine = document.getLineNumber(foldRegion.getEndOffset());
            if (foldEndLine <= line2) {
                second = new LogicalPosition(line2 + 1, 0);
                break;
            }
            line2 = foldEndLine;
            offset2 = document.getLineEndOffset(line2);
        }
        if (second.line >= document.getLineCount()) {
            second = editor.offsetToLogicalPosition(document.getTextLength());
        }
        return Pair.create((Object)first, (Object)second);
    }

    public static int getNotFoldedLineStartOffset(@NotNull Editor editor, int offset) {
        if (editor == null) {
            EditorUtil.$$$reportNull$$$0(28);
        }
        return EditorUtil.getNotFoldedLineStartOffset(editor, offset, false);
    }

    public static int getNotFoldedLineStartOffset(@NotNull Editor editor, int offset, boolean stopAtInvisibleFoldRegions) {
        if (editor == null) {
            EditorUtil.$$$reportNull$$$0(29);
        }
        while (true) {
            offset = DocumentUtil.getLineStartOffset(offset, editor.getDocument());
            FoldRegion foldRegion = editor.getFoldingModel().getCollapsedRegionAtOffset(offset - 1);
            if (foldRegion == null || stopAtInvisibleFoldRegions && foldRegion.getPlaceholderText().isEmpty() || foldRegion.getStartOffset() >= offset) break;
            offset = foldRegion.getStartOffset();
        }
        return offset;
    }

    public static int getNotFoldedLineEndOffset(@NotNull Editor editor, int offset) {
        if (editor == null) {
            EditorUtil.$$$reportNull$$$0(30);
        }
        return EditorUtil.getNotFoldedLineEndOffset(editor, offset, false);
    }

    public static int getNotFoldedLineEndOffset(@NotNull Editor editor, int offset, boolean stopAtInvisibleFoldRegions) {
        if (editor == null) {
            EditorUtil.$$$reportNull$$$0(31);
        }
        while (true) {
            offset = EditorUtil.getLineEndOffset(offset, editor.getDocument());
            FoldRegion foldRegion = editor.getFoldingModel().getCollapsedRegionAtOffset(offset);
            if (foldRegion == null || stopAtInvisibleFoldRegions && foldRegion.getPlaceholderText().isEmpty() || foldRegion.getEndOffset() <= offset) break;
            offset = foldRegion.getEndOffset();
        }
        return offset;
    }

    private static int getLineEndOffset(int offset, Document document) {
        if (offset >= document.getTextLength()) {
            return offset;
        }
        int lineNumber = document.getLineNumber(offset);
        return document.getLineEndOffset(lineNumber);
    }

    public static void scrollToTheEnd(@NotNull Editor editor) {
        if (editor == null) {
            EditorUtil.$$$reportNull$$$0(32);
        }
        EditorUtil.scrollToTheEnd(editor, false);
    }

    public static void scrollToTheEnd(@NotNull Editor editor, boolean preferVerticalScroll) {
        if (editor == null) {
            EditorUtil.$$$reportNull$$$0(33);
        }
        editor.getSelectionModel().removeSelection();
        Document document = editor.getDocument();
        int lastLine = Math.max(0, document.getLineCount() - 1);
        boolean caretWasAtLastLine = editor.getCaretModel().getLogicalPosition().line == lastLine;
        editor.getCaretModel().moveToOffset(document.getTextLength());
        ScrollingModel scrollingModel = editor.getScrollingModel();
        if (preferVerticalScroll && document.getLineStartOffset(lastLine) == document.getLineEndOffset(lastLine)) {
            int scrollOffset;
            if (editor instanceof EditorEx) {
                JScrollBar verticalScrollBar = ((EditorEx)editor).getScrollPane().getVerticalScrollBar();
                scrollOffset = verticalScrollBar.getMaximum() - verticalScrollBar.getModel().getExtent();
            } else {
                scrollOffset = editor.getContentComponent().getHeight() - scrollingModel.getVisibleArea().height;
            }
            scrollingModel.scrollVertically(scrollOffset);
        } else if (!caretWasAtLastLine) {
            scrollingModel.scrollTo(new LogicalPosition(lastLine, 0), ScrollType.RELATIVE);
        } else {
            scrollingModel.scrollToCaret(ScrollType.RELATIVE);
        }
    }

    public static boolean isChangeFontSize(@NotNull MouseWheelEvent e) {
        if (e == null) {
            EditorUtil.$$$reportNull$$$0(34);
        }
        if (e.getWheelRotation() == 0) {
            return false;
        }
        return SystemInfo.isMac ? !e.isControlDown() && e.isMetaDown() && !e.isAltDown() && !e.isShiftDown() : e.isControlDown() && !e.isMetaDown() && !e.isAltDown() && !e.isShiftDown();
    }

    public static boolean isCaretInVirtualSpace(@NotNull Editor editor) {
        if (editor == null) {
            EditorUtil.$$$reportNull$$$0(35);
        }
        return EditorUtil.inVirtualSpace(editor, editor.getCaretModel().getLogicalPosition());
    }

    public static boolean inVirtualSpace(@NotNull Editor editor, @NotNull LogicalPosition logicalPosition) {
        if (editor == null) {
            EditorUtil.$$$reportNull$$$0(36);
        }
        if (logicalPosition == null) {
            EditorUtil.$$$reportNull$$$0(37);
        }
        return !editor.offsetToLogicalPosition(editor.logicalPositionToOffset(logicalPosition)).equals((Object)logicalPosition);
    }

    public static void reinitSettings() {
        EditorFactory.getInstance().refreshAllEditors();
    }

    @NotNull
    public static TextRange getSelectionInAnyMode(Editor editor) {
        SelectionModel selection = editor.getSelectionModel();
        int[] starts = selection.getBlockSelectionStarts();
        int[] ends = selection.getBlockSelectionEnds();
        int start2 = starts.length > 0 ? starts[0] : selection.getSelectionStart();
        int end = ends.length > 0 ? ends[ends.length - 1] : selection.getSelectionEnd();
        TextRange textRange = TextRange.create((int)start2, (int)end);
        if (textRange == null) {
            EditorUtil.$$$reportNull$$$0(38);
        }
        return textRange;
    }

    public static int logicalToVisualLine(@NotNull Editor editor, int logicalLine) {
        if (editor == null) {
            EditorUtil.$$$reportNull$$$0(39);
        }
        LogicalPosition logicalPosition = new LogicalPosition(logicalLine, 0);
        VisualPosition visualPosition = editor.logicalToVisualPosition(logicalPosition);
        return visualPosition.line;
    }

    @NotNull
    public static @NotNull Pair<@NotNull Interval, @Nullable Interval> logicalLineToYRange(@NotNull Editor editor, int logicalLine) {
        boolean topOverlapped;
        boolean bottomOverlapped;
        int startVisualLine;
        int endVisualLine;
        if (editor == null) {
            EditorUtil.$$$reportNull$$$0(40);
        }
        if (logicalLine < 0) {
            throw new IllegalArgumentException("Logical line is negative: " + logicalLine);
        }
        Document document = editor.getDocument();
        if (logicalLine >= document.getLineCount()) {
            startVisualLine = endVisualLine = EditorUtil.logicalToVisualLine(editor, logicalLine);
            bottomOverlapped = false;
            topOverlapped = false;
        } else {
            int lineStartOffset = document.getLineStartOffset(logicalLine);
            int lineEndOffset = document.getLineEndOffset(logicalLine);
            FoldRegion foldRegion = editor.getFoldingModel().getCollapsedRegionAtOffset(lineStartOffset);
            if (foldRegion != null) {
                Rectangle bounds2;
                if (foldRegion instanceof CustomFoldRegion) {
                    int startY = editor.visualLineToY(editor.offsetToVisualLine(foldRegion.getStartOffset(), false));
                    OurInterval interval = new OurInterval(startY, startY + ((CustomFoldRegion)foldRegion).getHeightInPixels());
                    Pair pair = Pair.create((Object)interval, foldRegion.getStartOffset() == document.getLineStartOffset(logicalLine) && foldRegion.getEndOffset() == document.getLineEndOffset(logicalLine) ? interval : null);
                    if (pair == null) {
                        EditorUtil.$$$reportNull$$$0(41);
                    }
                    return pair;
                }
                Inlay<?> inlay = EditorInlayFoldingMapper.getInstance().getAssociatedInlay(foldRegion);
                if (inlay != null && (bounds2 = inlay.getBounds()) != null) {
                    OurInterval interval = new OurInterval(bounds2.y, bounds2.y + bounds2.height);
                    Pair pair = Pair.create((Object)interval, foldRegion.getStartOffset() == lineStartOffset && foldRegion.getEndOffset() == (logicalLine + 1 < document.getLineCount() ? document.getLineStartOffset(logicalLine + 1) : document.getTextLength()) ? interval : null);
                    if (pair == null) {
                        EditorUtil.$$$reportNull$$$0(42);
                    }
                    return pair;
                }
            }
            startVisualLine = editor.offsetToVisualLine(lineStartOffset, false);
            endVisualLine = startVisualLine + editor.getSoftWrapModel().getSoftWrapsForRange(lineStartOffset + 1, lineEndOffset - 1).size();
            topOverlapped = editor.getFoldingModel().isOffsetCollapsed(lineStartOffset - 1);
            bottomOverlapped = logicalLine + 1 < document.getLineCount() && editor.getFoldingModel().isOffsetCollapsed(document.getLineStartOffset(logicalLine + 1) - 1);
        }
        int lineHeight = editor.getLineHeight();
        int startY = editor.visualLineToY(startVisualLine);
        int endY = (endVisualLine == startVisualLine ? startY : editor.visualLineToY(endVisualLine)) + lineHeight;
        int startYEx = topOverlapped ? startY + lineHeight : startY;
        int endYEx = bottomOverlapped ? endY - lineHeight : endY;
        Pair pair = Pair.create((Object)new OurInterval(startY, endY), (Object)(startYEx < endYEx ? new OurInterval(startYEx, endYEx) : null));
        if (pair == null) {
            EditorUtil.$$$reportNull$$$0(43);
        }
        return pair;
    }

    @NotNull
    public static Interval yToLogicalLineRange(@NotNull Editor editor, int y) {
        VisualLinesIterator iterator2;
        FoldRegion foldRegion;
        int yDiff;
        List inlays;
        if (editor == null) {
            EditorUtil.$$$reportNull$$$0(44);
        }
        int visualLine = editor.yToVisualLine(y);
        int[] visualLineYRange = editor.visualLineToYRange(visualLine);
        Inlay blockInlay = null;
        if (y < visualLineYRange[0]) {
            inlays = editor.getInlayModel().getBlockElementsForVisualLine(visualLine, true);
            yDiff = visualLineYRange[0] - y;
            for (int i2 = inlays.size() - 1; i2 >= 0; --i2) {
                Inlay inlay = (Inlay)inlays.get(i2);
                int height = inlay.getHeightInPixels();
                if (yDiff <= height) {
                    blockInlay = inlay;
                    break;
                }
                yDiff -= height;
            }
        } else if (y >= visualLineYRange[1]) {
            inlays = editor.getInlayModel().getBlockElementsForVisualLine(visualLine, false);
            yDiff = y - visualLineYRange[1];
            for (Inlay inlay : inlays) {
                int height = inlay.getHeightInPixels();
                if (yDiff < height) {
                    blockInlay = inlay;
                    break;
                }
                yDiff -= height;
            }
        }
        if (blockInlay != null && (foldRegion = EditorInlayFoldingMapper.getInstance().getAssociatedFoldRegion(blockInlay)) != null) {
            Document document = editor.getDocument();
            return new OurInterval(document.getLineNumber(foldRegion.getStartOffset()), document.getLineNumber(foldRegion.getEndOffset() - 1));
        }
        if (editor instanceof EditorImpl && !(iterator2 = new VisualLinesIterator((EditorImpl)editor, visualLine)).atEnd()) {
            return new OurInterval(iterator2.getStartLogicalLine(), iterator2.getEndLogicalLine());
        }
        int startLogicalLine = editor.visualToLogicalPosition((VisualPosition)new VisualPosition((int)visualLine, (int)0, (boolean)false)).line;
        int endLogicalLine = editor.visualToLogicalPosition((VisualPosition)new VisualPosition((int)visualLine, (int)Integer.MAX_VALUE, (boolean)true)).line;
        return new OurInterval(startLogicalLine, endLogicalLine);
    }

    public static int yPositionToLogicalLine(@NotNull Editor editor, @NotNull MouseEvent event) {
        if (editor == null) {
            EditorUtil.$$$reportNull$$$0(45);
        }
        if (event == null) {
            EditorUtil.$$$reportNull$$$0(46);
        }
        return EditorUtil.yPositionToLogicalLine(editor, event.getY());
    }

    public static int yPositionToLogicalLine(@NotNull Editor editor, @NotNull Point point) {
        if (editor == null) {
            EditorUtil.$$$reportNull$$$0(47);
        }
        if (point == null) {
            EditorUtil.$$$reportNull$$$0(48);
        }
        return EditorUtil.yPositionToLogicalLine(editor, point.y);
    }

    public static int yPositionToLogicalLine(@NotNull Editor editor, int y) {
        if (editor == null) {
            EditorUtil.$$$reportNull$$$0(49);
        }
        int line = editor instanceof EditorImpl ? editor.yToVisualLine(y) : y / editor.getLineHeight();
        return editor.visualToLogicalPosition((VisualPosition)new VisualPosition((int)line, (int)0)).line;
    }

    public static int yToLogicalLineNoCustomRenderers(@NotNull Editor editor, int y) {
        int visualLine;
        int visualLineStartY;
        if (editor == null) {
            EditorUtil.$$$reportNull$$$0(50);
        }
        if (y < (visualLineStartY = editor.visualLineToY(visualLine = editor.yToVisualLine(y))) || y >= visualLineStartY + editor.getLineHeight()) {
            return -1;
        }
        int line = editor.visualToLogicalPosition((VisualPosition)new VisualPosition((int)visualLine, (int)0)).line;
        Document document = editor.getDocument();
        if (line < document.getLineCount()) {
            int lineStartOffset = document.getLineStartOffset(line);
            FoldRegion foldRegion = editor.getFoldingModel().getCollapsedRegionAtOffset(lineStartOffset);
            if (foldRegion instanceof CustomFoldRegion) {
                return -1;
            }
        }
        return line;
    }

    public static boolean isAtLineEnd(@NotNull Editor editor, int offset) {
        if (editor == null) {
            EditorUtil.$$$reportNull$$$0(51);
        }
        Document document = editor.getDocument();
        if (offset < 0 || offset > document.getTextLength()) {
            return false;
        }
        int line = document.getLineNumber(offset);
        return offset == document.getLineEndOffset(line);
    }

    public static void setSelectionExpandingFoldedRegionsIfNeeded(@NotNull Editor editor, int startOffset, int endOffset) {
        FoldRegion endFoldRegion;
        FoldingModel foldingModel;
        FoldRegion startFoldRegion;
        if (editor == null) {
            EditorUtil.$$$reportNull$$$0(52);
        }
        if ((startFoldRegion = (foldingModel = editor.getFoldingModel()).getCollapsedRegionAtOffset(startOffset)) != null && (startFoldRegion.getStartOffset() == startOffset || startFoldRegion.isExpanded())) {
            startFoldRegion = null;
        }
        if ((endFoldRegion = foldingModel.getCollapsedRegionAtOffset(endOffset)) != null && (endFoldRegion.getStartOffset() == endOffset || endFoldRegion.isExpanded())) {
            endFoldRegion = null;
        }
        if (startFoldRegion != null || endFoldRegion != null) {
            FoldRegion finalStartFoldRegion = startFoldRegion;
            FoldRegion finalEndFoldRegion = endFoldRegion;
            foldingModel.runBatchFoldingOperation(() -> {
                if (finalStartFoldRegion != null) {
                    finalStartFoldRegion.setExpanded(true);
                }
                if (finalEndFoldRegion != null) {
                    finalEndFoldRegion.setExpanded(true);
                }
            });
        }
        editor.getSelectionModel().setSelection(startOffset, endOffset);
    }

    public static Font getEditorFont() {
        EditorColorsScheme scheme2 = EditorColorsManager.getInstance().getGlobalScheme();
        Font editorFont = scheme2.getFont(EditorFontType.PLAIN);
        if (UISettings.getInstance().getPresentationMode()) {
            editorFont = editorFont.deriveFont((float)UISettings.getInstance().getPresentationModeFontSize() - 4.0f);
        }
        return UIUtil.getFontWithFallback((Font)editorFont);
    }

    public static Font getEditorFont(int size) {
        EditorColorsScheme scheme2 = EditorColorsManager.getInstance().getGlobalScheme();
        Font font = scheme2.getFont(EditorFontType.PLAIN).deriveFont((float)size);
        return UIUtil.getFontWithFallback((Font)font);
    }

    public static int getDefaultCaretWidth() {
        return Registry.intValue((String)"editor.caret.width", (int)2);
    }

    public static int getSoftWrapCountAfterLineStart(@NotNull Editor editor, @NotNull LogicalPosition position) {
        if (editor == null) {
            EditorUtil.$$$reportNull$$$0(53);
        }
        if (position == null) {
            EditorUtil.$$$reportNull$$$0(54);
        }
        int startOffset = editor.getDocument().getLineStartOffset(position.line);
        int endOffset = editor.logicalPositionToOffset(position);
        return editor.getSoftWrapModel().getSoftWrapsForRange(startOffset, endOffset).size();
    }

    public static boolean attributesImpactFontStyleOrColor(@Nullable TextAttributes attributes2) {
        return attributes2 == TextAttributes.ERASE_MARKER || attributes2 != null && (attributes2.getFontType() != 0 || attributes2.getForegroundColor() != null);
    }

    public static boolean attributesImpactFontStyle(@Nullable TextAttributes attributes2) {
        return attributes2 == TextAttributes.ERASE_MARKER || attributes2 != null && attributes2.getFontType() != 0;
    }

    public static boolean attributesImpactForegroundColor(@Nullable TextAttributes attributes2) {
        return attributes2 == TextAttributes.ERASE_MARKER || attributes2 != null && attributes2.getForegroundColor() != null;
    }

    public static boolean isCurrentCaretPrimary(@NotNull Editor editor) {
        if (editor == null) {
            EditorUtil.$$$reportNull$$$0(55);
        }
        return editor.getCaretModel().getCurrentCaret() == editor.getCaretModel().getPrimaryCaret();
    }

    public static void disposeWithEditor(@NotNull Editor editor, @NotNull Disposable disposable2) {
        Editor hostEditor;
        if (editor == null) {
            EditorUtil.$$$reportNull$$$0(56);
        }
        if (disposable2 == null) {
            EditorUtil.$$$reportNull$$$0(57);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (Disposer.isDisposed((Disposable)disposable2)) {
            return;
        }
        if (editor.isDisposed()) {
            Disposer.dispose((Disposable)disposable2);
            return;
        }
        Editor editor2 = hostEditor = editor instanceof EditorWindow ? ((EditorWindow)editor).getDelegate() : editor;
        if (hostEditor instanceof EditorImpl) {
            Disposer.register((Disposable)((EditorImpl)hostEditor).getDisposable(), (Disposable)disposable2);
        } else {
            LOG.warn("Cannot watch for disposal of " + editor);
        }
    }

    public static void runBatchFoldingOperationOutsideOfBulkUpdate(final @NotNull Editor editor, final @NotNull Runnable operation2) {
        if (editor == null) {
            EditorUtil.$$$reportNull$$$0(58);
        }
        if (operation2 == null) {
            EditorUtil.$$$reportNull$$$0(59);
        }
        if (editor.getDocument().isInBulkUpdate()) {
            final Disposable disposable2 = Disposer.newDisposable();
            EditorUtil.disposeWithEditor(editor, disposable2);
            editor.getDocument().addDocumentListener(new DocumentListener(){

                public void bulkUpdateFinished(@NotNull Document document) {
                    if (document == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    editor.getFoldingModel().runBatchFoldingOperation(operation2);
                    Disposer.dispose((Disposable)disposable2);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/openapi/editor/ex/util/EditorUtil$1", "bulkUpdateFinished"));
                }
            });
        } else {
            editor.getFoldingModel().runBatchFoldingOperation(operation2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runWithAnimationDisabled(@NotNull Editor editor, @NotNull Runnable taskWithScrolling) {
        ScrollingModel scrollingModel;
        if (editor == null) {
            EditorUtil.$$$reportNull$$$0(60);
        }
        if (taskWithScrolling == null) {
            EditorUtil.$$$reportNull$$$0(61);
        }
        if (!((scrollingModel = editor.getScrollingModel()) instanceof ScrollingModelImpl)) {
            taskWithScrolling.run();
        } else {
            boolean animationWasEnabled = ((ScrollingModelImpl)scrollingModel).isAnimationEnabled();
            scrollingModel.disableAnimation();
            try {
                taskWithScrolling.run();
            }
            finally {
                if (animationWasEnabled) {
                    scrollingModel.enableAnimation();
                }
            }
        }
    }

    @NotNull
    public static String displayCharInEditor(char c, @NotNull TextAttributesKey textAttributesKey, @NotNull String fallback) {
        if (textAttributesKey == null) {
            EditorUtil.$$$reportNull$$$0(62);
        }
        if (fallback == null) {
            EditorUtil.$$$reportNull$$$0(63);
        }
        if (!Character.isValidCodePoint(c)) {
            String string = fallback;
            if (string == null) {
                EditorUtil.$$$reportNull$$$0(64);
            }
            return string;
        }
        EditorColorsScheme scheme2 = EditorColorsManager.getInstance().getGlobalScheme();
        TextAttributes textAttributes = scheme2.getAttributes(textAttributesKey);
        int style = textAttributes != null ? textAttributes.getFontType() : 0;
        FontInfo fallbackFont = ComplementaryFontsRegistry.getFontAbleToDisplay(c, style, scheme2.getFontPreferences(), null);
        String string = fallbackFont.canDisplay(c) ? String.valueOf(c) : fallback;
        if (string == null) {
            EditorUtil.$$$reportNull$$$0(65);
        }
        return string;
    }

    @NotNull
    public static VisualPosition inlayAwareOffsetToVisualPosition(@NotNull Editor editor, int offset) {
        Inlay inlay;
        if (editor == null) {
            EditorUtil.$$$reportNull$$$0(66);
        }
        LogicalPosition logicalPosition = editor.offsetToLogicalPosition(offset);
        if (editor instanceof EditorWindow) {
            logicalPosition = ((EditorWindow)editor).injectedToHost(logicalPosition);
            editor = ((EditorWindow)editor).getDelegate();
        }
        VisualPosition pos = editor.logicalToVisualPosition(logicalPosition);
        while ((inlay = editor.getInlayModel().getInlineElementAt(pos)) != null && !inlay.isRelatedToPrecedingText()) {
            pos = new VisualPosition(pos.line, pos.column + 1);
        }
        VisualPosition visualPosition = pos;
        if (visualPosition == null) {
            EditorUtil.$$$reportNull$$$0(67);
        }
        return visualPosition;
    }

    public static int getTotalInlaysHeight(@NotNull List<? extends Inlay> inlays) {
        if (inlays == null) {
            EditorUtil.$$$reportNull$$$0(68);
        }
        int sum = 0;
        for (Inlay inlay : inlays) {
            sum += inlay.getHeightInPixels();
        }
        return sum;
    }

    public static int getInlaysHeight(@NotNull Editor editor, int visualLine, boolean above) {
        if (editor == null) {
            EditorUtil.$$$reportNull$$$0(69);
        }
        return EditorUtil.getTotalInlaysHeight(editor.getInlayModel().getBlockElementsForVisualLine(visualLine, above));
    }

    public static boolean isInlayFolded(@NotNull Inlay inlay) {
        if (inlay == null) {
            EditorUtil.$$$reportNull$$$0(70);
        }
        if (InlayModelImpl.showWhenFolded(inlay)) {
            return false;
        }
        Editor editor = inlay.getEditor();
        Inlay.Placement placement = inlay.getPlacement();
        int offset = inlay.getOffset();
        if (placement == Inlay.Placement.AFTER_LINE_END) {
            offset = DocumentUtil.getLineEndOffset(offset, editor.getDocument());
        } else if (!(placement != Inlay.Placement.ABOVE_LINE && placement != Inlay.Placement.BELOW_LINE || inlay.isRelatedToPrecedingText())) {
            --offset;
        }
        FoldingModel foldingModel = editor.getFoldingModel();
        return foldingModel.isOffsetCollapsed(offset) || (placement == Inlay.Placement.INLINE || placement == Inlay.Placement.AFTER_LINE_END) && foldingModel.getCollapsedRegionAtOffset(offset - 1) instanceof CustomFoldRegion;
    }

    public static int getVisualLineAreaStartY(@NotNull Editor editor, int visualLine) {
        if (editor == null) {
            EditorUtil.$$$reportNull$$$0(71);
        }
        return editor.visualLineToY(visualLine) - EditorUtil.getInlaysHeight(editor, visualLine, true);
    }

    public static int getVisualLineAreaEndY(@NotNull Editor editor, int visualLine) {
        if (editor == null) {
            EditorUtil.$$$reportNull$$$0(72);
        }
        return editor.visualLineToYRange(visualLine)[1] + EditorUtil.getInlaysHeight(editor, visualLine, false);
    }

    public static void addBulkSelectionListener(final @NotNull Editor editor, final @NotNull SelectionListener listener2, @NotNull Disposable disposable2) {
        if (editor == null) {
            EditorUtil.$$$reportNull$$$0(73);
        }
        if (listener2 == null) {
            EditorUtil.$$$reportNull$$$0(74);
        }
        if (disposable2 == null) {
            EditorUtil.$$$reportNull$$$0(75);
        }
        final Ref selectionBeforeBulkChange = new Ref();
        final Ref selectionChangedDuringBulkChange = new Ref();
        editor.getSelectionModel().addSelectionListener(new SelectionListener(){

            public void selectionChanged(@NotNull SelectionEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (selectionBeforeBulkChange.isNull()) {
                    listener2.selectionChanged(e);
                } else {
                    selectionChangedDuringBulkChange.set((Object)Boolean.TRUE);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/editor/ex/util/EditorUtil$2", "selectionChanged"));
            }
        }, disposable2);
        editor.getCaretModel().addCaretActionListener(new CaretActionListener(){

            public void beforeAllCaretsAction() {
                selectionBeforeBulkChange.set(this.getSelectionOffsets());
                selectionChangedDuringBulkChange.set(null);
            }

            public void afterAllCaretsAction() {
                if (!selectionChangedDuringBulkChange.isNull()) {
                    Pair beforeBulk = (Pair)selectionBeforeBulkChange.get();
                    Pair<int[], int[]> afterBulk = this.getSelectionOffsets();
                    listener2.selectionChanged(new SelectionEvent(editor, (int[])beforeBulk.first, (int[])beforeBulk.second, (int[])afterBulk.first, (int[])afterBulk.second));
                }
                selectionBeforeBulkChange.set(null);
            }

            private Pair<int[], int[]> getSelectionOffsets() {
                return Pair.create((Object)editor.getSelectionModel().getBlockSelectionStarts(), (Object)editor.getSelectionModel().getBlockSelectionEnds());
            }
        }, disposable2);
    }

    public static void performBeforeCommandEnd(final @NotNull Runnable task2) {
        if (task2 == null) {
            EditorUtil.$$$reportNull$$$0(76);
        }
        if (CommandProcessor.getInstance().getCurrentCommand() == null) {
            return;
        }
        final MessageBusConnection connection = ApplicationManager.getApplication().getMessageBus().connect();
        connection.subscribe(CommandListener.TOPIC, (Object)new CommandListener(){

            public void beforeCommandFinished(@NotNull CommandEvent event) {
                if (event == null) {
                    4.$$$reportNull$$$0(0);
                }
                task2.run();
            }

            public void commandFinished(@NotNull CommandEvent event) {
                if (event == null) {
                    4.$$$reportNull$$$0(1);
                }
                connection.disconnect();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "event";
                objectArray2[1] = "com/intellij/openapi/editor/ex/util/EditorUtil$4";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "beforeCommandFinished";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "commandFinished";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    public static boolean isPrimaryCaretVisible(@NotNull Editor editor) {
        if (editor == null) {
            EditorUtil.$$$reportNull$$$0(77);
        }
        Rectangle visibleArea = editor.getScrollingModel().getVisibleArea();
        Caret caret = editor.getCaretModel().getPrimaryCaret();
        Point caretPoint = editor.visualPositionToXY(caret.getVisualPosition());
        return visibleArea.contains(caretPoint);
    }

    public static boolean isPointOverText(@NotNull Editor editor, @NotNull Point point) {
        if (editor == null) {
            EditorUtil.$$$reportNull$$$0(78);
        }
        if (point == null) {
            EditorUtil.$$$reportNull$$$0(79);
        }
        VisualPosition visualPosition = editor.xyToVisualPosition(point);
        int visualLineStartY = editor.visualLineToY(visualPosition.line);
        if (point.y < visualLineStartY || point.y >= visualLineStartY + editor.getLineHeight()) {
            return false;
        }
        if (editor.getSoftWrapModel().isInsideOrBeforeSoftWrap(visualPosition)) {
            return false;
        }
        LogicalPosition logicalPosition = editor.visualToLogicalPosition(visualPosition);
        int offset = editor.logicalPositionToOffset(logicalPosition);
        if (editor.getFoldingModel().getCollapsedRegionAtOffset(offset) instanceof CustomFoldRegion) {
            return false;
        }
        if (!logicalPosition.equals((Object)editor.offsetToLogicalPosition(offset))) {
            return false;
        }
        List inlays = editor.getInlayModel().getInlineElementsInRange(offset, offset);
        if (!inlays.isEmpty()) {
            int relX;
            VisualPosition inlaysStart = editor.offsetToVisualPosition(offset);
            if (inlaysStart.line == visualPosition.line && (relX = point.x - editor.visualPositionToXY((VisualPosition)inlaysStart).x) >= 0 && relX < inlays.stream().mapToInt(i2 -> i2.getWidthInPixels()).sum()) {
                return false;
            }
        }
        return true;
    }

    public static void notifyMaxCarets(@NotNull Editor editor) {
        if (editor == null) {
            EditorUtil.$$$reportNull$$$0(80);
        }
        Long lastTimeStamp = (Long)editor.getUserData(EditorNotification.LAST_MAX_CARETS_NOTIFY_TIMESTAMP);
        long currentTimeStamp = System.currentTimeMillis();
        if (lastTimeStamp != null && currentTimeStamp - lastTimeStamp < 10000L) {
            return;
        }
        editor.putUserData(EditorNotification.LAST_MAX_CARETS_NOTIFY_TIMESTAMP, (Object)currentTimeStamp);
        NotificationGroupManager.getInstance().getNotificationGroup("Editor notifications").createNotification(EditorBundle.message((String)"editor.max.carets.hint", (Object[])new Object[]{editor.getCaretModel().getMaxCaretCount()}), NotificationType.INFORMATION).notify(editor.getProject());
    }

    public static boolean checkMaxCarets(@NotNull Editor editor) {
        CaretModel caretModel;
        if (editor == null) {
            EditorUtil.$$$reportNull$$$0(81);
        }
        if ((caretModel = editor.getCaretModel()).getCaretCount() >= caretModel.getMaxCaretCount()) {
            EditorUtil.notifyMaxCarets(editor);
            return true;
        }
        return false;
    }

    @NotNull
    public static DataContext getEditorDataContext(@NotNull Editor editor) {
        DataContext context2;
        if (editor == null) {
            EditorUtil.$$$reportNull$$$0(82);
        }
        if (CommonDataKeys.PROJECT.getData(context2 = DataManager.getInstance().getDataContext((Component)editor.getContentComponent())) == editor.getProject()) {
            DataContext dataContext = context2;
            if (dataContext == null) {
                EditorUtil.$$$reportNull$$$0(83);
            }
            return dataContext;
        }
        DataContext dataContext = dataId -> {
            if (CommonDataKeys.PROJECT.is(dataId)) {
                return editor.getProject();
            }
            return context2.getData(dataId);
        };
        if (dataContext == null) {
            EditorUtil.$$$reportNull$$$0(84);
        }
        return dataContext;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 12: 
            case 38: 
            case 41: 
            case 42: 
            case 43: 
            case 64: 
            case 65: 
            case 67: 
            case 83: 
            case 84: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 12: 
            case 38: 
            case 41: 
            case 42: 
            case 43: 
            case 64: 
            case 65: 
            case 67: 
            case 83: 
            case 84: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 9: 
            case 10: 
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 12: 
            case 38: 
            case 41: 
            case 42: 
            case 43: 
            case 64: 
            case 65: 
            case 67: 
            case 83: 
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/ex/util/EditorUtil";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caret";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "start";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "end";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logicalPosition";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 48: 
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "point";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 57: 
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operation";
                break;
            }
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "taskWithScrolling";
                break;
            }
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textAttributesKey";
                break;
            }
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fallback";
                break;
            }
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inlays";
                break;
            }
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inlay";
                break;
            }
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/ex/util/EditorUtil";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "fontForChar";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectionInAnyMode";
                break;
            }
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "logicalLineToYRange";
                break;
            }
            case 64: 
            case 65: {
                objectArray = objectArray2;
                objectArray2[1] = "displayCharInEditor";
                break;
            }
            case 67: {
                objectArray = objectArray2;
                objectArray2[1] = "inlayAwareOffsetToVisualPosition";
                break;
            }
            case 83: 
            case 84: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditorDataContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getLastVisualLineColumnNumber";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getVisualLineEndOffset";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "calcVerticalScrollProportion";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setVerticalScrollProportion";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "calcRelativeCaretPosition";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setRelativeCaretPosition";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "fillVirtualSpaceUntilCaret";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "fillVirtualSpaceUntil";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "calcColumnNumber";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "fontForChar";
                break;
            }
            case 12: 
            case 38: 
            case 41: 
            case 42: 
            case 43: 
            case 64: 
            case 65: 
            case 67: 
            case 83: 
            case 84: {
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "charWidth";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getSpaceWidth";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getPlainSpaceWidth";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getTabSize";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "nextTabStop";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "textWidthInColumns";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "textWidth";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "calcCaretLineRange";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "calcSurroundingRange";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getNotFoldedLineStartOffset";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getNotFoldedLineEndOffset";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "scrollToTheEnd";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "isChangeFontSize";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "isCaretInVirtualSpace";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "inVirtualSpace";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "logicalToVisualLine";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "logicalLineToYRange";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "yToLogicalLineRange";
                break;
            }
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "yPositionToLogicalLine";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "yToLogicalLineNoCustomRenderers";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "isAtLineEnd";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "setSelectionExpandingFoldedRegionsIfNeeded";
                break;
            }
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "getSoftWrapCountAfterLineStart";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "isCurrentCaretPrimary";
                break;
            }
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "disposeWithEditor";
                break;
            }
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "runBatchFoldingOperationOutsideOfBulkUpdate";
                break;
            }
            case 60: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "runWithAnimationDisabled";
                break;
            }
            case 62: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "displayCharInEditor";
                break;
            }
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "inlayAwareOffsetToVisualPosition";
                break;
            }
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "getTotalInlaysHeight";
                break;
            }
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "getInlaysHeight";
                break;
            }
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "isInlayFolded";
                break;
            }
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "getVisualLineAreaStartY";
                break;
            }
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "getVisualLineAreaEndY";
                break;
            }
            case 73: 
            case 74: 
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "addBulkSelectionListener";
                break;
            }
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "performBeforeCommandEnd";
                break;
            }
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "isPrimaryCaretVisible";
                break;
            }
            case 78: 
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "isPointOverText";
                break;
            }
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "notifyMaxCarets";
                break;
            }
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "checkMaxCarets";
                break;
            }
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "getEditorDataContext";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 12: 
            case 38: 
            case 41: 
            case 42: 
            case 43: 
            case 64: 
            case 65: 
            case 67: 
            case 83: 
            case 84: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class OurInterval
    implements Interval {
        private final int intervalStart;
        private final int intervalEnd;

        private OurInterval(int intervalStart, int intervalEnd) {
            this.intervalStart = intervalStart;
            this.intervalEnd = intervalEnd;
        }

        @Override
        public int intervalStart() {
            return this.intervalStart;
        }

        @Override
        public int intervalEnd() {
            return this.intervalEnd;
        }
    }

    private static class EditorNotification {
        private static final Key<Long> LAST_MAX_CARETS_NOTIFY_TIMESTAMP = Key.create((String)"last.max.carets.notify.timestamp");
        private static final long MAX_CARETS_NOTIFY_INTERVAL_MS = 10000L;

        private EditorNotification() {
        }
    }
}

