/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.colors.impl;

import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.EditorFontCache;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.editor.colors.FontPreferences;
import com.intellij.openapi.editor.colors.impl.AppEditorFontOptions;
import com.intellij.openapi.editor.impl.FontFamilyService;
import com.intellij.util.ObjectUtils;
import java.awt.Font;
import java.awt.font.TextAttribute;
import java.util.EnumMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditorFontCacheImpl
extends EditorFontCache {
    private static final Map<TextAttribute, Integer> LIGATURES_ATTRIBUTES = Map.of(TextAttribute.LIGATURES, TextAttribute.LIGATURES_ON);
    @NotNull
    private final Map<EditorFontType, Font> myFonts = new EnumMap<EditorFontType, Font>(EditorFontType.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public Font getFont(@Nullable EditorFontType key) {
        Map<EditorFontType, Font> map2 = this.myFonts;
        // MONITORENTER : map2
        if (this.myFonts.isEmpty()) {
            this.initFonts();
        }
        EditorFontType fontType = (EditorFontType)ObjectUtils.notNull((Object)key, (Object)EditorFontType.PLAIN);
        Font font = this.myFonts.get(fontType);
        assert (font != null) : "Font " + fontType + " not found.";
        UISettings uiSettings = UISettings.getInstance();
        if (uiSettings.getPresentationMode()) {
            Font font2 = font.deriveFont((float)uiSettings.getPresentationModeFontSize());
            // MONITOREXIT : map2
            if (font2 != null) return font2;
            EditorFontCacheImpl.$$$reportNull$$$0(0);
            return font2;
        }
        Font font3 = font;
        // MONITOREXIT : map2
        if (font3 != null) return font3;
        EditorFontCacheImpl.$$$reportNull$$$0(1);
        return font3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        Map<EditorFontType, Font> map2 = this.myFonts;
        synchronized (map2) {
            this.myFonts.clear();
        }
    }

    protected EditorColorsScheme getFontCacheScheme() {
        return EditorColorsManager.getInstance().getGlobalScheme();
    }

    private void initFonts() {
        int editorFontSize;
        EditorColorsScheme scheme2 = this.getFontCacheScheme();
        FontPreferences preferences = scheme2.getFontPreferences();
        String editorFontName = preferences.getFontFamily();
        String fallbackName = EditorFontCacheImpl.getFallbackName(editorFontName, editorFontSize = scheme2.getEditorFontSize());
        if (fallbackName != null) {
            editorFontName = fallbackName;
        }
        this.setFont(EditorFontType.PLAIN, editorFontName, 0, editorFontSize, preferences);
        this.setFont(EditorFontType.BOLD, editorFontName, 1, editorFontSize, preferences);
        this.setFont(EditorFontType.ITALIC, editorFontName, 2, editorFontSize, preferences);
        this.setFont(EditorFontType.BOLD_ITALIC, editorFontName, 3, editorFontSize, preferences);
        FontPreferences consolePreferences = scheme2.getConsoleFontPreferences();
        String consoleFontName = scheme2.getConsoleFontName();
        int consoleFontSize = scheme2.getConsoleFontSize();
        this.setFont(EditorFontType.CONSOLE_PLAIN, consoleFontName, 0, consoleFontSize, consolePreferences);
        this.setFont(EditorFontType.CONSOLE_BOLD, consoleFontName, 1, consoleFontSize, consolePreferences);
        this.setFont(EditorFontType.CONSOLE_ITALIC, consoleFontName, 2, consoleFontSize, consolePreferences);
        this.setFont(EditorFontType.CONSOLE_BOLD_ITALIC, consoleFontName, 3, consoleFontSize, consolePreferences);
    }

    private void setFont(EditorFontType fontType, String familyName, int style, int fontSize, FontPreferences fontPreferences) {
        Font baseFont = FontFamilyService.getFont(familyName, fontPreferences.getRegularSubFamily(), fontPreferences.getBoldSubFamily(), style, fontSize);
        this.myFonts.put(fontType, EditorFontCacheImpl.deriveFontWithLigatures(baseFont, fontPreferences.useLigatures()));
    }

    @Nullable
    private static String getFallbackName(@NotNull String fontName, int fontSize) {
        Font plainFont;
        if (fontName == null) {
            EditorFontCacheImpl.$$$reportNull$$$0(2);
        }
        if ((plainFont = new Font(fontName, 0, fontSize)).getFamily().equals("Dialog") && !"Dialog".equals(fontName) && !fontName.startsWith("Dialog.")) {
            FontPreferences appPrefs = AppEditorFontOptions.getInstance().getFontPreferences();
            return appPrefs.getFontFamily();
        }
        return null;
    }

    @NotNull
    public static Font deriveFontWithLigatures(@NotNull Font font, boolean enableLigatures) {
        if (font == null) {
            EditorFontCacheImpl.$$$reportNull$$$0(3);
        }
        Font font2 = enableLigatures ? font.deriveFont(LIGATURES_ATTRIBUTES) : font;
        if (font2 == null) {
            EditorFontCacheImpl.$$$reportNull$$$0(4);
        }
        return font2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/colors/impl/EditorFontCacheImpl";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fontName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "font";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFont";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/colors/impl/EditorFontCacheImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "deriveFontWithLigatures";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getFallbackName";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "deriveFontWithLigatures";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

