/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.ide.IdeBundle;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class RemoveBomAction
extends AnAction
implements DumbAware {
    private static final Logger LOG = Logger.getInstance(RemoveBomAction.class);

    public RemoveBomAction() {
        super(IdeBundle.messagePointer((String)"remove.BOM", (Object[])new Object[0]));
    }

    public void update(@NotNull AnActionEvent e) {
        VirtualFile[] files2;
        String fromWhere;
        if (e == null) {
            RemoveBomAction.$$$reportNull$$$0(0);
        }
        boolean enabled = (fromWhere = RemoveBomAction.computeFromWhere(files2 = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY))) != null;
        e.getPresentation().setEnabled(enabled);
        e.getPresentation().setVisible(enabled || ActionPlaces.isMainMenuOrActionSearch((String)e.getPlace()));
        e.getPresentation().setDescription(IdeBundle.messagePointer((String)"remove.byte.order.mark.from", (Object[])new Object[]{fromWhere}));
    }

    private static String computeFromWhere(VirtualFile[] files2) {
        if (files2 == null || files2.length == 0) {
            return null;
        }
        String fromWhere = null;
        for (VirtualFile file2 : files2) {
            if (file2.isDirectory()) {
                fromWhere = "all files in '" + file2.getName() + "' directory (recursively)" + (files2.length == 1 ? "" : " and others");
                break;
            }
            if (file2.getBOM() == null) continue;
            fromWhere = file2.getName() + (files2.length == 1 ? "" : " and others");
            break;
        }
        return fromWhere;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        VirtualFile[] files2;
        if (e == null) {
            RemoveBomAction.$$$reportNull$$$0(1);
        }
        if ((files2 = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY)) == null) {
            return;
        }
        final List<VirtualFile> filesToProcess = RemoveBomAction.getFilesWithBom(files2);
        if (filesToProcess.isEmpty()) {
            return;
        }
        final ArrayList filesUnableToProcess = new ArrayList();
        new Task.Backgroundable(RemoveBomAction.getEventProject((AnActionEvent)e), IdeBundle.message((String)"removing.BOM", (Object[])new Object[0]), true, PerformInBackgroundOption.DEAF){

            public void run(@NotNull ProgressIndicator indicator2) {
                if (indicator2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                indicator2.setIndeterminate(false);
                for (int i2 = 0; i2 < filesToProcess.size(); ++i2) {
                    ProgressManager.checkCanceled();
                    VirtualFile virtualFile2 = (VirtualFile)filesToProcess.get(i2);
                    indicator2.setFraction((double)i2 * 1.0 / (double)filesToProcess.size());
                    indicator2.setText2(StringUtil.shortenPathWithEllipsis((String)virtualFile2.getPresentableUrl(), (int)40));
                    byte[] bom = virtualFile2.getBOM();
                    if (bom == null) continue;
                    if (RemoveBomAction.isBOMMandatory(virtualFile2)) {
                        filesUnableToProcess.add(virtualFile2);
                        continue;
                    }
                    RemoveBomAction.doRemoveBOM(virtualFile2, bom);
                }
                if (!filesUnableToProcess.isEmpty()) {
                    String title2 = IdeBundle.message((String)"notification.title.was.unable.to.remove.bom.in", (Object[])new Object[]{filesUnableToProcess.size()});
                    String msg = IdeBundle.message((String)"notification.content.mandatory.bom.br", (Object[])new Object[]{filesUnableToProcess.size(), StringUtil.join((Collection)filesUnableToProcess, VirtualFile::getName, (String)"<br/>    ")});
                    Notifications.Bus.notify((Notification)new Notification(NotificationGroup.createIdWithTitle((String)"Failed to remove BOM", (String)IdeBundle.message((String)"notification.group.failed.to.remove.bom", (Object[])new Object[0])), title2, msg, NotificationType.ERROR));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/editor/actions/RemoveBomAction$1", "run"));
            }
        }.queue();
    }

    private static boolean isBOMMandatory(@NotNull VirtualFile file2) {
        if (file2 == null) {
            RemoveBomAction.$$$reportNull$$$0(2);
        }
        return CharsetToolkit.getMandatoryBom((Charset)file2.getCharset()) != null;
    }

    private static void doRemoveBOM(@NotNull VirtualFile virtualFile2, byte @NotNull [] bom) {
        if (virtualFile2 == null) {
            RemoveBomAction.$$$reportNull$$$0(3);
        }
        if (bom == null) {
            RemoveBomAction.$$$reportNull$$$0(4);
        }
        virtualFile2.setBOM(null);
        try {
            byte[] bytes = virtualFile2.contentsToByteArray();
            byte[] contentWithStrippedBom = Arrays.copyOfRange(bytes, bom.length, bytes.length);
            WriteAction.runAndWait(() -> virtualFile2.setBinaryContent(contentWithStrippedBom));
        }
        catch (IOException ex) {
            LOG.warn("Unexpected exception occurred on attempt to remove BOM from file " + virtualFile2, (Throwable)ex);
        }
    }

    @NotNull
    private static List<VirtualFile> getFilesWithBom(VirtualFile @NotNull [] roots) {
        if (roots == null) {
            RemoveBomAction.$$$reportNull$$$0(5);
        }
        final ArrayList<VirtualFile> result2 = new ArrayList<VirtualFile>();
        for (VirtualFile root : roots) {
            VfsUtilCore.visitChildrenRecursively((VirtualFile)root, (VirtualFileVisitor)new VirtualFileVisitor<Void>(new VirtualFileVisitor.Option[0]){

                public boolean visitFile(@NotNull VirtualFile file2) {
                    if (file2 == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if (!file2.isDirectory() && file2.getBOM() != null) {
                        result2.add(file2);
                    }
                    return true;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/editor/actions/RemoveBomAction$2", "visitFile"));
                }
            });
        }
        ArrayList<VirtualFile> arrayList = result2;
        if (arrayList == null) {
            RemoveBomAction.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bom";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/actions/RemoveBomAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/actions/RemoveBomAction";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilesWithBom";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isBOMMandatory";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "doRemoveBOM";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getFilesWithBom";
                break;
            }
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

