/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerImpl;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.tooltips.TooltipActionProvider;
import com.intellij.codeInsight.documentation.DocumentationComponent;
import com.intellij.codeInsight.documentation.DocumentationManager;
import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.codeInsight.hint.LineTooltipRenderer;
import com.intellij.codeInsight.hint.TooltipGroup;
import com.intellij.codeInsight.hint.TooltipRenderer;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.ide.IdeEventQueue;
import com.intellij.injected.editor.DocumentWindow;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.documentation.DocumentationProvider;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.ex.AnActionListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ModalityStateListener;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.EditorEventMulticaster;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseEventArea;
import com.intellij.openapi.editor.event.EditorMouseListener;
import com.intellij.openapi.editor.event.EditorMouseMotionListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.EditorMarkupModel;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.editor.ex.ErrorStripTooltipRendererProvider;
import com.intellij.openapi.editor.ex.TooltipAction;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.EditorMouseHoverPopupControl;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.ui.popup.util.PopupUtil;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPlainText;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.reference.SoftReference;
import com.intellij.ui.HintHint;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.LightweightHint;
import com.intellij.ui.MouseMovementTracker;
import com.intellij.ui.WidthBasedLayout;
import com.intellij.ui.popup.AbstractPopup;
import com.intellij.ui.popup.PopupFactoryImpl;
import com.intellij.util.Alarm;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.MenuSelectionManager;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.CancellablePromise;

public class EditorMouseHoverPopupManager
implements Disposable {
    private static final Logger LOG = Logger.getInstance(EditorMouseHoverPopupManager.class);
    private static final Key<Boolean> DISABLE_BINDING = Key.create((String)"EditorMouseHoverPopupManager.disable.binding");
    private static final TooltipGroup EDITOR_INFO_GROUP = new TooltipGroup("EDITOR_INFO_GROUP", 0);
    private static final int MAX_POPUP_WIDTH = 650;
    public static final int MAX_QUICK_DOC_CHARACTERS = 100000;
    protected final Alarm myAlarm;
    private final MouseMovementTracker myMouseMovementTracker = new MouseMovementTracker();
    private boolean myKeepPopupOnMouseMove;
    protected Reference<Editor> myCurrentEditor;
    protected Reference<AbstractPopup> myPopupReference;
    protected Context myContext;
    protected ProgressIndicator myCurrentProgress;
    private CancellablePromise<Context> myPreparationTask;
    private boolean mySkipNextMovement;

    public EditorMouseHoverPopupManager() {
        this.myAlarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)this);
        EditorEventMulticaster multicaster = EditorFactory.getInstance().getEventMulticaster();
        multicaster.addCaretListener(new CaretListener(){

            public void caretPositionChanged(@NotNull CaretEvent event) {
                Editor editor;
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((editor = event.getEditor()) == SoftReference.dereference(EditorMouseHoverPopupManager.this.myCurrentEditor)) {
                    DocumentationManager.getInstance(Objects.requireNonNull(editor.getProject())).setAllowContentUpdateFromContext(true);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/editor/EditorMouseHoverPopupManager$1", "caretPositionChanged"));
            }
        }, (Disposable)this);
        multicaster.addVisibleAreaListener(e -> {
            Rectangle oldRectangle = e.getOldRectangle();
            if (e.getEditor() == SoftReference.dereference(this.myCurrentEditor) && oldRectangle != null && !oldRectangle.getLocation().equals(e.getNewRectangle().getLocation())) {
                this.cancelProcessingAndCloseHint();
            }
        }, (Disposable)this);
        EditorMouseHoverPopupControl.getInstance().addListener(() -> {
            Editor editor = (Editor)SoftReference.dereference(this.myCurrentEditor);
            if (editor != null && EditorMouseHoverPopupControl.arePopupsDisabled(editor)) {
                this.closeHint();
            }
        });
        LaterInvocator.addModalityStateListener(new ModalityStateListener(){

            public void beforeModalityStateChanged(boolean entering, @NotNull Object modalEntity) {
                if (modalEntity == null) {
                    2.$$$reportNull$$$0(0);
                }
                EditorMouseHoverPopupManager.this.cancelProcessingAndCloseHint();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modalEntity", "com/intellij/openapi/editor/EditorMouseHoverPopupManager$2", "beforeModalityStateChanged"));
            }
        }, this);
        IdeEventQueue.getInstance().addDispatcher(event -> {
            if (event.getID() == 401) {
                this.cancelCurrentProcessing();
            }
            return false;
        }, this);
        ApplicationManager.getApplication().getMessageBus().connect((Disposable)this).subscribe(AnActionListener.TOPIC, (Object)new MyActionListener());
    }

    public void dispose() {
    }

    protected void handleMouseMoved(@NotNull EditorMouseEvent e) {
        if (e == null) {
            EditorMouseHoverPopupManager.$$$reportNull$$$0(0);
        }
        long startTimestamp = System.currentTimeMillis();
        this.cancelCurrentProcessing();
        if (this.ignoreEvent(e)) {
            return;
        }
        Editor editor = e.getEditor();
        if (EditorMouseHoverPopupManager.isPopupDisabled(editor)) {
            this.closeHint();
            return;
        }
        int targetOffset = EditorMouseHoverPopupManager.getTargetOffset(e);
        if (targetOffset < 0) {
            this.closeHint();
            return;
        }
        this.myPreparationTask = ReadAction.nonBlocking(() -> this.createContext(editor, targetOffset, startTimestamp)).coalesceBy(new Object[]{this}).withDocumentsCommitted(Objects.requireNonNull(editor.getProject())).expireWhen(() -> editor.isDisposed()).finishOnUiThread(ModalityState.any(), context2 -> {
            Context.Relation relation;
            this.myPreparationTask = null;
            if (context2 == null || !editor.getContentComponent().isShowing()) {
                this.closeHint();
                return;
            }
            Context.Relation relation2 = relation = this.isHintShown() ? context2.compareTo(this.myContext) : Context.Relation.DIFFERENT;
            if (relation == Context.Relation.SAME) {
                return;
            }
            if (relation == Context.Relation.DIFFERENT) {
                this.closeHint();
            }
            this.scheduleProcessing(editor, (Context)context2, relation == Context.Relation.SIMILAR, false, false);
        }).submit((Executor)AppExecutorUtil.getAppExecutorService());
    }

    protected void cancelCurrentProcessing() {
        if (this.myPreparationTask != null) {
            this.myPreparationTask.cancel();
            this.myPreparationTask = null;
        }
        this.myAlarm.cancelAllRequests();
        if (this.myCurrentProgress != null) {
            this.myCurrentProgress.cancel();
            this.myCurrentProgress = null;
        }
    }

    protected void skipNextMovement() {
        this.mySkipNextMovement = true;
    }

    protected void scheduleProcessing(@NotNull Editor editor, @NotNull Context context2, boolean updateExistingPopup, boolean forceShowing, boolean requestFocus) {
        if (editor == null) {
            EditorMouseHoverPopupManager.$$$reportNull$$$0(1);
        }
        if (context2 == null) {
            EditorMouseHoverPopupManager.$$$reportNull$$$0(2);
        }
        ProgressIndicatorBase progress2 = new ProgressIndicatorBase();
        this.myCurrentProgress = progress2;
        this.myAlarm.addRequest(() -> ProgressManager.getInstance().executeProcessUnderProgress(() -> {
            Editor topLevelEditor = InjectedLanguageUtil.getTopLevelEditor(editor);
            Info info2 = context2.calcInfo(topLevelEditor);
            ApplicationManager.getApplication().invokeLater(() -> {
                if (progress2 != this.myCurrentProgress) {
                    return;
                }
                this.myCurrentProgress = null;
                if (info2 == null || !topLevelEditor.getContentComponent().isShowing() || !forceShowing && EditorMouseHoverPopupManager.isPopupDisabled(topLevelEditor)) {
                    return;
                }
                PopupBridge popupBridge = new PopupBridge();
                JComponent component2 = info2.createComponent(topLevelEditor, popupBridge, requestFocus);
                if (component2 == null) {
                    this.closeHint();
                } else {
                    if (updateExistingPopup && this.isHintShown()) {
                        this.updateHint(component2, popupBridge);
                    } else {
                        AbstractPopup hint = EditorMouseHoverPopupManager.createHint(component2, popupBridge, requestFocus);
                        this.showHintInEditor(hint, topLevelEditor, context2);
                        this.myPopupReference = new WeakReference<AbstractPopup>(hint);
                        this.myCurrentEditor = new WeakReference<Editor>(topLevelEditor);
                    }
                    this.myContext = context2;
                }
            });
        }, (ProgressIndicator)progress2), context2.getShowingDelay());
    }

    private boolean ignoreEvent(EditorMouseEvent e) {
        if (this.mySkipNextMovement) {
            this.mySkipNextMovement = false;
            return true;
        }
        Rectangle currentHintBounds = this.getCurrentHintBounds(e.getEditor());
        return this.myMouseMovementTracker.isMovingTowards(e.getMouseEvent(), currentHintBounds) || currentHintBounds != null && this.myKeepPopupOnMouseMove;
    }

    protected static boolean isPopupDisabled(Editor editor) {
        return EditorMouseHoverPopupManager.isAnotherAppInFocus() || EditorMouseHoverPopupControl.arePopupsDisabled(editor) || LookupManager.getActiveLookup(editor) != null || EditorMouseHoverPopupManager.isAnotherPopupFocused() || EditorMouseHoverPopupManager.isContextMenuShown();
    }

    private static boolean isAnotherAppInFocus() {
        return KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusedWindow() == null;
    }

    private static boolean isAnotherPopupFocused() {
        JBPopup popup2 = PopupUtil.getPopupContainerFor((Component)KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner());
        return popup2 != null && !popup2.isDisposed();
    }

    private static boolean isContextMenuShown() {
        return MenuSelectionManager.defaultManager().getSelectedPath().length > 0;
    }

    private Rectangle getCurrentHintBounds(Editor editor) {
        AbstractPopup popup2 = this.getCurrentHint();
        if (popup2 == null) {
            return null;
        }
        Dimension size = popup2.getSize();
        if (size == null) {
            return null;
        }
        Rectangle result2 = new Rectangle(popup2.getLocationOnScreen(), size);
        int borderTolerance = editor.getLineHeight() / 3;
        result2.grow(borderTolerance, borderTolerance);
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void showHintInEditor(AbstractPopup hint, Editor editor, Context context2) {
        this.closeHint();
        this.myMouseMovementTracker.reset();
        this.myKeepPopupOnMouseMove = false;
        editor.putUserData(PopupFactoryImpl.ANCHOR_POPUP_POSITION, (Object)context2.getPopupPosition(editor));
        try {
            hint.showInBestPositionFor(editor);
        }
        finally {
            editor.putUserData(PopupFactoryImpl.ANCHOR_POPUP_POSITION, null);
        }
        Window window = hint.getPopupWindow();
        if (window != null) {
            window.setFocusableWindowState(true);
            IdeEventQueue.getInstance().addDispatcher(e -> {
                if (e.getID() == 501 && e.getSource() == window) {
                    this.myKeepPopupOnMouseMove = true;
                } else if (e.getID() == 200 && !EditorMouseHoverPopupManager.isParentWindow(window, e.getSource())) {
                    this.closeHint();
                }
                return false;
            }, hint);
        }
    }

    private static boolean isParentWindow(@NotNull Window parent, Object potentialChild) {
        if (parent == null) {
            EditorMouseHoverPopupManager.$$$reportNull$$$0(3);
        }
        return parent == potentialChild || potentialChild instanceof Component && EditorMouseHoverPopupManager.isParentWindow(parent, ((Component)potentialChild).getParent());
    }

    protected static AbstractPopup createHint(JComponent component2, PopupBridge popupBridge, boolean requestFocus) {
        WrapperPanel wrapper2 = new WrapperPanel(component2);
        AbstractPopup popup2 = (AbstractPopup)JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)wrapper2, component2).setResizable(true).setFocusable(requestFocus).setRequestFocus(requestFocus).createPopup();
        popupBridge.setPopup(popup2);
        return popup2;
    }

    protected void updateHint(JComponent component2, PopupBridge popupBridge) {
        AbstractPopup popup2 = this.getCurrentHint();
        if (popup2 != null) {
            WrapperPanel wrapper2 = (WrapperPanel)popup2.getComponent();
            wrapper2.setContent(component2);
            EditorMouseHoverPopupManager.validatePopupSize(popup2);
            popupBridge.setPopup(popup2);
        }
    }

    private static void validatePopupSize(@NotNull AbstractPopup popup2) {
        JComponent component2;
        if (popup2 == null) {
            EditorMouseHoverPopupManager.$$$reportNull$$$0(4);
        }
        if ((component2 = popup2.getComponent()) != null) {
            popup2.setSize(component2.getPreferredSize());
        }
    }

    private static int getTargetOffset(EditorMouseEvent event) {
        Editor editor = event.getEditor();
        if (editor instanceof EditorEx && editor.getProject() != null && event.getArea() == EditorMouseEventArea.EDITING_AREA && event.getMouseEvent().getModifiers() == 0 && event.isOverText() && event.getCollapsedFoldRegion() == null) {
            return event.getOffset();
        }
        return -1;
    }

    protected Context createContext(Editor editor, int offset, long startTimestamp) {
        Project project = Objects.requireNonNull(editor.getProject());
        HighlightInfo info2 = null;
        if (!Registry.is((String)"ide.disable.editor.tooltips")) {
            DaemonCodeAnalyzerImpl daemonCodeAnalyzer = (DaemonCodeAnalyzerImpl)DaemonCodeAnalyzer.getInstance((Project)project);
            boolean highestPriorityOnly = !Registry.is((String)"ide.tooltip.showAllSeverities");
            info2 = daemonCodeAnalyzer.findHighlightsByOffset(editor.getDocument(), offset, false, highestPriorityOnly, HighlightSeverity.INFORMATION);
        }
        PsiElement elementForQuickDoc = this.findElementForQuickDoc(editor, offset, project);
        return info2 == null && elementForQuickDoc == null ? null : new Context(startTimestamp, offset, info2, elementForQuickDoc);
    }

    @Nullable
    protected PsiElement findElementForQuickDoc(Editor editor, int offset, Project project) {
        PsiFile psiFile;
        PsiElement result2 = null;
        if (EditorSettingsExternalizable.getInstance().isShowQuickDocOnMouseOverElement() && (psiFile = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument())) != null) {
            result2 = InjectedLanguageManager.getInstance((Project)project).findInjectedElementAt(psiFile, offset);
            if (result2 == null) {
                result2 = psiFile.findElementAt(offset);
            }
            if (result2 instanceof PsiWhiteSpace || result2 instanceof PsiPlainText) {
                result2 = null;
            }
        }
        return result2;
    }

    protected void cancelProcessingAndCloseHint() {
        this.cancelCurrentProcessing();
        this.closeHint();
    }

    protected void closeHint() {
        AbstractPopup hint = this.getCurrentHint();
        if (hint != null) {
            hint.cancel();
        }
        this.myPopupReference = null;
        this.myCurrentEditor = null;
        this.myContext = null;
    }

    protected boolean isHintShown() {
        return this.getCurrentHint() != null;
    }

    protected AbstractPopup getCurrentHint() {
        if (this.myPopupReference == null) {
            return null;
        }
        AbstractPopup hint = this.myPopupReference.get();
        if (hint == null || !hint.isVisible()) {
            if (hint != null) {
                hint.cancel();
            }
            this.myPopupReference = null;
            this.myCurrentEditor = null;
            this.myContext = null;
            return null;
        }
        return hint;
    }

    public void showInfoTooltip(@NotNull Editor editor, @NotNull HighlightInfo info2, int offset, boolean requestFocus, final boolean showImmediately) {
        if (editor == null) {
            EditorMouseHoverPopupManager.$$$reportNull$$$0(5);
        }
        if (info2 == null) {
            EditorMouseHoverPopupManager.$$$reportNull$$$0(6);
        }
        if (editor.getProject() == null) {
            return;
        }
        this.cancelProcessingAndCloseHint();
        Context context2 = new Context(System.currentTimeMillis(), offset, info2, null){

            @Override
            public long getShowingDelay() {
                return showImmediately ? 0L : super.getShowingDelay();
            }
        };
        this.scheduleProcessing(editor, context2, false, true, requestFocus);
    }

    private static PsiElement extractOriginalElement(PsiElement element2) {
        if (element2 == null) {
            return null;
        }
        SmartPsiElementPointer originalElementPointer = (SmartPsiElementPointer)element2.getUserData(DocumentationManager.ORIGINAL_ELEMENT_KEY);
        return originalElementPointer == null ? null : originalElementPointer.getElement();
    }

    @NotNull
    public static EditorMouseHoverPopupManager getInstance() {
        EditorMouseHoverPopupManager editorMouseHoverPopupManager = (EditorMouseHoverPopupManager)ApplicationManager.getApplication().getService(EditorMouseHoverPopupManager.class);
        if (editorMouseHoverPopupManager == null) {
            EditorMouseHoverPopupManager.$$$reportNull$$$0(7);
        }
        return editorMouseHoverPopupManager;
    }

    @Nullable
    public DocumentationComponent getDocumentationComponent() {
        AbstractPopup hint = this.getCurrentHint();
        return hint == null ? null : (DocumentationComponent)UIUtil.findComponentOfType((JComponent)hint.getComponent(), DocumentationComponent.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "popup";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/EditorMouseHoverPopupManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/EditorMouseHoverPopupManager";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "handleMouseMoved";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "scheduleProcessing";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isParentWindow";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "validatePopupSize";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "showInfoTooltip";
                break;
            }
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyActionListener
    implements AnActionListener {
        private MyActionListener() {
        }

        public void beforeActionPerformed(@NotNull AnAction action2, @NotNull AnActionEvent event) {
            Component contextComponent;
            JBPopup contextPopup;
            if (action2 == null) {
                MyActionListener.$$$reportNull$$$0(0);
            }
            if (event == null) {
                MyActionListener.$$$reportNull$$$0(1);
            }
            if (action2 instanceof HintManagerImpl.ActionToIgnore) {
                return;
            }
            AbstractPopup currentHint = EditorMouseHoverPopupManager.getInstance().getCurrentHint();
            if (currentHint != null && (contextPopup = PopupUtil.getPopupContainerFor((Component)(contextComponent = (Component)event.getData(PlatformDataKeys.CONTEXT_COMPONENT)))) == currentHint) {
                return;
            }
            EditorMouseHoverPopupManager.getInstance().cancelProcessingAndCloseHint();
        }

        public void beforeEditorTyping(char c, @NotNull DataContext dataContext) {
            if (dataContext == null) {
                MyActionListener.$$$reportNull$$$0(2);
            }
            EditorMouseHoverPopupManager.getInstance().cancelProcessingAndCloseHint();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "action";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataContext";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/editor/EditorMouseHoverPopupManager$MyActionListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "beforeActionPerformed";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "beforeEditorTyping";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static final class MyEditorMouseEventListener
    implements EditorMouseListener {
        MyEditorMouseEventListener() {
        }

        public void mouseEntered(@NotNull EditorMouseEvent event) {
            if (event == null) {
                MyEditorMouseEventListener.$$$reportNull$$$0(0);
            }
            EditorMouseHoverPopupManager.getInstance().skipNextMovement();
        }

        public void mouseExited(@NotNull EditorMouseEvent event) {
            if (event == null) {
                MyEditorMouseEventListener.$$$reportNull$$$0(1);
            }
            EditorMouseHoverPopupManager.getInstance().cancelCurrentProcessing();
        }

        public void mousePressed(@NotNull EditorMouseEvent event) {
            if (event == null) {
                MyEditorMouseEventListener.$$$reportNull$$$0(2);
            }
            EditorMouseHoverPopupManager.getInstance().cancelProcessingAndCloseHint();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "event";
            objectArray2[1] = "com/intellij/openapi/editor/EditorMouseHoverPopupManager$MyEditorMouseEventListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "mouseEntered";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "mouseExited";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "mousePressed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static final class MyEditorMouseMotionEventListener
    implements EditorMouseMotionListener {
        MyEditorMouseMotionEventListener() {
        }

        public void mouseMoved(@NotNull EditorMouseEvent e) {
            if (e == null) {
                MyEditorMouseMotionEventListener.$$$reportNull$$$0(0);
            }
            EditorMouseHoverPopupManager.getInstance().handleMouseMoved(e);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/editor/EditorMouseHoverPopupManager$MyEditorMouseMotionEventListener", "mouseMoved"));
        }
    }

    private static final class CombinedPopupLayout
    implements LayoutManager {
        private final JComponent highlightInfoComponent;
        private final DocumentationComponent quickDocComponent;

        private CombinedPopupLayout(JComponent highlightInfoComponent, DocumentationComponent quickDocComponent) {
            this.highlightInfoComponent = highlightInfoComponent;
            this.quickDocComponent = quickDocComponent;
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int w1 = WidthBasedLayout.getPreferredWidth((Component)this.highlightInfoComponent);
            int w2 = WidthBasedLayout.getPreferredWidth((Component)this.quickDocComponent);
            int preferredWidth = Math.min(JBUI.scale((int)650), Math.max(w1, w2));
            int h1 = WidthBasedLayout.getPreferredHeight((Component)this.highlightInfoComponent, (int)preferredWidth);
            int h2 = WidthBasedLayout.getPreferredHeight((Component)this.quickDocComponent, (int)preferredWidth);
            return new Dimension(preferredWidth, h1 + h2);
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            Dimension d1 = this.highlightInfoComponent == null ? new Dimension() : this.highlightInfoComponent.getMinimumSize();
            Dimension d2 = this.quickDocComponent == null ? new Dimension() : this.quickDocComponent.getMinimumSize();
            return new Dimension(Math.max(d1.width, d2.width), d1.height + d2.height);
        }

        @Override
        public void layoutContainer(Container parent) {
            int width = parent.getWidth();
            int height = parent.getHeight();
            if (this.highlightInfoComponent == null) {
                if (this.quickDocComponent != null) {
                    this.quickDocComponent.setBounds(0, 0, width, height);
                }
            } else if (this.quickDocComponent == null) {
                this.highlightInfoComponent.setBounds(0, 0, width, height);
            } else {
                int h1 = Math.min(height, this.highlightInfoComponent.getPreferredSize().height);
                this.highlightInfoComponent.setBounds(0, 0, width, h1);
                this.quickDocComponent.setBounds(0, h1, width, height - h1);
            }
        }
    }

    private static final class WrapperPanel
    extends JPanel
    implements WidthBasedLayout {
        private WrapperPanel(JComponent content2) {
            super(new BorderLayout());
            this.setBorder(null);
            this.setContent(content2);
        }

        private void setContent(JComponent content2) {
            this.removeAll();
            this.add((Component)content2, "Center");
        }

        private JComponent getComponent() {
            return (JComponent)this.getComponent(0);
        }

        public int getPreferredWidth() {
            return WidthBasedLayout.getPreferredWidth((Component)this.getComponent());
        }

        public int getPreferredHeight(int width) {
            return WidthBasedLayout.getPreferredHeight((Component)this.getComponent(), (int)width);
        }
    }

    protected static class PopupBridge {
        private AbstractPopup popup;
        private List<Consumer<? super AbstractPopup>> consumers = new ArrayList<Consumer<? super AbstractPopup>>();

        private void setPopup(@NotNull AbstractPopup popup2) {
            if (popup2 == null) {
                PopupBridge.$$$reportNull$$$0(0);
            }
            assert (this.popup == null);
            this.popup = popup2;
            this.consumers.forEach(c -> c.accept(popup2));
            this.consumers = null;
        }

        @Nullable
        private AbstractPopup getPopup() {
            return this.popup;
        }

        private void performWhenAvailable(@NotNull Consumer<? super AbstractPopup> consumer) {
            if (consumer == null) {
                PopupBridge.$$$reportNull$$$0(1);
            }
            if (this.popup == null) {
                this.consumers.add(consumer);
            } else {
                consumer.accept(this.popup);
            }
        }

        private void performOnCancel(final @NotNull Runnable runnable2) {
            if (runnable2 == null) {
                PopupBridge.$$$reportNull$$$0(2);
            }
            this.performWhenAvailable(popup2 -> popup2.addListener(new JBPopupListener(){

                public void onClosed(@NotNull LightweightWindowEvent event) {
                    if (event == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    runnable2.run();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/editor/EditorMouseHoverPopupManager$PopupBridge$1", "onClosed"));
                }
            }));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "popup";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "consumer";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "runnable";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/editor/EditorMouseHoverPopupManager$PopupBridge";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setPopup";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "performWhenAvailable";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "performOnCancel";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    protected static final class Info {
        private final HighlightInfo highlightInfo;
        private final TooltipAction tooltipAction;
        @Nls
        private final String quickDocMessage;
        private final WeakReference<PsiElement> quickDocElement;
        private final DocumentationProvider docProvider;

        public Info(HighlightInfo highlightInfo, TooltipAction tooltipAction, @Nls String quickDocMessage, PsiElement quickDocElement, @Nullable DocumentationProvider provider2) {
            assert (highlightInfo != null || quickDocMessage != null);
            this.docProvider = provider2;
            this.highlightInfo = highlightInfo;
            this.tooltipAction = tooltipAction;
            this.quickDocMessage = quickDocMessage;
            this.quickDocElement = new WeakReference<PsiElement>(quickDocElement);
        }

        public JComponent createComponent(Editor editor, PopupBridge popupBridge, boolean requestFocus) {
            boolean quickDocShownInPopup = this.quickDocMessage != null && ToolWindowManager.getInstance((Project)Objects.requireNonNull(editor.getProject())).getToolWindow("Documentation") == null;
            JComponent c1 = this.createHighlightInfoComponent(editor, !quickDocShownInPopup, popupBridge, requestFocus);
            DocumentationComponent c2 = this.createQuickDocComponent(editor, c1 != null, popupBridge);
            assert (quickDocShownInPopup == (c2 != null));
            if (c1 == null && c2 == null) {
                return null;
            }
            JPanel p = new JPanel(new CombinedPopupLayout(c1, c2));
            p.setBorder(null);
            if (c1 != null) {
                p.add(c1);
            }
            if (c2 != null) {
                p.add(c2);
            }
            return p;
        }

        private JComponent createHighlightInfoComponent(Editor editor, boolean highlightActions, PopupBridge popupBridge, boolean requestFocus) {
            if (this.highlightInfo == null) {
                return null;
            }
            ErrorStripTooltipRendererProvider provider2 = ((EditorMarkupModel)editor.getMarkupModel()).getErrorStripTooltipRendererProvider();
            TooltipRenderer tooltipRenderer = provider2.calcTooltipRenderer(Objects.requireNonNull(this.highlightInfo.getToolTip()), this.tooltipAction, -1);
            if (!(tooltipRenderer instanceof LineTooltipRenderer)) {
                return null;
            }
            return Info.createHighlightInfoComponent(editor, (LineTooltipRenderer)tooltipRenderer, highlightActions, popupBridge, requestFocus);
        }

        private static JComponent createHighlightInfoComponent(Editor editor, LineTooltipRenderer renderer, boolean highlightActions, PopupBridge popupBridge, boolean requestFocus) {
            Ref wrapperPanelRef = new Ref();
            Ref mockHintRef = new Ref();
            HintHint hintHint = new HintHint().setAwtTooltip(true).setRequestFocus(requestFocus);
            LightweightHint hint = renderer.createHint(editor, new Point(), false, EDITOR_INFO_GROUP, hintHint, highlightActions, false, expand -> {
                LineTooltipRenderer newRenderer = renderer.createRenderer(renderer.getText(), expand ? 1 : 0);
                JComponent newComponent = Info.createHighlightInfoComponent(editor, newRenderer, highlightActions, popupBridge, requestFocus);
                AbstractPopup popup2 = popupBridge.getPopup();
                WrapperPanel wrapper2 = (WrapperPanel)wrapperPanelRef.get();
                if (newComponent != null && popup2 != null && wrapper2 != null) {
                    LightweightHint mockHint = (LightweightHint)mockHintRef.get();
                    if (mockHint != null) {
                        Info.closeHintIgnoreBinding(mockHint);
                    }
                    wrapper2.setContent(newComponent);
                    EditorMouseHoverPopupManager.validatePopupSize(popup2);
                }
            });
            if (hint == null) {
                return null;
            }
            mockHintRef.set((Object)hint);
            Info.bindHintHiding(hint, popupBridge);
            JComponent component2 = hint.getComponent();
            LOG.assertTrue(component2 instanceof WidthBasedLayout, (Object)("Unexpected type of tooltip component: " + component2.getClass()));
            WrapperPanel wrapper2 = new WrapperPanel(component2);
            wrapperPanelRef.set((Object)wrapper2);
            wrapper2.setBackground(hintHint.getTextBackground());
            wrapper2.setOpaque(true);
            return wrapper2;
        }

        private static void bindHintHiding(LightweightHint hint, PopupBridge popupBridge) {
            AtomicBoolean inProcess = new AtomicBoolean();
            hint.addHintListener(e -> {
                if (hint.getUserData(DISABLE_BINDING) == null && inProcess.compareAndSet(false, true)) {
                    try {
                        AbstractPopup popup2 = popupBridge.getPopup();
                        if (popup2 != null) {
                            popup2.cancel();
                        }
                    }
                    finally {
                        inProcess.set(false);
                    }
                }
            });
            popupBridge.performOnCancel(() -> {
                if (hint.getUserData(DISABLE_BINDING) == null && inProcess.compareAndSet(false, true)) {
                    try {
                        hint.hide();
                    }
                    finally {
                        inProcess.set(false);
                    }
                }
            });
        }

        private static void closeHintIgnoreBinding(LightweightHint hint) {
            hint.putUserData(DISABLE_BINDING, Boolean.TRUE);
            hint.hide();
        }

        @Nullable
        private DocumentationComponent createQuickDocComponent(Editor editor, final boolean deEmphasize, final PopupBridge popupBridge) {
            if (this.quickDocMessage == null) {
                return null;
            }
            PsiElement element2 = (PsiElement)this.quickDocElement.get();
            Project project = Objects.requireNonNull(editor.getProject());
            final DocumentationManager documentationManager = DocumentationManager.getInstance(project);
            ToolWindow toolWindow = ToolWindowManager.getInstance((Project)project).getToolWindow("Documentation");
            if (toolWindow != null) {
                if (element2 != null) {
                    documentationManager.showJavaDocInfo(editor, element2, EditorMouseHoverPopupManager.extractOriginalElement(element2), null, this.quickDocMessage, true, false);
                    documentationManager.setAllowContentUpdateFromContext(false);
                }
                return null;
            }
            final class MyDocComponent
            extends DocumentationComponent {
                private MyDocComponent() {
                    super(documentationManager2, false);
                    if (deEmphasize) {
                        this.setBackground(UIUtil.getToolTipActionBackground());
                    }
                }

                @Override
                protected void showHint() {
                    AbstractPopup popup2 = popupBridge.getPopup();
                    if (popup2 != null) {
                        EditorMouseHoverPopupManager.validatePopupSize(popup2);
                    }
                }
            }
            MyDocComponent component2 = new MyDocComponent();
            if (deEmphasize) {
                component2.setBorder(IdeBorderFactory.createBorder((Color)UIUtil.getTooltipSeparatorColor(), (int)2));
            }
            component2.setData(element2, this.quickDocMessage, null, null, this.docProvider);
            component2.setToolwindowCallback(() -> {
                AbstractPopup popup2;
                PsiElement docElement = component2.getElement();
                if (docElement != null) {
                    documentationManager.createToolWindow(docElement, EditorMouseHoverPopupManager.extractOriginalElement(docElement));
                    ToolWindow createdToolWindow = ToolWindowManager.getInstance((Project)project).getToolWindow("Documentation");
                    if (createdToolWindow != null) {
                        createdToolWindow.setAutoHide(false);
                    }
                }
                if ((popup2 = popupBridge.getPopup()) != null) {
                    popup2.cancel();
                }
            });
            popupBridge.performWhenAvailable(component2::setHint);
            EditorUtil.disposeWithEditor(editor, component2);
            popupBridge.performOnCancel(() -> Disposer.dispose((Disposable)component2));
            return component2;
        }

        public Info withQuickDocMessage(@Nls String quickDocMessage) {
            return new Info(this.highlightInfo, this.tooltipAction, quickDocMessage, (PsiElement)this.quickDocElement.get(), this.docProvider);
        }

        public Info withQuickDocElement(PsiElement element2) {
            return new Info(this.highlightInfo, this.tooltipAction, this.quickDocMessage, element2, this.docProvider);
        }

        public Info withTooltip(TooltipAction tooltipAction) {
            return new Info(this.highlightInfo, tooltipAction, this.quickDocMessage, (PsiElement)this.quickDocElement.get(), this.docProvider);
        }
    }

    protected static class Context {
        private final long startTimestamp;
        private final int targetOffset;
        private final WeakReference<HighlightInfo> highlightInfo;
        private final WeakReference<PsiElement> elementForQuickDoc;

        protected Context(long startTimestamp, int targetOffset, HighlightInfo highlightInfo, PsiElement elementForQuickDoc) {
            this.startTimestamp = startTimestamp;
            this.targetOffset = targetOffset;
            this.highlightInfo = highlightInfo == null ? null : new WeakReference<HighlightInfo>(highlightInfo);
            this.elementForQuickDoc = elementForQuickDoc == null ? null : new WeakReference<PsiElement>(elementForQuickDoc);
        }

        public PsiElement getElementForQuickDoc() {
            return (PsiElement)SoftReference.dereference(this.elementForQuickDoc);
        }

        public HighlightInfo getHighlightInfo() {
            return (HighlightInfo)SoftReference.dereference(this.highlightInfo);
        }

        public int getTargetOffset() {
            return this.targetOffset;
        }

        private Relation compareTo(Context other) {
            if (other == null) {
                return Relation.DIFFERENT;
            }
            HighlightInfo highlightInfo = this.getHighlightInfo();
            if (!Objects.equals(highlightInfo, other.getHighlightInfo())) {
                return Relation.DIFFERENT;
            }
            return Objects.equals(this.getElementForQuickDoc(), other.getElementForQuickDoc()) ? Relation.SAME : (highlightInfo == null ? Relation.DIFFERENT : Relation.SIMILAR);
        }

        public long getShowingDelay() {
            return Math.max(0L, (long)EditorSettingsExternalizable.getInstance().getTooltipsDelay() - (System.currentTimeMillis() - this.startTimestamp));
        }

        private static int getElementStartHostOffset(@NotNull PsiElement element2) {
            Document document;
            if (element2 == null) {
                Context.$$$reportNull$$$0(0);
            }
            int offset = element2.getTextRange().getStartOffset();
            Project project = element2.getProject();
            PsiFile containingFile = element2.getContainingFile();
            if (containingFile != null && InjectedLanguageManager.getInstance((Project)project).isInjectedFragment(containingFile) && (document = PsiDocumentManager.getInstance((Project)project).getDocument(containingFile)) instanceof DocumentWindow) {
                return ((DocumentWindow)document).injectedToHost(offset);
            }
            return offset;
        }

        @NotNull
        protected VisualPosition getPopupPosition(Editor editor) {
            HighlightInfo highlightInfo = this.getHighlightInfo();
            if (highlightInfo == null) {
                int offset = this.targetOffset;
                PsiElement elementForQuickDoc = this.getElementForQuickDoc();
                if (elementForQuickDoc != null && elementForQuickDoc.isValid()) {
                    offset = Context.getElementStartHostOffset(elementForQuickDoc);
                }
                VisualPosition visualPosition = editor.offsetToVisualPosition(offset);
                if (visualPosition == null) {
                    Context.$$$reportNull$$$0(1);
                }
                return visualPosition;
            }
            VisualPosition targetPosition = editor.offsetToVisualPosition(this.targetOffset);
            VisualPosition endPosition = editor.offsetToVisualPosition(highlightInfo.getEndOffset());
            if (endPosition.line <= targetPosition.line) {
                VisualPosition visualPosition = targetPosition;
                if (visualPosition == null) {
                    Context.$$$reportNull$$$0(2);
                }
                return visualPosition;
            }
            Point targetPoint = editor.visualPositionToXY(targetPosition);
            Point endPoint = editor.visualPositionToXY(endPosition);
            Point resultPoint = new Point(targetPoint.x, endPoint.x > targetPoint.x ? endPoint.y : editor.visualLineToY(endPosition.line - 1));
            VisualPosition visualPosition = editor.xyToVisualPosition(resultPoint);
            if (visualPosition == null) {
                Context.$$$reportNull$$$0(3);
            }
            return visualPosition;
        }

        @Nullable
        protected Info calcInfo(@NotNull Editor editor) {
            if (editor == null) {
                Context.$$$reportNull$$$0(4);
            }
            HighlightInfo info2 = this.getHighlightInfo();
            HighlightInfo infoToUse = null;
            TooltipAction tooltipAction = null;
            if (info2 != null && info2.getDescription() != null && info2.getToolTip() != null) {
                infoToUse = info2;
                try {
                    tooltipAction = (TooltipAction)ReadAction.nonBlocking(() -> TooltipActionProvider.calcTooltipAction(info2, editor)).executeSynchronously();
                }
                catch (IndexNotReadyException indexNotReadyException) {
                }
                catch (ProcessCanceledException e) {
                    throw e;
                }
                catch (Exception e) {
                    LOG.warn((Throwable)e);
                }
            }
            String quickDocMessage = null;
            DocumentationProvider provider2 = null;
            PsiElement targetElement = null;
            PsiElement element2 = this.getElementForQuickDoc();
            if (element2 != null) {
                try {
                    Project project = Objects.requireNonNull(editor.getProject());
                    DocumentationManager documentationManager = (DocumentationManager)ReadAction.compute(() -> project.isDisposed() ? null : DocumentationManager.getInstance(project));
                    if (documentationManager != null && (targetElement = this.findTargetElement(editor, element2, documentationManager)) != null) {
                        Pair<@NlsSafe String, DocumentationProvider> docWithProvider = documentationManager.getDocumentationAndProvider(targetElement, element2, true);
                        quickDocMessage = (String)docWithProvider.first;
                        provider2 = (DocumentationProvider)docWithProvider.second;
                        if (quickDocMessage != null && quickDocMessage.length() > 100000) {
                            quickDocMessage = quickDocMessage.substring(0, 100000);
                        }
                        if (quickDocMessage != null) {
                            PsiElement finalTargetElement = targetElement;
                            String finalQuickDocMessage = quickDocMessage;
                            DocumentationProvider finalProvider = provider2;
                            quickDocMessage = (String)ReadAction.compute(() -> documentationManager.decorate(finalTargetElement, finalQuickDocMessage, null, finalProvider));
                        }
                    }
                }
                catch (IndexNotReadyException project) {
                }
                catch (ProcessCanceledException project) {
                }
                catch (Exception e) {
                    LOG.warn((Throwable)e);
                }
            }
            return infoToUse == null && quickDocMessage == null ? null : new Info(infoToUse, tooltipAction, quickDocMessage, targetElement, provider2);
        }

        @Nullable
        protected PsiElement findTargetElement(@NotNull Editor editor, PsiElement element2, DocumentationManager documentationManager) {
            if (editor == null) {
                Context.$$$reportNull$$$0(5);
            }
            return (PsiElement)ReadAction.nonBlocking(() -> {
                if (element2.isValid()) {
                    PsiFile containingFile = element2.getContainingFile();
                    Editor injectedEditor = InjectedLanguageUtil.getInjectedEditorForInjectedFile(editor, null, containingFile);
                    int offset = injectedEditor instanceof EditorWindow ? ((EditorWindow)injectedEditor).getDocument().hostToInjected(this.targetOffset) : this.targetOffset;
                    return documentationManager.findTargetElement(injectedEditor, offset, containingFile, element2);
                }
                return null;
            }).executeSynchronously();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/editor/EditorMouseHoverPopupManager$Context";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/editor/EditorMouseHoverPopupManager$Context";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPopupPosition";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getElementStartHostOffset";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "calcInfo";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "findTargetElement";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        private static enum Relation {
            SAME,
            SIMILAR,
            DIFFERENT;

        }
    }
}

