/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.patch;

import com.intellij.openapi.diff.impl.patch.BinaryEncoder;
import com.intellij.openapi.diff.impl.patch.BinaryFilePatch;
import com.intellij.openapi.diff.impl.patch.FilePatch;
import com.intellij.openapi.diff.impl.patch.PatchSyntaxException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.VcsBundle;
import java.io.ByteArrayOutputStream;
import java.util.ListIterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class BinaryPatchContentParser {
    @NonNls
    private static final Pattern ourGitBinaryLineSize = Pattern.compile("literal\\s+(\\d+)\\s*");

    public static FilePatch readGitBinaryFormatPatch(@NotNull ListIterator<String> iterator2, @NotNull FileStatus parsedStatus) throws PatchSyntaxException {
        if (iterator2 == null) {
            BinaryPatchContentParser.$$$reportNull$$$0(0);
        }
        if (parsedStatus == null) {
            BinaryPatchContentParser.$$$reportNull$$$0(1);
        }
        ByteArrayOutputStream afterStream = new ByteArrayOutputStream();
        ByteArrayOutputStream beforeStream = new ByteArrayOutputStream();
        BinaryPatchContentParser.checkNotEOF(iterator2);
        try {
            String next = iterator2.next();
            Matcher literalMatcher = ourGitBinaryLineSize.matcher(next);
            if (literalMatcher.matches()) {
                BinaryPatchContentParser.getContent(iterator2, afterStream, literalMatcher.group(1));
            }
            if (iterator2.hasNext() && parsedStatus != FileStatus.ADDED) {
                next = iterator2.next();
                if (StringUtil.isEmptyOrSpaces((String)next) && iterator2.hasNext()) {
                    next = iterator2.next();
                }
                if (literalMatcher.reset(next).matches()) {
                    BinaryPatchContentParser.getContent(iterator2, beforeStream, literalMatcher.group(1));
                } else {
                    iterator2.previous();
                }
            }
            return new BinaryFilePatch(parsedStatus == FileStatus.ADDED ? null : beforeStream.toByteArray(), parsedStatus == FileStatus.DELETED ? null : afterStream.toByteArray());
        }
        catch (Exception e) {
            throw new PatchSyntaxException(iterator2.previousIndex(), e.getMessage());
        }
    }

    private static void getContent(@NotNull ListIterator<String> iterator2, @NotNull ByteArrayOutputStream afterStream, @NotNull String lenFromLiteral) throws EofBinaryPatchSyntaxException, BinaryEncoder.BinaryPatchException {
        if (iterator2 == null) {
            BinaryPatchContentParser.$$$reportNull$$$0(2);
        }
        if (afterStream == null) {
            BinaryPatchContentParser.$$$reportNull$$$0(3);
        }
        if (lenFromLiteral == null) {
            BinaryPatchContentParser.$$$reportNull$$$0(4);
        }
        long afterSize = Long.parseLong(lenFromLiteral);
        BinaryPatchContentParser.checkNotEOF(iterator2);
        BinaryEncoder.decode(iterator2, afterSize, afterStream);
    }

    private static void checkNotEOF(@NotNull ListIterator<String> iterator2) throws EofBinaryPatchSyntaxException {
        if (iterator2 == null) {
            BinaryPatchContentParser.$$$reportNull$$$0(5);
        }
        if (!iterator2.hasNext()) {
            throw new EofBinaryPatchSyntaxException(iterator2.previousIndex());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iterator";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parsedStatus";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "afterStream";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lenFromLiteral";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/diff/impl/patch/BinaryPatchContentParser";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "readGitBinaryFormatPatch";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getContent";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "checkNotEOF";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class EofBinaryPatchSyntaxException
    extends PatchSyntaxException {
        public EofBinaryPatchSyntaxException(int line) {
            super(line, VcsBundle.message((String)"patch.unexpected.end.of.binary.patch", (Object[])new Object[0]));
        }
    }
}

