/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application.impl;

import com.intellij.BundleBase;
import com.intellij.CommonBundle;
import com.intellij.codeWithMe.ClientId;
import com.intellij.configurationStore.StoreUtil;
import com.intellij.diagnostic.Activity;
import com.intellij.diagnostic.ActivityCategory;
import com.intellij.diagnostic.LoadingState;
import com.intellij.diagnostic.PerformanceWatcher;
import com.intellij.diagnostic.StartUpMeasurer;
import com.intellij.diagnostic.ThreadDumper;
import com.intellij.featureStatistics.fusCollectors.LifecycleUsageTriggerCollector;
import com.intellij.ide.ActivityTracker;
import com.intellij.ide.AppLifecycleListener;
import com.intellij.ide.ApplicationActivationStateManager;
import com.intellij.ide.BootstrapBundle;
import com.intellij.ide.GeneralSettings;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.SaveAndSyncHandler;
import com.intellij.ide.plugins.ContainerDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.idea.ApplicationLoader;
import com.intellij.idea.IdeaLogger;
import com.intellij.idea.Main;
import com.intellij.idea.StartupUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityInvokator;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.application.TransactionGuardImpl;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.application.ex.ApplicationUtil;
import com.intellij.openapi.application.impl.AWTExceptionHandler;
import com.intellij.openapi.application.impl.AnyModalityState;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.application.impl.ModalityInvokatorImpl;
import com.intellij.openapi.application.impl.ModalityStateEx;
import com.intellij.openapi.application.impl.NoSwingUnderWriteAction;
import com.intellij.openapi.application.impl.ReadMostlyRWLock;
import com.intellij.openapi.client.ClientAwareComponentManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diagnostic.RuntimeExceptionWithAttachments;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.impl.CoreProgressManager;
import com.intellij.openapi.progress.impl.ProgressResult;
import com.intellij.openapi.progress.impl.ProgressRunner;
import com.intellij.openapi.progress.util.PotemkinProgress;
import com.intellij.openapi.progress.util.ProgressWindow;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.OkCancelDialogBuilder;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.ShutDownTracker;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.serviceContainer.ComponentManagerImpl;
import com.intellij.ui.ComponentUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.BitUtil;
import com.intellij.util.DeprecatedMethodException;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.Restarter;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.AppScheduledExecutorService;
import com.intellij.util.containers.Stack;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.EDT;
import com.intellij.util.ui.EdtInvocationManager;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.KeyboardFocusManager;
import java.awt.Toolkit;
import java.awt.Window;
import java.util.EventListener;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import sun.awt.AWTAccessor;
import sun.awt.AWTAutoShutdown;

@ApiStatus.Internal
public class ApplicationImpl
extends ClientAwareComponentManager
implements ApplicationEx {
    private static final Logger LOG = Logger.getInstance(ApplicationImpl.class);
    public static final boolean USE_SEPARATE_WRITE_THREAD = StartupUtil.isUsingSeparateWriteThread();
    final ReadMostlyRWLock myLock;
    private final ModalityInvokator myInvokator = new ModalityInvokatorImpl();
    private final EventDispatcher<ApplicationListener> myDispatcher = EventDispatcher.create(ApplicationListener.class);
    private final boolean myTestModeFlag;
    private final boolean myHeadlessMode;
    private final boolean myCommandLineMode;
    private final boolean myIsInternal;
    private final Stack<Class<?>> myWriteActionsStack = new Stack();
    private final TransactionGuardImpl myTransactionGuard = new TransactionGuardImpl();
    private int myWriteStackBase;
    private final long myStartTime = System.currentTimeMillis();
    private boolean mySaveAllowed;
    private volatile boolean myExitInProgress;
    private final Disposable myLastDisposable = Disposer.newDisposable();
    private final ExecutorService ourThreadExecutorsService = AppExecutorUtil.getAppExecutorService();
    private static final String WAS_EVER_SHOWN = "was.ever.shown";
    private volatile boolean myWriteActionPending;

    public ApplicationImpl(boolean isInternal, boolean isUnitTestMode, boolean isHeadless, boolean isCommandLine) {
        super(null);
        this.registerServiceInstance(TransactionGuard.class, this.myTransactionGuard, (PluginDescriptor)ComponentManagerImpl.fakeCorePluginDescriptor);
        this.registerServiceInstance(ApplicationInfo.class, ApplicationInfoImpl.getShadowInstance(), (PluginDescriptor)ComponentManagerImpl.fakeCorePluginDescriptor);
        this.registerServiceInstance(Application.class, this, (PluginDescriptor)ComponentManagerImpl.fakeCorePluginDescriptor);
        if (isUnitTestMode || isInternal) {
            BundleBase.assertOnMissedKeys((boolean)true);
        }
        AWTExceptionHandler.register();
        Disposer.setDebugMode((isInternal || isUnitTestMode || Disposer.isDebugDisposerOn() ? 1 : 0) != 0);
        this.myIsInternal = isInternal;
        this.myTestModeFlag = isUnitTestMode;
        this.myHeadlessMode = isHeadless;
        this.myCommandLineMode = isCommandLine;
        if (isUnitTestMode) {
            Logger.setUnitTestMode();
        }
        this.mySaveAllowed = !isUnitTestMode && !isHeadless;
        ApplicationManager.setApplication((Application)this, (Disposable)this.myLastDisposable);
        if (!isUnitTestMode && !isHeadless) {
            Disposable uiRootDisposable = Disposer.newDisposable();
            Disposer.register((Disposable)this, (Disposable)uiRootDisposable, (String)"ui");
        }
        Activity activity = StartUpMeasurer.startActivity((String)"AppDelayQueue instantiation", (ActivityCategory)ActivityCategory.DEFAULT);
        AtomicReference edtThread = new AtomicReference();
        EdtInvocationManager.invokeAndWaitIfNeeded(() -> {
            ApplicationImpl.preventAwtAutoShutdown((Disposable)this);
            edtThread.set(Thread.currentThread());
        });
        this.myLock = new ReadMostlyRWLock((Thread)edtThread.get());
        if (!USE_SEPARATE_WRITE_THREAD || isUnitTestMode) {
            EdtInvocationManager.invokeAndWaitIfNeeded(() -> this.acquireWriteIntentLock(this.getClass().getName()));
        }
        activity.end();
        NoSwingUnderWriteAction.watchForEvents(this);
    }

    public static void preventAwtAutoShutdown(@NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            ApplicationImpl.$$$reportNull$$$0(0);
        }
        Thread thread = AppScheduledExecutorService.getPeriodicTasksThread();
        AWTAutoShutdown.getInstance().notifyThreadBusy(thread);
        Disposer.register((Disposable)parentDisposable, () -> AWTAutoShutdown.getInstance().notifyThreadFree(thread));
    }

    @Override
    public void executeByImpatientReader(@NotNull Runnable runnable2) throws ApplicationUtil.CannotRunReadActionException {
        if (runnable2 == null) {
            ApplicationImpl.$$$reportNull$$$0(1);
        }
        if (this.isDispatchThread()) {
            runnable2.run();
        } else {
            this.myLock.executeByImpatientReader(runnable2);
        }
    }

    @Override
    public boolean isInImpatientReader() {
        return this.myLock.isInImpatientReader();
    }

    @TestOnly
    public void disposeContainer() {
        this.runWriteAction(() -> {
            this.startDispose();
            Disposer.dispose((Disposable)this);
        });
        Disposer.assertIsEmpty();
    }

    private boolean disposeSelf(boolean checkCanCloseProject) {
        ProjectManagerEx manager2 = ProjectManagerEx.getInstanceExIfCreated();
        if (manager2 != null) {
            try {
                if (!manager2.closeAndDisposeAllProjects(checkCanCloseProject)) {
                    return false;
                }
            }
            catch (Throwable e) {
                LOG.error(e);
            }
        }
        this.disposeContainer();
        return true;
    }

    @Override
    public boolean holdsReadLock() {
        return this.myLock.isReadLockedByThisThread();
    }

    public boolean isInternal() {
        return this.myIsInternal;
    }

    public boolean isEAP() {
        return ApplicationInfoImpl.getShadowInstance().isEAP();
    }

    public boolean isUnitTestMode() {
        return this.myTestModeFlag;
    }

    public boolean isHeadlessEnvironment() {
        return this.myHeadlessMode;
    }

    public boolean isCommandLine() {
        return this.myCommandLineMode;
    }

    @Override
    public final boolean isLightEditMode() {
        return Main.isLightEdit();
    }

    @NotNull
    public Future<?> executeOnPooledThread(final @NotNull Runnable action2) {
        if (action2 == null) {
            ApplicationImpl.$$$reportNull$$$0(2);
        }
        final Runnable actionDecorated = ClientId.decorateRunnable((Runnable)action2);
        Future<?> future2 = this.ourThreadExecutorsService.submit(new Runnable(){

            @Override
            public void run() {
                if (ApplicationImpl.this.isDisposed()) {
                    return;
                }
                try {
                    actionDecorated.run();
                }
                catch (ProcessCanceledException processCanceledException) {
                }
                catch (Throwable e) {
                    LOG.error(e);
                }
                finally {
                    Thread.interrupted();
                }
            }

            public String toString() {
                return action2.toString();
            }
        });
        if (future2 == null) {
            ApplicationImpl.$$$reportNull$$$0(3);
        }
        return future2;
    }

    @NotNull
    public <T> Future<T> executeOnPooledThread(final @NotNull Callable<T> action2) {
        if (action2 == null) {
            ApplicationImpl.$$$reportNull$$$0(4);
        }
        final Callable actionDecorated = ClientId.decorateCallable(action2);
        Future future2 = this.ourThreadExecutorsService.submit(new Callable<T>(){

            @Override
            public T call() {
                if (ApplicationImpl.this.isDisposed()) {
                    return null;
                }
                try {
                    Object v = actionDecorated.call();
                    return v;
                }
                catch (ProcessCanceledException processCanceledException) {
                }
                catch (Throwable e) {
                    LOG.error(e);
                }
                finally {
                    Thread.interrupted();
                }
                return null;
            }

            public String toString() {
                return action2.toString();
            }
        });
        if (future2 == null) {
            ApplicationImpl.$$$reportNull$$$0(5);
        }
        return future2;
    }

    public boolean isDispatchThread() {
        return this.isWriteThread() && EDT.isCurrentThreadEdt();
    }

    public boolean isWriteThread() {
        return this.myLock.isWriteThread();
    }

    @NotNull
    public ModalityInvokator getInvokator() {
        ModalityInvokator modalityInvokator = this.myInvokator;
        if (modalityInvokator == null) {
            ApplicationImpl.$$$reportNull$$$0(6);
        }
        return modalityInvokator;
    }

    public void invokeLater(@NotNull Runnable runnable2) {
        if (runnable2 == null) {
            ApplicationImpl.$$$reportNull$$$0(7);
        }
        this.invokeLater(runnable2, this.getDisposed());
    }

    public void invokeLater(@NotNull Runnable runnable2, @NotNull Condition<?> expired) {
        if (runnable2 == null) {
            ApplicationImpl.$$$reportNull$$$0(8);
        }
        if (expired == null) {
            ApplicationImpl.$$$reportNull$$$0(9);
        }
        this.invokeLater(runnable2, ModalityState.defaultModalityState(), expired);
    }

    public void invokeLater(@NotNull Runnable runnable2, @NotNull ModalityState state) {
        if (runnable2 == null) {
            ApplicationImpl.$$$reportNull$$$0(10);
        }
        if (state == null) {
            ApplicationImpl.$$$reportNull$$$0(11);
        }
        this.invokeLater(runnable2, state, this.getDisposed());
    }

    public void invokeLater(@NotNull Runnable runnable2, @NotNull ModalityState state, @NotNull Condition<?> expired) {
        if (runnable2 == null) {
            ApplicationImpl.$$$reportNull$$$0(12);
        }
        if (state == null) {
            ApplicationImpl.$$$reportNull$$$0(13);
        }
        if (expired == null) {
            ApplicationImpl.$$$reportNull$$$0(14);
        }
        Runnable r = this.myTransactionGuard.wrapLaterInvocation(runnable2, state);
        LaterInvocator.invokeLaterWithCallback(() -> this.runIntendedWriteActionOnCurrentThread(r), state, expired, null, true);
    }

    @Override
    public final void load() {
        List<IdeaPluginDescriptorImpl> plugins2 = PluginManagerCore.getLoadedPlugins(null);
        this.registerComponents(plugins2, this, null, null);
        ApplicationLoader.initConfigurationStore(this);
        ((CompletableFuture)this.preloadServices(plugins2, "", false).getSecond()).join();
        this.loadComponents(null);
        ForkJoinTask.invokeAll(ApplicationLoader.callAppInitialized(this));
    }

    public final void loadComponents(@Nullable ProgressIndicator indicator2) {
        if (indicator2 == null) {
            this.createComponents(null);
        } else {
            ProgressManager.getInstance().runProcess(() -> this.createComponents(indicator2), indicator2);
        }
        StartUpMeasurer.setCurrentState((LoadingState)LoadingState.COMPONENTS_LOADED);
    }

    @Override
    public void dispose() {
        ((ApplicationListener)this.myDispatcher.getMulticaster()).applicationExiting();
        ShutDownTracker.getInstance().ensureStopperThreadsFinished();
        super.dispose();
        if (!USE_SEPARATE_WRITE_THREAD || this.isUnitTestMode()) {
            this.invokeLater(() -> this.releaseWriteIntentLock(), ModalityState.NON_MODAL);
        }
        AppExecutorUtil.shutdownApplicationScheduledExecutorService();
        Disposer.dispose((Disposable)this.myLastDisposable);
    }

    @Override
    public boolean runProcessWithProgressSynchronously(@NotNull Runnable process2, @NotNull String progressTitle2, boolean canBeCanceled, boolean shouldShowModalWindow, @Nullable Project project, @Nullable JComponent parentComponent, @Nullable @Nls(capitalization=Nls.Capitalization.Title) String cancelText) {
        if (process2 == null) {
            ApplicationImpl.$$$reportNull$$$0(15);
        }
        if (progressTitle2 == null) {
            ApplicationImpl.$$$reportNull$$$0(16);
        }
        if (this.isDispatchThread() && this.isWriteAccessAllowed()) {
            LOG.debug("Starting process with progress from within write action makes no sense");
            try {
                ProgressManager.getInstance().runProcess(process2, (ProgressIndicator)new EmptyProgressIndicator());
            }
            catch (ProcessCanceledException e) {
                return false;
            }
            return true;
        }
        CompletableFuture<@NotNull ProgressWindow> progress2 = this.createProgressWindowAsyncIfNeeded(progressTitle2, canBeCanceled, shouldShowModalWindow, project, parentComponent, cancelText);
        ProgressRunner progressRunner2 = new ProgressRunner(process2).sync().onThread(ProgressRunner.ThreadToUse.POOLED).modal().withProgress(progress2);
        ProgressResult result2 = progressRunner2.submitAndGet();
        Throwable exception = result2.getThrowable();
        if (!(exception instanceof ProcessCanceledException)) {
            ExceptionUtil.rethrowUnchecked((Throwable)exception);
        }
        return !result2.isCanceled();
    }

    public void invokeAndWait(@NotNull Runnable runnable2, @NotNull ModalityState modalityState) {
        if (runnable2 == null) {
            ApplicationImpl.$$$reportNull$$$0(17);
        }
        if (modalityState == null) {
            ApplicationImpl.$$$reportNull$$$0(18);
        }
        if (this.isDispatchThread()) {
            runnable2.run();
            return;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            this.runIntendedWriteActionOnCurrentThread(runnable2);
            return;
        }
        if (this.holdsReadLock()) {
            throw new IllegalStateException("Calling invokeAndWait from read-action leads to possible deadlock.");
        }
        Runnable r = this.myTransactionGuard.wrapLaterInvocation(runnable2, modalityState);
        LaterInvocator.invokeAndWait(() -> this.runIntendedWriteActionOnCurrentThread(r), modalityState);
    }

    public void invokeAndWait(@NotNull Runnable runnable2) throws ProcessCanceledException {
        if (runnable2 == null) {
            ApplicationImpl.$$$reportNull$$$0(19);
        }
        this.invokeAndWait(runnable2, ModalityState.defaultModalityState());
    }

    @NotNull
    public ModalityState getCurrentModalityState() {
        ModalityStateEx modalityStateEx = LaterInvocator.getCurrentModalityState();
        if (modalityStateEx == null) {
            ApplicationImpl.$$$reportNull$$$0(20);
        }
        return modalityStateEx;
    }

    @NotNull
    public ModalityState getModalityStateForComponent(@NotNull Component c) {
        Window window;
        if (c == null) {
            ApplicationImpl.$$$reportNull$$$0(21);
        }
        if ((window = ComponentUtil.getWindow((Component)c)) == null) {
            ModalityState modalityState = this.getNoneModalityState();
            if (modalityState == null) {
                ApplicationImpl.$$$reportNull$$$0(22);
            }
            return modalityState;
        }
        ModalityStateEx modalityStateEx = LaterInvocator.modalityStateForWindow(window);
        if (modalityStateEx == null) {
            ApplicationImpl.$$$reportNull$$$0(23);
        }
        return modalityStateEx;
    }

    @NotNull
    public ModalityState getAnyModalityState() {
        AnyModalityState anyModalityState = AnyModalityState.ANY;
        if (anyModalityState == null) {
            ApplicationImpl.$$$reportNull$$$0(24);
        }
        return anyModalityState;
    }

    @NotNull
    public ModalityState getDefaultModalityState() {
        ModalityState modalityState = this.isDispatchThread() ? this.getCurrentModalityState() : CoreProgressManager.getCurrentThreadProgressModality();
        if (modalityState == null) {
            ApplicationImpl.$$$reportNull$$$0(25);
        }
        return modalityState;
    }

    @NotNull
    public ModalityState getNoneModalityState() {
        ModalityState modalityState = ModalityState.NON_MODAL;
        if (modalityState == null) {
            ApplicationImpl.$$$reportNull$$$0(26);
        }
        return modalityState;
    }

    public long getStartTime() {
        return this.myStartTime;
    }

    public long getIdleTime() {
        return IdeEventQueue.getInstance().getIdleTime();
    }

    @Override
    public final void restart(boolean exitConfirmed) {
        int flags = 4;
        if (exitConfirmed) {
            flags |= 2;
        }
        this.exit(flags, true, ArrayUtilRt.EMPTY_STRING_ARRAY);
    }

    @Override
    public final void restart(boolean exitConfirmed, boolean elevate) {
        int flags = 4;
        if (exitConfirmed) {
            flags |= 2;
        }
        if (elevate) {
            flags |= 8;
        }
        this.exit(flags, true, ArrayUtilRt.EMPTY_STRING_ARRAY);
    }

    public final void exit(boolean force, boolean exitConfirmed, boolean restart) {
        int flags = 4;
        if (force) {
            flags |= 1;
        }
        if (exitConfirmed) {
            flags |= 2;
        }
        this.exit(flags, restart, ArrayUtilRt.EMPTY_STRING_ARRAY);
    }

    public void restart(int flags, String @NotNull [] beforeRestart) {
        if (beforeRestart == null) {
            ApplicationImpl.$$$reportNull$$$0(27);
        }
        this.exit(flags, true, beforeRestart);
    }

    @Override
    public final void exit(int flags) {
        this.exit(flags, false, ArrayUtil.EMPTY_STRING_ARRAY);
    }

    private void exit(int flags, boolean restart, String @NotNull [] beforeRestart) {
        if (beforeRestart == null) {
            ApplicationImpl.$$$reportNull$$$0(28);
        }
        if (!BitUtil.isSet((int)flags, (int)1) && (this.myExitInProgress || !BitUtil.isSet((int)flags, (int)2) && this.getDefaultModalityState() != ModalityState.NON_MODAL)) {
            return;
        }
        this.myExitInProgress = true;
        if (this.isDispatchThread()) {
            this.doExit(flags, restart, beforeRestart);
        } else {
            this.invokeLater(() -> this.doExit(flags, restart, beforeRestart), ModalityState.NON_MODAL);
        }
    }

    @Override
    public final boolean isExitInProgress() {
        return this.myExitInProgress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doExit(int flags, boolean restart, String @NotNull [] beforeRestart) {
        if (beforeRestart == null) {
            ApplicationImpl.$$$reportNull$$$0(29);
        }
        boolean force = BitUtil.isSet((int)flags, (int)1);
        try {
            boolean success2;
            if (!force && !ApplicationImpl.confirmExitIfNeeded(BitUtil.isSet((int)flags, (int)2))) {
                return;
            }
            AppLifecycleListener lifecycleListener = (AppLifecycleListener)this.getMessageBus().syncPublisher(AppLifecycleListener.TOPIC);
            lifecycleListener.appClosing();
            if (!force && !this.canExit()) {
                return;
            }
            this.stopServicePreloading();
            if (ApplicationImpl.isInstantShutdownPossible()) {
                for (Frame frame : Frame.getFrames()) {
                    frame.setVisible(false);
                }
            }
            try {
                lifecycleListener.appWillBeClosed(restart);
            }
            catch (Throwable t) {
                LOG.error(t);
            }
            LifecycleUsageTriggerCollector.onIdeClose(restart);
            if (BitUtil.isSet((int)flags, (int)4)) {
                SaveAndSyncHandler.getInstance().saveSettingsUnderModalProgress((ComponentManager)this);
            }
            if (!(success2 = this.disposeSelf(!force)) || this.isUnitTestMode() || Boolean.getBoolean("idea.test.guimode")) {
                if (Boolean.getBoolean("idea.test.guimode")) {
                    ApplicationImpl.shutdown();
                }
                return;
            }
            int exitCode = 0;
            if (restart && Restarter.isSupported()) {
                try {
                    Restarter.scheduleRestart(BitUtil.isSet((int)flags, (int)8), beforeRestart);
                }
                catch (Throwable t) {
                    LOG.error("Restart failed", t);
                    Main.showMessage((String)BootstrapBundle.message((String)"restart.failed.title", (Object[])new Object[0]), (Throwable)t);
                    exitCode = 2;
                }
            }
            IdeaLogger.dropFrequentExceptionsCaches();
            System.exit(exitCode);
        }
        finally {
            this.myExitInProgress = false;
        }
    }

    private static boolean isInstantShutdownPossible() {
        if (!Registry.is((String)"ide.instant.shutdown")) {
            return false;
        }
        return !ProgressManager.getInstance().hasProgressIndicator();
    }

    @NotNull
    public final @NotNull CompletableFuture<@NotNull ProgressWindow> createProgressWindowAsyncIfNeeded(@NotNull @NlsContexts.ProgressTitle String progressTitle2, boolean canBeCanceled, boolean shouldShowModalWindow, @Nullable Project project, @Nullable JComponent parentComponent, @Nullable @NlsContexts.Button String cancelText) {
        if (progressTitle2 == null) {
            ApplicationImpl.$$$reportNull$$$0(30);
        }
        if (SwingUtilities.isEventDispatchThread()) {
            CompletableFuture<ProgressWindow> completableFuture = CompletableFuture.completedFuture(this.createProgressWindow(progressTitle2, canBeCanceled, shouldShowModalWindow, project, parentComponent, cancelText));
            if (completableFuture == null) {
                ApplicationImpl.$$$reportNull$$$0(31);
            }
            return completableFuture;
        }
        CompletableFuture<ProgressWindow> completableFuture = CompletableFuture.supplyAsync(() -> this.createProgressWindow(progressTitle2, canBeCanceled, shouldShowModalWindow, project, parentComponent, cancelText), this::invokeLater);
        if (completableFuture == null) {
            ApplicationImpl.$$$reportNull$$$0(32);
        }
        return completableFuture;
    }

    @NotNull
    private ProgressWindow createProgressWindow(@NotNull @NlsContexts.ProgressTitle String progressTitle2, boolean canBeCanceled, boolean shouldShowModalWindow, @Nullable Project project, @Nullable JComponent parentComponent, @Nullable @NlsContexts.Button String cancelText) {
        if (progressTitle2 == null) {
            ApplicationImpl.$$$reportNull$$$0(33);
        }
        ProgressWindow progress2 = new ProgressWindow(canBeCanceled, !shouldShowModalWindow, project, parentComponent, cancelText);
        Disposer.register((Disposable)this, (Disposable)progress2);
        progress2.setTitle(progressTitle2);
        ProgressWindow progressWindow = progress2;
        if (progressWindow == null) {
            ApplicationImpl.$$$reportNull$$$0(34);
        }
        return progressWindow;
    }

    private static void shutdown() {
        IdeEventQueue.applicationClose();
        ShutDownTracker.getInstance().run();
    }

    private static boolean confirmExitIfNeeded(boolean exitConfirmed) {
        final boolean hasUnsafeBgTasks = ProgressManager.getInstance().hasUnsafeProgressIndicator();
        if (exitConfirmed && !hasUnsafeBgTasks) {
            return true;
        }
        DialogWrapper.DoNotAskOption option2 = new DialogWrapper.DoNotAskOption(){

            public boolean isToBeShown() {
                return GeneralSettings.getInstance().isConfirmExit() && ProjectManager.getInstance().getOpenProjects().length > 0;
            }

            public void setToBeShown(boolean value2, int exitCode) {
                GeneralSettings.getInstance().setConfirmExit(value2);
            }

            public boolean canBeHidden() {
                return !hasUnsafeBgTasks;
            }

            public boolean shouldSaveOptionsOnCancel() {
                return false;
            }

            @NotNull
            public String getDoNotShowMessage() {
                String string = IdeBundle.message((String)"do.not.ask.me.again", (Object[])new Object[0]);
                if (string == null) {
                    3.$$$reportNull$$$0(0);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/impl/ApplicationImpl$3", "getDoNotShowMessage"));
            }
        };
        if (!hasUnsafeBgTasks && !option2.isToBeShown()) {
            return true;
        }
        final AtomicBoolean alreadyGone = new AtomicBoolean(false);
        if (hasUnsafeBgTasks) {
            final Runnable dialogRemover = Messages.createMessageDialogRemover(null);
            Runnable task2 = new Runnable(){

                @Override
                public void run() {
                    if (alreadyGone.get()) {
                        return;
                    }
                    if (!ProgressManager.getInstance().hasUnsafeProgressIndicator()) {
                        alreadyGone.set(true);
                        dialogRemover.run();
                    } else {
                        AppExecutorUtil.getAppScheduledExecutorService().schedule(this, 1L, TimeUnit.SECONDS);
                    }
                }
            };
            AppExecutorUtil.getAppScheduledExecutorService().schedule(task2, 1L, TimeUnit.SECONDS);
        }
        String message2 = ApplicationBundle.message((String)(hasUnsafeBgTasks ? "exit.confirm.prompt.tasks" : "exit.confirm.prompt"), (Object[])new Object[0]);
        exitConfirmed = ((MessageDialogBuilder.YesNo)((MessageDialogBuilder.YesNo)((MessageDialogBuilder.YesNo)MessageDialogBuilder.yesNo((String)ApplicationBundle.message((String)"exit.confirm.title", (Object[])new Object[0]), (String)message2).yesText(ApplicationBundle.message((String)"command.exit", (Object[])new Object[0]))).noText(CommonBundle.getCancelButtonText())).doNotAsk(option2)).guessWindowAndAsk();
        if (alreadyGone.getAndSet(true)) {
            if (!option2.isToBeShown()) {
                return true;
            }
            exitConfirmed = ((OkCancelDialogBuilder)((OkCancelDialogBuilder)MessageDialogBuilder.okCancel((String)ApplicationBundle.message((String)"exit.confirm.title", (Object[])new Object[0]), (String)ApplicationBundle.message((String)"exit.confirm.prompt", (Object[])new Object[0])).yesText(ApplicationBundle.message((String)"command.exit", (Object[])new Object[0]))).doNotAsk(option2)).guessWindowAndAsk();
        }
        return exitConfirmed;
    }

    private boolean canExit() {
        Project[] projects;
        for (ApplicationListener applicationListener : this.myDispatcher.getListeners()) {
            if (applicationListener.canExitApplication()) continue;
            return false;
        }
        ProjectManagerEx projectManager = ProjectManagerEx.getInstanceExIfCreated();
        if (projectManager == null) {
            return true;
        }
        for (Project project : projects = projectManager.getOpenProjects()) {
            if (projectManager.canClose(project)) continue;
            return false;
        }
        return true;
    }

    public boolean isCurrentWriteOnEdt() {
        return EDT.isEdt((Thread)this.myLock.writeThread);
    }

    public void invokeLaterOnWriteThread(@NotNull Runnable action2, @NotNull ModalityState modal) {
        if (action2 == null) {
            ApplicationImpl.$$$reportNull$$$0(35);
        }
        if (modal == null) {
            ApplicationImpl.$$$reportNull$$$0(36);
        }
        this.invokeLaterOnWriteThread(action2, modal, this.getDisposed());
    }

    public void invokeLaterOnWriteThread(@NotNull Runnable action2, @NotNull ModalityState modal, @NotNull Condition<?> expired) {
        if (action2 == null) {
            ApplicationImpl.$$$reportNull$$$0(37);
        }
        if (modal == null) {
            ApplicationImpl.$$$reportNull$$$0(38);
        }
        if (expired == null) {
            ApplicationImpl.$$$reportNull$$$0(39);
        }
        Runnable r = this.myTransactionGuard.wrapLaterInvocation(action2, modal);
        LaterInvocator.invokeLaterWithCallback(() -> this.runIntendedWriteActionOnCurrentThread(r), modal, expired, null, !USE_SEPARATE_WRITE_THREAD);
    }

    public void invokeLaterOnWriteThread(@NotNull Runnable action2) {
        if (action2 == null) {
            ApplicationImpl.$$$reportNull$$$0(40);
        }
        this.invokeLaterOnWriteThread(action2, ModalityState.defaultModalityState());
    }

    @Override
    public void runIntendedWriteActionOnCurrentThread(@NotNull Runnable action2) {
        if (action2 == null) {
            ApplicationImpl.$$$reportNull$$$0(41);
        }
        if (this.isWriteThread()) {
            action2.run();
        } else {
            this.acquireWriteIntentLock(action2.getClass().getName());
            try {
                action2.run();
            }
            finally {
                this.releaseWriteIntentLock();
            }
        }
    }

    @Override
    public <T, E extends Throwable> T runUnlockingIntendedWrite(@NotNull ThrowableComputable<T, E> action2) throws E {
        if (action2 == null) {
            ApplicationImpl.$$$reportNull$$$0(42);
        }
        if (this.isWriteThread() && USE_SEPARATE_WRITE_THREAD) {
            this.releaseWriteIntentLock();
            try {
                Object object = action2.compute();
                return (T)object;
            }
            finally {
                this.acquireWriteIntentLock(action2.getClass().getName());
            }
        }
        return (T)action2.compute();
    }

    public void runReadAction(@NotNull Runnable action2) {
        if (action2 == null) {
            ApplicationImpl.$$$reportNull$$$0(43);
        }
        ReadMostlyRWLock.Reader status = this.myLock.startRead();
        try {
            action2.run();
        }
        finally {
            if (status != null) {
                this.myLock.endRead(status);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T runReadAction(@NotNull Computable<T> computation) {
        if (computation == null) {
            ApplicationImpl.$$$reportNull$$$0(44);
        }
        ReadMostlyRWLock.Reader status = this.myLock.startRead();
        try {
            Object object = computation.compute();
            return (T)object;
        }
        finally {
            if (status != null) {
                this.myLock.endRead(status);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T, E extends Throwable> T runReadAction(@NotNull ThrowableComputable<T, E> computation) throws E {
        if (computation == null) {
            ApplicationImpl.$$$reportNull$$$0(45);
        }
        ReadMostlyRWLock.Reader status = this.myLock.startRead();
        try {
            Object object = computation.compute();
            return (T)object;
        }
        finally {
            if (status != null) {
                this.myLock.endRead(status);
            }
        }
    }

    @Override
    public void acquireWriteIntentLock(@NotNull String invokedClassFqn) {
        if (invokedClassFqn == null) {
            ApplicationImpl.$$$reportNull$$$0(46);
        }
        this.myLock.writeIntentLock();
    }

    @Override
    public void releaseWriteIntentLock() {
        this.myLock.writeIntentUnlock();
    }

    @Override
    @ApiStatus.Experimental
    public boolean runWriteActionWithNonCancellableProgressInDispatchThread(@NotNull @NlsContexts.ProgressTitle String title2, @Nullable Project project, @Nullable JComponent parentComponent, @NotNull Consumer<? super ProgressIndicator> action2) {
        if (title2 == null) {
            ApplicationImpl.$$$reportNull$$$0(47);
        }
        if (action2 == null) {
            ApplicationImpl.$$$reportNull$$$0(48);
        }
        return this.runEdtProgressWriteAction(title2, project, parentComponent, null, action2);
    }

    @Override
    @ApiStatus.Experimental
    public boolean runWriteActionWithCancellableProgressInDispatchThread(@NotNull @NlsContexts.ProgressTitle String title2, @Nullable Project project, @Nullable JComponent parentComponent, @NotNull Consumer<? super ProgressIndicator> action2) {
        if (title2 == null) {
            ApplicationImpl.$$$reportNull$$$0(49);
        }
        if (action2 == null) {
            ApplicationImpl.$$$reportNull$$$0(50);
        }
        return this.runEdtProgressWriteAction(title2, project, parentComponent, IdeBundle.message((String)"action.stop", (Object[])new Object[0]), action2);
    }

    private boolean runEdtProgressWriteAction(@NotNull @NlsContexts.ProgressTitle String title2, @Nullable Project project, @Nullable JComponent parentComponent, @Nullable @Nls(capitalization=Nls.Capitalization.Title) String cancelText, @NotNull Consumer<? super ProgressIndicator> action2) {
        if (title2 == null) {
            ApplicationImpl.$$$reportNull$$$0(51);
        }
        if (action2 == null) {
            ApplicationImpl.$$$reportNull$$$0(52);
        }
        if (!USE_SEPARATE_WRITE_THREAD) {
            return (Boolean)this.runWriteActionWithClass(action2.getClass(), () -> {
                PotemkinProgress indicator2 = new PotemkinProgress(title2, project, parentComponent, cancelText);
                indicator2.runInSwingThread(() -> action2.accept(indicator2));
                return !indicator2.isCanceled();
            });
        }
        ProgressWindow progress2 = this.createProgressWindow(title2, cancelText != null, true, project, parentComponent, cancelText);
        ProgressResult result2 = new ProgressRunner(() -> this.runWriteAction(() -> action2.accept(progress2))).sync().onThread(ProgressRunner.ThreadToUse.WRITE).withProgress(progress2).modal().submitAndGet();
        if (result2.getThrowable() instanceof RuntimeException) {
            throw (RuntimeException)result2.getThrowable();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T, E extends Throwable> T runWriteActionWithClass(@NotNull Class<?> clazz, @NotNull ThrowableComputable<T, E> computable) throws E {
        if (clazz == null) {
            ApplicationImpl.$$$reportNull$$$0(53);
        }
        if (computable == null) {
            ApplicationImpl.$$$reportNull$$$0(54);
        }
        this.startWrite(clazz);
        try {
            Object object = computable.compute();
            return (T)object;
        }
        finally {
            this.endWrite(clazz);
        }
    }

    public void runWriteAction(@NotNull Runnable action2) {
        if (action2 == null) {
            ApplicationImpl.$$$reportNull$$$0(55);
        }
        Class<?> clazz = action2.getClass();
        this.startWrite(clazz);
        try {
            action2.run();
        }
        finally {
            this.endWrite(clazz);
        }
    }

    public <T> T runWriteAction(@NotNull Computable<T> computation) {
        if (computation == null) {
            ApplicationImpl.$$$reportNull$$$0(56);
        }
        return this.runWriteActionWithClass(computation.getClass(), () -> computation.compute());
    }

    public <T, E extends Throwable> T runWriteAction(@NotNull ThrowableComputable<T, E> computation) throws E {
        if (computation == null) {
            ApplicationImpl.$$$reportNull$$$0(57);
        }
        return this.runWriteActionWithClass(computation.getClass(), computation);
    }

    public boolean hasWriteAction(@NotNull Class<?> actionClass) {
        if (actionClass == null) {
            ApplicationImpl.$$$reportNull$$$0(58);
        }
        this.assertReadAccessAllowed();
        for (int i2 = this.myWriteActionsStack.size() - 1; i2 >= 0; --i2) {
            Class action2 = (Class)this.myWriteActionsStack.get(i2);
            if (actionClass != action2 && !ReflectionUtil.isAssignable(actionClass, (Class)action2)) continue;
            return true;
        }
        return false;
    }

    public void assertReadAccessAllowed() {
        if (!this.isReadAccessAllowed()) {
            LOG.error("Read access is allowed from inside read-action (or EDT) only (see com.intellij.openapi.application.Application.runReadAction())", new String[]{"Current thread: " + ApplicationImpl.describe(Thread.currentThread()), "; dispatch thread: " + EventQueue.isDispatchThread() + "; isDispatchThread(): " + this.isDispatchThread(), "SystemEventQueueThread: " + ApplicationImpl.describe(ApplicationImpl.getEventQueueThread())});
        }
    }

    public void assertReadAccessNotAllowed() {
        if (this.isReadAccessAllowed()) {
            LOG.error("Read access is not allowed", new String[]{"Current thread: " + ApplicationImpl.describe(Thread.currentThread()), "; dispatch thread: " + EventQueue.isDispatchThread() + "; isDispatchThread(): " + this.isDispatchThread(), "SystemEventQueueThread: " + ApplicationImpl.describe(ApplicationImpl.getEventQueueThread())});
        }
    }

    private static String describe(Thread o) {
        return o == null ? "null" : o + " " + System.identityHashCode(o);
    }

    private static Thread getEventQueueThread() {
        EventQueue eventQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
        return AWTAccessor.getEventQueueAccessor().getDispatchThread(eventQueue);
    }

    public boolean isReadAccessAllowed() {
        return this.isWriteThread() || this.myLock.isReadLockedByThisThread();
    }

    public void assertIsDispatchThread() {
        if (this.isDispatchThread()) {
            return;
        }
        if (ShutDownTracker.isShutdownHookRunning()) {
            return;
        }
        ApplicationImpl.throwThreadAccessException("Access is allowed from event dispatch thread only");
    }

    public void assertIsNonDispatchThread() {
        if (this.isUnitTestMode() || this.isHeadlessEnvironment()) {
            return;
        }
        if (!this.isDispatchThread()) {
            return;
        }
        if (ShutDownTracker.isShutdownHookRunning()) {
            return;
        }
        ApplicationImpl.throwThreadAccessException("Access from event dispatch thread is not allowed.");
    }

    public void assertIsWriteThread() {
        if (this.isWriteThread()) {
            return;
        }
        if (ShutDownTracker.isShutdownHookRunning()) {
            return;
        }
        this.assertIsWriteThread("Access is allowed from write thread only.");
    }

    private static void throwThreadAccessException(@NotNull String message2) {
        if (message2 == null) {
            ApplicationImpl.$$$reportNull$$$0(59);
        }
        throw new RuntimeExceptionWithAttachments(message2, "EventQueue.isDispatchThread()=" + EventQueue.isDispatchThread() + " Toolkit.getEventQueue()=" + Toolkit.getDefaultToolkit().getSystemEventQueue() + "\nCurrent thread: " + ApplicationImpl.describe(Thread.currentThread()) + "\nSystemEventQueueThread: " + ApplicationImpl.describe(ApplicationImpl.getEventQueueThread()), new Attachment[]{new Attachment("threadDump.txt", ThreadDumper.dumpThreadsToString())});
    }

    private void assertIsWriteThread(@NotNull String message2) {
        if (message2 == null) {
            ApplicationImpl.$$$reportNull$$$0(60);
        }
        if (this.isWriteThread()) {
            return;
        }
        throw new RuntimeExceptionWithAttachments(message2, "EventQueue.isDispatchThread()=" + EventQueue.isDispatchThread() + " Toolkit.getEventQueue()=" + Toolkit.getDefaultToolkit().getSystemEventQueue() + "\nCurrent thread: " + ApplicationImpl.describe(Thread.currentThread()) + "\nWrite thread: " + ApplicationImpl.describe(this.myLock.writeThread), new Attachment[]{new Attachment("threadDump.txt", ThreadDumper.dumpThreadsToString())});
    }

    @Override
    public void assertIsDispatchThread(@Nullable JComponent component2) {
        if (component2 == null) {
            return;
        }
        if (this.isDispatchThread()) {
            return;
        }
        if (Boolean.TRUE.equals(component2.getClientProperty(WAS_EVER_SHOWN))) {
            this.assertIsDispatchThread();
        } else {
            JRootPane root = component2.getRootPane();
            if (root != null) {
                component2.putClientProperty(WAS_EVER_SHOWN, Boolean.TRUE);
                this.assertIsDispatchThread();
            }
        }
    }

    @Override
    public void assertTimeConsuming() {
        if (this.myTestModeFlag || this.myHeadlessMode || ShutDownTracker.isShutdownHookRunning()) {
            return;
        }
        LOG.assertTrue(!this.isDispatchThread(), (Object)"This operation is time consuming and must not be called on EDT");
    }

    @Override
    public boolean tryRunReadAction(@NotNull Runnable action2) {
        ReadMostlyRWLock.Reader status;
        if (action2 == null) {
            ApplicationImpl.$$$reportNull$$$0(61);
        }
        if ((status = this.myLock.startTryRead()) != null && !status.readRequested) {
            return false;
        }
        try {
            action2.run();
        }
        finally {
            if (status != null) {
                this.myLock.endRead(status);
            }
        }
        return true;
    }

    public boolean isActive() {
        if (this.isHeadlessEnvironment()) {
            return true;
        }
        if (this.isDisposed()) {
            return false;
        }
        Window activeWindow = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
        if (activeWindow != null) {
            ApplicationActivationStateManager.updateState(this, activeWindow);
        }
        return ApplicationActivationStateManager.isActive();
    }

    @NotNull
    public AccessToken acquireReadActionLock() {
        DeprecatedMethodException.report((String)"Use runReadAction() instead");
        return this.isWriteThread() || this.myLock.isReadLockedByThisThread() ? AccessToken.EMPTY_ACCESS_TOKEN : new ReadAccessToken();
    }

    @Override
    public boolean isWriteActionPending() {
        return this.myWriteActionPending;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startWrite(@NotNull Class<?> clazz) {
        if (clazz == null) {
            ApplicationImpl.$$$reportNull$$$0(62);
        }
        if (!this.isWriteAccessAllowed()) {
            this.assertIsWriteThread("Write access is allowed from write thread only");
        }
        boolean writeActionPending = this.myWriteActionPending;
        this.myWriteActionPending = true;
        try {
            ActivityTracker.getInstance().inc();
            this.fireBeforeWriteActionStart(clazz);
            if (!this.myLock.isWriteLocked()) {
                long elapsed;
                int delay = Holder.ourDumpThreadsOnLongWriteActionWaiting;
                ScheduledFuture<?> reportSlowWrite = delay <= 0 ? null : AppExecutorUtil.getAppScheduledExecutorService().scheduleWithFixedDelay(() -> PerformanceWatcher.getInstance().dumpThreads("waiting", true), delay, delay, TimeUnit.MILLISECONDS);
                long t = LOG.isDebugEnabled() ? System.currentTimeMillis() : 0L;
                this.myLock.writeLock();
                if (LOG.isDebugEnabled() && (elapsed = System.currentTimeMillis() - t) != 0L) {
                    LOG.debug("Write action wait time: " + elapsed);
                }
                if (reportSlowWrite != null) {
                    reportSlowWrite.cancel(false);
                }
            }
        }
        finally {
            this.myWriteActionPending = writeActionPending;
        }
        this.myWriteActionsStack.push(clazz);
        this.fireWriteActionStarted(clazz);
    }

    private void endWrite(@NotNull Class<?> clazz) {
        if (clazz == null) {
            ApplicationImpl.$$$reportNull$$$0(63);
        }
        try {
            this.fireWriteActionFinished(clazz);
        }
        finally {
            this.myWriteActionsStack.pop();
            if (this.myWriteActionsStack.size() == this.myWriteStackBase) {
                this.myLock.writeUnlock();
            }
            if (this.myWriteActionsStack.isEmpty()) {
                this.fireAfterWriteActionFinished(clazz);
            }
        }
    }

    @NotNull
    public AccessToken acquireWriteActionLock(@NotNull Class<?> clazz) {
        if (clazz == null) {
            ApplicationImpl.$$$reportNull$$$0(64);
        }
        DeprecatedMethodException.report((String)"Use runWriteAction() instead");
        return new WriteAccessToken(clazz);
    }

    public void assertWriteAccessAllowed() {
        LOG.assertTrue(this.isWriteAccessAllowed(), (Object)"Write access is allowed inside write-action only (see com.intellij.openapi.application.Application.runWriteAction())");
    }

    public boolean isWriteAccessAllowed() {
        return this.isWriteThread() && this.myLock.isWriteLocked();
    }

    @Override
    public boolean isWriteActionInProgress() {
        return this.myLock.isWriteLocked();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeSuspendingWriteAction(@Nullable Project project, @NotNull @NlsContexts.DialogTitle String title2, @NotNull Runnable runnable2) {
        if (title2 == null) {
            ApplicationImpl.$$$reportNull$$$0(65);
        }
        if (runnable2 == null) {
            ApplicationImpl.$$$reportNull$$$0(66);
        }
        this.assertIsWriteThread();
        if (!this.myLock.isWriteLocked()) {
            ApplicationImpl.runModalProgress(project, title2, runnable2);
            return;
        }
        int prevBase = this.myWriteStackBase;
        this.myWriteStackBase = this.myWriteActionsStack.size();
        try (AccessToken ignored = this.myLock.writeSuspend();){
            ApplicationImpl.runModalProgress(project, title2, runnable2);
        }
        finally {
            this.myWriteStackBase = prevBase;
        }
    }

    private static void runModalProgress(@Nullable Project project, @NotNull @NlsContexts.DialogTitle String title2, final @NotNull Runnable runnable2) {
        if (title2 == null) {
            ApplicationImpl.$$$reportNull$$$0(67);
        }
        if (runnable2 == null) {
            ApplicationImpl.$$$reportNull$$$0(68);
        }
        ProgressManager.getInstance().run((Task)new Task.Modal(project, title2, false){

            public void run(@NotNull ProgressIndicator indicator2) {
                if (indicator2 == null) {
                    5.$$$reportNull$$$0(0);
                }
                runnable2.run();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/application/impl/ApplicationImpl$5", "run"));
            }
        });
    }

    public void addApplicationListener(@NotNull ApplicationListener l) {
        if (l == null) {
            ApplicationImpl.$$$reportNull$$$0(69);
        }
        this.myDispatcher.addListener((EventListener)l);
    }

    public void addApplicationListener(@NotNull ApplicationListener l, @NotNull Disposable parent) {
        if (l == null) {
            ApplicationImpl.$$$reportNull$$$0(70);
        }
        if (parent == null) {
            ApplicationImpl.$$$reportNull$$$0(71);
        }
        this.myDispatcher.addListener((EventListener)l, parent);
    }

    public void removeApplicationListener(@NotNull ApplicationListener l) {
        if (l == null) {
            ApplicationImpl.$$$reportNull$$$0(72);
        }
        this.myDispatcher.removeListener((EventListener)l);
    }

    private void fireBeforeWriteActionStart(@NotNull Class<?> action2) {
        if (action2 == null) {
            ApplicationImpl.$$$reportNull$$$0(73);
        }
        ((ApplicationListener)this.myDispatcher.getMulticaster()).beforeWriteActionStart(action2);
    }

    private void fireWriteActionStarted(@NotNull Class<?> action2) {
        if (action2 == null) {
            ApplicationImpl.$$$reportNull$$$0(74);
        }
        ((ApplicationListener)this.myDispatcher.getMulticaster()).writeActionStarted(action2);
    }

    private void fireWriteActionFinished(@NotNull Class<?> action2) {
        if (action2 == null) {
            ApplicationImpl.$$$reportNull$$$0(75);
        }
        ((ApplicationListener)this.myDispatcher.getMulticaster()).writeActionFinished(action2);
    }

    private void fireAfterWriteActionFinished(@NotNull Class<?> action2) {
        if (action2 == null) {
            ApplicationImpl.$$$reportNull$$$0(76);
        }
        ((ApplicationListener)this.myDispatcher.getMulticaster()).afterWriteActionFinished(action2);
    }

    public void saveSettings() {
        if (this.mySaveAllowed) {
            StoreUtil.saveSettings(this, false);
        }
    }

    public void saveAll() {
        StoreUtil.saveDocumentsAndProjectsAndApp(false);
    }

    @Override
    public void setSaveAllowed(boolean value2) {
        this.mySaveAllowed = value2;
    }

    @Override
    public boolean isSaveAllowed() {
        return this.mySaveAllowed;
    }

    public boolean isRestartCapable() {
        return Restarter.isSupported();
    }

    public String toString() {
        return "Application (containerState=" + this.getContainerStateName() + ") " + (this.isUnitTestMode() ? " (Unit test)" : "") + (this.isInternal() ? " (Internal)" : "") + (this.isHeadlessEnvironment() ? " (Headless)" : "") + (this.isCommandLine() ? " (Command line)" : "");
    }

    @Override
    @NotNull
    public String activityNamePrefix() {
        return "app ";
    }

    @Override
    @NotNull
    protected ContainerDescriptor getContainerDescriptor(@NotNull IdeaPluginDescriptorImpl pluginDescriptor) {
        if (pluginDescriptor == null) {
            ApplicationImpl.$$$reportNull$$$0(77);
        }
        ContainerDescriptor containerDescriptor = pluginDescriptor.appContainerDescriptor;
        if (containerDescriptor == null) {
            ApplicationImpl.$$$reportNull$$$0(78);
        }
        return containerDescriptor;
    }

    @Override
    protected void logMessageBusDelivery(@NotNull Topic<?> topic, @NotNull String messageName, @NotNull Object handler2, long duration) {
        if (topic == null) {
            ApplicationImpl.$$$reportNull$$$0(79);
        }
        if (messageName == null) {
            ApplicationImpl.$$$reportNull$$$0(80);
        }
        if (handler2 == null) {
            ApplicationImpl.$$$reportNull$$$0(81);
        }
        super.logMessageBusDelivery(topic, messageName, handler2, duration);
        if (topic == ProjectManager.TOPIC) {
            long start2 = StartUpMeasurer.getCurrentTime() - duration;
            StartUpMeasurer.addCompletedActivity((long)start2, handler2.getClass(), (ActivityCategory)ActivityCategory.PROJECT_OPEN_HANDLER, null, (long)StartUpMeasurer.MEASURE_THRESHOLD);
        } else if (topic == VirtualFileManager.VFS_CHANGES && TimeUnit.NANOSECONDS.toMillis(duration) > 50L) {
            LOG.info(String.format("LONG VFS PROCESSING. Topic=%s, offender=%s, message=%s, time=%dms", topic.getDisplayName(), handler2.getClass(), messageName, TimeUnit.NANOSECONDS.toMillis(duration)));
        }
    }

    @TestOnly
    void disableEventsUntil(@NotNull Disposable disposable2) {
        if (disposable2 == null) {
            ApplicationImpl.$$$reportNull$$$0(82);
        }
        this.myDispatcher.neuterMultiCasterWhilePerformanceTestIsRunningUntil(disposable2);
    }

    @Override
    public boolean isComponentCreated() {
        return this.getContainerState().get().compareTo(ComponentManagerImpl.ContainerState.COMPONENT_CREATED) >= 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 31: 
            case 32: 
            case 34: 
            case 78: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 31: 
            case 32: 
            case 34: 
            case 78: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 1: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 17: 
            case 19: 
            case 66: 
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 2: 
            case 4: 
            case 35: 
            case 37: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 48: 
            case 50: 
            case 52: 
            case 55: 
            case 61: 
            case 73: 
            case 74: 
            case 75: 
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 31: 
            case 32: 
            case 34: 
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/application/impl/ApplicationImpl";
                break;
            }
            case 9: 
            case 14: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expired";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "process";
                break;
            }
            case 16: 
            case 30: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressTitle";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modalityState";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beforeRestart";
                break;
            }
            case 36: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modal";
                break;
            }
            case 44: 
            case 45: 
            case 56: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computation";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "invokedClassFqn";
                break;
            }
            case 47: 
            case 49: 
            case 51: 
            case 65: 
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 53: 
            case 62: 
            case 63: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computable";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionClass";
                break;
            }
            case 59: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 69: 
            case 70: 
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "l";
                break;
            }
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginDescriptor";
                break;
            }
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "topic";
                break;
            }
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageName";
                break;
            }
            case 81: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/application/impl/ApplicationImpl";
                break;
            }
            case 3: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "executeOnPooledThread";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getInvokator";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentModalityState";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getModalityStateForComponent";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnyModalityState";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultModalityState";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getNoneModalityState";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "createProgressWindowAsyncIfNeeded";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "createProgressWindow";
                break;
            }
            case 78: {
                objectArray = objectArray2;
                objectArray2[1] = "getContainerDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "preventAwtAutoShutdown";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "executeByImpatientReader";
                break;
            }
            case 2: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "executeOnPooledThread";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 31: 
            case 32: 
            case 34: 
            case 78: {
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "invokeLater";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "runProcessWithProgressSynchronously";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "invokeAndWait";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getModalityStateForComponent";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "restart";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "exit";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "doExit";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "createProgressWindowAsyncIfNeeded";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "createProgressWindow";
                break;
            }
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "invokeLaterOnWriteThread";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "runIntendedWriteActionOnCurrentThread";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "runUnlockingIntendedWrite";
                break;
            }
            case 43: 
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "runReadAction";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "acquireWriteIntentLock";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "runWriteActionWithNonCancellableProgressInDispatchThread";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "runWriteActionWithCancellableProgressInDispatchThread";
                break;
            }
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "runEdtProgressWriteAction";
                break;
            }
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "runWriteActionWithClass";
                break;
            }
            case 55: 
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "runWriteAction";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "hasWriteAction";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "throwThreadAccessException";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "assertIsWriteThread";
                break;
            }
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "tryRunReadAction";
                break;
            }
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "startWrite";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "endWrite";
                break;
            }
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "acquireWriteActionLock";
                break;
            }
            case 65: 
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "executeSuspendingWriteAction";
                break;
            }
            case 67: 
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "runModalProgress";
                break;
            }
            case 69: 
            case 70: 
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "addApplicationListener";
                break;
            }
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "removeApplicationListener";
                break;
            }
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "fireBeforeWriteActionStart";
                break;
            }
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "fireWriteActionStarted";
                break;
            }
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "fireWriteActionFinished";
                break;
            }
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "fireAfterWriteActionFinished";
                break;
            }
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "getContainerDescriptor";
                break;
            }
            case 79: 
            case 80: 
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "logMessageBusDelivery";
                break;
            }
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "disableEventsUntil";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 31: 
            case 32: 
            case 34: 
            case 78: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @Deprecated
    private final class ReadAccessToken
    extends AccessToken {
        private final ReadMostlyRWLock.Reader myReader;

        private ReadAccessToken() {
            this.myReader = ApplicationImpl.this.myLock.startRead();
        }

        public void finish() {
            ApplicationImpl.this.myLock.endRead(this.myReader);
        }
    }

    private class WriteAccessToken
    extends AccessToken {
        @NotNull
        private final Class<?> clazz;

        WriteAccessToken(Class<?> clazz) {
            if (clazz == null) {
                WriteAccessToken.$$$reportNull$$$0(0);
            }
            this.clazz = clazz;
            ApplicationImpl.this.startWrite(clazz);
            this.markThreadNameInStackTrace();
        }

        public void finish() {
            try {
                ApplicationImpl.this.endWrite(this.clazz);
            }
            finally {
                this.unmarkThreadNameInStackTrace();
            }
        }

        private void markThreadNameInStackTrace() {
            String id2 = this.id();
            if (id2 != null) {
                Thread thread = Thread.currentThread();
                thread.setName(thread.getName() + id2);
            }
        }

        private void unmarkThreadNameInStackTrace() {
            String id2 = this.id();
            if (id2 != null) {
                Thread thread = Thread.currentThread();
                String name = thread.getName();
                name = StringUtil.replace((String)name, (String)id2, (String)"");
                thread.setName(name);
            }
        }

        @Nullable
        private String id() {
            Class<?> aClass = ((Object)((Object)this)).getClass();
            String name = aClass.getName();
            name = name.substring(name.lastIndexOf(46) + 1);
            if (!(name = name.substring(name.lastIndexOf(36) + 1)).equals("AccessToken")) {
                return " [" + name + "]";
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/openapi/application/impl/ApplicationImpl$WriteAccessToken", "<init>"));
        }
    }

    private static class Holder {
        private static final int ourDumpThreadsOnLongWriteActionWaiting = ApplicationManager.getApplication().isUnitTestMode() ? 0 : Integer.getInteger("dump.threads.on.long.write.action.waiting", 0);

        private Holder() {
        }
    }
}

