/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application;

import com.intellij.openapi.application.ConfigImportHelper;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.io.PathKt;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0007\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0003H\u0002J\u0010\u0010\b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0003H\u0002J\u000e\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bJ\f\u0010\f\u001a\u00020\r*\u00020\u000eH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/openapi/application/ConfigBackup;", "", "configDir", "Ljava/nio/file/Path;", "(Ljava/nio/file/Path;)V", "cleanupOldBackups", "", "backupsDir", "migratePreviousBackupIfExists", "moveToBackup", "dirToMove", "Ljava/io/File;", "looksLikeDate", "", "", "Companion", "intellij.platform.ide.impl"})
@ApiStatus.Internal
public final class ConfigBackup {
    private final Path configDir;
    public static final int MAX_BACKUPS_NUMBER = 10;
    private static final Logger LOG;
    private static final String DATE_FORMAT = "yyyy-MM-dd-HH-mm";
    @NotNull
    public static final Companion Companion;

    public final void moveToBackup(@NotNull File dirToMove) throws IOException {
        Intrinsics.checkNotNullParameter((Object)dirToMove, (String)"dirToMove");
        Path backupsDir = ConfigBackup.Companion.getBackupsDir(this.configDir);
        if (PathKt.exists((Path)backupsDir)) {
            this.migratePreviousBackupIfExists(backupsDir);
            this.cleanupOldBackups(backupsDir);
        }
        Path backupPath = Companion.getNextBackupPath(this.configDir);
        LOG.info("Move backup from " + dirToMove + " to " + backupPath);
        FileUtil.copyDir((File)dirToMove, (File)backupPath.toFile());
        FileUtil.delete((File)dirToMove);
    }

    private final void migratePreviousBackupIfExists(Path backupsDir) {
        if (ConfigImportHelper.isConfigDirectory(backupsDir)) {
            try {
                Path path2 = backupsDir.resolve("1970-01-01-00-00");
                Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"backupsDir.resolve(\"1970-01-01-00-00\")");
                Path path3 = path2;
                FileAttribute[] fileAttributeArray = new FileAttribute[]{};
                boolean bl = false;
                Path path4 = Files.createDirectory(path3, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"Files.createDirectory(this, *attributes)");
                Path oldBackup = path4;
                for (Path file2 : PathsKt.listDirectoryEntries$default((Path)backupsDir, null, (int)1, null)) {
                    if (PathKt.isDirectory((Path)file2) && this.looksLikeDate(PathsKt.getName((Path)file2))) continue;
                    FileUtil.copyDir((File)file2.toFile(), (File)oldBackup.resolve(PathsKt.getName((Path)file2)).toFile());
                    FileUtil.delete((File)file2.toFile());
                }
            }
            catch (Exception e) {
                LOG.warn((Throwable)e);
            }
        }
    }

    private final boolean looksLikeDate(String $this$looksLikeDate) {
        try {
            DateTimeFormatter format = DateTimeFormatter.ofPattern(DATE_FORMAT);
            format.parse($this$looksLikeDate);
            return true;
        }
        catch (DateTimeParseException e) {
            return false;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void cleanupOldBackups(Path backupsDir) {
        int n;
        Iterable $this$sortedBy$iv = PathsKt.listDirectoryEntries$default((Path)backupsDir, null, (int)1, null);
        boolean $i$f$sortedBy = false;
        boolean bl = false;
        List children2 = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                Path it = (Path)a;
                boolean bl2 = false;
                Comparable comparable = (Comparable)((Object)PathsKt.getName((Path)it));
                it = (Path)b;
                Comparable comparable2 = comparable;
                bl2 = false;
                String string = PathsKt.getName((Path)it);
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)string)));
            }
        });
        if (children2.size() >= 10 && ($this$sortedBy$iv = 0) <= (n = children2.size() - 10)) {
            while (true) {
                void i2;
                Path oldDir = (Path)children2.get((int)i2);
                try {
                    PathKt.delete((Path)oldDir, (boolean)true);
                }
                catch (Exception e) {
                    LOG.warn((Throwable)e);
                }
                if (i2 == n) break;
                ++i2;
            }
        }
    }

    public ConfigBackup(@NotNull Path configDir) {
        Intrinsics.checkNotNullParameter((Object)configDir, (String)"configDir");
        this.configDir = configDir;
    }

    static {
        Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(ConfigBackup.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        LOG = logger;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0002J\u000e\u0010\r\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/openapi/application/ConfigBackup$Companion;", "", "()V", "DATE_FORMAT", "", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "MAX_BACKUPS_NUMBER", "", "getBackupsDir", "Ljava/nio/file/Path;", "configDir", "getNextBackupPath", "intellij.platform.ide.impl"})
    public static final class Companion {
        @NotNull
        public final Path getNextBackupPath(@NotNull Path configDir) {
            Path dirWithIndex;
            Path dir;
            Intrinsics.checkNotNullParameter((Object)configDir, (String)"configDir");
            LocalDateTime now = LocalDateTime.now();
            DateTimeFormatter format = DateTimeFormatter.ofPattern(ConfigBackup.DATE_FORMAT);
            String date = now.format(format);
            Path path2 = dir = this.getBackupsDir(configDir).resolve(date);
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"dir");
            if (!PathKt.exists((Path)path2)) {
                return dir;
            }
            LOG.info(dir + " already exists");
            String string = UUID.randomUUID().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"UUID.randomUUID().toString()");
            String id2 = string;
            Path path3 = dirWithIndex = this.getBackupsDir(configDir).resolve(date + '-' + id2);
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"dirWithIndex");
            if (PathKt.exists((Path)path3)) {
                LOG.warn("Even " + dirWithIndex + " already exists");
            }
            return dirWithIndex;
        }

        private final Path getBackupsDir(Path configDir) {
            Path path2 = configDir.resolveSibling(PathsKt.getName((Path)configDir) + "-backup");
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"configDir.resolveSibling\u2026nfigDir.name + \"-backup\")");
            return path2;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

