/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem.impl;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.WeakList;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class PresentationFactory {
    private final Map<AnAction, Presentation> myPresentations = CollectionFactory.createConcurrentWeakMap();
    private boolean myNeedRebuild;
    private static final Collection<PresentationFactory> ourAllFactories = new WeakList();

    public PresentationFactory() {
        ourAllFactories.add(this);
    }

    @NotNull
    public final Presentation getPresentation(@NotNull AnAction action2) {
        Presentation presentation2;
        if (action2 == null) {
            PresentationFactory.$$$reportNull$$$0(0);
        }
        if ((presentation2 = this.myPresentations.get(action2)) == null || !action2.isDefaultIcon()) {
            Presentation templatePresentation = action2.getTemplatePresentation();
            if (presentation2 == null) {
                presentation2 = templatePresentation.clone();
                presentation2 = (Presentation)ObjectUtils.notNull((Object)this.myPresentations.putIfAbsent(action2, presentation2), (Object)presentation2);
            }
            if (!action2.isDefaultIcon()) {
                presentation2.setIcon(templatePresentation.getIcon());
                presentation2.setDisabledIcon(templatePresentation.getDisabledIcon());
            }
            this.processPresentation(presentation2);
        }
        Presentation presentation3 = presentation2;
        if (presentation3 == null) {
            PresentationFactory.$$$reportNull$$$0(1);
        }
        return presentation3;
    }

    protected void processPresentation(@NotNull Presentation presentation2) {
        if (presentation2 == null) {
            PresentationFactory.$$$reportNull$$$0(2);
        }
    }

    public void reset() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myPresentations.clear();
        this.myNeedRebuild = true;
    }

    public boolean isNeedRebuild() {
        return this.myNeedRebuild;
    }

    public void resetNeedRebuild() {
        this.myNeedRebuild = false;
    }

    public static void clearPresentationCaches() {
        for (PresentationFactory factory2 : ourAllFactories) {
            factory2.reset();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/actionSystem/impl/PresentationFactory";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/actionSystem/impl/PresentationFactory";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getPresentation";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "processPresentation";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

