/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem.impl;

import com.intellij.openapi.actionSystem.AbbreviationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

@State(name="AbbreviationManager", storages={@Storage(value="abbreviations.xml", roamingType=RoamingType.PER_OS)})
public final class AbbreviationManagerImpl
extends AbbreviationManager
implements PersistentStateComponent<Element> {
    private final Map<String, List<String>> myAbbreviation2ActionId = new HashMap<String, List<String>>();
    private final Map<String, Set<String>> myActionId2Abbreviations = new HashMap<String, Set<String>>();
    private final Map<String, Set<String>> myPluginsActionId2Abbreviations = new HashMap<String, Set<String>>();

    @NotNull
    public Element getState() {
        Element actions2 = new Element("actions");
        if (this.myActionId2Abbreviations.isEmpty()) {
            Element element2 = actions2;
            if (element2 == null) {
                AbbreviationManagerImpl.$$$reportNull$$$0(0);
            }
            return element2;
        }
        Element abbreviations = null;
        for (Map.Entry<String, Set<String>> entry2 : this.myActionId2Abbreviations.entrySet()) {
            Set<String> pluginAbbrs;
            String key = entry2.getKey();
            Set<String> abbrs = entry2.getValue();
            if (Objects.equals(abbrs, pluginAbbrs = this.myPluginsActionId2Abbreviations.get(key)) || abbrs == null) continue;
            if (abbreviations == null) {
                abbreviations = new Element("abbreviations");
                actions2.addContent(abbreviations);
            }
            Element action2 = new Element("action");
            action2.setAttribute("id", key);
            abbreviations.addContent(action2);
            for (String abbr : abbrs) {
                Element abbreviation = new Element("abbreviation");
                abbreviation.setAttribute("name", abbr);
                action2.addContent(abbreviation);
            }
        }
        Element element3 = actions2;
        if (element3 == null) {
            AbbreviationManagerImpl.$$$reportNull$$$0(1);
        }
        return element3;
    }

    public void loadState(@NotNull Element state) {
        List abbreviations;
        if (state == null) {
            AbbreviationManagerImpl.$$$reportNull$$$0(2);
        }
        if ((abbreviations = state.getChildren("abbreviations")).size() != 1) {
            return;
        }
        List actions2 = ((Element)abbreviations.get(0)).getChildren("action");
        for (Element action2 : actions2) {
            String actionId = action2.getAttributeValue("id");
            Set values2 = this.myActionId2Abbreviations.computeIfAbsent(actionId, k -> new LinkedHashSet(1));
            for (Element abbr : action2.getChildren("abbreviation")) {
                String abbrValue = abbr.getAttributeValue("name");
                if (abbrValue == null) continue;
                values2.add(abbrValue);
                this.myAbbreviation2ActionId.computeIfAbsent(abbrValue, k -> new ArrayList()).add(actionId);
            }
        }
    }

    @NotNull
    public Set<String> getAbbreviations() {
        Set<String> set2 = this.myActionId2Abbreviations.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
        if (set2 == null) {
            AbbreviationManagerImpl.$$$reportNull$$$0(3);
        }
        return set2;
    }

    @NotNull
    public Set<String> getAbbreviations(@NotNull String actionId) {
        Set<String> abbreviations;
        if (actionId == null) {
            AbbreviationManagerImpl.$$$reportNull$$$0(4);
        }
        if ((abbreviations = this.myActionId2Abbreviations.get(actionId)) == null) {
            Set<String> set2 = Collections.emptySet();
            if (set2 == null) {
                AbbreviationManagerImpl.$$$reportNull$$$0(5);
            }
            return set2;
        }
        Set<String> set3 = Collections.unmodifiableSet(abbreviations);
        if (set3 == null) {
            AbbreviationManagerImpl.$$$reportNull$$$0(6);
        }
        return set3;
    }

    @NotNull
    public List<String> findActions(@NotNull String abbreviation) {
        List<String> actions2;
        if (abbreviation == null) {
            AbbreviationManagerImpl.$$$reportNull$$$0(7);
        }
        List<Object> list2 = (actions2 = this.myAbbreviation2ActionId.get(abbreviation)) == null ? Collections.emptyList() : Collections.unmodifiableList(actions2);
        if (list2 == null) {
            AbbreviationManagerImpl.$$$reportNull$$$0(8);
        }
        return list2;
    }

    private static void register(@NotNull String abbreviation, @NotNull String actionId, @NotNull Map<String, Set<String>> storage2) {
        if (abbreviation == null) {
            AbbreviationManagerImpl.$$$reportNull$$$0(9);
        }
        if (actionId == null) {
            AbbreviationManagerImpl.$$$reportNull$$$0(10);
        }
        if (storage2 == null) {
            AbbreviationManagerImpl.$$$reportNull$$$0(11);
        }
        storage2.computeIfAbsent(actionId, k -> new LinkedHashSet(1)).add(abbreviation);
    }

    public void register(@NotNull String abbreviation, @NotNull String actionId, boolean fromPluginXml) {
        List ids;
        if (abbreviation == null) {
            AbbreviationManagerImpl.$$$reportNull$$$0(12);
        }
        if (actionId == null) {
            AbbreviationManagerImpl.$$$reportNull$$$0(13);
        }
        if (fromPluginXml && this.myActionId2Abbreviations.containsKey(actionId)) {
            AbbreviationManagerImpl.register(abbreviation, actionId, this.myPluginsActionId2Abbreviations);
            return;
        }
        AbbreviationManagerImpl.register(abbreviation, actionId, this.myActionId2Abbreviations);
        if (fromPluginXml) {
            AbbreviationManagerImpl.register(abbreviation, actionId, this.myPluginsActionId2Abbreviations);
        }
        if (!(ids = this.myAbbreviation2ActionId.computeIfAbsent(abbreviation, k -> new ArrayList(0))).contains(actionId)) {
            ids.add(actionId);
        }
    }

    public void register(@NotNull String abbreviation, @NotNull String actionId) {
        if (abbreviation == null) {
            AbbreviationManagerImpl.$$$reportNull$$$0(14);
        }
        if (actionId == null) {
            AbbreviationManagerImpl.$$$reportNull$$$0(15);
        }
        this.register(abbreviation, actionId, false);
    }

    public void remove(@NotNull String abbreviation, @NotNull String actionId) {
        Set<String> abbreviations;
        List<String> actions2;
        if (abbreviation == null) {
            AbbreviationManagerImpl.$$$reportNull$$$0(16);
        }
        if (actionId == null) {
            AbbreviationManagerImpl.$$$reportNull$$$0(17);
        }
        if ((actions2 = this.myAbbreviation2ActionId.get(abbreviation)) != null) {
            actions2.remove(actionId);
        }
        if ((abbreviations = this.myActionId2Abbreviations.get(actionId)) != null) {
            abbreviations.remove(abbreviation);
        } else {
            Set<String> abbrs = this.myActionId2Abbreviations.get(actionId);
            if (abbrs != null) {
                LinkedHashSet<String> customValues = new LinkedHashSet<String>(abbrs);
                customValues.remove(abbreviation);
                this.myActionId2Abbreviations.put(actionId, customValues);
            }
        }
    }

    public void removeAllAbbreviations(@NotNull String actionId) {
        if (actionId == null) {
            AbbreviationManagerImpl.$$$reportNull$$$0(18);
        }
        Set<String> abbreviations = this.getAbbreviations(actionId);
        for (String abbreviation : abbreviations) {
            this.myAbbreviation2ActionId.get(abbreviation).remove(actionId);
        }
        this.myActionId2Abbreviations.remove(actionId);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/actionSystem/impl/AbbreviationManagerImpl";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 4: 
            case 10: 
            case 13: 
            case 15: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionId";
                break;
            }
            case 7: 
            case 9: 
            case 12: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "abbreviation";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/actionSystem/impl/AbbreviationManagerImpl";
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getAbbreviations";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "findActions";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getAbbreviations";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findActions";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "register";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "remove";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "removeAllAbbreviations";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

