/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem;

import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.HelpTooltip;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Toggleable;
import com.intellij.openapi.actionSystem.UpdateInBackground;
import com.intellij.openapi.actionSystem.UpdateSession;
import com.intellij.openapi.actionSystem.ex.ActionButtonLook;
import com.intellij.openapi.actionSystem.ex.AnActionListener;
import com.intellij.openapi.actionSystem.ex.CustomComponentAction;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.actionSystem.impl.ActionManagerImpl;
import com.intellij.openapi.actionSystem.impl.MenuItemPresentationFactory;
import com.intellij.openapi.actionSystem.impl.Utils;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.ui.JBPopupMenu;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.SimpleMessageBusConnection;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StartupUiUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.geom.Area;
import java.util.List;
import java.util.Objects;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SplitButtonAction
extends ActionGroup
implements CustomComponentAction,
UpdateInBackground {
    private final ActionGroup myActionGroup;
    private static final Key<AnAction> FIRST_ACTION = Key.create((String)"firstAction");

    public SplitButtonAction(@NotNull ActionGroup actionGroup2) {
        if (actionGroup2 == null) {
            SplitButtonAction.$$$reportNull$$$0(0);
        }
        this.myActionGroup = actionGroup2;
        this.setPopup(true);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            SplitButtonAction.$$$reportNull$$$0(1);
        }
    }

    @NotNull
    public ActionGroup getActionGroup() {
        ActionGroup actionGroup2 = this.myActionGroup;
        if (actionGroup2 == null) {
            SplitButtonAction.$$$reportNull$$$0(2);
        }
        return actionGroup2;
    }

    public boolean isUpdateInBackground() {
        return UpdateInBackground.isUpdateInBackground((AnAction)this.myActionGroup);
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            SplitButtonAction.$$$reportNull$$$0(3);
        }
        Presentation presentation2 = e.getPresentation();
        SplitButton splitButton = (SplitButton)ObjectUtils.tryCast((Object)presentation2.getClientProperty(CustomComponentAction.COMPONENT_KEY), SplitButton.class);
        this.myActionGroup.update(e);
        if (presentation2.isVisible()) {
            AnAction action2;
            AnAction anAction2 = action2 = splitButton != null ? splitButton.selectedAction : this.getFirstEnabledAction(e);
            if (action2 != null) {
                Presentation actionPresentation = Utils.getOrCreateUpdateSession(e).presentation(action2);
                presentation2.copyFrom(actionPresentation, (Component)splitButton);
                if (splitButton != null) {
                    boolean shouldRepaint = splitButton.actionEnabled != presentation2.isEnabled();
                    splitButton.actionEnabled = presentation2.isEnabled();
                    if (shouldRepaint) {
                        splitButton.repaint();
                    }
                }
                presentation2.setEnabledAndVisible(true);
            }
            presentation2.putClientProperty(FIRST_ACTION, (Object)(splitButton != null ? null : action2));
        }
    }

    @Nullable
    private AnAction getFirstEnabledAction(@NotNull AnActionEvent e) {
        UpdateSession session2;
        List children2;
        AnAction firstEnabled;
        if (e == null) {
            SplitButtonAction.$$$reportNull$$$0(4);
        }
        return (firstEnabled = (AnAction)ContainerUtil.find((Iterable)(children2 = (session2 = Utils.getOrCreateUpdateSession(e)).children(this.myActionGroup)), a -> session2.presentation(a).isEnabled())) != null ? firstEnabled : (AnAction)ContainerUtil.getFirstItem((List)children2);
    }

    public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
        AnAction[] anActionArray = this.myActionGroup.getChildren(e);
        if (anActionArray == null) {
            SplitButtonAction.$$$reportNull$$$0(5);
        }
        return anActionArray;
    }

    public boolean isDumbAware() {
        return this.myActionGroup.isDumbAware();
    }

    @NotNull
    public JComponent createCustomComponent(@NotNull Presentation presentation2, @NotNull String place) {
        if (presentation2 == null) {
            SplitButtonAction.$$$reportNull$$$0(6);
        }
        if (place == null) {
            SplitButtonAction.$$$reportNull$$$0(7);
        }
        return new SplitButton((AnAction)this, presentation2, place, this.myActionGroup);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionGroup";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/actionSystem/SplitButtonAction";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/actionSystem/SplitButtonAction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionGroup";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 2: 
            case 5: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getFirstEnabledAction";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createCustomComponent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class SplitButton
    extends ActionButton {
        private static final Icon ARROW_DOWN = AllIcons.General.ButtonDropTriangle;
        private final ActionGroup myActionGroup;
        private AnAction selectedAction;
        private boolean actionEnabled;
        private MousePressType mousePressType;
        private SimpleMessageBusConnection myConnection;

        private SplitButton(@NotNull AnAction action2, @NotNull Presentation presentation2, String place, ActionGroup actionGroup2) {
            if (action2 == null) {
                SplitButton.$$$reportNull$$$0(0);
            }
            if (presentation2 == null) {
                SplitButton.$$$reportNull$$$0(1);
            }
            super(action2, presentation2, place, ActionToolbar.DEFAULT_MINIMUM_BUTTON_SIZE);
            this.actionEnabled = true;
            this.mousePressType = MousePressType.None;
            this.myActionGroup = actionGroup2;
            this.selectedAction = (AnAction)presentation2.getClientProperty(FIRST_ACTION);
        }

        private void copyPresentation(Presentation presentation2) {
            this.myPresentation.copyFrom(presentation2, (Component)this);
            this.actionEnabled = presentation2.isEnabled();
            this.myPresentation.setEnabled(true);
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension size = super.getPreferredSize();
            size.width += ARROW_DOWN.getIconWidth() + JBUIScale.scale((int)7);
            return size;
        }

        private boolean selectedActionEnabled() {
            return this.selectedAction != null && this.actionEnabled;
        }

        @Override
        public void paintComponent(Graphics g) {
            ActionButtonLook look = this.getButtonLook();
            if (this.selectedActionEnabled() || !StartupUiUtil.isUnderDarcula()) {
                int state = this.getPopState();
                if (state == -1) {
                    state = 1;
                }
                look.paintBackground(g, (JComponent)this, state);
            }
            Rectangle baseRect = new Rectangle(this.getSize());
            JBInsets.removeFrom((Rectangle)baseRect, (Insets)this.getInsets());
            if (this.getPopState() == -1 && this.mousePressType != MousePressType.None && this.selectedActionEnabled() || this.isToggleActionPushed()) {
                int arrowWidth = ARROW_DOWN.getIconWidth() + JBUIScale.scale((int)7);
                Shape clip = g.getClip();
                Area buttonClip = new Area(clip);
                Rectangle execButtonRect = new Rectangle(baseRect.x, baseRect.y, baseRect.width - arrowWidth, baseRect.height);
                if (this.mousePressType == MousePressType.Action || this.isToggleActionPushed()) {
                    buttonClip.intersect(new Area(execButtonRect));
                } else if (this.mousePressType == MousePressType.Popup) {
                    Rectangle arrowButtonRect = new Rectangle(execButtonRect.x + execButtonRect.width, baseRect.y, arrowWidth, baseRect.height);
                    buttonClip.intersect(new Area(arrowButtonRect));
                }
                g.setClip(buttonClip);
                look.paintBackground(g, (JComponent)this, -1);
                g.setClip(clip);
            }
            int x = baseRect.x + baseRect.width - JBUIScale.scale((int)3) - ARROW_DOWN.getIconWidth();
            int y = baseRect.y + (baseRect.height - ARROW_DOWN.getIconHeight()) / 2 + JBUIScale.scale((int)1);
            look.paintIcon(g, this, ARROW_DOWN, x, y);
            x -= JBUIScale.scale((int)4);
            int popState = this.getPopState();
            if (popState == 1 || popState == -1) {
                g.setColor(JBUI.CurrentTheme.ActionButton.hoverSeparatorColor());
                g.fillRect(x, baseRect.y, JBUIScale.scale((int)1), baseRect.height);
            }
            Icon actionIcon = this.getIcon();
            if (!this.selectedActionEnabled()) {
                Icon disabledIcon = this.myPresentation.getDisabledIcon();
                Icon icon2 = actionIcon = disabledIcon != null || actionIcon == null ? disabledIcon : IconLoader.getDisabledIcon((Icon)actionIcon);
                if (actionIcon == null) {
                    actionIcon = this.getFallbackIcon(false);
                }
            }
            x = baseRect.x + (x - actionIcon.getIconWidth()) / 2;
            y = baseRect.y + (baseRect.height - actionIcon.getIconHeight()) / 2;
            look.paintIcon(g, this, actionIcon, x, y);
        }

        private boolean isToggleActionPushed() {
            return this.selectedAction instanceof Toggleable && Toggleable.isSelected((Presentation)this.myPresentation);
        }

        @Override
        protected void onMousePressed(@NotNull MouseEvent e) {
            if (e == null) {
                SplitButton.$$$reportNull$$$0(2);
            }
            Rectangle baseRect = new Rectangle(this.getSize());
            JBInsets.removeFrom((Rectangle)baseRect, (Insets)this.getInsets());
            int arrowWidth = ARROW_DOWN.getIconWidth() + JBUIScale.scale((int)7);
            Rectangle execButtonRect = new Rectangle(baseRect.x, baseRect.y, baseRect.width - arrowWidth, baseRect.height);
            Rectangle arrowButtonRect = new Rectangle(execButtonRect.x + execButtonRect.width, baseRect.y, arrowWidth, baseRect.height);
            Point p = e.getPoint();
            this.mousePressType = execButtonRect.contains(p) ? MousePressType.Action : (arrowButtonRect.contains(p) ? MousePressType.Popup : MousePressType.None);
        }

        @Override
        protected void actionPerformed(@NotNull AnActionEvent event) {
            if (event == null) {
                SplitButton.$$$reportNull$$$0(3);
            }
            HelpTooltip.hide((Component)this);
            if (this.mousePressType == MousePressType.Popup || !this.selectedActionEnabled()) {
                this.showActionGroupPopup(this.myActionGroup, event);
            } else {
                this.selectedAction.actionPerformed(event);
            }
        }

        @Override
        protected void showActionGroupPopup(@NotNull ActionGroup actionGroup2, @NotNull AnActionEvent event) {
            if (actionGroup2 == null) {
                SplitButton.$$$reportNull$$$0(4);
            }
            if (event == null) {
                SplitButton.$$$reportNull$$$0(5);
            }
            if (this.myPopupState.isRecentlyHidden()) {
                return;
            }
            ActionManagerImpl am = (ActionManagerImpl)ActionManager.getInstance();
            ActionPopupMenu popupMenu = am.createActionPopupMenu(event.getPlace(), actionGroup2, new MenuItemPresentationFactory(){

                @Override
                protected void processPresentation(@NotNull Presentation presentation2) {
                    if (presentation2 == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    super.processPresentation(presentation2);
                    if (StringUtil.defaultIfEmpty((String)presentation2.getText(), (String)"").equals(myPresentation.getText()) && StringUtil.defaultIfEmpty((String)presentation2.getDescription(), (String)"").equals(myPresentation.getDescription())) {
                        presentation2.setEnabled(this.selectedActionEnabled());
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentation", "com/intellij/openapi/actionSystem/SplitButtonAction$SplitButton$1", "processPresentation"));
                }
            });
            popupMenu.setTargetComponent((JComponent)this);
            JPopupMenu menu = popupMenu.getComponent();
            this.myPopupState.prepareToShow((Object)menu);
            if (event.isFromActionToolbar()) {
                menu.show(this, ActionToolbar.DEFAULT_MINIMUM_BUTTON_SIZE.width + this.getInsets().left, this.getHeight());
            } else {
                JBPopupMenu.showAtRight((Component)this, (JPopupMenu)menu);
            }
            HelpTooltip.setMasterPopupOpenCondition((Component)this, () -> !menu.isVisible());
        }

        @Override
        public void addNotify() {
            super.addNotify();
            DataContext context2 = DataManager.getInstance().getDataContext((Component)this.getParent());
            Disposable parentDisposable = (Disposable)Objects.requireNonNullElse((ComponentManager)CommonDataKeys.PROJECT.getData(context2), ApplicationManager.getApplication());
            this.myConnection = ApplicationManager.getApplication().getMessageBus().connect(parentDisposable);
            this.myConnection.subscribe(AnActionListener.TOPIC, (Object)new AnActionListener(){

                public void beforeActionPerformed(@NotNull AnAction action2, @NotNull AnActionEvent event) {
                    if (action2 == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if (event == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    if (event.getDataContext().getData(PlatformDataKeys.CONTEXT_COMPONENT) == this) {
                        selectedAction = action2;
                        this.copyPresentation(event.getPresentation());
                        this.repaint();
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "action";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "event";
                            break;
                        }
                    }
                    objectArray[1] = "com/intellij/openapi/actionSystem/SplitButtonAction$SplitButton$2";
                    objectArray[2] = "beforeActionPerformed";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }

        @Override
        public void removeNotify() {
            super.removeNotify();
            if (this.myConnection != null) {
                this.myConnection.disconnect();
                this.myConnection = null;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "action";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "presentation";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "actionGroup";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/actionSystem/SplitButtonAction$SplitButton";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onMousePressed";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "showActionGroupPopup";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        private static enum MousePressType {
            Action,
            Popup,
            None;

        }
    }
}

