/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notification.impl;

import com.intellij.codeInsight.hint.TooltipController;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.FrameStateListener;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.ide.ui.LafManagerListener;
import com.intellij.notification.EventLog;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.notification.NotificationsManager;
import com.intellij.notification.impl.NotificationCollector;
import com.intellij.notification.impl.NotificationFullContent;
import com.intellij.notification.impl.NotificationParentGroup;
import com.intellij.notification.impl.NotificationSettings;
import com.intellij.notification.impl.NotificationsConfigurationImpl;
import com.intellij.notification.impl.ui.NotificationsUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.DialogWrapperDialog;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.BalloonBuilder;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomeBalloonLayoutImpl;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomeFrame;
import com.intellij.ui.BalloonImpl;
import com.intellij.ui.BalloonLayout;
import com.intellij.ui.BalloonLayoutConfiguration;
import com.intellij.ui.BalloonLayoutData;
import com.intellij.ui.BalloonLayoutImpl;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.ContextHelpLabel;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.NotificationBalloonActionProvider;
import com.intellij.ui.NotificationBalloonShadowBorderProvider;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.components.GradientViewport;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.ui.components.labels.LinkListener;
import com.intellij.ui.components.panels.HorizontalLayout;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ArrayUtil;
import com.intellij.util.FontUtil;
import com.intellij.util.IconUtil;
import com.intellij.util.ModalityUiUtil;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.ui.AbstractLayoutManager;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Window;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Rectangle2D;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.plaf.UIResource;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultCaret;
import javax.swing.text.EditorKit;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class NotificationsManagerImpl
extends NotificationsManager {
    public static final Color DEFAULT_TEXT_COLOR = new JBColor((Color)Gray._0, (Color)Gray._191);
    public static final Color FILL_COLOR = JBColor.namedColor((String)"Notification.background", (Color)new JBColor((Color)Gray._242, new Color(5132370)));
    public static final Color BORDER_COLOR = JBColor.namedColor((String)"Notification.borderColor", (Color)new JBColor(-843926862, -849978788));
    @Nullable
    private List<Notification> myEarlyNotifications = new ArrayList<Notification>();

    public NotificationsManagerImpl() {
        ApplicationManager.getApplication().getMessageBus().connect().subscribe(ProjectManager.TOPIC, (Object)new ProjectManagerListener(){

            public void projectClosed(@NotNull Project project) {
                if (project == null) {
                    1.$$$reportNull$$$0(0);
                }
                for (Notification notification : NotificationsManagerImpl.this.getNotificationsOfType(Notification.class, project)) {
                    notification.hideBalloon();
                }
                TooltipController.getInstance().resetCurrent();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/notification/impl/NotificationsManagerImpl$1", "projectClosed"));
            }
        });
    }

    public void expire(@NotNull Notification notification) {
        if (notification == null) {
            NotificationsManagerImpl.$$$reportNull$$$0(0);
        }
        UIUtil.invokeLaterIfNeeded(() -> EventLog.expireNotification(notification));
    }

    public void expireAll() {
        EventLog.expireNotifications();
    }

    public <T extends Notification> T @NotNull [] getNotificationsOfType(@NotNull Class<T> klass, @Nullable Project project) {
        if (klass == null) {
            NotificationsManagerImpl.$$$reportNull$$$0(1);
        }
        ArrayList<Notification> result2 = new ArrayList<Notification>();
        if (project == null || !project.isDefault() && !project.isDisposed()) {
            for (Notification notification : EventLog.getLogModel(project).getNotifications()) {
                if (!klass.isInstance(notification)) continue;
                Notification t = notification;
                result2.add(t);
            }
        }
        Notification[] notificationArray = (Notification[])ArrayUtil.toObjectArray(result2, klass);
        if (notificationArray == null) {
            NotificationsManagerImpl.$$$reportNull$$$0(2);
        }
        return notificationArray;
    }

    private void doNotify(Notification notification, @Nullable Project project) {
        NotificationsConfigurationImpl configuration2 = NotificationsConfigurationImpl.getInstanceImpl();
        NotificationSettings settings2 = NotificationsConfigurationImpl.getSettings(notification.getGroupId());
        if (!configuration2.isRegistered(notification.getGroupId())) {
            configuration2.register(notification.getGroupId(), NotificationDisplayType.BALLOON);
        }
        if (!(settings2.isShouldLog() || settings2.getDisplayType() != NotificationDisplayType.NONE && configuration2.SHOW_BALLOONS)) {
            notification.expire();
        }
        if (configuration2.SHOW_BALLOONS) {
            if (project == null) {
                ModalityUiUtil.invokeLaterIfNeeded(() -> this.showNotification(notification, null), (ModalityState)ModalityState.any(), (Condition)ApplicationManager.getApplication().getDisposed());
            } else if (!project.isDisposed()) {
                StartupManager.getInstance((Project)project).runAfterOpened(() -> ModalityUiUtil.invokeLaterIfNeeded(() -> this.showNotification(notification, project), (ModalityState)ModalityState.any(), (Condition)project.getDisposed()));
            }
        }
    }

    @RequiresEdt
    @ApiStatus.Internal
    public void dispatchEarlyNotifications() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.myEarlyNotifications != null) {
            List<Notification> copy2 = this.myEarlyNotifications;
            this.myEarlyNotifications = null;
            copy2.forEach(early -> this.showNotification((Notification)early, null));
        }
    }

    /*
     * WARNING - void declaration
     */
    @RequiresEdt
    private void showNotification(Notification notification, @Nullable Project project) {
        void project2;
        void notification2;
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.myEarlyNotifications != null) {
            this.myEarlyNotifications.add((Notification)notification2);
            return;
        }
        String groupId2 = notification2.getGroupId();
        NotificationSettings settings2 = NotificationsConfigurationImpl.getSettings(groupId2);
        NotificationDisplayType type = settings2.getDisplayType();
        String toolWindowId = NotificationsConfigurationImpl.getInstanceImpl().getToolWindowId(groupId2);
        if (!(type != NotificationDisplayType.TOOL_WINDOW || toolWindowId != null && project2 != null && ToolWindowManager.getInstance((Project)project2).canShowNotification(toolWindowId))) {
            type = NotificationDisplayType.BALLOON;
        }
        switch (type) {
            case NONE: {
                return;
            }
            default: {
                Balloon balloon2 = NotificationsManagerImpl.notifyByBalloon((Notification)notification2, type, (Project)project2);
                if (project2 == null || project2.isDefault() || settings2.isShouldLog() && type != NotificationDisplayType.STICKY_BALLOON) break;
                if (balloon2 == null) {
                    notification2.expire();
                    break;
                }
                balloon2.addListener(new JBPopupListener((Notification)notification2){
                    final /* synthetic */ Notification val$notification;
                    {
                        this.val$notification = notification;
                    }

                    public void onClosed(@NotNull LightweightWindowEvent event) {
                        if (event == null) {
                            2.$$$reportNull$$$0(0);
                        }
                        if (!event.isOk()) {
                            this.val$notification.expire();
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/notification/impl/NotificationsManagerImpl$2", "onClosed"));
                    }
                });
                break;
            }
            case TOOL_WINDOW: {
                NotificationListener notificationListener;
                BalloonLayout layout;
                Window window;
                MessageType messageType = notification2.getType() == NotificationType.ERROR ? MessageType.ERROR : (notification2.getType() == NotificationType.WARNING ? MessageType.WARNING : MessageType.INFO);
                Object messageBody = notification2.getTitle();
                HyperlinkListener listener2 = null;
                String content2 = notification2.getContent();
                if (!content2.isEmpty()) {
                    if (!((String)messageBody).isEmpty()) {
                        messageBody = (String)messageBody + HtmlChunk.br();
                    }
                    messageBody = (String)messageBody + content2;
                }
                List actions2 = notification2.getActions();
                final HashMap<CallSite, AnAction> actionListeners = new HashMap<CallSite, AnAction>();
                if (!actions2.isEmpty()) {
                    messageBody = (String)messageBody + HtmlChunk.br();
                    for (int index2 = 0; index2 < actions2.size(); ++index2) {
                        AnAction action2 = (AnAction)actions2.get(index2);
                        String text2 = action2.getTemplatePresentation().getText();
                        if (text2 == null) continue;
                        String linkTarget = "notification-action-" + index2 + "for-tool-window-" + System.identityHashCode(notification2);
                        actionListeners.put((CallSite)((Object)linkTarget), action2);
                        messageBody = (String)messageBody + HtmlChunk.link((String)linkTarget, (String)text2);
                        messageBody = (String)messageBody + " ";
                    }
                }
                if ((window = NotificationsManagerImpl.findWindowForBalloon((Project)project2)) instanceof IdeFrame && (layout = ((IdeFrame)window).getBalloonLayout()) != null) {
                    ((BalloonLayoutImpl)layout).remove((Notification)notification2);
                }
                if ((notificationListener = notification2.getListener()) != null || !actionListeners.isEmpty()) {
                    listener2 = new HyperlinkListener((Notification)notification2, (Project)project2, notificationListener){
                        final /* synthetic */ Notification val$notification;
                        final /* synthetic */ Project val$project;
                        final /* synthetic */ NotificationListener val$notificationListener;
                        {
                            this.val$notification = notification;
                            this.val$project = project;
                            this.val$notificationListener = notificationListener;
                        }

                        @Override
                        public void hyperlinkUpdate(HyperlinkEvent e) {
                            AnAction action2;
                            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED && (action2 = (AnAction)actionListeners.get(e.getDescription())) != null) {
                                Object source = e.getSource();
                                DataContext context2 = source instanceof Component ? DataManager.getInstance().getDataContext((Component)source) : null;
                                Notification.fire((Notification)this.val$notification, (AnAction)action2, (DataContext)context2);
                                NotificationCollector.getInstance().logNotificationActionInvoked(this.val$project, this.val$notification, action2, NotificationCollector.NotificationPlace.TOOL_WINDOW);
                                return;
                            }
                            if (this.val$notificationListener != null) {
                                this.val$notificationListener.hyperlinkUpdate(this.val$notification, e);
                            }
                        }
                    };
                }
                ToolWindowManager.getInstance((Project)((Project)Objects.requireNonNull(project2))).notifyByBalloon(toolWindowId, messageType, (String)messageBody, notification2.getIcon(), listener2);
                NotificationCollector.getInstance().logToolWindowNotificationShown((Project)project2, (Notification)notification2);
            }
        }
    }

    @Nullable
    private static Balloon notifyByBalloon(Notification notification, NotificationDisplayType displayType, @Nullable Project project) {
        if (NotificationsManagerImpl.isDummyEnvironment()) {
            return null;
        }
        Window window = NotificationsManagerImpl.findWindowForBalloon(project);
        if (!(window instanceof IdeFrame)) {
            return null;
        }
        BalloonLayout layout = ((IdeFrame)window).getBalloonLayout();
        if (layout == null) {
            return null;
        }
        Ref layoutDataRef = new Ref();
        if (project == null || project.isDefault()) {
            BalloonLayoutData layoutData = new BalloonLayoutData();
            layoutData.groupId = "";
            layoutData.welcomeScreen = layout instanceof WelcomeBalloonLayoutImpl;
            layoutData.type = notification.getType();
            layoutDataRef.set((Object)layoutData);
        } else {
            BalloonLayoutData.MergeInfo mergeData = ((BalloonLayoutImpl)layout).preMerge(notification);
            if (mergeData != null) {
                BalloonLayoutData layoutData = new BalloonLayoutData();
                layoutData.mergeData = mergeData;
                layoutDataRef.set((Object)layoutData);
            }
        }
        Project disposable2 = project != null ? project : ApplicationManager.getApplication();
        Balloon balloon2 = NotificationsManagerImpl.createBalloon((IdeFrame)window, notification, false, false, (Ref<BalloonLayoutData>)layoutDataRef, (Disposable)disposable2);
        if (notification.isExpired()) {
            return null;
        }
        BalloonLayoutData layoutData = (BalloonLayoutData)layoutDataRef.get();
        layout.add(balloon2, (Object)layoutData);
        if (balloon2.isDisposed()) {
            return null;
        }
        if (layoutData != null) {
            layoutData.project = project;
        }
        if (balloon2 instanceof BalloonImpl) {
            ((BalloonImpl)balloon2).startFadeoutTimer(0);
            if (displayType == NotificationDisplayType.BALLOON || ProjectUtil.getOpenProjects().length == 0) {
                NotificationsManagerImpl.frameActivateBalloonListener((Disposable)balloon2, () -> {
                    if (!balloon2.isDisposed()) {
                        ((BalloonImpl)balloon2).startSmartFadeoutTimer(10000);
                    }
                });
            }
        }
        NotificationCollector.getInstance().logBalloonShown(project, displayType, notification, layoutData != null && layoutData.isExpandable);
        return balloon2;
    }

    public static void frameActivateBalloonListener(@NotNull Disposable parentDisposable, final @NotNull Runnable callback2) {
        if (parentDisposable == null) {
            NotificationsManagerImpl.$$$reportNull$$$0(3);
        }
        if (callback2 == null) {
            NotificationsManagerImpl.$$$reportNull$$$0(4);
        }
        if (ApplicationManager.getApplication().isActive()) {
            callback2.run();
        } else {
            final Disposable listenerDisposable = Disposer.newDisposable();
            Disposer.register((Disposable)parentDisposable, (Disposable)listenerDisposable);
            ApplicationManager.getApplication().getMessageBus().connect(parentDisposable).subscribe(FrameStateListener.TOPIC, (Object)new FrameStateListener(){

                public void onFrameActivated() {
                    Disposer.dispose((Disposable)listenerDisposable);
                    callback2.run();
                }
            });
        }
    }

    @Nullable
    public static Window findWindowForBalloon(@Nullable Project project) {
        Window frame = WindowManager.getInstance().getFrame(project);
        if (frame == null && project == null) {
            frame = (Window)WelcomeFrame.getInstance();
        }
        if (frame == null && project == null) {
            DialogWrapper wrapper2;
            frame = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
            while (frame instanceof DialogWrapperDialog && (wrapper2 = ((DialogWrapperDialog)frame).getDialogWrapper()) != null && wrapper2.isModalProgress()) {
                frame = frame.getOwner();
            }
        }
        if (frame == null && project == null) {
            frame = WindowManager.getInstance().findVisibleFrame();
        }
        return frame;
    }

    @NotNull
    public static Balloon createBalloon(@NotNull IdeFrame window, @NotNull Notification notification, boolean showCallout, boolean hideOnClickOutside, @NotNull Ref<BalloonLayoutData> layoutDataRef, @NotNull Disposable parentDisposable) {
        if (window == null) {
            NotificationsManagerImpl.$$$reportNull$$$0(5);
        }
        if (notification == null) {
            NotificationsManagerImpl.$$$reportNull$$$0(6);
        }
        if (layoutDataRef == null) {
            NotificationsManagerImpl.$$$reportNull$$$0(7);
        }
        if (parentDisposable == null) {
            NotificationsManagerImpl.$$$reportNull$$$0(8);
        }
        return NotificationsManagerImpl.createBalloon(window.getComponent(), notification, showCallout, hideOnClickOutside, layoutDataRef, parentDisposable);
    }

    @NotNull
    public static Balloon createBalloon(@Nullable JComponent windowComponent, @NotNull Notification notification, boolean showCallout, boolean hideOnClickOutside, @NotNull Ref<BalloonLayoutData> layoutDataRef, @NotNull Disposable parentDisposable) {
        Balloon balloon2;
        String style;
        BalloonLayoutData layoutData;
        if (notification == null) {
            NotificationsManagerImpl.$$$reportNull$$$0(9);
        }
        if (layoutDataRef == null) {
            NotificationsManagerImpl.$$$reportNull$$$0(10);
        }
        if (parentDisposable == null) {
            NotificationsManagerImpl.$$$reportNull$$$0(11);
        }
        BalloonLayoutData balloonLayoutData = layoutData = layoutDataRef.isNull() ? new BalloonLayoutData() : (BalloonLayoutData)layoutDataRef.get();
        if (layoutData.groupId == null) {
            layoutData.groupId = notification.getGroupId();
        } else {
            layoutData.groupId = null;
            layoutData.mergeData = null;
        }
        layoutData.id = notification.id;
        layoutData.displayId = notification.getDisplayId();
        layoutDataRef.set((Object)layoutData);
        if (layoutData.textColor == null) {
            layoutData.textColor = JBColor.namedColor((String)"Notification.foreground", (Color)DEFAULT_TEXT_COLOR);
        }
        if (layoutData.fillColor == null) {
            layoutData.fillColor = FILL_COLOR;
        }
        if (layoutData.borderColor == null) {
            layoutData.borderColor = BORDER_COLOR;
        }
        boolean actions2 = !notification.getActions().isEmpty() || notification.getContextHelpAction() != null;
        boolean showFullContent = layoutData.showFullContent || notification instanceof NotificationFullContent;
        JEditorPane text2 = new JEditorPane(){

            @Override
            protected void paintComponent(Graphics g) {
                Point location;
                super.paintComponent(g);
                if (layoutData.showMinSize && (location = NotificationsManagerImpl.getCollapsedTextEndLocation(this, layoutData)) != null) {
                    if (g instanceof Graphics2D) {
                        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                    }
                    g.setColor(this.getForeground());
                    g.drawString("...", location.x, location.y + g.getFontMetrics().getAscent());
                }
            }
        };
        UIUtil.JBWordWrapHtmlEditorKit kit = new UIUtil.JBWordWrapHtmlEditorKit();
        kit.getStyleSheet().addRule("a {color: " + ColorUtil.toHtmlColor((Color)JBUI.CurrentTheme.Link.Foreground.ENABLED) + "}");
        text2.setEditorKit((EditorKit)kit);
        text2.setForeground(layoutData.textColor);
        HyperlinkListener listener2 = NotificationsUtil.wrapListener(notification);
        if (listener2 != null) {
            text2.addHyperlinkListener(listener2);
        }
        String fontStyle = NotificationsUtil.getFontStyle();
        int prefSize = new JLabel((String)NotificationsUtil.buildHtml((Notification)notification, null, (boolean)true, null, (String)fontStyle)).getPreferredSize().width;
        String string = style = prefSize > BalloonLayoutConfiguration.MaxWidth() ? BalloonLayoutConfiguration.MaxWidthStyle() : null;
        if (layoutData.showFullContent) {
            style = prefSize > BalloonLayoutConfiguration.MaxFullContentWidth() ? BalloonLayoutConfiguration.MaxFullContentWidthStyle() : null;
        }
        String textContent = NotificationsUtil.buildHtml(notification, style, true, null, fontStyle);
        text2.setText(textContent);
        NotificationsManagerImpl.setTextAccessibleName(text2, textContent);
        text2.setEditable(false);
        text2.setOpaque(false);
        text2.setBorder(null);
        NonOpaquePanel content2 = new NonOpaquePanel((LayoutManager)new BorderLayout());
        if (text2.getCaret() != null) {
            text2.setCaretPosition(0);
        }
        final JScrollPane pane2 = NotificationsManagerImpl.createBalloonScrollPane(text2, false);
        pane2.getVerticalScrollBar().addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent e) {
                JScrollBar scrollBar = pane2.getVerticalScrollBar();
                if (layoutData.showMinSize && scrollBar.getValue() > 0) {
                    scrollBar.removeAdjustmentListener(this);
                    scrollBar.setValue(0);
                    scrollBar.addAdjustmentListener(this);
                }
            }
        });
        LinkLabel expandAction = null;
        int lines2 = 3;
        if (notification.hasTitle()) {
            --lines2;
        }
        if (actions2) {
            --lines2;
        }
        layoutData.fullHeight = text2.getPreferredSize().height;
        layoutData.twoLineHeight = NotificationsManagerImpl.calculateContentHeight(lines2);
        layoutData.maxScrollHeight = Math.min(layoutData.fullHeight, NotificationsManagerImpl.calculateContentHeight(10));
        layoutData.configuration = BalloonLayoutConfiguration.create(notification, layoutData, actions2);
        if (layoutData.welcomeScreen) {
            layoutData.maxScrollHeight = layoutData.fullHeight;
        } else if (!showFullContent && layoutData.maxScrollHeight != layoutData.fullHeight) {
            pane2.setViewport((JViewport)((Object)new GradientViewport(text2, (Insets)JBInsets.create((int)10, (int)0), true){

                @Override
                @Nullable
                protected Color getViewColor() {
                    return layoutData.fillColor;
                }

                @Override
                protected void paintGradient(Graphics g) {
                    if (!layoutData.showMinSize) {
                        super.paintGradient(g);
                    }
                }
            }));
        }
        NotificationsManagerImpl.configureBalloonScrollPane(pane2, layoutData.fillColor);
        if (showFullContent) {
            if (windowComponent == null) {
                pane2.setPreferredSize(text2.getPreferredSize());
            } else {
                pane2.setPreferredSize(new Dimension(text2.getPreferredSize().width, (int)Math.min((double)layoutData.fullHeight, (double)windowComponent.getHeight() * 0.75)));
            }
        } else if (layoutData.twoLineHeight < layoutData.fullHeight) {
            text2.setPreferredSize(null);
            Dimension size = text2.getPreferredSize();
            size.height = layoutData.twoLineHeight;
            text2.setPreferredSize(size);
            text2.setSize(size);
            layoutData.showMinSize = true;
            pane2.setHorizontalScrollBarPolicy(31);
            pane2.setVerticalScrollBarPolicy(21);
            pane2.setPreferredSize(size);
            text2.setCaret(new TextCaret(layoutData));
            expandAction = new LinkLabel(null, AllIcons.Ide.Notification.Expand, (arg_0, arg_1) -> NotificationsManagerImpl.lambda$createBalloon$6(layoutData, text2, pane2, notification, (JPanel)content2, arg_0, arg_1));
            expandAction.setHoveringIcon(AllIcons.Ide.Notification.ExpandHover);
            layoutData.isExpandable = true;
        }
        NotificationCenterPanel centerPanel = new NotificationCenterPanel(text2, layoutData);
        content2.add((Component)((Object)centerPanel), "Center");
        if (notification.hasTitle()) {
            String titleStyle = StringUtil.defaultIfEmpty((String)fontStyle, (String)"") + "white-space:nowrap;";
            JLabel title2 = new JLabel();
            String titleContent = NotificationsUtil.buildHtml(notification, titleStyle, false, null, null);
            title2.setText(titleContent);
            NotificationsManagerImpl.setTextAccessibleName(title2, titleContent);
            title2.setOpaque(false);
            title2.setForeground(layoutData.textColor);
            centerPanel.addTitle(title2);
        }
        if (expandAction != null) {
            centerPanel.addExpandAction(expandAction);
        }
        if (notification.hasContent()) {
            centerPanel.addContent(layoutData.welcomeScreen ? text2 : pane2);
        }
        if (!layoutData.welcomeScreen) {
            final Icon icon2 = NotificationsUtil.getIcon(notification);
            JComponent iconComponent = new JComponent(){

                @Override
                protected void paintComponent(Graphics g) {
                    super.paintComponent(g);
                    icon2.paintIcon(this, g, layoutData.configuration.iconOffset.width, layoutData.configuration.iconOffset.height);
                }
            };
            iconComponent.setOpaque(false);
            iconComponent.setPreferredSize(new Dimension(layoutData.configuration.iconPanelWidth, 2 * layoutData.configuration.iconOffset.height + icon2.getIconHeight()));
            content2.add((Component)iconComponent, "West");
        }
        HoverAdapter hoverAdapter = new HoverAdapter();
        hoverAdapter.addSource((Component)content2);
        hoverAdapter.addSource((Component)((Object)centerPanel));
        hoverAdapter.addSource(text2);
        hoverAdapter.addSource(pane2);
        if (actions2) {
            NotificationsManagerImpl.createActionPanel(notification, centerPanel, layoutData.configuration.actionGap, hoverAdapter);
        }
        if (expandAction != null) {
            hoverAdapter.addComponent((Component)expandAction, arg_0 -> NotificationsManagerImpl.lambda$createBalloon$7((JPanel)content2, layoutData, text2, pane2, arg_0));
        }
        hoverAdapter.initListeners();
        if (layoutData.mergeData != null) {
            NotificationsManagerImpl.createMergeAction(layoutData, (JPanel)content2);
        }
        text2.setSize(text2.getPreferredSize());
        Dimension paneSize = new Dimension(text2.getPreferredSize());
        int maxWidth = JBUIScale.scale((int)600);
        if (windowComponent != null) {
            maxWidth = Math.min(maxWidth, windowComponent.getWidth() - 20);
        }
        if (paneSize.width > maxWidth) {
            pane2.setPreferredSize(new Dimension(maxWidth, paneSize.height + UIUtil.getScrollBarWidth()));
        }
        BalloonBuilder builder2 = JBPopupFactory.getInstance().createBalloonBuilder((JComponent)content2);
        builder2.setFillColor(layoutData.fillColor).setCloseButtonEnabled(true).setShowCallout(showCallout).setShadow(false).setAnimationCycle(200).setHideOnClickOutside(hideOnClickOutside).setHideOnAction(hideOnClickOutside).setHideOnKeyOutside(hideOnClickOutside).setHideOnFrameResize(false).setBorderColor(layoutData.borderColor).setBorderInsets((Insets)JBUI.emptyInsets());
        if (layoutData.fadeoutTime != 0L) {
            builder2.setFadeoutTime(layoutData.fadeoutTime);
        }
        if ((balloon2 = builder2.createBalloon()) instanceof BalloonImpl) {
            BalloonImpl balloonImpl = (BalloonImpl)balloon2;
            balloonImpl.getContent().addMouseListener(new MouseAdapter(){});
            balloon2.setAnimationEnabled(false);
            balloonImpl.setShadowBorderProvider(new NotificationBalloonShadowBorderProvider(layoutData.fillColor, layoutData.borderColor));
            if (!layoutData.welcomeScreen) {
                balloonImpl.setActionProvider(new NotificationBalloonActionProvider(balloonImpl, centerPanel.getTitle(), layoutData, notification.getGroupId(), notification.id, notification.getDisplayId()));
            }
        }
        notification.setBalloon(balloon2);
        ApplicationManager.getApplication().getMessageBus().connect((Disposable)balloon2).subscribe(LafManagerListener.TOPIC, source -> {
            UIUtil.JBWordWrapHtmlEditorKit newKit = new UIUtil.JBWordWrapHtmlEditorKit();
            newKit.getStyleSheet().addRule("a {color: " + ColorUtil.toHtmlColor((Color)JBUI.CurrentTheme.Link.Foreground.ENABLED) + "}");
            text2.setEditorKit((EditorKit)newKit);
            text2.setText(textContent);
            text2.revalidate();
            text2.repaint();
        });
        Disposer.register((Disposable)parentDisposable, (Disposable)balloon2);
        Balloon balloon3 = balloon2;
        if (balloon3 == null) {
            NotificationsManagerImpl.$$$reportNull$$$0(12);
        }
        return balloon3;
    }

    private static void setTextAccessibleName(@NotNull JComponent component2, @NotNull String htmlContent) {
        if (component2 == null) {
            NotificationsManagerImpl.$$$reportNull$$$0(13);
        }
        if (htmlContent == null) {
            NotificationsManagerImpl.$$$reportNull$$$0(14);
        }
        component2.putClientProperty("AccessibleName", StringUtil.unescapeXmlEntities((String)StringUtil.stripHtml((String)htmlContent, (String)" ")));
    }

    @NotNull
    public static JScrollPane createBalloonScrollPane(@NotNull Component content2, boolean configure2) {
        if (content2 == null) {
            NotificationsManagerImpl.$$$reportNull$$$0(15);
        }
        JScrollPane pane2 = ScrollPaneFactory.createScrollPane((Component)content2, (boolean)true);
        if (configure2) {
            NotificationsManagerImpl.configureBalloonScrollPane(pane2, FILL_COLOR);
        }
        JScrollPane jScrollPane = pane2;
        if (jScrollPane == null) {
            NotificationsManagerImpl.$$$reportNull$$$0(16);
        }
        return jScrollPane;
    }

    public static void configureBalloonScrollPane(@NotNull JScrollPane pane2, @NotNull Color fillColor) {
        if (pane2 == null) {
            NotificationsManagerImpl.$$$reportNull$$$0(17);
        }
        if (fillColor == null) {
            NotificationsManagerImpl.$$$reportNull$$$0(18);
        }
        pane2.setOpaque(false);
        pane2.getViewport().setOpaque(false);
        pane2.setBackground(fillColor);
        pane2.getViewport().setBackground(fillColor);
        pane2.getVerticalScrollBar().setBackground(fillColor);
    }

    private static void createActionPanel(Notification notification, NotificationCenterPanel centerPanel, int gap, HoverAdapter hoverAdapter) {
        AnAction helpAction;
        NotificationActionPanel actionPanel = new NotificationActionPanel(gap, notification.getCollapseDirection());
        centerPanel.addActionPanel(actionPanel);
        List actions2 = notification.getActions();
        if (actions2.size() > 2 && notification.getCollapseDirection() == Notification.CollapseActionsDirection.KEEP_RIGHTMOST) {
            NotificationsManagerImpl.addDropDownAction(notification, actionPanel);
        }
        for (AnAction action2 : actions2) {
            Presentation presentation2 = action2.getTemplatePresentation();
            String text2 = presentation2.getText();
            actionPanel.addActionLink((LinkLabel<AnAction>)new LinkLabel(text2, presentation2.getIcon(), (link2, _action) -> {
                NotificationCollector.getInstance().logNotificationActionInvoked(null, notification, (AnAction)_action, NotificationCollector.NotificationPlace.BALLOON);
                Notification.fire((Notification)notification, (AnAction)_action, (DataContext)DataManager.getInstance().getDataContext((Component)link2));
            }, (Object)action2));
        }
        if (actions2.size() > 2 && notification.getCollapseDirection() == Notification.CollapseActionsDirection.KEEP_LEFTMOST) {
            NotificationsManagerImpl.addDropDownAction(notification, actionPanel);
        }
        if ((helpAction = notification.getContextHelpAction()) != null) {
            Presentation presentation3 = helpAction.getTemplatePresentation();
            ContextHelpLabel helpLabel = new ContextHelpLabel(presentation3.getText(), presentation3.getDescription());
            helpLabel.setForeground(UIUtil.getLabelDisabledForeground());
            actionPanel.addContextHelpLabel(helpLabel);
        }
        JBInsets hover = JBUI.insets((int)8, (int)5, (int)8, (int)7);
        int count = actionPanel.getComponentCount();
        for (int i2 = 0; i2 < count; ++i2) {
            hoverAdapter.addComponent(actionPanel.getComponent(i2), (Insets)hover);
        }
        hoverAdapter.addSource((Component)((Object)actionPanel));
    }

    private static void addDropDownAction(Notification notification, NotificationActionPanel actionPanel) {
        DropDownAction action2 = new DropDownAction(notification.getDropDownText(), (LinkListener<Void>)((LinkListener)(link2, ignored) -> {
            NotificationActionPanel parent = (NotificationActionPanel)((Object)((Object)link2.getParent()));
            DefaultActionGroup group2 = new DefaultActionGroup();
            for (LinkLabel<AnAction> actionLink2 : parent.actionLinks) {
                if (actionLink2.isVisible()) continue;
                group2.add((AnAction)actionLink2.getLinkData());
            }
            NotificationsManagerImpl.showPopup(link2, group2);
        }));
        Notification.setDataProvider((Notification)notification, (JComponent)((Object)action2));
        action2.setVisible(false);
        actionPanel.addGroupedActionsLink(action2);
    }

    private static void createMergeAction(BalloonLayoutData layoutData, JPanel panel2) {
        String shortTitle = NotificationParentGroup.getShortTitle(layoutData.groupId);
        String title2 = shortTitle != null ? IdeBundle.message((String)"notification.manager.merge.n.more.from", (Object[])new Object[]{layoutData.mergeData.count, shortTitle}) : IdeBundle.message((String)"notification.manager.merge.n.more", (Object[])new Object[]{layoutData.mergeData.count});
        LinkListener listener2 = (link2, _layoutData) -> EventLog.showNotification(_layoutData.project, _layoutData.groupId, _layoutData.getMergeIds());
        LinkLabel<BalloonLayoutData> action2 = new LinkLabel<BalloonLayoutData>(title2, null, listener2, layoutData){

            protected boolean isInClickableArea(Point pt) {
                return true;
            }

            protected Color getTextColor() {
                return JBColor.namedColor((String)"Notification.MoreButton.foreground", (Color)new JBColor(0x666666, 0x8C8C8C));
            }
        };
        action2.setFont(FontUtil.minusOne((Font)action2.getFont()));
        action2.setHorizontalAlignment(0);
        action2.setPaintUnderline(false);
        AbstractLayoutManager layout = new AbstractLayoutManager(){

            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(parent.getWidth(), JBUIScale.scale((int)20) + 2);
            }

            public void layoutContainer(Container parent) {
                parent.getComponent(0).setBounds(2, 1, parent.getWidth() - 4, JBUIScale.scale((int)20));
            }
        };
        NonOpaquePanel mergePanel = new NonOpaquePanel((LayoutManager)layout){

            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                g.setColor((Color)JBColor.namedColor((String)"Notification.MoreButton.background", (Color)new JBColor(0xE3E3E3, 3816509)));
                ((Graphics2D)g).fill(new Rectangle2D.Double(1.5, 1.0, (double)this.getWidth() - 2.5, this.getHeight() - 2));
                g.setColor((Color)JBColor.namedColor((String)"Notification.MoreButton.innerBorderColor", (Color)new JBColor(0xDBDBDB, 3487544)));
                if (SystemInfo.isMac) {
                    ((Graphics2D)g).draw(new Rectangle2D.Double(2.0, 0.0, (double)this.getWidth() - 3.5, 0.5));
                } else if (SystemInfo.isWindows) {
                    ((Graphics2D)g).draw(new Rectangle2D.Double(1.5, 0.0, this.getWidth() - 3, 0.5));
                } else {
                    ((Graphics2D)g).draw(new Rectangle2D.Double(1.5, 0.0, (double)this.getWidth() - 2.5, 0.5));
                }
            }
        };
        mergePanel.add((Component)action2);
        panel2.add("South", (Component)mergePanel);
    }

    public static int calculateContentHeight(int lines2) {
        String word = IdeBundle.message((String)"notification.manager.content.height.word", (Object[])new Object[0]);
        String lineBreak = IdeBundle.message((String)"notification.manager.content.height.linebreak", (Object[])new Object[0]);
        String content2 = word + StringUtil.repeat((String)(lineBreak + word), (int)(lines2 - 1));
        JEditorPane text2 = new JEditorPane();
        text2.setEditorKit(UIUtil.getHTMLEditorKit());
        text2.setText(NotificationsUtil.buildHtml(null, null, content2, null, null, null, NotificationsUtil.getFontStyle()));
        text2.setEditable(false);
        text2.setOpaque(false);
        text2.setBorder(null);
        return text2.getPreferredSize().height;
    }

    private static boolean isDummyEnvironment() {
        Application app = ApplicationManager.getApplication();
        return app.isUnitTestMode() || app.isCommandLine();
    }

    private static void showPopup(@NotNull LinkLabel<?> link2, @NotNull DefaultActionGroup group2) {
        if (link2 == null) {
            NotificationsManagerImpl.$$$reportNull$$$0(19);
        }
        if (group2 == null) {
            NotificationsManagerImpl.$$$reportNull$$$0(20);
        }
        if (link2.isShowing()) {
            ActionPopupMenu menu = ActionManager.getInstance().createActionPopupMenu("unknown", (ActionGroup)group2);
            menu.getComponent().show((Component)link2, JBUIScale.scale((int)-10), link2.getHeight() + JBUIScale.scale((int)2));
        }
    }

    @Nullable
    private static Point getCollapsedTextEndLocation(JEditorPane text2, BalloonLayoutData layoutData) {
        try {
            int end = text2.viewToModel2D(new Point(10, layoutData.twoLineHeight + 5));
            if (end == -1) {
                end = text2.getDocument().getLength();
            }
            for (int i2 = end - 1; i2 >= 0; --i2) {
                Rectangle2D r = text2.modelToView2D(i2);
                if (r == null || !(r.getY() < (double)layoutData.twoLineHeight)) continue;
                return r.getBounds().getLocation();
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return null;
    }

    private static int getFirstLineHeight(JEditorPane text2) {
        try {
            int end = text2.getDocument().getLength();
            for (int i2 = 0; i2 < end; ++i2) {
                int height;
                Rectangle2D r = text2.modelToView2D(i2);
                if (r == null || (height = (int)r.getHeight()) <= 0) continue;
                return height;
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return 0;
    }

    private static /* synthetic */ Rectangle lambda$createBalloon$7(JPanel content2, BalloonLayoutData layoutData, JEditorPane text2, JScrollPane pane2, Component component2) {
        Rectangle bounds2;
        Point location = SwingUtilities.convertPoint(content2.getParent(), content2.getLocation(), component2.getParent());
        if (layoutData.showMinSize) {
            JComponent centerComponent = layoutData.welcomeScreen ? text2 : pane2;
            Point centerLocation = SwingUtilities.convertPoint(centerComponent.getParent(), centerComponent.getLocation(), component2.getParent());
            bounds2 = new Rectangle(location.x, centerLocation.y, content2.getWidth(), ((Component)centerComponent).getHeight());
        } else {
            bounds2 = new Rectangle(location.x, component2.getY(), content2.getWidth(), component2.getHeight());
            JBInsets.addTo((Rectangle)bounds2, (Insets)JBUI.insets((int)5, (int)0, (int)7, (int)0));
        }
        return bounds2;
    }

    private static /* synthetic */ void lambda$createBalloon$6(BalloonLayoutData layoutData, JEditorPane text2, JScrollPane pane2, Notification notification, JPanel content2, LinkLabel link2, Void ignored) {
        layoutData.showMinSize = !layoutData.showMinSize;
        text2.setPreferredSize(null);
        Dimension _size = text2.getPreferredSize();
        if (layoutData.showMinSize) {
            _size.height = layoutData.twoLineHeight;
            pane2.setVerticalScrollBarPolicy(21);
            link2.setIcon(AllIcons.Ide.Notification.Expand);
            link2.setHoveringIcon(AllIcons.Ide.Notification.ExpandHover);
            NotificationCollector.getInstance().logNotificationBalloonCollapsed(layoutData.project, notification);
        } else {
            text2.select(0, 0);
            _size.height = layoutData.fullHeight;
            pane2.setVerticalScrollBarPolicy(20);
            link2.setIcon(AllIcons.Ide.Notification.Collapse);
            link2.setHoveringIcon(AllIcons.Ide.Notification.CollapseHover);
            NotificationCollector.getInstance().logNotificationBalloonExpanded(layoutData.project, notification);
        }
        text2.setPreferredSize(_size);
        text2.setSize(_size);
        if (!layoutData.showMinSize) {
            _size = new Dimension(_size.width, layoutData.maxScrollHeight);
        }
        pane2.setPreferredSize(_size);
        content2.doLayout();
        layoutData.doLayout.run();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 12: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 12: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notification";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "klass";
                break;
            }
            case 2: 
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/notification/impl/NotificationsManagerImpl";
                break;
            }
            case 3: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "window";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "layoutDataRef";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "htmlContent";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pane";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fillColor";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "link";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/notification/impl/NotificationsManagerImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getNotificationsOfType";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createBalloon";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "createBalloonScrollPane";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "expire";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getNotificationsOfType";
                break;
            }
            case 2: 
            case 12: 
            case 16: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "frameActivateBalloonListener";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createBalloon";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "setTextAccessibleName";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createBalloonScrollPane";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "configureBalloonScrollPane";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "showPopup";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 12: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class TextCaret
    extends DefaultCaret
    implements UIResource {
        private final BalloonLayoutData myLayoutData;

        TextCaret(@NotNull BalloonLayoutData layoutData) {
            if (layoutData == null) {
                TextCaret.$$$reportNull$$$0(0);
            }
            this.myLayoutData = layoutData;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (!this.myLayoutData.showMinSize) {
                super.mouseClicked(e);
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (!this.myLayoutData.showMinSize) {
                super.mousePressed(e);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (!this.myLayoutData.showMinSize) {
                super.mouseReleased(e);
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            if (!this.myLayoutData.showMinSize) {
                super.mouseEntered(e);
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            if (!this.myLayoutData.showMinSize) {
                super.mouseExited(e);
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (!this.myLayoutData.showMinSize) {
                super.mouseDragged(e);
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            if (!this.myLayoutData.showMinSize) {
                super.mouseMoved(e);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "layoutData", "com/intellij/notification/impl/NotificationsManagerImpl$TextCaret", "<init>"));
        }
    }

    private static class CenteredLayoutWithActions
    extends BorderLayout {
        private final JEditorPane myText;
        private final BalloonLayoutData myLayoutData;
        private JLabel myTitleComponent;
        private Component myCenteredComponent;
        private NotificationActionPanel myActionPanel;
        private Component myExpandAction;

        CenteredLayoutWithActions(JEditorPane text2, BalloonLayoutData layoutData) {
            this.myText = text2;
            this.myLayoutData = layoutData;
        }

        @Nullable
        public Component getTitle() {
            if (this.myTitleComponent != null) {
                return this.myTitleComponent;
            }
            if (this.myCenteredComponent != null) {
                if (this.myCenteredComponent instanceof JScrollPane) {
                    return ((JScrollPane)this.myCenteredComponent).getViewport().getView();
                }
                return this.myCenteredComponent;
            }
            return null;
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return this.layoutSize(component2 -> component2.getPreferredSize());
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return this.layoutSize(component2 -> component2.getMinimumSize());
        }

        private Dimension layoutSize(Function<? super Component, ? extends Dimension> size) {
            Dimension titleSize = this.myTitleComponent == null ? new Dimension() : size.apply(this.myTitleComponent);
            Dimension centeredSize = this.myCenteredComponent == null ? new Dimension() : size.apply(this.myCenteredComponent);
            Dimension actionSize = this.myActionPanel == null ? new Dimension() : size.apply((Component)((Object)this.myActionPanel));
            Dimension expandSize = this.myExpandAction == null || this.myLayoutData.showMinSize ? new Dimension() : size.apply(this.myExpandAction);
            int height = this.myLayoutData.configuration.topSpaceHeight + titleSize.height + centeredSize.height + Math.max(actionSize.height, expandSize.height) + this.myLayoutData.configuration.bottomSpaceHeight;
            if (titleSize.height > 0 && centeredSize.height > 0) {
                height += this.myLayoutData.configuration.titleContentSpaceHeight;
            }
            if (centeredSize.height > 0 && actionSize.height > 0) {
                height += this.myLayoutData.configuration.contentActionsSpaceHeight;
            }
            if (titleSize.height > 0 && actionSize.height > 0) {
                height += this.myLayoutData.configuration.titleActionsSpaceHeight;
            }
            int titleWidth = titleSize.width + this.myLayoutData.configuration.closeOffset;
            int centerWidth = centeredSize.width + this.myLayoutData.configuration.closeOffset;
            int actionWidth = actionSize.width + expandSize.width;
            int width = Math.max(centerWidth, Math.max(titleWidth, actionWidth));
            if (!this.myLayoutData.showFullContent) {
                width = Math.min(width, BalloonLayoutConfiguration.MaxWidth());
            }
            width = Math.max(width, BalloonLayoutConfiguration.MinWidth());
            return new Dimension(width, height);
        }

        @Override
        public void layoutContainer(Container parent) {
            boolean isActions;
            int top = this.myLayoutData.configuration.topSpaceHeight;
            int width = parent.getWidth();
            Dimension centeredSize = this.myCenteredComponent == null ? new Dimension() : this.myCenteredComponent.getPreferredSize();
            boolean bl = isActions = this.myActionPanel != null || this.myExpandAction != null && !this.myLayoutData.showMinSize;
            if (this.myTitleComponent != null) {
                int titleHeight = this.myTitleComponent.getPreferredSize().height;
                this.myTitleComponent.setBounds(0, top, width - this.myLayoutData.configuration.closeOffset, titleHeight);
                top += titleHeight;
                if (this.myCenteredComponent != null) {
                    top += this.myLayoutData.configuration.titleContentSpaceHeight;
                } else if (isActions) {
                    top += this.myLayoutData.configuration.titleActionsSpaceHeight;
                }
            }
            if (this.myCenteredComponent != null) {
                int centeredWidth = width;
                if (!this.myLayoutData.showFullContent && !this.myLayoutData.showMinSize && this.myLayoutData.fullHeight != this.myLayoutData.maxScrollHeight) {
                    --centeredWidth;
                }
                this.myCenteredComponent.setBounds(0, top, centeredWidth, centeredSize.height);
                this.myCenteredComponent.revalidate();
            }
            if (this.myExpandAction != null) {
                Dimension size = this.myExpandAction.getPreferredSize();
                int x = width - size.width - Objects.requireNonNull(this.myLayoutData.configuration.rightActionsOffset).width;
                if (this.myLayoutData.showMinSize) {
                    Point location = NotificationsManagerImpl.getCollapsedTextEndLocation(this.myText, this.myLayoutData);
                    if (location != null) {
                        int y = SwingUtilities.convertPoint((Component)this.myText, (int)location.x, (int)location.y, (Component)parent).y;
                        this.myExpandAction.setBounds(x, y, size.width, size.height);
                    }
                } else {
                    int y = parent.getHeight() - size.height - this.myLayoutData.configuration.bottomSpaceHeight;
                    this.myExpandAction.setBounds(x, y, size.width, size.height);
                }
            }
            if (this.myActionPanel != null) {
                int expandWidth = this.myExpandAction == null || this.myLayoutData.showMinSize ? 0 : this.myExpandAction.getPreferredSize().width;
                width -= this.myLayoutData.configuration.actionGap + expandWidth;
                if (this.myActionPanel.actionLinks.size() > 2) {
                    this.myActionPanel.groupedActionsLink.setVisible(false);
                    for (LinkLabel<AnAction> link2 : this.myActionPanel.actionLinks) {
                        link2.setVisible(true);
                    }
                    this.myActionPanel.doLayout();
                    boolean keepRightmost = this.myActionPanel.collapseActionsDirection == Notification.CollapseActionsDirection.KEEP_RIGHTMOST;
                    int collapseStart = keepRightmost ? 0 : this.myActionPanel.actionLinks.size() - 1;
                    int collapseDelta = keepRightmost ? 1 : -1;
                    int collapseIndex = collapseStart;
                    if (this.myActionPanel.getPreferredSize().width > width) {
                        this.myActionPanel.groupedActionsLink.setVisible(true);
                        this.myActionPanel.actionLinks.get(collapseIndex).setVisible(false);
                        this.myActionPanel.actionLinks.get(collapseIndex += collapseDelta).setVisible(false);
                        collapseIndex += collapseDelta;
                        this.myActionPanel.doLayout();
                        while (this.myActionPanel.getPreferredSize().width > width && collapseIndex >= 0 && collapseIndex < this.myActionPanel.actionLinks.size()) {
                            this.myActionPanel.actionLinks.get(collapseIndex).setVisible(false);
                            collapseIndex += collapseDelta;
                            this.myActionPanel.doLayout();
                        }
                    }
                }
                Dimension size = this.myActionPanel.getPreferredSize();
                int y = parent.getHeight() - size.height - this.myLayoutData.configuration.bottomSpaceHeight;
                this.myActionPanel.setBounds(0, y, width, size.height);
            }
        }
    }

    private static final class NotificationActionPanel
    extends NonOpaquePanel {
        private final List<LinkLabel<AnAction>> actionLinks = new ArrayList<LinkLabel<AnAction>>();
        private final Notification.CollapseActionsDirection collapseActionsDirection;
        private DropDownAction groupedActionsLink;

        private NotificationActionPanel(int gap, Notification.CollapseActionsDirection direction) {
            super((LayoutManager)new HorizontalLayout(gap, 0));
            this.collapseActionsDirection = direction;
        }

        public void addGroupedActionsLink(DropDownAction action2) {
            this.add((Component)((Object)action2));
            this.groupedActionsLink = action2;
        }

        public void addActionLink(LinkLabel<AnAction> label2) {
            this.add("LEFT", (Component)label2);
            this.actionLinks.add(label2);
        }

        public void addContextHelpLabel(ContextHelpLabel label2) {
            this.add("LEFT", (Component)label2);
        }
    }

    private static final class NotificationCenterPanel
    extends NonOpaquePanel {
        private final CenteredLayoutWithActions myLayout = (CenteredLayoutWithActions)this.getLayout();
        private final BalloonLayoutData myLayoutData;

        private NotificationCenterPanel(JEditorPane text2, BalloonLayoutData layoutData) {
            super((LayoutManager)new CenteredLayoutWithActions(text2, layoutData));
            this.myLayoutData = layoutData;
        }

        public void addTitle(JLabel title2) {
            this.add(title2, "North");
            this.myLayout.myTitleComponent = title2;
        }

        public Component getTitle() {
            return this.myLayout.getTitle();
        }

        public void addExpandAction(LinkLabel<Void> action2) {
            this.add((Component)action2, "East");
            this.myLayout.myExpandAction = action2;
        }

        public void addContent(JComponent component2) {
            this.add(component2, "Center");
            this.myLayout.myCenteredComponent = component2;
        }

        public void addActionPanel(NotificationActionPanel panel2) {
            this.add((Component)((Object)panel2), "South");
            this.myLayout.myActionPanel = panel2;
        }

        protected void paintChildren(Graphics g) {
            super.paintChildren(g);
            Component title2 = this.myLayout.getTitle();
            if (title2 != null && this.myLayoutData.showActions != null && ((Boolean)this.myLayoutData.showActions.compute()).booleanValue()) {
                int width = this.myLayoutData.configuration.allActionsOffset;
                int x = this.getWidth() - width - JBUIScale.scale((int)5);
                int y = this.myLayoutData.configuration.topSpaceHeight;
                int height = title2 instanceof JEditorPane ? NotificationsManagerImpl.getFirstLineHeight((JEditorPane)title2) : title2.getHeight();
                g.setColor(this.myLayoutData.fillColor);
                g.fillRect(x, y, width, height);
                width = this.myLayoutData.configuration.beforeGearSpace;
                ((Graphics2D)g).setPaint(new GradientPaint(x -= width, y, ColorUtil.withAlpha((Color)this.myLayoutData.fillColor, (double)0.2), x + width, y, this.myLayoutData.fillColor));
                g.fillRect(x, y, width, height);
            }
        }
    }

    static final class MyNotificationListener
    implements Notifications {
        private final Project myProject;

        MyNotificationListener() {
            this.myProject = null;
        }

        private MyNotificationListener(@Nullable Project project) {
            this.myProject = project;
        }

        public void notify(@NotNull Notification notification) {
            if (notification == null) {
                MyNotificationListener.$$$reportNull$$$0(0);
            }
            ((NotificationsManagerImpl)NotificationsManager.getNotificationsManager()).doNotify(notification, this.myProject);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/intellij/notification/impl/NotificationsManagerImpl$MyNotificationListener", "notify"));
        }
    }

    private static class DropDownAction
    extends LinkLabel<Void> {
        Icon myIcon = AllIcons.Ide.Notification.DropTriangle;

        DropDownAction(@NlsContexts.LinkLabel String text2, @Nullable LinkListener<Void> listener2) {
            super(text2, null, listener2);
            this.setHorizontalTextPosition(10);
            this.setIconTextGap(0);
            this.setIcon(new Icon(){

                @Override
                public void paintIcon(Component c, Graphics g, int x, int y) {
                    IconUtil.colorize((Graphics2D)g, myIcon, this.getTextColor()).paintIcon(c, g, x - 1, y + 1);
                }

                @Override
                public int getIconWidth() {
                    return myIcon.getIconWidth();
                }

                @Override
                public int getIconHeight() {
                    return myIcon.getIconHeight();
                }
            });
        }

        @NotNull
        protected Rectangle getTextBounds() {
            Rectangle bounds2 = super.getTextBounds();
            bounds2.x -= this.getIcon().getIconWidth();
            bounds2.width += 8;
            Rectangle rectangle = bounds2;
            if (rectangle == null) {
                DropDownAction.$$$reportNull$$$0(0);
            }
            return rectangle;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/notification/impl/NotificationsManagerImpl$DropDownAction", "getTextBounds"));
        }
    }

    static final class ProjectNotificationsComponent {
        ProjectNotificationsComponent(@NotNull Project project) {
            if (project == null) {
                ProjectNotificationsComponent.$$$reportNull$$$0(0);
            }
            if (!NotificationsManagerImpl.isDummyEnvironment()) {
                project.getMessageBus().connect().subscribe(Notifications.TOPIC, (Object)new MyNotificationListener(project));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/notification/impl/NotificationsManagerImpl$ProjectNotificationsComponent", "<init>"));
        }
    }

    private static final class HoverAdapter
    extends MouseAdapter
    implements MouseMotionListener {
        private final List<Pair<Component, ?>> myComponents = new ArrayList();
        private List<Component> mySources = new ArrayList<Component>();
        private Component myLastComponent;

        private HoverAdapter() {
        }

        public void addComponent(@NotNull Component component2, @NotNull Function<? super Component, ? extends Rectangle> hover) {
            if (component2 == null) {
                HoverAdapter.$$$reportNull$$$0(0);
            }
            if (hover == null) {
                HoverAdapter.$$$reportNull$$$0(1);
            }
            this.myComponents.add(Pair.create((Object)component2, hover));
        }

        public void addComponent(@NotNull Component component2, @NotNull Insets hover) {
            if (component2 == null) {
                HoverAdapter.$$$reportNull$$$0(2);
            }
            if (hover == null) {
                HoverAdapter.$$$reportNull$$$0(3);
            }
            this.myComponents.add(Pair.create((Object)component2, (Object)hover));
        }

        public void addSource(@NotNull Component component2) {
            if (component2 == null) {
                HoverAdapter.$$$reportNull$$$0(4);
            }
            this.mySources.add(component2);
        }

        public void initListeners() {
            if (!this.myComponents.isEmpty()) {
                for (Component source : this.mySources) {
                    source.addMouseMotionListener(this);
                    source.addMouseListener(this);
                }
                this.mySources = null;
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.handleEvent(e, true, false);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.handleEvent(e, false, false);
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            this.handleEvent(e, false, true);
        }

        @Override
        public void mouseExited(MouseEvent e) {
            if (this.myLastComponent != null) {
                HoverAdapter.mouseExited(e, this.myLastComponent);
                this.myLastComponent = null;
            }
        }

        private void handleEvent(MouseEvent e, boolean pressed, boolean moved) {
            HTMLDocument document;
            AttributeSet attributes2;
            JEditorPane pane2;
            int pos;
            if (e.getSource() instanceof JEditorPane && (pos = (pane2 = (JEditorPane)e.getSource()).viewToModel2D(e.getPoint())) >= 0 && (attributes2 = (document = (HTMLDocument)pane2.getDocument()).getCharacterElement(pos).getAttributes()).getAttribute(HTML.Tag.A) != null) {
                return;
            }
            for (Pair<Component, ?> p : this.myComponents) {
                Rectangle bounds2;
                Component component2 = (Component)p.first;
                if (p.second instanceof Insets) {
                    bounds2 = component2.getBounds();
                    JBInsets.addTo((Rectangle)bounds2, (Insets)((Insets)p.second));
                } else {
                    Function fun = (Function)p.second;
                    bounds2 = (Rectangle)fun.apply(component2);
                }
                if (bounds2.contains(SwingUtilities.convertPoint(e.getComponent(), e.getPoint(), component2.getParent()))) {
                    if (this.myLastComponent != null && this.myLastComponent != component2) {
                        HoverAdapter.mouseExited(e, this.myLastComponent);
                    }
                    this.myLastComponent = component2;
                    MouseEvent event = HoverAdapter.createEvent(e, component2);
                    if (moved) {
                        for (MouseMotionListener listener2 : component2.getMouseMotionListeners()) {
                            listener2.mouseMoved(event);
                        }
                    } else {
                        for (MouseListener listener3 : component2.getMouseListeners()) {
                            if (pressed) {
                                listener3.mousePressed(event);
                                continue;
                            }
                            listener3.mouseReleased(event);
                        }
                    }
                    e.getComponent().setCursor(component2.getCursor());
                    return;
                }
                if (component2 != this.myLastComponent) continue;
                this.myLastComponent = null;
                HoverAdapter.mouseExited(e, component2);
            }
        }

        private static void mouseExited(MouseEvent e, Component component2) {
            MouseListener[] listeners2;
            e.getComponent().setCursor(null);
            MouseEvent event = HoverAdapter.createEvent(e, component2);
            for (MouseListener listener2 : listeners2 = component2.getMouseListeners()) {
                listener2.mouseExited(event);
            }
        }

        private static MouseEvent createEvent(MouseEvent e, Component c) {
            return new MouseEvent(c, e.getID(), e.getWhen(), e.getModifiers(), 5, 5, e.getClickCount(), e.isPopupTrigger(), e.getButton());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "hover";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/notification/impl/NotificationsManagerImpl$HoverAdapter";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addComponent";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addSource";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

