/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notification;

import com.intellij.notification.EventLog;
import com.intellij.notification.EventLogListener;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.impl.NotificationsConfigurationImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.UIUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LogModel {
    public static final Topic<EventLogListener> LOG_MODEL_CHANGED = Topic.create((String)"LOG_MODEL_CHANGED", EventLogListener.class, (Topic.BroadcastDirection)Topic.BroadcastDirection.NONE);
    private final List<Notification> myNotifications = new ArrayList<Notification>();
    private final Map<Notification, @NlsContexts.StatusBarText String> myStatuses = CollectionFactory.createConcurrentWeakIdentityMap();
    private Trinity<Notification, @NlsContexts.StatusBarText String, Long> myStatusMessage;
    private final Project myProject;
    final Map<Notification, Runnable> removeHandlers = new HashMap<Notification, Runnable>();

    LogModel(@Nullable Project project) {
        this.myProject = project;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addNotification(Notification notification) {
        long stamp = System.currentTimeMillis();
        NotificationDisplayType type = NotificationsConfigurationImpl.getSettings(notification.getGroupId()).getDisplayType();
        this.myStatuses.put(notification, EventLog.formatForLog((Notification)notification, (String)"").status);
        if (notification.isImportant() || type != NotificationDisplayType.NONE && type != NotificationDisplayType.TOOL_WINDOW) {
            List<Notification> list2 = this.myNotifications;
            synchronized (list2) {
                this.myNotifications.add(notification);
            }
        }
        this.setStatusMessage(notification, stamp);
        LogModel.fireModelChanged();
    }

    private static void fireModelChanged() {
        ((EventLogListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(LOG_MODEL_CHANGED)).modelChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<Notification> takeNotifications() {
        ArrayList<Notification> result2;
        List<Notification> list2 = this.myNotifications;
        synchronized (list2) {
            result2 = this.getNotifications();
            this.myNotifications.clear();
        }
        if (!result2.isEmpty()) {
            LogModel.fireModelChanged();
        }
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setStatusMessage(@Nullable Notification statusMessage, long stamp) {
        List<Notification> list2 = this.myNotifications;
        synchronized (list2) {
            if (this.myStatusMessage != null && this.myStatusMessage.first == statusMessage) {
                return;
            }
            if (this.myStatusMessage == null && statusMessage == null) {
                return;
            }
            this.myStatusMessage = statusMessage == null ? null : Trinity.create((Object)statusMessage, (Object)Objects.requireNonNull(this.myStatuses.get(statusMessage)), (Object)stamp);
        }
        StatusBar.Info.set((String)"", (Project)this.myProject, (String)"Internal log requestor");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable Trinity<Notification, @NlsContexts.StatusBarText String, Long> getStatusMessage() {
        List<Notification> list2 = this.myNotifications;
        synchronized (list2) {
            return this.myStatusMessage;
        }
    }

    void logShown() {
        for (Notification notification : this.getNotifications()) {
            if (notification.isImportant()) continue;
            this.removeNotification(notification);
        }
        this.setStatusToImportant();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void projectDispose(@Nullable LogModel applicationModel) {
        List<Notification> list2;
        if (applicationModel != null) {
            list2 = applicationModel.myNotifications;
            synchronized (list2) {
                applicationModel.myNotifications.removeAll(this.myNotifications);
                for (Notification notification : this.myNotifications) {
                    applicationModel.myStatuses.remove(notification);
                    applicationModel.removeHandlers.remove(notification);
                }
            }
        }
        list2 = this.myNotifications;
        synchronized (list2) {
            this.myNotifications.clear();
            this.myStatuses.clear();
            this.removeHandlers.clear();
            this.myStatusMessage = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public ArrayList<Notification> getNotifications() {
        List<Notification> list2 = this.myNotifications;
        // MONITORENTER : list2
        ArrayList<Notification> arrayList = new ArrayList<Notification>(this.myNotifications);
        // MONITOREXIT : list2
        if (arrayList != null) return arrayList;
        LogModel.$$$reportNull$$$0(0);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNotification(Notification notification) {
        Trinity<Notification, String, Long> oldStatus;
        List<Notification> list2 = this.myNotifications;
        synchronized (list2) {
            this.myNotifications.remove(notification);
        }
        Runnable handler2 = this.removeHandlers.remove(notification);
        if (handler2 != null) {
            UIUtil.invokeLaterIfNeeded((Runnable)handler2);
        }
        if ((oldStatus = this.getStatusMessage()) != null && notification == oldStatus.first) {
            this.setStatusToImportant();
        }
        LogModel.fireModelChanged();
    }

    private void setStatusToImportant() {
        ArrayList<Notification> notifications = this.getNotifications();
        Collections.reverse(notifications);
        Notification message2 = (Notification)ContainerUtil.find(notifications, Notification::isImportant);
        if (message2 == null) {
            this.setStatusMessage(null, 0L);
        } else {
            this.setStatusMessage(message2, message2.getTimestamp());
        }
    }

    public Project getProject() {
        return this.myProject;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/notification/LogModel", "getNotifications"));
    }
}

