/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.largeFilesEditor.editor;

import com.intellij.codeHighlighting.BackgroundEditorHighlighter;
import com.intellij.largeFilesEditor.PlatformActionsReplacer;
import com.intellij.largeFilesEditor.editor.EditorModel;
import com.intellij.largeFilesEditor.editor.LargeFileEditor;
import com.intellij.largeFilesEditor.editor.LargeFileEditorState;
import com.intellij.largeFilesEditor.editor.Page;
import com.intellij.largeFilesEditor.editor.PropertiesGetter;
import com.intellij.largeFilesEditor.encoding.LargeFileEditorAccess;
import com.intellij.largeFilesEditor.file.LargeFileManager;
import com.intellij.largeFilesEditor.file.LargeFileManagerImpl;
import com.intellij.largeFilesEditor.file.ReadingPageResultHandler;
import com.intellij.largeFilesEditor.search.LfeSearchManager;
import com.intellij.largeFilesEditor.search.LfeSearchManagerImpl;
import com.intellij.largeFilesEditor.search.RangeSearchCreatorImpl;
import com.intellij.largeFilesEditor.search.SearchResult;
import com.intellij.largeFilesEditor.search.searchTask.FileDataProviderForSearch;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.undo.UndoUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorBundle;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.fileEditor.FileEditorLocation;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.fileEditor.impl.FileDocumentManagerImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import java.beans.PropertyChangeListener;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LargeFileEditorImpl
extends UserDataHolderBase
implements LargeFileEditor {
    private static final Logger logger = Logger.getInstance(LargeFileEditorImpl.class);
    private final Project project;
    private LargeFileManager fileManager;
    private final EditorModel editorModel;
    private final VirtualFile vFile;
    private LfeSearchManager searchManager;

    public LargeFileEditorImpl(Project project, VirtualFile vFile) {
        this.vFile = vFile;
        this.project = project;
        int customPageSize = PropertiesGetter.getPageSize();
        int customBorderShift = PropertiesGetter.getMaxPageBorderShiftBytes();
        DocumentEx document = LargeFileEditorImpl.createSpecialDocument();
        this.editorModel = new EditorModel(document, project, this.implementDataProviderForEditorModel());
        this.editorModel.putUserDataToEditor(LARGE_FILE_EDITOR_MARK_KEY, new Object());
        this.editorModel.putUserDataToEditor(LARGE_FILE_EDITOR_KEY, this);
        try {
            this.fileManager = new LargeFileManagerImpl(vFile, customPageSize, customBorderShift);
        }
        catch (FileNotFoundException e) {
            logger.warn((Throwable)e);
            this.editorModel.setBrokenMode();
            Messages.showWarningDialog((String)EditorBundle.message((String)"large.file.editor.message.cant.open.file.because.file.not.found", (Object[])new Object[0]), (String)EditorBundle.message((String)"large.file.editor.title.warning", (Object[])new Object[0]));
            this.requestClosingEditorTab();
            return;
        }
        this.searchManager = new LfeSearchManagerImpl(this, this.fileManager.getFileDataProviderForSearch(), new RangeSearchCreatorImpl());
        PlatformActionsReplacer.makeAdaptingOfPlatformActionsIfNeed();
        this.editorModel.addCaretListener(new MyCaretListener());
        this.fileManager.addFileChangeListener((lastPage, isLengthIncreased) -> ApplicationManager.getApplication().invokeLater(() -> this.editorModel.onFileChanged(lastPage, isLengthIncreased)));
    }

    private void requestClosingEditorTab() {
        ApplicationManager.getApplication().invokeLater(() -> FileEditorManager.getInstance((Project)this.project).closeFile(this.vFile));
    }

    @Override
    public LfeSearchManager getSearchManager() {
        return this.searchManager;
    }

    @NotNull
    public JComponent getComponent() {
        JComponent jComponent = this.editorModel.getComponent();
        if (jComponent == null) {
            LargeFileEditorImpl.$$$reportNull$$$0(0);
        }
        return jComponent;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.editorModel.getEditor().getContentComponent();
    }

    @NotNull
    public String getName() {
        String string = EditorBundle.message((String)"large.file.editor.title", (Object[])new Object[0]);
        if (string == null) {
            LargeFileEditorImpl.$$$reportNull$$$0(1);
        }
        return string;
    }

    public void setState(@NotNull FileEditorState state) {
        if (state == null) {
            LargeFileEditorImpl.$$$reportNull$$$0(2);
        }
        if (state instanceof LargeFileEditorState) {
            LargeFileEditorState largeFileEditorState = (LargeFileEditorState)state;
            this.editorModel.setCaretAndShow(largeFileEditorState.caretPageNumber, largeFileEditorState.caretSymbolOffsetInPage);
        }
    }

    @NotNull
    public FileEditorState getState(@NotNull FileEditorStateLevel level) {
        if (level == null) {
            LargeFileEditorImpl.$$$reportNull$$$0(3);
        }
        LargeFileEditorState state = new LargeFileEditorState();
        state.caretPageNumber = this.editorModel.getCaretPageNumber();
        state.caretSymbolOffsetInPage = this.editorModel.getCaretPageOffset();
        LargeFileEditorState largeFileEditorState = state;
        if (largeFileEditorState == null) {
            LargeFileEditorImpl.$$$reportNull$$$0(4);
        }
        return largeFileEditorState;
    }

    public boolean isModified() {
        return false;
    }

    public boolean isValid() {
        return true;
    }

    public void selectNotify() {
    }

    public void deselectNotify() {
    }

    public void addPropertyChangeListener(@NotNull PropertyChangeListener listener2) {
        if (listener2 == null) {
            LargeFileEditorImpl.$$$reportNull$$$0(5);
        }
    }

    public void removePropertyChangeListener(@NotNull PropertyChangeListener listener2) {
        if (listener2 == null) {
            LargeFileEditorImpl.$$$reportNull$$$0(6);
        }
    }

    @Nullable
    public BackgroundEditorHighlighter getBackgroundHighlighter() {
        return null;
    }

    @Nullable
    public FileEditorLocation getCurrentLocation() {
        return null;
    }

    public void dispose() {
        if (this.searchManager != null) {
            this.searchManager.dispose();
        }
        if (this.fileManager != null) {
            Disposer.dispose((Disposable)this.fileManager);
        }
        this.editorModel.dispose();
        this.vFile.putUserData(FileDocumentManagerImpl.HARD_REF_TO_DOCUMENT_KEY, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @RequiresEdt
    public void showSearchResult(SearchResult searchResult) {
        void searchResult2;
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.editorModel.showSearchResult((SearchResult)searchResult2);
    }

    @Override
    public Project getProject() {
        return this.project;
    }

    @Override
    public long getCaretPageNumber() {
        return this.editorModel.getCaretPageNumber();
    }

    @Override
    public int getCaretPageOffset() {
        return this.editorModel.getCaretPageOffset();
    }

    @Override
    public Editor getEditor() {
        return this.editorModel.getEditor();
    }

    @Override
    @NotNull
    public VirtualFile getFile() {
        VirtualFile virtualFile2 = this.vFile;
        if (virtualFile2 == null) {
            LargeFileEditorImpl.$$$reportNull$$$0(7);
        }
        return virtualFile2;
    }

    @Override
    public LargeFileEditorAccess createAccessForEncodingWidget() {
        return new LargeFileEditorAccess(){

            @Override
            @NotNull
            public VirtualFile getVirtualFile() {
                VirtualFile virtualFile2 = LargeFileEditorImpl.this.getFile();
                if (virtualFile2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                return virtualFile2;
            }

            @Override
            @NotNull
            public Editor getEditor() {
                Editor editor = LargeFileEditorImpl.this.getEditor();
                if (editor == null) {
                    1.$$$reportNull$$$0(1);
                }
                return editor;
            }

            @Override
            public boolean tryChangeEncoding(@NotNull Charset charset) {
                if (charset == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (LargeFileEditorImpl.this.fileManager.hasBOM()) {
                    Messages.showWarningDialog((String)EditorBundle.message((String)"large.file.editor.message.cant.change.encoding.because.it.has.bom.byte.order.mark", (Object[])new Object[0]), (String)EditorBundle.message((String)"large.file.editor.title.warning", (Object[])new Object[0]));
                    return false;
                }
                if (LargeFileEditorImpl.this.searchManager.isSearchWorkingNow()) {
                    Messages.showInfoMessage((String)EditorBundle.message((String)"large.file.editor.message.cant.change.encoding.because.search.is.working.now", (Object[])new Object[0]), (String)EditorBundle.message((String)"large.file.editor.title.cant.change.encoding", (Object[])new Object[0]));
                    return false;
                }
                LargeFileEditorImpl.this.fileManager.reset(charset);
                LargeFileEditorImpl.this.editorModel.onEncodingChanged();
                return true;
            }

            @Override
            public String getCharsetName() {
                return LargeFileEditorImpl.this.fileManager.getCharsetName();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 2: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 2: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/largeFilesEditor/editor/LargeFileEditorImpl$1";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "charset";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getVirtualFile";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getEditor";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/largeFilesEditor/editor/LargeFileEditorImpl$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "tryChangeEncoding";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 2: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    @Override
    public FileDataProviderForSearch getFileDataProviderForSearch() {
        return this.fileManager.getFileDataProviderForSearch();
    }

    @Override
    @NotNull
    public EditorModel getEditorModel() {
        EditorModel editorModel = this.editorModel;
        if (editorModel == null) {
            LargeFileEditorImpl.$$$reportNull$$$0(8);
        }
        return editorModel;
    }

    @Override
    public int getPageSize() {
        return this.fileManager.getPageSize();
    }

    private static DocumentEx createSpecialDocument() {
        DocumentImpl doc = new DocumentImpl("", false, false);
        doc.putUserData(FileDocumentManagerImpl.NOT_RELOADABLE_DOCUMENT_KEY, new Object());
        UndoUtil.disableUndoFor((Document)doc);
        return doc;
    }

    private EditorModel.DataProvider implementDataProviderForEditorModel() {
        return new EditorModel.DataProvider(){

            @Override
            public Page getPage(long pageNumber) throws IOException {
                return LargeFileEditorImpl.this.fileManager.getPage_wait(pageNumber);
            }

            @Override
            public long getPagesAmount() throws IOException {
                return LargeFileEditorImpl.this.fileManager.getPagesAmount();
            }

            @Override
            public Project getProject() {
                return LargeFileEditorImpl.this.project;
            }

            @Override
            public void requestReadPage(long pageNumber, ReadingPageResultHandler readingPageResultHandler) {
                LargeFileEditorImpl.this.fileManager.requestReadPage(pageNumber, readingPageResultHandler);
            }

            @Override
            public List<SearchResult> getSearchResultsInPage(Page page) {
                if (LargeFileEditorImpl.this.searchManager != null) {
                    return LargeFileEditorImpl.this.searchManager.getSearchResultsInPage(page);
                }
                return null;
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/largeFilesEditor/editor/LargeFileEditorImpl";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/largeFilesEditor/editor/LargeFileEditorImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditorModel";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setState";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getState";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addPropertyChangeListener";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "removePropertyChangeListener";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyCaretListener
    implements CaretListener {
        private MyCaretListener() {
        }

        public void caretPositionChanged(@NotNull CaretEvent e) {
            if (e == null) {
                MyCaretListener.$$$reportNull$$$0(0);
            }
            LargeFileEditorImpl.this.searchManager.onCaretPositionChanged(e);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/largeFilesEditor/editor/LargeFileEditorImpl$MyCaretListener", "caretPositionChanged"));
        }
    }
}

