/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.json.psi;

import com.intellij.json.psi.JsonElementGenerator;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.AbstractElementManipulator;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class JsonStringLiteralManipulator
extends AbstractElementManipulator<JsonStringLiteral> {
    public JsonStringLiteral handleContentChange(@NotNull JsonStringLiteral element2, @NotNull TextRange range2, String newContent) throws IncorrectOperationException {
        if (element2 == null) {
            JsonStringLiteralManipulator.$$$reportNull$$$0(0);
        }
        if (range2 == null) {
            JsonStringLiteralManipulator.$$$reportNull$$$0(1);
        }
        assert (new TextRange(0, element2.getTextLength()).contains(range2));
        String originalContent = element2.getText();
        TextRange withoutQuotes = this.getRangeInElement(element2);
        JsonElementGenerator generator = new JsonElementGenerator(element2.getProject());
        String replacement = originalContent.substring(withoutQuotes.getStartOffset(), range2.getStartOffset()) + newContent + originalContent.substring(range2.getEndOffset(), withoutQuotes.getEndOffset());
        return (JsonStringLiteral)element2.replace(generator.createStringLiteral(replacement));
    }

    @NotNull
    public TextRange getRangeInElement(@NotNull JsonStringLiteral element2) {
        String content2;
        if (element2 == null) {
            JsonStringLiteralManipulator.$$$reportNull$$$0(2);
        }
        int startOffset = (content2 = element2.getText()).startsWith("'") || content2.startsWith("\"") ? 1 : 0;
        int endOffset = content2.length() > 1 && (content2.endsWith("'") || content2.endsWith("\"")) ? -1 : 0;
        return new TextRange(startOffset, content2.length() + endOffset);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
        }
        objectArray2[1] = "com/intellij/json/psi/JsonStringLiteralManipulator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "handleContentChange";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getRangeInElement";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

