/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.json.codeinsight;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.icons.AllIcons;
import com.intellij.json.JsonBundle;
import com.intellij.json.psi.JsonElementVisitor;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.jsonSchema.ide.JsonSchemaService;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonDuplicatePropertyKeysInspection
extends LocalInspectionTool {
    private static final String COMMENT = "$comment";

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            JsonDuplicatePropertyKeysInspection.$$$reportNull$$$0(0);
        }
        final boolean isSchemaFile = JsonSchemaService.isSchemaFile(holder.getFile());
        return new JsonElementVisitor(){

            @Override
            public void visitObject(@NotNull JsonObject o) {
                if (o == null) {
                    1.$$$reportNull$$$0(0);
                }
                MultiMap keys2 = new MultiMap();
                for (JsonProperty property2 : o.getPropertyList()) {
                    keys2.putValue((Object)property2.getName(), (Object)property2.getNameElement());
                }
                for (Map.Entry entry2 : keys2.entrySet()) {
                    Collection sameNamedKeys = (Collection)entry2.getValue();
                    String entryKey = (String)entry2.getKey();
                    if (sameNamedKeys.size() <= 1 || isSchemaFile && JsonDuplicatePropertyKeysInspection.COMMENT.equalsIgnoreCase(entryKey)) continue;
                    for (PsiElement element2 : sameNamedKeys) {
                        holder.registerProblem(element2, JsonBundle.message("inspection.duplicate.keys.msg.duplicate.keys", entryKey), new LocalQuickFix[]{new NavigateToDuplicatesFix(sameNamedKeys, element2, entryKey)});
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/json/codeinsight/JsonDuplicatePropertyKeysInspection$1", "visitObject"));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/json/codeinsight/JsonDuplicatePropertyKeysInspection", "buildVisitor"));
    }

    private static final class NavigateToDuplicatesFix
    extends LocalQuickFixAndIntentionActionOnPsiElement {
        @NotNull
        private final Collection<SmartPsiElementPointer> mySameNamedKeys;
        @NotNull
        private final String myEntryKey;

        private NavigateToDuplicatesFix(@NotNull Collection<PsiElement> sameNamedKeys, @NotNull PsiElement element2, @NotNull String entryKey) {
            if (sameNamedKeys == null) {
                NavigateToDuplicatesFix.$$$reportNull$$$0(0);
            }
            if (element2 == null) {
                NavigateToDuplicatesFix.$$$reportNull$$$0(1);
            }
            if (entryKey == null) {
                NavigateToDuplicatesFix.$$$reportNull$$$0(2);
            }
            super(element2);
            this.mySameNamedKeys = ContainerUtil.map(sameNamedKeys, k -> SmartPointerManager.createPointer((PsiElement)k));
            this.myEntryKey = entryKey;
        }

        @NotNull
        public String getText() {
            String string = JsonBundle.message("navigate.to.duplicates", new Object[0]);
            if (string == null) {
                NavigateToDuplicatesFix.$$$reportNull$$$0(3);
            }
            return string;
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = this.getText();
            if (string == null) {
                NavigateToDuplicatesFix.$$$reportNull$$$0(4);
            }
            return string;
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile file2, final @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            if (project == null) {
                NavigateToDuplicatesFix.$$$reportNull$$$0(5);
            }
            if (file2 == null) {
                NavigateToDuplicatesFix.$$$reportNull$$$0(6);
            }
            if (startElement == null) {
                NavigateToDuplicatesFix.$$$reportNull$$$0(7);
            }
            if (endElement == null) {
                NavigateToDuplicatesFix.$$$reportNull$$$0(8);
            }
            if (editor == null) {
                return;
            }
            if (this.mySameNamedKeys.size() == 2) {
                PsiElement toNavigate;
                Iterator<SmartPsiElementPointer> iterator2 = this.mySameNamedKeys.iterator();
                PsiElement next = iterator2.next().getElement();
                PsiElement psiElement = toNavigate = next != startElement ? next : iterator2.next().getElement();
                if (toNavigate == null) {
                    return;
                }
                NavigateToDuplicatesFix.navigateTo(editor, toNavigate);
            } else {
                List allElements = this.mySameNamedKeys.stream().map(k -> k.getElement()).filter(k -> k != startElement).collect(Collectors.toList());
                JBPopupFactory.getInstance().createListPopup((ListPopupStep)new BaseListPopupStep<PsiElement>(JsonBundle.message("navigate.to.duplicates.header", this.myEntryKey), allElements){

                    @NotNull
                    public Icon getIconFor(PsiElement aValue) {
                        Icon icon2 = AllIcons.Nodes.Property;
                        if (icon2 == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        return icon2;
                    }

                    @NotNull
                    public String getTextFor(PsiElement value2) {
                        String string = JsonBundle.message("navigate.to.duplicates.desc", myEntryKey, editor.getDocument().getLineNumber(value2.getTextOffset()));
                        if (string == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        return string;
                    }

                    public int getDefaultOptionIndex() {
                        return 0;
                    }

                    @Nullable
                    public PopupStep onChosen(PsiElement selectedValue, boolean finalChoice) {
                        NavigateToDuplicatesFix.navigateTo(editor, selectedValue);
                        return PopupStep.FINAL_CHOICE;
                    }

                    public boolean isSpeedSearchEnabled() {
                        return true;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[2];
                        objectArray2[0] = "com/intellij/json/codeinsight/JsonDuplicatePropertyKeysInspection$NavigateToDuplicatesFix$1";
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[1] = "getIconFor";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[1] = "getTextFor";
                                break;
                            }
                        }
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
                    }
                }).showInBestPositionFor(editor);
            }
        }

        private static void navigateTo(@NotNull Editor editor, @NotNull PsiElement toNavigate) {
            if (editor == null) {
                NavigateToDuplicatesFix.$$$reportNull$$$0(9);
            }
            if (toNavigate == null) {
                NavigateToDuplicatesFix.$$$reportNull$$$0(10);
            }
            editor.getCaretModel().moveToOffset(toNavigate.getTextOffset());
            editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sameNamedKeys";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "entryKey";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/json/codeinsight/JsonDuplicatePropertyKeysInspection$NavigateToDuplicatesFix";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "endElement";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "toNavigate";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/json/codeinsight/JsonDuplicatePropertyKeysInspection$NavigateToDuplicatesFix";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
                case 9: 
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "navigateTo";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

