/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.collectors.fus.ui;

import com.intellij.ide.ui.LafManager;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.beans.MetricEventFactoryKt;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.service.fus.collectors.ApplicationUsagesCollector;
import com.intellij.jdkEx.JdkEx;
import com.intellij.openapi.actionSystem.ex.QuickListsManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.JreHiDpiUtil;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.accessibility.ScreenReader;
import java.awt.DisplayMode;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.Set;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.jetbrains.annotations.NotNull;

final class UiInfoUsageCollector
extends ApplicationUsagesCollector {
    private static final Logger LOG = Logger.getInstance(UiInfoUsageCollector.class);

    UiInfoUsageCollector() {
    }

    @NotNull
    public String getGroupId() {
        return "ui.info.features";
    }

    public int getVersion() {
        return 10;
    }

    @NotNull
    public Set<MetricEvent> getMetrics() {
        return UiInfoUsageCollector.getDescriptors();
    }

    @NotNull
    public static Set<MetricEvent> getDescriptors() {
        HashSet<MetricEvent> set2 = new HashSet<MetricEvent>();
        UiInfoUsageCollector.addValue(set2, "Nav.Bar", UiInfoUsageCollector.navbar() ? "visible" : "floating");
        UiInfoUsageCollector.addValue(set2, "Nav.Bar.members", UISettings.getInstance().getShowMembersInNavigationBar() ? "visible" : "hidden");
        UiInfoUsageCollector.addValue(set2, "Toolbar", UiInfoUsageCollector.toolbar() ? "visible" : "hidden");
        UiInfoUsageCollector.addValue(set2, "Toolbar.and.NavBar", new FeatureUsageData().addData("toolbar", UiInfoUsageCollector.toolbar() ? "visible" : "hidden").addData("navbar", UiInfoUsageCollector.navbar() ? "visible" : "hidden"));
        UiInfoUsageCollector.addEnabled(set2, "Retina", UIUtil.isRetina());
        PropertiesComponent properties = PropertiesComponent.getInstance();
        UiInfoUsageCollector.addEnabled(set2, "QuickDoc.Show.Toolwindow", properties.isTrueValue("ShowDocumentationInToolWindow"));
        UiInfoUsageCollector.addEnabled(set2, "QuickDoc.AutoUpdate", properties.getBoolean("DocumentationAutoUpdateEnabled", true));
        UIManager.LookAndFeelInfo laf = LafManager.getInstance().getCurrentLookAndFeel();
        UiInfoUsageCollector.addValue(set2, "Look.and.Feel", StringUtil.notNullize((String)(laf != null ? laf.getName() : null), (String)"unknown"));
        UiInfoUsageCollector.addValue(set2, "Hidpi.Mode", JreHiDpiUtil.isJreHiDPIEnabled() ? "per_monitor_dpi" : "system_dpi");
        UiInfoUsageCollector.addEnabled(set2, "Screen.Reader", ScreenReader.isActive());
        set2.add(MetricEventFactoryKt.newMetric((String)"QuickListsCount", (int)QuickListsManager.getInstance().getAllQuickLists().length));
        UiInfoUsageCollector.addScreenScale(set2);
        UiInfoUsageCollector.addNumberOfMonitors(set2);
        UiInfoUsageCollector.addScreenResolutions(set2);
        HashSet<MetricEvent> hashSet = set2;
        if (hashSet == null) {
            UiInfoUsageCollector.$$$reportNull$$$0(0);
        }
        return hashSet;
    }

    private static String getDeviceScreenInfo(GraphicsDevice device) {
        GraphicsConfiguration conf = device.getDefaultConfiguration();
        Rectangle rect = conf.getBounds();
        String info2 = rect.width + "x" + rect.height;
        float scale = JBUIScale.sysScale((GraphicsConfiguration)conf);
        if (scale != 1.0f) {
            info2 = info2 + " (" + (int)(scale * 100.0f) + "%)";
        }
        return info2;
    }

    private static void addScreenResolutions(Set<MetricEvent> set2) {
        GraphicsDevice[] devices = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices();
        for (int i2 = 0; i2 < devices.length; ++i2) {
            String info2 = UiInfoUsageCollector.getDeviceScreenInfo(devices[i2]);
            FeatureUsageData data2 = new FeatureUsageData().addValue((Object)info2).addData("display_id", i2);
            set2.add(MetricEventFactoryKt.newMetric((String)"Screen.Resolution", (FeatureUsageData)data2));
        }
    }

    private static void addNumberOfMonitors(Set<MetricEvent> set2) {
        int numberOfMonitors = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices().length;
        UiInfoUsageCollector.addValue(set2, "Number.Of.Monitors", String.valueOf(numberOfMonitors));
    }

    private static void addValue(Set<? super MetricEvent> set2, String key, FeatureUsageData data2) {
        set2.add((MetricEvent)MetricEventFactoryKt.newMetric((String)key, (FeatureUsageData)data2));
    }

    private static void addValue(Set<? super MetricEvent> set2, String key, String value2) {
        set2.add((MetricEvent)MetricEventFactoryKt.newMetric((String)key, (FeatureUsageData)new FeatureUsageData().addValue((Object)value2)));
    }

    private static void addEnabled(Set<? super MetricEvent> set2, String key, boolean enabled) {
        set2.add((MetricEvent)MetricEventFactoryKt.newBooleanMetric((String)key, (boolean)enabled));
    }

    private static boolean toolbar() {
        return UISettings.getInstance().getShowMainToolbar();
    }

    private static boolean navbar() {
        return UISettings.getInstance().getShowNavigationBar();
    }

    private static void addScreenScale(Set<? super MetricEvent> set2) {
        int scaleBase;
        float scale = JBUIScale.sysScale();
        float scaleFract = scale - (float)(scaleBase = (int)Math.floor(scale));
        scaleFract = scaleFract == 0.0f ? 0.0f : (scaleFract < 0.375f ? 0.25f : (scaleFract < 0.625f ? 0.5f : 0.75f));
        scale = (float)scaleBase + scaleFract;
        Ref isScaleMode = new Ref();
        if (!GraphicsEnvironment.isHeadless()) {
            try {
                SwingUtilities.invokeAndWait(() -> {
                    DisplayMode dm = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDisplayMode();
                    isScaleMode.set((Object)(dm != null && JdkEx.getDisplayModeEx().isDefault(dm) ? 1 : 0));
                });
            }
            catch (InvocationTargetException e) {
                LOG.error((Throwable)e);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        FeatureUsageData data2 = new FeatureUsageData().addData("scale", scale);
        if (!isScaleMode.isNull()) {
            data2.addData("scale_mode", ((Boolean)isScaleMode.get()).booleanValue());
        }
        set2.add((MetricEvent)MetricEventFactoryKt.newMetric((String)"Screen.Scale", (FeatureUsageData)data2));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/internal/statistic/collectors/fus/ui/UiInfoUsageCollector", "getDescriptors"));
    }
}

