/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.collectors.fus.project;

import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.collectors.fus.project.IndexableFilesCollector;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventId1;
import com.intellij.internal.statistic.service.fus.collectors.ProjectUsagesCollector;
import com.intellij.internal.statistic.utils.StatisticsUtil;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.concurrency.NonUrgentExecutor;
import com.intellij.util.indexing.FileBasedIndex;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.CancellablePromise;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J&\u0010\u0005\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/intellij/internal/statistic/collectors/fus/project/IndexableFilesCollector;", "Lcom/intellij/internal/statistic/service/fus/collectors/ProjectUsagesCollector;", "()V", "getGroup", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "getMetrics", "Lorg/jetbrains/concurrency/CancellablePromise;", "", "Lcom/intellij/internal/statistic/beans/MetricEvent;", "project", "Lcom/intellij/openapi/project/Project;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "Companion", "intellij.platform.ide.impl"})
public final class IndexableFilesCollector
extends ProjectUsagesCollector {
    private static final EventLogGroup GROUP;
    private static final EventId1<Integer> ALL_INDEXABLE_FILES;
    private static final EventId1<Integer> CONTENT_INDEXABLE_FILES;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public EventLogGroup getGroup() {
        return GROUP;
    }

    @NotNull
    public CancellablePromise<? extends Set<MetricEvent>> getMetrics(@NotNull Project project, @NotNull ProgressIndicator indicator2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)indicator2, (String)"indicator");
        CancellablePromise cancellablePromise = ReadAction.nonBlocking((Callable)new Callable(project, indicator2){
            final /* synthetic */ Project $project;
            final /* synthetic */ ProgressIndicator $indicator;

            /*
             * WARNING - void declaration
             */
            public final Set<MetricEvent> call() {
                void allIndexableFiles;
                void inContentIndexableFiles;
                Ref.IntRef intRef = new Ref.IntRef();
                intRef.element = 0;
                Ref.IntRef intRef2 = new Ref.IntRef();
                intRef2.element = 0;
                ProjectRootManager projectRootManager = ProjectRootManager.getInstance((Project)this.$project);
                Intrinsics.checkNotNullExpressionValue((Object)projectRootManager, (String)"ProjectRootManager.getInstance(project)");
                ProjectFileIndex projectFileIndex = projectRootManager.getFileIndex();
                Intrinsics.checkNotNullExpressionValue((Object)projectFileIndex, (String)"ProjectRootManager.getInstance(project).fileIndex");
                ProjectFileIndex fileIndex = projectFileIndex;
                FileBasedIndex.getInstance().iterateIndexableFiles(new ContentIterator(this, fileIndex, (Ref.IntRef)inContentIndexableFiles, (Ref.IntRef)allIndexableFiles){
                    final /* synthetic */ getMetrics.1 this$0;
                    final /* synthetic */ ProjectFileIndex $fileIndex;
                    final /* synthetic */ Ref.IntRef $inContentIndexableFiles;
                    final /* synthetic */ Ref.IntRef $allIndexableFiles;

                    public final boolean processFile(@NotNull VirtualFile fileOrDir) {
                        Intrinsics.checkNotNullParameter((Object)fileOrDir, (String)"fileOrDir");
                        this.this$0.$indicator.checkCanceled();
                        if (!fileOrDir.isDirectory() && !this.$fileIndex.isExcluded(fileOrDir)) {
                            int n;
                            if (this.$fileIndex.isInContent(fileOrDir)) {
                                n = this.$inContentIndexableFiles.element;
                                this.$inContentIndexableFiles.element = n + 1;
                            }
                            n = this.$allIndexableFiles.element;
                            this.$allIndexableFiles.element = n + 1;
                        }
                        return true;
                    }
                    {
                        this.this$0 = var1_1;
                        this.$fileIndex = projectFileIndex;
                        this.$inContentIndexableFiles = intRef;
                        this.$allIndexableFiles = intRef2;
                    }
                }, this.$project, this.$indicator);
                return SetsKt.hashSetOf((Object[])new MetricEvent[]{IndexableFilesCollector.access$getALL_INDEXABLE_FILES$cp().metric((Object)StatisticsUtil.roundToPowerOfTwo((int)allIndexableFiles.element)), IndexableFilesCollector.access$getCONTENT_INDEXABLE_FILES$cp().metric((Object)StatisticsUtil.roundToPowerOfTwo((int)inContentIndexableFiles.element))});
            }
            {
                this.$project = project;
                this.$indicator = progressIndicator;
            }
        }).inSmartMode(project).wrapProgress(indicator2).submit((Executor)NonUrgentExecutor.getInstance());
        Intrinsics.checkNotNullExpressionValue((Object)cancellablePromise, (String)"ReadAction.nonBlocking(\n\u2026ntExecutor.getInstance())");
        return cancellablePromise;
    }

    static {
        Companion = new Companion(null);
        GROUP = new EventLogGroup("project.indexable.files", 3);
        ALL_INDEXABLE_FILES = GROUP.registerEvent("all.indexable.files", (EventField)EventFields.Int((String)"count"));
        CONTENT_INDEXABLE_FILES = GROUP.registerEvent("content.indexable.files", (EventField)EventFields.Int((String)"count"));
    }

    public static final /* synthetic */ EventId1 access$getALL_INDEXABLE_FILES$cp() {
        return ALL_INDEXABLE_FILES;
    }

    public static final /* synthetic */ EventId1 access$getCONTENT_INDEXABLE_FILES$cp() {
        return CONTENT_INDEXABLE_FILES;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/intellij/internal/statistic/collectors/fus/project/IndexableFilesCollector$Companion;", "", "()V", "ALL_INDEXABLE_FILES", "Lcom/intellij/internal/statistic/eventLog/events/EventId1;", "", "CONTENT_INDEXABLE_FILES", "GROUP", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "intellij.platform.ide.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

