/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.collectors.fus.fileTypes;

import com.intellij.codeInsight.actions.ReaderModeSettings;
import com.intellij.internal.statistic.collectors.fus.fileTypes.FileTypeUsageSchemaDescriptor;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.ClassEventField;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.internal.statistic.eventLog.events.VarargEventId;
import com.intellij.internal.statistic.eventLog.validator.ValidationResultType;
import com.intellij.internal.statistic.eventLog.validator.rules.EventContext;
import com.intellij.internal.statistic.eventLog.validator.rules.impl.CustomValidationRule;
import com.intellij.internal.statistic.service.fus.collectors.CounterUsagesCollector;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.ex.AnActionListener;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorAction;
import com.intellij.openapi.editor.actionSystem.EditorWriteActionHandler;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.serviceContainer.BaseKeyedLazyInstance;
import com.intellij.util.ArrayUtil;
import com.intellij.util.KeyedLazyInstance;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.annotations.Attribute;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileTypeUsageCounterCollector
extends CounterUsagesCollector {
    private static final Logger LOG = Logger.getInstance(FileTypeUsageCounterCollector.class);
    private static final ExtensionPointName<FileTypeUsageSchemaDescriptorEP<FileTypeUsageSchemaDescriptor>> EP = ExtensionPointName.create((String)"com.intellij.fileTypeUsageSchemaDescriptor");
    private static final EventLogGroup GROUP = new EventLogGroup("file.types.usage", 63);
    private static final ClassEventField FILE_EDITOR = EventFields.Class((String)"file_editor");
    private static final EventField<String> SCHEMA = EventFields.StringValidatedByCustomRule((String)"schema", (String)"file_type_schema");
    private static final EventField<Boolean> IS_WRITABLE = EventFields.Boolean((String)"is_writable");
    private static final EventField<Boolean> IS_IN_READER_MODE = EventFields.Boolean((String)"is_in_reader_mode");
    private static final VarargEventId SELECT = FileTypeUsageCounterCollector.registerFileTypeEvent("select", new EventField[0]);
    private static final VarargEventId EDIT = FileTypeUsageCounterCollector.registerFileTypeEvent("edit", new EventField[0]);
    private static final VarargEventId OPEN = FileTypeUsageCounterCollector.registerFileTypeEvent("open", new EventField[]{FILE_EDITOR, EventFields.TimeToShowMs, EventFields.DurationMs, IS_WRITABLE, IS_IN_READER_MODE});
    private static final VarargEventId CLOSE = FileTypeUsageCounterCollector.registerFileTypeEvent("close", IS_WRITABLE, IS_IN_READER_MODE);

    public EventLogGroup getGroup() {
        return GROUP;
    }

    private static VarargEventId registerFileTypeEvent(String eventId, EventField<?> ... extraFields) {
        Object[] baseFields = new EventField[]{EventFields.PluginInfoFromInstance, EventFields.FileType, EventFields.AnonymizedPath, SCHEMA};
        return GROUP.registerVarargEvent(eventId, (EventField[])ArrayUtil.mergeArrays((Object[])baseFields, (Object[])extraFields));
    }

    public static void triggerEdit(@NotNull Project project, @NotNull VirtualFile file2) {
        if (project == null) {
            FileTypeUsageCounterCollector.$$$reportNull$$$0(0);
        }
        if (file2 == null) {
            FileTypeUsageCounterCollector.$$$reportNull$$$0(1);
        }
        FileTypeUsageCounterCollector.log(EDIT, project, file2, false);
    }

    public static void triggerSelect(@NotNull Project project, @Nullable VirtualFile file2) {
        if (project == null) {
            FileTypeUsageCounterCollector.$$$reportNull$$$0(2);
        }
        if (file2 != null) {
            FileTypeUsageCounterCollector.log(SELECT, project, file2, false);
        } else {
            FileTypeUsageCounterCollector.logEmptyFile();
        }
    }

    public static void triggerOpen(@NotNull Project project, @NotNull FileEditorManager source, @NotNull VirtualFile file2, @Nullable Long openStartedNs) {
        Editor editor;
        if (project == null) {
            FileTypeUsageCounterCollector.$$$reportNull$$$0(3);
        }
        if (source == null) {
            FileTypeUsageCounterCollector.$$$reportNull$$$0(4);
        }
        if (file2 == null) {
            FileTypeUsageCounterCollector.$$$reportNull$$$0(5);
        }
        long timeToShow = openStartedNs != null ? TimeoutUtil.getDurationMillis((long)openStartedNs) : -1L;
        FileEditor fileEditor = FileEditorManager.getInstance((Project)project).getSelectedEditor(file2);
        Editor editor2 = editor = fileEditor instanceof TextEditor ? ((TextEditor)fileEditor).getEditor() : null;
        if (editor == null) {
            FileTypeUsageCounterCollector.logOpened(project, file2, fileEditor, timeToShow, -1L);
        } else {
            source.runWhenLoaded(editor, () -> {
                long durationMs = openStartedNs != null ? TimeoutUtil.getDurationMillis((long)openStartedNs) : -1L;
                FileTypeUsageCounterCollector.logOpened(project, file2, fileEditor, timeToShow, durationMs);
            });
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void logOpened(@NotNull Project project, @NotNull VirtualFile file2, @Nullable FileEditor fileEditor, long timeToShow, long l) {
        void durationMs;
        if (project == null) {
            FileTypeUsageCounterCollector.$$$reportNull$$$0(6);
        }
        if (file2 == null) {
            FileTypeUsageCounterCollector.$$$reportNull$$$0(7);
        }
        List<@NotNull EventPair<?>> data2 = FileTypeUsageCounterCollector.buildCommonEventPairs(project, file2, true);
        if (fileEditor != null) {
            data2.add(FILE_EDITOR.with(fileEditor.getClass()));
        }
        data2.add(EventFields.TimeToShowMs.with((Object)timeToShow));
        if (durationMs != -1L) {
            data2.add(EventFields.DurationMs.with((Object)((long)durationMs)));
        }
        OPEN.log(data2);
    }

    public static void triggerClosed(@NotNull Project project, @NotNull VirtualFile file2) {
        if (project == null) {
            FileTypeUsageCounterCollector.$$$reportNull$$$0(8);
        }
        if (file2 == null) {
            FileTypeUsageCounterCollector.$$$reportNull$$$0(9);
        }
        FileTypeUsageCounterCollector.log(CLOSE, project, file2, true);
    }

    private static void log(@NotNull VarargEventId eventId, @NotNull Project project, @NotNull VirtualFile file2, boolean withWritable) {
        if (eventId == null) {
            FileTypeUsageCounterCollector.$$$reportNull$$$0(10);
        }
        if (project == null) {
            FileTypeUsageCounterCollector.$$$reportNull$$$0(11);
        }
        if (file2 == null) {
            FileTypeUsageCounterCollector.$$$reportNull$$$0(12);
        }
        eventId.log(project, FileTypeUsageCounterCollector.buildCommonEventPairs(project, file2, withWritable));
    }

    private static List<@NotNull EventPair<?>> buildCommonEventPairs(@NotNull Project project, @NotNull VirtualFile file2, boolean withWritable) {
        if (project == null) {
            FileTypeUsageCounterCollector.$$$reportNull$$$0(13);
        }
        if (file2 == null) {
            FileTypeUsageCounterCollector.$$$reportNull$$$0(14);
        }
        FileType fileType = file2.getFileType();
        ArrayList data2 = ContainerUtil.newArrayList((Object[])new EventPair[]{EventFields.PluginInfoFromInstance.with((Object)fileType), EventFields.FileType.with((Object)fileType), EventFields.AnonymizedPath.with((Object)file2.getPath()), SCHEMA.with((Object)FileTypeUsageCounterCollector.findSchema(project, file2))});
        if (withWritable) {
            data2.add(IS_WRITABLE.with((Object)file2.isWritable()));
            data2.add(IS_IN_READER_MODE.with((Object)ReaderModeSettings.matchModeForStats((Project)project, (VirtualFile)file2)));
        }
        return data2;
    }

    private static void logEmptyFile() {
        SELECT.log(new EventPair[]{EventFields.AnonymizedPath.with(null)});
    }

    @Nullable
    public static String findSchema(@NotNull Project project, @NotNull VirtualFile file2) {
        if (project == null) {
            FileTypeUsageCounterCollector.$$$reportNull$$$0(15);
        }
        if (file2 == null) {
            FileTypeUsageCounterCollector.$$$reportNull$$$0(16);
        }
        for (FileTypeUsageSchemaDescriptorEP ext : EP.getExtensionList()) {
            FileTypeUsageSchemaDescriptor instance = (FileTypeUsageSchemaDescriptor)ext.getInstance();
            if (ext.schema == null) {
                LOG.warn("Extension " + ext.implementationClass + " should define a 'schema' attribute");
                continue;
            }
            if (!instance.describes(project, file2)) continue;
            return PluginInfoDetectorKt.getPluginInfo(instance.getClass()).isSafeToReport() ? ext.schema : "third.party";
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: 
            case 7: 
            case 9: 
            case 12: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "eventId";
                break;
            }
        }
        objectArray2[1] = "com/intellij/internal/statistic/collectors/fus/fileTypes/FileTypeUsageCounterCollector";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "triggerEdit";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "triggerSelect";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "triggerOpen";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "logOpened";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "triggerClosed";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "log";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "buildCommonEventPairs";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "findSchema";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class MyAnActionListener
    implements AnActionListener {
        private static final Key<Long> LAST_EDIT_USAGE = Key.create((String)"LAST_EDIT_USAGE");

        public void beforeActionPerformed(@NotNull AnAction action2, @NotNull AnActionEvent event) {
            if (action2 == null) {
                MyAnActionListener.$$$reportNull$$$0(0);
            }
            if (event == null) {
                MyAnActionListener.$$$reportNull$$$0(1);
            }
            if (action2 instanceof EditorAction && ((EditorAction)action2).getHandlerOfType(EditorWriteActionHandler.class) != null) {
                MyAnActionListener.onChange(event.getDataContext());
            }
        }

        private static void onChange(DataContext dataContext) {
            Long lastEdit;
            Editor editor = (Editor)CommonDataKeys.HOST_EDITOR.getData(dataContext);
            if (editor == null) {
                return;
            }
            Project project = editor.getProject();
            if (project == null) {
                return;
            }
            VirtualFile file2 = FileDocumentManager.getInstance().getFile(editor.getDocument());
            if (file2 != null && ((lastEdit = (Long)editor.getUserData(LAST_EDIT_USAGE)) == null || System.currentTimeMillis() - lastEdit > 60000L)) {
                editor.putUserData(LAST_EDIT_USAGE, (Object)System.currentTimeMillis());
                FileTypeUsageCounterCollector.triggerEdit(project, file2);
            }
        }

        public void beforeEditorTyping(char c, @NotNull DataContext dataContext) {
            if (dataContext == null) {
                MyAnActionListener.$$$reportNull$$$0(2);
            }
            MyAnActionListener.onChange(dataContext);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "action";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataContext";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/internal/statistic/collectors/fus/fileTypes/FileTypeUsageCounterCollector$MyAnActionListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "beforeActionPerformed";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "beforeEditorTyping";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static final class FileTypeSchemaValidator
    extends CustomValidationRule {
        public boolean acceptRuleId(@Nullable String ruleId) {
            return "file_type_schema".equals(ruleId);
        }

        @NotNull
        protected ValidationResultType doValidate(@NotNull String data2, @NotNull EventContext context2) {
            if (data2 == null) {
                FileTypeSchemaValidator.$$$reportNull$$$0(0);
            }
            if (context2 == null) {
                FileTypeSchemaValidator.$$$reportNull$$$0(1);
            }
            if (FileTypeSchemaValidator.isThirdPartyValue((String)data2)) {
                ValidationResultType validationResultType = ValidationResultType.ACCEPTED;
                if (validationResultType == null) {
                    FileTypeSchemaValidator.$$$reportNull$$$0(2);
                }
                return validationResultType;
            }
            for (FileTypeUsageSchemaDescriptorEP ext : EP.getExtensionList()) {
                if (!StringUtil.equals((CharSequence)ext.schema, (CharSequence)data2)) continue;
                ValidationResultType validationResultType = PluginInfoDetectorKt.getPluginInfo(((FileTypeUsageSchemaDescriptor)ext.getInstance()).getClass()).isSafeToReport() ? ValidationResultType.ACCEPTED : ValidationResultType.THIRD_PARTY;
                if (validationResultType == null) {
                    FileTypeSchemaValidator.$$$reportNull$$$0(3);
                }
                return validationResultType;
            }
            ValidationResultType validationResultType = ValidationResultType.REJECTED;
            if (validationResultType == null) {
                FileTypeSchemaValidator.$$$reportNull$$$0(4);
            }
            return validationResultType;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "data";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/internal/statistic/collectors/fus/fileTypes/FileTypeUsageCounterCollector$FileTypeSchemaValidator";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/internal/statistic/collectors/fus/fileTypes/FileTypeUsageCounterCollector$FileTypeSchemaValidator";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "doValidate";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "doValidate";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static final class FileTypeUsageSchemaDescriptorEP<T>
    extends BaseKeyedLazyInstance<T>
    implements KeyedLazyInstance<T> {
        @Attribute(value="schema")
        public String schema;
        @Attribute(value="implementationClass")
        public String implementationClass;

        @Nullable
        protected String getImplementationClassName() {
            return this.implementationClass;
        }

        public String getKey() {
            return this.schema;
        }
    }
}

