/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.psiView.stubtree;

import com.intellij.internal.psiView.PsiViewerDialog;
import com.intellij.internal.psiView.ViewerPsiBasedTree;
import com.intellij.internal.psiView.stubtree.StubTreeNode;
import com.intellij.internal.psiView.stubtree.StubTreeStructure;
import com.intellij.lang.ASTNode;
import com.intellij.lang.FileASTNode;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.StubBuilder;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.PsiFileWithStubSupport;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.PsiFileStub;
import com.intellij.psi.stubs.Stub;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubTree;
import com.intellij.psi.stubs.StubTreeBuilder;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IStubFileElementType;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.tree.AsyncTreeModel;
import com.intellij.ui.tree.StructureTreeModel;
import com.intellij.ui.tree.TreePathUtil;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.containers.BidirectionalMap;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.FileContentImpl;
import com.intellij.util.indexing.IndexingDataKeys;
import com.intellij.util.ui.StatusText;
import com.intellij.util.ui.tree.AbstractTreeModel;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StubViewerPsiBasedTree
implements ViewerPsiBasedTree {
    public static final Logger LOG = Logger.getInstance(PsiViewerDialog.class);
    @Nullable
    private AbstractTreeModel myTreeModel;
    @NotNull
    private final Tree myStubTree;
    @Nullable
    private JPanel myPanel;
    @NotNull
    private final Project myProject;
    @NotNull
    private final ViewerPsiBasedTree.PsiTreeUpdater myUpdater;
    @NotNull
    private volatile Map<ASTNode, StubElement<?>> myNodeToStubs;
    private Disposable myTreeModelDisposable;

    public StubViewerPsiBasedTree(@NotNull Project project, @NotNull ViewerPsiBasedTree.PsiTreeUpdater updater) {
        if (project == null) {
            StubViewerPsiBasedTree.$$$reportNull$$$0(0);
        }
        if (updater == null) {
            StubViewerPsiBasedTree.$$$reportNull$$$0(1);
        }
        this.myNodeToStubs = new BidirectionalMap();
        this.myTreeModelDisposable = Disposer.newDisposable();
        this.myProject = project;
        this.myUpdater = updater;
        this.myStubTree = new Tree((TreeModel)new DefaultTreeModel(new DefaultMutableTreeNode()));
    }

    @Override
    public void reloadTree(@Nullable PsiElement rootRootElement, @NotNull String text2) {
        if (text2 == null) {
            StubViewerPsiBasedTree.$$$reportNull$$$0(2);
        }
        this.resetStubTree();
        this.buildStubTree(rootRootElement, text2);
    }

    private void resetStubTree() {
        this.myStubTree.removeAll();
        if (this.myTreeModel != null) {
            Disposer.dispose((Disposable)this.myTreeModelDisposable);
            this.myTreeModel = null;
            this.myTreeModelDisposable = Disposer.newDisposable();
        }
        this.myNodeToStubs = new BidirectionalMap();
        ViewerPsiBasedTree.removeListenerOfClass(this.myStubTree, StubTreeSelectionListener.class);
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        if (this.myPanel != null) {
            JPanel jPanel2 = this.myPanel;
            if (jPanel2 == null) {
                StubViewerPsiBasedTree.$$$reportNull$$$0(3);
            }
            return jPanel2;
        }
        JPanel panel2 = new JPanel(new BorderLayout());
        panel2.add(ScrollPaneFactory.createScrollPane((Component)this.myStubTree));
        panel2.setBorder(IdeBorderFactory.createBorder());
        PsiViewerDialog.initTree((JTree)this.myStubTree);
        this.myPanel = panel2;
        JPanel jPanel3 = panel2;
        if (jPanel3 == null) {
            StubViewerPsiBasedTree.$$$reportNull$$$0(4);
        }
        return jPanel3;
    }

    @Override
    public boolean isFocusOwner() {
        return this.myStubTree.isFocusOwner();
    }

    @Override
    public void focusTree() {
        IdeFocusManager.getInstance((Project)this.myProject).requestFocus((Component)this.myStubTree, true);
    }

    private synchronized void buildStubTree(@Nullable PsiElement rootElement, @NotNull String textToParse) {
        if (textToParse == null) {
            StubViewerPsiBasedTree.$$$reportNull$$$0(5);
        }
        if (rootElement == null) {
            this.myStubTree.setRootVisible(false);
            return;
        }
        if (!(rootElement instanceof PsiFileWithStubSupport)) {
            this.myStubTree.setRootVisible(false);
            StatusText text2 = this.myStubTree.getEmptyText();
            if (rootElement instanceof PsiFile) {
                text2.setText("No stubs for " + rootElement.getLanguage().getDisplayName());
            } else {
                text2.setText("Cannot build stub tree for code fragments");
            }
            return;
        }
        Stub stub = StubViewerPsiBasedTree.buildStubForElement(this.myProject, rootElement, textToParse);
        if (stub instanceof PsiFileStub) {
            PsiFileWithStubSupport file2 = (PsiFileWithStubSupport)rootElement;
            StubTreeNode rootNode = new StubTreeNode((StubElement)stub, null);
            StructureTreeModel<StubTreeStructure> treeModel = new StructureTreeModel<StubTreeStructure>(new StubTreeStructure(rootNode), this.myTreeModelDisposable);
            this.myTreeModel = new AsyncTreeModel((TreeModel)((Object)treeModel), this.myTreeModelDisposable);
            this.myStubTree.setModel((TreeModel)this.myTreeModel);
            this.fillPsiToStubCache(file2, (PsiFileStub)stub);
            this.myStubTree.setRootVisible(true);
            this.myStubTree.expandRow(0);
            this.myStubTree.addTreeSelectionListener((TreeSelectionListener)new StubTreeSelectionListener());
            treeModel.invalidate();
        } else {
            this.myStubTree.setRootVisible(false);
            StatusText text3 = this.myStubTree.getEmptyText();
            text3.setText("Cannot build stubs for " + rootElement.getLanguage().getDisplayName());
        }
    }

    public void dispose() {
        this.resetStubTree();
    }

    @Nullable
    private static Stub buildStubForElement(Project project, PsiElement rootElement, @NotNull String textToParse) {
        if (textToParse == null) {
            StubViewerPsiBasedTree.$$$reportNull$$$0(6);
        }
        PsiFileStub stub = null;
        PsiFileWithStubSupport psiFile = (PsiFileWithStubSupport)rootElement;
        StubTree tree = psiFile.getStubTree();
        if (tree != null) {
            stub = tree.getRoot();
        } else if (rootElement instanceof PsiFileImpl) {
            StubBuilder stubBuilder = StubViewerPsiBasedTree.getStubBuilder((PsiFileImpl)rootElement);
            StubElement stubElement = stub = stubBuilder == null ? null : stubBuilder.buildStubTree((PsiFile)rootElement);
        }
        if (stub == null) {
            LightVirtualFile file2 = new LightVirtualFile("stub", rootElement.getLanguage(), (CharSequence)textToParse);
            try {
                FileContent fc = FileContentImpl.createByFile((VirtualFile)file2, project);
                fc.putUserData(IndexingDataKeys.PSI_FILE, (Object)psiFile);
                stub = StubTreeBuilder.buildStubTree(fc);
            }
            catch (IOException e) {
                LOG.warn(e.getMessage(), (Throwable)e);
            }
        }
        return stub;
    }

    @Nullable
    private static StubBuilder getStubBuilder(@NotNull PsiFileImpl rootElement) {
        IStubFileElementType<?> builder2;
        if (rootElement == null) {
            StubViewerPsiBasedTree.$$$reportNull$$$0(7);
        }
        return (builder2 = rootElement.getElementTypeForStubBuilder()) == null ? null : builder2.getBuilder();
    }

    @Override
    public void selectNodeFromPsi(@Nullable PsiElement element2) {
        if (this.myTreeModel == null || element2 == null) {
            return;
        }
        PsiFile file2 = element2.getContainingFile();
        if (!(file2 instanceof PsiFileWithStubSupport)) {
            return;
        }
        DefaultMutableTreeNode rootNode = this.getRoot();
        if (rootNode == null) {
            return;
        }
        StubElement<?> stubElement = this.myNodeToStubs.get(element2.getNode());
        if (stubElement != null) {
            this.selectStubElement(stubElement);
        } else {
            this.myStubTree.clearSelection();
        }
    }

    private void selectStubElement(StubElement<?> stubElement) {
        TreeNode node = (TreeNode)TreeUtil.treeNodeTraverser((TreeNode)this.getRoot()).traverse().find(treeNode -> treeNode instanceof DefaultMutableTreeNode && ((StubTreeNode)((Object)((Object)((DefaultMutableTreeNode)treeNode).getUserObject()))).getStub() == stubElement);
        if (node != null) {
            TreePath path2 = TreePathUtil.pathToTreeNode(node);
            this.myStubTree.getSelectionModel().setSelectionPath(path2);
        }
    }

    private DefaultMutableTreeNode getRoot() {
        return (DefaultMutableTreeNode)this.myStubTree.getModel().getRoot();
    }

    public PsiElement getPsiElementForStub(StubElement<?> stub) {
        Ref result2 = Ref.create();
        this.myNodeToStubs.forEach((key, value2) -> {
            if (value2 == stub) {
                result2.set((Object)key.getPsi());
            }
        });
        return (PsiElement)result2.get();
    }

    private void fillPsiToStubCache(@NotNull PsiFileWithStubSupport rootElement, @NotNull PsiFileStub<?> rootStub) {
        if (rootElement == null) {
            StubViewerPsiBasedTree.$$$reportNull$$$0(8);
        }
        if (rootStub == null) {
            StubViewerPsiBasedTree.$$$reportNull$$$0(9);
        }
        this.fillTreeForStub(rootElement, new StubTree(rootStub));
    }

    public void fillTreeForStub(@NotNull PsiFileWithStubSupport file2, @NotNull StubTree tree) {
        StubBuilder builder2;
        if (file2 == null) {
            StubViewerPsiBasedTree.$$$reportNull$$$0(10);
        }
        if (tree == null) {
            StubViewerPsiBasedTree.$$$reportNull$$$0(11);
        }
        StubBuilder stubBuilder = builder2 = file2 instanceof PsiFileImpl ? StubViewerPsiBasedTree.getStubBuilder((PsiFileImpl)file2) : null;
        if (builder2 == null) {
            return;
        }
        Iterator<StubElement<?>> stubs = tree.getPlainList().iterator();
        StubElement root = (StubElement)stubs.next();
        FileASTNode ast = file2.getNode();
        this.myNodeToStubs.put((ASTNode)ast, root);
        this.findTreeForStub(builder2, (ASTNode)ast, stubs);
        if (stubs.hasNext()) {
            LOG.error("Stub mismatch, unprocessed stubs " + stubs.next());
        }
    }

    private void findTreeForStub(StubBuilder builder2, ASTNode tree, Iterator<StubElement<?>> stubs) {
        IElementType type = tree.getElementType();
        if (type instanceof IStubElementType && ((IStubElementType)type).shouldCreateStub(tree)) {
            if (!stubs.hasNext()) {
                LOG.error("Stub mismatch, " + type);
            }
            StubElement<?> curStub = stubs.next();
            this.myNodeToStubs.put(tree, curStub);
        }
        for (ASTNode node : tree.getChildren(null)) {
            if (builder2.skipChildProcessingWhenBuildingStubs(tree, node)) continue;
            this.findTreeForStub(builder2, node, stubs);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updater";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/psiView/stubtree/StubViewerPsiBasedTree";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textToParse";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootElement";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootStub";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/psiView/stubtree/StubViewerPsiBasedTree";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "reloadTree";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "buildStubTree";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "buildStubForElement";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getStubBuilder";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "fillPsiToStubCache";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "fillTreeForStub";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class StubTreeSelectionListener
    implements TreeSelectionListener {
        StubTreeSelectionListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            StubElement<?> topLevelStub;
            if (StubViewerPsiBasedTree.this.myTreeModel == null) {
                return;
            }
            StubTreeNode rootNode = (StubTreeNode)((Object)StubViewerPsiBasedTree.this.getRoot().getUserObject());
            StubElement<?> stubElement = topLevelStub = rootNode == null ? null : rootNode.getStub();
            if (!(topLevelStub instanceof PsiFileStub)) {
                return;
            }
            TreePath selectionPath = StubViewerPsiBasedTree.this.myStubTree.getSelectionPath();
            if (selectionPath == null) {
                return;
            }
            StubElement<?> stub = ((StubTreeNode)((Object)((DefaultMutableTreeNode)selectionPath.getLastPathComponent()).getUserObject())).getStub();
            PsiElement result2 = StubViewerPsiBasedTree.this.getPsiElementForStub(stub);
            if (result2 != null) {
                StubViewerPsiBasedTree.this.myUpdater.updatePsiTree(result2, StubViewerPsiBasedTree.this.myStubTree.hasFocus() ? result2.getTextRange() : null);
            }
        }
    }
}

