/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.inspector;

import com.google.common.base.MoreObjects;
import com.intellij.codeInsight.daemon.GutterMark;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.IntentionActionDelegate;
import com.intellij.codeInspection.QuickFix;
import com.intellij.codeInspection.ex.QuickFixWrapper;
import com.intellij.icons.AllIcons;
import com.intellij.ide.CopyProvider;
import com.intellij.ide.DataManager;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.impl.DataManagerImpl;
import com.intellij.ide.lightEdit.LightEditCompatible;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.ide.ui.AntialiasingType;
import com.intellij.ide.ui.UISettings;
import com.intellij.idea.ActionsBundle;
import com.intellij.internal.InternalActionsBundle;
import com.intellij.internal.inspector.PropertyBean;
import com.intellij.internal.inspector.UiInspectorContextProvider;
import com.intellij.internal.inspector.UiInspectorUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPromoter;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.MouseShortcut;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.ex.CustomComponentAction;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.actionSystem.impl.ActionMenu;
import com.intellij.openapi.actionSystem.impl.ActionMenuItem;
import com.intellij.openapi.actionSystem.impl.ActionToolbarImpl;
import com.intellij.openapi.editor.ex.EditorGutterComponentEx;
import com.intellij.openapi.editor.impl.EditorComponentImpl;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManagerListener;
import com.intellij.openapi.keymap.ex.KeymapManagerEx;
import com.intellij.openapi.keymap.impl.KeymapManagerImpl;
import com.intellij.openapi.keymap.impl.ui.MouseShortcutPanel;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.actions.IconWithTextAction;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.openapi.ui.StripeTable;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.DimensionService;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.ScalableIcon;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.ToolWindowEP;
import com.intellij.openapi.wm.ToolWindowFactory;
import com.intellij.openapi.wm.impl.StripeButton;
import com.intellij.openapi.wm.impl.ToolWindowImpl;
import com.intellij.openapi.wm.impl.status.TextPanel;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.ColorPicker;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.JBColor;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.RetrievableIcon;
import com.intellij.ui.RowIcon;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TableSpeedSearch;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.border.CustomLineBorder;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.ui.paint.LinePainter2D;
import com.intellij.ui.paint.RectanglePainter;
import com.intellij.ui.picker.ColorListener;
import com.intellij.ui.popup.PopupFactoryImpl;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.speedSearch.SpeedSearchUtil;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.Function;
import com.intellij.util.IconUtil;
import com.intellij.util.LazyInitializer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PsiNavigateUtil;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.ColorIcon;
import com.intellij.util.ui.ColorsIcon;
import com.intellij.util.ui.JBFont;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBScalableIcon;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.PlatformColors;
import com.intellij.util.ui.TextTransferable;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.AWTEvent;
import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Transferable;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ContainerEvent;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.font.TextAttribute;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InaccessibleObjectException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Vector;
import java.util.function.Supplier;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.CellRendererPane;
import javax.swing.DefaultCellEditor;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JRootPane;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import net.miginfocom.layout.AC;
import net.miginfocom.layout.BoundSize;
import net.miginfocom.layout.CC;
import net.miginfocom.layout.DimConstraint;
import net.miginfocom.layout.LC;
import net.miginfocom.layout.UnitValue;
import net.miginfocom.swing.MigLayout;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UiInspectorAction
extends DumbAwareAction
implements LightEditCompatible,
ActionPromoter {
    private static final String ACTION_ID = "UiInspector";
    private static final String RENDERER_BOUNDS = "clicked renderer";
    private static final int MAX_DEEPNESS_TO_DISCOVER_FIELD_NAME = 8;
    private static final Key<List<PropertyBean>> CLICK_INFO = Key.create((String)"CLICK_INFO");
    private static final Key<Point> CLICK_INFO_POINT = Key.create((String)"CLICK_INFO_POINT");
    private static final Key<Throwable> ADDED_AT_STACKTRACE = Key.create((String)"uiInspector.addedAt");
    private final List<MouseShortcut> myMouseShortcuts = new ArrayList<MouseShortcut>();
    private static boolean ourGlobalInstanceInitialized = false;
    private static final LazyInitializer.LazyValue<Map<Integer, String>> MIG_LAYOUT_UNIT_MAP = new LazyInitializer.LazyValue(() -> {
        HashMap<Integer, String> result2 = new HashMap<Integer, String>();
        try {
            Field mapField = UnitValue.class.getDeclaredField("UNIT_MAP");
            mapField.setAccessible(true);
            Map map2 = (Map)mapField.get(null);
            for (Map.Entry entry2 : map2.entrySet()) {
                result2.put((Integer)entry2.getValue(), (String)entry2.getKey());
            }
        }
        catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
            // empty catch block
        }
        return result2;
    });

    public static synchronized void initGlobalInspector() {
        if (!ourGlobalInstanceInitialized) {
            ourGlobalInstanceInitialized = true;
            UIUtil.invokeLaterIfNeeded(() -> new UiInspector(null));
        }
    }

    public UiInspectorAction() {
        this.setEnabledInModalContext(true);
        this.updateMouseShortcuts();
        KeymapManagerEx.getInstanceEx().addWeakListener(new KeymapManagerListener(){

            public void activeKeymapChanged(@Nullable Keymap keymap2) {
                UiInspectorAction.this.updateMouseShortcuts();
            }

            public void shortcutChanged(@NotNull Keymap keymap2, @NotNull String actionId) {
                if (keymap2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (actionId == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (UiInspectorAction.ACTION_ID.equals(actionId)) {
                    UiInspectorAction.this.updateMouseShortcuts();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "keymap";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "actionId";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/internal/inspector/UiInspectorAction$1";
                objectArray[2] = "shortcutChanged";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        Toolkit.getDefaultToolkit().addAWTEventListener(new AWTEventListener(){

            @Override
            public void eventDispatched(AWTEvent event) {
                MouseEvent me;
                MouseShortcut mouseShortcut;
                if (event instanceof MouseEvent && ((MouseEvent)event).getClickCount() > 0 && !UiInspectorAction.this.myMouseShortcuts.isEmpty() && UiInspectorAction.this.myMouseShortcuts.contains(mouseShortcut = new MouseShortcut((me = (MouseEvent)event).getButton(), me.getModifiersEx(), me.getClickCount())) && !(me.getComponent() instanceof MouseShortcutPanel)) {
                    me.consume();
                }
            }
        }, 16L);
    }

    private void updateMouseShortcuts() {
        if (KeymapManagerImpl.isKeymapManagerInitialized()) {
            this.myMouseShortcuts.clear();
            Keymap keymap2 = KeymapManagerEx.getInstanceEx().getActiveKeymap();
            for (Shortcut shortcut : keymap2.getShortcuts(ACTION_ID)) {
                if (!(shortcut instanceof MouseShortcut)) continue;
                this.myMouseShortcuts.add((MouseShortcut)shortcut);
            }
        }
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        InputEvent event;
        if (e == null) {
            UiInspectorAction.$$$reportNull$$$0(0);
        }
        if ((event = e.getInputEvent()) != null) {
            event.consume();
        }
        Component component2 = (Component)e.getData(PlatformDataKeys.CONTEXT_COMPONENT);
        Project project = e.getProject();
        UiInspectorAction.closeAllInspectorWindows();
        if (event instanceof MouseEvent && event.getComponent() != null) {
            new UiInspector(project).processMouseEvent(project, (MouseEvent)event);
            return;
        }
        if (component2 == null) {
            component2 = IdeFocusManager.getInstance((Project)project).getFocusOwner();
        }
        assert (component2 != null);
        new UiInspector(project).showInspector(project, component2);
    }

    public List<AnAction> promote(@NotNull List<? extends AnAction> actions2, @NotNull DataContext context2) {
        if (actions2 == null) {
            UiInspectorAction.$$$reportNull$$$0(1);
        }
        if (context2 == null) {
            UiInspectorAction.$$$reportNull$$$0(2);
        }
        ArrayList<AnAction> sorted = new ArrayList<AnAction>(actions2);
        if (context2.getData(PlatformDataKeys.CONTEXT_COMPONENT) instanceof EditorComponentImpl) {
            sorted.remove((Object)this);
            sorted.add((AnAction)this);
        }
        return sorted;
    }

    private static void closeAllInspectorWindows() {
        Arrays.stream(Window.getWindows()).filter(w -> w instanceof InspectorWindow).forEach(w -> Disposer.dispose((Disposable)((InspectorWindow)w).myInspector));
    }

    @NotNull
    private static String getComponentName(Component component2) {
        Object name = UiInspectorAction.getClassName(component2);
        String componentName = component2.getName();
        if (StringUtil.isNotEmpty((String)componentName)) {
            name = (String)name + " \"" + componentName + "\"";
        }
        String string = name;
        if (string == null) {
            UiInspectorAction.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Nullable
    private static Pair<Class<?>, String> getClassAndFieldName(Component component2) {
        Container parent = component2.getParent();
        for (int deepness = 1; parent != null && deepness <= 8; parent = parent.getParent(), ++deepness) {
            HashMap fields2 = new HashMap();
            for (Class<?> aClass = parent.getClass(); aClass != null; aClass = aClass.getSuperclass()) {
                for (Field field : aClass.getDeclaredFields()) {
                    fields2.put(field, aClass);
                }
            }
            for (Map.Entry entry2 : fields2.entrySet()) {
                try {
                    Field field = (Field)entry2.getKey();
                    field.setAccessible(true);
                    if (field.get(parent) != component2) continue;
                    return Pair.create((Object)((Class)entry2.getValue()), (Object)field.getName());
                }
                catch (IllegalAccessException | InaccessibleObjectException exception) {
                }
            }
        }
        return null;
    }

    private static TreeModel buildModel(Component c) {
        return UiInspectorAction.buildModel(c, false);
    }

    private static TreeModel buildModel(Component c, boolean accessibleModel) {
        Accessible axComponent;
        Component parent = null;
        if (accessibleModel && c instanceof Accessible) {
            axComponent = c.getAccessibleContext().getAccessibleParent();
            if (axComponent instanceof Component) {
                parent = (Component)((Object)axComponent);
            }
        } else {
            parent = c.getParent();
        }
        while (parent != null) {
            c = parent;
            if (accessibleModel && c instanceof Accessible) {
                axComponent = c.getAccessibleContext().getAccessibleParent();
                if (axComponent instanceof Component) {
                    parent = (Component)((Object)axComponent);
                    continue;
                }
                parent = null;
                continue;
            }
            parent = c.getParent();
        }
        return new DefaultTreeModel(new HierarchyTree.ComponentNode(c, accessibleModel));
    }

    private static void drawCenteredString(Graphics2D g2d, FontMetrics fm, int fontHeight, String text2, int x, int y) {
        int width = fm.stringWidth(text2);
        UIUtil.drawCenteredString((Graphics2D)g2d, (Rectangle)new Rectangle(x - width / 2, y - fontHeight / 2, width, fontHeight), (String)text2);
    }

    @NotNull
    private static String getToStringValue(@NotNull Object value2) {
        if (value2 == null) {
            UiInspectorAction.$$$reportNull$$$0(4);
        }
        StringBuilder sb = new StringBuilder();
        if (value2.getClass().getName().equals("javax.swing.ArrayTable")) {
            Object table = ReflectionUtil.getField(value2.getClass(), (Object)value2, Object.class, (String)"table");
            if (table != null) {
                try {
                    if (table instanceof Object[]) {
                        Object[] arr = (Object[])table;
                        for (int i2 = 0; i2 < arr.length; i2 += 2) {
                            if (arr[i2].equals(ADDED_AT_STACKTRACE)) continue;
                            if (sb.length() > 0) {
                                sb.append(",");
                            }
                            sb.append('[').append(arr[i2]).append("->").append(arr[i2 + 1]).append(']');
                        }
                    } else if (table instanceof Map) {
                        Map map2 = (Map)table;
                        for (Map.Entry entry2 : map2.entrySet()) {
                            if (entry2.getKey().equals(ADDED_AT_STACKTRACE)) continue;
                            if (sb.length() > 0) {
                                sb.append(",");
                            }
                            sb.append('[').append(entry2.getKey()).append("->").append(entry2.getValue()).append(']');
                        }
                    }
                }
                catch (Exception map2) {
                    // empty catch block
                }
            }
            if (sb.length() == 0) {
                sb.append("-");
            }
            value2 = sb;
        }
        if (value2.getClass().isArray()) {
            int length = Array.getLength(value2);
            for (int index2 = 0; index2 < length; ++index2) {
                Object obj2;
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                if ((obj2 = Array.get(value2, index2)) == null) continue;
                sb.append(obj2.getClass().getName());
            }
            value2 = sb.length() == 0 ? "-" : sb;
        }
        String toString2 = StringUtil.notNullize((String)String.valueOf(value2), (String)"toString()==null");
        String string = toString2.replace('\n', ' ');
        if (string == null) {
            UiInspectorAction.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    private static String getClassName(Object value2) {
        Class<?> clazz0 = value2.getClass();
        Class<?> clazz = clazz0.isAnonymousClass() ? clazz0.getSuperclass() : clazz0;
        String string = clazz.getSimpleName();
        if (string == null) {
            UiInspectorAction.$$$reportNull$$$0(6);
        }
        return string;
    }

    private static ColorIcon createColorIcon(Color color) {
        return (ColorIcon)JBUIScale.scaleIcon((JBScalableIcon)new ColorIcon(13, 11, color, true));
    }

    private static Icon createColorIcon(Color color1, Color color2) {
        return JBUIScale.scaleIcon((JBScalableIcon)new ColorsIcon(11, new Color[]{color1, color2}));
    }

    @Nullable
    private static AnAction getAction(Component c) {
        return (AnAction)UIUtil.getClientProperty((Object)c, (Key)CustomComponentAction.ACTION_KEY);
    }

    @Nullable
    private static String getAddedAtStacktrace(@Nullable Component component2) {
        Throwable throwable = (Throwable)UIUtil.getClientProperty((Object)component2, ADDED_AT_STACKTRACE);
        if (throwable == null) {
            return null;
        }
        String text2 = ExceptionUtil.getThrowableText((Throwable)throwable);
        int first = text2.indexOf("at com.intellij", text2.indexOf("at java."));
        int last = text2.indexOf("at java.awt.EventQueue");
        if (last == -1) {
            last = text2.length();
        }
        return last > first && first > 0 ? text2.substring(first, last).trim() : null;
    }

    private static Object fromObject(Object o, Class<?> type) {
        if (o == null) {
            return null;
        }
        if (type.isAssignableFrom(o.getClass())) {
            return o;
        }
        if ("null".equals(o)) {
            return null;
        }
        String value2 = String.valueOf(o).trim();
        if (type == Integer.TYPE) {
            return Integer.parseInt(value2);
        }
        if (type == Boolean.TYPE) {
            return "yes".equalsIgnoreCase(value2) || "true".equalsIgnoreCase(value2);
        }
        if (type == Byte.TYPE) {
            return Byte.parseByte(value2);
        }
        if (type == Short.TYPE) {
            return Short.parseShort(value2);
        }
        if (type == Double.TYPE) {
            return Double.parseDouble(value2);
        }
        if (type == Float.TYPE) {
            return Float.valueOf(Float.parseFloat(value2));
        }
        String[] s = value2.split("(?i)\\s*(?:[x@:]|[a-z]+:)\\s*", 6);
        if (type == Dimension.class) {
            if (s.length == 2) {
                return new Dimension(Integer.parseInt(s[0]), Integer.parseInt(s[1]));
            }
        } else if (type == Point.class) {
            if (s.length == 2) {
                return new Point(Integer.parseInt(s[0]), Integer.parseInt(s[1]));
            }
        } else if (type == Rectangle.class) {
            if (s.length >= 5) {
                return new Rectangle(Integer.parseInt(s[3]), Integer.parseInt(s[4]), Integer.parseInt(s[1]), Integer.parseInt(s[2]));
            }
        } else if (type == Insets.class) {
            if (s.length >= 5) {
                return new Insets(Integer.parseInt(s[1]), Integer.parseInt(s[2]), Integer.parseInt(s[4]), Integer.parseInt(s[4]));
            }
        } else if (type == Color.class) {
            if (s.length >= 5) {
                return new ColorUIResource(new Color(Integer.parseInt(s[1]), Integer.parseInt(s[2]), Integer.parseInt(s[3]), Integer.parseInt(s[4])));
            }
        } else if (type.getSimpleName().contains("ArrayTable")) {
            return "ArrayTable!";
        }
        throw new UnsupportedOperationException(type.toString());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actions";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/inspector/UiInspectorAction";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/inspector/UiInspectorAction";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponentName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getToStringValue";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "promote";
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getToStringValue";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class ToggleHierarchyTraceAction
    extends ToggleAction
    implements AWTEventListener {
        private boolean myEnabled = false;

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                ToggleHierarchyTraceAction.$$$reportNull$$$0(0);
            }
            if (this.isSelected(e)) {
                e.getPresentation().setText(ActionsBundle.message((String)"action.ToggleUiInspectorHierarchyTrace.text.disable", (Object[])new Object[0]));
            } else {
                e.getPresentation().setText(ActionsBundle.message((String)"action.ToggleUiInspectorHierarchyTrace.text.enable", (Object[])new Object[0]));
            }
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            if (e == null) {
                ToggleHierarchyTraceAction.$$$reportNull$$$0(1);
            }
            return this.myEnabled;
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            if (e == null) {
                ToggleHierarchyTraceAction.$$$reportNull$$$0(2);
            }
            if (state) {
                Toolkit.getDefaultToolkit().addAWTEventListener(this, 2L);
            } else {
                Toolkit.getDefaultToolkit().removeAWTEventListener(this);
            }
            this.myEnabled = state;
        }

        @Override
        public void eventDispatched(AWTEvent event) {
            if (event instanceof ContainerEvent) {
                UiInspector.processContainerEvent((ContainerEvent)event);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/internal/inspector/UiInspectorAction$ToggleHierarchyTraceAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSelected";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setSelected";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class UiInspectorIcons {
        private static final Map<Class<?>, Icon> COMPONENT_MAPPING = new HashMap();
        @NotNull
        static final Icon Kotlin;
        @NotNull
        static final Icon Unknown;

        UiInspectorIcons() {
        }

        @NotNull
        private static Icon load(@NotNull String path2) {
            if (path2 == null) {
                UiInspectorIcons.$$$reportNull$$$0(0);
            }
            return UiInspectorIcons.load(path2, null);
        }

        @NotNull
        private static Icon load(@NotNull String path2, Class<?> cls) {
            if (path2 == null) {
                UiInspectorIcons.$$$reportNull$$$0(1);
            }
            Icon icon2 = IconLoader.getIcon((String)("com/intellij/internal/inspector/icons/" + path2), UiInspectorAction.class);
            if (cls != null) {
                COMPONENT_MAPPING.put(cls, icon2);
            }
            Icon icon3 = icon2;
            if (icon3 == null) {
                UiInspectorIcons.$$$reportNull$$$0(2);
            }
            return icon3;
        }

        public static Icon findIconFor(Component component2) {
            Icon icon2 = null;
            for (Class<?> aClass = component2.getClass(); icon2 == null && aClass != null; aClass = aClass.getSuperclass()) {
                icon2 = COMPONENT_MAPPING.get(aClass);
            }
            if (icon2 == null) {
                icon2 = Unknown;
            }
            if (ComponentUtil.findParentByCondition((Component)component2, c -> c.getClass() == DialogPanel.class) != null) {
                Icon kotlinIcon = ((ScalableIcon)Kotlin).scale(0.5f);
                return new RowIcon(icon2, IconUtil.toSize(kotlinIcon, icon2.getIconWidth(), icon2.getIconHeight()));
            }
            return icon2;
        }

        static {
            UiInspectorIcons.load("button.svg", JButton.class);
            UiInspectorIcons.load("checkBox.svg", JCheckBox.class);
            UiInspectorIcons.load("comboBox.svg", JComboBox.class);
            UiInspectorIcons.load("editorPane.svg", JEditorPane.class);
            UiInspectorIcons.load("formattedTextField.svg", JFormattedTextField.class);
            UiInspectorIcons.load("label.svg", JLabel.class);
            UiInspectorIcons.load("list.svg", JList.class);
            UiInspectorIcons.load("panel.svg", JPanel.class);
            UiInspectorIcons.load("passwordField.svg", JPasswordField.class);
            UiInspectorIcons.load("progressbar.svg", JProgressBar.class);
            UiInspectorIcons.load("radioButton.svg", JRadioButton.class);
            UiInspectorIcons.load("scrollbar.svg", JScrollBar.class);
            UiInspectorIcons.load("scrollPane.svg", JScrollPane.class);
            UiInspectorIcons.load("separator.svg", JSeparator.class);
            UiInspectorIcons.load("slider.svg", JSlider.class);
            UiInspectorIcons.load("spinner.svg", JSpinner.class);
            UiInspectorIcons.load("splitPane.svg", JSplitPane.class);
            UiInspectorIcons.load("tabbedPane.svg", JTabbedPane.class);
            UiInspectorIcons.load("table.svg", JTable.class);
            UiInspectorIcons.load("textArea.svg", JTextArea.class);
            UiInspectorIcons.load("textField.svg", JTextField.class);
            UiInspectorIcons.load("textPane.svg", JTextPane.class);
            UiInspectorIcons.load("toolbar.svg", JToolBar.class);
            UiInspectorIcons.load("tree.svg", JTree.class);
            Kotlin = UiInspectorIcons.load("kotlin.svg");
            Unknown = UiInspectorIcons.load("unknown.svg");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/internal/inspector/UiInspectorAction$UiInspectorIcons";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/internal/inspector/UiInspectorAction$UiInspectorIcons";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "load";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "load";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class UiInspector
    implements AWTEventListener,
    Disposable {
        UiInspector(@Nullable Project project) {
            if (project != null) {
                Disposer.register((Disposable)project, (Disposable)this);
            }
            Toolkit.getDefaultToolkit().addAWTEventListener(this, 2L);
        }

        public void dispose() {
            Toolkit.getDefaultToolkit().removeAWTEventListener(this);
            for (Window window : Window.getWindows()) {
                if (!(window instanceof InspectorWindow)) continue;
                ((InspectorWindow)window).close();
            }
        }

        public void showInspector(@Nullable Project project, @NotNull Component c) {
            if (c == null) {
                UiInspector.$$$reportNull$$$0(0);
            }
            InspectorWindow window = new InspectorWindow(project, c, this);
            Disposer.register((Disposable)window, (Disposable)this);
            if (DimensionService.getInstance().getSize(InspectorWindow.getDimensionServiceKey(), null) == null) {
                window.pack();
            }
            window.setVisible(true);
            window.toFront();
        }

        @Override
        public void eventDispatched(AWTEvent event) {
            if (event instanceof ContainerEvent) {
                UiInspector.processContainerEvent((ContainerEvent)event);
            }
        }

        private void processMouseEvent(Project project, MouseEvent me) {
            me.consume();
            Component component2 = me.getComponent();
            if (component2 instanceof Container) {
                component2 = UIUtil.getDeepestComponentAt((Component)component2, (int)me.getX(), (int)me.getY());
            } else if (component2 == null) {
                component2 = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
            }
            if (component2 != null) {
                if (component2 instanceof JComponent) {
                    UIUtil.putClientProperty((JComponent)((JComponent)component2), CLICK_INFO, UiInspector.getClickInfo(me, component2));
                    UIUtil.putClientProperty((JComponent)((JComponent)component2), CLICK_INFO_POINT, (Object)me.getPoint());
                }
                this.showInspector(project, component2);
            }
        }

        private static List<PropertyBean> getClickInfo(MouseEvent me, Component component2) {
            JTree tree;
            TreePath path2;
            JList list2;
            int row2;
            if (me.getComponent() == null) {
                return null;
            }
            me = SwingUtilities.convertMouseEvent(me.getComponent(), me, component2);
            ArrayList<PropertyBean> clickInfo = new ArrayList<PropertyBean>();
            if (component2 instanceof JList && (row2 = (list2 = (JList)component2).getUI().locationToIndex(list2, me.getPoint())) != -1) {
                Component rendererComponent = list2.getCellRenderer().getListCellRendererComponent(list2, list2.getModel().getElementAt(row2), row2, list2.getSelectionModel().isSelectedIndex(row2), list2.hasFocus());
                clickInfo.addAll(UiInspector.findActionsFor(list2.getModel().getElementAt(row2)));
                clickInfo.add(new PropertyBean(UiInspectorAction.RENDERER_BOUNDS, list2.getUI().getCellBounds(list2, row2, row2)));
                clickInfo.addAll(new InspectorTableModel((Component)rendererComponent).myProperties);
                return clickInfo;
            }
            if (component2 instanceof JTable) {
                JTable table = (JTable)component2;
                row2 = table.rowAtPoint(me.getPoint());
                int column2 = table.columnAtPoint(me.getPoint());
                if (row2 != -1 && column2 != -1) {
                    Component rendererComponent = table.getCellRenderer(row2, column2).getTableCellRendererComponent(table, table.getValueAt(row2, column2), table.getSelectionModel().isSelectedIndex(row2), table.hasFocus(), row2, column2);
                    clickInfo.add(new PropertyBean(UiInspectorAction.RENDERER_BOUNDS, table.getCellRect(row2, column2, true)));
                    clickInfo.addAll(new InspectorTableModel((Component)rendererComponent).myProperties);
                    return clickInfo;
                }
            }
            if (component2 instanceof JTree && (path2 = (tree = (JTree)component2).getClosestPathForLocation(me.getX(), me.getY())) != null) {
                Object object = path2.getLastPathComponent();
                Component rendererComponent = tree.getCellRenderer().getTreeCellRendererComponent(tree, object, tree.getSelectionModel().isPathSelected(path2), tree.isExpanded(path2), tree.getModel().isLeaf(object), tree.getRowForPath(path2), tree.hasFocus());
                clickInfo.add(new PropertyBean(UiInspectorAction.RENDERER_BOUNDS, tree.getPathBounds(path2)));
                clickInfo.addAll(new InspectorTableModel((Component)rendererComponent).myProperties);
                return clickInfo;
            }
            return null;
        }

        private static List<PropertyBean> findActionsFor(Object object) {
            if (object instanceof PopupFactoryImpl.ActionItem) {
                AnAction action2 = ((PopupFactoryImpl.ActionItem)object).getAction();
                return UiInspectorUtil.collectAnActionInfo(action2);
            }
            if (object instanceof QuickFixWrapper) {
                return UiInspector.findActionsFor(((QuickFixWrapper)object).getFix());
            }
            if (object instanceof IntentionActionDelegate) {
                IntentionAction delegate2 = ((IntentionActionDelegate)object).getDelegate();
                if (delegate2 != object) {
                    return UiInspector.findActionsFor(delegate2);
                }
            } else {
                if (object instanceof IntentionAction) {
                    return Collections.singletonList(new PropertyBean("intention action", object.getClass().getName(), true));
                }
                if (object instanceof QuickFix) {
                    return Collections.singletonList(new PropertyBean("quick fix", object.getClass().getName(), true));
                }
            }
            return Collections.emptyList();
        }

        private static void processContainerEvent(ContainerEvent event) {
            Component child2;
            Component component2 = child2 = event.getID() == 300 ? event.getChild() : null;
            if (child2 instanceof JComponent && !(event.getSource() instanceof CellRendererPane)) {
                UIUtil.putClientProperty((JComponent)((JComponent)child2), ADDED_AT_STACKTRACE, (Object)new Throwable());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/intellij/internal/inspector/UiInspectorAction$UiInspector", "showInspector"));
        }
    }

    private static class InspectorTableModel
    extends AbstractTableModel {
        final List<String> PROPERTIES;
        final List<String> CHECKERS;
        final List<String> ACCESSIBLE_CONTEXT_PROPERTIES;
        final List<String> MIGLAYOUT_CC_PROPERTIES;
        final Component myComponent;
        final List<PropertyBean> myProperties;

        InspectorTableModel(@NotNull List<? extends PropertyBean> clickInfo) {
            if (clickInfo == null) {
                InspectorTableModel.$$$reportNull$$$0(0);
            }
            this.PROPERTIES = Arrays.asList("ui", "getLocation", "getLocationOnScreen", "getSize", "isOpaque", "getBorder", "getForeground", "getBackground", "getFont", "getCellRenderer", "getCellEditor", "getMinimumSize", "getMaximumSize", "getPreferredSize", "getPreferredScrollableViewportSize", "getText", "isEditable", "getIcon", "getVisibleRect", "getLayout", "getAlignmentX", "getAlignmentY", "getTooltipText", "getToolTipText", "cursor", "isShowing", "isEnabled", "isVisible", "isDoubleBuffered", "isFocusable", "isFocusCycleRoot", "isFocusOwner", "isValid", "isDisplayable", "isLightweight", "getClientProperties", "getMouseListeners");
            this.CHECKERS = Arrays.asList("isForegroundSet", "isBackgroundSet", "isFontSet", "isMinimumSizeSet", "isMaximumSizeSet", "isPreferredSizeSet");
            this.ACCESSIBLE_CONTEXT_PROPERTIES = Arrays.asList("getAccessibleRole", "getAccessibleName", "getAccessibleDescription", "getAccessibleAction", "getAccessibleChildrenCount", "getAccessibleIndexInParent", "getAccessibleRelationSet", "getAccessibleStateSet", "getAccessibleEditableText", "getAccessibleTable", "getAccessibleText", "getAccessibleValue", "accessibleChangeSupport");
            this.MIGLAYOUT_CC_PROPERTIES = Arrays.asList("getHorizontal", "getVertical");
            this.myProperties = new ArrayList<PropertyBean>();
            this.myComponent = null;
            this.myProperties.addAll(clickInfo);
        }

        InspectorTableModel(@NotNull Component c) {
            if (c == null) {
                InspectorTableModel.$$$reportNull$$$0(1);
            }
            this.PROPERTIES = Arrays.asList("ui", "getLocation", "getLocationOnScreen", "getSize", "isOpaque", "getBorder", "getForeground", "getBackground", "getFont", "getCellRenderer", "getCellEditor", "getMinimumSize", "getMaximumSize", "getPreferredSize", "getPreferredScrollableViewportSize", "getText", "isEditable", "getIcon", "getVisibleRect", "getLayout", "getAlignmentX", "getAlignmentY", "getTooltipText", "getToolTipText", "cursor", "isShowing", "isEnabled", "isVisible", "isDoubleBuffered", "isFocusable", "isFocusCycleRoot", "isFocusOwner", "isValid", "isDisplayable", "isLightweight", "getClientProperties", "getMouseListeners");
            this.CHECKERS = Arrays.asList("isForegroundSet", "isBackgroundSet", "isFontSet", "isMinimumSizeSet", "isMaximumSizeSet", "isPreferredSizeSet");
            this.ACCESSIBLE_CONTEXT_PROPERTIES = Arrays.asList("getAccessibleRole", "getAccessibleName", "getAccessibleDescription", "getAccessibleAction", "getAccessibleChildrenCount", "getAccessibleIndexInParent", "getAccessibleRelationSet", "getAccessibleStateSet", "getAccessibleEditableText", "getAccessibleTable", "getAccessibleText", "getAccessibleValue", "accessibleChangeSupport");
            this.MIGLAYOUT_CC_PROPERTIES = Arrays.asList("getHorizontal", "getVertical");
            this.myProperties = new ArrayList<PropertyBean>();
            this.myComponent = c;
            this.fillTable();
        }

        void fillTable() {
            CC cc;
            LayoutManager layout;
            this.addProperties("", this.myComponent, this.PROPERTIES);
            String addedAt = UiInspectorAction.getAddedAtStacktrace(this.myComponent);
            this.myProperties.add(new PropertyBean("added-at", addedAt, addedAt != null));
            boolean isAccessible = this.myComponent instanceof Accessible;
            this.myProperties.add(new PropertyBean("accessible", isAccessible));
            AccessibleContext context2 = this.myComponent.getAccessibleContext();
            this.myProperties.add(new PropertyBean("accessibleContext", context2));
            if (isAccessible) {
                this.addProperties("  ", this.myComponent.getAccessibleContext(), this.ACCESSIBLE_CONTEXT_PROPERTIES);
            }
            if (this.myComponent instanceof Container) {
                this.addLayoutProperties((Container)this.myComponent);
            }
            if (this.myComponent instanceof TextPanel.WithIconAndArrows) {
                this.myProperties.add(new PropertyBean("icon", ((TextPanel.WithIconAndArrows)((Object)this.myComponent)).getIcon()));
            }
            if (this.myComponent.getParent() != null && (layout = this.myComponent.getParent().getLayout()) instanceof com.intellij.ui.layout.migLayout.patched.MigLayout && (cc = ((com.intellij.ui.layout.migLayout.patched.MigLayout)layout).getComponentConstraints().get(this.myComponent)) != null) {
                this.addMigLayoutComponentConstraints(cc);
            }
        }

        private void addProperties(@NotNull String prefix2, @NotNull Object component2, @NotNull List<String> methodNames) {
            DialogWrapper dialog2;
            TreeModel model2;
            Class<?> declaringClass;
            Class<?> superClass;
            if (prefix2 == null) {
                InspectorTableModel.$$$reportNull$$$0(2);
            }
            if (component2 == null) {
                InspectorTableModel.$$$reportNull$$$0(3);
            }
            if (methodNames == null) {
                InspectorTableModel.$$$reportNull$$$0(4);
            }
            Class<?> clazz = component2.getClass();
            this.myProperties.add(new PropertyBean(prefix2 + "class", clazz.getName() + "@" + System.identityHashCode(component2)));
            if (clazz.isAnonymousClass() && (superClass = clazz.getSuperclass()) != null) {
                this.myProperties.add(new PropertyBean(prefix2 + "superclass", superClass.getName(), true));
            }
            if ((declaringClass = clazz.getDeclaringClass()) != null) {
                this.myProperties.add(new PropertyBean(prefix2 + "declaringClass", declaringClass.getName()));
            }
            if (component2 instanceof Tree && (model2 = ((Tree)component2).getModel()) != null) {
                this.myProperties.add(new PropertyBean(prefix2 + "treeModelClass", model2.getClass().getName(), true));
            }
            this.addActionInfo(component2);
            this.addToolbarInfo(component2);
            this.addToolWindowInfo(component2);
            this.addGutterInfo(component2);
            UiInspectorContextProvider contextProvider = UiInspectorUtil.getProvider(component2);
            if (contextProvider != null) {
                this.myProperties.addAll(contextProvider.getUiInspectorContext());
            }
            StringBuilder classHierarchy = new StringBuilder();
            for (Class<?> cl = clazz.getSuperclass(); cl != null; cl = cl.getSuperclass()) {
                if (classHierarchy.length() > 0) {
                    classHierarchy.append(" ").append(UIUtil.rightArrow()).append(" ");
                }
                classHierarchy.append(cl.getName());
                if (JComponent.class.getName().equals(cl.getName())) break;
            }
            this.myProperties.add(new PropertyBean(prefix2 + "hierarchy", classHierarchy.toString()));
            if (component2 instanceof Component && (dialog2 = DialogWrapper.findInstance((Component)((Component)component2))) != null) {
                this.myProperties.add(new PropertyBean(prefix2 + "dialogWrapperClass", dialog2.getClass().getName(), true));
            }
            this.addPropertiesFromMethodNames(prefix2, component2, methodNames);
        }

        private static List<Method> collectAllMethodsRecursively(Class<?> clazz) {
            ArrayList<Method> list2 = new ArrayList<Method>();
            for (Class<?> cl = clazz; cl != null; cl = cl.getSuperclass()) {
                list2.addAll(Arrays.asList(cl.getDeclaredMethods()));
            }
            return list2;
        }

        private void addPropertiesFromMethodNames(@NotNull String prefix2, @NotNull Object component2, @NotNull List<String> methodNames) {
            Class<?> clazz0;
            if (prefix2 == null) {
                InspectorTableModel.$$$reportNull$$$0(5);
            }
            if (component2 == null) {
                InspectorTableModel.$$$reportNull$$$0(6);
            }
            if (methodNames == null) {
                InspectorTableModel.$$$reportNull$$$0(7);
            }
            Class<?> clazz = (clazz0 = component2.getClass()).isAnonymousClass() ? clazz0.getSuperclass() : clazz0;
            for (String name : methodNames) {
                String propertyName = (String)ObjectUtils.notNull((Object)StringUtil.getPropertyName((String)name), (Object)name);
                try {
                    Object propertyValue;
                    try {
                        propertyValue = ReflectionUtil.findMethod(InspectorTableModel.collectAllMethodsRecursively(clazz), (String)name, (Class[])new Class[0]).invoke(component2, new Object[0]);
                    }
                    catch (Exception e) {
                        propertyValue = ReflectionUtil.findField(clazz, null, (String)name).get(component2);
                    }
                    boolean changed2 = false;
                    try {
                        Object value2;
                        String checkerMethodName = "is" + StringUtil.capitalize((String)propertyName) + "Set";
                        if (this.CHECKERS.contains(checkerMethodName) && (value2 = ReflectionUtil.findMethod(Arrays.asList(clazz.getMethods()), (String)checkerMethodName, (Class[])new Class[0]).invoke(component2, new Object[0])) instanceof Boolean) {
                            changed2 = (Boolean)value2;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.myProperties.add(new PropertyBean(prefix2 + propertyName, propertyValue, changed2));
                }
                catch (Exception exception) {}
            }
        }

        private void addGutterInfo(Object component2) {
            GutterMark renderer;
            Point clickPoint;
            Point point = clickPoint = component2 instanceof EditorGutterComponentEx ? (Point)UIUtil.getClientProperty((Object)component2, CLICK_INFO_POINT) : null;
            if (clickPoint != null && (renderer = ((EditorGutterComponentEx)component2).getGutterRenderer(clickPoint)) != null) {
                this.myProperties.add(new PropertyBean("gutter renderer", renderer.getClass().getName(), true));
            }
        }

        private void addActionInfo(Object component2) {
            AnAction action2 = null;
            if (component2 instanceof ActionButton) {
                action2 = ((ActionButton)component2).getAction();
            } else if (component2 instanceof JComponent) {
                action2 = component2 instanceof ActionMenuItem ? ((ActionMenuItem)((Object)component2)).getAnAction() : (component2 instanceof ActionMenu ? ((ActionMenu)((Object)component2)).getAnAction() : UiInspectorAction.getAction(ComponentUtil.findParentByCondition((Component)((Component)component2), c -> UiInspectorAction.getAction(c) != null)));
            }
            if (action2 != null) {
                this.myProperties.addAll(UiInspectorUtil.collectAnActionInfo(action2));
            }
        }

        private void addToolbarInfo(Object component2) {
            if (component2 instanceof ActionToolbarImpl) {
                ActionToolbarImpl toolbar = (ActionToolbarImpl)component2;
                this.myProperties.addAll(UiInspectorUtil.collectActionGroupInfo("Toolbar", toolbar.getActionGroup(), toolbar.getPlace()));
                JComponent targetComponent = (JComponent)ReflectionUtil.getField(ActionToolbarImpl.class, (Object)toolbar, JComponent.class, (String)"myTargetComponent");
                if (targetComponent != null) {
                    this.myProperties.add(new PropertyBean("Target component", targetComponent.toString(), true));
                }
            }
        }

        private void addToolWindowInfo(Object component2) {
            if (component2 instanceof StripeButton) {
                ToolWindowImpl window = ((StripeButton)component2).getToolWindow();
                this.myProperties.add(new PropertyBean("Tool Window ID", window.getId(), true));
                this.myProperties.add(new PropertyBean("Tool Window Icon", window.getIcon()));
                ToolWindowFactory contentFactory = (ToolWindowFactory)ReflectionUtil.getField(ToolWindowImpl.class, (Object)window, ToolWindowFactory.class, (String)"contentFactory");
                if (contentFactory != null) {
                    this.myProperties.add(new PropertyBean("Tool Window Factory", contentFactory));
                } else {
                    ToolWindowEP ep2 = (ToolWindowEP)ToolWindowEP.EP_NAME.findFirstSafe(it -> it.id == window.getId());
                    if (ep2 != null && ep2.factoryClass != null) {
                        this.myProperties.add(new PropertyBean("Tool Window Factory", ep2.factoryClass));
                    }
                }
            }
        }

        private void addLayoutProperties(@NotNull Container component2) {
            if (component2 == null) {
                InspectorTableModel.$$$reportNull$$$0(8);
            }
            String prefix2 = "  ";
            LayoutManager layout = component2.getLayout();
            if (layout instanceof GridBagLayout) {
                GridBagLayout bagLayout = (GridBagLayout)layout;
                GridBagConstraints defaultConstraints = (GridBagConstraints)ReflectionUtil.getField(GridBagLayout.class, (Object)bagLayout, GridBagConstraints.class, (String)"defaultConstraints");
                this.myProperties.add(new PropertyBean("GridBagLayout constraints", String.format("defaultConstraints - %s", InspectorTableModel.toString(defaultConstraints))));
                if (bagLayout.columnWidths != null) {
                    this.myProperties.add(new PropertyBean(prefix2 + "columnWidths", Arrays.toString(bagLayout.columnWidths)));
                }
                if (bagLayout.rowHeights != null) {
                    this.myProperties.add(new PropertyBean(prefix2 + "rowHeights", Arrays.toString(bagLayout.rowHeights)));
                }
                if (bagLayout.columnWeights != null) {
                    this.myProperties.add(new PropertyBean(prefix2 + "columnWeights", Arrays.toString(bagLayout.columnWeights)));
                }
                if (bagLayout.rowWeights != null) {
                    this.myProperties.add(new PropertyBean(prefix2 + "rowWeights", Arrays.toString(bagLayout.rowWeights)));
                }
                for (Component child2 : component2.getComponents()) {
                    this.myProperties.add(new PropertyBean(prefix2 + UiInspectorAction.getComponentName(child2), InspectorTableModel.toString(bagLayout.getConstraints(child2))));
                }
            } else if (layout instanceof BorderLayout) {
                BorderLayout borderLayout = (BorderLayout)layout;
                this.myProperties.add(new PropertyBean("BorderLayout constraints", String.format("hgap - %s, vgap - %s", borderLayout.getHgap(), borderLayout.getVgap())));
                for (Component child3 : component2.getComponents()) {
                    this.myProperties.add(new PropertyBean(prefix2 + UiInspectorAction.getComponentName(child3), borderLayout.getConstraints(child3)));
                }
            } else if (layout instanceof CardLayout) {
                CardLayout cardLayout = (CardLayout)layout;
                Integer currentCard = (Integer)ReflectionUtil.getField(CardLayout.class, (Object)cardLayout, null, (String)"currentCard");
                Vector vector = (Vector)ReflectionUtil.getField(CardLayout.class, (Object)cardLayout, Vector.class, (String)"vector");
                String cardDescription = "???";
                if (vector != null && currentCard != null) {
                    Object card = vector.get(currentCard);
                    cardDescription = (String)ReflectionUtil.getField(card.getClass(), card, String.class, (String)"name");
                }
                this.myProperties.add(new PropertyBean("CardLayout constraints", String.format("card - %s, hgap - %s, vgap - %s", cardDescription, cardLayout.getHgap(), cardLayout.getVgap())));
                if (vector != null) {
                    for (Object card : vector) {
                        String cardName = (String)ReflectionUtil.getField(card.getClass(), card, String.class, (String)"name");
                        Component child4 = (Component)ReflectionUtil.getField(card.getClass(), card, Component.class, (String)"comp");
                        this.myProperties.add(new PropertyBean(prefix2 + UiInspectorAction.getComponentName(child4), cardName));
                    }
                }
            } else if (layout instanceof MigLayout) {
                MigLayout migLayout = (MigLayout)layout;
                Object constraints2 = migLayout.getLayoutConstraints();
                if (constraints2 instanceof LC) {
                    this.addMigLayoutLayoutConstraints((LC)constraints2);
                } else {
                    this.myProperties.add(new PropertyBean("MigLayout layout constraints", constraints2));
                }
                constraints2 = migLayout.getColumnConstraints();
                if (constraints2 instanceof AC) {
                    this.addMigLayoutAxisConstraints("MigLayout column constraints", (AC)constraints2);
                } else {
                    this.myProperties.add(new PropertyBean("MigLayout column constraints", constraints2));
                }
                constraints2 = migLayout.getRowConstraints();
                if (constraints2 instanceof AC) {
                    this.addMigLayoutAxisConstraints("MigLayout row constraints", (AC)constraints2);
                } else {
                    this.myProperties.add(new PropertyBean("MigLayout row constraints", constraints2));
                }
                for (Component child5 : component2.getComponents()) {
                    this.myProperties.add(new PropertyBean(prefix2 + UiInspectorAction.getComponentName(child5), migLayout.getComponentConstraints(child5)));
                }
            } else if (layout instanceof com.intellij.ui.layout.migLayout.patched.MigLayout) {
                com.intellij.ui.layout.migLayout.patched.MigLayout migLayout = (com.intellij.ui.layout.migLayout.patched.MigLayout)layout;
                this.addMigLayoutLayoutConstraints(migLayout.getLayoutConstraints());
                this.addMigLayoutAxisConstraints("MigLayout column constraints", migLayout.getColumnConstraints());
                this.addMigLayoutAxisConstraints("MigLayout row constraints", migLayout.getRowConstraints());
            }
        }

        private void addMigLayoutLayoutConstraints(LC lc) {
            this.myProperties.add(new PropertyBean("MigLayout layout constraints", InspectorTableModel.lcConstraintToString(lc)));
            Object[] insets = lc.getInsets();
            if (insets != null) {
                List insetsText = ContainerUtil.map((Object[])insets, i2 -> InspectorTableModel.unitValueToString(i2));
                this.myProperties.add(new PropertyBean("  lc.insets", "[" + StringUtil.join((Collection)insetsText, (String)", ") + "]"));
            }
            UnitValue alignX = lc.getAlignX();
            UnitValue alignY = lc.getAlignY();
            if (alignX != null || alignY != null) {
                this.myProperties.add(new PropertyBean("  lc.align", "x: " + InspectorTableModel.unitValueToString(alignX) + "; y: " + InspectorTableModel.unitValueToString(alignY)));
            }
            BoundSize width = lc.getWidth();
            BoundSize height = lc.getHeight();
            if (width != BoundSize.NULL_SIZE || height != BoundSize.NULL_SIZE) {
                this.myProperties.add(new PropertyBean("  lc.size", "width: " + InspectorTableModel.boundSizeToString(width) + "; height: " + InspectorTableModel.boundSizeToString(height)));
            }
            BoundSize gridX = lc.getGridGapX();
            BoundSize gridY = lc.getGridGapY();
            if (gridX != null || gridY != null) {
                this.myProperties.add(new PropertyBean("  lc.gridGap", "x: " + InspectorTableModel.boundSizeToString(gridX) + "; y: " + InspectorTableModel.boundSizeToString(gridY)));
            }
            boolean fillX = lc.isFillX();
            boolean fillY = lc.isFillY();
            if (fillX || fillY) {
                this.myProperties.add(new PropertyBean("  lc.fill", "x: " + fillX + "; y: " + fillY));
            }
            BoundSize packWidth = lc.getPackWidth();
            BoundSize packHeight = lc.getPackHeight();
            if (packWidth != BoundSize.NULL_SIZE || packHeight != BoundSize.NULL_SIZE) {
                this.myProperties.add(new PropertyBean("  lc.pack", "width: " + packWidth + "; height: " + packHeight + "; widthAlign: " + lc.getPackWidthAlign() + "; heightAlign: " + lc.getPackHeightAlign()));
            }
        }

        private static String lcConstraintToString(LC constraint) {
            return "isFlowX=" + constraint.isFlowX() + " leftToRight=" + constraint.getLeftToRight() + " noGrid=" + constraint.isNoGrid() + " hideMode=" + constraint.getHideMode() + " visualPadding=" + constraint.isVisualPadding() + " topToBottom=" + constraint.isTopToBottom() + " noCache=" + constraint.isNoCache();
        }

        private void addMigLayoutAxisConstraints(String title2, AC ac) {
            this.myProperties.add(new PropertyBean(title2, ac));
            DimConstraint[] constraints2 = ac.getConstaints();
            for (int i2 = 0; i2 < constraints2.length; ++i2) {
                this.addDimConstraintProperties("  [" + i2 + "]", constraints2[i2]);
            }
        }

        private void addMigLayoutComponentConstraints(CC cc) {
            this.myProperties.add(new PropertyBean("MigLayout component constraints", InspectorTableModel.componentConstraintsToString(cc)));
            DimConstraint horizontal = cc.getHorizontal();
            this.addDimConstraintProperties("  cc.horizontal", horizontal);
            DimConstraint vertical = cc.getVertical();
            this.addDimConstraintProperties("  cc.vertical", vertical);
        }

        private void addDimConstraintProperties(String name, DimConstraint constraint) {
            BoundSize gapAfter;
            BoundSize gapBefore;
            UnitValue align;
            this.myProperties.add(new PropertyBean(name, InspectorTableModel.dimConstraintToString(constraint)));
            BoundSize size = constraint.getSize();
            if (size != null) {
                this.myProperties.add(new PropertyBean("  " + name + ".size", InspectorTableModel.boundSizeToString(size)));
            }
            if ((align = constraint.getAlign()) != null) {
                this.myProperties.add(new PropertyBean("  " + name + ".align", InspectorTableModel.unitValueToString(align)));
            }
            if ((gapBefore = constraint.getGapBefore()) != null && !gapBefore.isUnset()) {
                this.myProperties.add(new PropertyBean("  " + name + ".gapBefore", InspectorTableModel.boundSizeToString(gapBefore)));
            }
            if ((gapAfter = constraint.getGapAfter()) != null && !gapAfter.isUnset()) {
                this.myProperties.add(new PropertyBean("  " + name + ".gapAfter", InspectorTableModel.boundSizeToString(gapAfter)));
            }
        }

        private static String componentConstraintsToString(CC cc) {
            CC newCC = new CC();
            StringBuilder stringBuilder = new StringBuilder();
            if (cc.getSkip() != newCC.getSkip()) {
                stringBuilder.append(" skip=").append(cc.getSkip());
            }
            if (cc.getSpanX() != newCC.getSpanX()) {
                stringBuilder.append(" spanX=").append(cc.getSpanX() == 2097051 ? "INF" : Integer.valueOf(cc.getSpanX()));
            }
            if (cc.getSpanY() != newCC.getSpanY()) {
                stringBuilder.append(" spanY=").append(cc.getSpanY() == 2097051 ? "INF" : Integer.valueOf(cc.getSpanY()));
            }
            if (cc.getPushX() != null) {
                stringBuilder.append(" pushX=").append(cc.getPushX());
            }
            if (cc.getPushY() != null) {
                stringBuilder.append(" pushY=").append(cc.getPushY());
            }
            if (cc.getSplit() != newCC.getSplit()) {
                stringBuilder.append(" split=").append(cc.getSplit());
            }
            if (cc.isWrap()) {
                stringBuilder.append(" wrap=");
                if (cc.getWrapGapSize() != null) {
                    stringBuilder.append(cc.getWrapGapSize());
                } else {
                    stringBuilder.append("true");
                }
            }
            if (cc.isNewline()) {
                stringBuilder.append(" newline=");
                if (cc.getNewlineGapSize() != null) {
                    stringBuilder.append(cc.getNewlineGapSize());
                } else {
                    stringBuilder.append("true");
                }
            }
            if (cc.getHideMode() != newCC.getHideMode()) {
                stringBuilder.append(" hidemode=").append(cc.getHideMode());
            }
            return stringBuilder.toString().trim();
        }

        private static String dimConstraintToString(DimConstraint constraint) {
            StringBuilder stringBuilder = new StringBuilder();
            DimConstraint newConstraint = new DimConstraint();
            if (!Comparing.equal((Object)constraint.getGrow(), (Object)newConstraint.getGrow())) {
                stringBuilder.append(" grow=").append(constraint.getGrow());
            }
            if (constraint.getGrowPriority() != newConstraint.getGrowPriority()) {
                stringBuilder.append(" growPrio=").append(constraint.getGrowPriority());
            }
            if (!Comparing.equal((Object)constraint.getShrink(), (Object)newConstraint.getShrink())) {
                stringBuilder.append(" shrink=").append(constraint.getShrink());
            }
            if (constraint.getShrinkPriority() != newConstraint.getShrinkPriority()) {
                stringBuilder.append(" shrinkPrio=").append(constraint.getShrinkPriority());
            }
            if (constraint.isFill() != newConstraint.isFill()) {
                stringBuilder.append(" fill=").append(constraint.isFill());
            }
            if (constraint.isNoGrid() != newConstraint.isNoGrid()) {
                stringBuilder.append(" noGrid=").append(constraint.isNoGrid());
            }
            if (!Objects.equals(constraint.getSizeGroup(), newConstraint.getSizeGroup())) {
                stringBuilder.append(" sizeGroup=").append(constraint.getSizeGroup());
            }
            if (!Objects.equals(constraint.getEndGroup(), newConstraint.getEndGroup())) {
                stringBuilder.append(" endGroup=").append(constraint.getEndGroup());
            }
            return stringBuilder.toString();
        }

        private static String unitValueToString(@Nullable UnitValue unitValue) {
            if (unitValue == null) {
                return "null";
            }
            if (unitValue.getOperation() == 100) {
                StringBuilder result2 = new StringBuilder();
                result2.append(unitValue.getValue());
                if (unitValue.getUnitString() != null) {
                    result2.append(unitValue.getUnitString());
                } else {
                    int unit = unitValue.getUnit();
                    if (unit >= 0) {
                        String unitName = (String)((Map)MIG_LAYOUT_UNIT_MAP.get()).get(unit);
                        if (unitName == null) {
                            return unitValue.toString();
                        }
                        result2.append(unitName);
                    }
                }
                if (unitValue.isHorizontal()) {
                    result2.append("H");
                } else {
                    result2.append("V");
                }
                return result2.toString();
            }
            return unitValue.toString();
        }

        private static String boundSizeToString(BoundSize boundSize) {
            StringBuilder result2 = new StringBuilder("BoundSize{ ");
            if (boundSize.getMin() != null) {
                result2.append("min=").append(InspectorTableModel.unitValueToString(boundSize.getMin())).append(" ");
            }
            if (boundSize.getPreferred() != null) {
                result2.append("pref=").append(InspectorTableModel.unitValueToString(boundSize.getPreferred())).append(" ");
            }
            if (boundSize.getMax() != null) {
                result2.append("max=").append(InspectorTableModel.unitValueToString(boundSize.getMax())).append(" ");
            }
            if (boundSize.getGapPush()) {
                result2.append("push ");
            }
            result2.append("}");
            return result2.toString();
        }

        @NotNull
        private static String toString(@Nullable GridBagConstraints constraints2) {
            if (constraints2 == null) {
                return "null";
            }
            MoreObjects.ToStringHelper h = MoreObjects.toStringHelper((String)"");
            InspectorTableModel.appendFieldValue(h, constraints2, "gridx");
            InspectorTableModel.appendFieldValue(h, constraints2, "gridy");
            InspectorTableModel.appendFieldValue(h, constraints2, "gridwidth");
            InspectorTableModel.appendFieldValue(h, constraints2, "gridheight");
            InspectorTableModel.appendFieldValue(h, constraints2, "weightx");
            InspectorTableModel.appendFieldValue(h, constraints2, "weighty");
            InspectorTableModel.appendFieldValue(h, constraints2, "anchor");
            InspectorTableModel.appendFieldValue(h, constraints2, "fill");
            InspectorTableModel.appendFieldValue(h, constraints2, "insets");
            InspectorTableModel.appendFieldValue(h, constraints2, "ipadx");
            InspectorTableModel.appendFieldValue(h, constraints2, "ipady");
            String string = h.toString();
            if (string == null) {
                InspectorTableModel.$$$reportNull$$$0(9);
            }
            return string;
        }

        private static void appendFieldValue(@NotNull MoreObjects.ToStringHelper h, @NotNull GridBagConstraints constraints2, @NotNull String field) {
            Object defaultValue;
            Object value2;
            if (h == null) {
                InspectorTableModel.$$$reportNull$$$0(10);
            }
            if (constraints2 == null) {
                InspectorTableModel.$$$reportNull$$$0(11);
            }
            if (field == null) {
                InspectorTableModel.$$$reportNull$$$0(12);
            }
            if (!Comparing.equal((Object)(value2 = ReflectionUtil.getField(GridBagConstraints.class, (Object)constraints2, null, (String)field)), (Object)(defaultValue = ReflectionUtil.getField(GridBagConstraints.class, (Object)new GridBagConstraints(), null, (String)field)))) {
                h.add(field, value2);
            }
        }

        @Override
        @Nullable
        public Object getValueAt(int row2, int column2) {
            PropertyBean bean = this.myProperties.get(row2);
            if (bean != null) {
                return column2 == 0 ? bean.propertyName : bean.propertyValue;
            }
            return null;
        }

        @Override
        public boolean isCellEditable(int row2, int col) {
            return col == 1 && this.updater(this.myProperties.get(row2)) != null;
        }

        @Override
        public void setValueAt(Object value2, int row2, int col) {
            PropertyBean bean = this.myProperties.get(row2);
            try {
                this.myProperties.set(row2, new PropertyBean(bean.propertyName, Objects.requireNonNull(this.updater(bean)).fun(value2)));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @Nullable
        public Function<Object, Object> updater(PropertyBean bean) {
            if (this.myComponent == null) {
                return null;
            }
            String name = bean.propertyName.trim();
            try {
                Method getter;
                try {
                    getter = this.myComponent.getClass().getMethod("get" + StringUtil.capitalize((String)name), new Class[0]);
                }
                catch (Exception e) {
                    getter = this.myComponent.getClass().getMethod("is" + StringUtil.capitalize((String)name), new Class[0]);
                }
                Method finalGetter = getter;
                Method setter = this.myComponent.getClass().getMethod("set" + StringUtil.capitalize((String)name), getter.getReturnType());
                setter.setAccessible(true);
                return o -> {
                    try {
                        setter.invoke((Object)this.myComponent, UiInspectorAction.fromObject(o, finalGetter.getReturnType()));
                        return finalGetter.invoke((Object)this.myComponent, new Object[0]);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                };
            }
            catch (Exception e) {
                try {
                    Field field = ReflectionUtil.findField(this.myComponent.getClass(), null, (String)name);
                    if (Modifier.isFinal(field.getModifiers()) || Modifier.isStatic(field.getModifiers())) {
                        return null;
                    }
                    return o -> {
                        try {
                            field.set(this.myComponent, UiInspectorAction.fromObject(o, field.getType()));
                            return field.get(this.myComponent);
                        }
                        catch (Exception e1) {
                            throw new RuntimeException(e1);
                        }
                    };
                }
                catch (Exception exception) {
                    return null;
                }
            }
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return this.myProperties.size();
        }

        @Override
        public String getColumnName(int columnIndex) {
            return columnIndex == 0 ? "Property" : "Value";
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return columnIndex == 0 ? String.class : Object.class;
        }

        public void refresh() {
            this.myProperties.clear();
            this.fillTable();
            this.fireTableDataChanged();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 9: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 9: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "clickInfo";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "c";
                    break;
                }
                case 2: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "prefix";
                    break;
                }
                case 3: 
                case 6: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
                case 4: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "methodNames";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/internal/inspector/UiInspectorAction$InspectorTableModel";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "h";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "constraints";
                    break;
                }
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "field";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/internal/inspector/UiInspectorAction$InspectorTableModel";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toString";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "addProperties";
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "addPropertiesFromMethodNames";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "addLayoutProperties";
                    break;
                }
                case 9: {
                    break;
                }
                case 10: 
                case 11: 
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "appendFieldValue";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 9: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class ObjectRenderer
    extends Renderer<Object> {
        private ObjectRenderer() {
            this.putClientProperty("html.disable", Boolean.TRUE);
        }

        @Override
        public void setValue(@NotNull Object value2) {
            if (value2 == null) {
                ObjectRenderer.$$$reportNull$$$0(0);
            }
            this.setText(UiInspectorAction.getToStringValue(value2));
            this.setIcon(this.getText().contains("$$$setupUI$$$") ? AllIcons.FileTypes.UiForm : null);
            if (!this.getText().equals(this.getText().trim())) {
                this.setForeground((Color)JBColor.RED);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/internal/inspector/UiInspectorAction$ObjectRenderer", "setValue"));
        }
    }

    private static class BorderRenderer
    extends Renderer<Border> {
        private BorderRenderer() {
        }

        @Override
        public void setValue(@NotNull Border value2) {
            if (value2 == null) {
                BorderRenderer.$$$reportNull$$$0(0);
            }
            this.setText(BorderRenderer.getTextDescription(value2));
            if (value2 instanceof CompoundBorder) {
                Color insideColor = BorderRenderer.getBorderColor(((CompoundBorder)value2).getInsideBorder());
                Color outsideColor = BorderRenderer.getBorderColor(((CompoundBorder)value2).getOutsideBorder());
                if (insideColor != null && outsideColor != null) {
                    this.setIcon(UiInspectorAction.createColorIcon(insideColor, outsideColor));
                } else if (insideColor != null) {
                    this.setIcon((Icon)UiInspectorAction.createColorIcon(insideColor));
                } else if (outsideColor != null) {
                    this.setIcon((Icon)UiInspectorAction.createColorIcon(outsideColor));
                } else {
                    this.setIcon(null);
                }
            } else {
                Color color = BorderRenderer.getBorderColor(value2);
                this.setIcon((Icon)(color != null ? UiInspectorAction.createColorIcon(color) : null));
            }
        }

        @Nullable
        private static Color getBorderColor(@NotNull Border value2) {
            if (value2 == null) {
                BorderRenderer.$$$reportNull$$$0(1);
            }
            if (value2 instanceof LineBorder) {
                return ((LineBorder)value2).getLineColor();
            }
            if (value2 instanceof CustomLineBorder) {
                try {
                    return (Color)ReflectionUtil.findField(CustomLineBorder.class, Color.class, (String)"myColor").get(value2);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return null;
        }

        @NotNull
        private static String getTextDescription(@Nullable Border value2) {
            if (value2 == null) {
                return "null";
            }
            StringBuilder sb = new StringBuilder();
            sb.append(UiInspectorAction.getClassName(value2));
            Color color = BorderRenderer.getBorderColor(value2);
            if (color != null) {
                sb.append(" color=").append(color);
            }
            if (value2 instanceof LineBorder && ((LineBorder)value2).getRoundedCorners()) {
                sb.append(" roundedCorners=true");
            }
            if (value2 instanceof TitledBorder) {
                sb.append(" title='").append(((TitledBorder)value2).getTitle()).append("'");
            }
            if (value2 instanceof CompoundBorder) {
                sb.append(" inside={").append(BorderRenderer.getTextDescription(((CompoundBorder)value2).getInsideBorder())).append("}");
                sb.append(" outside={").append(BorderRenderer.getTextDescription(((CompoundBorder)value2).getOutsideBorder())).append("}");
            }
            if (value2 instanceof EmptyBorder) {
                Insets insets = ((EmptyBorder)value2).getBorderInsets();
                sb.append(" insets={top=").append(insets.top).append(" left=").append(insets.left).append(" bottom=").append(insets.bottom).append(" right=").append(insets.right).append("}");
            }
            if (value2 instanceof UIResource) {
                sb.append(" UIResource");
            }
            sb.append(" (").append(UiInspectorAction.getToStringValue(value2)).append(")");
            String string = sb.toString();
            if (string == null) {
                BorderRenderer.$$$reportNull$$$0(2);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/internal/inspector/UiInspectorAction$BorderRenderer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/internal/inspector/UiInspectorAction$BorderRenderer";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTextDescription";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "setValue";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getBorderColor";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class IconRenderer
    extends Renderer<Icon> {
        private IconRenderer() {
        }

        @Override
        public void setValue(@NotNull Icon value2) {
            if (value2 == null) {
                IconRenderer.$$$reportNull$$$0(0);
            }
            this.setIcon(value2);
            this.setText(IconRenderer.getPathToIcon(value2));
        }

        private static String getPathToIcon(@NotNull Icon value2) {
            Icon icon2;
            if (value2 == null) {
                IconRenderer.$$$reportNull$$$0(1);
            }
            if (value2 instanceof RetrievableIcon && (icon2 = ((RetrievableIcon)value2).retrieveIcon()) != value2) {
                return IconRenderer.getPathToIcon(icon2);
            }
            String text2 = UiInspectorAction.getToStringValue(value2);
            if (text2.startsWith("jar:") && text2.contains("!")) {
                int index2 = text2.lastIndexOf("!");
                String jarFile = text2.substring(4, index2);
                String path2 = text2.substring(index2 + 1);
                return path2 + " in " + jarFile;
            }
            return text2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "value";
            objectArray2[1] = "com/intellij/internal/inspector/UiInspectorAction$IconRenderer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setValue";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getPathToIcon";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class BooleanRenderer
    extends Renderer<Boolean> {
        private BooleanRenderer() {
        }

        @Override
        public void setValue(@NotNull Boolean value2) {
            if (value2 == null) {
                BooleanRenderer.$$$reportNull$$$0(0);
            }
            this.setText(value2 != false ? "Yes" : "No");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/internal/inspector/UiInspectorAction$BooleanRenderer", "setValue"));
        }
    }

    private static class FontRenderer
    extends Renderer<Font> {
        private FontRenderer() {
        }

        @Override
        public void setValue(@NotNull Font value2) {
            if (value2 == null) {
                FontRenderer.$$$reportNull$$$0(0);
            }
            StringBuilder sb = new StringBuilder();
            sb.append(value2.getFontName()).append(" (").append(value2.getFamily()).append("), ").append(value2.getSize()).append("px");
            if (1 == (1 & value2.getStyle())) {
                sb.append(" bold");
            }
            if (2 == (2 & value2.getStyle())) {
                sb.append(" italic");
            }
            if (value2 instanceof UIResource) {
                sb.append(" UIResource");
            }
            Map<TextAttribute, ?> attributes2 = value2.getAttributes();
            StringBuilder attrs = new StringBuilder();
            for (Map.Entry<TextAttribute, ?> entry2 : attributes2.entrySet()) {
                String name;
                if (entry2.getKey() == TextAttribute.FAMILY || entry2.getKey() == TextAttribute.SIZE || entry2.getValue() == null) continue;
                if (attrs.length() > 0) {
                    attrs.append(",");
                }
                attrs.append((name = (String)ReflectionUtil.getField(TextAttribute.class, (Object)entry2.getKey(), String.class, (String)"name")) != null ? name : entry2.getKey()).append("=").append(entry2.getValue());
            }
            if (attrs.length() > 0) {
                sb.append(" {").append((CharSequence)attrs).append("}");
            }
            this.setText(sb.toString());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/internal/inspector/UiInspectorAction$FontRenderer", "setValue"));
        }
    }

    private static class ColorRenderer
    extends Renderer<Color> {
        private ColorRenderer() {
        }

        @Override
        public void setValue(@NotNull Color value2) {
            if (value2 == null) {
                ColorRenderer.$$$reportNull$$$0(0);
            }
            StringBuilder sb = new StringBuilder();
            sb.append(" r:").append(value2.getRed());
            sb.append(" g:").append(value2.getGreen());
            sb.append(" b:").append(value2.getBlue());
            sb.append(" a:").append(value2.getAlpha());
            sb.append(" argb:0x");
            String hex = Integer.toHexString(value2.getRGB());
            sb.append("0".repeat(8 - hex.length()));
            sb.append(StringUtil.toUpperCase((String)hex));
            if (value2 instanceof UIResource) {
                sb.append(" UIResource");
            }
            this.setText(sb.toString());
            this.setIcon((Icon)UiInspectorAction.createColorIcon(value2));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/internal/inspector/UiInspectorAction$ColorRenderer", "setValue"));
        }
    }

    private static class RectangleRenderer
    extends Renderer<Rectangle> {
        private RectangleRenderer() {
        }

        @Override
        public void setValue(@NotNull Rectangle value2) {
            if (value2 == null) {
                RectangleRenderer.$$$reportNull$$$0(0);
            }
            this.setText(RectangleRenderer.toString(value2));
        }

        @NotNull
        static String toString(@NotNull Rectangle r) {
            if (r == null) {
                RectangleRenderer.$$$reportNull$$$0(1);
            }
            String string = r.width + "x" + r.height + " @ " + r.x + ":" + r.y;
            if (string == null) {
                RectangleRenderer.$$$reportNull$$$0(2);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "r";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/internal/inspector/UiInspectorAction$RectangleRenderer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/internal/inspector/UiInspectorAction$RectangleRenderer";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toString";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "setValue";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "toString";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class InsetsRenderer
    extends Renderer<Insets> {
        private InsetsRenderer() {
        }

        @Override
        public void setValue(@NotNull Insets value2) {
            if (value2 == null) {
                InsetsRenderer.$$$reportNull$$$0(0);
            }
            this.setText("top: " + value2.top + " left:" + value2.left + " bottom:" + value2.bottom + " right:" + value2.right);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/internal/inspector/UiInspectorAction$InsetsRenderer", "setValue"));
        }
    }

    private static class DimensionRenderer
    extends Renderer<Dimension> {
        private DimensionRenderer() {
        }

        @Override
        public void setValue(@NotNull Dimension value2) {
            if (value2 == null) {
                DimensionRenderer.$$$reportNull$$$0(0);
            }
            this.setText(value2.width + "x" + value2.height);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/internal/inspector/UiInspectorAction$DimensionRenderer", "setValue"));
        }
    }

    private static class PointRenderer
    extends Renderer<Point> {
        private PointRenderer() {
        }

        @Override
        public void setValue(@NotNull Point value2) {
            if (value2 == null) {
                PointRenderer.$$$reportNull$$$0(0);
            }
            this.setText(String.valueOf(value2.x) + ":" + value2.y);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/internal/inspector/UiInspectorAction$PointRenderer", "setValue"));
        }
    }

    private static abstract class Renderer<T>
    extends JLabel {
        private Renderer() {
        }

        abstract void setValue(@NotNull T var1);
    }

    private static class ValueCellRenderer
    implements TableCellRenderer {
        private static final Map<Class<?>, Renderer<?>> RENDERERS = new HashMap();
        private static final Renderer<Object> DEFAULT_RENDERER;
        private static final JLabel NULL_RENDERER;

        private ValueCellRenderer() {
        }

        @Override
        public JLabel getTableCellRendererComponent(JTable table, Object value2, boolean isSelected, boolean hasFocus, int row2, int column2) {
            if (value2 == null) {
                NULL_RENDERER.setOpaque(isSelected);
                NULL_RENDERER.setForeground(isSelected ? table.getSelectionForeground() : table.getForeground());
                NULL_RENDERER.setBackground(isSelected ? table.getSelectionBackground() : table.getBackground());
                return NULL_RENDERER;
            }
            Renderer renderer = (Renderer)ObjectUtils.notNull(ValueCellRenderer.getRenderer(value2.getClass()), DEFAULT_RENDERER);
            renderer.setOpaque(isSelected);
            renderer.setForeground(isSelected ? table.getSelectionForeground() : table.getForeground());
            renderer.setBackground(isSelected ? table.getSelectionBackground() : table.getBackground());
            renderer.setValue(value2);
            return renderer;
        }

        @Nullable
        private static Renderer<Object> getRenderer(Class<?> clazz) {
            Class<?>[] interfaces;
            if (clazz == null) {
                return null;
            }
            Renderer<Object> renderer = RENDERERS.get(clazz);
            if (renderer != null) {
                return renderer;
            }
            for (Class<?> aClass : interfaces = clazz.getInterfaces()) {
                renderer = ValueCellRenderer.getRenderer(aClass);
                if (renderer == null) continue;
                return renderer;
            }
            if ((clazz = clazz.getSuperclass()) != null) {
                return ValueCellRenderer.getRenderer(clazz);
            }
            return null;
        }

        static {
            RENDERERS.put(Point.class, new PointRenderer());
            RENDERERS.put(Dimension.class, new DimensionRenderer());
            RENDERERS.put(Insets.class, new InsetsRenderer());
            RENDERERS.put(Rectangle.class, new RectangleRenderer());
            RENDERERS.put(Color.class, new ColorRenderer());
            RENDERERS.put(Font.class, new FontRenderer());
            RENDERERS.put(Boolean.class, new BooleanRenderer());
            RENDERERS.put(Icon.class, new IconRenderer());
            RENDERERS.put(Border.class, new BorderRenderer());
            DEFAULT_RENDERER = new ObjectRenderer();
            NULL_RENDERER = new JLabel("-");
        }
    }

    private static final class DimensionsComponent
    extends JComponent {
        Component myComponent;
        int myWidth;
        int myHeight;
        Border myBorder;
        Insets myInsets;

        private DimensionsComponent(@NotNull Component component2) {
            if (component2 == null) {
                DimensionsComponent.$$$reportNull$$$0(0);
            }
            this.myComponent = component2;
            this.setOpaque(true);
            this.setBackground((Color)JBColor.WHITE);
            this.setBorder((Border)JBUI.Borders.empty((int)5, (int)0));
            this.setFont((Font)JBUI.Fonts.label((float)9.0f));
            this.update();
        }

        public void update() {
            this.myWidth = this.myComponent.getWidth();
            this.myHeight = this.myComponent.getHeight();
            if (this.myComponent instanceof JComponent) {
                this.myBorder = ((JComponent)this.myComponent).getBorder();
                this.myInsets = ((JComponent)this.myComponent).getInsets();
            }
        }

        @Override
        protected void paintComponent(Graphics g) {
            Graphics2D g2d = (Graphics2D)g;
            GraphicsConfig config2 = new GraphicsConfig(g).setAntialiasing(UISettings.getShadowInstance().getIdeAAType() != AntialiasingType.OFF);
            Rectangle bounds2 = this.getBounds();
            g2d.setColor(this.getBackground());
            Insets insets = this.getInsets();
            g2d.fillRect(insets.left, insets.top, bounds2.width - insets.left - insets.right, bounds2.height - insets.top - insets.bottom);
            String sizeString = String.format("%d x %d", this.myWidth, this.myHeight);
            FontMetrics fm = g2d.getFontMetrics();
            int sizeWidth = fm.stringWidth(sizeString);
            int fontHeight = fm.getHeight();
            int innerBoxWidthGap = JBUIScale.scale((int)20);
            int innerBoxHeightGap = JBUIScale.scale((int)5);
            int boxSize = JBUIScale.scale((int)15);
            int centerX = bounds2.width / 2;
            int centerY = bounds2.height / 2;
            int innerX = centerX - sizeWidth / 2 - innerBoxWidthGap;
            int innerY = centerY - fontHeight / 2 - innerBoxHeightGap;
            int innerWidth = sizeWidth + innerBoxWidthGap * 2;
            int innerHeight = fontHeight + innerBoxHeightGap * 2;
            g2d.setColor(this.getForeground());
            UiInspectorAction.drawCenteredString(g2d, fm, fontHeight, sizeString, centerX, centerY);
            g2d.setColor((Color)JBColor.GRAY);
            g2d.drawRect(innerX, innerY, innerWidth, innerHeight);
            Insets borderInsets = null;
            if (this.myBorder != null) {
                borderInsets = this.myBorder.getBorderInsets(this.myComponent);
            }
            UIUtil.drawDottedRectangle((Graphics)g2d, (int)(innerX - boxSize), (int)(innerY - boxSize), (int)(innerX + innerWidth + boxSize), (int)(innerY + innerHeight + boxSize));
            DimensionsComponent.drawInsets(g2d, fm, "border", borderInsets, boxSize, fontHeight, innerX, innerY, innerWidth, innerHeight);
            g2d.drawRect(innerX - boxSize * 2, innerY - boxSize * 2, innerWidth + boxSize * 4, innerHeight + boxSize * 4);
            DimensionsComponent.drawInsets(g2d, fm, "insets", this.myInsets, boxSize * 2, fontHeight, innerX, innerY, innerWidth, innerHeight);
            config2.restore();
        }

        private static void drawInsets(Graphics2D g2d, FontMetrics fm, String name, Insets insets, int offset, int fontHeight, int innerX, int innerY, int innerWidth, int innerHeight) {
            g2d.setColor((Color)JBColor.BLACK);
            g2d.drawString(name, innerX - offset + JBUIScale.scale((int)5), innerY - offset + fontHeight);
            g2d.setColor((Color)JBColor.GRAY);
            int outerX = innerX - offset;
            int outerWidth = innerWidth + offset * 2;
            int outerY = innerY - offset;
            int outerHeight = innerHeight + offset * 2;
            String top = insets != null ? Integer.toString(insets.top) : "-";
            String bottom = insets != null ? Integer.toString(insets.bottom) : "-";
            String left = insets != null ? Integer.toString(insets.left) : "-";
            String right = insets != null ? Integer.toString(insets.right) : "-";
            int shift = JBUIScale.scale((int)7);
            UiInspectorAction.drawCenteredString(g2d, fm, fontHeight, top, outerX + outerWidth / 2, outerY + shift);
            UiInspectorAction.drawCenteredString(g2d, fm, fontHeight, bottom, outerX + outerWidth / 2, outerY + outerHeight - shift);
            UiInspectorAction.drawCenteredString(g2d, fm, fontHeight, left, outerX + shift, outerY + outerHeight / 2);
            UiInspectorAction.drawCenteredString(g2d, fm, fontHeight, right, outerX + outerWidth - shift, outerY + outerHeight / 2);
        }

        @Override
        public Dimension getMinimumSize() {
            return JBUI.size((int)120);
        }

        @Override
        public Dimension getPreferredSize() {
            return JBUI.size((int)150);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/internal/inspector/UiInspectorAction$DimensionsComponent", "<init>"));
        }
    }

    private static final class InspectorTable
    extends JPanel
    implements DataProvider {
        InspectorTableModel myModel;
        DimensionsComponent myDimensionComponent;
        StripeTable myTable;

        private InspectorTable(@NotNull List<? extends PropertyBean> clickInfo) {
            if (clickInfo == null) {
                InspectorTable.$$$reportNull$$$0(0);
            }
            this.myModel = new InspectorTableModel(clickInfo);
            this.init(null);
        }

        private InspectorTable(@NotNull Component component2) {
            if (component2 == null) {
                InspectorTable.$$$reportNull$$$0(1);
            }
            this.myModel = new InspectorTableModel(component2);
            this.init(component2);
        }

        private void init(final @Nullable Component component2) {
            this.setLayout(new BorderLayout());
            this.myTable = new StripeTable((TableModel)this.myModel);
            new TableSpeedSearch((JTable)this.myTable);
            TableColumnModel columnModel = this.myTable.getColumnModel();
            TableColumn propertyColumn = columnModel.getColumn(0);
            propertyColumn.setMinWidth(JBUIScale.scale((int)220));
            propertyColumn.setMaxWidth(JBUIScale.scale((int)220));
            propertyColumn.setResizable(false);
            propertyColumn.setCellRenderer(new PropertyNameRenderer());
            TableColumn valueColumn = columnModel.getColumn(1);
            valueColumn.setMinWidth(JBUIScale.scale((int)200));
            valueColumn.setResizable(false);
            valueColumn.setCellRenderer(new ValueCellRenderer());
            valueColumn.setCellEditor(new DefaultCellEditor((JTextField)new JBTextField()){

                @Override
                public Component getTableCellEditorComponent(JTable table, Object value2, boolean isSelected, final int row2, int column2) {
                    Component comp = table.getCellRenderer(row2, column2).getTableCellRendererComponent(table, value2, false, false, row2, column2);
                    Object realValue = table.getModel().getValueAt(row2, column2);
                    if (comp instanceof JLabel) {
                        value2 = ((JLabel)comp).getText();
                    }
                    if (realValue instanceof Color) {
                        Rectangle cellRect = table.getCellRect(row2, column2, true);
                        ColorPicker.showColorPickerPopup(null, (Color)realValue, new ColorListener(){

                            public void colorChanged(Color color, Object source) {
                                if (component2 != null) {
                                    component2.setBackground(color);
                                    String name = myModel.myProperties.get((int)row2).propertyName;
                                    myModel.myProperties.set(row2, new PropertyBean(name, color));
                                }
                            }
                        }, new RelativePoint((Component)table, new Point(cellRect.x + JBUI.scale((int)6), cellRect.y + cellRect.height)));
                        return null;
                    }
                    Component result2 = super.getTableCellEditorComponent(table, value2, isSelected, row2, column2);
                    ((JComponent)result2).setBorder(BorderFactory.createLineBorder((Color)JBColor.GRAY, 1));
                    return result2;
                }
            });
            new DoubleClickListener(){

                protected boolean onDoubleClick(@NotNull MouseEvent event) {
                    Component renderer;
                    if (event == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    int row2 = myTable.rowAtPoint(event.getPoint());
                    int column2 = 1;
                    if (row2 >= 0 && row2 < myTable.getRowCount() && column2 < myTable.getColumnCount() && (renderer = myTable.getCellRenderer(row2, column2).getTableCellRendererComponent((JTable)myTable, myModel.getValueAt(row2, column2), false, false, row2, column2)) instanceof JLabel) {
                        StringBuilder sb = new StringBuilder();
                        if (component2 != null) {
                            sb.append(UiInspectorAction.getComponentName(component2)).append(" ");
                        }
                        String value2 = StringUtil.trimStart((String)((JLabel)renderer).getText().replace("\r", "").replace("\tat", "\n\tat"), (String)"at ");
                        sb.append("'").append(myModel.getValueAt(row2, 0)).append("':");
                        sb.append(value2.contains("\n") || value2.length() > 100 ? "\n" : " ");
                        sb.append(value2);
                        System.out.println(sb);
                        return true;
                    }
                    return false;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/internal/inspector/UiInspectorAction$InspectorTable$2", "onDoubleClick"));
                }
            }.installOn((Component)this.myTable);
            this.myTable.setAutoResizeMode(3);
            this.add((Component)new JBScrollPane((Component)this.myTable), "Center");
            if (component2 != null) {
                this.myDimensionComponent = new DimensionsComponent(component2);
                this.add((Component)this.myDimensionComponent, "South");
            }
        }

        public void refresh() {
            this.myModel.refresh();
            this.myDimensionComponent.update();
            this.myDimensionComponent.repaint();
        }

        @Override
        public Object getData(@NotNull String dataId) {
            if (dataId == null) {
                InspectorTable.$$$reportNull$$$0(2);
            }
            if (PlatformDataKeys.COPY_PROVIDER.is(dataId)) {
                return new MyInspectorTableCopyProvider();
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "clickInfo";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataId";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/internal/inspector/UiInspectorAction$InspectorTable";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getData";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        private class MyInspectorTableCopyProvider
        implements CopyProvider {
            private MyInspectorTableCopyProvider() {
            }

            public void performCopy(@NotNull DataContext dataContext) {
                if (dataContext == null) {
                    MyInspectorTableCopyProvider.$$$reportNull$$$0(0);
                }
                int[] rows = InspectorTable.this.myTable.getSelectedRows();
                StringBuilder builder2 = new StringBuilder();
                for (int row2 : rows) {
                    if (builder2.length() > 0) {
                        builder2.append('\n');
                    }
                    for (int col = 0; col < InspectorTable.this.myTable.getColumnCount(); ++col) {
                        builder2.append(this.getTextValue(row2, col));
                        if (col >= InspectorTable.this.myTable.getColumnCount() - 1) continue;
                        builder2.append("\t");
                    }
                }
                CopyPasteManager.getInstance().setContents((Transferable)new TextTransferable(builder2.toString()));
            }

            private String getTextValue(int row2, int col) {
                Object value2 = InspectorTable.this.myTable.getValueAt(row2, col);
                if (value2 instanceof String) {
                    return (String)value2;
                }
                TableColumn tableColumn = InspectorTable.this.myTable.getColumnModel().getColumn(col);
                Component component2 = tableColumn.getCellRenderer().getTableCellRendererComponent((JTable)InspectorTable.this.myTable, value2, false, false, row2, col);
                if (component2 instanceof JLabel) {
                    return ((JLabel)component2).getText();
                }
                return value2.toString();
            }

            public boolean isCopyEnabled(@NotNull DataContext dataContext) {
                if (dataContext == null) {
                    MyInspectorTableCopyProvider.$$$reportNull$$$0(1);
                }
                return true;
            }

            public boolean isCopyVisible(@NotNull DataContext dataContext) {
                if (dataContext == null) {
                    MyInspectorTableCopyProvider.$$$reportNull$$$0(2);
                }
                return InspectorTable.this.myTable.getSelectedRowCount() > 0;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "dataContext";
                objectArray2[1] = "com/intellij/internal/inspector/UiInspectorAction$InspectorTable$MyInspectorTableCopyProvider";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "performCopy";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isCopyEnabled";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isCopyVisible";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }

        private static class PropertyNameRenderer
        extends DefaultTableCellRenderer {
            private PropertyNameRenderer() {
            }

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value2, boolean isSelected, boolean hasFocus, int row2, int column2) {
                super.getTableCellRendererComponent(table, value2, isSelected, hasFocus, row2, column2);
                TableModel model2 = table.getModel();
                boolean changed2 = false;
                if (model2 instanceof InspectorTableModel) {
                    changed2 = ((InspectorTableModel)model2).myProperties.get((int)row2).changed;
                }
                Color fg = isSelected ? table.getSelectionForeground() : (changed2 ? JBUI.CurrentTheme.Link.Foreground.ENABLED : table.getForeground());
                JBFont font = JBFont.label();
                this.setFont((Font)(changed2 ? font.asBold() : font));
                this.setForeground(fg);
                return this;
            }
        }
    }

    private static final class HighlightComponent
    extends JComponent {
        @NotNull
        private final Color myColor;
        @NotNull
        private final Insets myInsets;

        private HighlightComponent(@NotNull Color c, @NotNull Insets insets) {
            if (c == null) {
                HighlightComponent.$$$reportNull$$$0(0);
            }
            if (insets == null) {
                HighlightComponent.$$$reportNull$$$0(1);
            }
            this.myColor = c;
            this.myInsets = insets;
        }

        @Override
        protected void paintComponent(Graphics g) {
            int i2;
            Graphics2D g2d = (Graphics2D)g;
            Color oldColor = g2d.getColor();
            Composite old = g2d.getComposite();
            g2d.setComposite(AlphaComposite.getInstance(3, 0.2f));
            Rectangle r = this.getBounds();
            RectanglePainter.paint((Graphics2D)g2d, (int)0, (int)0, (int)r.width, (int)r.height, (int)0, (Paint)this.myColor, null);
            ((Graphics2D)g).setPaint(this.myColor.darker());
            for (i2 = 0; i2 < this.myInsets.left; ++i2) {
                LinePainter2D.paint((Graphics2D)g2d, (double)i2, (double)this.myInsets.top, (double)i2, (double)(r.height - this.myInsets.bottom - 1));
            }
            for (i2 = 0; i2 < this.myInsets.right; ++i2) {
                LinePainter2D.paint((Graphics2D)g2d, (double)(r.width - i2 - 1), (double)this.myInsets.top, (double)(r.width - i2 - 1), (double)(r.height - this.myInsets.bottom - 1));
            }
            for (i2 = 0; i2 < this.myInsets.top; ++i2) {
                LinePainter2D.paint((Graphics2D)g2d, (double)0.0, (double)i2, (double)r.width, (double)i2);
            }
            for (i2 = 0; i2 < this.myInsets.bottom; ++i2) {
                LinePainter2D.paint((Graphics2D)g2d, (double)0.0, (double)(r.height - i2 - 1), (double)r.width, (double)(r.height - i2 - 1));
            }
            g2d.setComposite(old);
            g2d.setColor(oldColor);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "c";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "insets";
                    break;
                }
            }
            objectArray[1] = "com/intellij/internal/inspector/UiInspectorAction$HighlightComponent";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static abstract class HierarchyTree
    extends JTree
    implements TreeSelectionListener {
        final Component myComponent;

        private HierarchyTree(Component c) {
            this.myComponent = c;
            this.setModel(UiInspectorAction.buildModel(c));
            this.setCellRenderer((TreeCellRenderer)((Object)new ComponentTreeCellRenderer(c)));
            this.getSelectionModel().addTreeSelectionListener(this);
            new TreeSpeedSearch(this);
            if (c instanceof JComponent && UIUtil.getClientProperty((Object)c, CLICK_INFO) != null) {
                SwingUtilities.invokeLater(() -> this.getSelectionModel().setSelectionPath(this.getPathForRow(this.getLeadSelectionRow() + 1)));
            }
        }

        @Override
        public String convertValueToText(Object value2, boolean selected2, boolean expanded, boolean leaf, int row2, boolean hasFocus) {
            if (value2 instanceof ComponentNode) {
                Pair<Class<?>, String> pair = null;
                if (((ComponentNode)value2).myComponent != null) {
                    pair = UiInspectorAction.getClassAndFieldName(((ComponentNode)value2).myComponent);
                }
                if (pair != null) {
                    return ((Class)pair.first).getSimpleName() + "." + (String)pair.second;
                }
                return this.myComponent.getClass().getName();
            }
            return super.convertValueToText(value2, selected2, expanded, leaf, row2, hasFocus);
        }

        public void expandPath() {
            this.expandPath(false);
        }

        public void expandPath(boolean isAccessibleTree) {
            TreeUtil.expandAll((JTree)this);
            int count = this.getRowCount();
            ComponentNode node = new ComponentNode(this.myComponent, isAccessibleTree);
            for (int i2 = 0; i2 < count; ++i2) {
                TreePath row2 = this.getPathForRow(i2);
                if (!row2.getLastPathComponent().equals(node)) continue;
                this.setSelectionPath(row2);
                this.scrollPathToVisible(this.getSelectionPath());
                break;
            }
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            Object[] paths = this.getSelectionPaths();
            if (paths == null) {
                this.onComponentsChanged(Collections.emptyList());
                return;
            }
            List clickInfos = ContainerUtil.mapNotNull((Object[])paths, path2 -> {
                Object node = path2.getLastPathComponent();
                if (node instanceof ClickInfoNode) {
                    return ((ClickInfoNode)node).getInfo();
                }
                return null;
            });
            if (!clickInfos.isEmpty()) {
                this.onClickInfoChanged((List)clickInfos.get(0));
                return;
            }
            List components = ContainerUtil.mapNotNull((Object[])paths, path2 -> {
                Object node = path2.getLastPathComponent();
                if (node instanceof ComponentNode) {
                    return ((ComponentNode)node).getComponent();
                }
                return null;
            });
            this.onComponentsChanged(components);
        }

        public abstract void onClickInfoChanged(List<? extends PropertyBean> var1);

        public abstract void onComponentsChanged(List<? extends Component> var1);

        private static class ClickInfoNode
        extends DefaultMutableTreeNode {
            private final List<PropertyBean> myInfo;

            ClickInfoNode(List<PropertyBean> info2) {
                this.myInfo = info2;
            }

            @Override
            public String toString() {
                return "Clicked Info";
            }

            public List<PropertyBean> getInfo() {
                return this.myInfo;
            }

            @Override
            public boolean isLeaf() {
                return true;
            }
        }

        private static final class ComponentNode
        extends DefaultMutableTreeNode {
            private final Component myComponent;
            String myText;
            private final Accessible myAccessible;
            private final boolean isAccessibleNode;

            private ComponentNode(@NotNull Component component2, boolean isAccessibleComponent) {
                if (component2 == null) {
                    ComponentNode.$$$reportNull$$$0(0);
                }
                super(component2);
                this.myComponent = component2;
                this.myAccessible = component2 instanceof Accessible ? (Accessible)((Object)component2) : null;
                this.isAccessibleNode = isAccessibleComponent;
                this.children = ComponentNode.prepareChildren(this.myComponent, isAccessibleComponent);
            }

            private ComponentNode(@NotNull Accessible a) {
                if (a == null) {
                    ComponentNode.$$$reportNull$$$0(1);
                }
                super(a);
                this.myComponent = null;
                this.myAccessible = a;
                this.isAccessibleNode = true;
                this.children = ComponentNode.prepareChildren(a);
            }

            private static Vector<TreeNode> prepareChildren(@NotNull Accessible a) {
                if (a == null) {
                    ComponentNode.$$$reportNull$$$0(2);
                }
                Vector<TreeNode> result2 = new Vector<TreeNode>();
                AccessibleContext ac = a.getAccessibleContext();
                if (ac != null) {
                    int count = ac.getAccessibleChildrenCount();
                    for (int i2 = 0; i2 < count; ++i2) {
                        Accessible axComponent = a.getAccessibleContext().getAccessibleChild(i2);
                        if (axComponent instanceof Component) {
                            result2.add(new ComponentNode((Component)((Object)axComponent), true));
                            continue;
                        }
                        result2.add(new ComponentNode(axComponent));
                    }
                }
                return result2;
            }

            Component getComponent() {
                return this.myComponent;
            }

            private Accessible getAccessible() {
                return this.myAccessible;
            }

            private boolean isAccessibleNode() {
                return this.isAccessibleNode;
            }

            @Override
            public String toString() {
                if (this.myComponent != null) {
                    return this.myText != null ? this.myText : this.myComponent.getClass().getName();
                }
                return Objects.requireNonNullElseGet(this.myText, () -> this.myAccessible.getClass().getName());
            }

            public void setText(String value2) {
                this.myText = value2;
            }

            public boolean equals(Object obj2) {
                return obj2 instanceof ComponentNode && ((ComponentNode)obj2).getComponent() == this.getComponent();
            }

            private static Vector<TreeNode> prepareChildren(Component parent, boolean isAccessibleComponent) {
                Component[] o;
                Vector<TreeNode> result2 = new Vector<TreeNode>();
                if (isAccessibleComponent) {
                    if (parent instanceof Accessible) {
                        for (int i2 = 0; i2 < parent.getAccessibleContext().getAccessibleChildrenCount(); ++i2) {
                            Accessible axComponent = parent.getAccessibleContext().getAccessibleChild(i2);
                            if (axComponent instanceof Component) {
                                result2.add(new ComponentNode((Component)((Object)axComponent), true));
                                continue;
                            }
                            result2.add(new ComponentNode(axComponent));
                        }
                    }
                    return result2;
                }
                if (parent instanceof JComponent && (o = (Component[])UIUtil.getClientProperty((Object)parent, CLICK_INFO)) != null) {
                    result2.add(new ClickInfoNode((List<PropertyBean>)o));
                }
                if (parent instanceof Container) {
                    for (Component component2 : ((Container)parent).getComponents()) {
                        result2.add(new ComponentNode(component2, false));
                    }
                }
                if (parent instanceof Window) {
                    Window[] children2;
                    for (Window child2 : children2 = ((Window)parent).getOwnedWindows()) {
                        if (child2 instanceof InspectorWindow) continue;
                        result2.add(new ComponentNode(child2, false));
                    }
                }
                return result2;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "component";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "a";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/internal/inspector/UiInspectorAction$HierarchyTree$ComponentNode";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "<init>";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "prepareChildren";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
    }

    private static class ComponentTreeCellRenderer
    extends ColoredTreeCellRenderer {
        private final Component myInitialSelection;

        ComponentTreeCellRenderer(Component initialSelection) {
            this.myInitialSelection = initialSelection;
            this.setFont((Font)JBUI.Fonts.label((float)11.0f));
            this.setBorder((Border)JBUI.Borders.empty((int)0, (int)3));
        }

        public void customizeCellRenderer(@NotNull JTree tree, Object value2, boolean selected2, boolean expanded, boolean leaf, int row2, boolean hasFocus) {
            Color background;
            if (tree == null) {
                ComponentTreeCellRenderer.$$$reportNull$$$0(0);
            }
            Color foreground = UIUtil.getTreeForeground((boolean)selected2, (boolean)hasFocus);
            Color color = background = selected2 ? UIUtil.getTreeSelectionBackground((boolean)hasFocus) : null;
            if (value2 instanceof HierarchyTree.ComponentNode) {
                HierarchyTree.ComponentNode componentNode = (HierarchyTree.ComponentNode)value2;
                Component component2 = componentNode.getComponent();
                if (component2 != null && !selected2) {
                    if (!component2.isVisible()) {
                        foreground = JBColor.GRAY;
                    } else if (component2.getWidth() == 0 || component2.getHeight() == 0) {
                        foreground = new JBColor(new Color(128, 10, 0), (Color)JBColor.BLUE);
                    } else if (component2.getPreferredSize() != null && (component2.getSize().width < component2.getPreferredSize().width || component2.getSize().height < component2.getPreferredSize().height)) {
                        foreground = PlatformColors.BLUE;
                    }
                    if (this.myInitialSelection == componentNode.getComponent()) {
                        background = new Color(31, 128, 8, 58);
                    }
                }
                if (componentNode.isAccessibleNode) {
                    AccessibleContext ac = component2 != null ? component2.getAccessibleContext() : componentNode.getAccessible().getAccessibleContext();
                    String simpleName = ac.getClass().getSimpleName();
                    if (StringUtil.isEmpty((String)simpleName)) {
                        this.append(ac.getClass().getName());
                    } else {
                        this.append(simpleName);
                    }
                    String axName = ac.getAccessibleName();
                    if (axName != null) {
                        this.append(" " + axName);
                    }
                } else {
                    this.append(UiInspectorAction.getComponentName(component2));
                    Pair<Class<?>, String> class2field = UiInspectorAction.getClassAndFieldName(component2);
                    if (class2field != null) {
                        this.append("(" + (String)class2field.second + "@" + ((Class)class2field.first).getSimpleName() + ")");
                    }
                    this.append(": " + RectangleRenderer.toString(component2.getBounds()), SimpleTextAttributes.GRAYED_ATTRIBUTES);
                    if (component2.isOpaque()) {
                        this.append(", opaque", SimpleTextAttributes.GRAYED_ATTRIBUTES);
                    }
                    if (component2.isDoubleBuffered()) {
                        this.append(", double-buffered", SimpleTextAttributes.GRAYED_ATTRIBUTES);
                    }
                    if (DataManagerImpl.getDataProviderEx(component2) != null) {
                        this.append(", ", SimpleTextAttributes.GRAYED_ATTRIBUTES);
                        this.append("data-provider", SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
                    }
                    componentNode.setText(this.toString());
                    this.setIcon(UiInspectorIcons.findIconFor(component2));
                }
            }
            if (value2 instanceof HierarchyTree.ClickInfoNode) {
                this.append(value2.toString());
                this.setIcon(AllIcons.Ide.Rating);
            }
            this.setForeground(foreground);
            this.setBackground(background);
            SpeedSearchUtil.applySpeedSearchHighlighting((JComponent)tree, (SimpleColoredComponent)this, (boolean)false, (boolean)selected2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/internal/inspector/UiInspectorAction$ComponentTreeCellRenderer", "customizeCellRenderer"));
        }
    }

    private static final class InspectorWindow
    extends JDialog
    implements Disposable {
        private InspectorTable myInspectorTable;
        @NotNull
        private final List<Component> myComponents;
        private List<? extends PropertyBean> myInfo;
        @NotNull
        private final Component myInitialComponent;
        @NotNull
        private final List<HighlightComponent> myHighlightComponents;
        private boolean myIsHighlighted;
        @NotNull
        private final HierarchyTree myHierarchyTree;
        @NotNull
        private final Wrapper myWrapperPanel;
        @Nullable
        private final Project myProject;
        private final UiInspector myInspector;

        private InspectorWindow(@Nullable Project project, @NotNull Component component2, UiInspector inspector) throws HeadlessException {
            if (component2 == null) {
                InspectorWindow.$$$reportNull$$$0(0);
            }
            super(InspectorWindow.findWindow(component2));
            this.myComponents = new ArrayList<Component>();
            this.myHighlightComponents = new ArrayList<HighlightComponent>();
            this.myIsHighlighted = true;
            this.myProject = project;
            this.myInspector = inspector;
            Window window = InspectorWindow.findWindow(component2);
            this.setModal(window instanceof JDialog && ((JDialog)window).isModal());
            this.myComponents.add(component2);
            this.myInitialComponent = component2;
            this.getRootPane().setBorder(JBUI.Borders.empty((int)5));
            this.setDefaultCloseOperation(2);
            this.setLayout(new BorderLayout());
            this.setTitle(component2.getClass().getName());
            Dimension size = DimensionService.getInstance().getSize(InspectorWindow.getDimensionServiceKey(), null);
            Point location = DimensionService.getInstance().getLocation(InspectorWindow.getDimensionServiceKey(), null);
            if (size != null) {
                this.setSize(size);
            }
            if (location != null) {
                this.setLocation(location);
            }
            DefaultActionGroup actions2 = new DefaultActionGroup();
            actions2.addAction((AnAction)new MyTextAction(IdeBundle.messagePointer((String)"action.Anonymous.text.highlight", (Object[])new Object[0])){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    if (e == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    myIsHighlighted = !myIsHighlighted;
                    this.updateHighlighting();
                }

                public void update(@NotNull AnActionEvent e) {
                    if (e == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    e.getPresentation().setEnabled(myInfo != null || !myComponents.isEmpty());
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    objectArray2[0] = "e";
                    objectArray2[1] = "com/intellij/internal/inspector/UiInspectorAction$InspectorWindow$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "actionPerformed";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "update";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
            actions2.addSeparator();
            actions2.add((AnAction)new MyTextAction(InternalActionsBundle.messagePointer("action.Anonymous.text.refresh", new Object[0])){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    if (e == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    this.getCurrentTable().refresh();
                }

                public void update(@NotNull AnActionEvent e) {
                    if (e == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    e.getPresentation().setEnabled(!myComponents.isEmpty());
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    objectArray2[0] = "e";
                    objectArray2[1] = "com/intellij/internal/inspector/UiInspectorAction$InspectorWindow$2";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "actionPerformed";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "update";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
            actions2.addSeparator();
            actions2.add((AnAction)new MyTextAction(InternalActionsBundle.messagePointer("action.Anonymous.text.Accessible", new Object[0])){
                private boolean isAccessibleEnable;
                {
                    super(text2);
                    this.isAccessibleEnable = false;
                }

                public void actionPerformed(@NotNull AnActionEvent e) {
                    if (e == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    this.switchHierarchy();
                }

                public void update(@NotNull AnActionEvent e) {
                    if (e == null) {
                        3.$$$reportNull$$$0(1);
                    }
                    e.getPresentation().setText(this.isAccessibleEnable ? InternalActionsBundle.message("action.Anonymous.text.Visible", new Object[0]) : InternalActionsBundle.message("action.Anonymous.text.Accessible", new Object[0]));
                }

                private void switchHierarchy() {
                    Object node;
                    TreePath path2 = myHierarchyTree.getLeadSelectionPath();
                    Object object = node = path2 == null ? null : path2.getLastPathComponent();
                    if (node == null) {
                        return;
                    }
                    Component c = ((HierarchyTree.ComponentNode)node).getComponent();
                    if (c != null) {
                        this.isAccessibleEnable = !this.isAccessibleEnable;
                        myHierarchyTree.setModel(UiInspectorAction.buildModel(c, this.isAccessibleEnable));
                        myHierarchyTree.expandPath(this.isAccessibleEnable);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    objectArray2[0] = "e";
                    objectArray2[1] = "com/intellij/internal/inspector/UiInspectorAction$InspectorWindow$3";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "actionPerformed";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "update";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
            ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("ContextToolbar", (ActionGroup)actions2, true);
            toolbar.setTargetComponent((JComponent)this.getRootPane());
            this.add((Component)toolbar.getComponent(), "North");
            this.myWrapperPanel = new Wrapper();
            this.myInspectorTable = new InspectorTable(component2);
            this.myHierarchyTree = new HierarchyTree(component2){

                @Override
                public void onComponentsChanged(List<? extends Component> components) {
                    this.switchComponentsInfo(components);
                    this.updateHighlighting();
                }

                @Override
                public void onClickInfoChanged(List<? extends PropertyBean> info2) {
                    this.switchClickInfo(info2);
                    this.updateHighlighting();
                }
            };
            DataProvider provider2 = dataId -> {
                if (CommonDataKeys.NAVIGATABLE.is(dataId)) {
                    return new Navigatable(){

                        public void navigate(boolean requestFocus) {
                            if (myHierarchyTree.hasFocus()) {
                                this.openClass(myComponents.get(0).getClass().getName(), requestFocus);
                            } else if (myInspectorTable.myTable.hasFocus()) {
                                int row2 = myInspectorTable.myTable.getSelectedRow();
                                Object at = myInspectorTable.myModel.getValueAt(row2, 1);
                                this.openClass(String.valueOf(at), requestFocus);
                            }
                        }

                        public boolean canNavigate() {
                            return true;
                        }

                        public boolean canNavigateToSource() {
                            return true;
                        }
                    };
                }
                return null;
            };
            this.myWrapperPanel.setContent((JComponent)this.myInspectorTable);
            JBSplitter splitPane = new JBSplitter(false, "UiInspector.splitter.proportion", 0.5f);
            splitPane.setSecondComponent((JComponent)this.myWrapperPanel);
            splitPane.setFirstComponent((JComponent)new JBScrollPane((Component)this.myHierarchyTree));
            this.add((Component)splitPane, "Center");
            DataManager.registerDataProvider((JComponent)splitPane, (DataProvider)provider2);
            this.myHierarchyTree.expandPath();
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    this.close();
                }
            });
            this.getRootPane().getActionMap().put("CLOSE", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.close();
                }
            });
            this.updateHighlighting();
            this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), "CLOSE");
        }

        private void openClass(String fqn, boolean requestFocus) {
            if (this.myProject != null) {
                try {
                    String javaPsiFacadeFqn = "com.intellij.psi.JavaPsiFacade";
                    PluginId pluginId = PluginManager.getPluginByClassName(javaPsiFacadeFqn);
                    Class<?> facade = null;
                    if (pluginId != null) {
                        IdeaPluginDescriptor plugin2 = PluginManager.getInstance().findEnabledPlugin(pluginId);
                        if (plugin2 != null) {
                            facade = Class.forName(javaPsiFacadeFqn, false, plugin2.getPluginClassLoader());
                        }
                    } else {
                        facade = Class.forName(javaPsiFacadeFqn);
                    }
                    if (facade != null) {
                        Method getInstance = facade.getDeclaredMethod("getInstance", Project.class);
                        Method findClass = facade.getDeclaredMethod("findClass", String.class, GlobalSearchScope.class);
                        Object result2 = findClass.invoke(getInstance.invoke(null, this.myProject), fqn, GlobalSearchScope.allScope((Project)this.myProject));
                        if (result2 instanceof PsiElement) {
                            PsiNavigateUtil.navigate((PsiElement)((PsiElement)result2), (boolean)requestFocus);
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        private static String getDimensionServiceKey() {
            return "UiInspectorWindow";
        }

        private static Window findWindow(Component component2) {
            DialogWrapper dialogWrapper2 = DialogWrapper.findInstance((Component)component2);
            if (dialogWrapper2 != null) {
                return dialogWrapper2.getPeer().getWindow();
            }
            return null;
        }

        private InspectorTable getCurrentTable() {
            return this.myInspectorTable;
        }

        private void switchComponentsInfo(@NotNull List<? extends Component> components) {
            if (components == null) {
                InspectorWindow.$$$reportNull$$$0(1);
            }
            if (components.isEmpty()) {
                return;
            }
            this.myComponents.clear();
            this.myComponents.addAll(components);
            this.myInfo = null;
            this.setTitle(components.get(0).getClass().getName());
            this.myInspectorTable = new InspectorTable(components.get(0));
            this.myWrapperPanel.setContent((JComponent)this.myInspectorTable);
        }

        private void switchClickInfo(@NotNull List<? extends PropertyBean> clickInfo) {
            if (clickInfo == null) {
                InspectorWindow.$$$reportNull$$$0(2);
            }
            this.myComponents.clear();
            this.myInfo = clickInfo;
            this.setTitle("Click Info");
            this.myInspectorTable = new InspectorTable(clickInfo);
            this.myWrapperPanel.setContent((JComponent)this.myInspectorTable);
        }

        @Override
        public void dispose() {
            DimensionService.getInstance().setSize(InspectorWindow.getDimensionServiceKey(), this.getSize(), null);
            DimensionService.getInstance().setLocation(InspectorWindow.getDimensionServiceKey(), this.getLocation(), null);
            super.dispose();
            DialogWrapper.cleanupRootPane((JRootPane)this.rootPane);
            DialogWrapper.cleanupWindowListeners((Window)this);
            Disposer.dispose((Disposable)this);
        }

        public void close() {
            if (this.myInitialComponent instanceof JComponent) {
                UIUtil.putClientProperty((JComponent)((JComponent)this.myInitialComponent), CLICK_INFO, null);
            }
            this.myIsHighlighted = false;
            this.myInfo = null;
            this.myComponents.clear();
            this.updateHighlighting();
            this.setVisible(false);
            Disposer.dispose((Disposable)this);
        }

        private void updateHighlighting() {
            for (HighlightComponent highlightComponent : this.myHighlightComponents) {
                JComponent jComponent = InspectorWindow.getGlassPane(highlightComponent);
                if (jComponent == null) continue;
                jComponent.remove(highlightComponent);
                jComponent.revalidate();
                jComponent.repaint();
            }
            this.myHighlightComponents.clear();
            if (this.myIsHighlighted) {
                for (Component component2 : this.myComponents) {
                    ContainerUtil.addIfNotNull(this.myHighlightComponents, (Object)InspectorWindow.createHighlighter(component2, null));
                }
                if (this.myInfo != null) {
                    Rectangle bounds2 = null;
                    for (PropertyBean propertyBean : this.myInfo) {
                        if (!UiInspectorAction.RENDERER_BOUNDS.equals(propertyBean.propertyName)) continue;
                        bounds2 = (Rectangle)propertyBean.propertyValue;
                        break;
                    }
                    ContainerUtil.addIfNotNull(this.myHighlightComponents, (Object)InspectorWindow.createHighlighter(this.myInitialComponent, bounds2));
                }
            }
        }

        @Nullable
        private static HighlightComponent createHighlighter(@NotNull Component component2, @Nullable Rectangle bounds2) {
            JComponent glassPane;
            if (component2 == null) {
                InspectorWindow.$$$reportNull$$$0(3);
            }
            if ((glassPane = InspectorWindow.getGlassPane(component2)) == null) {
                return null;
            }
            if (bounds2 != null) {
                bounds2 = SwingUtilities.convertRectangle(component2, bounds2, glassPane);
            } else {
                Point pt = SwingUtilities.convertPoint(component2, new Point(0, 0), glassPane);
                bounds2 = new Rectangle(pt.x, pt.y, component2.getWidth(), component2.getHeight());
            }
            JBColor color = new JBColor((Color)JBColor.GREEN, (Color)JBColor.RED);
            if (bounds2.width == 0 || bounds2.height == 0) {
                bounds2.width = Math.max(bounds2.width, 1);
                bounds2.height = Math.max(bounds2.height, 1);
                color = JBColor.BLUE;
            }
            JBInsets insets = component2 instanceof JComponent ? ((JComponent)component2).getInsets() : JBUI.emptyInsets();
            HighlightComponent highlightComponent = new HighlightComponent((Color)color, (Insets)insets);
            highlightComponent.setBounds(bounds2);
            glassPane.add(highlightComponent);
            glassPane.revalidate();
            glassPane.repaint();
            return highlightComponent;
        }

        @Nullable
        private static JComponent getGlassPane(@NotNull Component component2) {
            JRootPane rootPane;
            if (component2 == null) {
                InspectorWindow.$$$reportNull$$$0(4);
            }
            return (rootPane = SwingUtilities.getRootPane(component2)) == null ? null : (JComponent)rootPane.getGlassPane();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "components";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "clickInfo";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/internal/inspector/UiInspectorAction$InspectorWindow";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "switchComponentsInfo";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "switchClickInfo";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createHighlighter";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getGlassPane";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        private static abstract class MyTextAction
        extends IconWithTextAction
        implements DumbAware {
            private MyTextAction(Supplier<String> text2) {
                super(text2);
            }
        }
    }
}

