/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal;

import com.intellij.application.options.CodeStyle;
import com.intellij.formatting.Block;
import com.intellij.formatting.CoreFormatterUtil;
import com.intellij.formatting.FormattingMode;
import com.intellij.formatting.FormattingModel;
import com.intellij.formatting.FormattingModelBuilder;
import com.intellij.formatting.FormattingModelDumper;
import com.intellij.idea.ActionsBundle;
import com.intellij.lang.LanguageFormatting;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.io.File;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class DumpFormattingModelAction
extends AnAction
implements DumbAware {
    private static final Logger LOG = Logger.getInstance(DumpFormattingModelAction.class);

    public DumpFormattingModelAction() {
        super(ActionsBundle.messagePointer((String)"action.DumpFormattingModelAction.text", (Object[])new Object[0]));
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        VirtualFile file2;
        if (e == null) {
            DumpFormattingModelAction.$$$reportNull$$$0(0);
        }
        PsiFile psiFile = (PsiFile)e.getData(CommonDataKeys.PSI_FILE);
        Project project = e.getProject();
        if (project == null || psiFile == null) {
            return;
        }
        StringBuilder output2 = new StringBuilder();
        DumpFormattingModelAction.dumpModelForFile(psiFile, output2, psiFile.getTextRange());
        InjectedLanguageManager injectedLanguageManager = InjectedLanguageManager.getInstance((Project)project);
        List injectedFiles = injectedLanguageManager.getCachedInjectedDocumentsInRange(psiFile, psiFile.getTextRange()).stream().map(documentWindow -> PsiDocumentManager.getInstance((Project)project).getPsiFile((Document)documentWindow)).filter(psi -> psi != null).sorted(Comparator.comparingInt(psi -> injectedLanguageManager.injectedToHost((PsiElement)psi, psi.getTextRange()).getStartOffset())).collect(Collectors.toList());
        for (PsiFile injectedFile : injectedFiles) {
            DumpFormattingModelAction.dumpModelForFile(injectedFile, output2, injectedLanguageManager.injectedToHost((PsiElement)injectedFile, injectedFile.getTextRange()));
        }
        try {
            File tempFile = FileUtil.createTempFile((String)("formattingModel-" + psiFile.getName() + "-"), (String)".txt");
            FileUtil.writeToFile((File)tempFile, (String)output2.toString());
            file2 = LocalFileSystem.getInstance().findFileByIoFile(tempFile);
            if (file2 == null) {
                return;
            }
        }
        catch (Exception exception) {
            LOG.error((Throwable)exception);
            return;
        }
        OpenFileDescriptor fileDescriptor = new OpenFileDescriptor(project, file2);
        FileEditorManager.getInstance((Project)project).openEditor(fileDescriptor, true);
    }

    private static void dumpModelForFile(@NotNull PsiFile psiFile, @NotNull StringBuilder output2, @NotNull TextRange hostTextRange) {
        FormattingModelBuilder builder2;
        if (psiFile == null) {
            DumpFormattingModelAction.$$$reportNull$$$0(1);
        }
        if (output2 == null) {
            DumpFormattingModelAction.$$$reportNull$$$0(2);
        }
        if (hostTextRange == null) {
            DumpFormattingModelAction.$$$reportNull$$$0(3);
        }
        if ((builder2 = LanguageFormatting.INSTANCE.forContext((PsiElement)psiFile)) == null) {
            LOG.warn("no formatting model found for file: " + psiFile.getName());
            return;
        }
        output2.append("> ");
        output2.append(hostTextRange);
        output2.append("\n");
        FormattingModel model2 = CoreFormatterUtil.buildModel(builder2, (PsiElement)psiFile, CodeStyle.getSettings((PsiFile)psiFile), FormattingMode.REFORMAT);
        FormattingModelDumper.dumpFormattingModel((Block)model2.getRootBlock(), (int)0, (StringBuilder)output2);
        output2.append("\n\n");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "output";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hostTextRange";
                break;
            }
        }
        objectArray2[1] = "com/intellij/internal/DumpFormattingModelAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "dumpModelForFile";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

