/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.treeView.smartTree;

import com.intellij.ide.structureView.impl.StructureViewElementWrapper;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.smartTree.Filter;
import com.intellij.ide.util.treeView.smartTree.Group;
import com.intellij.ide.util.treeView.smartTree.GroupWrapper;
import com.intellij.ide.util.treeView.smartTree.Grouper;
import com.intellij.ide.util.treeView.smartTree.Sorter;
import com.intellij.ide.util.treeView.smartTree.TreeElement;
import com.intellij.ide.util.treeView.smartTree.TreeElementWrapper;
import com.intellij.ide.util.treeView.smartTree.TreeModel;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.pom.Navigatable;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public abstract class CachingChildrenTreeNode<Value>
extends AbstractTreeNode<Value> {
    private static final Logger LOG = Logger.getInstance(CachingChildrenTreeNode.class);
    private List<CachingChildrenTreeNode<?>> myChildren;
    private List<CachingChildrenTreeNode<?>> myOldChildren;
    @NotNull
    protected final TreeModel myTreeModel;

    CachingChildrenTreeNode(Project project, @NotNull Value value2, @NotNull TreeModel treeModel) {
        if (value2 == null) {
            CachingChildrenTreeNode.$$$reportNull$$$0(0);
        }
        if (treeModel == null) {
            CachingChildrenTreeNode.$$$reportNull$$$0(1);
        }
        super(project, value2 instanceof StructureViewElementWrapper ? ((StructureViewElementWrapper)value2).getWrappedElement() : value2);
        this.myTreeModel = treeModel;
    }

    @NotNull
    public Collection<AbstractTreeNode<?>> getChildren() {
        this.ensureChildrenAreInitialized();
        return new ArrayList(this.myChildren);
    }

    private void ensureChildrenAreInitialized() {
        if (this.myChildren == null) {
            try {
                this.myChildren = new ArrayList();
                this.rebuildSubtree();
            }
            catch (ProcessCanceledException | IndexNotReadyException pce) {
                this.myChildren = null;
                throw pce;
            }
        }
    }

    void addSubElement(@NotNull CachingChildrenTreeNode node) {
        JBIterable parents2;
        if (node == null) {
            CachingChildrenTreeNode.$$$reportNull$$$0(2);
        }
        if ((parents2 = JBIterable.generate((Object)((Object)this), o -> o.getParent())).map(o -> o.getValue()).contains(node.getValue())) {
            return;
        }
        this.ensureChildrenAreInitialized();
        this.myChildren.add(node);
        node.setParent(this);
    }

    protected void setChildren(@NotNull Collection<? extends AbstractTreeNode<?>> children2) {
        if (children2 == null) {
            CachingChildrenTreeNode.$$$reportNull$$$0(3);
        }
        this.clearChildren();
        for (AbstractTreeNode<?> node : children2) {
            this.myChildren.add((CachingChildrenTreeNode)node);
            node.setParent((AbstractTreeNode)this);
        }
    }

    protected void sortChildren(Sorter @NotNull [] sorters) {
        if (sorters == null) {
            CachingChildrenTreeNode.$$$reportNull$$$0(4);
        }
        if (this.myChildren == null) {
            return;
        }
        this.myChildren.sort(new CompositeComparator(sorters));
        for (CachingChildrenTreeNode<?> child2 : this.myChildren) {
            if (!(child2 instanceof GroupWrapper)) continue;
            child2.sortChildren(sorters);
        }
    }

    protected void filterChildren(Filter @NotNull [] filters) {
        if (filters == null) {
            CachingChildrenTreeNode.$$$reportNull$$$0(5);
        }
        Collection<AbstractTreeNode<?>> children2 = this.getChildren();
        for (Filter filter : filters) {
            Iterator<AbstractTreeNode<?>> eachNode = children2.iterator();
            while (eachNode.hasNext()) {
                AbstractTreeNode<?> eachChild = eachNode.next();
                Object value2 = eachChild.getValue();
                if (value2 instanceof TreeElement && filter.isVisible((TreeElement)value2)) continue;
                eachNode.remove();
            }
        }
        this.setChildren(children2);
    }

    void groupChildren(Grouper @NotNull [] groupers) {
        if (groupers == null) {
            CachingChildrenTreeNode.$$$reportNull$$$0(6);
        }
        for (Grouper grouper : groupers) {
            this.groupElements(grouper);
        }
        Collection<AbstractTreeNode<?>> children2 = this.getChildren();
        for (AbstractTreeNode<?> child2 : children2) {
            if (!(child2 instanceof GroupWrapper)) continue;
            ((GroupWrapper)child2).groupChildren(groupers);
        }
    }

    private void groupElements(@NotNull Grouper grouper) {
        if (grouper == null) {
            CachingChildrenTreeNode.$$$reportNull$$$0(7);
        }
        ArrayList ungrouped = new ArrayList();
        Collection<AbstractTreeNode<?>> children2 = this.getChildren();
        for (AbstractTreeNode<?> child2 : children2) {
            if (!(child2 instanceof TreeElementWrapper)) continue;
            ungrouped.add(child2);
        }
        if (!ungrouped.isEmpty()) {
            this.processUngrouped(ungrouped, grouper);
        }
        LinkedHashSet<Object> result2 = new LinkedHashSet<Object>();
        for (AbstractTreeNode<?> child3 : children2) {
            AbstractTreeNode parent = child3.getParent();
            if (parent != this) {
                if (result2.contains(parent)) continue;
                result2.add(parent);
                continue;
            }
            result2.add(child3);
        }
        this.setChildren(result2);
    }

    private void processUngrouped(@NotNull List<? extends AbstractTreeNode<TreeElement>> ungrouped, @NotNull Grouper grouper) {
        if (ungrouped == null) {
            CachingChildrenTreeNode.$$$reportNull$$$0(8);
        }
        if (grouper == null) {
            CachingChildrenTreeNode.$$$reportNull$$$0(9);
        }
        Map<TreeElement, AbstractTreeNode> ungroupedObjects = CachingChildrenTreeNode.collectValues(ungrouped);
        Collection groups2 = grouper.group((AbstractTreeNode)this, ungroupedObjects.keySet());
        Map<Group, GroupWrapper> groupNodes = this.createGroupNodes(groups2);
        for (Group group2 : groups2) {
            if (group2 == null) {
                LOG.error(grouper + " returned null group: " + groups2);
            }
            GroupWrapper groupWrapper = groupNodes.get(group2);
            Collection children2 = group2.getChildren();
            for (TreeElement node : children2) {
                if (node == null) {
                    LOG.error(group2 + " returned null child: " + children2);
                }
                TreeElementWrapper child2 = this.createChildNode(node);
                groupWrapper.addSubElement(child2);
                AbstractTreeNode abstractTreeNode = ungroupedObjects.get(node);
                abstractTreeNode.setParent((AbstractTreeNode)groupWrapper);
            }
        }
    }

    @NotNull
    protected TreeElementWrapper createChildNode(@NotNull TreeElement child2) {
        if (child2 == null) {
            CachingChildrenTreeNode.$$$reportNull$$$0(10);
        }
        return new TreeElementWrapper(this.getProject(), child2, this.myTreeModel);
    }

    @NotNull
    private static Map<TreeElement, AbstractTreeNode> collectValues(@NotNull List<? extends AbstractTreeNode<TreeElement>> ungrouped) {
        if (ungrouped == null) {
            CachingChildrenTreeNode.$$$reportNull$$$0(11);
        }
        LinkedHashMap<TreeElement, AbstractTreeNode> objects = new LinkedHashMap<TreeElement, AbstractTreeNode>();
        for (AbstractTreeNode<TreeElement> abstractTreeNode : ungrouped) {
            objects.put((TreeElement)abstractTreeNode.getValue(), abstractTreeNode);
        }
        LinkedHashMap<TreeElement, AbstractTreeNode> linkedHashMap = objects;
        if (linkedHashMap == null) {
            CachingChildrenTreeNode.$$$reportNull$$$0(12);
        }
        return linkedHashMap;
    }

    @NotNull
    private Map<Group, GroupWrapper> createGroupNodes(@NotNull Collection<? extends Group> groups2) {
        if (groups2 == null) {
            CachingChildrenTreeNode.$$$reportNull$$$0(13);
        }
        Map result2 = CollectionFactory.createSmallMemoryFootprintMap((int)groups2.size());
        for (Group group2 : groups2) {
            result2.put(group2, this.createGroupWrapper(this.getProject(), group2, this.myTreeModel));
        }
        Map map2 = result2;
        if (map2 == null) {
            CachingChildrenTreeNode.$$$reportNull$$$0(14);
        }
        return map2;
    }

    @NotNull
    protected GroupWrapper createGroupWrapper(Project project, @NotNull Group group2, @NotNull TreeModel treeModel) {
        if (group2 == null) {
            CachingChildrenTreeNode.$$$reportNull$$$0(15);
        }
        if (treeModel == null) {
            CachingChildrenTreeNode.$$$reportNull$$$0(16);
        }
        return new GroupWrapper(project, group2, treeModel);
    }

    private void rebuildSubtree() {
        this.initChildren();
        this.performTreeActions();
        this.synchronizeChildren();
    }

    void synchronizeChildren() {
        List<CachingChildrenTreeNode<?>> children2 = this.myChildren;
        if (this.myOldChildren != null && children2 != null) {
            HashMap oldValuesToChildrenMap = new HashMap();
            for (CachingChildrenTreeNode<?> oldChild : this.myOldChildren) {
                Object oldValue = oldChild instanceof TreeElementWrapper ? oldChild.getValue() : oldChild;
                if (oldValue == null) continue;
                oldValuesToChildrenMap.put((CachingChildrenTreeNode<?>)((Object)oldValue), oldChild);
            }
            for (int i2 = 0; i2 < children2.size(); ++i2) {
                CachingChildrenTreeNode oldChild;
                Object newValue2;
                CachingChildrenTreeNode<?> newChild = children2.get(i2);
                Object object = newValue2 = newChild instanceof TreeElementWrapper ? newChild.getValue() : newChild;
                if (newValue2 == null || (oldChild = (CachingChildrenTreeNode)((Object)oldValuesToChildrenMap.get(newValue2))) == null) continue;
                oldChild.copyFromNewInstance(newChild);
                oldChild.setValue(newChild.getValue());
                children2.set(i2, oldChild);
            }
            this.myOldChildren = null;
        }
    }

    protected abstract void copyFromNewInstance(@NotNull CachingChildrenTreeNode var1);

    protected abstract void performTreeActions();

    protected abstract void initChildren();

    public void navigate(boolean requestFocus) {
        ((Navigatable)this.getValue()).navigate(requestFocus);
    }

    public boolean canNavigate() {
        return this.getValue() instanceof Navigatable && ((Navigatable)this.getValue()).canNavigate();
    }

    public boolean canNavigateToSource() {
        return this.getValue() instanceof Navigatable && ((Navigatable)this.getValue()).canNavigateToSource();
    }

    protected void clearChildren() {
        if (this.myChildren != null) {
            this.myChildren.clear();
        } else {
            this.myChildren = new ArrayList();
        }
    }

    void rebuildChildren() {
        if (this.myChildren != null) {
            this.myOldChildren = this.myChildren;
            for (CachingChildrenTreeNode<?> node : this.myChildren) {
                node.rebuildChildren();
            }
            this.myChildren = null;
        }
    }

    protected void resetChildren() {
        this.myChildren = null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 12: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 12: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 1: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "treeModel";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "children";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sorters";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filters";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupers";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grouper";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ungrouped";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/util/treeView/smartTree/CachingChildrenTreeNode";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groups";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/util/treeView/smartTree/CachingChildrenTreeNode";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "collectValues";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createGroupNodes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addSubElement";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setChildren";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "sortChildren";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "filterChildren";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "groupChildren";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "groupElements";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "processUngrouped";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createChildNode";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "collectValues";
                break;
            }
            case 12: 
            case 14: {
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createGroupNodes";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "createGroupWrapper";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 12: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class CompositeComparator
    implements Comparator<CachingChildrenTreeNode> {
        private final Sorter[] mySorters;

        CompositeComparator(Sorter @NotNull [] sorters) {
            if (sorters == null) {
                CompositeComparator.$$$reportNull$$$0(0);
            }
            this.mySorters = sorters;
        }

        @Override
        public int compare(CachingChildrenTreeNode o1, CachingChildrenTreeNode o2) {
            Object value1 = o1.getValue();
            Object value2 = o2.getValue();
            for (Sorter sorter : this.mySorters) {
                int result2 = sorter.getComparator().compare(value1, value2);
                if (result2 == 0) continue;
                return result2;
            }
            return 0;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sorters", "com/intellij/ide/util/treeView/smartTree/CachingChildrenTreeNode$CompositeComparator", "<init>"));
        }
    }
}

