/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.scopeChooser;

import com.intellij.DynamicBundle;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.impl.FlattenModulesToggleAction;
import com.intellij.ide.projectView.impl.nodes.ProjectViewDirectoryHelper;
import com.intellij.ide.util.scopeChooser.FlattenPackagesAction;
import com.intellij.ide.util.scopeChooser.ShowFilesAction;
import com.intellij.ide.util.scopeChooser.ShowModuleGroupsAction;
import com.intellij.ide.util.scopeChooser.ShowModulesAction;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.ex.ComboBoxAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packageDependencies.DependencyUISettings;
import com.intellij.packageDependencies.ui.FileTreeModelBuilder;
import com.intellij.packageDependencies.ui.Marker;
import com.intellij.packageDependencies.ui.PackageDependenciesNode;
import com.intellij.packageDependencies.ui.PackageTreeExpansionMonitor;
import com.intellij.packageDependencies.ui.PanelProgressIndicator;
import com.intellij.packageDependencies.ui.PatternDialectProvider;
import com.intellij.packageDependencies.ui.RootNode;
import com.intellij.packageDependencies.ui.TreeExpansionMonitor;
import com.intellij.packageDependencies.ui.TreeModel;
import com.intellij.psi.search.scope.packageSet.ComplementPackageSet;
import com.intellij.psi.search.scope.packageSet.CompoundPackageSet;
import com.intellij.psi.search.scope.packageSet.IntersectionPackageSet;
import com.intellij.psi.search.scope.packageSet.InvalidPackageSet;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.psi.search.scope.packageSet.PackageSet;
import com.intellij.psi.search.scope.packageSet.PackageSetBase;
import com.intellij.psi.search.scope.packageSet.PackageSetFactory;
import com.intellij.psi.search.scope.packageSet.UnionPackageSet;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.DarculaColors;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.JBColor;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.SmartExpander;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.components.panels.VerticalLayout;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.ColorIcon;
import com.intellij.util.ui.JBScalableIcon;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;
import org.jetbrains.annotations.TestOnly;

public final class ScopeEditorPanel
implements Disposable {
    private JPanel myButtonsPanel;
    private RawCommandLineEditor myPatternField;
    private JPanel myTreeToolbar;
    private final Tree myPackageTree;
    private JPanel myPanel;
    private JPanel myTreePanel;
    private JLabel myMatchingCountLabel;
    private JPanel myLegendPanel;
    private final Project myProject;
    private final TreeExpansionMonitor<?> myTreeExpansionMonitor;
    private final Marker myTreeMarker;
    private PackageSet myCurrentScope;
    private boolean myIsInUpdate;
    @Nls
    private String myErrorMessage;
    private Future<?> myUpdateAlarm;
    private JLabel myCaretPositionLabel;
    private int myCaretPosition;
    private JPanel myMatchingCountPanel;
    private JPanel myPositionPanel;
    private JLabel myRecursivelyIncluded;
    private JLabel myPartiallyIncluded;
    private PanelProgressIndicator myCurrentProgress;
    private NamedScopesHolder myHolder;
    private Boolean myRebuildRequired;
    private final MyAction myInclude;
    private final MyAction myIncludeRec;
    private final MyAction myExclude;
    private final MyAction myExcludeRec;

    public ScopeEditorPanel(final @NotNull Project project, @NotNull NamedScopesHolder holder) {
        if (project == null) {
            ScopeEditorPanel.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            ScopeEditorPanel.$$$reportNull$$$0(1);
        }
        this.myCurrentScope = null;
        this.myIsInUpdate = false;
        this.$$$setupUI$$$();
        this.myUpdateAlarm = CompletableFuture.completedFuture(null);
        this.myCaretPosition = 0;
        this.myRebuildRequired = null;
        this.myInclude = new MyAction("button.include", (Consumer<List<PackageSet>>)((Consumer)this::includeSelected));
        this.myIncludeRec = new MyAction("button.include.recursively", (Consumer<List<PackageSet>>)((Consumer)this::includeSelected));
        this.myExclude = new MyAction("button.exclude", (Consumer<List<PackageSet>>)((Consumer)this::excludeSelected));
        this.myExcludeRec = new MyAction("button.exclude.recursively", (Consumer<List<PackageSet>>)((Consumer)this::excludeSelected));
        this.myProject = project;
        this.myHolder = holder;
        this.myPackageTree = new Tree((TreeNode)new RootNode(project));
        this.myButtonsPanel.add(this.createActionsPanel());
        this.myTreePanel.setLayout(new BorderLayout());
        this.myTreePanel.add((Component)ScrollPaneFactory.createScrollPane((Component)this.myPackageTree), "Center");
        this.myTreeToolbar.setLayout(new BorderLayout());
        this.myTreeToolbar.add((Component)this.createTreeToolbar(), "West");
        this.myTreeExpansionMonitor = PackageTreeExpansionMonitor.install((JTree)this.myPackageTree, this.myProject);
        this.myTreeMarker = new Marker(){

            @Override
            public boolean isMarked(@NotNull VirtualFile file2) {
                if (file2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                return ScopeEditorPanel.this.myCurrentScope != null && (ScopeEditorPanel.this.myCurrentScope instanceof PackageSetBase ? ((PackageSetBase)ScopeEditorPanel.this.myCurrentScope).contains(file2, project, ScopeEditorPanel.this.myHolder) : ScopeEditorPanel.this.myCurrentScope.contains(PackageSetBase.getPsiFile((VirtualFile)file2, (Project)ScopeEditorPanel.this.myProject), ScopeEditorPanel.this.myHolder));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/ide/util/scopeChooser/ScopeEditorPanel$1", "isMarked"));
            }
        };
        this.myPatternField.setDialogCaption("Pattern");
        this.myPatternField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            public void textChanged(@NotNull DocumentEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                ScopeEditorPanel.this.onTextChange();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/ide/util/scopeChooser/ScopeEditorPanel$2", "textChanged"));
            }
        });
        this.myPatternField.getTextField().addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent e) {
                ScopeEditorPanel.this.myCaretPosition = e.getDot();
                ScopeEditorPanel.this.updateCaretPositionText();
            }
        });
        this.myPatternField.getTextField().addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                if (ScopeEditorPanel.this.myErrorMessage != null) {
                    ScopeEditorPanel.this.myPositionPanel.setVisible(true);
                    ScopeEditorPanel.this.myPanel.revalidate();
                }
            }

            @Override
            public void focusLost(FocusEvent e) {
                if (!ScopeEditorPanel.this.myPatternField.getEditorField().isExpanded()) {
                    ScopeEditorPanel.this.myPositionPanel.setVisible(false);
                    ScopeEditorPanel.this.myPanel.revalidate();
                }
            }
        });
        this.initTree(this.myPackageTree);
        Disposer.register((Disposable)this, (Disposable)new UiNotifyConnector((Component)this.myPanel, new Activatable(){

            public void hideNotify() {
                ScopeEditorPanel.this.cancelCurrentProgress();
            }

            public void showNotify() {
                if (ScopeEditorPanel.this.myRebuildRequired != null && ScopeEditorPanel.this.myRebuildRequired.booleanValue()) {
                    ScopeEditorPanel.this.rebuild(false);
                }
            }
        }));
        this.myPartiallyIncluded.setIcon((Icon)JBUIScale.scaleIcon((JBScalableIcon)new ColorIcon(10, MyTreeCellRenderer.PARTIAL_INCLUDED)));
        this.myRecursivelyIncluded.setIcon((Icon)JBUIScale.scaleIcon((JBScalableIcon)new ColorIcon(10, MyTreeCellRenderer.WHOLE_INCLUDED)));
        MessageBusConnection connection = project.getMessageBus().connect((Disposable)this);
        connection.subscribe(SettingsChangedListener.TOPIC, () -> {
            if (!this.myPanel.isShowing()) {
                if (this.myRebuildRequired != null) {
                    this.myRebuildRequired = true;
                }
            } else {
                this.rebuild(false);
            }
        });
    }

    public void dispose() {
    }

    private void updateCaretPositionText() {
        if (this.myErrorMessage != null) {
            this.myCaretPositionLabel.setText(IdeBundle.message((String)"label.scope.editor.caret.position", (Object[])new Object[]{this.myCaretPosition + 1}));
        } else {
            this.myCaretPositionLabel.setText("");
        }
        this.myPositionPanel.setVisible(this.myErrorMessage != null);
        this.myCaretPositionLabel.setVisible(this.myErrorMessage != null);
        this.myPanel.revalidate();
    }

    public JPanel getPanel() {
        return this.myPanel;
    }

    public JPanel getTreePanel() {
        JPanel panel2 = new JPanel(new BorderLayout());
        panel2.add((Component)this.myTreePanel, "Center");
        panel2.add((Component)this.myLegendPanel, "South");
        return panel2;
    }

    public JPanel getTreeToolbar() {
        return this.myTreeToolbar;
    }

    private void onTextChange() {
        if (!this.myIsInUpdate) {
            this.cancelCurrentProgress();
            String text2 = this.myPatternField.getText();
            this.myCurrentScope = new InvalidPackageSet(text2);
            try {
                if (!StringUtil.isEmpty((String)text2)) {
                    this.myCurrentScope = PackageSetFactory.getInstance().compile(text2);
                }
                this.myErrorMessage = null;
            }
            catch (Exception e) {
                this.myErrorMessage = e.getMessage();
                this.showErrorMessage();
            }
            this.rebuild(false);
        } else if (!ScopeEditorPanel.invalidScopeInside(this.myCurrentScope)) {
            this.myErrorMessage = null;
        }
    }

    private void createUIComponents() {
        this.myPatternField = new RawCommandLineEditor(text2 -> Arrays.asList(text2.split("\\|\\|")), strings -> StringUtil.join((Collection)strings, (String)"||"));
    }

    private static boolean invalidScopeInside(PackageSet currentScope) {
        if (currentScope instanceof InvalidPackageSet) {
            return true;
        }
        if (currentScope instanceof CompoundPackageSet) {
            return ContainerUtil.or((Object[])((CompoundPackageSet)currentScope).getSets(), s -> ScopeEditorPanel.invalidScopeInside(s));
        }
        if (currentScope instanceof ComplementPackageSet) {
            return ScopeEditorPanel.invalidScopeInside(((ComplementPackageSet)currentScope).getComplementarySet());
        }
        return false;
    }

    private void showErrorMessage() {
        this.myMatchingCountLabel.setText(StringUtil.capitalize((String)this.myErrorMessage));
        this.myMatchingCountLabel.setForeground((Color)JBColor.red);
        this.myMatchingCountLabel.setToolTipText(this.myErrorMessage);
    }

    private JComponent createActionsPanel() {
        this.myPackageTree.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                ArrayList<PackageSet> selection = ScopeEditorPanel.this.getSelectedSets(false);
                ScopeEditorPanel.this.myInclude.setSelection(selection);
                ScopeEditorPanel.this.myExclude.setSelection(selection);
                ArrayList<PackageSet> recursive = ScopeEditorPanel.this.getSelectedSets(true);
                ScopeEditorPanel.this.myIncludeRec.setSelection(recursive);
                ScopeEditorPanel.this.myExcludeRec.setSelection(recursive);
            }
        });
        JPanel buttonsPanel = new JPanel((LayoutManager)new VerticalLayout(5));
        buttonsPanel.add(new JButton(this.myInclude));
        buttonsPanel.add(new JButton(this.myIncludeRec));
        buttonsPanel.add(new JButton(this.myExclude));
        buttonsPanel.add(new JButton(this.myExcludeRec));
        return buttonsPanel;
    }

    private void excludeSelected(@NotNull List<PackageSet> selected2) {
        if (selected2 == null) {
            ScopeEditorPanel.$$$reportNull$$$0(2);
        }
        for (PackageSet set2 : selected2) {
            Object[] objectArray;
            if (this.myCurrentScope == null) {
                this.myCurrentScope = new ComplementPackageSet(set2);
                continue;
            }
            if (this.myCurrentScope instanceof InvalidPackageSet) {
                this.myCurrentScope = StringUtil.isEmpty((String)this.myCurrentScope.getText()) ? new ComplementPackageSet(set2) : IntersectionPackageSet.create((PackageSet[])new PackageSet[]{this.myCurrentScope, new ComplementPackageSet(set2)});
                continue;
            }
            boolean[] append = new boolean[]{true};
            PackageSet simplifiedScope = ScopeEditorPanel.processComplementaryScope(this.myCurrentScope, set2, false, append);
            if (!append[0]) {
                this.myCurrentScope = simplifiedScope;
                continue;
            }
            if (simplifiedScope == null) {
                this.myCurrentScope = new ComplementPackageSet(set2);
                continue;
            }
            if (simplifiedScope instanceof IntersectionPackageSet) {
                objectArray = ((IntersectionPackageSet)simplifiedScope).getSets();
            } else {
                PackageSet[] packageSetArray = new PackageSet[1];
                objectArray = packageSetArray;
                packageSetArray[0] = simplifiedScope;
            }
            Object[] sets = objectArray;
            this.myCurrentScope = IntersectionPackageSet.create((PackageSet[])((PackageSet[])ArrayUtil.append((Object[])sets, (Object)new ComplementPackageSet(set2))));
        }
        this.rebuild(true);
    }

    private void includeSelected(@NotNull List<PackageSet> selected2) {
        if (selected2 == null) {
            ScopeEditorPanel.$$$reportNull$$$0(3);
        }
        for (PackageSet set2 : selected2) {
            Object[] objectArray;
            if (this.myCurrentScope == null) {
                this.myCurrentScope = set2;
                continue;
            }
            if (this.myCurrentScope instanceof InvalidPackageSet) {
                this.myCurrentScope = StringUtil.isEmpty((String)this.myCurrentScope.getText()) ? set2 : UnionPackageSet.create((PackageSet[])new PackageSet[]{this.myCurrentScope, set2});
                continue;
            }
            boolean[] append = new boolean[]{true};
            PackageSet simplifiedScope = ScopeEditorPanel.processComplementaryScope(this.myCurrentScope, set2, true, append);
            if (!append[0]) {
                this.myCurrentScope = simplifiedScope;
                continue;
            }
            if (simplifiedScope == null) {
                this.myCurrentScope = set2;
                continue;
            }
            if (simplifiedScope instanceof UnionPackageSet) {
                objectArray = ((UnionPackageSet)simplifiedScope).getSets();
            } else {
                PackageSet[] packageSetArray = new PackageSet[1];
                objectArray = packageSetArray;
                packageSetArray[0] = simplifiedScope;
            }
            Object[] sets = objectArray;
            this.myCurrentScope = UnionPackageSet.create((PackageSet[])((PackageSet[])ArrayUtil.append((Object[])sets, (Object)set2)));
        }
        this.rebuild(true);
    }

    @Nullable
    private static PackageSet processComplementaryScope(@NotNull PackageSet current2, PackageSet added2, boolean checkComplementSet, boolean[] append) {
        if (current2 == null) {
            ScopeEditorPanel.$$$reportNull$$$0(4);
        }
        String text2 = added2.getText();
        if (current2 instanceof ComplementPackageSet && Comparing.strEqual((String)((ComplementPackageSet)current2).getComplementarySet().getText(), (String)text2)) {
            if (checkComplementSet) {
                append[0] = false;
            }
            return null;
        }
        if (Comparing.strEqual((String)current2.getText(), (String)text2)) {
            if (!checkComplementSet) {
                append[0] = false;
            }
            return null;
        }
        if (current2 instanceof UnionPackageSet) {
            Object[] sets = ((UnionPackageSet)current2).getSets();
            PackageSet[] processed2 = (PackageSet[])ContainerUtil.mapNotNull((Object[])sets, s -> ScopeEditorPanel.processComplementaryScope(s, added2, checkComplementSet, append), (Object[])new PackageSet[0]);
            return processed2.length == 0 ? null : UnionPackageSet.create((PackageSet[])processed2);
        }
        if (current2 instanceof IntersectionPackageSet) {
            Object[] sets = ((IntersectionPackageSet)current2).getSets();
            PackageSet[] processed3 = (PackageSet[])ContainerUtil.mapNotNull((Object[])sets, s -> ScopeEditorPanel.processComplementaryScope(s, added2, checkComplementSet, append), (Object[])new PackageSet[0]);
            return processed3.length == 0 ? null : IntersectionPackageSet.create((PackageSet[])processed3);
        }
        return current2;
    }

    @Nullable
    private ArrayList<PackageSet> getSelectedSets(boolean recursively) {
        int[] rows = this.myPackageTree.getSelectionRows();
        if (rows == null) {
            return null;
        }
        ArrayList<PackageSet> result2 = new ArrayList<PackageSet>();
        for (int row2 : rows) {
            PackageDependenciesNode node = (PackageDependenciesNode)this.myPackageTree.getPathForRow(row2).getLastPathComponent();
            PackageSet set2 = PatternDialectProvider.getInstance(DependencyUISettings.getInstance().SCOPE_TYPE).createPackageSet(node, recursively);
            if (set2 == null) continue;
            result2.add(set2);
        }
        return result2;
    }

    private JComponent createTreeToolbar() {
        DefaultActionGroup group2 = new DefaultActionGroup();
        Runnable update2 = () -> ((SettingsChangedListener)this.myProject.getMessageBus().syncPublisher(SettingsChangedListener.TOPIC)).settingsChanged();
        if (ProjectViewDirectoryHelper.getInstance(this.myProject).supportsFlattenPackages()) {
            group2.add((AnAction)new FlattenPackagesAction(update2));
        }
        List dialectProviders = PatternDialectProvider.EP_NAME.getExtensionList();
        for (PatternDialectProvider provider2 : dialectProviders) {
            for (AnAction action2 : provider2.createActions(this.myProject, update2)) {
                group2.add(action2);
            }
        }
        group2.add((AnAction)new ShowFilesAction(update2));
        Module[] modules2 = ModuleManager.getInstance((Project)this.myProject).getModules();
        if (modules2.length > 1) {
            group2.add((AnAction)new ShowModulesAction(update2));
            if (ModuleManager.getInstance((Project)this.myProject).hasModuleGroups()) {
                group2.add((AnAction)new ShowModuleGroupsAction(update2));
            }
            group2.add((AnAction)this.createFlattenModulesAction(update2));
        }
        group2.add((AnAction)new FilterLegalsAction(update2));
        if (dialectProviders.size() > 1) {
            group2.add((AnAction)new ChooseScopeTypeAction(update2));
        }
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("ScopeEditor", (ActionGroup)group2, true);
        toolbar.setTargetComponent((JComponent)this.myPackageTree);
        return toolbar.getComponent();
    }

    @NotNull
    private FlattenModulesToggleAction createFlattenModulesAction(Runnable update2) {
        return new FlattenModulesToggleAction(this.myProject, () -> DependencyUISettings.getInstance().UI_SHOW_MODULES, () -> !DependencyUISettings.getInstance().UI_SHOW_MODULE_GROUPS, value2 -> {
            DependencyUISettings.getInstance().UI_SHOW_MODULE_GROUPS = value2 == false;
            update2.run();
        });
    }

    @TestOnly
    public void waitForCompletion() {
        int idx = 0;
        while (!this.myUpdateAlarm.isDone() && idx++ < 10000) {
            try {
                this.myUpdateAlarm.get(1L, TimeUnit.MILLISECONDS);
                return;
            }
            catch (TimeoutException timeoutException) {
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void rebuild(boolean updateText, @Nullable Runnable runnable2, boolean requestFocus, int delayMillis) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myRebuildRequired = false;
        this.cancelCurrentProgress();
        PanelProgressIndicator progress2 = this.createProgressIndicator(requestFocus);
        progress2.setBordersVisible(false);
        this.myCurrentProgress = progress2;
        Runnable request = () -> {
            if (updateText) {
                String text2 = this.myCurrentScope != null ? this.myCurrentScope.getText() : null;
                SwingUtilities.invokeLater(() -> {
                    try {
                        this.myIsInUpdate = true;
                        this.myPatternField.setText(text2);
                    }
                    finally {
                        this.myIsInUpdate = false;
                    }
                });
            }
            if (this.myProject.isDisposed()) {
                return;
            }
            try {
                this.updateTreeModel(requestFocus, progress2);
            }
            catch (ProcessCanceledException e) {
                return;
            }
            if (runnable2 != null) {
                runnable2.run();
            }
        };
        this.myUpdateAlarm = AppExecutorUtil.getAppScheduledExecutorService().schedule(request, (long)delayMillis, TimeUnit.MILLISECONDS);
    }

    public void rebuild(boolean updateText) {
        this.rebuild(updateText, null, true, 300);
    }

    public void setHolder(NamedScopesHolder holder) {
        this.myHolder = holder;
    }

    private void initTree(Tree tree) {
        tree.setCellRenderer((TreeCellRenderer)((Object)new MyTreeCellRenderer()));
        tree.setRootVisible(false);
        tree.setShowsRootHandles(true);
        TreeUtil.installActions((JTree)tree);
        SmartExpander.installOn((JTree)tree);
        new TreeSpeedSearch((JTree)tree);
        tree.addTreeWillExpandListener(new TreeWillExpandListener(){

            @Override
            public void treeWillExpand(TreeExpansionEvent event) {
                ((PackageDependenciesNode)event.getPath().getLastPathComponent()).sortChildren();
            }

            @Override
            public void treeWillCollapse(TreeExpansionEvent event) {
            }
        });
        PopupHandler.installPopupMenu((JComponent)tree, (ActionGroup)this.createTreePopupActions(), (String)"ScopeEditorPopup");
    }

    private ActionGroup createTreePopupActions() {
        DefaultActionGroup actionGroup2 = new DefaultActionGroup();
        ScopeEditorPanel.addAction(actionGroup2, this.myInclude);
        ScopeEditorPanel.addAction(actionGroup2, this.myIncludeRec);
        ScopeEditorPanel.addAction(actionGroup2, this.myExclude);
        ScopeEditorPanel.addAction(actionGroup2, this.myExcludeRec);
        return actionGroup2;
    }

    private void updateTreeModel(boolean requestFocus, PanelProgressIndicator progress2) throws ProcessCanceledException {
        Runnable updateModel = () -> {
            ProcessCanceledException[] ex = new ProcessCanceledException[1];
            ApplicationManager.getApplication().runReadAction(() -> {
                if (this.myProject.isDisposed()) {
                    return;
                }
                try {
                    this.myTreeExpansionMonitor.freeze();
                    TreeModel model2 = PatternDialectProvider.getInstance(DependencyUISettings.getInstance().SCOPE_TYPE).createTreeModel(this.myProject, this.myTreeMarker);
                    ((PackageDependenciesNode)model2.getRoot()).sortChildren();
                    if (this.myErrorMessage == null) {
                        String message2 = IdeBundle.message((String)"label.scope.contains.files", (Object[])new Object[]{model2.getMarkedFileCount(), model2.getTotalFileCount()});
                        this.myMatchingCountLabel.setText(message2);
                        this.myMatchingCountLabel.setForeground(new JLabel().getForeground());
                    } else {
                        this.showErrorMessage();
                    }
                    SwingUtilities.invokeLater(() -> {
                        this.myPackageTree.setModel((javax.swing.tree.TreeModel)model2);
                        this.myTreeExpansionMonitor.restore();
                    });
                }
                catch (ProcessCanceledException e) {
                    ex[0] = e;
                }
                finally {
                    SwingUtilities.invokeLater(() -> this.setToComponent(this.myMatchingCountLabel, requestFocus));
                }
            });
            if (ex[0] != null) {
                throw ex[0];
            }
        };
        ProgressManager.getInstance().runProcess(updateModel, (ProgressIndicator)progress2);
    }

    private PanelProgressIndicator createProgressIndicator(boolean requestFocus) {
        return new MyPanelProgressIndicator(requestFocus);
    }

    public void cancelCurrentProgress() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myUpdateAlarm.cancel(false);
        if (this.myCurrentProgress != null) {
            this.myCurrentProgress.cancel();
            this.myCurrentProgress = null;
        }
    }

    public void apply() throws ConfigurationException {
    }

    public PackageSet getCurrentScope() {
        return this.myCurrentScope;
    }

    public String getPatternText() {
        return this.myPatternField.getText();
    }

    public void reset(PackageSet packageSet, @Nullable Runnable runnable2) {
        this.myCurrentScope = packageSet;
        this.myRebuildRequired = false;
        this.myPatternField.setText(this.myCurrentScope == null ? "" : this.myCurrentScope.getText());
        this.rebuild(false, runnable2, false, 0);
    }

    private void setToComponent(JComponent cmp, boolean requestFocus) {
        this.myMatchingCountPanel.removeAll();
        this.myMatchingCountPanel.add((Component)cmp, "Center");
        this.myMatchingCountPanel.revalidate();
        this.myMatchingCountPanel.repaint();
        if (requestFocus) {
            this.myPatternField.getTextField().requestFocusInWindow();
        }
    }

    public void restoreCanceledProgress() {
        if (this.myIsInUpdate) {
            this.rebuild(false);
        }
    }

    public void clearCaches() {
        FileTreeModelBuilder.clearCaches(this.myProject);
    }

    private static void addAction(@NotNull DefaultActionGroup group2, final @NotNull MyAction action2) {
        if (group2 == null) {
            ScopeEditorPanel.$$$reportNull$$$0(5);
        }
        if (action2 == null) {
            ScopeEditorPanel.$$$reportNull$$$0(6);
        }
        group2.add((AnAction)new DumbAwareAction(String.valueOf(action2.getValue("Name"))){

            public void update(@NotNull AnActionEvent event) {
                if (event == null) {
                    8.$$$reportNull$$$0(0);
                }
                event.getPresentation().setEnabled(action2.isEnabled());
            }

            public void actionPerformed(@NotNull AnActionEvent event) {
                if (event == null) {
                    8.$$$reportNull$$$0(1);
                }
                action2.actionPerformed(null);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "event";
                objectArray2[1] = "com/intellij/ide/util/scopeChooser/ScopeEditorPanel$8";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "update";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "actionPerformed";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selected";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "current";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/util/scopeChooser/ScopeEditorPanel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "excludeSelected";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "includeSelected";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "processComplementaryScope";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "addAction";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JLabel jLabel;
        JLabel jLabel2;
        JPanel jPanel2;
        JLabel jLabel3;
        JPanel jPanel3;
        JLabel jLabel4;
        JPanel jPanel4;
        JPanel jPanel5;
        JPanel jPanel6;
        JPanel jPanel7;
        JPanel jPanel8;
        this.createUIComponents();
        this.myPanel = jPanel8 = new JPanel();
        jPanel8.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myTreePanel = jPanel7 = new JPanel();
        jPanel8.add((Component)jPanel7, new GridConstraints(1, 0, 3, 1, 0, 3, 7, 3, new Dimension(-1, 150), null, null));
        this.myButtonsPanel = jPanel6 = new JPanel();
        jPanel6.setLayout(new BorderLayout(0, 0));
        jPanel8.add((Component)jPanel6, new GridConstraints(1, 1, 1, 1, 0, 3, 0, 0, null, null, null));
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout((LayoutManager)new GridLayoutManager(2, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel8.add((Component)jPanel9, new GridConstraints(0, 0, 1, 2, 0, 3, 1, 0, null, null, null));
        JPanel jPanel10 = new JPanel();
        jPanel10.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel9.add((Component)jPanel10, new GridConstraints(1, 0, 1, 3, 0, 3, 1, 3, null, null, null));
        this.myTreeToolbar = jPanel5 = new JPanel();
        jPanel10.add((Component)jPanel5, new GridConstraints(0, 0, 1, 1, 0, 3, 1, 0, null, null, null));
        this.myMatchingCountPanel = jPanel4 = new JPanel();
        jPanel4.setLayout(new BorderLayout(0, 0));
        jPanel10.add((Component)jPanel4, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myMatchingCountLabel = jLabel4 = new JLabel();
        jLabel4.setHorizontalAlignment(4);
        jLabel4.setHorizontalTextPosition(4);
        jLabel4.setText("");
        jPanel4.add((Component)jLabel4, "Center");
        JLabel jLabel5 = new JLabel();
        this.$$$loadLabelText$$$(jLabel5, DynamicBundle.getBundle((String)"messages/IdeBundle", ScopeEditorPanel.class).getString("label.scope.pattern"));
        jPanel9.add((Component)jLabel5, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myPositionPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        ((Component)jPanel3).setVisible(false);
        jPanel9.add((Component)jPanel3, new GridConstraints(0, 2, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myCaretPositionLabel = jLabel3 = new JLabel();
        jLabel3.setText("");
        ((Component)jLabel3).setVisible(false);
        jPanel3.add((Component)jLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        RawCommandLineEditor rawCommandLineEditor = this.myPatternField;
        jPanel9.add((Component)rawCommandLineEditor, new GridConstraints(0, 1, 1, 1, 0, 1, 7, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel8.add((Component)spacer, new GridConstraints(2, 1, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myLegendPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel8.add((Component)jPanel2, new GridConstraints(3, 1, 1, 1, 0, 1, 0, 0, null, null, null));
        this.myRecursivelyIncluded = jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, DynamicBundle.getBundle((String)"messages/IdeBundle", ScopeEditorPanel.class).getString("scope.editor.legend.recursively.included.label"));
        jPanel2.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myPartiallyIncluded = jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/IdeBundle", ScopeEditorPanel.class).getString("scope.editor.legend.partly.included.label"));
        jPanel2.add((Component)jLabel, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int j = 0; j < string.length(); ++j) {
            if (string.charAt(j) == '&') {
                if (++j == string.length()) break;
                if (!bl && string.charAt(j) != '&') {
                    bl = true;
                    c = string.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(j));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private static final class MyAction
    extends AbstractAction {
        private final Consumer<List<PackageSet>> consumer;
        private List<PackageSet> selection;

        private MyAction(@NotNull @PropertyKey(resourceBundle="messages.IdeBundle") @NotNull @PropertyKey(resourceBundle="messages.IdeBundle") String key, @NotNull Consumer<List<PackageSet>> consumer) {
            if (key == null) {
                MyAction.$$$reportNull$$$0(0);
            }
            if (consumer == null) {
                MyAction.$$$reportNull$$$0(1);
            }
            super(IdeBundle.message((String)key, (Object[])new Object[0]));
            this.setEnabled(false);
            this.consumer = consumer;
        }

        void setSelection(@Nullable List<PackageSet> selection) {
            this.selection = selection;
            this.setEnabled(selection != null && !selection.isEmpty());
        }

        @Override
        public void actionPerformed(@Nullable ActionEvent event) {
            if (this.selection != null && !this.selection.isEmpty()) {
                this.consumer.consume(this.selection);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "key";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "consumer";
                    break;
                }
            }
            objectArray[1] = "com/intellij/ide/util/scopeChooser/ScopeEditorPanel$MyAction";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    protected class MyPanelProgressIndicator
    extends PanelProgressIndicator {
        private final boolean myRequestFocus;

        public MyPanelProgressIndicator(final boolean requestFocus) {
            super((Consumer<? super JComponent>)new Consumer<JComponent>(){

                public void consume(JComponent component2) {
                    ScopeEditorPanel.this.setToComponent(component2, requestFocus);
                }
            });
            this.myRequestFocus = requestFocus;
        }

        @Override
        public void stop() {
            super.stop();
            ScopeEditorPanel.this.setToComponent(ScopeEditorPanel.this.myMatchingCountLabel, this.myRequestFocus);
        }

        @Override
        public String getText() {
            return null;
        }

        @Override
        public String getText2() {
            return null;
        }
    }

    private final class FilterLegalsAction
    extends ToggleAction {
        private final Runnable myUpdate;

        FilterLegalsAction(Runnable update2) {
            super(IdeBundle.message((String)"action.show.included.only", (Object[])new Object[0]), IdeBundle.message((String)"action.description.show.included.only", (Object[])new Object[0]), AllIcons.General.Filter);
            this.myUpdate = update2;
        }

        public boolean isSelected(@NotNull AnActionEvent event) {
            if (event == null) {
                FilterLegalsAction.$$$reportNull$$$0(0);
            }
            return DependencyUISettings.getInstance().UI_FILTER_LEGALS;
        }

        public void setSelected(@NotNull AnActionEvent event, boolean flag) {
            if (event == null) {
                FilterLegalsAction.$$$reportNull$$$0(1);
            }
            DependencyUISettings.getInstance().UI_FILTER_LEGALS = flag;
            UIUtil.setEnabled((Component)ScopeEditorPanel.this.myLegendPanel, (!flag ? 1 : 0) != 0, (boolean)true);
            this.myUpdate.run();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "event";
            objectArray2[1] = "com/intellij/ide/util/scopeChooser/ScopeEditorPanel$FilterLegalsAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSelected";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setSelected";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class ChooseScopeTypeAction
    extends ComboBoxAction {
        private final Runnable myUpdate;

        ChooseScopeTypeAction(Runnable update2) {
            this.myUpdate = update2;
        }

        @NotNull
        protected DefaultActionGroup createPopupActionGroup(JComponent button4) {
            DefaultActionGroup group2 = new DefaultActionGroup();
            for (final PatternDialectProvider provider2 : PatternDialectProvider.EP_NAME.getExtensionList()) {
                group2.add(new AnAction(provider2.getDisplayName()){

                    public void actionPerformed(@NotNull AnActionEvent e) {
                        if (e == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        DependencyUISettings.getInstance().SCOPE_TYPE = provider2.getShortName();
                        myUpdate.run();
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/util/scopeChooser/ScopeEditorPanel$ChooseScopeTypeAction$1", "actionPerformed"));
                    }
                });
            }
            DefaultActionGroup defaultActionGroup = group2;
            if (defaultActionGroup == null) {
                ChooseScopeTypeAction.$$$reportNull$$$0(0);
            }
            return defaultActionGroup;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                ChooseScopeTypeAction.$$$reportNull$$$0(1);
            }
            super.update(e);
            PatternDialectProvider provider2 = PatternDialectProvider.getInstance(DependencyUISettings.getInstance().SCOPE_TYPE);
            e.getPresentation().setText(provider2.getDisplayName());
            e.getPresentation().setIcon(provider2.getIcon());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/util/scopeChooser/ScopeEditorPanel$ChooseScopeTypeAction";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createPopupActionGroup";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/util/scopeChooser/ScopeEditorPanel$ChooseScopeTypeAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class MyTreeCellRenderer
    extends ColoredTreeCellRenderer {
        private static final Color WHOLE_INCLUDED = new JBColor(new Color(10, 119, 0), new Color(10863196));
        private static final Color PARTIAL_INCLUDED = new JBColor(new Color(0, 50, 160), DarculaColors.BLUE);

        private MyTreeCellRenderer() {
        }

        public void customizeCellRenderer(JTree tree, Object value2, boolean selected2, boolean expanded, boolean leaf, int row2, boolean hasFocus) {
            if (value2 instanceof PackageDependenciesNode) {
                PackageDependenciesNode node = (PackageDependenciesNode)value2;
                this.setIcon(node.getIcon());
                this.setForeground(UIUtil.getTreeForeground((boolean)selected2, (boolean)hasFocus));
                if (!(selected2 && hasFocus || !node.hasMarked() || DependencyUISettings.getInstance().UI_FILTER_LEGALS)) {
                    this.setForeground(node.hasUnmarked() ? PARTIAL_INCLUDED : WHOLE_INCLUDED);
                }
                this.append(node.toString(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
                String locationString = node.getComment();
                if (!StringUtil.isEmpty((String)locationString)) {
                    this.append(" (" + locationString + ")", SimpleTextAttributes.GRAY_ATTRIBUTES);
                }
            }
        }
    }

    static interface SettingsChangedListener {
        public static final Topic<SettingsChangedListener> TOPIC = new Topic(SettingsChangedListener.class, Topic.BroadcastDirection.TO_CHILDREN);

        public void settingsChanged();
    }
}

