/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.scopeChooser;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.scopeChooser.ScopeChooserConfigurable;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.newEditor.SettingsDialog;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.ui.Messages;
import com.intellij.packageDependencies.DependencyValidationManager;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.PackageSet;
import javax.swing.Icon;
import org.jetbrains.annotations.Nullable;

public final class EditScopesDialog
extends SettingsDialog {
    private NamedScope mySelectedScope;
    private final Project myProject;
    private final ScopeChooserConfigurable myConfigurable;
    private final boolean myCheckShared;

    public EditScopesDialog(Project project, ScopeChooserConfigurable configurable2, boolean checkShared) {
        super(project, "scopes", (Configurable)configurable2, true, false);
        this.myProject = project;
        this.myConfigurable = configurable2;
        this.myCheckShared = checkShared;
    }

    @Override
    public void doOKAction() {
        String newName2;
        Project project;
        DependencyValidationManager manager2;
        NamedScope scope2;
        Object selectedObject = this.myConfigurable.getSelectedObject();
        this.mySelectedScope = selectedObject instanceof NamedScope ? (NamedScope)selectedObject : null;
        super.doOKAction();
        if (this.myCheckShared && this.mySelectedScope != null && (scope2 = (manager2 = DependencyValidationManager.getInstance((Project)(project = this.myProject))).getScope(this.mySelectedScope.getScopeId())) == null && ((MessageDialogBuilder.YesNo)MessageDialogBuilder.yesNo((String)IdeBundle.message((String)"scope.unable.to.save.scope.title", (Object[])new Object[0]), (String)IdeBundle.message((String)"scope.unable.to.save.scope.message", (Object[])new Object[0])).icon(Messages.getErrorIcon())).ask(project) && (newName2 = Messages.showInputDialog((Project)project, (String)IdeBundle.message((String)"add.scope.name.label", (Object[])new Object[0]), (String)IdeBundle.message((String)"scopes.save.dialog.title.shared", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon(), (String)this.mySelectedScope.getScopeId(), (InputValidator)new InputValidator(){

            public boolean checkInput(String inputString) {
                return inputString != null && inputString.length() > 0 && manager2.getScope(inputString) == null;
            }

            public boolean canClose(String inputString) {
                return this.checkInput(inputString);
            }
        })) != null) {
            PackageSet packageSet = this.mySelectedScope.getValue();
            this.mySelectedScope = scope2 = new NamedScope(newName2, manager2.getIcon(), packageSet != null ? packageSet.createCopy() : null);
            manager2.addScope(this.mySelectedScope);
        }
    }

    public static EditScopesDialog showDialog(Project project, @Nullable String scopeToSelect) {
        return EditScopesDialog.showDialog(project, scopeToSelect, false);
    }

    public static EditScopesDialog showDialog(Project project, @Nullable String scopeToSelect, boolean checkShared) {
        ScopeChooserConfigurable configurable2 = new ScopeChooserConfigurable(project);
        EditScopesDialog dialog2 = new EditScopesDialog(project, configurable2, checkShared);
        if (scopeToSelect != null) {
            configurable2.selectNodeInTree(scopeToSelect);
        }
        dialog2.show();
        return dialog2;
    }

    public NamedScope getSelectedScope() {
        return this.mySelectedScope;
    }
}

