/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf.darcula.ui;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.ui.laf.darcula.DarculaUIUtil;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.components.fields.ExtendableTextComponent;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.FontUtil;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.LinkedHashMap;
import java.util.Objects;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicTextFieldUI;
import javax.swing.plaf.basic.BasicTextUI;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public abstract class TextFieldWithPopupHandlerUI
extends BasicTextFieldUI
implements Condition {
    @NonNls
    private static final String DOCUMENT = "document";
    @NonNls
    private static final String MONOSPACED = "monospaced";
    @NonNls
    private static final String VARIANT = "JTextField.variant";
    @NonNls
    private static final String INPLACE_HISTORY = "JTextField.Search.InplaceHistory";
    @NonNls
    private static final String ON_CLEAR = "JTextField.Search.CancelAction";
    @NonNls
    private static final String HISTORY_POPUP_ENABLED = "History.Popup.Enabled";
    protected final LinkedHashMap<String, IconHolder> icons = new LinkedHashMap();
    private final Handler handler = new Handler();
    private boolean monospaced;
    private Object variant;
    private int cursor;

    protected Icon getSearchIcon(boolean hovered2, boolean clickable) {
        return clickable ? AllIcons.Actions.SearchWithHistory : AllIcons.Actions.Search;
    }

    protected int getSearchIconPreferredSpace() {
        Icon icon2 = this.getSearchIcon(true, TextFieldWithPopupHandlerUI.isSearchFieldWithHistoryPopup(this.getComponent()));
        return icon2 == null ? 0 : icon2.getIconWidth() + this.getSearchIconGap();
    }

    protected int getSearchIconGap() {
        return JBUIScale.scale((int)2);
    }

    protected Icon getClearIcon(boolean hovered2, boolean clickable) {
        return !clickable ? null : (hovered2 ? AllIcons.Actions.CloseHovered : AllIcons.Actions.Close);
    }

    protected int getClearIconPreferredSpace() {
        Icon icon2 = this.getClearIcon(true, true);
        return icon2 == null ? 0 : icon2.getIconWidth() + this.getClearIconGap();
    }

    protected int getClearIconGap() {
        return JBUIScale.scale((int)2);
    }

    protected boolean hasText() {
        JTextComponent component2 = this.getComponent();
        return component2 != null && !StringUtil.isEmpty((String)component2.getText());
    }

    private void updateIconsLayout(Rectangle bounds2) {
        JTextComponent c = this.getComponent();
        JBInsets margin = ComponentUtil.getParentOfType(JComboBox.class, (Component)c) != null || ComponentUtil.getParentOfType(JSpinner.class, (Component)c) != null || UIUtil.isClientPropertyTrue((Object)c, (Object)"TextFieldWithoutMargins") ? JBUI.emptyInsets() : this.getDefaultMargins();
        JBInsets.removeFrom((Rectangle)bounds2, (Insets)c.getInsets());
        JBInsets.removeFrom((Rectangle)bounds2, (Insets)margin);
        for (IconHolder holder : this.icons.values()) {
            int gap = holder.extension.getIconGap();
            if (holder.extension.isIconBeforeText()) {
                int offset = holder.extension.getAfterIconOffset();
                holder.bounds.x = bounds2.x;
                int extensionWidth = holder.bounds.width + gap + offset;
                bounds2.x += extensionWidth;
                bounds2.width -= extensionWidth;
                margin.left += extensionWidth;
            } else {
                holder.bounds.x = bounds2.x + bounds2.width - holder.bounds.width;
                int extensionWidth = holder.bounds.width + gap;
                bounds2.width -= extensionWidth;
                margin.right += extensionWidth;
            }
            int top = (bounds2.height - holder.bounds.height) / 2;
            if (top > gap) {
                boolean multiline;
                JTextComponent component2 = this.getComponent();
                boolean bl = multiline = component2 != null && !Boolean.TRUE.equals(component2.getDocument().getProperty("filterNewlines"));
                if (multiline) {
                    top = gap;
                }
            }
            holder.bounds.y = bounds2.y + top;
        }
        c.setMargin((Insets)margin);
    }

    protected SearchAction getActionUnder(@NotNull Point p) {
        if (p == null) {
            TextFieldWithPopupHandlerUI.$$$reportNull$$$0(0);
        }
        return null;
    }

    protected void showSearchPopup() {
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        if (SystemInfo.isMacOSCatalina) {
            JTextComponent component2 = this.getComponent();
            component2.setFont(FontUtil.disableKerning((Font)component2.getFont()));
        }
    }

    @Override
    protected void installListeners() {
        JTextComponent component2 = this.getComponent();
        this.handler.installListener(component2.getDocument());
        component2.addPropertyChangeListener(this.handler);
        component2.addMouseMotionListener(this.handler);
        component2.addMouseListener(this.handler);
        component2.addFocusListener(this.handler);
        this.setVariant(component2.getClientProperty(VARIANT));
        this.setMonospaced(component2.getClientProperty(MONOSPACED));
    }

    @Override
    protected void uninstallListeners() {
        JTextComponent component2 = this.getComponent();
        component2.removeFocusListener(this.handler);
        component2.removeMouseListener(this.handler);
        component2.removeMouseMotionListener(this.handler);
        component2.removePropertyChangeListener(this.handler);
        this.handler.uninstallListener(component2.getDocument());
    }

    @Override
    public int getNextVisualPositionFrom(JTextComponent t, int pos, Position.Bias b, int direction, Position.Bias[] biasRet) throws BadLocationException {
        int position = DarculaUIUtil.getPatchedNextVisualPositionFrom(t, pos, direction);
        return position != -1 ? position : super.getNextVisualPositionFrom(t, pos, b, direction, biasRet);
    }

    @Override
    protected Caret createCaret() {
        return new MouseDragAwareCaret();
    }

    public boolean value(Object o) {
        MouseEvent me;
        if (o instanceof MouseEvent && this.getActionUnder((me = (MouseEvent)o).getPoint()) != null) {
            if (me.getID() == 500) {
                SwingUtilities.invokeLater(() -> this.handler.mouseClicked(me));
            }
            return true;
        }
        return false;
    }

    public static boolean isSearchField(Component c) {
        if (!(c instanceof JTextField)) {
            return false;
        }
        Object variant = ((JTextField)c).getClientProperty(VARIANT);
        return "search".equals(variant) || "searchWithJbPopup".equals(variant);
    }

    @Nullable
    public static AbstractAction getNewLineAction(Component c) {
        if (!TextFieldWithPopupHandlerUI.isSearchField(c)) {
            return null;
        }
        Object action2 = ((JTextField)c).getClientProperty("JTextField.Search.NewLineAction");
        return action2 instanceof AbstractAction ? (AbstractAction)action2 : null;
    }

    @TestOnly
    @NotNull
    public Point getExtensionIconLocation(@NotNull String extensionName) {
        IconHolder iconHolder;
        if (extensionName == null) {
            TextFieldWithPopupHandlerUI.$$$reportNull$$$0(1);
        }
        if ((iconHolder = this.icons.get(extensionName)) == null) {
            throw new IllegalArgumentException("The " + extensionName + " extension does not exist in this text field");
        }
        Point point = iconHolder.bounds.getLocation();
        if (point == null) {
            TextFieldWithPopupHandlerUI.$$$reportNull$$$0(2);
        }
        return point;
    }

    @NotNull
    public Rectangle getExtensionIconBounds(@NotNull ExtendableTextComponent.Extension extension2) {
        if (extension2 == null) {
            TextFieldWithPopupHandlerUI.$$$reportNull$$$0(3);
        }
        for (IconHolder holder : this.icons.values()) {
            if (holder.extension != extension2) continue;
            return new Rectangle(holder.bounds);
        }
        throw new IllegalArgumentException("The " + extension2 + " extension does not exist in this text field");
    }

    @Override
    public String getToolTipText(JTextComponent component2, Point point) {
        if (!this.icons.isEmpty() && component2 != null && component2.isEnabled()) {
            for (IconHolder holder : this.icons.values()) {
                if (!holder.bounds.contains(point)) continue;
                return holder.extension.getTooltip();
            }
        }
        return super.getToolTipText(component2, point);
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        Dimension size = super.getMinimumSize(c);
        if (size != null) {
            this.updatePreferredSize(c, size);
        }
        return size;
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        Dimension size = super.getPreferredSize(c);
        if (size != null) {
            int columns;
            JTextComponent component2 = this.getComponent();
            int n = columns = component2 instanceof JTextField ? ((JTextField)component2).getColumns() : 0;
            if (columns != 0) {
                Insets insets = component2.getInsets();
                FontMetrics fm = component2.getFontMetrics(component2.getFont());
                size.width = columns * fm.charWidth('m') + insets.left + insets.right;
            }
            this.updatePreferredSize(component2, size);
        }
        return size;
    }

    protected void updatePreferredSize(JComponent c, Dimension size) {
        if (!TextFieldWithPopupHandlerUI.isUnderComboBox(c)) {
            JBInsets.addTo((Dimension)size, (Insets)this.getDefaultMargins());
            size.width += this.icons.values().stream().mapToInt(h -> h.extension.getPreferredSpace()).sum();
            size.height = Math.max(size.height, this.getMinimumHeight(size.height));
            size.width = Math.max(size.width, DarculaUIUtil.MINIMUM_WIDTH.get());
        }
    }

    private static boolean isUnderComboBox(JComponent c) {
        Container parent = c.getParent();
        return parent instanceof JComboBox || parent != null && parent.getParent() instanceof JComboBox;
    }

    protected int getMinimumHeight(int textHeight) {
        return 0;
    }

    protected Insets getDefaultMargins() {
        return JBUI.emptyInsets();
    }

    @Override
    protected Rectangle getVisibleEditorRect() {
        JTextComponent c = this.getComponent();
        Rectangle bounds2 = new Rectangle(c.getSize());
        this.updateIconsLayout(bounds2);
        return bounds2;
    }

    @Override
    protected void paintSafely(Graphics g) {
        JTextComponent component2 = this.getComponent();
        if (!component2.isOpaque()) {
            this.paintBackground(g);
        }
        Shape clip = g.getClip();
        super.paintSafely(g);
        if (!this.icons.isEmpty()) {
            g.setClip(clip);
            for (IconHolder holder : this.icons.values()) {
                if (holder.icon == null) continue;
                holder.icon.paintIcon(component2, g, holder.bounds.x, holder.bounds.y);
            }
        }
    }

    @Override
    public int viewToModel(JTextComponent tc, Point pt, Position.Bias[] biasReturn) {
        return this.icons.values().stream().anyMatch(p -> p.bounds.contains(pt)) ? -1 : super.viewToModel(tc, pt, biasReturn);
    }

    private void repaint(boolean invalid) {
        JTextComponent component2 = this.getComponent();
        if (component2 != null) {
            if (invalid) {
                component2.revalidate();
            }
            component2.repaint();
        }
    }

    private void updateIcon(IconHolder holder) {
        Icon icon2;
        if (holder != null && holder.icon != (icon2 = holder.extension.getIcon(holder.hovered))) {
            this.repaint(holder.setIcon(icon2));
        }
    }

    private void handleMouse(MouseEvent event, boolean run2) {
        JTextComponent component2 = this.getComponent();
        if (component2 != null) {
            Runnable action2;
            IconHolder result2 = this.getIconHolder(component2, event.getX(), event.getY());
            Runnable runnable2 = action2 = result2 == null ? null : result2.extension.getActionOnClick();
            if (action2 == null) {
                this.setCursor(2);
            } else {
                this.setCursor(12);
                if (run2) {
                    action2.run();
                    event.consume();
                }
            }
        }
    }

    @Nullable
    private IconHolder getIconHolder(@NotNull JTextComponent component2, int x, int y) {
        if (component2 == null) {
            TextFieldWithPopupHandlerUI.$$$reportNull$$$0(4);
        }
        boolean invalid = false;
        boolean repaint = false;
        IconHolder result2 = null;
        for (IconHolder holder : this.icons.values()) {
            Icon icon2;
            boolean bl = holder.hovered = component2.isEnabled() && holder.bounds.contains(x, y);
            if (holder.hovered) {
                result2 = holder;
            }
            if (holder.icon == (icon2 = holder.extension.getIcon(holder.hovered))) continue;
            if (holder.setIcon(icon2)) {
                invalid = true;
            }
            repaint = true;
        }
        if (repaint) {
            this.repaint(invalid);
        }
        return result2;
    }

    private void setCursor(int cursor) {
        if (this.cursor != cursor) {
            this.cursor = cursor;
            JTextComponent component2 = this.getComponent();
            if (component2 != null) {
                component2.setCursor(Cursor.getPredefinedCursor(cursor));
            }
        }
    }

    private void setVariant(Object variant) {
        if (!Objects.equals(this.variant, variant)) {
            this.variant = variant;
            this.icons.clear();
            if ("extendable".equals(variant)) {
                JTextComponent component2 = this.getComponent();
                if (component2 instanceof ExtendableTextComponent) {
                    ExtendableTextComponent field = (ExtendableTextComponent)component2;
                    for (ExtendableTextComponent.Extension extension2 : field.getExtensions()) {
                        if (extension2 == null) continue;
                        this.addExtension(extension2);
                    }
                }
            } else if ("search".equals(variant)) {
                Object extension3 = this.getComponent().getClientProperty("search.extension");
                if (extension3 instanceof ExtendableTextComponent.Extension) {
                    this.addExtension((ExtendableTextComponent.Extension)extension3);
                }
                this.addExtension(new SearchExtension());
                this.addExtension(new ClearExtension());
            }
        }
        this.updateIconsLayout(new Rectangle(this.getComponent().getSize()));
    }

    protected void addExtension(ExtendableTextComponent.Extension extension2) {
        this.icons.put(extension2.toString(), new IconHolder(extension2));
    }

    private void setMonospaced(Object value2) {
        boolean monospaced = Boolean.TRUE.equals(value2);
        if (this.monospaced != monospaced) {
            Font font;
            this.monospaced = monospaced;
            JTextComponent component2 = this.getComponent();
            if (component2 != null && ((font = component2.getFont()) == null || font instanceof UIResource)) {
                font = UIManager.getFont(this.getPropertyPrefix() + ".font");
                if (font == null) {
                    font = UIManager.getFont("TextField.font");
                }
                if (font == null) {
                    font = UIManager.getFont("Label.font");
                }
                component2.setFont(!monospaced ? (!SystemInfo.isMacOSCatalina ? font : FontUtil.disableKerning((Font)font)) : EditorUtil.getEditorFont(font.getSize()));
            }
        }
    }

    public static boolean isSearchFieldWithHistoryPopup(Component c) {
        if (c instanceof JComponent) {
            Object historyPopupEnabled = ((JComponent)c).getClientProperty(HISTORY_POPUP_ENABLED);
            boolean searchPopupDisabled = historyPopupEnabled != null && historyPopupEnabled.equals(false);
            return TextFieldWithPopupHandlerUI.isSearchField(c) && !searchPopupDisabled;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensionName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/ui/laf/darcula/ui/TextFieldWithPopupHandlerUI";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/ui/laf/darcula/ui/TextFieldWithPopupHandlerUI";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtensionIconLocation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getActionUnder";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getExtensionIconLocation";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getExtensionIconBounds";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getIconHolder";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class MouseDragAwareCaret
    extends MarginAwareCaret {
        MouseDragAwareCaret() {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (e.getID() == 506 && !this.isMultiline(this.getComponent())) {
                boolean consumed = e.isConsumed();
                e = new MouseEvent(e.getComponent(), e.getID(), e.getWhen(), e.getModifiers() | e.getModifiersEx(), e.getX(), this.getComponent().getHeight() / 2, e.getClickCount(), e.isPopupTrigger(), e.getButton());
                if (consumed) {
                    e.consume();
                }
            }
            super.mouseDragged(e);
        }

        public boolean isMultiline(JTextComponent component2) {
            return component2.getText().contains("\n") || component2 instanceof JTextArea && ((JTextArea)component2).getLineWrap();
        }
    }

    public static class MarginAwareCaret
    extends BasicTextUI.BasicCaret {
        @Override
        protected void adjustVisibility(Rectangle r) {
            Insets m = this.getComponent().getMargin();
            r.x -= m.left;
            r.width += m.left;
            super.adjustVisibility(r);
        }
    }

    private class ClearExtension
    implements ExtendableTextComponent.Extension {
        private ClearExtension() {
        }

        public Icon getIcon(boolean hovered2) {
            return TextFieldWithPopupHandlerUI.this.getClearIcon(hovered2, TextFieldWithPopupHandlerUI.this.hasText());
        }

        public int getPreferredSpace() {
            Icon icon2 = TextFieldWithPopupHandlerUI.this.getClearIcon(false, true);
            return icon2 != null ? this.getIconGap() + icon2.getIconWidth() : 0;
        }

        public int getIconGap() {
            return TextFieldWithPopupHandlerUI.this.getClearIconGap();
        }

        public Runnable getActionOnClick() {
            JTextComponent component2 = TextFieldWithPopupHandlerUI.this.getComponent();
            return component2 == null ? null : () -> {
                component2.setText(null);
                Object property2 = component2.getClientProperty(TextFieldWithPopupHandlerUI.ON_CLEAR);
                if (property2 instanceof ActionListener) {
                    ActionListener listener2 = (ActionListener)property2;
                    listener2.actionPerformed(new ActionEvent(component2, 1001, "clear"));
                }
            };
        }

        public String toString() {
            return "clear";
        }
    }

    private final class SearchExtension
    implements ExtendableTextComponent.Extension {
        private SearchExtension() {
        }

        public Icon getIcon(boolean hovered2) {
            return TextFieldWithPopupHandlerUI.this.getSearchIcon(hovered2, TextFieldWithPopupHandlerUI.isSearchFieldWithHistoryPopup(TextFieldWithPopupHandlerUI.this.getComponent()));
        }

        public int getAfterIconOffset() {
            Integer gap = (Integer)TextFieldWithPopupHandlerUI.this.getComponent().getClientProperty("JTextField.Search.Gap");
            return gap == null ? 0 : gap;
        }

        public int getIconGap() {
            return TextFieldWithPopupHandlerUI.this.getSearchIconGap();
        }

        public boolean isIconBeforeText() {
            return true;
        }

        public Runnable getActionOnClick() {
            return null;
        }

        public String getTooltip() {
            String prefix2 = null;
            if (UIUtil.getClientProperty((Object)TextFieldWithPopupHandlerUI.this.getComponent(), (Object)TextFieldWithPopupHandlerUI.INPLACE_HISTORY) != null) {
                prefix2 = IdeBundle.message((String)"tooltip.recent.search", (Object[])new Object[0]);
            }
            if (this.getActionOnClick() != null) {
                prefix2 = IdeBundle.message((String)"tooltip.search.history", (Object[])new Object[0]);
            }
            return prefix2 == null ? null : prefix2 + " (" + KeymapUtil.getFirstKeyboardShortcutText((String)"ShowSearchHistory") + ")";
        }

        public String toString() {
            return "search";
        }
    }

    public static final class IconHolder {
        public final Rectangle bounds = new Rectangle();
        public final ExtendableTextComponent.Extension extension;
        public boolean hovered;
        public Icon icon;

        private IconHolder(ExtendableTextComponent.Extension extension2) {
            this.extension = extension2;
            this.setIcon(extension2.getIcon(false));
        }

        private boolean setIcon(Icon icon2) {
            int height;
            this.icon = icon2;
            int width = icon2 == null ? 0 : icon2.getIconWidth();
            int n = height = icon2 == null ? 0 : icon2.getIconHeight();
            if (this.bounds.width == width && this.bounds.height == height) {
                return false;
            }
            this.bounds.width = width;
            this.bounds.height = height;
            return true;
        }

        public boolean isClickable() {
            return null != this.extension.getActionOnClick();
        }
    }

    private final class Handler
    extends MouseAdapter
    implements DocumentListener,
    FocusListener,
    PropertyChangeListener {
        private Handler() {
        }

        private void installListener(Document document) {
            if (document != null) {
                document.addDocumentListener(this);
            }
        }

        private void uninstallListener(Document document) {
            if (document != null) {
                document.removeDocumentListener(this);
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent event) {
            if (TextFieldWithPopupHandlerUI.DOCUMENT.equals(event.getPropertyName())) {
                if (event.getOldValue() instanceof Document) {
                    this.uninstallListener((Document)event.getOldValue());
                }
                if (event.getNewValue() instanceof Document) {
                    this.installListener((Document)event.getNewValue());
                }
            } else if (TextFieldWithPopupHandlerUI.MONOSPACED.equals(event.getPropertyName())) {
                TextFieldWithPopupHandlerUI.this.setMonospaced(event.getNewValue());
            } else if (TextFieldWithPopupHandlerUI.VARIANT.equals(event.getPropertyName())) {
                TextFieldWithPopupHandlerUI.this.setVariant(event.getNewValue());
            }
        }

        @Override
        public void focusGained(FocusEvent event) {
            TextFieldWithPopupHandlerUI.this.repaint(false);
        }

        @Override
        public void focusLost(FocusEvent event) {
            TextFieldWithPopupHandlerUI.this.repaint(false);
        }

        @Override
        public void insertUpdate(DocumentEvent event) {
            this.changedUpdate(event);
        }

        @Override
        public void removeUpdate(DocumentEvent event) {
            this.changedUpdate(event);
        }

        @Override
        public void changedUpdate(DocumentEvent event) {
            if (!TextFieldWithPopupHandlerUI.this.icons.isEmpty()) {
                for (IconHolder holder : TextFieldWithPopupHandlerUI.this.icons.values()) {
                    TextFieldWithPopupHandlerUI.this.updateIcon(holder);
                }
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            if (!TextFieldWithPopupHandlerUI.this.icons.isEmpty()) {
                TextFieldWithPopupHandlerUI.this.handleMouse(e, false);
            } else if (TextFieldWithPopupHandlerUI.this.getComponent() != null && TextFieldWithPopupHandlerUI.isSearchField(TextFieldWithPopupHandlerUI.this.getComponent())) {
                SearchAction action2 = TextFieldWithPopupHandlerUI.this.getActionUnder(e.getPoint());
                TextFieldWithPopupHandlerUI.this.setCursor(action2 != null ? 12 : 2);
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            if (!TextFieldWithPopupHandlerUI.this.icons.isEmpty()) {
                TextFieldWithPopupHandlerUI.this.handleMouse(e, false);
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            SearchAction action2;
            if (!TextFieldWithPopupHandlerUI.this.icons.isEmpty()) {
                TextFieldWithPopupHandlerUI.this.handleMouse(e, true);
            } else if (TextFieldWithPopupHandlerUI.isSearchField(TextFieldWithPopupHandlerUI.this.getComponent()) && (action2 = TextFieldWithPopupHandlerUI.this.getActionUnder(e.getPoint())) != null) {
                switch (action2) {
                    case CLEAR: {
                        Object listener2 = TextFieldWithPopupHandlerUI.this.getComponent().getClientProperty(TextFieldWithPopupHandlerUI.ON_CLEAR);
                        if (listener2 instanceof ActionListener) {
                            ((ActionListener)listener2).actionPerformed(new ActionEvent(TextFieldWithPopupHandlerUI.this.getComponent(), 1001, "action"));
                        }
                        TextFieldWithPopupHandlerUI.this.getComponent().setText("");
                        break;
                    }
                    case NEWLINE: {
                        AbstractAction newLineAction = TextFieldWithPopupHandlerUI.getNewLineAction(TextFieldWithPopupHandlerUI.this.getComponent());
                        if (newLineAction == null) break;
                        newLineAction.actionPerformed(new ActionEvent(TextFieldWithPopupHandlerUI.this.getComponent(), 1001, "action"));
                        break;
                    }
                }
                e.consume();
            }
        }
    }

    public static enum SearchAction {
        CLEAR,
        NEWLINE;

    }
}

