/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf.darcula.ui;

import com.intellij.ide.ui.laf.darcula.DarculaUIUtil;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.JBValue;
import com.intellij.util.ui.MacUIUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicArrowButton;
import javax.swing.plaf.basic.BasicSpinnerUI;

public class DarculaSpinnerUI
extends BasicSpinnerUI {
    protected static final JBValue MINIMUM_WIDTH = new JBValue.Float(72.0f);
    private static final JBValue ARROW_WIDTH = new JBValue.Float(9.0f);
    private static final JBValue ARROW_HEIGHT = new JBValue.Float(5.0f);
    protected JButton prevButton;
    protected JButton nextButton;
    private final FocusAdapter myFocusListener = new FocusAdapter(){

        @Override
        public void focusGained(FocusEvent e) {
            DarculaSpinnerUI.this.spinner.repaint();
        }

        @Override
        public void focusLost(FocusEvent e) {
            DarculaSpinnerUI.this.spinner.repaint();
        }
    };

    protected Insets editorMargins() {
        return DarculaUIUtil.isCompact(this.spinner) ? JBInsets.create((int)0, (int)5) : JBInsets.create((int)1, (int)5);
    }

    public static ComponentUI createUI(JComponent c) {
        return new DarculaSpinnerUI();
    }

    private void addEditorFocusListener(JComponent editor) {
        if (editor != null) {
            editor.getComponents()[0].addFocusListener(this.myFocusListener);
        }
    }

    private void removeEditorFocusListener(JComponent editor) {
        if (editor != null) {
            editor.getComponents()[0].removeFocusListener(this.myFocusListener);
        }
    }

    private static void resetEditorOpaque(JComponent editor) {
        if (editor != null) {
            editor.setOpaque(false);
            ((JComponent)editor.getComponents()[0]).setOpaque(false);
        }
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        this.removeEditorFocusListener(this.spinner.getEditor());
    }

    @Override
    protected void replaceEditor(JComponent oldEditor, JComponent newEditor) {
        super.replaceEditor(oldEditor, newEditor);
        this.removeEditorFocusListener(oldEditor);
        this.addEditorFocusListener(newEditor);
        DarculaSpinnerUI.resetEditorOpaque(newEditor);
    }

    @Override
    protected JComponent createEditor() {
        JComponent editor = super.createEditor();
        this.addEditorFocusListener(editor);
        DarculaSpinnerUI.resetEditorOpaque(editor);
        return editor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(Graphics g, JComponent c) {
        Graphics2D g2 = (Graphics2D)g.create();
        Rectangle r = new Rectangle(c.getSize());
        JBInsets.removeFrom((Rectangle)r, (Insets)JBUI.insets((int)1));
        try {
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, MacUIUtil.USE_QUARTZ ? RenderingHints.VALUE_STROKE_PURE : RenderingHints.VALUE_STROKE_NORMALIZE);
            g2.translate(r.x, r.y);
            float bw = DarculaUIUtil.BW.getFloat();
            float arc = DarculaUIUtil.COMPONENT_ARC.getFloat();
            g2.setColor(this.getBackground());
            g2.fill(new RoundRectangle2D.Float(bw, bw, (float)r.width - bw * 2.0f, (float)r.height - bw * 2.0f, arc, arc));
        }
        finally {
            g2.dispose();
        }
    }

    protected Color getBackground() {
        return this.spinner.isEnabled() && this.spinner.getEditor() != null ? this.spinner.getEditor().getComponent(0).getBackground() : UIUtil.getPanelBackground();
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        Dimension size = super.getPreferredSize(c);
        return this.getSizeWithButtons(c.getInsets(), size);
    }

    protected Dimension getSizeWithButtons(Insets i2, Dimension size) {
        Dimension arrowSize = this.nextButton.getPreferredSize();
        Dimension minSize = new Dimension(i2.left + MINIMUM_WIDTH.get() + i2.right, arrowSize.height * 2);
        size = DarculaUIUtil.maximize(size, minSize);
        JBDimension editorSize = this.spinner.getEditor() != null ? this.spinner.getEditor().getPreferredSize() : JBUI.emptySize();
        Insets m = this.editorMargins();
        return new Dimension(Math.max(size.width, i2.left + m.left + editorSize.width + m.right + arrowSize.width), Math.max(size.height, i2.top + m.top + editorSize.height + m.bottom + i2.bottom));
    }

    protected JButton createButton(int direction, String name) {
        JButton button4 = this.createArrow(direction);
        button4.setName(name);
        button4.setBorder((Border)JBUI.Borders.empty());
        if (direction == 1) {
            this.installNextButtonListeners(button4);
        } else {
            this.installPreviousButtonListeners(button4);
        }
        return button4;
    }

    @Override
    protected Component createPreviousButton() {
        this.prevButton = this.createButton(5, "Spinner.previousButton");
        return this.prevButton;
    }

    @Override
    protected Component createNextButton() {
        this.nextButton = this.createButton(1, "Spinner.nextButton");
        return this.nextButton;
    }

    @Override
    protected LayoutManager createLayout() {
        return new LayoutManagerDelegate(super.createLayout()){

            @Override
            public void layoutContainer(Container parent) {
                super.layoutContainer(parent);
                DarculaSpinnerUI.this.layout();
            }
        };
    }

    protected void layout() {
        int w = this.spinner.getWidth();
        int h = this.spinner.getHeight();
        Dimension abSize = this.nextButton.getPreferredSize();
        this.nextButton.setBounds(w - abSize.width, JBUIScale.scale((int)1), abSize.width, h / 2);
        this.prevButton.setBounds(w - abSize.width, h / 2, abSize.width, h - h / 2);
        JComponent editor = this.spinner.getEditor();
        if (editor != null) {
            Insets i2 = this.spinner.getInsets();
            Insets m = this.editorMargins();
            int editorHeight = editor.getPreferredSize().height;
            int editorOffset = (int)Math.round((double)(h - i2.top - i2.bottom - m.top - m.bottom - editorHeight) / 2.0);
            editor.setBounds(i2.left + m.left, i2.top + m.top + editorOffset, w - (i2.left + abSize.width + m.left + m.right), editorHeight);
        }
    }

    protected void layoutEditor() {
    }

    protected void paintArrowButton(Graphics g, BasicArrowButton button4, int direction) {
        Insets i2 = this.spinner.getInsets();
        int x = (button4.getWidth() - i2.right - ARROW_WIDTH.get()) / 2;
        int y = direction == 1 ? button4.getHeight() - JBUIScale.scale((int)2) : JBUIScale.scale((int)2);
        button4.paintTriangle(g, x, y, 0, direction, this.spinner.isEnabled());
    }

    private JButton createArrow(int direction) {
        BasicArrowButton b = new BasicArrowButton(direction){

            @Override
            public void paint(Graphics g) {
                DarculaSpinnerUI.this.paintArrowButton(g, this, this.direction);
            }

            @Override
            public boolean isOpaque() {
                return false;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void paintTriangle(Graphics g, int x, int y, int size, int direction, boolean isEnabled) {
                Graphics2D g2 = (Graphics2D)g.create();
                try {
                    g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, MacUIUtil.USE_QUARTZ ? RenderingHints.VALUE_STROKE_PURE : RenderingHints.VALUE_STROKE_NORMALIZE);
                    float lw = DarculaUIUtil.LW.getFloat();
                    float bw = DarculaUIUtil.BW.getFloat();
                    g2.setColor(JBUI.CurrentTheme.Arrow.backgroundColor((boolean)isEnabled, (boolean)true));
                    g2.fill(this.getInnerShape(lw, bw));
                    int h = this.getHeight() - JBUIScale.scale((int)1);
                    Rectangle2D.Float sideLine = direction == 1 ? new Rectangle2D.Float(0.0f, bw + lw, lw, (float)h - (bw + lw)) : new Rectangle2D.Float(0.0f, 0.0f, lw, (float)h - (bw + lw));
                    g2.setColor(DarculaUIUtil.getOutlineColor(DarculaSpinnerUI.this.spinner.isEnabled(), false));
                    g2.fill(sideLine);
                    g2.translate(x, y);
                    g2.setColor(JBUI.CurrentTheme.Arrow.foregroundColor((boolean)isEnabled));
                    g2.fill(this.getArrowShape());
                }
                finally {
                    g2.dispose();
                }
            }

            private Shape getInnerShape(float lw, float bw) {
                Path2D.Float shape = new Path2D.Float();
                int w = this.getWidth() - JBUIScale.scale((int)1);
                int h = this.getHeight() - JBUIScale.scale((int)1);
                float arc = DarculaUIUtil.COMPONENT_ARC.getFloat();
                arc = arc > bw + lw ? arc - bw - lw : 0.0f;
                switch (this.direction) {
                    case 5: {
                        ((Path2D)shape).moveTo(lw, 0.0);
                        ((Path2D)shape).lineTo((float)w - bw - lw, 0.0);
                        ((Path2D)shape).lineTo((float)w - bw - lw, (float)h - bw - lw - arc);
                        ((Path2D)shape).quadTo((float)w - bw - lw, (float)h - bw - lw, (float)w - bw - lw - arc, (float)h - bw - lw);
                        ((Path2D)shape).lineTo(lw, (float)h - bw - lw);
                        shape.closePath();
                        break;
                    }
                    case 1: {
                        ((Path2D)shape).moveTo(lw, bw + lw);
                        ((Path2D)shape).lineTo((float)w - bw - lw - arc, bw + lw);
                        ((Path2D)shape).quadTo((float)w - bw - lw, bw + lw, (float)w - bw - lw, bw + lw + arc);
                        ((Path2D)shape).lineTo((float)w - bw - lw, h);
                        ((Path2D)shape).lineTo(lw, h);
                        shape.closePath();
                        break;
                    }
                }
                return shape;
            }

            private Shape getArrowShape() {
                Path2D.Float arrow = new Path2D.Float();
                int aw = ARROW_WIDTH.get();
                int ah = ARROW_HEIGHT.get();
                switch (this.direction) {
                    case 5: {
                        ((Path2D)arrow).moveTo(0.0, 0.0);
                        ((Path2D)arrow).lineTo(aw, 0.0);
                        ((Path2D)arrow).lineTo((double)aw / 2.0, ah);
                        arrow.closePath();
                        break;
                    }
                    case 1: {
                        ((Path2D)arrow).moveTo(0.0, 0.0);
                        ((Path2D)arrow).lineTo(aw, 0.0);
                        ((Path2D)arrow).lineTo((double)aw / 2.0, -ah);
                        arrow.closePath();
                        break;
                    }
                }
                return arrow;
            }

            @Override
            public Dimension getPreferredSize() {
                Insets i2 = DarculaSpinnerUI.this.spinner.getInsets();
                int minHeight = DarculaUIUtil.isCompact(DarculaSpinnerUI.this.spinner) ? JBUIScale.scale((int)10) : JBUIScale.scale((int)12);
                return new Dimension(DarculaUIUtil.ARROW_BUTTON_WIDTH.get() + i2.left, minHeight + (this.direction == 1 ? i2.top : i2.bottom));
            }
        };
        b.setInheritsPopupMenu(true);
        b.setBorder((Border)JBUI.Borders.empty());
        return b;
    }

    protected static class LayoutManagerDelegate
    implements LayoutManager {
        protected final LayoutManager myDelegate;

        public LayoutManagerDelegate(LayoutManager delegate2) {
            this.myDelegate = delegate2;
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
            this.myDelegate.addLayoutComponent(name, comp);
        }

        @Override
        public void removeLayoutComponent(Component comp) {
            this.myDelegate.removeLayoutComponent(comp);
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return this.myDelegate.preferredLayoutSize(parent);
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return this.myDelegate.minimumLayoutSize(parent);
        }

        @Override
        public void layoutContainer(Container parent) {
            this.myDelegate.layoutContainer(parent);
        }
    }
}

