/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.startup;

import com.intellij.configurationStore.StorageUtilKt;
import com.intellij.internal.statistic.collectors.fus.project.ProjectFsStatsCollector;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionNotApplicableException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.impl.local.FileWatcher;
import com.intellij.openapi.vfs.impl.local.LocalFileSystemImpl;
import com.intellij.project.ProjectKt;
import com.intellij.util.PathUtil;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.concurrency.NonUrgentExecutor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 \t2\u00020\u0001:\u0001\tB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/ide/startup/CheckFsSanityAndProjectRootPostStartUpActivity;", "Lcom/intellij/openapi/startup/StartupActivity$DumbAware;", "()V", "checkFsSanity", "", "project", "Lcom/intellij/openapi/project/Project;", "checkProjectRoots", "runActivity", "Companion", "intellij.platform.ide.impl"})
public final class CheckFsSanityAndProjectRootPostStartUpActivity
implements StartupActivity.DumbAware {
    private static final Logger LOG;
    @NotNull
    public static final Companion Companion;

    public void runActivity(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        try {
            this.checkFsSanity(project);
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
        }
        NonUrgentExecutor.getInstance().execute(new Runnable(this, project){
            final /* synthetic */ CheckFsSanityAndProjectRootPostStartUpActivity this$0;
            final /* synthetic */ Project $project;

            public final void run() {
                CheckFsSanityAndProjectRootPostStartUpActivity.access$checkProjectRoots(this.this$0, this.$project);
                StorageUtilKt.checkUnknownMacros(this.$project, true);
            }
            {
                this.this$0 = checkFsSanityAndProjectRootPostStartUpActivity;
                this.$project = project;
            }
        });
    }

    private final void checkFsSanity(Project project) {
        boolean bl;
        String path2 = project.getProjectFilePath();
        if (path2 == null || FileUtil.isAncestor((String)PathManager.getConfigPath(), (String)path2, (boolean)true)) {
            return;
        }
        if (ProjectKt.isDirectoryBased(project)) {
            path2 = PathUtil.getParentPath((String)path2);
        }
        boolean expected = SystemInfo.isFileSystemCaseSensitive;
        try {
            bl = FileUtil.isFileSystemCaseSensitive((String)path2);
        }
        catch (FileNotFoundException ignore) {
            return;
        }
        boolean actual = bl;
        LOG.info(path2 + " case-sensitivity: expected=" + expected + " actual=" + actual);
        ProjectFsStatsCollector.caseSensitivity(project, actual);
    }

    private final void checkProjectRoots(Project project) {
        ProjectRootManager projectRootManager = ProjectRootManager.getInstance((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)projectRootManager, (String)"ProjectRootManager.getInstance(project)");
        VirtualFile[] roots = projectRootManager.getContentRoots();
        Intrinsics.checkNotNullExpressionValue((Object)roots, (String)"roots");
        VirtualFile[] virtualFileArray = roots;
        boolean bl = false;
        if (virtualFileArray.length == 0) {
            return;
        }
        LocalFileSystem localFileSystem2 = LocalFileSystem.getInstance();
        if (!(localFileSystem2 instanceof LocalFileSystemImpl)) {
            localFileSystem2 = null;
        }
        LocalFileSystemImpl localFileSystemImpl = (LocalFileSystemImpl)localFileSystem2;
        if (localFileSystemImpl == null) {
            return;
        }
        FileWatcher fileWatcher = localFileSystemImpl.getFileWatcher();
        Intrinsics.checkNotNullExpressionValue((Object)fileWatcher, (String)"(LocalFileSystem.getInst\u2026pl ?: return).fileWatcher");
        FileWatcher watcher = fileWatcher;
        if (!watcher.isOperational()) {
            ProjectFsStatsCollector.watchedRoots(project, -1);
            return;
        }
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(project, watcher, roots){
            final /* synthetic */ Project $project;
            final /* synthetic */ FileWatcher $watcher;
            final /* synthetic */ VirtualFile[] $roots;

            /*
             * Unable to fully structure code
             */
            public final void run() {
                block11: {
                    CheckFsSanityAndProjectRootPostStartUpActivity.access$getLOG$cp().debug("FW/roots waiting started");
                    while (true) {
                        if (this.$project.isDisposed()) {
                            return;
                        }
                        if (!this.$watcher.isSettingRoots()) break;
                        TimeoutUtil.sleep((long)10L);
                    }
                    CheckFsSanityAndProjectRootPostStartUpActivity.access$getLOG$cp().debug("FW/roots waiting finished");
                    v0 = this.$watcher.getManualWatchRoots();
                    Intrinsics.checkNotNullExpressionValue(v0, (String)"watcher.manualWatchRoots");
                    manualWatchRoots = v0;
                    pctNonWatched = 0;
                    var3_3 = manualWatchRoots;
                    var4_4 = false;
                    if (!(var3_3.isEmpty() == false)) break block11;
                    Intrinsics.checkNotNullExpressionValue((Object)this.$roots, (String)"roots");
                    $this$filter$iv = this.$roots;
                    $i$f$filter = false;
                    var6_8 = $this$filter$iv;
                    destination$iv$iv = new ArrayList<E>();
                    $i$f$filterTo = false;
                    for (VirtualFile element$iv$iv : $this$filterTo$iv$iv) {
                        block10: {
                            root = element$iv$iv;
                            $i$a$-filter-CheckFsSanityAndProjectRootPostStartUpActivity$checkProjectRoots$1$unwatched$1 = false;
                            v1 = root;
                            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"root");
                            if (!v1.isInLocalFileSystem()) ** GOTO lbl-1000
                            $this$any$iv = manualWatchRoots;
                            $i$f$any = false;
                            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                v2 = false;
                            } else {
                                for (T element$iv : $this$any$iv) {
                                    it = (String)element$iv;
                                    $i$a$-any-CheckFsSanityAndProjectRootPostStartUpActivity$checkProjectRoots$1$unwatched$1$1 = false;
                                    if (!VfsUtilCore.isAncestorOrSelf((String)it, (VirtualFile)root)) continue;
                                    v2 = true;
                                    break block10;
                                }
                                v2 = false;
                            }
                        }
                        if (v2) {
                            v3 = true;
                        } else lbl-1000:
                        // 2 sources

                        {
                            v3 = false;
                        }
                        if (!v3) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    unwatched = (List)destination$iv$iv;
                    $this$filter$iv = unwatched;
                    $i$f$filter = false;
                    if ($this$filter$iv.isEmpty() == false) {
                        v4 = new Object[1];
                        v5 = ApplicationNamesInfo.getInstance();
                        Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"ApplicationNamesInfo.getInstance()");
                        v4[0] = v5.getFullProductName();
                        v6 = ApplicationBundle.message((String)"watcher.non.watchable.project", (Object[])v4);
                        Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"ApplicationBundle.messag\u2026stance().fullProductName)");
                        message = v6;
                        this.$watcher.notifyOnFailure(message, null);
                        $i$f$filter = unwatched;
                        var22_29 = new StringBuilder().append("unwatched roots: ");
                        var21_30 = CheckFsSanityAndProjectRootPostStartUpActivity.access$getLOG$cp();
                        $i$f$map = false;
                        destination$iv$iv = $this$map$iv;
                        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        $i$f$mapTo = false;
                        for (T item$iv$iv : $this$mapTo$iv$iv) {
                            element$iv$iv = (VirtualFile)item$iv$iv;
                            var23_31 = destination$iv$iv;
                            $i$a$-map-CheckFsSanityAndProjectRootPostStartUpActivity$checkProjectRoots$1$1 = false;
                            v7 = it;
                            Intrinsics.checkNotNullExpressionValue((Object)v7, (String)"it");
                            var24_32 = v7.getPresentableUrl();
                            var23_31.add(var24_32);
                        }
                        var23_31 = (List)destination$iv$iv;
                        var21_30.info(var22_29.append(var23_31).toString());
                        CheckFsSanityAndProjectRootPostStartUpActivity.access$getLOG$cp().info("manual watches: " + manualWatchRoots);
                        pctNonWatched = (int)(100.0 * (double)unwatched.size() / (double)this.$roots.length);
                    }
                }
                ProjectFsStatsCollector.watchedRoots(this.$project, pctNonWatched);
            }
            {
                this.$project = project;
                this.$watcher = fileWatcher;
                this.$roots = virtualFileArray;
            }
        });
    }

    public CheckFsSanityAndProjectRootPostStartUpActivity() {
        block3: {
            block2: {
                Application application = ApplicationManager.getApplication();
                Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
                if (application.isHeadlessEnvironment()) break block2;
                Application application2 = ApplicationManager.getApplication();
                Intrinsics.checkNotNullExpressionValue((Object)application2, (String)"ApplicationManager.getApplication()");
                if (!application2.isUnitTestMode()) break block3;
            }
            ExtensionNotApplicableException extensionNotApplicableException = ExtensionNotApplicableException.INSTANCE;
            Intrinsics.checkNotNullExpressionValue((Object)extensionNotApplicableException, (String)"ExtensionNotApplicableException.INSTANCE");
            throw (Throwable)extensionNotApplicableException;
        }
    }

    static {
        Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(CheckFsSanityAndProjectRootPostStartUpActivity.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        LOG = logger;
    }

    public static final /* synthetic */ void access$checkProjectRoots(CheckFsSanityAndProjectRootPostStartUpActivity $this, Project project) {
        $this.checkProjectRoots(project);
    }

    public static final /* synthetic */ Logger access$getLOG$cp() {
        return LOG;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/ide/startup/CheckFsSanityAndProjectRootPostStartUpActivity$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.platform.ide.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

