/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.scratch;

import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeView;
import com.intellij.ide.actions.NewActionGroup;
import com.intellij.ide.actions.RecentLocationsAction;
import com.intellij.ide.scratch.LRUPopupBuilder;
import com.intellij.ide.scratch.RootType;
import com.intellij.ide.scratch.ScratchFileCreationHelper;
import com.intellij.ide.scratch.ScratchFileService;
import com.intellij.ide.scratch.ScratchImplUtil;
import com.intellij.ide.scratch.ScratchRootType;
import com.intellij.ide.util.DeleteHandler;
import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.idea.ActionsBundle;
import com.intellij.lang.LangBundle;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.lang.PerFileMappings;
import com.intellij.lang.StdLanguages;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.UpdateInBackground;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.command.undo.UnexpectedUndoException;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.ex.IdeDocumentHistory;
import com.intellij.openapi.fileEditor.impl.IdeDocumentHistoryImpl;
import com.intellij.openapi.fileEditor.impl.text.TextEditorState;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.InternalFileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.fileTypes.PlainTextLanguage;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.NaturalComparator;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.LayeredIcon;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.EmptyIcon;
import java.awt.Component;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ScratchFileActions {
    private static int ourCurrentBuffer = 0;

    private static int nextBufferIndex() {
        ourCurrentBuffer = ourCurrentBuffer % Registry.intValue((String)"ide.scratch.buffers") + 1;
        return ourCurrentBuffer;
    }

    @NotNull
    static ScratchFileCreationHelper.Context createContext(@NotNull AnActionEvent e) {
        if (e == null) {
            ScratchFileActions.$$$reportNull$$$0(0);
        }
        Project project = Objects.requireNonNull(e.getProject());
        PsiFile file2 = (PsiFile)e.getData(CommonDataKeys.PSI_FILE);
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        if (file2 == null && editor != null) {
            file2 = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
        }
        return ScratchFileActions.createContext(project, file2, editor, e.getDataContext());
    }

    @NotNull
    static ScratchFileCreationHelper.Context createContext(@NotNull Project project, @Nullable PsiFile file2, @Nullable Editor editor, @NotNull DataContext dataContext) {
        if (project == null) {
            ScratchFileActions.$$$reportNull$$$0(1);
        }
        if (dataContext == null) {
            ScratchFileActions.$$$reportNull$$$0(2);
        }
        ScratchFileCreationHelper.Context context2 = new ScratchFileCreationHelper.Context();
        context2.text = StringUtil.notNullize((String)ScratchFileActions.getSelectionText(editor));
        if (StringUtil.isNotEmpty((String)context2.text)) {
            ScratchFileActions.initLanguageFromCaret(project, editor, file2, context2, dataContext);
        }
        context2.ideView = (IdeView)LangDataKeys.IDE_VIEW.getData(dataContext);
        ScratchFileCreationHelper.Context context3 = context2;
        if (context3 == null) {
            ScratchFileActions.$$$reportNull$$$0(3);
        }
        return context3;
    }

    @Nullable
    static PsiFile doCreateNewScratch(@NotNull Project project, @NotNull ScratchFileCreationHelper.Context context2) {
        LanguageFileType fileType;
        if (project == null) {
            ScratchFileActions.$$$reportNull$$$0(4);
        }
        if (context2 == null) {
            ScratchFileActions.$$$reportNull$$$0(5);
        }
        FeatureUsageTracker.getInstance().triggerFeatureUsed("scratch");
        if (context2.fileExtension == null && context2.language != null && (fileType = context2.language.getAssociatedFileType()) != null) {
            context2.fileExtension = (String)ScratchImplUtil.getFileTypeExtensions((FileType)fileType, true, FileTypeManager.getInstance()).first();
        }
        if (context2.language != null) {
            ScratchFileCreationHelper helper = (ScratchFileCreationHelper)ScratchFileCreationHelper.EXTENSION.forLanguage(context2.language);
            if (StringUtil.isEmpty((String)context2.text)) {
                helper.prepareText(project, context2, DataContext.EMPTY_CONTEXT);
            }
            helper.beforeCreate(project, context2);
        }
        VirtualFile dir = context2.ideView != null ? PsiUtilCore.getVirtualFile((PsiElement)((PsiElement)ArrayUtil.getFirstElement((Object[])context2.ideView.getDirectories()))) : null;
        RootType rootType = dir == null ? null : ScratchFileService.findRootType((VirtualFile)dir);
        String relativePath = rootType != ScratchRootType.getInstance() ? "" : FileUtil.getRelativePath((String)ScratchFileService.getInstance().getRootPath(rootType), (String)dir.getPath(), (char)'/');
        String fileName = (String)(StringUtil.isEmpty((String)relativePath) ? "" : relativePath + "/") + PathUtil.makeFileName((String)((String)ObjectUtils.notNull((Object)context2.filePrefix, (Object)"scratch") + (Serializable)(context2.fileCounter != null ? (Serializable)context2.fileCounter.create() : "")), (String)context2.fileExtension);
        VirtualFile file2 = ScratchRootType.getInstance().createScratchFile(project, fileName, context2.language, context2.text, context2.createOption);
        if (file2 == null) {
            return null;
        }
        Navigatable navigatable = PsiNavigationSupport.getInstance().createNavigatable(project, file2, context2.caretOffset);
        navigatable.navigate(!LaterInvocator.isInModalContextForProject(project));
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file2);
        if (context2.ideView != null && psiFile != null) {
            context2.ideView.selectElement((PsiElement)psiFile);
        }
        return psiFile;
    }

    private static void checkLanguageAndTryToFixText(@NotNull Project project, @NotNull ScratchFileCreationHelper.Context context2, @NotNull DataContext dataContext) {
        if (project == null) {
            ScratchFileActions.$$$reportNull$$$0(6);
        }
        if (context2 == null) {
            ScratchFileActions.$$$reportNull$$$0(7);
        }
        if (dataContext == null) {
            ScratchFileActions.$$$reportNull$$$0(8);
        }
        if (context2.language == null) {
            return;
        }
        ScratchFileCreationHelper handler2 = (ScratchFileCreationHelper)ScratchFileCreationHelper.EXTENSION.forLanguage(context2.language);
        if (handler2.prepareText(project, context2, dataContext)) {
            return;
        }
        PsiFile psiFile = ScratchFileCreationHelper.parseHeader(project, context2.language, context2.text);
        PsiErrorElement firstError = (PsiErrorElement)SyntaxTraverser.psiTraverser((PsiElement)psiFile).traverse().filter(PsiErrorElement.class).first();
        if (firstError != null && firstError.getParent() == psiFile) {
            context2.language = null;
        }
    }

    @Nullable
    static String getSelectionText(@Nullable Editor editor) {
        if (editor == null) {
            return null;
        }
        return editor.getSelectionModel().getSelectedText(true);
    }

    private static void initLanguageFromCaret(@NotNull Project project, @Nullable Editor editor, @Nullable PsiFile psiFile, @NotNull ScratchFileCreationHelper.Context context2, @NotNull DataContext dataContext) {
        if (project == null) {
            ScratchFileActions.$$$reportNull$$$0(9);
        }
        if (context2 == null) {
            ScratchFileActions.$$$reportNull$$$0(10);
        }
        if (dataContext == null) {
            ScratchFileActions.$$$reportNull$$$0(11);
        }
        if (editor == null || psiFile == null) {
            return;
        }
        Caret caret = editor.getCaretModel().getPrimaryCaret();
        int offset = caret.getOffset();
        PsiElement element2 = InjectedLanguageManager.getInstance((Project)project).findInjectedElementAt(psiFile, offset);
        PsiFile file2 = element2 != null ? element2.getContainingFile() : psiFile;
        FileTypeManager fileTypeManager = FileTypeManager.getInstance();
        FileType fileType = ScratchImplUtil.getFileTypeFromName(file2.getName(), fileTypeManager);
        Language language = context2.language = fileType instanceof LanguageFileType ? file2.getLanguage() : null;
        if (fileType != null) {
            context2.fileExtension = (String)ScratchImplUtil.getFileTypeExtensions(fileType, true, fileTypeManager).first();
        }
        if (context2.language == PlainTextLanguage.INSTANCE && file2.getFileType() instanceof InternalFileType) {
            context2.language = StdLanguages.XML;
        }
        ScratchFileActions.checkLanguageAndTryToFixText(project, context2, dataContext);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/scratch/ScratchFileActions";
                break;
            }
            case 5: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/scratch/ScratchFileActions";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createContext";
                break;
            }
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "doCreateNewScratch";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "checkLanguageAndTryToFixText";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "initLanguageFromCaret";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class ExportToScratchAction
    extends DumbAwareAction
    implements UpdateInBackground {
        public ExportToScratchAction() {
            this.setEnabledInModalContext(true);
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                ExportToScratchAction.$$$reportNull$$$0(0);
            }
            Project project = e.getProject();
            Component c = (Component)e.getData(PlatformDataKeys.CONTEXT_COMPONENT);
            ScratchImplUtil.TextExtractor extractor = ScratchImplUtil.getTextExtractor(c);
            boolean isFileEditor = EditorUtil.isRealFileEditor((Editor)e.getData(CommonDataKeys.EDITOR));
            e.getPresentation().setEnabled(project != null && extractor != null && !isFileEditor);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            String text2;
            Project project;
            if (e == null) {
                ExportToScratchAction.$$$reportNull$$$0(1);
            }
            if ((project = e.getProject()) == null) {
                return;
            }
            ScratchImplUtil.TextExtractor extractor = ScratchImplUtil.getTextExtractor((Component)e.getData(PlatformDataKeys.CONTEXT_COMPONENT));
            String string = text2 = extractor == null ? null : extractor.extractText();
            if (text2 == null) {
                return;
            }
            ScratchFileCreationHelper.Context context2 = new ScratchFileCreationHelper.Context();
            context2.text = text2;
            context2.fileExtension = PlainTextFileType.INSTANCE.getDefaultExtension();
            ScratchFileActions.doCreateNewScratch(project, context2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/ide/scratch/ScratchFileActions$ExportToScratchAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class ShowFilesPopupAction
    extends DumbAwareAction
    implements UpdateInBackground {
        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                ShowFilesPopupAction.$$$reportNull$$$0(0);
            }
            e.getPresentation().setEnabledAndVisible(e.getProject() != null);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Project project;
            if (e == null) {
                ShowFilesPopupAction.$$$reportNull$$$0(1);
            }
            if ((project = e.getProject()) == null) {
                return;
            }
            RecentLocationsAction.showPopup(project, false, LangBundle.message((String)"scratch.file.popup.title", (Object[])new Object[0]), LangBundle.message((String)"scratch.file.popup.changed.title", (Object[])new Object[0]), LangBundle.message((String)"scratch.file.popup.title.empty.text", (Object[])new Object[0]), changed2 -> ShowFilesPopupAction.getPlaces(project, changed2), toRemove2 -> ShowFilesPopupAction.removePlaces(project, toRemove2));
        }

        @NotNull
        private static List<IdeDocumentHistoryImpl.PlaceInfo> getPlaces(@NotNull Project project, boolean changed2) {
            Condition condition;
            if (project == null) {
                ShowFilesPopupAction.$$$reportNull$$$0(2);
            }
            String path2 = ScratchFileService.getInstance().getRootPath((RootType)ScratchRootType.getInstance());
            VirtualFile rootDir = LocalFileSystem.getInstance().findFileByPath(path2);
            if (rootDir == null || !rootDir.exists() || !rootDir.isDirectory()) {
                List<IdeDocumentHistoryImpl.PlaceInfo> list2 = Collections.emptyList();
                if (list2 == null) {
                    ShowFilesPopupAction.$$$reportNull$$$0(3);
                }
                return list2;
            }
            if (!changed2) {
                condition = Conditions.alwaysTrue();
            } else {
                Set files2 = JBIterable.from(IdeDocumentHistory.getInstance(project).getChangePlaces()).map(o -> o.getFile()).toSet();
                condition = files2::contains;
            }
            final ArrayList<IdeDocumentHistoryImpl.PlaceInfo> result2 = new ArrayList<IdeDocumentHistoryImpl.PlaceInfo>();
            VfsUtilCore.visitChildrenRecursively((VirtualFile)rootDir, (VirtualFileVisitor)new VirtualFileVisitor<Object>(new VirtualFileVisitor.Option[]{VirtualFileVisitor.SKIP_ROOT}){

                public boolean visitFile(@NotNull VirtualFile file2) {
                    if (file2 == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (file2.isDirectory() || !file2.isValid() || !condition.value((Object)file2)) {
                        return true;
                    }
                    Document document = FileDocumentManager.getInstance().getDocument(file2);
                    if (document == null) {
                        return true;
                    }
                    RangeMarker caret = document.createRangeMarker(0, 0);
                    result2.add(new IdeDocumentHistoryImpl.PlaceInfo(file2, new TextEditorState(), "text-editor", null, caret));
                    return result2.size() < 1000;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/ide/scratch/ScratchFileActions$ShowFilesPopupAction$1", "visitFile"));
                }
            });
            Collections.sort(result2, Comparator.comparing(o -> o.getFile().getName(), NaturalComparator.INSTANCE));
            ArrayList<IdeDocumentHistoryImpl.PlaceInfo> arrayList = result2;
            if (arrayList == null) {
                ShowFilesPopupAction.$$$reportNull$$$0(4);
            }
            return arrayList;
        }

        private static void removePlaces(@NotNull Project project, @NotNull List<IdeDocumentHistoryImpl.PlaceInfo> toRemove2) {
            if (project == null) {
                ShowFilesPopupAction.$$$reportNull$$$0(5);
            }
            if (toRemove2 == null) {
                ShowFilesPopupAction.$$$reportNull$$$0(6);
            }
            PsiManager psiManager = PsiManager.getInstance((Project)project);
            List files2 = ContainerUtil.mapNotNull(toRemove2, o -> psiManager.findFile(o.getFile()));
            DeleteHandler.deletePsiElement(files2.toArray(PsiElement.EMPTY_ARRAY), project, false);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 2: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/scratch/ScratchFileActions$ShowFilesPopupAction";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "toRemove";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/scratch/ScratchFileActions$ShowFilesPopupAction";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPlaces";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getPlaces";
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "removePlaces";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class ChangeLanguageAction
    extends DumbAwareAction
    implements UpdateInBackground {
        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                ChangeLanguageAction.$$$reportNull$$$0(0);
            }
            Project project = e.getProject();
            JBIterable files2 = JBIterable.of((Object[])((VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY)));
            if (project == null || files2.isEmpty()) {
                e.getPresentation().setEnabledAndVisible(false);
                return;
            }
            Condition<VirtualFile> isScratch = this.fileFilter(project);
            if (!files2.filter(Conditions.not(isScratch)).isEmpty()) {
                e.getPresentation().setEnabledAndVisible(false);
                return;
            }
            FileTypeManager fileTypeManager = FileTypeManager.getInstance();
            Set languages = files2.filter(isScratch).map(file2 -> {
                Language language;
                Language language2 = language = LanguageUtil.getFileLanguage((VirtualFile)file2) == null ? null : this.fileLanguage(project, (VirtualFile)file2);
                if (language != null) {
                    return language.getDisplayName();
                }
                return fileTypeManager.getFileTypeByFileName(file2.getName()).getDisplayName();
            }).toSet();
            String langName = languages.size() == 1 ? (String)languages.iterator().next() : LangBundle.message((String)"scratch.file.actions.0.different.languages.number", (Object[])new Object[]{languages.size()});
            e.getPresentation().setText(this.getChangeLanguageActionName(langName));
            e.getPresentation().setEnabledAndVisible(true);
        }

        @Deprecated
        @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
        @NotNull
        protected String getLanguageTerm() {
            return "Language";
        }

        @NotNull
        @Nls
        protected String getChangeLanguageActionName(@NotNull String languageName) {
            if (languageName == null) {
                ChangeLanguageAction.$$$reportNull$$$0(1);
            }
            String string = LangBundle.message((String)"scratch.file.action.change.language.action", (Object[])new Object[]{languageName});
            if (string == null) {
                ChangeLanguageAction.$$$reportNull$$$0(2);
            }
            return string;
        }

        @NotNull
        @Nls
        protected String getChangeLanguageTitle() {
            String string = LangBundle.message((String)"scratch.file.action.change.language.title", (Object[])new Object[0]);
            if (string == null) {
                ChangeLanguageAction.$$$reportNull$$$0(3);
            }
            return string;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Project project;
            if (e == null) {
                ChangeLanguageAction.$$$reportNull$$$0(4);
            }
            if ((project = e.getProject()) == null) {
                return;
            }
            JBIterable files2 = JBIterable.of((Object[])((VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY))).filter(this.fileFilter(project));
            if (files2.isEmpty()) {
                return;
            }
            this.actionPerformedImpl(e, project, this.getChangeLanguageTitle(), (JBIterable<? extends VirtualFile>)files2);
        }

        @NotNull
        protected Condition<VirtualFile> fileFilter(@NotNull Project project) {
            if (project == null) {
                ChangeLanguageAction.$$$reportNull$$$0(5);
            }
            Condition condition = file2 -> !file2.isDirectory() && ScratchRootType.getInstance().containsFile((VirtualFile)file2);
            if (condition == null) {
                ChangeLanguageAction.$$$reportNull$$$0(6);
            }
            return condition;
        }

        @Nullable
        protected Language fileLanguage(@NotNull Project project, @NotNull VirtualFile file2) {
            Language lang;
            if (project == null) {
                ChangeLanguageAction.$$$reportNull$$$0(7);
            }
            if (file2 == null) {
                ChangeLanguageAction.$$$reportNull$$$0(8);
            }
            return (lang = (Language)ScratchFileService.getInstance().getScratchesMapping().getMapping(file2)) != null ? lang : LanguageUtil.getLanguageForPsi((Project)project, (VirtualFile)file2);
        }

        protected void actionPerformedImpl(@NotNull AnActionEvent e, @NotNull Project project, @NotNull @NlsContexts.PopupTitle String title2, @NotNull JBIterable<? extends VirtualFile> files2) {
            if (e == null) {
                ChangeLanguageAction.$$$reportNull$$$0(9);
            }
            if (project == null) {
                ChangeLanguageAction.$$$reportNull$$$0(10);
            }
            if (title2 == null) {
                ChangeLanguageAction.$$$reportNull$$$0(11);
            }
            if (files2 == null) {
                ChangeLanguageAction.$$$reportNull$$$0(12);
            }
            ScratchFileService fileService = ScratchFileService.getInstance();
            PerFileMappings mapping2 = fileService.getScratchesMapping();
            VirtualFile[] filesCopy = VfsUtilCore.toVirtualFileArray((Collection)JBIterable.from(files2).toList());
            Arrays.sort(filesCopy, (o1, o2) -> StringUtil.compare((String)o1.getName(), (String)o2.getName(), (!o1.isCaseSensitive() ? 1 : 0) != 0));
            ScratchImplUtil.buildLanguagesPopup(project, title2).onChosen((Consumer<ScratchImplUtil.LanguageItem>)((Consumer)item -> {
                try {
                    WriteCommandAction.writeCommandAction((Project)project).withName(LangBundle.message((String)"command.name.change.language", (Object[])new Object[0])).run(() -> ScratchImplUtil.changeLanguageWithUndo(project, item, filesCopy, (PerFileMappings<Language>)mapping2));
                }
                catch (UnexpectedUndoException e1) {
                    ExceptionUtil.rethrowUnchecked((Throwable)e1);
                }
            })).buildPopup().showCenteredInCurrentWindow(project);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "languageName";
                    break;
                }
                case 2: 
                case 3: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/scratch/ScratchFileActions$ChangeLanguageAction";
                    break;
                }
                case 5: 
                case 7: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "title";
                    break;
                }
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "files";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/scratch/ScratchFileActions$ChangeLanguageAction";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChangeLanguageActionName";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChangeLanguageTitle";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "fileFilter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getChangeLanguageActionName";
                    break;
                }
                case 2: 
                case 3: 
                case 6: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "fileFilter";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "fileLanguage";
                    break;
                }
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformedImpl";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class NewBufferAction
    extends DumbAwareAction
    implements UpdateInBackground {
        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                NewBufferAction.$$$reportNull$$$0(0);
            }
            boolean enabled = e.getProject() != null && Registry.intValue((String)"ide.scratch.buffers") > 0;
            e.getPresentation().setEnabledAndVisible(enabled);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Project project;
            if (e == null) {
                NewBufferAction.$$$reportNull$$$0(1);
            }
            if ((project = e.getProject()) == null) {
                return;
            }
            ScratchFileCreationHelper.Context context2 = new ScratchFileCreationHelper.Context();
            context2.filePrefix = "buffer";
            context2.createOption = ScratchFileService.Option.create_if_missing;
            context2.fileCounter = () -> ScratchFileActions.nextBufferIndex();
            context2.language = PlainTextLanguage.INSTANCE;
            ScratchFileActions.doCreateNewScratch(project, context2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/ide/scratch/ScratchFileActions$NewBufferAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class NewFileAction
    extends DumbAwareAction
    implements UpdateInBackground {
        private static final Icon ICON = LayeredIcon.create(AllIcons.FileTypes.Text, AllIcons.Actions.Scratch);
        private static final String ACTION_ID = "NewScratchFile";
        private final NotNullLazyValue<@Nls String> myActionText = NotNullLazyValue.createValue(() -> NewActionGroup.isActionInNewPopupMenu((AnAction)this) ? ActionsBundle.actionText((String)ACTION_ID) : ActionsBundle.message((String)"action.NewScratchFile.text.with.new", (Object[])new Object[0]));

        public NewFileAction() {
            this.getTemplatePresentation().setIcon(ICON);
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                NewFileAction.$$$reportNull$$$0(0);
            }
            this.getTemplatePresentation().setText((String)this.myActionText.getValue());
            Project project = e.getProject();
            String place = e.getPlace();
            boolean enabled = project != null && (e.isFromActionToolbar() || ActionPlaces.isMainMenuOrActionSearch((String)place) || ActionPlaces.isPopupPlace((String)place) && e.getData(LangDataKeys.IDE_VIEW) != null);
            e.getPresentation().setEnabledAndVisible(enabled);
            this.updatePresentationTextAndIcon(e, e.getPresentation());
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Project project;
            if (e == null) {
                NewFileAction.$$$reportNull$$$0(1);
            }
            if ((project = e.getProject()) == null) {
                return;
            }
            Component component2 = (Component)e.getData(PlatformDataKeys.CONTEXT_COMPONENT);
            ScratchFileCreationHelper.Context context2 = ScratchFileActions.createContext(e);
            ScratchImplUtil.LanguageItem selectionItem = context2.language != null ? ScratchImplUtil.LanguageItem.fromLanguage(context2.language) : (context2.fileExtension != null ? new ScratchImplUtil.LanguageItem(null, FileTypeManager.getInstance().getFileTypeByExtension(context2.fileExtension), context2.fileExtension) : (StringUtil.isNotEmpty((String)context2.text) ? new ScratchImplUtil.LanguageItem(null, (FileType)PlainTextFileType.INSTANCE, PlainTextFileType.INSTANCE.getDefaultExtension()) : null));
            ScratchImplUtil.TextExtractor textExtractor = selectionItem == null ? ScratchImplUtil.getTextExtractor(component2) : null;
            ScratchImplUtil.LanguageItem extractItem = textExtractor != null && StringUtil.isEmpty((String)context2.text) && !EditorUtil.isRealFileEditor((Editor)e.getData(CommonDataKeys.EDITOR)) ? new ScratchImplUtil.LanguageItem(null, (FileType)PlainTextFileType.INSTANCE, PlainTextFileType.INSTANCE.getDefaultExtension()) : null;
            Consumer consumer = o -> {
                context2.language = o.language;
                context2.fileExtension = o.fileExtension;
                if (o == extractItem) {
                    context2.text = StringUtil.notNullize((String)textExtractor.extractText());
                    context2.caretOffset = 0;
                } else if (o != selectionItem) {
                    context2.text = "";
                    context2.caretOffset = 0;
                }
                ScratchFileActions.doCreateNewScratch(project, context2);
            };
            if (selectionItem != null && ApplicationManager.getApplication().isUnitTestMode()) {
                consumer.consume((Object)selectionItem);
                return;
            }
            LRUPopupBuilder<ScratchImplUtil.LanguageItem> builder2 = ScratchImplUtil.buildLanguagesPopup(project, ActionsBundle.message((String)"action.NewScratchFile.text.with.new", (Object[])new Object[0]));
            if (selectionItem != null) {
                String displayName = LangBundle.message((String)"scratch.file.action.new.from.selection", (Object[])new Object[]{selectionItem.fileType.getDisplayName()});
                builder2.withExtraTopValue(selectionItem, displayName, EmptyIcon.ICON_16);
            } else if (extractItem != null) {
                String displayName = LangBundle.message((String)"scratch.file.action.new.from.ui", (Object[])new Object[0]);
                if (textExtractor.hasSelection()) {
                    builder2.withExtraTopValue(extractItem, displayName, EmptyIcon.ICON_16);
                } else {
                    builder2.withExtraMiddleValue(extractItem, displayName, EmptyIcon.ICON_16);
                }
            }
            builder2.onChosen((Consumer<ScratchImplUtil.LanguageItem>)consumer).buildPopup().showCenteredInCurrentWindow(project);
        }

        private void updatePresentationTextAndIcon(@NotNull AnActionEvent e, @NotNull Presentation presentation2) {
            if (e == null) {
                NewFileAction.$$$reportNull$$$0(2);
            }
            if (presentation2 == null) {
                NewFileAction.$$$reportNull$$$0(3);
            }
            presentation2.setText((String)this.myActionText.getValue());
            presentation2.setIcon(ICON);
            if ("MainMenu".equals(e.getPlace()) && !NewActionGroup.isActionInNewPopupMenu((AnAction)this)) {
                presentation2.setIcon(null);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "presentation";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ide/scratch/ScratchFileActions$NewFileAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "updatePresentationTextAndIcon";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

