/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl;

import com.intellij.ide.dnd.aware.DnDAwareTree;
import com.intellij.ide.projectView.impl.ProjectViewRenderer;
import com.intellij.ide.util.treeView.PresentableNodeDescriptor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.presentation.FilePresentationService;
import com.intellij.psi.PsiElement;
import com.intellij.ui.popup.HintUpdateSupply;
import com.intellij.ui.tabs.FileColorManagerImpl;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.Color;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectViewTree
extends DnDAwareTree {
    private static final Logger LOG = Logger.getInstance(ProjectViewTree.class);

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2022.2")
    protected ProjectViewTree(Project project, TreeModel model2) {
        this(model2);
    }

    public ProjectViewTree(TreeModel model2) {
        super((TreeModel)null);
        this.setLargeModel(true);
        this.setModel(model2);
        this.setCellRenderer(this.createCellRenderer());
        HintUpdateSupply.installDataContextHintUpdateSupply((JComponent)((Object)this));
    }

    @NotNull
    protected TreeCellRenderer createCellRenderer() {
        return new ProjectViewRenderer();
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    public DefaultMutableTreeNode getSelectedNode() {
        TreePath path2 = TreeUtil.getSelectedPathIfOne((JTree)((Object)this));
        return path2 == null ? null : (DefaultMutableTreeNode)ObjectUtils.tryCast((Object)path2.getLastPathComponent(), DefaultMutableTreeNode.class);
    }

    public void setToggleClickCount(int count) {
        if (count != 2) {
            LOG.info((Throwable)new IllegalStateException("setToggleClickCount: unexpected count = " + count));
        }
        super.setToggleClickCount(count);
    }

    public boolean isFileColorsEnabled() {
        return ProjectViewTree.isFileColorsEnabledFor((JTree)((Object)this));
    }

    public static boolean isFileColorsEnabledFor(JTree tree) {
        boolean enabled = FileColorManagerImpl._isEnabled() && FileColorManagerImpl._isEnabledForProjectView();
        boolean opaque = tree.isOpaque();
        if (enabled && opaque) {
            tree.setOpaque(false);
        } else if (!enabled && !opaque) {
            tree.setOpaque(true);
        }
        return enabled;
    }

    @Nullable
    public Color getFileColorFor(Object object) {
        if (object instanceof DefaultMutableTreeNode) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)object;
            object = node.getUserObject();
        }
        if (object instanceof PresentableNodeDescriptor) {
            return ((PresentableNodeDescriptor)object).getPresentation().getBackground();
        }
        return null;
    }

    @Nullable
    public static Color getColorForElement(@Nullable PsiElement psi) {
        if (psi == null || !psi.isValid()) {
            return null;
        }
        Project project = psi.getProject();
        return FilePresentationService.getInstance((Project)project).getFileBackgroundColor(psi);
    }
}

