/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl;

import com.intellij.application.options.OptionId;
import com.intellij.application.options.OptionsApplicabilityFilter;
import com.intellij.ide.CopyPasteDelegator;
import com.intellij.ide.DeleteProvider;
import com.intellij.ide.FileEditorProvider;
import com.intellij.ide.FileSelectInContext;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.IdeView;
import com.intellij.ide.SelectInContext;
import com.intellij.ide.SelectInTarget;
import com.intellij.ide.SmartSelectInContext;
import com.intellij.ide.dnd.aware.DnDAwareTree;
import com.intellij.ide.impl.ProjectViewSelectInTarget;
import com.intellij.ide.projectView.ProjectView;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.impl.AbstractProjectViewPSIPane;
import com.intellij.ide.projectView.impl.AbstractProjectViewPane;
import com.intellij.ide.projectView.impl.IdeViewForProjectViewPane;
import com.intellij.ide.projectView.impl.ModuleGroup;
import com.intellij.ide.projectView.impl.ProjectRootsUtil;
import com.intellij.ide.projectView.impl.ProjectViewDeleteElementProvider;
import com.intellij.ide.projectView.impl.ProjectViewListener;
import com.intellij.ide.projectView.impl.ProjectViewSharedSettings;
import com.intellij.ide.projectView.impl.ProjectViewState;
import com.intellij.ide.projectView.impl.nodes.LibraryGroupElement;
import com.intellij.ide.projectView.impl.nodes.LibraryGroupNode;
import com.intellij.ide.projectView.impl.nodes.NamedLibraryElement;
import com.intellij.ide.projectView.impl.nodes.NamedLibraryElementNode;
import com.intellij.ide.projectView.impl.nodes.ProjectViewDirectoryHelper;
import com.intellij.ide.projectView.impl.nodes.PsiDirectoryNode;
import com.intellij.ide.scopeView.ScopeViewPane;
import com.intellij.ide.ui.SplitterProportionsDataImpl;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.util.treeView.AbstractTreeBuilder;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.idea.ActionsBundle;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.service.fus.collectors.FUCounterUsageLogger;
import com.intellij.lang.LangBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ToggleOptionAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.EditorEventMulticaster;
import com.intellij.openapi.editor.ex.EditorEventMulticasterEx;
import com.intellij.openapi.editor.ex.FocusChangeListener;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.module.UnloadedModuleDescription;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LibraryOrSdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleFileIndex;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.ui.configuration.actions.ModuleDeleteProvider;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.SimpleToolWindowPanel;
import com.intellij.openapi.ui.SplitterProportionsData;
import com.intellij.openapi.ui.popup.IPopupChooserBuilder;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.BusyObject;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowContentUiType;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowEx;
import com.intellij.openapi.wm.ex.ToolWindowManagerListener;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.AutoScrollFromSourceHandler;
import com.intellij.ui.AutoScrollToSourceHandler;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.GuiUtils;
import com.intellij.ui.IdeUICustomization;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.ui.switcher.QuickActionProvider;
import com.intellij.ui.tree.TreePathUtil;
import com.intellij.ui.tree.TreeVisitor;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IJSwingUtilities;
import com.intellij.util.PlatformUtils;
import com.intellij.util.SmartList;
import com.intellij.util.ThreeState;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.FocusEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="ProjectView", storages={@Storage(value="$PRODUCT_WORKSPACE_FILE$")})
public class ProjectViewImpl
extends ProjectView
implements PersistentStateComponent<Element>,
QuickActionProvider,
BusyObject {
    private static final Logger LOG = Logger.getInstance(ProjectViewImpl.class);
    private static final Key<String> ID_KEY = Key.create((String)"pane-id");
    private static final Key<String> SUB_ID_KEY = Key.create((String)"pane-sub-id");
    private final CopyPasteDelegator myCopyPasteDelegator;
    private boolean isInitialized;
    private final AtomicBoolean myExtensionsLoaded;
    @NotNull
    private final Project myProject;
    private final ProjectViewState myCurrentState;
    private final Option myAbbreviatePackageNames;
    private final Option myAutoscrollFromSource;
    private final Option myAutoscrollToSource;
    private final Option myOpenInPreviewTab;
    private final Option myCompactDirectories;
    private final Option myFlattenModules;
    private final Option myFlattenPackages;
    private final Option myFoldersAlwaysOnTop;
    private final Option myHideEmptyMiddlePackages;
    private final Option myManualOrder;
    private final Option myShowExcludedFiles;
    private final Option myShowLibraryContents;
    private final Option myShowMembers;
    private final Option myShowModules;
    private final Option myShowVisibilityIcons;
    private final Option mySortByType;
    private String myCurrentViewId;
    private String myCurrentViewSubId;
    private final AutoScrollToSourceHandler myAutoScrollToSourceHandler;
    private final MyAutoScrollFromSourceHandler myAutoScrollFromSourceHandler;
    private volatile ThreeState myCurrentSelectionObsolete;
    private final AtomicBoolean myAutoScrollOnFocusEditor;
    private final IdeView myIdeView;
    private final MyDeletePSIElementProvider myDeletePSIElementProvider;
    private SimpleToolWindowPanel myPanel;
    private final Map<String, AbstractProjectViewPane> myId2Pane;
    private final Collection<AbstractProjectViewPane> myUninitializedPanes;
    private DefaultActionGroup myActionGroup;
    @Nullable
    private String mySavedPaneId;
    @Nullable
    private String mySavedPaneSubId;
    @NonNls
    private static final String ELEMENT_NAVIGATOR = "navigator";
    @NonNls
    private static final String ELEMENT_PANES = "panes";
    @NonNls
    private static final String ELEMENT_PANE = "pane";
    @NonNls
    private static final String ATTRIBUTE_CURRENT_VIEW = "currentView";
    @NonNls
    private static final String ATTRIBUTE_CURRENT_SUBVIEW = "currentSubView";
    private static final String ATTRIBUTE_ID = "id";
    private JPanel myViewContentPanel;
    private static final Comparator<AbstractProjectViewPane> PANE_WEIGHT_COMPARATOR = Comparator.comparingInt(AbstractProjectViewPane::getWeight);
    private final MyPanel myDataProvider;
    private final SplitterProportionsData splitterProportions;
    private final Map<String, Element> myUninitializedPaneState;
    private final Map<String, SelectInTarget> mySelectInTargets;
    private ContentManager myContentManager;

    public ProjectViewImpl(@NotNull Project project) {
        if (project == null) {
            ProjectViewImpl.$$$reportNull$$$0(0);
        }
        this.myExtensionsLoaded = new AtomicBoolean(false);
        this.myAbbreviatePackageNames = new Option(){

            @Override
            public boolean isEnabled(@NotNull AbstractProjectViewPane pane2) {
                if (pane2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                return ProjectViewImpl.this.myFlattenPackages.isSelected() && ProjectViewImpl.this.myFlattenPackages.isEnabled(pane2) && pane2.supportsAbbreviatePackageNames();
            }

            public boolean isSelected() {
                return ProjectViewImpl.this.myCurrentState.getAbbreviatePackageNames();
            }

            public void setSelected(boolean selected2) {
                if (ProjectViewImpl.this.myProject.isDisposed()) {
                    return;
                }
                boolean updated = selected2 != this.isSelected();
                ProjectViewImpl.this.myCurrentState.setAbbreviatePackageNames(selected2);
                ProjectViewImpl.getDefaultState().setAbbreviatePackageNames(selected2);
                ProjectViewImpl.getGlobalOptions().setAbbreviatePackages(selected2);
                if (updated) {
                    ProjectViewImpl.this.updatePanes(false);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ProjectViewImpl.ELEMENT_PANE, "com/intellij/ide/projectView/impl/ProjectViewImpl$1", "isEnabled"));
            }
        };
        this.myAutoscrollFromSource = new Option(){

            public boolean isSelected() {
                return ProjectViewImpl.this.myCurrentState.getAutoscrollFromSource();
            }

            public void setSelected(boolean selected2) {
                if (ProjectViewImpl.this.myProject.isDisposed()) {
                    return;
                }
                ProjectViewImpl.this.myCurrentState.setAutoscrollFromSource(selected2);
                ProjectViewImpl.getDefaultState().setAutoscrollFromSource(selected2);
                ProjectViewImpl.getGlobalOptions().setAutoscrollFromSource(selected2);
                if (selected2 && !ProjectViewImpl.this.myAutoScrollFromSourceHandler.isCurrentProjectViewPaneFocused()) {
                    ProjectViewImpl.this.myAutoScrollFromSourceHandler.scrollFromSource(false);
                }
            }
        };
        this.myAutoscrollToSource = new Option(){

            public boolean isSelected() {
                return ProjectViewImpl.this.myCurrentState.getAutoscrollToSource();
            }

            public void setSelected(boolean selected2) {
                if (ProjectViewImpl.this.myProject.isDisposed()) {
                    return;
                }
                ProjectViewImpl.this.myCurrentState.setAutoscrollToSource(selected2);
                ProjectViewImpl.getDefaultState().setAutoscrollToSource(selected2);
                ProjectViewImpl.getGlobalOptions().setAutoscrollToSource(selected2);
            }
        };
        this.myOpenInPreviewTab = new Option(){

            public boolean isSelected() {
                return UISettings.getInstance().getOpenInPreviewTabIfPossible();
            }

            public void setSelected(boolean selected2) {
                UISettings.getInstance().setOpenInPreviewTabIfPossible(selected2);
            }
        };
        this.myCompactDirectories = new Option(){

            @Override
            public boolean isEnabled(@NotNull AbstractProjectViewPane pane2) {
                if (pane2 == null) {
                    5.$$$reportNull$$$0(0);
                }
                return pane2.supportsCompactDirectories();
            }

            public boolean isSelected() {
                return ProjectViewImpl.this.myCurrentState.getCompactDirectories();
            }

            public void setSelected(boolean selected2) {
                if (ProjectViewImpl.this.myProject.isDisposed()) {
                    return;
                }
                boolean updated = selected2 != this.isSelected();
                ProjectViewImpl.this.myCurrentState.setCompactDirectories(selected2);
                ProjectViewImpl.getDefaultState().setCompactDirectories(selected2);
                ProjectViewImpl.getGlobalOptions().setCompactDirectories(selected2);
                if (updated) {
                    ProjectViewImpl.this.updatePanes(false);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ProjectViewImpl.ELEMENT_PANE, "com/intellij/ide/projectView/impl/ProjectViewImpl$5", "isEnabled"));
            }
        };
        this.myFlattenModules = new Option(){

            @Override
            public boolean isEnabled(@NotNull AbstractProjectViewPane pane2) {
                if (pane2 == null) {
                    6.$$$reportNull$$$0(0);
                }
                return pane2.supportsFlattenModules();
            }

            public boolean isSelected() {
                return ProjectViewImpl.this.myCurrentState.getFlattenModules();
            }

            public void setSelected(boolean selected2) {
                if (ProjectViewImpl.this.myProject.isDisposed()) {
                    return;
                }
                boolean updated = selected2 != this.isSelected();
                ProjectViewImpl.this.myCurrentState.setFlattenModules(selected2);
                ProjectViewImpl.getDefaultState().setFlattenModules(selected2);
                ProjectViewImpl.getGlobalOptions().setFlattenModules(selected2);
                if (updated) {
                    ProjectViewImpl.this.updatePanes(false);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ProjectViewImpl.ELEMENT_PANE, "com/intellij/ide/projectView/impl/ProjectViewImpl$6", "isEnabled"));
            }
        };
        this.myFlattenPackages = new Option(){

            @Override
            public boolean isEnabled(@NotNull AbstractProjectViewPane pane2) {
                if (pane2 == null) {
                    7.$$$reportNull$$$0(0);
                }
                return ProjectViewDirectoryHelper.getInstance(ProjectViewImpl.this.myProject).supportsFlattenPackages();
            }

            public boolean isSelected() {
                return ProjectViewImpl.this.myCurrentState.getFlattenPackages();
            }

            public void setSelected(boolean selected2) {
                if (ProjectViewImpl.this.myProject.isDisposed()) {
                    return;
                }
                boolean updated = selected2 != this.isSelected();
                ProjectViewImpl.this.myCurrentState.setFlattenPackages(selected2);
                ProjectViewImpl.getDefaultState().setFlattenPackages(selected2);
                ProjectViewImpl.getGlobalOptions().setFlattenPackages(selected2);
                if (updated) {
                    ProjectViewImpl.this.updatePanes(false);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ProjectViewImpl.ELEMENT_PANE, "com/intellij/ide/projectView/impl/ProjectViewImpl$7", "isEnabled"));
            }
        };
        this.myFoldersAlwaysOnTop = new Option(){

            @Override
            public boolean isEnabled(@NotNull AbstractProjectViewPane pane2) {
                if (pane2 == null) {
                    8.$$$reportNull$$$0(0);
                }
                return pane2.supportsFoldersAlwaysOnTop();
            }

            public boolean isSelected() {
                return ProjectViewImpl.this.myCurrentState.getFoldersAlwaysOnTop();
            }

            public void setSelected(boolean selected2) {
                if (ProjectViewImpl.this.myProject.isDisposed()) {
                    return;
                }
                boolean updated = selected2 != this.isSelected();
                ProjectViewImpl.this.myCurrentState.setFoldersAlwaysOnTop(selected2);
                ProjectViewImpl.getDefaultState().setFoldersAlwaysOnTop(selected2);
                ProjectViewImpl.getGlobalOptions().setFoldersAlwaysOnTop(selected2);
                if (updated) {
                    ProjectViewImpl.this.updatePanes(true);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ProjectViewImpl.ELEMENT_PANE, "com/intellij/ide/projectView/impl/ProjectViewImpl$8", "isEnabled"));
            }
        };
        this.myHideEmptyMiddlePackages = new Option(){

            @NotNull
            public String getName() {
                String string = ProjectViewImpl.this.myFlattenPackages.isSelected() ? IdeBundle.message((String)"action.hide.empty.middle.packages", (Object[])new Object[0]) : IdeBundle.message((String)"action.compact.empty.middle.packages", (Object[])new Object[0]);
                if (string == null) {
                    9.$$$reportNull$$$0(0);
                }
                return string;
            }

            public String getDescription() {
                return ProjectViewImpl.this.myFlattenPackages.isSelected() ? IdeBundle.message((String)"action.show.hide.empty.middle.packages", (Object[])new Object[0]) : IdeBundle.message((String)"action.show.compact.empty.middle.packages", (Object[])new Object[0]);
            }

            @Override
            public boolean isEnabled(@NotNull AbstractProjectViewPane pane2) {
                if (pane2 == null) {
                    9.$$$reportNull$$$0(1);
                }
                return pane2.supportsHideEmptyMiddlePackages() && ProjectViewDirectoryHelper.getInstance(ProjectViewImpl.this.myProject).supportsHideEmptyMiddlePackages();
            }

            public boolean isSelected() {
                return ProjectViewImpl.this.myCurrentState.getHideEmptyMiddlePackages();
            }

            public void setSelected(boolean selected2) {
                if (ProjectViewImpl.this.myProject.isDisposed()) {
                    return;
                }
                boolean updated = selected2 != this.isSelected();
                ProjectViewImpl.this.myCurrentState.setHideEmptyMiddlePackages(selected2);
                ProjectViewImpl.getDefaultState().setHideEmptyMiddlePackages(selected2);
                ProjectViewImpl.getGlobalOptions().setHideEmptyPackages(selected2);
                if (updated) {
                    ProjectViewImpl.this.updatePanes(false);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 1: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 1: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/ide/projectView/impl/ProjectViewImpl$9";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = ProjectViewImpl.ELEMENT_PANE;
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getName";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/ide/projectView/impl/ProjectViewImpl$9";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "isEnabled";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        this.myManualOrder = new Option(){

            @NotNull
            public String getName() {
                AbstractProjectViewPane pane2 = ProjectViewImpl.this.getCurrentProjectViewPane();
                String string = pane2 != null ? pane2.getManualOrderOptionText() : IdeBundle.message((String)"action.manual.order", (Object[])new Object[0]);
                if (string == null) {
                    10.$$$reportNull$$$0(0);
                }
                return string;
            }

            @Override
            public boolean isEnabled(@NotNull AbstractProjectViewPane pane2) {
                if (pane2 == null) {
                    10.$$$reportNull$$$0(1);
                }
                return pane2.supportsManualOrder();
            }

            public boolean isSelected() {
                return ProjectViewImpl.this.myCurrentState.getManualOrder();
            }

            public void setSelected(boolean selected2) {
                if (ProjectViewImpl.this.myProject.isDisposed()) {
                    return;
                }
                boolean updated = selected2 != this.isSelected();
                ProjectViewImpl.this.myCurrentState.setManualOrder(selected2);
                ProjectViewImpl.getDefaultState().setManualOrder(selected2);
                ProjectViewImpl.getGlobalOptions().setManualOrder(selected2);
                if (updated) {
                    ProjectViewImpl.this.updatePanes(true);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 1: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 1: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/ide/projectView/impl/ProjectViewImpl$10";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = ProjectViewImpl.ELEMENT_PANE;
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getName";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/ide/projectView/impl/ProjectViewImpl$10";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "isEnabled";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        this.myShowExcludedFiles = new Option(){

            @Override
            public boolean isEnabled(@NotNull AbstractProjectViewPane pane2) {
                if (pane2 == null) {
                    11.$$$reportNull$$$0(0);
                }
                return pane2.supportsShowExcludedFiles();
            }

            public boolean isSelected() {
                return ProjectViewImpl.this.myCurrentState.getShowExcludedFiles();
            }

            public void setSelected(boolean selected2) {
                if (ProjectViewImpl.this.myProject.isDisposed()) {
                    return;
                }
                boolean updated = selected2 != this.isSelected();
                ProjectViewImpl.this.myCurrentState.setShowExcludedFiles(selected2);
                ProjectViewImpl.getDefaultState().setShowExcludedFiles(selected2);
                ProjectViewImpl.getGlobalOptions().setShowExcludedFiles(selected2);
                if (updated) {
                    ProjectViewImpl.this.updatePanes(false);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ProjectViewImpl.ELEMENT_PANE, "com/intellij/ide/projectView/impl/ProjectViewImpl$11", "isEnabled"));
            }
        };
        this.myShowLibraryContents = new Option(){

            @Override
            public boolean isEnabled(@NotNull AbstractProjectViewPane pane2) {
                if (pane2 == null) {
                    12.$$$reportNull$$$0(0);
                }
                return pane2.supportsShowLibraryContents();
            }

            public boolean isSelected() {
                return ProjectViewImpl.this.myCurrentState.getShowLibraryContents();
            }

            public void setSelected(boolean selected2) {
                if (ProjectViewImpl.this.myProject.isDisposed()) {
                    return;
                }
                boolean updated = selected2 != this.isSelected();
                ProjectViewImpl.this.myCurrentState.setShowLibraryContents(selected2);
                ProjectViewImpl.getDefaultState().setShowLibraryContents(selected2);
                ProjectViewImpl.getGlobalOptions().setShowLibraryContents(selected2);
                if (updated) {
                    ProjectViewImpl.this.updatePanes(false);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ProjectViewImpl.ELEMENT_PANE, "com/intellij/ide/projectView/impl/ProjectViewImpl$12", "isEnabled"));
            }
        };
        this.myShowMembers = new Option(){

            @Override
            public boolean isEnabled(@NotNull AbstractProjectViewPane pane2) {
                if (pane2 == null) {
                    13.$$$reportNull$$$0(0);
                }
                return ProjectViewImpl.this.isShowMembersOptionSupported();
            }

            public boolean isSelected() {
                return ProjectViewImpl.this.myCurrentState.getShowMembers();
            }

            public void setSelected(boolean selected2) {
                if (ProjectViewImpl.this.myProject.isDisposed()) {
                    return;
                }
                boolean updated = selected2 != this.isSelected();
                ProjectViewImpl.this.myCurrentState.setShowMembers(selected2);
                ProjectViewImpl.getDefaultState().setShowMembers(selected2);
                ProjectViewImpl.getGlobalOptions().setShowMembers(selected2);
                if (updated) {
                    ProjectViewImpl.this.updatePanes(false);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ProjectViewImpl.ELEMENT_PANE, "com/intellij/ide/projectView/impl/ProjectViewImpl$13", "isEnabled"));
            }
        };
        this.myShowModules = new Option(){

            @Override
            public boolean isEnabled(@NotNull AbstractProjectViewPane pane2) {
                if (pane2 == null) {
                    14.$$$reportNull$$$0(0);
                }
                return pane2.supportsShowModules();
            }

            public boolean isSelected() {
                return ProjectViewImpl.this.myCurrentState.getShowModules();
            }

            public void setSelected(boolean selected2) {
                if (ProjectViewImpl.this.myProject.isDisposed()) {
                    return;
                }
                boolean updated = selected2 != this.isSelected();
                ProjectViewImpl.this.myCurrentState.setShowModules(selected2);
                ProjectViewImpl.getDefaultState().setShowModules(selected2);
                ProjectViewImpl.getGlobalOptions().setShowModules(selected2);
                if (updated) {
                    ProjectViewImpl.this.updatePanes(false);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ProjectViewImpl.ELEMENT_PANE, "com/intellij/ide/projectView/impl/ProjectViewImpl$14", "isEnabled"));
            }
        };
        this.myShowVisibilityIcons = new Option(){

            @Override
            public boolean isEnabled(@NotNull AbstractProjectViewPane pane2) {
                if (pane2 == null) {
                    15.$$$reportNull$$$0(0);
                }
                return OptionsApplicabilityFilter.isApplicable(OptionId.PROJECT_VIEW_SHOW_VISIBILITY_ICONS);
            }

            public boolean isSelected() {
                return ProjectViewImpl.this.myCurrentState.getShowVisibilityIcons();
            }

            public void setSelected(boolean selected2) {
                if (ProjectViewImpl.this.myProject.isDisposed()) {
                    return;
                }
                boolean updated = selected2 != this.isSelected();
                ProjectViewImpl.this.myCurrentState.setShowVisibilityIcons(selected2);
                ProjectViewImpl.getDefaultState().setShowVisibilityIcons(selected2);
                ProjectViewImpl.getGlobalOptions().setShowVisibilityIcons(selected2);
                if (updated) {
                    ProjectViewImpl.this.updatePanes(false);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ProjectViewImpl.ELEMENT_PANE, "com/intellij/ide/projectView/impl/ProjectViewImpl$15", "isEnabled"));
            }
        };
        this.mySortByType = new Option(){

            @Override
            public boolean isEnabled(@NotNull AbstractProjectViewPane pane2) {
                if (pane2 == null) {
                    16.$$$reportNull$$$0(0);
                }
                return pane2.supportsSortByType();
            }

            public boolean isSelected() {
                return ProjectViewImpl.this.myCurrentState.getSortByType();
            }

            public void setSelected(boolean selected2) {
                if (ProjectViewImpl.this.myProject.isDisposed()) {
                    return;
                }
                boolean updated = selected2 != this.isSelected();
                ProjectViewImpl.this.myCurrentState.setSortByType(selected2);
                ProjectViewImpl.getDefaultState().setSortByType(selected2);
                ProjectViewImpl.getGlobalOptions().setSortByType(selected2);
                if (updated) {
                    ProjectViewImpl.this.updatePanes(true);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ProjectViewImpl.ELEMENT_PANE, "com/intellij/ide/projectView/impl/ProjectViewImpl$16", "isEnabled"));
            }
        };
        this.myCurrentSelectionObsolete = ThreeState.NO;
        this.myAutoScrollOnFocusEditor = new AtomicBoolean(true);
        this.myIdeView = new IdeViewForProjectViewPane(this::getCurrentProjectViewPane);
        this.myDeletePSIElementProvider = new MyDeletePSIElementProvider();
        this.myId2Pane = new LinkedHashMap<String, AbstractProjectViewPane>();
        this.myUninitializedPanes = new HashSet<AbstractProjectViewPane>();
        this.mySavedPaneId = null;
        this.splitterProportions = new SplitterProportionsDataImpl();
        this.myUninitializedPaneState = new HashMap<String, Element>();
        this.mySelectInTargets = new LinkedHashMap<String, SelectInTarget>();
        this.myProject = project;
        this.myCurrentState = ProjectViewState.getInstance(project);
        this.constructUi();
        this.myAutoScrollFromSourceHandler = new MyAutoScrollFromSourceHandler();
        this.myDataProvider = new MyPanel();
        this.myDataProvider.add((Component)this.myPanel, "Center");
        this.myCopyPasteDelegator = new CopyPasteDelegator(this.myProject, (JComponent)this.myPanel);
        this.myAutoScrollToSourceHandler = new AutoScrollToSourceHandler(){

            protected boolean isAutoScrollMode() {
                return ProjectViewImpl.this.myAutoscrollToSource.isSelected() || ProjectViewImpl.this.myOpenInPreviewTab.isSelected();
            }

            protected void setAutoScrollMode(boolean state) {
                ProjectViewImpl.this.myAutoscrollToSource.setSelected(state);
            }

            protected boolean isAutoScrollEnabledFor(@NotNull VirtualFile file2) {
                if (file2 == null) {
                    17.$$$reportNull$$$0(0);
                }
                if (!super.isAutoScrollEnabledFor(file2)) {
                    return false;
                }
                AbstractProjectViewPane pane2 = ProjectViewImpl.this.getCurrentProjectViewPane();
                return pane2 == null || pane2.isAutoScrollEnabledFor(file2);
            }

            protected String getActionName() {
                return ActionsBundle.message((String)"action.ProjectView.AutoscrollToSource.text", (Object[])new Object[0]);
            }

            protected String getActionDescription() {
                return ActionsBundle.message((String)"action.ProjectView.AutoscrollToSource.description", (Object[])new Object[0]);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/ide/projectView/impl/ProjectViewImpl$17", "isAutoScrollEnabledFor"));
            }
        };
        project.getMessageBus().connect().subscribe(ToolWindowManagerListener.TOPIC, (Object)new ToolWindowManagerListener(){

            @Override
            public void toolWindowShown(@NotNull ToolWindow toolWindow) {
                if (toolWindow == null) {
                    18.$$$reportNull$$$0(0);
                }
                if ("Project".equals(toolWindow.getId())) {
                    SimpleSelectInContext context2;
                    ProjectViewImpl.this.myCurrentSelectionObsolete = ThreeState.NO;
                    AbstractProjectViewPane currentProjectViewPane = ProjectViewImpl.this.getCurrentProjectViewPane();
                    if (currentProjectViewPane != null && ProjectViewImpl.this.isAutoscrollFromSource(currentProjectViewPane.getId()) && (context2 = ProjectViewImpl.this.myAutoScrollFromSourceHandler.findSelectInContext()) != null) {
                        ProjectViewImpl.this.myCurrentSelectionObsolete = ThreeState.UNSURE;
                        context2.selectInCurrentTarget(false);
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWindow", "com/intellij/ide/projectView/impl/ProjectViewImpl$18", "toolWindowShown"));
            }
        });
        AbstractProjectViewPane.EP.addExtensionPointListener((AreaInstance)project, (ExtensionPointListener)new ExtensionPointListener<AbstractProjectViewPane>(){

            public void extensionAdded(@NotNull AbstractProjectViewPane extension2, @NotNull PluginDescriptor pluginDescriptor) {
                if (extension2 == null) {
                    19.$$$reportNull$$$0(0);
                }
                if (pluginDescriptor == null) {
                    19.$$$reportNull$$$0(1);
                }
                ProjectViewImpl.this.reloadPanes();
            }

            public void extensionRemoved(@NotNull AbstractProjectViewPane extension2, @NotNull PluginDescriptor pluginDescriptor) {
                if (extension2 == null) {
                    19.$$$reportNull$$$0(2);
                }
                if (pluginDescriptor == null) {
                    19.$$$reportNull$$$0(3);
                }
                if (ProjectViewImpl.this.myId2Pane.containsKey(extension2.getId()) || ProjectViewImpl.this.myUninitializedPanes.contains(extension2)) {
                    ProjectViewImpl.this.reloadPanes();
                } else {
                    Disposer.dispose((Disposable)extension2);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "extension";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "pluginDescriptor";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/ide/projectView/impl/ProjectViewImpl$19";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionAdded";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionRemoved";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, (Disposable)project);
    }

    private void constructUi() {
        this.myViewContentPanel = new JPanel();
        this.myViewContentPanel.putClientProperty(FileEditorManagerImpl.OPEN_IN_PREVIEW_TAB, true);
        this.myPanel = new SimpleToolWindowPanel(true).setProvideQuickActions(false);
        this.myPanel.setContent((JComponent)this.myViewContentPanel);
    }

    @NotNull
    public String getName() {
        String string = IdeUICustomization.getInstance().getProjectViewTitle();
        if (string == null) {
            ProjectViewImpl.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public List<AnAction> getActions(boolean originalProvider) {
        DefaultActionGroup views = DefaultActionGroup.createPopupGroup(() -> LangBundle.message((String)"action.change.view.text", (Object[])new Object[0]));
        ChangeViewAction lastHeader = null;
        for (int i2 = 0; i2 < this.myContentManager.getContentCount(); ++i2) {
            Content each = this.myContentManager.getContent(i2);
            if (each == null) continue;
            String id2 = (String)each.getUserData(ID_KEY);
            String subId = (String)each.getUserData(SUB_ID_KEY);
            ChangeViewAction newHeader = new ChangeViewAction(id2, subId);
            if (lastHeader != null) {
                boolean newHasKids;
                boolean lastHasKids = lastHeader.mySubId != null;
                boolean bl = newHasKids = newHeader.mySubId != null;
                if (lastHasKids != newHasKids || lastHasKids && lastHeader.myId != newHeader.myId) {
                    views.add((AnAction)Separator.getInstance());
                }
            }
            views.add((AnAction)newHeader);
            lastHeader = newHeader;
        }
        ArrayList<AnAction> result2 = new ArrayList<AnAction>();
        result2.add((AnAction)views);
        result2.add((AnAction)Separator.getInstance());
        if (this.myActionGroup != null) {
            ArrayList<AnAction> secondary = new ArrayList<AnAction>();
            for (AnAction each : this.myActionGroup.getChildren(null)) {
                if (this.myActionGroup.isPrimary(each)) {
                    result2.add(each);
                    continue;
                }
                secondary.add(each);
            }
            result2.add((AnAction)Separator.getInstance());
            result2.addAll(secondary);
        }
        ArrayList<AnAction> arrayList = result2;
        if (arrayList == null) {
            ProjectViewImpl.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    private static ProjectViewState getDefaultState() {
        return ProjectViewState.getDefaultInstance();
    }

    @Override
    public synchronized void addProjectPane(@NotNull AbstractProjectViewPane pane2) {
        if (pane2 == null) {
            ProjectViewImpl.$$$reportNull$$$0(3);
        }
        this.myUninitializedPanes.add(pane2);
        SelectInTarget selectInTarget = pane2.createSelectInTarget();
        String id2 = selectInTarget.getMinorViewId();
        if (pane2.getId().equals(id2)) {
            this.mySelectInTargets.put(id2, selectInTarget);
        } else {
            try {
                LOG.error("Unexpected SelectInTarget: " + selectInTarget.getClass() + "\n  created by project pane:" + pane2.getClass());
            }
            catch (AssertionError assertionError) {
                // empty catch block
            }
        }
        if (this.isInitialized) {
            this.doAddUninitializedPanes();
        }
    }

    @Override
    public synchronized void removeProjectPane(@NotNull AbstractProjectViewPane pane2) {
        if (pane2 == null) {
            ProjectViewImpl.$$$reportNull$$$0(4);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myUninitializedPanes.remove(pane2);
        String idToRemove = pane2.getId();
        if (!this.myId2Pane.containsKey(idToRemove)) {
            return;
        }
        for (int i2 = this.getContentManager().getContentCount() - 1; i2 >= 0; --i2) {
            String id2;
            Content content2 = this.getContentManager().getContent(i2);
            String string = id2 = content2 != null ? (String)content2.getUserData(ID_KEY) : null;
            if (!idToRemove.equals(id2)) continue;
            this.getContentManager().removeContent(content2, true);
        }
        this.myId2Pane.remove(idToRemove);
        this.mySelectInTargets.remove(idToRemove);
        this.viewSelectionChanged();
    }

    private synchronized void doAddUninitializedPanes() {
        for (AbstractProjectViewPane pane2 : this.myUninitializedPanes) {
            this.doAddPane(pane2);
        }
        Content[] contents = this.getContentManager().getContents();
        for (int i2 = 1; i2 < contents.length; ++i2) {
            Content content2 = contents[i2];
            Content prev2 = contents[i2 - 1];
            if (StringUtil.equals((CharSequence)((CharSequence)content2.getUserData(ID_KEY)), (CharSequence)((CharSequence)prev2.getUserData(ID_KEY))) || prev2.getUserData(SUB_ID_KEY) == null || content2.getSeparator() != null) continue;
            content2.setSeparator("");
        }
        String selectID = null;
        String selectSubID = null;
        String savedPaneId = this.mySavedPaneId;
        if (savedPaneId == null) {
            savedPaneId = this.getDefaultViewId();
            this.mySavedPaneSubId = null;
        }
        for (Content content3 : contents) {
            String id2 = (String)content3.getUserData(ID_KEY);
            String subId = (String)content3.getUserData(SUB_ID_KEY);
            if (id2 == null || !id2.equals(savedPaneId) || !StringUtil.equals((CharSequence)subId, (CharSequence)this.mySavedPaneSubId)) continue;
            selectID = id2;
            selectSubID = subId;
            this.mySavedPaneId = null;
            this.mySavedPaneSubId = null;
            break;
        }
        if (selectID == null && contents.length > 0 && this.myCurrentViewId == null) {
            Content content4 = contents[0];
            selectID = (String)content4.getUserData(ID_KEY);
            selectSubID = (String)content4.getUserData(SUB_ID_KEY);
        }
        if (selectID != null) {
            this.changeView(selectID, selectSubID);
        }
        this.myUninitializedPanes.clear();
    }

    private void doAddPane(@NotNull AbstractProjectViewPane newPane) {
        String[] stringArray;
        int index2;
        if (newPane == null) {
            ProjectViewImpl.$$$reportNull$$$0(5);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        ContentManager manager2 = this.getContentManager();
        for (index2 = 0; index2 < manager2.getContentCount(); ++index2) {
            Content content2 = manager2.getContent(index2);
            String id2 = (String)content2.getUserData(ID_KEY);
            AbstractProjectViewPane pane2 = this.myId2Pane.get(id2);
            int comp = PANE_WEIGHT_COMPARATOR.compare(pane2, newPane);
            LOG.assertTrue(comp != 0, (Object)("Project view pane " + newPane + " has the same weight as " + pane2 + ". Please make sure that you overload getWeight() and return a distinct weight value."));
            if (comp > 0) break;
        }
        String id3 = newPane.getId();
        this.myId2Pane.put(id3, newPane);
        String[] subIds = newPane.getSubIds();
        if (subIds.length == 0) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = null;
        } else {
            stringArray = subIds;
        }
        subIds = stringArray;
        boolean first = true;
        for (String subId : subIds) {
            String title2 = subId != null ? newPane.getPresentableSubIdName(subId) : newPane.getTitle();
            Content content3 = this.getContentManager().getFactory().createContent(this.getComponent(), title2, false);
            content3.setTabName(title2);
            content3.putUserData(ID_KEY, (Object)id3);
            content3.putUserData(SUB_ID_KEY, (Object)subId);
            content3.putUserData(ToolWindow.SHOW_CONTENT_ICON, (Object)Boolean.TRUE);
            Icon icon2 = subId != null ? newPane.getPresentableSubIdIcon(subId) : newPane.getIcon();
            content3.setIcon(icon2);
            content3.setPopupIcon(icon2);
            content3.setPreferredFocusedComponent(() -> {
                AbstractProjectViewPane current2 = this.getCurrentProjectViewPane();
                return current2 != null ? current2.getComponentToFocus() : null;
            });
            content3.setBusyObject((BusyObject)this);
            if (first && subId != null) {
                content3.setSeparator(newPane.getTitle());
            }
            manager2.addContent(content3, index2++);
            first = false;
        }
    }

    private void showPane(@NotNull AbstractProjectViewPane newPane) {
        if (newPane == null) {
            ProjectViewImpl.$$$reportNull$$$0(6);
        }
        AbstractProjectViewPane currentPane = this.getCurrentProjectViewPane();
        PsiElement selectedPsiElement = null;
        if (currentPane != null) {
            PsiElement[] elements;
            if (currentPane != newPane) {
                currentPane.saveExpandedPaths();
            }
            if ((elements = currentPane.getSelectedPSIElements()).length > 0) {
                selectedPsiElement = elements[0];
            }
        }
        this.myViewContentPanel.removeAll();
        JComponent component2 = newPane.createComponent();
        UIUtil.removeScrollBorder((Component)component2);
        this.myViewContentPanel.setLayout(new BorderLayout());
        this.myViewContentPanel.add((Component)component2, "Center");
        this.myCurrentViewId = newPane.getId();
        String newSubId = this.myCurrentViewSubId = newPane.getSubId();
        this.myViewContentPanel.revalidate();
        this.myViewContentPanel.repaint();
        this.createToolbarActions(newPane);
        this.myAutoScrollToSourceHandler.install((JTree)((Object)newPane.myTree));
        newPane.restoreExpandedPaths();
        if (selectedPsiElement != null && newSubId != null) {
            ProjectViewSelectInTarget target2;
            VirtualFile virtualFile2 = PsiUtilCore.getVirtualFile((PsiElement)selectedPsiElement);
            ProjectViewSelectInTarget projectViewSelectInTarget = target2 = virtualFile2 == null ? null : this.getProjectViewSelectInTarget(newPane);
            if (target2 != null && target2.isSubIdSelectable(newSubId, (SelectInContext)new FileSelectInContext(this.myProject, virtualFile2, null))) {
                newPane.select(selectedPsiElement, virtualFile2, true);
            }
        }
        this.myAutoScrollToSourceHandler.onMouseClicked((Component)((Object)newPane.myTree));
        ((ProjectViewListener)this.myProject.getMessageBus().syncPublisher(ProjectViewListener.TOPIC)).paneShown(newPane, currentPane);
        ProjectViewImpl.logProjectViewPaneChangedEvent(currentPane, newPane);
    }

    private static void logProjectViewPaneChangedEvent(@Nullable AbstractProjectViewPane currentPane, @NotNull AbstractProjectViewPane newPane) {
        NamedScope selectedScope;
        if (newPane == null) {
            ProjectViewImpl.$$$reportNull$$$0(7);
        }
        FeatureUsageData data2 = new FeatureUsageData().addData("to_class_name", newPane.getClass().getName());
        NamedScope namedScope = selectedScope = newPane instanceof ScopeViewPane ? ((ScopeViewPane)newPane).getSelectedScope() : null;
        if (selectedScope != null) {
            data2.addData("to_scope_class_name", selectedScope.getClass().getName());
        }
        if (currentPane != null) {
            data2.addData("from_class_name", currentPane.getClass().getName());
            NamedScope namedScope2 = selectedScope = currentPane instanceof ScopeViewPane ? ((ScopeViewPane)currentPane).getSelectedScope() : null;
            if (selectedScope != null) {
                data2.addData("from_scope_class_name", selectedScope.getClass().getName());
            }
        }
        FUCounterUsageLogger.getInstance().logEvent("project.view.pane.changes", "changed", data2);
    }

    public synchronized void setupImpl(@NotNull ToolWindow toolWindow) {
        if (toolWindow == null) {
            ProjectViewImpl.$$$reportNull$$$0(8);
        }
        this.setupImpl(toolWindow, true);
    }

    public synchronized void setupImpl(@NotNull ToolWindow toolWindow, boolean loadPaneExtensions) {
        if (toolWindow == null) {
            ProjectViewImpl.$$$reportNull$$$0(9);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.isInitialized) {
            return;
        }
        this.myActionGroup = new DefaultActionGroup();
        this.myAutoScrollFromSourceHandler.install();
        this.myContentManager = toolWindow.getContentManager();
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            toolWindow.setDefaultContentUiType(ToolWindowContentUiType.COMBO);
            ((ToolWindowEx)toolWindow).setAdditionalGearActions((ActionGroup)this.myActionGroup);
            toolWindow.getComponent().putClientProperty("HideIdLabel", "true");
        }
        GuiUtils.replaceJSplitPaneWithIDEASplitter((JComponent)this.myPanel);
        SwingUtilities.invokeLater(() -> this.splitterProportions.restoreSplitterProportions((Component)this.myPanel));
        if (loadPaneExtensions) {
            this.ensurePanesLoaded();
        }
        this.isInitialized = true;
        this.doAddUninitializedPanes();
        this.getContentManager().addContentManagerListener(new ContentManagerListener(){

            public void selectionChanged(@NotNull ContentManagerEvent event) {
                if (event == null) {
                    20.$$$reportNull$$$0(0);
                }
                if (event.getOperation() == ContentManagerEvent.ContentOperation.add) {
                    ProjectViewImpl.this.viewSelectionChanged();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/ide/projectView/impl/ProjectViewImpl$20", "selectionChanged"));
            }
        });
        this.viewSelectionChanged();
        EditorEventMulticaster multicaster = EditorFactory.getInstance().getEventMulticaster();
        if (multicaster instanceof EditorEventMulticasterEx) {
            EditorEventMulticasterEx ex = (EditorEventMulticasterEx)multicaster;
            ex.addFocusChangeListener(new FocusChangeListener(){

                @Override
                public void focusLost(@NotNull Editor editor, @NotNull FocusEvent event) {
                    if (editor == null) {
                        21.$$$reportNull$$$0(0);
                    }
                    if (event == null) {
                        21.$$$reportNull$$$0(1);
                    }
                    ProjectViewImpl.this.myAutoScrollFromSourceHandler.cancelAllRequests();
                    ProjectViewImpl.this.myAutoScrollOnFocusEditor.set(true);
                }

                @Override
                public void focusGained(@NotNull Editor editor, @NotNull FocusEvent event) {
                    if (editor == null) {
                        21.$$$reportNull$$$0(2);
                    }
                    if (event == null) {
                        21.$$$reportNull$$$0(3);
                    }
                    if (this.isAutoscrollFromSourceAllowedHere()) {
                        ProjectViewImpl.this.myAutoScrollFromSourceHandler.addRequest(() -> {
                            FileEditorManager manager2;
                            FileEditorManager fileEditorManager = manager2 = ProjectViewImpl.this.myProject.isDisposed() ? null : FileEditorManager.getInstance((Project)ProjectViewImpl.this.myProject);
                            if (manager2 != null) {
                                JComponent component2 = editor.getComponent();
                                for (FileEditor fileEditor : manager2.getAllEditors()) {
                                    if (!SwingUtilities.isDescendingFrom(component2, fileEditor.getComponent())) continue;
                                    ProjectViewImpl.this.myAutoScrollFromSourceHandler.scrollFromSource(false);
                                    break;
                                }
                            }
                        });
                    }
                }

                private boolean isAutoscrollFromSourceAllowedHere() {
                    if (!ProjectViewImpl.this.myAutoScrollOnFocusEditor.getAndSet(true)) {
                        return false;
                    }
                    if (!Registry.is((String)"ide.autoscroll.from.source.on.focus.gained")) {
                        return false;
                    }
                    return ProjectViewImpl.this.isAutoscrollFromSource(ProjectViewImpl.this.getCurrentViewId());
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "editor";
                            break;
                        }
                        case 1: 
                        case 3: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "event";
                            break;
                        }
                    }
                    objectArray2[1] = "com/intellij/ide/projectView/impl/ProjectViewImpl$21";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "focusLost";
                            break;
                        }
                        case 2: 
                        case 3: {
                            objectArray = objectArray2;
                            objectArray2[2] = "focusGained";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            }, (Disposable)this.myProject);
        }
    }

    private synchronized void reloadPanes() {
        if (this.myProject.isDisposed() || !this.myExtensionsLoaded.get()) {
            return;
        }
        Map<String, AbstractProjectViewPane> newPanes = this.loadPanes();
        IdentityHashMap<AbstractProjectViewPane, Boolean> oldPanes = new IdentityHashMap<AbstractProjectViewPane, Boolean>();
        this.myUninitializedPanes.forEach(pane2 -> oldPanes.put((AbstractProjectViewPane)pane2, pane2 == newPanes.get(pane2.getId())));
        this.myId2Pane.forEach((id2, pane2) -> oldPanes.put((AbstractProjectViewPane)pane2, pane2 == newPanes.get(id2)));
        oldPanes.forEach((pane2, exists) -> {
            if (Boolean.FALSE.equals(exists)) {
                this.removeProjectPane((AbstractProjectViewPane)pane2);
                Disposer.dispose((Disposable)pane2);
            }
        });
        for (AbstractProjectViewPane pane3 : newPanes.values()) {
            if (Boolean.TRUE.equals(oldPanes.get(pane3)) || !pane3.isInitiallyVisible()) continue;
            this.addProjectPane(pane3);
        }
    }

    private void ensurePanesLoaded() {
        if (this.myProject.isDisposed() || this.myExtensionsLoaded.getAndSet(true)) {
            return;
        }
        for (AbstractProjectViewPane pane2 : this.loadPanes().values()) {
            if (!pane2.isInitiallyVisible()) continue;
            this.addProjectPane(pane2);
        }
    }

    @NotNull
    private Map<String, AbstractProjectViewPane> loadPanes() {
        LinkedHashMap<String, AbstractProjectViewPane> map2 = new LinkedHashMap<String, AbstractProjectViewPane>();
        ArrayList<AbstractProjectViewPane> toSort = new ArrayList<AbstractProjectViewPane>(AbstractProjectViewPane.EP.getExtensions((AreaInstance)this.myProject));
        toSort.sort(PANE_WEIGHT_COMPARATOR);
        for (AbstractProjectViewPane pane2 : toSort) {
            AbstractProjectViewPane added2;
            if (pane2 != (added2 = map2.computeIfAbsent(pane2.getId(), id2 -> pane2))) {
                LOG.warn("ignore duplicated pane with id=" + pane2.getId() + "\nold " + added2.getClass() + "\nnew " + pane2.getClass());
                continue;
            }
            Element element2 = this.myUninitializedPaneState.remove(pane2.getId());
            if (element2 == null) continue;
            ProjectViewImpl.applyPaneState(pane2, element2);
        }
        LinkedHashMap<String, AbstractProjectViewPane> linkedHashMap = map2;
        if (linkedHashMap == null) {
            ProjectViewImpl.$$$reportNull$$$0(10);
        }
        return linkedHashMap;
    }

    private void viewSelectionChanged() {
        Content content2 = this.getContentManager().getSelectedContent();
        if (content2 == null) {
            return;
        }
        String id2 = (String)content2.getUserData(ID_KEY);
        String subId = (String)content2.getUserData(SUB_ID_KEY);
        if (Objects.equals(id2, this.myCurrentViewId) && Objects.equals(subId, this.myCurrentViewSubId)) {
            return;
        }
        AbstractProjectViewPane newPane = this.getProjectViewPaneById(id2);
        if (newPane == null) {
            return;
        }
        newPane.setSubId(subId);
        this.showPane(newPane);
        ProjectViewSelectInTarget target2 = this.getProjectViewSelectInTarget(newPane);
        if (target2 != null) {
            target2.setSubId(subId);
        }
        if (this.isAutoscrollFromSource(id2)) {
            this.myAutoScrollFromSourceHandler.scrollFromSource(false);
        }
    }

    private void createToolbarActions(@NotNull AbstractProjectViewPane pane2) {
        ToolWindow window;
        if (pane2 == null) {
            ProjectViewImpl.$$$reportNull$$$0(11);
        }
        if (this.myActionGroup == null) {
            return;
        }
        this.myActionGroup.removeAll();
        DefaultActionGroup group2 = (DefaultActionGroup)ActionManager.getInstance().getAction("ProjectView.ToolWindow.SecondaryActions");
        for (AnAction action2 : group2.getChildActionsOrStubs()) {
            this.myActionGroup.addAction(action2).setAsSecondary(true);
        }
        pane2.addToolbarActions(this.myActionGroup);
        ArrayList titleActions = new ArrayList();
        this.createTitleActions(titleActions);
        if (!titleActions.isEmpty() && (window = ToolWindowManager.getInstance((Project)this.myProject).getToolWindow("Project")) != null) {
            window.setTitleActions(titleActions);
        }
    }

    protected void createTitleActions(@NotNull List<? super AnAction> titleActions) {
        AnAction action2;
        if (titleActions == null) {
            ProjectViewImpl.$$$reportNull$$$0(12);
        }
        if ((action2 = ActionManager.getInstance().getAction("ProjectViewToolbar")) != null) {
            titleActions.add((AnAction)action2);
        }
    }

    protected boolean isShowMembersOptionSupported() {
        return true;
    }

    @Override
    public AbstractProjectViewPane getProjectViewPaneById(String id2) {
        AbstractProjectViewPane pane2;
        if (!ApplicationManager.getApplication().isUnitTestMode() && ApplicationManager.getApplication().isDispatchThread()) {
            this.ensurePanesLoaded();
        }
        if ((pane2 = this.myId2Pane.get(id2)) != null) {
            return pane2;
        }
        for (AbstractProjectViewPane viewPane : this.myUninitializedPanes) {
            if (!viewPane.getId().equals(id2)) continue;
            return viewPane;
        }
        return null;
    }

    @Override
    public AbstractProjectViewPane getCurrentProjectViewPane() {
        return this.getProjectViewPaneById(this.myCurrentViewId);
    }

    @Override
    public void refresh() {
        AbstractProjectViewPane currentProjectViewPane = this.getCurrentProjectViewPane();
        if (currentProjectViewPane != null) {
            currentProjectViewPane.updateFromRoot(false);
        }
    }

    private boolean isCurrentSelectionObsolete(boolean requestFocus) {
        if (this.myCurrentSelectionObsolete == ThreeState.YES) {
            this.myCurrentSelectionObsolete = ThreeState.NO;
            return true;
        }
        if (this.myCurrentSelectionObsolete == ThreeState.UNSURE) {
            this.myCurrentSelectionObsolete = requestFocus ? ThreeState.YES : ThreeState.NO;
        }
        return false;
    }

    @Override
    public void select(Object element2, VirtualFile file2, boolean requestFocus) {
        if (this.isCurrentSelectionObsolete(requestFocus)) {
            return;
        }
        AbstractProjectViewPane viewPane = this.getCurrentProjectViewPane();
        if (viewPane != null) {
            this.myAutoScrollOnFocusEditor.set(!requestFocus);
            viewPane.select(element2, file2, requestFocus);
        }
    }

    @Override
    @NotNull
    public ActionCallback selectCB(Object element2, VirtualFile file2, boolean requestFocus) {
        if (this.isCurrentSelectionObsolete(requestFocus)) {
            ActionCallback actionCallback = ActionCallback.REJECTED;
            if (actionCallback == null) {
                ProjectViewImpl.$$$reportNull$$$0(13);
            }
            return actionCallback;
        }
        AbstractProjectViewPane viewPane = this.getCurrentProjectViewPane();
        if (viewPane instanceof AbstractProjectViewPSIPane) {
            this.myAutoScrollOnFocusEditor.set(!requestFocus);
            ActionCallback actionCallback = ((AbstractProjectViewPSIPane)viewPane).selectCB(element2, file2, requestFocus);
            if (actionCallback == null) {
                ProjectViewImpl.$$$reportNull$$$0(14);
            }
            return actionCallback;
        }
        this.select(element2, file2, requestFocus);
        ActionCallback actionCallback = ActionCallback.DONE;
        if (actionCallback == null) {
            ProjectViewImpl.$$$reportNull$$$0(15);
        }
        return actionCallback;
    }

    public JComponent getComponent() {
        return this.myDataProvider;
    }

    @Override
    public String getCurrentViewId() {
        return this.myCurrentViewId;
    }

    private SelectInTarget getCurrentSelectInTarget() {
        return this.getSelectInTarget(this.getCurrentViewId());
    }

    private SelectInTarget getSelectInTarget(String id2) {
        return this.mySelectInTargets.get(id2);
    }

    private ProjectViewSelectInTarget getProjectViewSelectInTarget(AbstractProjectViewPane pane2) {
        SelectInTarget target2 = this.getSelectInTarget(pane2.getId());
        return target2 instanceof ProjectViewSelectInTarget ? (ProjectViewSelectInTarget)target2 : null;
    }

    @Override
    public PsiElement getParentOfCurrentSelection() {
        AbstractProjectViewPane viewPane = this.getCurrentProjectViewPane();
        if (viewPane == null) {
            return null;
        }
        TreePath path2 = viewPane.getSelectedPath();
        if (path2 == null) {
            return null;
        }
        if ((path2 = path2.getParentPath()) == null) {
            return null;
        }
        ProjectViewNode descriptor2 = (ProjectViewNode)TreeUtil.getLastUserObject(ProjectViewNode.class, (TreePath)path2);
        if (descriptor2 != null) {
            Object element2 = descriptor2.getValue();
            if (element2 instanceof PsiElement) {
                PsiElement psiElement = (PsiElement)element2;
                if (!psiElement.isValid()) {
                    return null;
                }
                return psiElement;
            }
            return null;
        }
        return null;
    }

    public ContentManager getContentManager() {
        if (this.myContentManager == null) {
            ToolWindowManager.getInstance((Project)this.myProject).getToolWindow("Project").getContentManager();
        }
        return this.myContentManager;
    }

    @Override
    public void changeView() {
        ArrayList<AbstractProjectViewPane> views = new ArrayList<AbstractProjectViewPane>(this.myId2Pane.values());
        views.remove(this.getCurrentProjectViewPane());
        views.sort(PANE_WEIGHT_COMPARATOR);
        IPopupChooserBuilder builder2 = JBPopupFactory.getInstance().createPopupChooserBuilder(views).setRenderer((ListCellRenderer)new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list2, Object value2, int index2, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent((JList<?>)list2, value2, index2, isSelected, cellHasFocus);
                AbstractProjectViewPane pane2 = (AbstractProjectViewPane)value2;
                this.setText(pane2.getTitle());
                return this;
            }
        }).setTitle(IdeBundle.message((String)"title.popup.views", (Object[])new Object[0])).setItemChosenCallback(pane2 -> this.changeView(pane2.getId()));
        if (!views.isEmpty()) {
            builder2 = builder2.setSelectedValue((Object)((AbstractProjectViewPane)views.get(0)), true);
        }
        builder2.createPopup().showInCenterOf((Component)this.getComponent());
    }

    @Override
    public void changeView(@NotNull String viewId) {
        if (viewId == null) {
            ProjectViewImpl.$$$reportNull$$$0(16);
        }
        this.changeView(viewId, null);
    }

    @Override
    public void changeView(@NotNull String viewId, @Nullable String subId) {
        if (viewId == null) {
            ProjectViewImpl.$$$reportNull$$$0(17);
        }
        this.changeViewCB(viewId, subId);
    }

    @Override
    @NotNull
    public ActionCallback changeViewCB(@NotNull String viewId, @Nullable String subId) {
        boolean hasSubViews;
        AbstractProjectViewPane pane2;
        if (viewId == null) {
            ProjectViewImpl.$$$reportNull$$$0(18);
        }
        LOG.assertTrue((pane2 = this.getProjectViewPaneById(viewId)) != null, (Object)("Project view pane not found: " + viewId + "; subId:" + subId + "; project: " + this.myProject));
        boolean bl = hasSubViews = pane2.getSubIds().length > 0;
        if (hasSubViews) {
            if (subId == null) {
                subId = pane2.getSubId();
            }
        } else if (subId != null) {
            LOG.error("View doesn't have subviews: " + viewId + "; subId:" + subId + "; project: " + this.myProject);
        }
        if (viewId.equals(this.myCurrentViewId) && Objects.equals(subId, this.myCurrentViewSubId)) {
            ActionCallback actionCallback = ActionCallback.REJECTED;
            if (actionCallback == null) {
                ProjectViewImpl.$$$reportNull$$$0(19);
            }
            return actionCallback;
        }
        for (Content content2 : this.getContentManager().getContents()) {
            if (!viewId.equals(content2.getUserData(ID_KEY)) || subId != null && !subId.equals(content2.getUserData(SUB_ID_KEY))) continue;
            ActionCallback actionCallback = this.getContentManager().setSelectedContentCB(content2);
            if (actionCallback == null) {
                ProjectViewImpl.$$$reportNull$$$0(20);
            }
            return actionCallback;
        }
        ActionCallback actionCallback = ActionCallback.REJECTED;
        if (actionCallback == null) {
            ProjectViewImpl.$$$reportNull$$$0(21);
        }
        return actionCallback;
    }

    @Nullable
    private Module moduleBySingleContentRoot(@NotNull VirtualFile file2) {
        Module module;
        if (file2 == null) {
            ProjectViewImpl.$$$reportNull$$$0(22);
        }
        if (ProjectRootsUtil.isModuleContentRoot(file2, this.myProject) && (module = ProjectRootManager.getInstance((Project)this.myProject).getFileIndex().getModuleForFile(file2)) != null && !module.isDisposed() && ModuleRootManager.getInstance((Module)module).getContentRoots().length == 1) {
            return module;
        }
        return null;
    }

    @Nullable
    private UnloadedModuleDescription getUnloadedModuleByContentRoot(@NotNull VirtualFile file2) {
        String moduleName;
        if (file2 == null) {
            ProjectViewImpl.$$$reportNull$$$0(23);
        }
        if ((moduleName = ProjectRootsUtil.findUnloadedModuleByContentRoot(file2, this.myProject)) != null) {
            return ModuleManager.getInstance((Project)this.myProject).getUnloadedModuleDescription(moduleName);
        }
        return null;
    }

    @NotNull
    private <T> List<T> getSelectedElements(@NotNull Class<T> klass) {
        Object[] elements;
        if (klass == null) {
            ProjectViewImpl.$$$reportNull$$$0(24);
        }
        ArrayList<Object> result2 = new ArrayList<Object>();
        AbstractProjectViewPane viewPane = this.getCurrentProjectViewPane();
        if (viewPane == null) {
            ArrayList<Object> arrayList = result2;
            if (arrayList == null) {
                ProjectViewImpl.$$$reportNull$$$0(25);
            }
            return arrayList;
        }
        for (Object element2 : elements = viewPane.getSelectedElements()) {
            if (element2 == null || !klass.isAssignableFrom(element2.getClass())) continue;
            result2.add(element2);
        }
        ArrayList<Object> arrayList = result2;
        if (arrayList == null) {
            ProjectViewImpl.$$$reportNull$$$0(26);
        }
        return arrayList;
    }

    @Override
    public void selectPsiElement(@NotNull PsiElement element2, boolean requestFocus) {
        if (element2 == null) {
            ProjectViewImpl.$$$reportNull$$$0(27);
        }
        VirtualFile virtualFile2 = PsiUtilCore.getVirtualFile((PsiElement)element2);
        this.select(element2, virtualFile2, requestFocus);
    }

    public void loadState(@NotNull Element parentNode) {
        Element panesElement;
        Element navigatorElement;
        if (parentNode == null) {
            ProjectViewImpl.$$$reportNull$$$0(28);
        }
        if ((navigatorElement = parentNode.getChild(ELEMENT_NAVIGATOR)) != null) {
            this.mySavedPaneId = navigatorElement.getAttributeValue(ATTRIBUTE_CURRENT_VIEW);
            this.mySavedPaneSubId = this.mySavedPaneId == null ? null : navigatorElement.getAttributeValue(ATTRIBUTE_CURRENT_SUBVIEW);
            try {
                this.splitterProportions.readExternal(navigatorElement);
            }
            catch (InvalidDataException invalidDataException) {
                // empty catch block
            }
        }
        if ((panesElement = parentNode.getChild(ELEMENT_PANES)) != null) {
            this.readPaneState(panesElement);
        }
    }

    @Override
    @NotNull
    public String getDefaultViewId() {
        if ("AndroidStudio".equals(PlatformUtils.getPlatformPrefix()) && !Boolean.getBoolean("studio.projectview")) {
            return "AndroidView";
        }
        for (AbstractProjectViewPane extension2 : AbstractProjectViewPane.EP.getExtensions((AreaInstance)this.myProject)) {
            if (!extension2.isDefaultPane(this.myProject)) continue;
            String string = extension2.getId();
            if (string == null) {
                ProjectViewImpl.$$$reportNull$$$0(29);
            }
            return string;
        }
        return "ProjectPane";
    }

    private void readPaneState(@NotNull Element panesElement) {
        if (panesElement == null) {
            ProjectViewImpl.$$$reportNull$$$0(30);
        }
        List paneElements = panesElement.getChildren(ELEMENT_PANE);
        for (Element paneElement : paneElements) {
            String paneId = paneElement.getAttributeValue(ATTRIBUTE_ID);
            if (StringUtil.isEmptyOrSpaces((String)paneId)) continue;
            AbstractProjectViewPane pane2 = this.myId2Pane.get(paneId);
            if (pane2 != null) {
                ProjectViewImpl.applyPaneState(pane2, paneElement);
                continue;
            }
            this.myUninitializedPaneState.put(paneId, paneElement);
        }
    }

    private static void applyPaneState(@NotNull AbstractProjectViewPane pane2, @NotNull Element element2) {
        if (pane2 == null) {
            ProjectViewImpl.$$$reportNull$$$0(31);
        }
        if (element2 == null) {
            ProjectViewImpl.$$$reportNull$$$0(32);
        }
        try {
            pane2.readExternal(element2);
        }
        catch (InvalidDataException invalidDataException) {
            // empty catch block
        }
    }

    public Element getState() {
        Element parentNode = new Element("projectView");
        Element navigatorElement = new Element(ELEMENT_NAVIGATOR);
        AbstractProjectViewPane currentPane = this.getCurrentProjectViewPane();
        if (currentPane != null) {
            String subId = currentPane.getSubId();
            navigatorElement.setAttribute(ATTRIBUTE_CURRENT_VIEW, currentPane.getId());
            if (subId != null) {
                navigatorElement.setAttribute(ATTRIBUTE_CURRENT_SUBVIEW, subId);
            }
        }
        this.splitterProportions.saveSplitterProportions((Component)this.myPanel);
        try {
            this.splitterProportions.writeExternal(navigatorElement);
        }
        catch (WriteExternalException subId) {
            // empty catch block
        }
        if (!JDOMUtil.isEmpty((Element)navigatorElement)) {
            parentNode.addContent(navigatorElement);
        }
        Element panesElement = new Element(ELEMENT_PANES);
        this.writePaneState(panesElement);
        parentNode.addContent(panesElement);
        return parentNode;
    }

    private void writePaneState(@NotNull Element panesElement) {
        if (panesElement == null) {
            ProjectViewImpl.$$$reportNull$$$0(33);
        }
        for (AbstractProjectViewPane pane2 : this.myId2Pane.values()) {
            Element paneElement = new Element(ELEMENT_PANE);
            paneElement.setAttribute(ATTRIBUTE_ID, pane2.getId());
            try {
                pane2.writeExternal(paneElement);
            }
            catch (WriteExternalException e) {
                continue;
            }
            panesElement.addContent(paneElement);
        }
        for (Element element2 : this.myUninitializedPaneState.values()) {
            panesElement.addContent(element2.clone());
        }
    }

    private static ProjectViewSharedSettings getGlobalOptions() {
        return ProjectViewSharedSettings.Companion.getInstance();
    }

    @Override
    public boolean isAutoscrollToSource(String paneId) {
        return this.myAutoscrollToSource.isSelected() && this.myAutoscrollToSource.isEnabled(paneId);
    }

    public void setAutoscrollToSource(boolean autoscrollMode, String paneId) {
        if (this.myAutoscrollToSource.isEnabled(paneId)) {
            this.myAutoscrollToSource.setSelected(autoscrollMode);
        }
    }

    @Override
    public boolean isAutoscrollFromSource(String paneId) {
        if (!this.myAutoscrollFromSource.isSelected()) {
            return false;
        }
        if (!this.myAutoscrollFromSource.isEnabled(paneId)) {
            return false;
        }
        AbstractProjectViewPane pane2 = this.getProjectViewPaneById(paneId);
        if (pane2 == null) {
            return false;
        }
        JTree tree = pane2.getTree();
        if (tree == null || !tree.isShowing()) {
            return false;
        }
        return !UIUtil.isClientPropertyTrue((Object)tree, (Object)Tree.MOUSE_PRESSED_NON_FOCUSED);
    }

    public void setAutoscrollFromSource(boolean autoscrollMode, String paneId) {
        if (this.myAutoscrollFromSource.isEnabled(paneId)) {
            this.myAutoscrollFromSource.setSelected(autoscrollMode);
        }
    }

    @Override
    public boolean isFlattenPackages(String paneId) {
        return this.myFlattenPackages.isSelected() && this.myFlattenPackages.isEnabled(paneId);
    }

    public void setFlattenPackages(String paneId, boolean flattenPackages) {
        if (this.myFlattenPackages.isEnabled(paneId)) {
            this.myFlattenPackages.setSelected(flattenPackages);
        }
    }

    @Override
    public boolean isFoldersAlwaysOnTop(String paneId) {
        return this.myFoldersAlwaysOnTop.isSelected() && this.myFoldersAlwaysOnTop.isEnabled(paneId);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    public boolean isFoldersAlwaysOnTop() {
        return this.myFoldersAlwaysOnTop.isSelected() && this.myFoldersAlwaysOnTop.isEnabled();
    }

    public void setFoldersAlwaysOnTop(boolean foldersAlwaysOnTop) {
        if (this.myFoldersAlwaysOnTop.isEnabled()) {
            this.myFoldersAlwaysOnTop.setSelected(foldersAlwaysOnTop);
        }
    }

    @Override
    public boolean isShowMembers(String paneId) {
        return this.myShowMembers.isSelected() && this.myShowMembers.isEnabled(paneId);
    }

    @Override
    public boolean isHideEmptyMiddlePackages(String paneId) {
        return this.myHideEmptyMiddlePackages.isSelected() && this.myHideEmptyMiddlePackages.isEnabled(paneId);
    }

    @Override
    public boolean isAbbreviatePackageNames(String paneId) {
        return this.myAbbreviatePackageNames.isSelected() && this.myAbbreviatePackageNames.isEnabled(paneId);
    }

    @Override
    public boolean isShowExcludedFiles(String paneId) {
        return this.myShowExcludedFiles.isSelected() && this.myShowExcludedFiles.isEnabled(paneId);
    }

    @Override
    public boolean isShowVisibilityIcons(String paneId) {
        return this.myShowVisibilityIcons.isSelected() && this.myShowVisibilityIcons.isEnabled(paneId);
    }

    @Override
    public boolean isShowLibraryContents(String paneId) {
        return this.myShowLibraryContents.isSelected() && this.myShowLibraryContents.isEnabled(paneId);
    }

    @Override
    public void setShowLibraryContents(@NotNull String paneId, boolean showLibraryContents) {
        if (paneId == null) {
            ProjectViewImpl.$$$reportNull$$$0(34);
        }
        if (this.myShowLibraryContents.isEnabled(paneId)) {
            this.myShowLibraryContents.setSelected(showLibraryContents);
        }
    }

    @Override
    public boolean isShowModules(String paneId) {
        return this.myShowModules.isSelected() && this.myShowModules.isEnabled(paneId);
    }

    @Override
    public void setShowModules(@NotNull String paneId, boolean showModules) {
        if (paneId == null) {
            ProjectViewImpl.$$$reportNull$$$0(35);
        }
        if (this.myShowModules.isEnabled(paneId)) {
            this.myShowModules.setSelected(showModules);
        }
    }

    @Override
    public boolean isFlattenModules(String paneId) {
        return this.myFlattenModules.isSelected() && this.myFlattenModules.isEnabled(paneId);
    }

    @Override
    public void setFlattenModules(@NotNull String paneId, boolean flattenModules) {
        if (paneId == null) {
            ProjectViewImpl.$$$reportNull$$$0(36);
        }
        if (this.myFlattenModules.isEnabled(paneId)) {
            this.myFlattenModules.setSelected(flattenModules);
        }
    }

    @Override
    public boolean isShowURL(String paneId) {
        return Registry.is((String)"project.tree.structure.show.url");
    }

    @Override
    public void setHideEmptyPackages(@NotNull String paneId, boolean hideEmptyPackages) {
        if (paneId == null) {
            ProjectViewImpl.$$$reportNull$$$0(37);
        }
        if (this.myHideEmptyMiddlePackages.isEnabled(paneId)) {
            this.myHideEmptyMiddlePackages.setSelected(hideEmptyPackages);
        }
    }

    @Override
    public boolean isUseFileNestingRules(String paneId) {
        if (!this.myCurrentState.getUseFileNestingRules()) {
            return false;
        }
        AbstractProjectViewPane pane2 = this.myId2Pane.get(paneId);
        return pane2 != null && pane2.isFileNestingEnabled();
    }

    @Override
    public void setUseFileNestingRules(boolean useFileNestingRules) {
        if (this.myProject.isDisposed()) {
            return;
        }
        boolean updated = useFileNestingRules != this.myCurrentState.getUseFileNestingRules();
        this.myCurrentState.setUseFileNestingRules(useFileNestingRules);
        ProjectViewImpl.getDefaultState().setUseFileNestingRules(useFileNestingRules);
        if (updated) {
            this.updatePanes(false);
        }
    }

    @Override
    public boolean isCompactDirectories(String paneId) {
        return this.myCompactDirectories.isSelected() && this.myCompactDirectories.isEnabled(paneId);
    }

    @Override
    public void setCompactDirectories(@NotNull String paneId, boolean compactDirectories) {
        if (paneId == null) {
            ProjectViewImpl.$$$reportNull$$$0(38);
        }
        if (this.myCompactDirectories.isEnabled(paneId)) {
            this.myCompactDirectories.setSelected(compactDirectories);
        }
    }

    @Override
    public void setAbbreviatePackageNames(@NotNull String paneId, boolean abbreviatePackageNames) {
        if (paneId == null) {
            ProjectViewImpl.$$$reportNull$$$0(39);
        }
        if (this.myAbbreviatePackageNames.isEnabled(paneId)) {
            this.myAbbreviatePackageNames.setSelected(abbreviatePackageNames);
        }
    }

    @Override
    public boolean isManualOrder(String paneId) {
        return this.myManualOrder.isSelected() && this.myManualOrder.isEnabled(paneId);
    }

    @Override
    public void setManualOrder(@NotNull String paneId, boolean enabled) {
        if (paneId == null) {
            ProjectViewImpl.$$$reportNull$$$0(40);
        }
        if (this.myManualOrder.isEnabled(paneId)) {
            this.myManualOrder.setSelected(enabled);
        }
    }

    @Override
    public boolean isSortByType(String paneId) {
        return this.mySortByType.isSelected() && this.mySortByType.isEnabled(paneId);
    }

    @Override
    public void setSortByType(@NotNull String paneId, boolean sortByType) {
        if (paneId == null) {
            ProjectViewImpl.$$$reportNull$$$0(41);
        }
        if (this.mySortByType.isEnabled(paneId)) {
            this.mySortByType.setSelected(sortByType);
        }
    }

    boolean isSelectOpenedFileEnabled() {
        return !this.isAutoscrollFromSource(this.myCurrentViewId);
    }

    @Nullable
    Runnable getSelectOpenedFile() {
        SimpleSelectInContext context2 = this.myAutoScrollFromSourceHandler.findSelectInContext();
        return context2 == null ? null : () -> context2.selectInCurrentTarget(true);
    }

    @Override
    @NotNull
    public Collection<String> getPaneIds() {
        Collection<String> collection = Collections.unmodifiableCollection(this.myId2Pane.keySet());
        if (collection == null) {
            ProjectViewImpl.$$$reportNull$$$0(42);
        }
        return collection;
    }

    @Override
    @NotNull
    public Collection<SelectInTarget> getSelectInTargets() {
        this.ensurePanesLoaded();
        Collection<SelectInTarget> collection = this.mySelectInTargets.values();
        if (collection == null) {
            ProjectViewImpl.$$$reportNull$$$0(43);
        }
        return collection;
    }

    @Override
    @NotNull
    public ActionCallback getReady(@NotNull Object requestor) {
        AbstractProjectViewPane pane2;
        if (requestor == null) {
            ProjectViewImpl.$$$reportNull$$$0(44);
        }
        if ((pane2 = this.myId2Pane.get(this.myCurrentViewSubId)) == null) {
            pane2 = this.myId2Pane.get(this.myCurrentViewId);
        }
        ActionCallback actionCallback = pane2 != null ? pane2.getReady(requestor) : ActionCallback.DONE;
        if (actionCallback == null) {
            ProjectViewImpl.$$$reportNull$$$0(45);
        }
        return actionCallback;
    }

    private void updatePanes(boolean withComparator) {
        for (AbstractProjectViewPane pane2 : this.myId2Pane.values()) {
            SelectionInfo info2;
            JTree tree = pane2.getTree();
            if (tree == null) continue;
            SelectionInfo selectionInfo = info2 = pane2.getId().equals(this.myCurrentViewId) ? SelectionInfo.create(pane2) : null;
            if (withComparator) {
                pane2.installComparator();
            }
            pane2.updateFromRoot(false);
            if (info2 == null) continue;
            info2.apply(pane2);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 19: 
            case 20: 
            case 21: 
            case 25: 
            case 26: 
            case 29: 
            case 42: 
            case 43: 
            case 45: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 19: 
            case 20: 
            case 21: 
            case 25: 
            case 26: 
            case 29: 
            case 42: 
            case 43: 
            case 45: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 19: 
            case 20: 
            case 21: 
            case 25: 
            case 26: 
            case 29: 
            case 42: 
            case 43: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/projectView/impl/ProjectViewImpl";
                break;
            }
            case 3: 
            case 4: 
            case 11: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = ELEMENT_PANE;
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newPane";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWindow";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "titleActions";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewId";
                break;
            }
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "klass";
                break;
            }
            case 27: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentNode";
                break;
            }
            case 30: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "panesElement";
                break;
            }
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paneId";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requestor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/projectView/impl/ProjectViewImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getActions";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "loadPanes";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "selectCB";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "changeViewCB";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedElements";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultViewId";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getPaneIds";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectInTargets";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "getReady";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 19: 
            case 20: 
            case 21: 
            case 25: 
            case 26: 
            case 29: 
            case 42: 
            case 43: 
            case 45: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addProjectPane";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "removeProjectPane";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "doAddPane";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "showPane";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "logProjectViewPaneChangedEvent";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setupImpl";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createToolbarActions";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createTitleActions";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "changeView";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "changeViewCB";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "moduleBySingleContentRoot";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getUnloadedModuleByContentRoot";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedElements";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "selectPsiElement";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "readPaneState";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "applyPaneState";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "writePaneState";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "setShowLibraryContents";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "setShowModules";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "setFlattenModules";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "setHideEmptyPackages";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "setCompactDirectories";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "setAbbreviatePackageNames";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "setManualOrder";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "setSortByType";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "getReady";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 19: 
            case 20: 
            case 21: 
            case 25: 
            case 26: 
            case 29: 
            case 42: 
            case 43: 
            case 45: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class Action
    extends ToggleOptionAction
    implements DumbAware {
        private Action(@NotNull Function<? super ProjectViewImpl, ? extends ToggleOptionAction.Option> optionSupplier) {
            if (optionSupplier == null) {
                Action.$$$reportNull$$$0(0);
            }
            super(event -> {
                Project project = event.getProject();
                ProjectView view = project == null || project.isDisposed() ? null : ProjectView.getInstance(project);
                return view instanceof ProjectViewImpl ? (ToggleOptionAction.Option)optionSupplier.apply((ProjectViewImpl)view) : null;
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "optionSupplier", "com/intellij/ide/projectView/impl/ProjectViewImpl$Action", "<init>"));
        }

        static final class SortByType
        extends Action {
            SortByType() {
                super(view -> view.mySortByType);
            }
        }

        static final class ShowVisibilityIcons
        extends Action {
            ShowVisibilityIcons() {
                super(view -> view.myShowVisibilityIcons);
            }
        }

        static final class ShowModules
        extends Action {
            ShowModules() {
                super(view -> view.myShowModules);
            }
        }

        static final class ShowMembers
        extends Action {
            ShowMembers() {
                super(view -> view.myShowMembers);
            }
        }

        static final class ShowLibraryContents
        extends Action {
            ShowLibraryContents() {
                super(view -> view.myShowLibraryContents);
            }
        }

        static final class ShowExcludedFiles
        extends Action {
            ShowExcludedFiles() {
                super(view -> view.myShowExcludedFiles);
            }
        }

        static final class ManualOrder
        extends Action {
            ManualOrder() {
                super(view -> view.myManualOrder);
            }
        }

        static final class HideEmptyMiddlePackages
        extends Action {
            HideEmptyMiddlePackages() {
                super(view -> view.myHideEmptyMiddlePackages);
            }
        }

        static final class FoldersAlwaysOnTop
        extends Action {
            FoldersAlwaysOnTop() {
                super(view -> view.myFoldersAlwaysOnTop);
            }
        }

        static final class FlattenPackages
        extends Action {
            FlattenPackages() {
                super(view -> view.myFlattenPackages);
            }
        }

        static final class FlattenModules
        extends Action {
            FlattenModules() {
                super(view -> view.myFlattenModules);
            }
        }

        static final class CompactDirectories
        extends Action {
            CompactDirectories() {
                super(view -> view.myCompactDirectories);
            }
        }

        static final class OpenInPreviewTab
        extends Action {
            OpenInPreviewTab() {
                super(view -> view.myOpenInPreviewTab);
            }
        }

        static final class AutoscrollToSource
        extends Action {
            AutoscrollToSource() {
                super(view -> view.myAutoscrollToSource);
            }
        }

        static final class AutoscrollFromSource
        extends Action {
            AutoscrollFromSource() {
                super(view -> view.myAutoscrollFromSource);
            }
        }

        static final class AbbreviatePackageNames
        extends Action {
            AbbreviatePackageNames() {
                super(view -> view.myAbbreviatePackageNames);
            }
        }
    }

    abstract class Option
    implements ToggleOptionAction.Option {
        Option() {
        }

        public boolean isEnabled() {
            return this.isEnabled(ProjectViewImpl.this.getCurrentViewId());
        }

        boolean isEnabled(@Nullable String paneId) {
            AbstractProjectViewPane pane2 = ProjectViewImpl.this.myId2Pane.get(paneId);
            return pane2 != null ? this.isEnabled(pane2) : ApplicationManager.getApplication().isUnitTestMode();
        }

        boolean isEnabled(@NotNull AbstractProjectViewPane pane2) {
            if (pane2 == null) {
                Option.$$$reportNull$$$0(0);
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ProjectViewImpl.ELEMENT_PANE, "com/intellij/ide/projectView/impl/ProjectViewImpl$Option", "isEnabled"));
        }
    }

    private class EditorSelectInContext
    extends SimpleSelectInContext {
        private final Editor editor;

        EditorSelectInContext(@NotNull PsiFile psiFile, Editor editor) {
            if (psiFile == null) {
                EditorSelectInContext.$$$reportNull$$$0(0);
            }
            if (editor == null) {
                EditorSelectInContext.$$$reportNull$$$0(1);
            }
            super(psiFile);
            this.editor = editor;
        }

        @Override
        void selectInCurrentTarget(boolean requestFocus) {
            if (PsiDocumentManager.getInstance((Project)this.getProject()) == null) {
                return;
            }
            this.runWhenPsiAtCaretIsParsed(() -> super.selectInCurrentTarget(requestFocus));
        }

        private void runWhenPsiAtCaretIsParsed(Runnable runnable2) {
            int offset = this.editor.getCaretModel().getOffset();
            ReadAction.nonBlocking(() -> {
                PsiFile file2 = this.getPsiFile();
                return file2 == null ? null : file2.findElementAt(offset);
            }).withDocumentsCommitted(this.getProject()).finishOnUiThread(ModalityState.defaultModalityState(), parsedLeaf -> {
                if (this.editor.getCaretModel().getOffset() != offset) {
                    this.runWhenPsiAtCaretIsParsed(runnable2);
                } else {
                    runnable2.run();
                }
            }).coalesceBy(new Object[]{EditorSelectInContext.class, ProjectViewImpl.this}).expireWhen(() -> ((Editor)this.editor).isDisposed()).submit((Executor)AppExecutorUtil.getAppExecutorService());
        }

        public Object getSelectorInFile() {
            PsiFile file2 = this.getPsiFile();
            if (file2 != null) {
                int offset = this.editor.getCaretModel().getOffset();
                PsiDocumentManager manager2 = PsiDocumentManager.getInstance((Project)this.getProject());
                LOG.assertTrue(manager2.isCommitted(this.editor.getDocument()));
                PsiElement element2 = file2.findElementAt(offset);
                if (element2 != null) {
                    return element2;
                }
            }
            return file2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "psiFile";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "editor";
                    break;
                }
            }
            objectArray[1] = "com/intellij/ide/projectView/impl/ProjectViewImpl$EditorSelectInContext";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class SimpleSelectInContext
    extends SmartSelectInContext {
        SimpleSelectInContext(PsiFile psiFile) {
            if (psiFile == null) {
                SimpleSelectInContext.$$$reportNull$$$0(0);
            }
            super(psiFile, (PsiElement)psiFile);
        }

        void selectInCurrentTarget(boolean requestFocus) {
            SelectInTarget target2 = ProjectViewImpl.this.getCurrentSelectInTarget();
            if (target2 != null && this.getPsiFile() != null) {
                this.selectIn(target2, requestFocus);
            }
        }

        @NotNull
        public FileEditorProvider getFileEditorProvider() {
            FileEditorProvider fileEditorProvider = () -> (FileEditor)ArrayUtil.getFirstElement((Object[])FileEditorManager.getInstance((Project)ProjectViewImpl.this.myProject).openFile(this.getVirtualFile(), false));
            if (fileEditorProvider == null) {
                SimpleSelectInContext.$$$reportNull$$$0(1);
            }
            return fileEditorProvider;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiFile";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/projectView/impl/ProjectViewImpl$SimpleSelectInContext";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/projectView/impl/ProjectViewImpl$SimpleSelectInContext";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFileEditorProvider";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private final class MyAutoScrollFromSourceHandler
    extends AutoScrollFromSourceHandler {
        private MyAutoScrollFromSourceHandler() {
            super(ProjectViewImpl.this.myProject, (JComponent)ProjectViewImpl.this.myViewContentPanel, (Disposable)ProjectViewImpl.this.myProject);
        }

        void cancelAllRequests() {
            this.myAlarm.cancelAllRequests();
        }

        void addRequest(@NotNull Runnable request) {
            if (request == null) {
                MyAutoScrollFromSourceHandler.$$$reportNull$$$0(0);
            }
            this.myAlarm.cancelAllRequests();
            this.myAlarm.addRequest(request, this.getAlarmDelay(), this.getModalityState());
        }

        protected void selectElementFromEditor(@NotNull FileEditor fileEditor) {
            SimpleSelectInContext context2;
            if (fileEditor == null) {
                MyAutoScrollFromSourceHandler.$$$reportNull$$$0(1);
            }
            if (this.myProject.isDisposed() || !ProjectViewImpl.this.myViewContentPanel.isShowing()) {
                return;
            }
            if (ProjectViewImpl.this.isAutoscrollFromSource(ProjectViewImpl.this.getCurrentViewId()) && !this.isCurrentProjectViewPaneFocused() && (context2 = this.getSelectInContext(fileEditor)) != null) {
                context2.selectInCurrentTarget(false);
            }
        }

        void scrollFromSource(boolean requestFocus) {
            SimpleSelectInContext context2 = this.findSelectInContext();
            if (context2 != null) {
                context2.selectInCurrentTarget(requestFocus);
            }
        }

        @Nullable
        SimpleSelectInContext findSelectInContext() {
            FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)this.myProject);
            SimpleSelectInContext context2 = this.getSelectInContext(fileEditorManager.getSelectedEditor());
            if (context2 != null) {
                return context2;
            }
            for (FileEditor fileEditor : fileEditorManager.getSelectedEditors()) {
                context2 = this.getSelectInContext(fileEditor);
                if (context2 == null) continue;
                return context2;
            }
            return null;
        }

        @Nullable
        private SimpleSelectInContext getSelectInContext(@Nullable FileEditor fileEditor) {
            if (fileEditor instanceof TextEditor) {
                TextEditor textEditor = (TextEditor)fileEditor;
                PsiFile psiFile = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(textEditor.getEditor().getDocument());
                return psiFile == null ? null : new EditorSelectInContext(psiFile, textEditor.getEditor());
            }
            PsiFile psiFile = this.getPsiFile(this.getVirtualFile(fileEditor));
            return psiFile == null ? null : new SimpleSelectInContext(psiFile);
        }

        private PsiFile getPsiFile(VirtualFile file2) {
            return file2 == null || !file2.isValid() ? null : PsiManager.getInstance((Project)this.myProject).findFile(file2);
        }

        private VirtualFile getVirtualFile(FileEditor fileEditor) {
            return fileEditor == null ? null : fileEditor.getFile();
        }

        private boolean isCurrentProjectViewPaneFocused() {
            AbstractProjectViewPane pane2 = ProjectViewImpl.this.getCurrentProjectViewPane();
            return pane2 != null && IJSwingUtilities.hasFocus(pane2.getComponentToFocus());
        }

        protected boolean isAutoScrollEnabled() {
            return ProjectViewImpl.this.myAutoscrollFromSource.isSelected();
        }

        protected void setAutoScrollEnabled(boolean state) {
            ProjectViewImpl.this.myAutoscrollFromSource.setSelected(state);
        }

        protected String getActionName() {
            return ActionsBundle.message((String)"action.ProjectView.AutoscrollFromSource.text", (Object[])new Object[0]);
        }

        protected String getActionDescription() {
            return ActionsBundle.message((String)"action.ProjectView.AutoscrollFromSource.description", (Object[])new Object[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "request";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fileEditor";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ide/projectView/impl/ProjectViewImpl$MyAutoScrollFromSourceHandler";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addRequest";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "selectElementFromEditor";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class SelectionInfo {
        private final Object @NotNull [] myElements;

        private SelectionInfo(Object @NotNull [] elements) {
            if (elements == null) {
                SelectionInfo.$$$reportNull$$$0(0);
            }
            this.myElements = elements;
        }

        public void apply(AbstractProjectViewPane viewPane) {
            if (viewPane == null) {
                return;
            }
            AbstractTreeBuilder treeBuilder = viewPane.getTreeBuilder();
            DnDAwareTree tree = viewPane.myTree;
            if (treeBuilder != null) {
                DefaultTreeModel treeModel = (DefaultTreeModel)((JTree)((Object)tree)).getModel();
                ArrayList<TreePath> paths = new ArrayList<TreePath>(this.myElements.length);
                for (Object element2 : this.myElements) {
                    DefaultMutableTreeNode node = treeBuilder.getNodeForElement(element2);
                    if (node == null) {
                        treeBuilder.buildNodeForElement(element2);
                        node = treeBuilder.getNodeForElement(element2);
                    }
                    if (node == null) continue;
                    paths.add(new TreePath(treeModel.getPathToRoot(node)));
                }
                if (!paths.isEmpty()) {
                    ((JTree)((Object)tree)).setSelectionPaths(TreePathUtil.toTreePathArray(paths));
                }
            } else {
                List<TreeVisitor> visitors = AbstractProjectViewPane.createVisitors(this.myElements);
                if (1 == visitors.size()) {
                    TreeUtil.promiseSelect((JTree)((Object)tree), (TreeVisitor)visitors.get(0));
                } else if (!visitors.isEmpty()) {
                    TreeUtil.promiseSelect((JTree)((Object)tree), visitors.stream());
                }
            }
        }

        @NotNull
        public static SelectionInfo create(AbstractProjectViewPane viewPane) {
            TreePath[] selectionPaths;
            List selectedElements = Collections.emptyList();
            if (viewPane != null && (selectionPaths = viewPane.getSelectionPaths()) != null) {
                selectedElements = new ArrayList();
                for (TreePath path2 : selectionPaths) {
                    NodeDescriptor descriptor2 = (NodeDescriptor)TreeUtil.getLastUserObject(NodeDescriptor.class, (TreePath)path2);
                    if (descriptor2 == null) continue;
                    selectedElements.add(descriptor2.getElement());
                }
            }
            return new SelectionInfo(selectedElements.toArray());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/ide/projectView/impl/ProjectViewImpl$SelectionInfo", "<init>"));
        }
    }

    private final class MyPanel
    extends JPanel
    implements DataProvider {
        MyPanel() {
            super(new BorderLayout());
            ArrayList<AbstractProjectViewPane> snapshot = new ArrayList<AbstractProjectViewPane>(ProjectViewImpl.this.myId2Pane.values());
            ComponentUtil.putClientProperty((JComponent)this, (Key)UIUtil.NOT_IN_HIERARCHY_COMPONENTS, () -> JBIterable.from((Iterable)snapshot).map(pane2 -> {
                JComponent last = null;
                for (Component c : UIUtil.uiParents((Component)pane2.getComponentToFocus(), (boolean)false)) {
                    if (c == this || !(c instanceof JComponent)) {
                        return null;
                    }
                    last = (JComponent)c;
                }
                return last;
            }).filter(Conditions.notNull()).iterator());
        }

        @Nullable
        private Object getSelectedNodeElement() {
            AbstractProjectViewPane currentProjectViewPane = ProjectViewImpl.this.getCurrentProjectViewPane();
            if (currentProjectViewPane == null) {
                return null;
            }
            NodeDescriptor descriptor2 = (NodeDescriptor)TreeUtil.getLastUserObject(NodeDescriptor.class, (TreePath)currentProjectViewPane.getSelectedPath());
            if (descriptor2 == null) {
                return null;
            }
            return descriptor2 instanceof AbstractTreeNode ? ((AbstractTreeNode)descriptor2).getValue() : descriptor2.getElement();
        }

        @Override
        public Object getData(@NotNull String dataId) {
            List<Object> selectedElements;
            Object selected2;
            PsiElement[] elements;
            Object paneSpecificData;
            AbstractProjectViewPane currentProjectViewPane;
            if (dataId == null) {
                MyPanel.$$$reportNull$$$0(0);
            }
            if ((currentProjectViewPane = ProjectViewImpl.this.getCurrentProjectViewPane()) != null && (paneSpecificData = currentProjectViewPane.getData(dataId)) != null) {
                return paneSpecificData;
            }
            if (CommonDataKeys.PSI_ELEMENT.is(dataId)) {
                if (currentProjectViewPane == null) {
                    return null;
                }
                elements = currentProjectViewPane.getSelectedPSIElements();
                return elements.length == 1 ? elements[0] : null;
            }
            if (LangDataKeys.PSI_ELEMENT_ARRAY.is(dataId)) {
                if (currentProjectViewPane == null) {
                    return null;
                }
                elements = currentProjectViewPane.getSelectedPSIElements();
                return elements.length == 0 ? null : elements;
            }
            if (LangDataKeys.MODULE.is(dataId)) {
                VirtualFile[] virtualFiles = (VirtualFile[])this.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY.getName());
                if (virtualFiles == null || virtualFiles.length <= 1) {
                    return null;
                }
                HashSet<Module> modules2 = new HashSet<Module>();
                for (VirtualFile virtualFile2 : virtualFiles) {
                    modules2.add(ModuleUtilCore.findModuleForFile((VirtualFile)virtualFile2, (Project)ProjectViewImpl.this.myProject));
                }
                return modules2.size() == 1 ? modules2.iterator().next() : null;
            }
            if (PlatformDataKeys.CUT_PROVIDER.is(dataId)) {
                return ProjectViewImpl.this.myCopyPasteDelegator.getCutProvider();
            }
            if (PlatformDataKeys.COPY_PROVIDER.is(dataId)) {
                return ProjectViewImpl.this.myCopyPasteDelegator.getCopyProvider();
            }
            if (PlatformDataKeys.PASTE_PROVIDER.is(dataId)) {
                return ProjectViewImpl.this.myCopyPasteDelegator.getPasteProvider();
            }
            if (LangDataKeys.IDE_VIEW.is(dataId)) {
                return ProjectViewImpl.this.myIdeView;
            }
            if (PlatformDataKeys.DELETE_ELEMENT_PROVIDER.is(dataId)) {
                Module[] modules3 = this.getSelectedModules();
                if (modules3 != null || !this.getSelectedUnloadedModules().isEmpty()) {
                    return ModuleDeleteProvider.getInstance();
                }
                final LibraryOrderEntry orderEntry = this.getSelectedLibrary();
                if (orderEntry != null) {
                    return new DeleteProvider(){

                        public void deleteElement(@NotNull DataContext dataContext) {
                            if (dataContext == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            MyPanel.this.detachLibrary(orderEntry, ProjectViewImpl.this.myProject);
                        }

                        public boolean canDeleteElement(@NotNull DataContext dataContext) {
                            if (dataContext == null) {
                                1.$$$reportNull$$$0(1);
                            }
                            return true;
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            Object[] objectArray;
                            Object[] objectArray2 = new Object[3];
                            objectArray2[0] = "dataContext";
                            objectArray2[1] = "com/intellij/ide/projectView/impl/ProjectViewImpl$MyPanel$1";
                            switch (n) {
                                default: {
                                    objectArray = objectArray2;
                                    objectArray2[2] = "deleteElement";
                                    break;
                                }
                                case 1: {
                                    objectArray = objectArray2;
                                    objectArray2[2] = "canDeleteElement";
                                    break;
                                }
                            }
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                        }
                    };
                }
                return ProjectViewImpl.this.myDeletePSIElementProvider;
            }
            if (PlatformDataKeys.HELP_ID.is(dataId)) {
                return "viewingStructure.projectViews";
            }
            if (PlatformDataKeys.PROJECT_CONTEXT.is(dataId)) {
                selected2 = this.getSelectedNodeElement();
                return selected2 instanceof Project ? selected2 : null;
            }
            if (LangDataKeys.MODULE_CONTEXT.is(dataId)) {
                selected2 = this.getSelectedNodeElement();
                if (selected2 instanceof Module) {
                    return !((Module)selected2).isDisposed() ? selected2 : null;
                }
                if (selected2 instanceof PsiDirectory) {
                    return ProjectViewImpl.this.moduleBySingleContentRoot(((PsiDirectory)selected2).getVirtualFile());
                }
                if (selected2 instanceof VirtualFile) {
                    return ProjectViewImpl.this.moduleBySingleContentRoot((VirtualFile)selected2);
                }
                return null;
            }
            if (LangDataKeys.MODULE_CONTEXT_ARRAY.is(dataId)) {
                return this.getSelectedModules();
            }
            if (ProjectView.UNLOADED_MODULES_CONTEXT_KEY.is(dataId)) {
                return Collections.unmodifiableList(this.getSelectedUnloadedModules());
            }
            if (ModuleGroup.ARRAY_DATA_KEY.is(dataId)) {
                selectedElements = ProjectViewImpl.this.getSelectedElements(ModuleGroup.class);
                return selectedElements.isEmpty() ? null : selectedElements.toArray(new ModuleGroup[0]);
            }
            if (LibraryGroupElement.ARRAY_DATA_KEY.is(dataId)) {
                selectedElements = ProjectViewImpl.this.getSelectedElements(LibraryGroupElement.class);
                return selectedElements.isEmpty() ? null : selectedElements.toArray(new LibraryGroupElement[0]);
            }
            if (NamedLibraryElement.ARRAY_DATA_KEY.is(dataId)) {
                selectedElements = ProjectViewImpl.this.getSelectedElements(NamedLibraryElement.class);
                return selectedElements.isEmpty() ? null : selectedElements.toArray(new NamedLibraryElement[0]);
            }
            if (PlatformDataKeys.SELECTED_ITEMS.is(dataId)) {
                AbstractProjectViewPane viewPane = ProjectViewImpl.this.getCurrentProjectViewPane();
                return viewPane == null ? null : viewPane.getSelectedElements();
            }
            if (QuickActionProvider.KEY.is(dataId)) {
                return ProjectViewImpl.this;
            }
            return null;
        }

        @Nullable
        private LibraryOrderEntry getSelectedLibrary() {
            AbstractProjectViewPane viewPane = ProjectViewImpl.this.getCurrentProjectViewPane();
            if (viewPane == null) {
                return null;
            }
            TreePath path2 = viewPane.getSelectedPath();
            if (path2 == null) {
                return null;
            }
            TreePath parent = path2.getParentPath();
            if (parent == null) {
                return null;
            }
            Object userObject = TreeUtil.getLastUserObject((TreePath)parent);
            if (userObject instanceof LibraryGroupNode) {
                userObject = TreeUtil.getLastUserObject((TreePath)path2);
                if (userObject instanceof NamedLibraryElementNode) {
                    NamedLibraryElement element2 = (NamedLibraryElement)((NamedLibraryElementNode)((Object)userObject)).getValue();
                    LibraryOrSdkOrderEntry orderEntry = element2.getOrderEntry();
                    return orderEntry instanceof LibraryOrderEntry ? (LibraryOrderEntry)orderEntry : null;
                }
                PsiDirectory directory = (PsiDirectory)((PsiDirectoryNode)((Object)userObject)).getValue();
                VirtualFile virtualFile2 = directory.getVirtualFile();
                Module module = (Module)((AbstractTreeNode)TreeUtil.getLastUserObject(AbstractTreeNode.class, (TreePath)parent.getParentPath())).getValue();
                if (module == null) {
                    return null;
                }
                ModuleFileIndex index2 = ModuleRootManager.getInstance((Module)module).getFileIndex();
                OrderEntry entry2 = index2.getOrderEntryForFile(virtualFile2);
                if (entry2 instanceof LibraryOrderEntry) {
                    return (LibraryOrderEntry)entry2;
                }
            }
            return null;
        }

        private void detachLibrary(@NotNull LibraryOrderEntry orderEntry, @NotNull Project project) {
            String title2;
            if (orderEntry == null) {
                MyPanel.$$$reportNull$$$0(1);
            }
            if (project == null) {
                MyPanel.$$$reportNull$$$0(2);
            }
            Module module = orderEntry.getOwnerModule();
            String message2 = IdeBundle.message((String)"detach.library.from.module", (Object[])new Object[]{orderEntry.getPresentableName(), module.getName()});
            int ret = Messages.showOkCancelDialog((Project)project, (String)message2, (String)(title2 = IdeBundle.message((String)"detach.library", (Object[])new Object[0])), (Icon)Messages.getQuestionIcon());
            if (ret != 0) {
                return;
            }
            CommandProcessor.getInstance().executeCommand(module.getProject(), () -> {
                Runnable action2 = () -> {
                    ModuleRootManager rootManager = ModuleRootManager.getInstance((Module)module);
                    OrderEntry[] orderEntries = rootManager.getOrderEntries();
                    ModifiableRootModel model2 = rootManager.getModifiableModel();
                    OrderEntry[] modifiableEntries = model2.getOrderEntries();
                    for (int i2 = 0; i2 < orderEntries.length; ++i2) {
                        OrderEntry entry2 = orderEntries[i2];
                        if (!(entry2 instanceof LibraryOrderEntry) || ((LibraryOrderEntry)entry2).getLibrary() != orderEntry.getLibrary()) continue;
                        model2.removeOrderEntry(modifiableEntries[i2]);
                    }
                    model2.commit();
                };
                ApplicationManager.getApplication().runWriteAction(action2);
            }, title2, null);
        }

        private Module @Nullable [] getSelectedModules() {
            AbstractProjectViewPane viewPane = ProjectViewImpl.this.getCurrentProjectViewPane();
            if (viewPane == null) {
                return null;
            }
            Object[] elements = viewPane.getSelectedElements();
            ArrayList<Module> result2 = new ArrayList<Module>();
            for (Object element2 : elements) {
                Module module;
                if (element2 instanceof Module) {
                    module = (Module)element2;
                    if (module.isDisposed()) continue;
                    result2.add(module);
                    continue;
                }
                if (element2 instanceof ModuleGroup) {
                    Collection<Module> modules2 = ((ModuleGroup)element2).modulesInGroup(ProjectViewImpl.this.myProject, true);
                    result2.addAll(modules2);
                    continue;
                }
                if (element2 instanceof PsiDirectory) {
                    module = ProjectViewImpl.this.moduleBySingleContentRoot(((PsiDirectory)element2).getVirtualFile());
                    if (module == null) continue;
                    result2.add(module);
                    continue;
                }
                if (!(element2 instanceof VirtualFile) || (module = ProjectViewImpl.this.moduleBySingleContentRoot((VirtualFile)element2)) == null) continue;
                result2.add(module);
            }
            return result2.isEmpty() ? null : result2.toArray(Module.EMPTY_ARRAY);
        }

        private List<UnloadedModuleDescription> getSelectedUnloadedModules() {
            AbstractProjectViewPane viewPane = ProjectViewImpl.this.getCurrentProjectViewPane();
            if (viewPane == null) {
                return Collections.emptyList();
            }
            SmartList result2 = new SmartList();
            for (Object element2 : viewPane.getSelectedElements()) {
                if (element2 instanceof PsiDirectory) {
                    ContainerUtil.addIfNotNull((Collection)result2, (Object)ProjectViewImpl.this.getUnloadedModuleByContentRoot(((PsiDirectory)element2).getVirtualFile()));
                    continue;
                }
                if (!(element2 instanceof VirtualFile)) continue;
                ContainerUtil.addIfNotNull((Collection)result2, (Object)ProjectViewImpl.this.getUnloadedModuleByContentRoot((VirtualFile)element2));
            }
            return result2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataId";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "orderEntry";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ide/projectView/impl/ProjectViewImpl$MyPanel";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getData";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "detachLibrary";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private final class MyDeletePSIElementProvider
    extends ProjectViewDeleteElementProvider {
        private MyDeletePSIElementProvider() {
        }

        @Override
        protected PsiElement @NotNull [] getSelectedPSIElements(@NotNull DataContext dataContext) {
            if (dataContext == null) {
                MyDeletePSIElementProvider.$$$reportNull$$$0(0);
            }
            AbstractProjectViewPane viewPane = ProjectViewImpl.this.getCurrentProjectViewPane();
            PsiElement[] psiElementArray = viewPane.getSelectedPSIElements();
            if (psiElementArray == null) {
                MyDeletePSIElementProvider.$$$reportNull$$$0(1);
            }
            return psiElementArray;
        }

        @Override
        protected Boolean hideEmptyMiddlePackages(@NotNull DataContext dataContext) {
            if (dataContext == null) {
                MyDeletePSIElementProvider.$$$reportNull$$$0(2);
            }
            AbstractProjectViewPane viewPane = ProjectViewImpl.this.getCurrentProjectViewPane();
            return ProjectViewImpl.this.isHideEmptyMiddlePackages(viewPane.getId());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataContext";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/projectView/impl/ProjectViewImpl$MyDeletePSIElementProvider";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/projectView/impl/ProjectViewImpl$MyDeletePSIElementProvider";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSelectedPSIElements";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getSelectedPSIElements";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "hideEmptyMiddlePackages";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private final class ChangeViewAction
    extends AnAction {
        @NotNull
        private final String myId;
        @Nullable
        private final String mySubId;

        private ChangeViewAction(@Nullable String id2, String subId) {
            if (id2 == null) {
                ChangeViewAction.$$$reportNull$$$0(0);
            }
            this.myId = id2;
            this.mySubId = subId;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                ChangeViewAction.$$$reportNull$$$0(1);
            }
            AbstractProjectViewPane pane2 = ProjectViewImpl.this.getProjectViewPaneById(this.myId);
            e.getPresentation().setText(this.mySubId != null ? pane2.getPresentableSubIdName(this.mySubId) : pane2.getTitle());
            e.getPresentation().setIcon(this.mySubId != null ? pane2.getPresentableSubIdIcon(this.mySubId) : pane2.getIcon());
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                ChangeViewAction.$$$reportNull$$$0(2);
            }
            ProjectViewImpl.this.changeView(this.myId, this.mySubId);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = ProjectViewImpl.ATTRIBUTE_ID;
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ide/projectView/impl/ProjectViewImpl$ChangeViewAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

