/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins.newui;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.PluginEnableDisableAction;
import com.intellij.ide.plugins.PluginEnabledState;
import com.intellij.ide.plugins.PluginEnabler;
import com.intellij.ide.plugins.newui.EventHandler;
import com.intellij.ide.plugins.newui.MyPluginModel;
import com.intellij.ide.plugins.newui.TabbedPaneHeaderComponent;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Function;
import com.intellij.util.Producer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.Component;
import java.lang.invoke.LambdaMetafactory;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

abstract class SelectionBasedPluginModelAction<C extends JComponent, D extends IdeaPluginDescriptor>
extends DumbAwareAction {
    @NotNull
    protected final MyPluginModel myPluginModel;
    protected final boolean myShowShortcut;
    @NotNull
    private final List<? extends C> mySelection;
    @NotNull
    private final java.util.function.Function<? super C, ? extends D> myPluginDescriptor;

    protected SelectionBasedPluginModelAction(@NotNull @Nls String text2, @NotNull MyPluginModel pluginModel, boolean showShortcut, @NotNull List<? extends C> selection, @NotNull java.util.function.Function<? super C, ? extends D> pluginDescriptor) {
        if (text2 == null) {
            SelectionBasedPluginModelAction.$$$reportNull$$$0(0);
        }
        if (pluginModel == null) {
            SelectionBasedPluginModelAction.$$$reportNull$$$0(1);
        }
        if (selection == null) {
            SelectionBasedPluginModelAction.$$$reportNull$$$0(2);
        }
        if (pluginDescriptor == null) {
            SelectionBasedPluginModelAction.$$$reportNull$$$0(3);
        }
        super(text2);
        this.myPluginModel = pluginModel;
        this.myShowShortcut = showShortcut;
        this.mySelection = selection;
        this.myPluginDescriptor = pluginDescriptor;
    }

    protected final void setShortcutSet(@NotNull ShortcutSet shortcutSet, boolean show2) {
        if (shortcutSet == null) {
            SelectionBasedPluginModelAction.$$$reportNull$$$0(4);
        }
        this.setShortcutSet((ShortcutSet)(show2 ? shortcutSet : CustomShortcutSet.EMPTY));
    }

    @NotNull
    protected final Map<C, D> getSelection() {
        LinkedHashMap<JComponent, IdeaPluginDescriptor> map2 = new LinkedHashMap<JComponent, IdeaPluginDescriptor>();
        for (JComponent component2 : this.mySelection) {
            IdeaPluginDescriptor descriptor2 = (IdeaPluginDescriptor)this.myPluginDescriptor.apply(component2);
            if (descriptor2 == null) continue;
            map2.put(component2, descriptor2);
        }
        Map map3 = Collections.unmodifiableMap(map2);
        if (map3 == null) {
            SelectionBasedPluginModelAction.$$$reportNull$$$0(5);
        }
        return map3;
    }

    @NotNull
    protected final Collection<? extends D> getAllDescriptors() {
        Collection<D> collection = this.getSelection().values();
        if (collection == null) {
            SelectionBasedPluginModelAction.$$$reportNull$$$0(6);
        }
        return collection;
    }

    static <C extends JComponent> void addActionsTo(@NotNull DefaultActionGroup group2, @NotNull @NotNull java.util.function.Function<? super @NotNull PluginEnableDisableAction, @NotNull EnableDisableAction<C>> createEnableDisableAction, @NotNull @NotNull Producer<@NotNull UninstallAction<C>> createUninstallAction) {
        if (group2 == null) {
            SelectionBasedPluginModelAction.$$$reportNull$$$0(7);
        }
        if (createEnableDisableAction == null) {
            SelectionBasedPluginModelAction.$$$reportNull$$$0(8);
        }
        if (createUninstallAction == null) {
            SelectionBasedPluginModelAction.$$$reportNull$$$0(9);
        }
        PluginEnableDisableAction[] actions2 = PluginEnableDisableAction.values();
        for (int i2 = 0; i2 < actions2.length; ++i2) {
            group2.add((AnAction)createEnableDisableAction.apply(actions2[i2]));
            if ((i2 + 1) % 3 != 0) continue;
            group2.addSeparator();
        }
        group2.add((AnAction)createUninstallAction.produce());
    }

    @NotNull
    static <C extends JComponent> JComponent createGearButton(@NotNull @NotNull java.util.function.Function<@NotNull PluginEnableDisableAction, @NotNull EnableDisableAction<C>> createEnableDisableAction, @NotNull @NotNull Producer<@NotNull UninstallAction<C>> createUninstallAction) {
        if (createEnableDisableAction == null) {
            SelectionBasedPluginModelAction.$$$reportNull$$$0(10);
        }
        if (createUninstallAction == null) {
            SelectionBasedPluginModelAction.$$$reportNull$$$0(11);
        }
        DefaultActionGroup result2 = new DefaultActionGroup();
        SelectionBasedPluginModelAction.addActionsTo(result2, createEnableDisableAction, createUninstallAction);
        JComponent jComponent = TabbedPaneHeaderComponent.createToolbar(result2, IdeBundle.message((String)"plugin.settings.link.title", (Object[])new Object[0]), AllIcons.General.GearHover);
        if (jComponent == null) {
            SelectionBasedPluginModelAction.$$$reportNull$$$0(12);
        }
        return jComponent;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginModel";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selection";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginDescriptor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shortcutSet";
                break;
            }
            case 5: 
            case 6: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/plugins/newui/SelectionBasedPluginModelAction";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "createEnableDisableAction";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "createUninstallAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/plugins/newui/SelectionBasedPluginModelAction";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelection";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllDescriptors";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createGearButton";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setShortcutSet";
                break;
            }
            case 5: 
            case 6: 
            case 12: {
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addActionsTo";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createGearButton";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static final class UninstallAction<C extends JComponent>
    extends SelectionBasedPluginModelAction<C, IdeaPluginDescriptorImpl> {
        private static final ShortcutSet SHORTCUT_SET;
        @NotNull
        private final JComponent myUiParent;

        UninstallAction(@NotNull MyPluginModel pluginModel, boolean showShortcut, @NotNull JComponent uiParent, @NotNull List<? extends C> selection, @NotNull java.util.function.Function<? super C, ? extends IdeaPluginDescriptor> pluginDescriptor) {
            if (pluginModel == null) {
                UninstallAction.$$$reportNull$$$0(0);
            }
            if (uiParent == null) {
                UninstallAction.$$$reportNull$$$0(1);
            }
            if (selection == null) {
                UninstallAction.$$$reportNull$$$0(2);
            }
            if (pluginDescriptor == null) {
                UninstallAction.$$$reportNull$$$0(3);
            }
            super(IdeBundle.message((String)"plugins.configurable.uninstall", (Object[])new Object[0]), pluginModel, showShortcut, selection, pluginDescriptor.andThen(descriptor2 -> descriptor2 instanceof IdeaPluginDescriptorImpl ? (IdeaPluginDescriptorImpl)descriptor2 : null));
            this.myUiParent = uiParent;
        }

        /*
         * Unable to fully structure code
         */
        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                UninstallAction.$$$reportNull$$$0(4);
            }
            if ((descriptors = this.getAllDescriptors()).isEmpty() || ContainerUtil.exists(descriptors, (Condition)(Condition)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, isBundled(), (Lcom/intellij/ide/plugins/IdeaPluginDescriptorImpl;)Z)())) ** GOTO lbl-1000
            if (ContainerUtil.exists(descriptors, (Condition)(Condition)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, isUninstalled(com.intellij.ide.plugins.IdeaPluginDescriptor ), (Lcom/intellij/ide/plugins/IdeaPluginDescriptorImpl;)Z)((MyPluginModel)this.myPluginModel))) lbl-1000:
            // 2 sources

            {
                v0 = true;
            } else {
                v0 = false;
            }
            disabled = v0;
            e.getPresentation().setEnabledAndVisible(disabled == false);
            this.setShortcutSet(UninstallAction.SHORTCUT_SET, this.myShowShortcut);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Map selection;
            if (e == null) {
                UninstallAction.$$$reportNull$$$0(5);
            }
            if (!UninstallAction.askToUninstall(UninstallAction.getUninstallAllMessage((selection = this.getSelection()).values()), this.myUiParent)) {
                return;
            }
            for (Map.Entry entry2 : selection.entrySet()) {
                IdeaPluginDescriptorImpl descriptor2 = (IdeaPluginDescriptorImpl)entry2.getValue();
                List<? extends IdeaPluginDescriptor> dependents = this.myPluginModel.getDependents(descriptor2);
                if (!dependents.isEmpty() && !UninstallAction.askToUninstall(UninstallAction.getUninstallDependentsMessage(descriptor2, dependents), (JComponent)entry2.getKey())) continue;
                this.myPluginModel.uninstallAndUpdateUi(descriptor2);
            }
        }

        @NotNull
        @Nls
        private static String getUninstallAllMessage(@NotNull Collection<IdeaPluginDescriptorImpl> descriptors2) {
            if (descriptors2 == null) {
                UninstallAction.$$$reportNull$$$0(6);
            }
            String string = descriptors2.size() == 1 ? IdeBundle.message((String)"prompt.uninstall.plugin", (Object[])new Object[]{descriptors2.iterator().next().getName()}) : IdeBundle.message((String)"prompt.uninstall.several.plugins", (Object[])new Object[]{descriptors2.size()});
            if (string == null) {
                UninstallAction.$$$reportNull$$$0(7);
            }
            return string;
        }

        @NotNull
        @Nls
        private static String getUninstallDependentsMessage(@NotNull IdeaPluginDescriptorImpl descriptor2, @NotNull List<? extends IdeaPluginDescriptor> dependents) {
            if (descriptor2 == null) {
                UninstallAction.$$$reportNull$$$0(8);
            }
            if (dependents == null) {
                UninstallAction.$$$reportNull$$$0(9);
            }
            String listOfDeps = StringUtil.join(dependents, plugin2 -> "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;" + plugin2.getName(), (String)"<br>");
            String message2 = IdeBundle.message((String)"dialog.message.following.plugin.depend.on", (Object[])new Object[]{dependents.size(), descriptor2.getName(), listOfDeps});
            String string = XmlStringUtil.wrapInHtml((CharSequence)message2);
            if (string == null) {
                UninstallAction.$$$reportNull$$$0(10);
            }
            return string;
        }

        private static boolean askToUninstall(@NotNull @Nls String message2, @NotNull JComponent parentComponent) {
            if (message2 == null) {
                UninstallAction.$$$reportNull$$$0(11);
            }
            if (parentComponent == null) {
                UninstallAction.$$$reportNull$$$0(12);
            }
            return MessageDialogBuilder.yesNo((String)IdeBundle.message((String)"title.plugin.uninstall", (Object[])new Object[0]), (String)message2).ask((Component)parentComponent);
        }

        static {
            ShortcutSet deleteShortcutSet = EventHandler.getShortcuts("EditorDelete");
            SHORTCUT_SET = deleteShortcutSet != null ? deleteShortcutSet : new CustomShortcutSet(new Integer[]{EventHandler.DELETE_CODE});
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 7: 
                case 10: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 7: 
                case 10: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pluginModel";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "uiParent";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "selection";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pluginDescriptor";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptors";
                    break;
                }
                case 7: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/plugins/newui/SelectionBasedPluginModelAction$UninstallAction";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dependents";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "message";
                    break;
                }
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parentComponent";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/plugins/newui/SelectionBasedPluginModelAction$UninstallAction";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUninstallAllMessage";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUninstallDependentsMessage";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "getUninstallAllMessage";
                    break;
                }
                case 7: 
                case 10: {
                    break;
                }
                case 8: 
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "getUninstallDependentsMessage";
                    break;
                }
                case 11: 
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "askToUninstall";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 7: 
                case 10: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static final class EnableDisableAction<C extends JComponent>
    extends SelectionBasedPluginModelAction<C, IdeaPluginDescriptor> {
        private static final CustomShortcutSet SHORTCUT_SET = new CustomShortcutSet(new Integer[]{32});
        @NotNull
        private final PluginEnableDisableAction myAction;

        EnableDisableAction(@NotNull MyPluginModel pluginModel, @NotNull PluginEnableDisableAction action2, boolean showShortcut, @NotNull List<? extends C> selection, @NotNull java.util.function.Function<? super C, ? extends IdeaPluginDescriptor> pluginDescriptor) {
            if (pluginModel == null) {
                EnableDisableAction.$$$reportNull$$$0(0);
            }
            if (action2 == null) {
                EnableDisableAction.$$$reportNull$$$0(1);
            }
            if (selection == null) {
                EnableDisableAction.$$$reportNull$$$0(2);
            }
            if (pluginDescriptor == null) {
                EnableDisableAction.$$$reportNull$$$0(3);
            }
            super(action2.getPresentableText(), pluginModel, showShortcut, selection, pluginDescriptor);
            this.myAction = action2;
        }

        /*
         * Unable to fully structure code
         */
        public void update(@NotNull AnActionEvent e) {
            block4: {
                block3: {
                    if (e == null) {
                        EnableDisableAction.$$$reportNull$$$0(4);
                    }
                    descriptors = this.getAllDescriptors();
                    pluginIds = ContainerUtil.map2SetNotNull(descriptors, (Function)(Function)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getPluginId(), (Lcom/intellij/ide/plugins/IdeaPluginDescriptor;)Lcom/intellij/openapi/extensions/PluginId;)());
                    states = ContainerUtil.map((Collection)pluginIds, (Function)(Function)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getState(com.intellij.openapi.extensions.PluginId ), (Lcom/intellij/openapi/extensions/PluginId;)Lcom/intellij/ide/plugins/PluginEnabledState;)((MyPluginModel)this.myPluginModel));
                    allEnabled = ContainerUtil.all((Collection)states, (Condition)(Condition)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, equals(java.lang.Object ), (Lcom/intellij/ide/plugins/PluginEnabledState;)Z)((PluginEnabledState)PluginEnabledState.ENABLED));
                    v0 = isForceEnableAll = this.myAction == PluginEnableDisableAction.ENABLE_GLOBALLY && allEnabled == false;
                    if (pluginIds.isEmpty()) ** GOTO lbl-1000
                    if (!ContainerUtil.all((Collection)states, (Condition)(Condition)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, isApplicable(com.intellij.ide.plugins.PluginEnabledState ), (Lcom/intellij/ide/plugins/PluginEnabledState;)Z)((PluginEnableDisableAction)this.myAction))) ** GOTO lbl-1000
                    if (this.myAction == PluginEnableDisableAction.DISABLE_GLOBALLY) break block3;
                    if (this.myAction != PluginEnableDisableAction.DISABLE_FOR_PROJECT) break block4;
                }
                if (ContainerUtil.exists((Iterable)pluginIds, (Condition)(Condition)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, isRequiredPluginForProject(com.intellij.openapi.extensions.PluginId ), (Lcom/intellij/openapi/extensions/PluginId;)Z)((MyPluginModel)this.myPluginModel))) ** GOTO lbl-1000
            }
            if (!this.myAction.isPerProject()) ** GOTO lbl-1000
            if (e.getProject() == null || !PluginEnabler.isPerProjectEnabled() || ContainerUtil.exists((Iterable)pluginIds, (Condition)(Condition)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, isPluginExcluded(com.intellij.openapi.extensions.PluginId ), (Lcom/intellij/openapi/extensions/PluginId;)Z)())) ** GOTO lbl-1000
            if (ContainerUtil.exists(descriptors, (Condition)(Condition)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, requiresRestart(com.intellij.ide.plugins.IdeaPluginDescriptor ), (Lcom/intellij/ide/plugins/IdeaPluginDescriptor;)Z)((MyPluginModel)this.myPluginModel))) lbl-1000:
            // 5 sources

            {
                v1 = true;
            } else lbl-1000:
            // 2 sources

            {
                v1 = false;
            }
            disabled = v1;
            enabled = disabled == false;
            e.getPresentation().setEnabledAndVisible(isForceEnableAll != false || enabled != false);
            isForceDisableAll = this.myAction == PluginEnableDisableAction.DISABLE_GLOBALLY && allEnabled != false;
            this.setShortcutSet((ShortcutSet)EnableDisableAction.SHORTCUT_SET, this.myShowShortcut != false && (isForceEnableAll != false || isForceDisableAll != false));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                EnableDisableAction.$$$reportNull$$$0(5);
            }
            this.myPluginModel.setEnabledState(this.getAllDescriptors(), this.myAction);
        }

        private static boolean isPluginExcluded(@NotNull PluginId pluginId) {
            if (pluginId == null) {
                EnableDisableAction.$$$reportNull$$$0(6);
            }
            return StringUtil.split((String)Registry.stringValue((String)"ide.plugins.per.project.exclusion.list"), (String)",").contains(pluginId.getIdString());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pluginModel";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "action";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "selection";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pluginDescriptor";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pluginId";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ide/plugins/newui/SelectionBasedPluginModelAction$EnableDisableAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isPluginExcluded";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

