/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins.newui;

import com.intellij.ide.plugins.newui.PluginSearchTextField;
import com.intellij.ide.plugins.newui.SearchPopup;
import com.intellij.ide.plugins.newui.SearchPopupCallback;
import com.intellij.ide.plugins.newui.SearchQueryParser;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.util.containers.ContainerUtil;
import java.awt.event.KeyEvent;
import java.util.Collection;
import java.util.List;
import javax.swing.JList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SearchPopupController {
    protected final PluginSearchTextField myTextField;
    protected SearchPopup myPopup;
    private final JBPopupListener mySearchPopupListener;

    public SearchPopupController(@NotNull PluginSearchTextField searchTextField2) {
        if (searchTextField2 == null) {
            SearchPopupController.$$$reportNull$$$0(0);
        }
        this.mySearchPopupListener = new JBPopupListener(){

            public void onClosed(@NotNull LightweightWindowEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                SearchPopupController.this.myPopup = null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/ide/plugins/newui/SearchPopupController$1", "onClosed"));
            }
        };
        this.myTextField = searchTextField2;
    }

    public void handleShowPopup() {
        String query2 = this.myTextField.getText();
        int length = query2.length();
        int position = this.getCaretPosition();
        if (position < length) {
            if (query2.charAt(position) != ' ') {
                this.handleShowPopupForQuery();
                return;
            }
        } else if (query2.charAt(position - 1) == ' ') {
            this.handleShowPopupForQuery();
            return;
        }
        Ref startPosition = new Ref();
        Pair<String, String> attribute = SearchPopupController.parseAttributeInQuery(query2, position, (Ref<? super Integer>)startPosition);
        if (attribute.second == null) {
            this.showAttributesPopup((String)attribute.first, (Integer)startPosition.get());
        } else {
            this.handleShowAttributeValuesPopup((String)attribute.first, (String)attribute.second, (Integer)startPosition.get());
        }
    }

    private int getCaretPosition() {
        return this.myTextField.getTextEditor().getCaretPosition();
    }

    @NotNull
    private static Pair<String, String> parseAttributeInQuery(@NotNull String query2, int end, @NotNull Ref<? super Integer> startPosition) {
        int index2;
        if (query2 == null) {
            SearchPopupController.$$$reportNull$$$0(1);
        }
        if (startPosition == null) {
            SearchPopupController.$$$reportNull$$$0(2);
        }
        String value2 = null;
        for (index2 = end - 1; index2 >= 0; --index2) {
            char ch = query2.charAt(index2);
            if (ch == ':') {
                value2 = query2.substring(index2 + 1, end);
                startPosition.set((Object)(index2 + 1));
                end = index2 + 1;
                --index2;
                while (index2 >= 0 && query2.charAt(index2) != ' ') {
                    --index2;
                }
                break;
            }
            if (ch == ' ') break;
        }
        if (startPosition.isNull()) {
            startPosition.set((Object)(index2 + 1));
        }
        Pair pair = Pair.create((Object)query2.substring(index2 + 1, end), value2);
        if (pair == null) {
            SearchPopupController.$$$reportNull$$$0(3);
        }
        return pair;
    }

    public void showAttributesPopup(@Nullable String namePrefix, int caretPosition) {
        boolean async;
        CollectionListModel model2 = new CollectionListModel(this.getAttributes());
        if (this.noPrefixSearchValues((CollectionListModel<Object>)model2, namePrefix)) {
            return;
        }
        boolean bl = async = this.myPopup != null;
        if (this.updatePopupOrCreate(SearchPopup.Type.AttributeName, (CollectionListModel<Object>)model2, namePrefix, caretPosition)) {
            return;
        }
        this.createAndShow(async, new SearchPopupCallback(namePrefix){

            public void consume(String value2) {
                SearchPopupController.this.appendSearchText(value2, this.prefix);
                SearchPopupController.this.handleShowAttributeValuesPopup(value2, null, SearchPopupController.this.getCaretPosition());
            }
        });
    }

    private void handleShowAttributeValuesPopup(@NotNull String name, @Nullable String valuePrefix, int caretPosition) {
        Collection<String> values2;
        if (name == null) {
            SearchPopupController.$$$reportNull$$$0(4);
        }
        if (ContainerUtil.isEmpty(values2 = this.getValues(name))) {
            this.handleShowPopupForQuery();
            return;
        }
        CollectionListModel model2 = new CollectionListModel(values2);
        if (this.noPrefixSearchValues((CollectionListModel<Object>)model2, valuePrefix)) {
            return;
        }
        if (this.updatePopupOrCreate(SearchPopup.Type.AttributeValue, (CollectionListModel<Object>)model2, valuePrefix, caretPosition)) {
            return;
        }
        this.createAndShow(true, new SearchPopupCallback(valuePrefix){

            public void consume(String value2) {
                SearchPopupController.this.appendSearchText(SearchQueryParser.wrapAttribute(value2), this.prefix);
                SearchPopupController.this.handleShowPopupForQuery();
            }
        });
    }

    private boolean updatePopupOrCreate(@NotNull SearchPopup.Type type, @NotNull CollectionListModel<Object> model2, @Nullable String prefix2, int caretPosition) {
        if (type == null) {
            SearchPopupController.$$$reportNull$$$0(5);
        }
        if (model2 == null) {
            SearchPopupController.$$$reportNull$$$0(6);
        }
        if (this.myPopup != null && this.myPopup.type == type && this.myPopup.isValid()) {
            this.myPopup.model.replaceAll(model2.getItems());
            this.myPopup.callback.prefix = prefix2;
            this.myPopup.caretPosition = caretPosition;
            this.myPopup.update();
            return true;
        }
        this.createPopup(type, model2, caretPosition);
        return false;
    }

    protected void createPopup(@NotNull SearchPopup.Type type, @NotNull CollectionListModel<Object> model2, int caretPosition) {
        if (type == null) {
            SearchPopupController.$$$reportNull$$$0(7);
        }
        if (model2 == null) {
            SearchPopupController.$$$reportNull$$$0(8);
        }
        this.hidePopup();
        this.myPopup = new SearchPopup(this.myTextField, this.mySearchPopupListener, type, model2, caretPosition);
    }

    private void createAndShow(boolean async, @NotNull SearchPopupCallback callback2) {
        if (callback2 == null) {
            SearchPopupController.$$$reportNull$$$0(9);
        }
        ColoredListCellRenderer renderer = new ColoredListCellRenderer(){

            protected void customizeCellRenderer(@NotNull JList list2, Object value2, int index2, boolean selected2, boolean hasFocus) {
                if (list2 == null) {
                    4.$$$reportNull$$$0(0);
                }
                this.append((String)value2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/ide/plugins/newui/SearchPopupController$4", "customizeCellRenderer"));
            }
        };
        this.myPopup.createAndShow(callback2, renderer, async);
    }

    private boolean noPrefixSearchValues(@NotNull CollectionListModel<Object> model2, @Nullable String prefix2) {
        if (model2 == null) {
            SearchPopupController.$$$reportNull$$$0(10);
        }
        if (StringUtil.isEmptyOrSpaces((String)prefix2)) {
            return false;
        }
        int index2 = 0;
        while (index2 < model2.getSize()) {
            String attribute = (String)model2.getElementAt(index2);
            if (attribute.equals(prefix2)) {
                this.hidePopup();
                return true;
            }
            if (StringUtil.startsWithIgnoreCase((String)attribute, (String)prefix2)) {
                ++index2;
                continue;
            }
            model2.remove(index2);
        }
        if (model2.isEmpty()) {
            this.handleShowPopupForQuery();
            return true;
        }
        return false;
    }

    @NotNull
    protected abstract List<String> getAttributes();

    @Nullable
    protected abstract Collection<String> getValues(@NotNull String var1);

    private void handleShowPopupForQuery() {
        this.hidePopup();
        this.showPopupForQuery();
    }

    protected abstract void showPopupForQuery();

    public boolean isPopupShow() {
        return this.myPopup != null && this.myPopup.isValid();
    }

    public void hidePopup() {
        if (this.myPopup != null) {
            this.myPopup.hide();
            this.myPopup = null;
        }
    }

    private void appendSearchText(@NotNull String value2, @Nullable String prefix2) {
        if (value2 == null) {
            SearchPopupController.$$$reportNull$$$0(11);
        }
        String text2 = this.myTextField.getText();
        String suffix = "";
        int position = this.getCaretPosition();
        if (this.myPopup != null) {
            this.myPopup.skipCaretEvent = true;
        }
        if (position < text2.length()) {
            suffix = text2.substring(position);
            text2 = text2.substring(0, position);
        }
        if (prefix2 == null) {
            this.myTextField.setTextIgnoreEvents(text2 + value2 + suffix);
        } else if (StringUtil.startsWithIgnoreCase((String)value2, (String)prefix2) || StringUtil.startsWithIgnoreCase((String)value2, (String)("\"" + prefix2))) {
            this.myTextField.setTextIgnoreEvents(text2.substring(0, text2.length() - prefix2.length()) + value2 + suffix);
        } else {
            this.myTextField.setTextIgnoreEvents(text2 + value2 + suffix);
        }
        this.myTextField.getTextEditor().setCaretPosition(this.myTextField.getText().length() - suffix.length());
    }

    public boolean handleEnter(@NotNull KeyEvent event) {
        if (event == null) {
            SearchPopupController.$$$reportNull$$$0(12);
        }
        if (this.myPopup != null && this.myPopup.list != null && this.myPopup.list.getSelectedIndex() != -1) {
            this.myPopup.list.dispatchEvent(event);
            return true;
        }
        this.handleEnter();
        return false;
    }

    protected void handleEnter() {
    }

    public boolean handleUpDown(@NotNull KeyEvent event) {
        if (event == null) {
            SearchPopupController.$$$reportNull$$$0(13);
        }
        if (this.myPopup != null && this.myPopup.list != null) {
            if (event.getKeyCode() == 40 && this.myPopup.list.getSelectedIndex() == -1) {
                this.myPopup.list.setSelectedIndex(0);
                this.handlePopupListFirstSelection();
            } else {
                this.myPopup.list.dispatchEvent(event);
            }
        }
        return false;
    }

    protected void handlePopupListFirstSelection() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchTextField";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "query";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startPosition";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/plugins/newui/SearchPopupController";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 6: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/plugins/newui/SearchPopupController";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "parseAttributeInQuery";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "parseAttributeInQuery";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "handleShowAttributeValuesPopup";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "updatePopupOrCreate";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createPopup";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createAndShow";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "noPrefixSearchValues";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "appendSearchText";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "handleEnter";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "handleUpDown";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

