/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins.newui;

import com.intellij.icons.AllIcons;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.newui.HiDPIPluginLogoIcon;
import com.intellij.ide.plugins.newui.PluginLogo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.ui.JBColor;
import com.intellij.util.ArrayUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PluginLogoApi {
    private final Logger myLogger;

    @NotNull
    public static Icon getIcon(@NotNull IdeaPluginDescriptor descriptor2, int width, int height, @Nullable Logger logger) {
        if (descriptor2 == null) {
            PluginLogoApi.$$$reportNull$$$0(0);
        }
        return new PluginLogoApi(logger).getIcon(descriptor2, width, height);
    }

    private PluginLogoApi(@Nullable Logger logger) {
        this.myLogger = logger;
    }

    @NotNull
    private Icon getIcon(@NotNull IdeaPluginDescriptor descriptor2, int width, int height) {
        Path path2;
        if (descriptor2 == null) {
            PluginLogoApi.$$$reportNull$$$0(1);
        }
        if ((path2 = descriptor2.getPluginPath()) == null) {
            return this.getDefaultIcon(width, height);
        }
        if (Files.isDirectory(path2, new LinkOption[0])) {
            Icon icon2;
            if (System.getProperty("idea.required.plugins.id") != null && (icon2 = this.tryLoadDirIcon(path2.resolve("classes"), width, height)) != null) {
                Icon icon3 = icon2;
                if (icon3 == null) {
                    PluginLogoApi.$$$reportNull$$$0(2);
                }
                return icon3;
            }
            icon2 = this.tryLoadDirIcon(path2, width, height);
            if (icon2 != null) {
                Icon icon4 = icon2;
                if (icon4 == null) {
                    PluginLogoApi.$$$reportNull$$$0(3);
                }
                return icon4;
            }
            Path libFile = path2.resolve("lib");
            if (!Files.isDirectory(libFile, new LinkOption[0])) {
                return this.getDefaultIcon(width, height);
            }
            Object[] files2 = libFile.toFile().listFiles();
            if (ArrayUtil.isEmpty((Object[])files2)) {
                return this.getDefaultIcon(width, height);
            }
            for (Object file2 : files2) {
                Icon dirIcon = this.tryLoadDirIcon(((File)file2).toPath(), width, height);
                if (dirIcon != null) {
                    Icon icon5 = dirIcon;
                    if (icon5 == null) {
                        PluginLogoApi.$$$reportNull$$$0(4);
                    }
                    return icon5;
                }
                Icon jarIcon = this.tryLoadJarIcon((File)file2, width, height);
                if (jarIcon == null) continue;
                Icon icon6 = jarIcon;
                if (icon6 == null) {
                    PluginLogoApi.$$$reportNull$$$0(5);
                }
                return icon6;
            }
        } else {
            Icon icon7 = this.tryLoadJarIcon(path2.toFile(), width, height);
            if (icon7 != null) {
                Icon icon8 = icon7;
                if (icon8 == null) {
                    PluginLogoApi.$$$reportNull$$$0(6);
                }
                return icon8;
            }
        }
        return this.getDefaultIcon(width, height);
    }

    @Nullable
    private Icon tryLoadDirIcon(@NotNull Path path2, int width, int height) {
        boolean light;
        Icon icon2;
        if (path2 == null) {
            PluginLogoApi.$$$reportNull$$$0(7);
        }
        return (icon2 = this.tryLoadIcon(path2, light = JBColor.isBright(), width, height)) == null ? this.tryLoadIcon(path2, !light, width, height) : icon2;
    }

    @Nullable
    private Icon tryLoadJarIcon(@NotNull File path2, int width, int height) {
        Icon icon2;
        if (path2 == null) {
            PluginLogoApi.$$$reportNull$$$0(8);
        }
        if (!FileUtilRt.isJarOrZip((File)path2) || !path2.exists()) {
            return null;
        }
        ZipFile zipFile = new ZipFile(path2);
        try {
            boolean light = JBColor.isBright();
            Icon icon3 = PluginLogoApi.tryLoadIcon(zipFile, light, width, height);
            icon2 = icon3 == null ? PluginLogoApi.tryLoadIcon(zipFile, !light, width, height) : icon3;
        }
        catch (Throwable throwable) {
            try {
                try {
                    zipFile.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                if (this.myLogger != null) {
                    this.myLogger.error((Throwable)e);
                }
                return null;
            }
        }
        zipFile.close();
        return icon2;
    }

    @Nullable
    private Icon tryLoadIcon(@NotNull Path dirFile, boolean light, int width, int height) {
        if (dirFile == null) {
            PluginLogoApi.$$$reportNull$$$0(9);
        }
        try {
            Path iconFile = dirFile.resolve(PluginLogo.getIconFileName(light));
            return Files.size(iconFile) > 0L ? PluginLogoApi.loadFileIcon(iconFile.toUri().toURL(), Files.newInputStream(iconFile, new OpenOption[0]), width, height) : null;
        }
        catch (NoSuchFileException ignore) {
            return null;
        }
        catch (IOException e) {
            if (this.myLogger != null) {
                this.myLogger.error((Throwable)e);
            }
            return null;
        }
    }

    @Nullable
    private static Icon tryLoadIcon(@NotNull ZipFile zipFile, boolean light, int width, int height) throws IOException {
        ZipEntry iconEntry;
        if (zipFile == null) {
            PluginLogoApi.$$$reportNull$$$0(10);
        }
        return (iconEntry = zipFile.getEntry(PluginLogo.getIconFileName(light))) == null ? null : PluginLogoApi.loadFileIcon(PluginLogo.toURL(new File(zipFile.getName())), zipFile.getInputStream(iconEntry), width, height);
    }

    @NotNull
    private static Icon loadFileIcon(@Nullable URL url, @NotNull InputStream stream, int width, int height) throws IOException {
        if (stream == null) {
            PluginLogoApi.$$$reportNull$$$0(11);
        }
        Icon icon2 = HiDPIPluginLogoIcon.loadSVG(url, stream, width, height);
        if (icon2 == null) {
            PluginLogoApi.$$$reportNull$$$0(12);
        }
        return icon2;
    }

    @NotNull
    private Icon getDefaultIcon(int width, int height) {
        Icon icon2 = PluginLogo.reloadIcon(AllIcons.Plugins.PluginLogo, width, height, this.myLogger);
        if (icon2 == null) {
            PluginLogoApi.$$$reportNull$$$0(13);
        }
        return icon2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/plugins/newui/PluginLogoApi";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dirFile";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "zipFile";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stream";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/plugins/newui/PluginLogoApi";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "loadFileIcon";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultIcon";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getIcon";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 12: 
            case 13: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "tryLoadDirIcon";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "tryLoadJarIcon";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "tryLoadIcon";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "loadFileIcon";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

