/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins.newui;

import com.intellij.externalDependencies.DependencyOnPlugin;
import com.intellij.externalDependencies.ExternalDependenciesManager;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.ide.plugins.CustomPluginRepositoryService;
import com.intellij.ide.plugins.DynamicPlugins;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.InstalledPluginsState;
import com.intellij.ide.plugins.InstalledPluginsTableModel;
import com.intellij.ide.plugins.PendingDynamicPluginInstall;
import com.intellij.ide.plugins.PluginEnableDisableAction;
import com.intellij.ide.plugins.PluginEnabledState;
import com.intellij.ide.plugins.PluginEnabler;
import com.intellij.ide.plugins.PluginInstallCallbackData;
import com.intellij.ide.plugins.PluginInstallOperation;
import com.intellij.ide.plugins.PluginInstaller;
import com.intellij.ide.plugins.PluginManagerConfigurable;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginManagerMain;
import com.intellij.ide.plugins.PluginNode;
import com.intellij.ide.plugins.ProjectPluginTrackerManager;
import com.intellij.ide.plugins.ProjectPluginTrackerManagerState;
import com.intellij.ide.plugins.marketplace.MarketplaceRequests;
import com.intellij.ide.plugins.newui.BgProgressIndicator;
import com.intellij.ide.plugins.newui.InstallPluginInfo;
import com.intellij.ide.plugins.newui.ListPluginComponent;
import com.intellij.ide.plugins.newui.PluginDetailsPageComponent;
import com.intellij.ide.plugins.newui.PluginLogo;
import com.intellij.ide.plugins.newui.PluginUpdatesService;
import com.intellij.ide.plugins.newui.PluginsGroup;
import com.intellij.ide.plugins.newui.PluginsGroupComponent;
import com.intellij.ide.plugins.newui.ProjectDependentPluginEnabledState;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.newEditor.SettingsDialog;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.ex.ProgressIndicatorEx;
import com.intellij.openapi.wm.ex.StatusBarEx;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomeFrame;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.Component;
import java.awt.Window;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.nio.file.FileVisitResult;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MyPluginModel
extends InstalledPluginsTableModel
implements PluginEnabler {
    private static final Logger LOG = Logger.getInstance(MyPluginModel.class);
    private final List<ListPluginComponent> myInstalledPluginComponents = new ArrayList<ListPluginComponent>();
    private final Map<PluginId, List<ListPluginComponent>> myInstalledPluginComponentMap = new HashMap<PluginId, List<ListPluginComponent>>();
    private final Map<PluginId, List<ListPluginComponent>> myMarketplacePluginComponentMap = new HashMap<PluginId, List<ListPluginComponent>>();
    private final List<PluginsGroup> myEnabledGroups = new ArrayList<PluginsGroup>();
    private PluginsGroupComponent myInstalledPanel;
    private PluginsGroup myDownloaded;
    private PluginsGroup myInstalling;
    private Configurable.TopComponentController myTopController;
    private SortedSet<String> myVendors;
    private SortedSet<String> myTags;
    private static final Set<IdeaPluginDescriptor> myInstallingPlugins = new HashSet<IdeaPluginDescriptor>();
    private static final Set<IdeaPluginDescriptor> myInstallingWithUpdatesPlugins = new HashSet<IdeaPluginDescriptor>();
    static final Map<PluginId, InstallPluginInfo> myInstallingInfos = new HashMap<PluginId, InstallPluginInfo>();
    public boolean needRestart;
    public boolean createShutdownCallback = true;
    private boolean myInstallsRequiringRestart;
    private final List<PluginDetailsPageComponent> myDetailPanels = new ArrayList<PluginDetailsPageComponent>();
    private StatusBarEx myStatusBar;
    private PluginUpdatesService myPluginUpdatesService;
    private Runnable myInvalidFixCallback;
    private Consumer<? super IdeaPluginDescriptor> myCancelInstallCallback;
    private final Map<PluginId, PendingDynamicPluginInstall> myDynamicPluginsToInstall = new LinkedHashMap<PluginId, PendingDynamicPluginInstall>();
    private final Set<IdeaPluginDescriptorImpl> myDynamicPluginsToUninstall = new HashSet<IdeaPluginDescriptorImpl>();
    private final Set<IdeaPluginDescriptorImpl> myPluginsToRemoveOnCancel = new HashSet<IdeaPluginDescriptorImpl>();
    private final Map<IdeaPluginDescriptor, Pair<PluginEnableDisableAction, PluginEnabledState>> myDiff = new HashMap<IdeaPluginDescriptor, Pair<PluginEnableDisableAction, PluginEnabledState>>();
    private final Map<PluginId, Boolean> myRequiredPluginsForProject = new HashMap<PluginId, Boolean>();
    private final Map<IdeaPluginDescriptorImpl, Boolean> myRequiresRestart = new HashMap<IdeaPluginDescriptorImpl, Boolean>();
    private final Set<IdeaPluginDescriptor> myUninstalled = new HashSet<IdeaPluginDescriptor>();
    private final Set<PluginId> myErrorPluginsToDisable = new HashSet<PluginId>();
    private final Map<String, Icon> myIcons = new HashMap<String, Icon>();

    public MyPluginModel(@Nullable Project project) {
        super(project);
        Window window = ProjectUtil.getActiveFrameOrWelcomeScreen();
        this.myStatusBar = MyPluginModel.getStatusBar(window);
        if (this.myStatusBar == null && window != null) {
            this.myStatusBar = MyPluginModel.getStatusBar(window.getOwner());
        }
    }

    @Nullable
    private static StatusBarEx getStatusBar(@Nullable Window frame) {
        if (frame instanceof IdeFrame && !(frame instanceof WelcomeFrame)) {
            return (StatusBarEx)((IdeFrame)frame).getStatusBar();
        }
        return null;
    }

    public boolean isModified() {
        return this.needRestart || !this.myDynamicPluginsToInstall.isEmpty() || !this.myDynamicPluginsToUninstall.isEmpty() || !this.myPluginsToRemoveOnCancel.isEmpty() || !this.myDiff.isEmpty();
    }

    public boolean apply(JComponent parent) throws ConfigurationException {
        boolean changesAppliedWithoutRestart;
        ArrayList<CallSite> dependencies = new ArrayList<CallSite>();
        this.updatePluginDependencies();
        block2: for (Map.Entry<PluginId, Set<PluginId>> entry2 : this.getDependentToRequiredListMap().entrySet()) {
            PluginId id2 = entry2.getKey();
            if (!this.isLoaded(id2)) continue;
            for (PluginId dependId : (Set)entry2.getValue()) {
                if (PluginManagerCore.isModuleDependency(dependId)) continue;
                IdeaPluginDescriptor descriptor2 = PluginManagerCore.getPlugin(id2);
                if (descriptor2 instanceof IdeaPluginDescriptorImpl && (((IdeaPluginDescriptorImpl)descriptor2).isDeleted() || descriptor2.isImplementationDetail())) continue block2;
                dependencies.add((CallSite)((Object)("\"" + (descriptor2 == null ? id2.getIdString() : descriptor2.getName()) + "\"")));
                continue block2;
            }
        }
        if (!dependencies.isEmpty()) {
            throw new ConfigurationException(XmlStringUtil.wrapInHtml((CharSequence)IdeBundle.message((String)"dialog.message.unable.to.apply.changes", (Object[])new Object[]{dependencies.size(), StringUtil.join(dependencies, (String)", ")})));
        }
        HashSet<Object> uninstallsRequiringRestart = new HashSet<Object>();
        for (IdeaPluginDescriptorImpl pluginDescriptor : this.myDynamicPluginsToUninstall) {
            this.myDiff.remove(pluginDescriptor);
            PluginId pluginId = pluginDescriptor.getPluginId();
            if (!PluginInstaller.uninstallDynamicPlugin(parent, pluginDescriptor, false)) {
                uninstallsRequiringRestart.add(pluginId);
            } else {
                this.getEnabledMap().remove(pluginId);
            }
            ((ProjectPluginTrackerManagerState)ProjectPluginTrackerManager.getInstance().getState()).stopTracking(List.of(pluginId));
        }
        boolean installsRequiringRestart = this.myInstallsRequiringRestart;
        ArrayList dynamicPluginsRequiringRestart = new ArrayList();
        for (PendingDynamicPluginInstall pendingPluginInstall : this.myDynamicPluginsToInstall.values()) {
            PluginId pluginId = pendingPluginInstall.getPluginDescriptor().getPluginId();
            if (!uninstallsRequiringRestart.contains(pluginId)) {
                InstalledPluginsState.getInstance().trackPluginInstallation(() -> {
                    if (!PluginInstaller.installAndLoadDynamicPlugin(pendingPluginInstall.getFile(), parent, pendingPluginInstall.getPluginDescriptor())) {
                        dynamicPluginsRequiringRestart.add(pluginId);
                    }
                });
                continue;
            }
            try {
                PluginInstaller.installAfterRestart(pendingPluginInstall.getFile(), !Registry.is((String)"ide.plugins.keep.archive", (boolean)true), null, pendingPluginInstall.getPluginDescriptor());
                installsRequiringRestart = true;
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        }
        this.myDynamicPluginsToInstall.clear();
        this.myPluginsToRemoveOnCancel.clear();
        boolean enableDisableAppliedWithoutRestart = this.applyEnableDisablePlugins(parent);
        this.myDynamicPluginsToUninstall.clear();
        this.myDiff.clear();
        boolean bl = changesAppliedWithoutRestart = enableDisableAppliedWithoutRestart && uninstallsRequiringRestart.isEmpty() && !installsRequiringRestart && dynamicPluginsRequiringRestart.isEmpty();
        if (!changesAppliedWithoutRestart) {
            InstalledPluginsState.getInstance().setRestartRequired(true);
        }
        return changesAppliedWithoutRestart;
    }

    public void clear(@Nullable JComponent parentComponent) {
        this.cancel(parentComponent);
        this.updateAfterEnableDisable();
    }

    public void cancel(@Nullable JComponent parentComponent) {
        this.myDiff.forEach((key, value2) -> this.setEnabled(key.getPluginId(), (PluginEnabledState)((Object)((Object)value2.getSecond()))));
        this.myDiff.clear();
        this.myPluginsToRemoveOnCancel.forEach(pluginDescriptor -> PluginInstaller.uninstallDynamicPlugin(parentComponent, pluginDescriptor, false));
        this.myPluginsToRemoveOnCancel.clear();
    }

    private boolean applyEnableDisablePlugins(@Nullable JComponent parentComponent) {
        EnumMap<PluginEnableDisableAction, List> descriptorsByAction = new EnumMap<PluginEnableDisableAction, List>(PluginEnableDisableAction.class);
        for (Map.Entry<IdeaPluginDescriptor, Pair<PluginEnableDisableAction, PluginEnabledState>> entry2 : this.myDiff.entrySet()) {
            IdeaPluginDescriptor descriptor2 = entry2.getKey();
            PluginId pluginId = descriptor2.getPluginId();
            Pair<PluginEnableDisableAction, PluginEnabledState> pair = entry2.getValue();
            PluginEnabledState oldState = (PluginEnabledState)((Object)pair.getSecond());
            PluginEnabledState newState2 = this.getState(pluginId);
            if (descriptor2 instanceof IdeaPluginDescriptorImpl && ((IdeaPluginDescriptorImpl)descriptor2).isDeleted() || descriptor2.isImplementationDetail() && !newState2.isEnabled() || !this.isLoaded(pluginId) || oldState == newState2 && (!newState2.isDisabled() || !this.myErrorPluginsToDisable.contains(pluginId))) continue;
            descriptorsByAction.computeIfAbsent((PluginEnableDisableAction)((Object)pair.getFirst()), __ -> new ArrayList()).add(descriptor2);
        }
        boolean result2 = true;
        ProjectPluginTrackerManager pluginTrackerManager = ProjectPluginTrackerManager.getInstance();
        for (Map.Entry entry3 : descriptorsByAction.entrySet()) {
            if (pluginTrackerManager.updatePluginsState((Collection)entry3.getValue(), entry3.getKey(), this.getProject(), parentComponent)) continue;
            result2 = false;
        }
        return result2;
    }

    public void pluginInstalledFromDisk(@NotNull PluginInstallCallbackData callbackData) {
        if (callbackData == null) {
            MyPluginModel.$$$reportNull$$$0(0);
        }
        this.appendOrUpdateDescriptor(callbackData.getPluginDescriptor(), callbackData.getRestartNeeded());
        if (!callbackData.getRestartNeeded()) {
            this.myDynamicPluginsToInstall.put(callbackData.getPluginDescriptor().getPluginId(), new PendingDynamicPluginInstall(callbackData.getFile(), callbackData.getPluginDescriptor()));
        }
    }

    public void addComponent(@NotNull ListPluginComponent component2) {
        if (component2 == null) {
            MyPluginModel.$$$reportNull$$$0(1);
        }
        IdeaPluginDescriptor descriptor2 = component2.getPluginDescriptor();
        PluginId pluginId = descriptor2.getPluginId();
        if (!component2.isMarketplace()) {
            if (myInstallingPlugins.contains(descriptor2) && (this.myInstalling == null || this.myInstalling.ui == null || this.myInstalling.ui.findComponent(pluginId) == null)) {
                return;
            }
            this.myInstalledPluginComponents.add(component2);
            List components = this.myInstalledPluginComponentMap.computeIfAbsent(pluginId, __ -> new ArrayList());
            components.add(component2);
        } else {
            List components = this.myMarketplacePluginComponentMap.computeIfAbsent(pluginId, __ -> new ArrayList());
            components.add(component2);
        }
    }

    public void removeComponent(@NotNull ListPluginComponent component2) {
        if (component2 == null) {
            MyPluginModel.$$$reportNull$$$0(2);
        }
        PluginId pluginId = component2.getPluginDescriptor().getPluginId();
        if (!component2.isMarketplace()) {
            this.myInstalledPluginComponents.remove(component2);
            List<ListPluginComponent> components = this.myInstalledPluginComponentMap.get(pluginId);
            if (components != null) {
                components.remove(component2);
                if (components.isEmpty()) {
                    this.myInstalledPluginComponentMap.remove(pluginId);
                }
            }
        } else {
            List<ListPluginComponent> components = this.myMarketplacePluginComponentMap.get(pluginId);
            if (components != null) {
                components.remove(component2);
                if (components.isEmpty()) {
                    this.myMarketplacePluginComponentMap.remove(pluginId);
                }
            }
        }
    }

    public void setTopController(@NotNull Configurable.TopComponentController topController) {
        if (topController == null) {
            MyPluginModel.$$$reportNull$$$0(3);
        }
        this.myTopController = topController;
        this.myTopController.showProject(false);
        for (InstallPluginInfo info2 : myInstallingInfos.values()) {
            info2.fromBackground(this);
        }
        if (!myInstallingInfos.isEmpty()) {
            this.myTopController.showProgress(true);
        }
    }

    public void setPluginUpdatesService(@NotNull PluginUpdatesService service) {
        if (service == null) {
            MyPluginModel.$$$reportNull$$$0(4);
        }
        this.myPluginUpdatesService = service;
    }

    @Nullable
    public PluginsGroup getDownloadedGroup() {
        return this.myDownloaded;
    }

    @NotNull
    public static Set<IdeaPluginDescriptor> getInstallingPlugins() {
        Set<IdeaPluginDescriptor> set2 = myInstallingPlugins;
        if (set2 == null) {
            MyPluginModel.$$$reportNull$$$0(5);
        }
        return set2;
    }

    static boolean isInstallingOrUpdate(@NotNull IdeaPluginDescriptor descriptor2) {
        if (descriptor2 == null) {
            MyPluginModel.$$$reportNull$$$0(6);
        }
        return myInstallingWithUpdatesPlugins.contains(descriptor2);
    }

    void installOrUpdatePlugin(@Nullable JComponent parentComponent, final @NotNull IdeaPluginDescriptor descriptor2, @Nullable IdeaPluginDescriptor updateDescriptor, final @NotNull ModalityState modalityState) {
        IdeaPluginDescriptor actionDescriptor;
        if (descriptor2 == null) {
            MyPluginModel.$$$reportNull$$$0(7);
        }
        if (modalityState == null) {
            MyPluginModel.$$$reportNull$$$0(8);
        }
        final boolean isUpdate = updateDescriptor != null;
        IdeaPluginDescriptor ideaPluginDescriptor = actionDescriptor = isUpdate ? updateDescriptor : descriptor2;
        if (!PluginManagerMain.checkThirdPartyPluginsAllowed(List.of(actionDescriptor))) {
            return;
        }
        final Ref allowInstallWithoutRestart = Ref.create((Object)true);
        if (isUpdate) {
            IdeaPluginDescriptorImpl installedPluginDescriptor = (IdeaPluginDescriptorImpl)descriptor2;
            if (!DynamicPlugins.allowLoadUnloadWithoutRestart(installedPluginDescriptor)) {
                allowInstallWithoutRestart.set((Object)false);
            } else if (!installedPluginDescriptor.isEnabled()) {
                try {
                    FileUtil.delete((Path)installedPluginDescriptor.getPluginPath());
                }
                catch (IOException e) {
                    LOG.debug((Throwable)e);
                }
            } else if (DynamicPlugins.allowLoadUnloadSynchronously(installedPluginDescriptor)) {
                allowInstallWithoutRestart.set((Object)PluginInstaller.uninstallDynamicPlugin(parentComponent, installedPluginDescriptor, true));
            } else {
                this.performUninstall(installedPluginDescriptor);
            }
        }
        ProgressManager.getInstance().runProcessWithProgressAsynchronously(new Task.Backgroundable(this.getProject(), parentComponent, IdeBundle.message((String)"progress.title.loading.plugin.details", (Object[])new Object[0]), true, null){

            public void run(@NotNull ProgressIndicator indicator2) {
                PluginNode pluginNode;
                if (indicator2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((pluginNode = this.toPluginNode(actionDescriptor, indicator2)) == null) {
                    return;
                }
                List<PluginNode> pluginsToInstall = List.of(pluginNode);
                ApplicationManager.getApplication().invokeAndWait(() -> PluginManagerMain.suggestToEnableInstalledDependantPlugins(MyPluginModel.this, pluginsToInstall), modalityState);
                InstallPluginInfo info2 = new InstallPluginInfo((BgProgressIndicator)indicator2, descriptor2, MyPluginModel.this, !isUpdate);
                MyPluginModel.this.prepareToInstall(info2);
                PluginInstallOperation operation2 = new PluginInstallOperation(pluginsToInstall, MyPluginModel.this.getCustomRepoPlugins(), MyPluginModel.this, indicator2);
                operation2.setAllowInstallWithoutRestart((Boolean)allowInstallWithoutRestart.get());
                MyPluginModel.this.runInstallOperation(operation2, info2, modalityState);
            }

            @Nullable
            private PluginNode toPluginNode(@NotNull IdeaPluginDescriptor descriptor22, @NotNull ProgressIndicator indicator2) {
                if (descriptor22 == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (indicator2 == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (descriptor22 instanceof PluginNode) {
                    PluginNode pluginNode = (PluginNode)descriptor22;
                    return pluginNode.detailsLoaded() ? pluginNode : MarketplaceRequests.getInstance().loadPluginDetails(pluginNode, indicator2);
                }
                PluginNode pluginNode = new PluginNode(descriptor22.getPluginId(), descriptor22.getName(), "-1");
                pluginNode.setDependencies(descriptor22.getDependencies());
                pluginNode.setRepositoryName("__unknown_repository__");
                return pluginNode;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "indicator";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "descriptor";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/ide/plugins/newui/MyPluginModel$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "run";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "toPluginNode";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, (ProgressIndicator)new BgProgressIndicator());
    }

    private void runInstallOperation(@NotNull PluginInstallOperation operation2, @NotNull InstallPluginInfo info2, @NotNull ModalityState modalityState) {
        if (operation2 == null) {
            MyPluginModel.$$$reportNull$$$0(9);
        }
        if (info2 == null) {
            MyPluginModel.$$$reportNull$$$0(10);
        }
        if (modalityState == null) {
            MyPluginModel.$$$reportNull$$$0(11);
        }
        boolean cancel = false;
        boolean success2 = true;
        boolean showErrors2 = true;
        boolean restartRequired = true;
        ArrayList<PendingDynamicPluginInstall> pluginsToInstallSynchronously = new ArrayList<PendingDynamicPluginInstall>();
        try {
            operation2.run();
            for (PendingDynamicPluginInstall install2 : operation2.getPendingDynamicPluginInstalls()) {
                if (DynamicPlugins.allowLoadUnloadSynchronously(install2.getPluginDescriptor())) {
                    pluginsToInstallSynchronously.add(install2);
                    this.myPluginsToRemoveOnCancel.add(install2.getPluginDescriptor());
                    continue;
                }
                this.myDynamicPluginsToInstall.put(install2.getPluginDescriptor().getPluginId(), install2);
            }
            success2 = operation2.isSuccess();
            showErrors2 = !operation2.isShownErrors();
            restartRequired = operation2.isRestartRequired();
        }
        catch (ProcessCanceledException e) {
            cancel = true;
        }
        catch (Throwable e) {
            LOG.error(e);
            success2 = false;
        }
        boolean _success = success2;
        boolean _cancel = cancel;
        boolean _showErrors = showErrors2;
        boolean _restartRequired = restartRequired;
        ApplicationManager.getApplication().invokeLater(() -> {
            boolean dynamicRestartRequired = false;
            for (PendingDynamicPluginInstall install2 : pluginsToInstallSynchronously) {
                boolean installedWithoutRestart = PluginInstaller.installAndLoadDynamicPlugin(install2.getFile(), (JComponent)((Object)this.myInstalledPanel), install2.getPluginDescriptor());
                if (installedWithoutRestart) {
                    IdeaPluginDescriptor installedDescriptor = PluginManagerCore.getPlugin(info2.getDescriptor().getPluginId());
                    if (installedDescriptor == null) continue;
                    info2.setInstalledDescriptor((IdeaPluginDescriptorImpl)installedDescriptor);
                    continue;
                }
                dynamicRestartRequired = true;
            }
            info2.finish(_success, _cancel, _showErrors, _restartRequired || dynamicRestartRequired);
        }, modalityState);
    }

    public boolean toBackground() {
        boolean result2;
        for (InstallPluginInfo info2 : myInstallingInfos.values()) {
            info2.toBackground(this.myStatusBar);
        }
        boolean bl = result2 = !myInstallingInfos.isEmpty();
        if (result2) {
            InstallPluginInfo.showRestart();
        }
        return result2;
    }

    private void prepareToInstall(@NotNull InstallPluginInfo info2) {
        List<ListPluginComponent> listComponents;
        List<ListPluginComponent> gridComponents;
        if (info2 == null) {
            MyPluginModel.$$$reportNull$$$0(12);
        }
        IdeaPluginDescriptor descriptor2 = info2.getDescriptor();
        PluginId pluginId = descriptor2.getPluginId();
        myInstallingInfos.put(pluginId, info2);
        if (myInstallingWithUpdatesPlugins.isEmpty()) {
            this.myTopController.showProgress(true);
        }
        myInstallingWithUpdatesPlugins.add(descriptor2);
        if (info2.install) {
            myInstallingPlugins.add(descriptor2);
        }
        if (info2.install && this.myInstalling != null) {
            if (this.myInstalling.ui == null) {
                this.myInstalling.descriptors.add(descriptor2);
                this.myInstalledPanel.addGroup(this.myInstalling, 0);
            } else {
                this.myInstalledPanel.addToGroup(this.myInstalling, descriptor2);
            }
            this.myInstalling.titleWithCount();
            this.myInstalledPanel.doLayout();
        }
        if ((gridComponents = this.myMarketplacePluginComponentMap.get(pluginId)) != null) {
            for (ListPluginComponent gridComponent : gridComponents) {
                gridComponent.showProgress();
            }
        }
        if ((listComponents = this.myInstalledPluginComponentMap.get(pluginId)) != null) {
            for (ListPluginComponent listComponent : listComponents) {
                listComponent.showProgress();
            }
        }
        for (PluginDetailsPageComponent panel2 : this.myDetailPanels) {
            if (panel2.getPlugin() != descriptor2) continue;
            panel2.showProgress();
        }
    }

    void finishInstall(@NotNull IdeaPluginDescriptor descriptor2, @Nullable IdeaPluginDescriptorImpl installedDescriptor, boolean success2, boolean showErrors2, boolean restartRequired) {
        List<ListPluginComponent> installedComponents;
        PluginId pluginId;
        List<ListPluginComponent> marketplaceComponents;
        if (descriptor2 == null) {
            MyPluginModel.$$$reportNull$$$0(13);
        }
        InstallPluginInfo info2 = MyPluginModel.finishInstall(descriptor2);
        if (myInstallingWithUpdatesPlugins.isEmpty()) {
            this.myTopController.showProgress(false);
        }
        if ((marketplaceComponents = this.myMarketplacePluginComponentMap.get(pluginId = descriptor2.getPluginId())) != null) {
            for (ListPluginComponent listPluginComponent : marketplaceComponents) {
                if (installedDescriptor != null) {
                    listPluginComponent.setPluginDescriptor(installedDescriptor);
                }
                listPluginComponent.hideProgress(success2, restartRequired);
            }
        }
        if ((installedComponents = this.myInstalledPluginComponentMap.get(pluginId)) != null) {
            for (ListPluginComponent listComponent : installedComponents) {
                if (installedDescriptor != null) {
                    listComponent.setPluginDescriptor(installedDescriptor);
                }
                listComponent.hideProgress(success2, restartRequired);
                listComponent.updateErrors();
            }
        }
        for (PluginDetailsPageComponent panel2 : this.myDetailPanels) {
            if (!panel2.isShowingPlugin(descriptor2)) continue;
            panel2.setPlugin(installedDescriptor);
            panel2.hideProgress(success2);
        }
        if (info2.install) {
            if (this.myInstalling != null && this.myInstalling.ui != null) {
                this.clearInstallingProgress(descriptor2);
                if (myInstallingPlugins.isEmpty()) {
                    this.myInstalledPanel.removeGroup(this.myInstalling);
                } else {
                    this.myInstalledPanel.removeFromGroup(this.myInstalling, descriptor2);
                    this.myInstalling.titleWithCount();
                }
                this.myInstalledPanel.doLayout();
            }
            if (success2) {
                this.appendOrUpdateDescriptor(installedDescriptor != null ? installedDescriptor : descriptor2, restartRequired);
                this.appendDependsAfterInstall();
            } else if (this.myCancelInstallCallback != null) {
                this.myCancelInstallCallback.accept((IdeaPluginDescriptor)descriptor2);
            }
        } else if (success2) {
            ListPluginComponent listPluginComponent;
            if (this.myDownloaded != null && this.myDownloaded.ui != null && restartRequired && (listPluginComponent = this.myDownloaded.ui.findComponent(pluginId)) != null) {
                listPluginComponent.enableRestart();
            }
        } else {
            this.myPluginUpdatesService.finishUpdate();
        }
        info2.indicator.cancel();
        if (success2) {
            this.needRestart = true;
            this.myInstallsRequiringRestart |= restartRequired;
        }
        if (!success2 && showErrors2) {
            Messages.showErrorDialog((Project)this.getProject(), (String)IdeBundle.message((String)"plugins.configurable.plugin.installing.failed", (Object[])new Object[]{descriptor2.getName()}), (String)IdeBundle.message((String)"action.download.and.install.plugin", (Object[])new Object[0]));
        }
    }

    private void clearInstallingProgress(@NotNull IdeaPluginDescriptor descriptor2) {
        if (descriptor2 == null) {
            MyPluginModel.$$$reportNull$$$0(14);
        }
        if (myInstallingPlugins.isEmpty()) {
            for (ListPluginComponent listComponent : this.myInstalling.ui.plugins) {
                listComponent.clearProgress();
            }
        } else {
            for (ListPluginComponent listComponent : this.myInstalling.ui.plugins) {
                if (listComponent.getPluginDescriptor() != descriptor2) continue;
                listComponent.clearProgress();
                return;
            }
        }
    }

    @NotNull
    static InstallPluginInfo finishInstall(@NotNull IdeaPluginDescriptor descriptor2) {
        if (descriptor2 == null) {
            MyPluginModel.$$$reportNull$$$0(15);
        }
        InstallPluginInfo info2 = myInstallingInfos.remove(descriptor2.getPluginId());
        info2.close();
        myInstallingWithUpdatesPlugins.remove(descriptor2);
        if (info2.install) {
            myInstallingPlugins.remove(descriptor2);
        }
        InstallPluginInfo installPluginInfo = info2;
        if (installPluginInfo == null) {
            MyPluginModel.$$$reportNull$$$0(16);
        }
        return installPluginInfo;
    }

    static void addProgress(@NotNull IdeaPluginDescriptor descriptor2, @NotNull ProgressIndicatorEx indicator2) {
        if (descriptor2 == null) {
            MyPluginModel.$$$reportNull$$$0(17);
        }
        if (indicator2 == null) {
            MyPluginModel.$$$reportNull$$$0(18);
        }
        MyPluginModel.myInstallingInfos.get((Object)descriptor2.getPluginId()).indicator.addStateDelegate(indicator2);
    }

    static void removeProgress(@NotNull IdeaPluginDescriptor descriptor2, @NotNull ProgressIndicatorEx indicator2) {
        if (descriptor2 == null) {
            MyPluginModel.$$$reportNull$$$0(19);
        }
        if (indicator2 == null) {
            MyPluginModel.$$$reportNull$$$0(20);
        }
        MyPluginModel.myInstallingInfos.get((Object)descriptor2.getPluginId()).indicator.removeStateDelegate(indicator2);
    }

    public void addEnabledGroup(@NotNull PluginsGroup group2) {
        if (group2 == null) {
            MyPluginModel.$$$reportNull$$$0(21);
        }
        this.myEnabledGroups.add(group2);
    }

    public void setDownloadedGroup(@NotNull PluginsGroupComponent panel2, @NotNull PluginsGroup downloaded, @NotNull PluginsGroup installing) {
        if (panel2 == null) {
            MyPluginModel.$$$reportNull$$$0(22);
        }
        if (downloaded == null) {
            MyPluginModel.$$$reportNull$$$0(23);
        }
        if (installing == null) {
            MyPluginModel.$$$reportNull$$$0(24);
        }
        this.myInstalledPanel = panel2;
        this.myDownloaded = downloaded;
        this.myInstalling = installing;
    }

    private void appendDependsAfterInstall() {
        if (this.myDownloaded == null || this.myDownloaded.ui == null) {
            return;
        }
        block0: for (IdeaPluginDescriptor descriptor2 : InstalledPluginsState.getInstance().getInstalledPlugins()) {
            PluginId pluginId = descriptor2.getPluginId();
            if (this.myDownloaded.ui.findComponent(pluginId) != null) continue;
            this.appendOrUpdateDescriptor(descriptor2, true);
            String id2 = pluginId.getIdString();
            for (Map.Entry<PluginId, List<ListPluginComponent>> entry2 : this.myMarketplacePluginComponentMap.entrySet()) {
                if (!id2.equals(entry2.getKey().getIdString())) continue;
                for (ListPluginComponent component2 : entry2.getValue()) {
                    component2.hideProgress(true, true);
                }
                continue block0;
            }
        }
    }

    public void addDetailPanel(@NotNull PluginDetailsPageComponent detailPanel) {
        if (detailPanel == null) {
            MyPluginModel.$$$reportNull$$$0(25);
        }
        this.myDetailPanels.add(detailPanel);
    }

    private void appendOrUpdateDescriptor(@NotNull IdeaPluginDescriptor descriptor2) {
        int index2;
        if (descriptor2 == null) {
            MyPluginModel.$$$reportNull$$$0(26);
        }
        if ((index2 = this.view.indexOf(descriptor2)) < 0) {
            this.view.add(descriptor2);
        } else {
            this.view.set(index2, descriptor2);
        }
    }

    void appendOrUpdateDescriptor(@NotNull IdeaPluginDescriptor descriptor2, boolean restartNeeded) {
        PluginId id2;
        if (descriptor2 == null) {
            MyPluginModel.$$$reportNull$$$0(27);
        }
        if (!PluginManagerCore.isPluginInstalled(id2 = descriptor2.getPluginId())) {
            this.appendOrUpdateDescriptor(descriptor2);
            this.setEnabled(id2, PluginEnabledState.ENABLED);
        }
        if (restartNeeded) {
            this.myInstallsRequiringRestart = true;
            this.needRestart = true;
        }
        if (this.myDownloaded == null) {
            return;
        }
        this.myVendors = null;
        this.myTags = null;
        if (this.myDownloaded.ui == null) {
            this.myDownloaded.descriptors.add(descriptor2);
            this.myDownloaded.titleWithEnabled(this);
            this.myInstalledPanel.addGroup(this.myDownloaded, this.myInstalling == null || this.myInstalling.ui == null ? 0 : 1);
            this.myInstalledPanel.setSelection(this.myDownloaded.ui.plugins.get(0));
            this.myInstalledPanel.doLayout();
            this.addEnabledGroup(this.myDownloaded);
        } else {
            ListPluginComponent component2 = this.myDownloaded.ui.findComponent(id2);
            if (component2 != null) {
                this.myInstalledPanel.setSelection(component2);
                component2.enableRestart();
                return;
            }
            this.myInstalledPanel.addToGroup(this.myDownloaded, descriptor2);
            this.myDownloaded.titleWithEnabled(this);
            this.myInstalledPanel.setSelection(this.myDownloaded.ui.plugins.get(this.myDownloaded.descriptors.indexOf(descriptor2)));
            this.myInstalledPanel.doLayout();
        }
    }

    @NotNull
    public SortedSet<String> getVendors() {
        if (ContainerUtil.isEmpty(this.myVendors)) {
            Map<String, Integer> vendorsCount = MyPluginModel.getVendorsCount(this.getInstalledDescriptors());
            this.myVendors = new TreeSet<String>((v1, v2) -> {
                int result2 = (Integer)vendorsCount.get(v2) - (Integer)vendorsCount.get(v1);
                return result2 == 0 ? v2.compareToIgnoreCase((String)v1) : result2;
            });
            this.myVendors.addAll(vendorsCount.keySet());
        }
        SortedSet<String> sortedSet = Collections.unmodifiableSortedSet(this.myVendors);
        if (sortedSet == null) {
            MyPluginModel.$$$reportNull$$$0(28);
        }
        return sortedSet;
    }

    @NotNull
    public SortedSet<String> getTags() {
        if (ContainerUtil.isEmpty(this.myTags)) {
            this.myTags = new TreeSet<String>(String::compareToIgnoreCase);
            for (IdeaPluginDescriptor descriptor2 : this.getInstalledDescriptors()) {
                this.myTags.addAll(PluginManagerConfigurable.getTags(descriptor2));
            }
        }
        SortedSet<String> sortedSet = Collections.unmodifiableSortedSet(this.myTags);
        if (sortedSet == null) {
            MyPluginModel.$$$reportNull$$$0(29);
        }
        return sortedSet;
    }

    @NotNull
    public List<IdeaPluginDescriptor> getInstalledDescriptors() {
        assert (this.myInstalledPanel != null);
        List<IdeaPluginDescriptor> list2 = this.myInstalledPanel.getGroups().stream().flatMap(group2 -> group2.plugins.stream()).map(ListPluginComponent::getPluginDescriptor).collect(Collectors.toList());
        if (list2 == null) {
            MyPluginModel.$$$reportNull$$$0(30);
        }
        return list2;
    }

    @NotNull
    private static Map<String, Integer> getVendorsCount(@NotNull Collection<? extends IdeaPluginDescriptor> descriptors2) {
        if (descriptors2 == null) {
            MyPluginModel.$$$reportNull$$$0(31);
        }
        HashMap<String, Integer> vendors = new HashMap<String, Integer>();
        for (IdeaPluginDescriptor ideaPluginDescriptor : descriptors2) {
            String vendor = StringUtil.trim((String)ideaPluginDescriptor.getVendor());
            if (StringUtil.isEmptyOrSpaces((String)vendor)) continue;
            vendors.compute(vendor, (__, old) -> (old != null ? old : 0) + 1);
        }
        HashMap<String, Integer> hashMap = vendors;
        if (hashMap == null) {
            MyPluginModel.$$$reportNull$$$0(32);
        }
        return hashMap;
    }

    public static boolean isVendor(@NotNull IdeaPluginDescriptor descriptor2, @NotNull Set<String> vendors) {
        String vendor;
        if (descriptor2 == null) {
            MyPluginModel.$$$reportNull$$$0(33);
        }
        if (vendors == null) {
            MyPluginModel.$$$reportNull$$$0(34);
        }
        if (StringUtil.isEmpty((String)(vendor = StringUtil.trim((String)descriptor2.getVendor())))) {
            return false;
        }
        for (String vendorToFind : vendors) {
            if (!vendor.equalsIgnoreCase(vendorToFind) && !StringUtil.containsIgnoreCase((String)vendor, (String)vendorToFind)) continue;
            return true;
        }
        return false;
    }

    public boolean isEnabled(@NotNull IdeaPluginDescriptor descriptor2) {
        if (descriptor2 == null) {
            MyPluginModel.$$$reportNull$$$0(35);
        }
        return !this.isDisabled(descriptor2.getPluginId());
    }

    @NotNull
    public PluginEnabledState getState(@NotNull IdeaPluginDescriptor descriptor2) {
        if (descriptor2 == null) {
            MyPluginModel.$$$reportNull$$$0(36);
        }
        PluginEnabledState pluginEnabledState = this.getState(descriptor2.getPluginId());
        if (pluginEnabledState == null) {
            MyPluginModel.$$$reportNull$$$0(37);
        }
        return pluginEnabledState;
    }

    @NotNull
    ProjectDependentPluginEnabledState getProjectDependentState(@NotNull IdeaPluginDescriptor descriptor2) {
        if (descriptor2 == null) {
            MyPluginModel.$$$reportNull$$$0(38);
        }
        PluginId pluginId = descriptor2.getPluginId();
        return new ProjectDependentPluginEnabledState(pluginId, this.getState(pluginId), this.getProject());
    }

    @NotNull
    PluginEnabledState getState(@NotNull PluginId pluginId) {
        PluginEnabledState state;
        if (pluginId == null) {
            MyPluginModel.$$$reportNull$$$0(39);
        }
        PluginEnabledState pluginEnabledState = (state = this.getEnabledMap().get(pluginId)) != null ? state : PluginEnabledState.ENABLED;
        if (pluginEnabledState == null) {
            MyPluginModel.$$$reportNull$$$0(40);
        }
        return pluginEnabledState;
    }

    boolean isRequiredPluginForProject(@NotNull PluginId pluginId) {
        Project project;
        if (pluginId == null) {
            MyPluginModel.$$$reportNull$$$0(41);
        }
        return (project = this.getProject()) != null && this.myRequiredPluginsForProject.computeIfAbsent(pluginId, id2 -> ContainerUtil.exists(MyPluginModel.getDependenciesOnPlugins(project), id2.getIdString()::equals)) != false;
    }

    boolean requiresRestart(@NotNull IdeaPluginDescriptor descriptor2) {
        if (descriptor2 == null) {
            MyPluginModel.$$$reportNull$$$0(42);
        }
        return this.myRequiresRestart.computeIfAbsent(descriptor2 instanceof IdeaPluginDescriptorImpl ? (IdeaPluginDescriptorImpl)descriptor2 : null, it -> it == null || DynamicPlugins.checkCanUnloadWithoutRestart(it) != null);
    }

    boolean isUninstalled(@NotNull IdeaPluginDescriptor descriptor2) {
        if (descriptor2 == null) {
            MyPluginModel.$$$reportNull$$$0(43);
        }
        return this.myUninstalled.contains(descriptor2);
    }

    void addUninstalled(@NotNull IdeaPluginDescriptor descriptor2) {
        if (descriptor2 == null) {
            MyPluginModel.$$$reportNull$$$0(44);
        }
        this.myUninstalled.add(descriptor2);
    }

    @Override
    public void setEnabledState(@NotNull Collection<? extends IdeaPluginDescriptor> descriptors2, @NotNull PluginEnableDisableAction action2) {
        if (descriptors2 == null) {
            MyPluginModel.$$$reportNull$$$0(45);
        }
        if (action2 == null) {
            MyPluginModel.$$$reportNull$$$0(46);
        }
        this.enableRows(descriptors2, action2);
        this.updateAfterEnableDisable();
        this.runInvalidFixCallback();
    }

    void enableRequiredPlugins(@NotNull IdeaPluginDescriptor descriptor2) {
        Set<PluginId> requiredPluginIds;
        if (descriptor2 == null) {
            MyPluginModel.$$$reportNull$$$0(47);
        }
        if (ContainerUtil.isEmpty(requiredPluginIds = this.getRequiredPlugins(descriptor2.getPluginId()))) {
            return;
        }
        List<IdeaPluginDescriptor> allPlugins = this.getAllPlugins();
        HashSet<IdeaPluginDescriptor> requiredPlugins = new HashSet<IdeaPluginDescriptor>();
        for (PluginId pluginId : requiredPluginIds) {
            IdeaPluginDescriptor result2 = (IdeaPluginDescriptor)ContainerUtil.find(allPlugins, d -> pluginId.equals((Object)d.getPluginId()));
            if (result2 == null && PluginManagerCore.isModuleDependency(pluginId) && (result2 = (IdeaPluginDescriptor)ContainerUtil.find(allPlugins, d -> d instanceof IdeaPluginDescriptorImpl && ((IdeaPluginDescriptorImpl)d).modules.contains(pluginId))) != null) {
                this.setEnabled(pluginId, PluginEnabledState.ENABLED);
            }
            if (result2 == null) continue;
            requiredPlugins.add(result2);
        }
        if (!requiredPlugins.isEmpty()) {
            this.enablePlugins(requiredPlugins);
        }
    }

    @Override
    protected void handleBeforeChangeEnableState(@NotNull IdeaPluginDescriptor descriptor2, @NotNull Pair<PluginEnableDisableAction, PluginEnabledState> pair) {
        PluginEnabledState newState2;
        if (descriptor2 == null) {
            MyPluginModel.$$$reportNull$$$0(48);
        }
        if (pair == null) {
            MyPluginModel.$$$reportNull$$$0(49);
        }
        PluginId pluginId = descriptor2.getPluginId();
        Pair<PluginEnableDisableAction, PluginEnabledState> oldPair = this.myDiff.get(descriptor2);
        PluginEnabledState oldState = oldPair != null ? (PluginEnabledState)((Object)oldPair.getSecond()) : null;
        if (oldState != (newState2 = (PluginEnabledState)((Object)pair.getSecond()))) {
            PluginEnabledState state = oldState != null ? oldState : this.getState(pluginId);
            this.myDiff.put(descriptor2, (Pair<PluginEnableDisableAction, PluginEnabledState>)Pair.create((Object)((Object)((PluginEnableDisableAction)((Object)pair.getFirst()))), (Object)((Object)state)));
        } else {
            this.myDiff.remove(descriptor2);
        }
        this.myErrorPluginsToDisable.remove(pluginId);
        if (newState2.isEnabled() || descriptor2.isEnabled()) {
            return;
        }
        if (PluginManagerCore.isIncompatible(descriptor2) || PluginManagerCore.isBrokenPlugin(descriptor2) || this.hasProblematicDependencies(pluginId)) {
            this.myErrorPluginsToDisable.add(pluginId);
        }
    }

    private void runInvalidFixCallback() {
        if (this.myInvalidFixCallback != null) {
            ApplicationManager.getApplication().invokeLater(this.myInvalidFixCallback, ModalityState.any());
        }
    }

    public void setInvalidFixCallback(@Nullable Runnable invalidFixCallback) {
        this.myInvalidFixCallback = invalidFixCallback;
    }

    public void setCancelInstallCallback(@NotNull Consumer<? super IdeaPluginDescriptor> callback2) {
        if (callback2 == null) {
            MyPluginModel.$$$reportNull$$$0(50);
        }
        this.myCancelInstallCallback = callback2;
    }

    private void updateAfterEnableDisable() {
        for (ListPluginComponent component2 : this.myInstalledPluginComponents) {
            component2.updateEnabledState();
        }
        for (PluginDetailsPageComponent detailPanel : this.myDetailPanels) {
            detailPanel.updateEnabledState();
        }
        for (PluginsGroup group2 : this.myEnabledGroups) {
            group2.titleWithEnabled(this);
        }
    }

    public void runRestartButton(@NotNull Component component2) {
        if (component2 == null) {
            MyPluginModel.$$$reportNull$$$0(51);
        }
        if (PluginManagerConfigurable.showRestartDialog() == 0) {
            this.needRestart = true;
            this.createShutdownCallback = false;
            DialogWrapper settings2 = DialogWrapper.findInstance((Component)component2);
            if (settings2 instanceof SettingsDialog) {
                ((SettingsDialog)settings2).applyAndClose(false);
            } else if (this.isModified()) {
                try {
                    this.apply(null);
                }
                catch (ConfigurationException e) {
                    LOG.error((Throwable)e);
                }
            }
            ApplicationManager.getApplication().exit(true, false, true);
        }
    }

    void uninstallAndUpdateUi(@NotNull IdeaPluginDescriptor descriptor2) {
        if (descriptor2 == null) {
            MyPluginModel.$$$reportNull$$$0(52);
        }
        boolean needRestartForUninstall = this.performUninstall((IdeaPluginDescriptorImpl)descriptor2);
        this.needRestart |= descriptor2.isEnabled() && needRestartForUninstall;
        this.myInstallsRequiringRestart |= needRestartForUninstall;
        List<ListPluginComponent> listComponents = this.myInstalledPluginComponentMap.get(descriptor2.getPluginId());
        if (listComponents != null) {
            for (ListPluginComponent listComponent : listComponents) {
                listComponent.updateAfterUninstall(needRestartForUninstall);
            }
        }
        for (ListPluginComponent component2 : this.myInstalledPluginComponents) {
            component2.updateErrors();
        }
        for (PluginDetailsPageComponent panel2 : this.myDetailPanels) {
            if (panel2.getPlugin() != descriptor2) continue;
            panel2.updateButtons();
        }
    }

    private boolean performUninstall(@NotNull IdeaPluginDescriptorImpl descriptorImpl) {
        if (descriptorImpl == null) {
            MyPluginModel.$$$reportNull$$$0(53);
        }
        boolean needRestartForUninstall = true;
        try {
            descriptorImpl.setDeleted(true);
            needRestartForUninstall = PluginInstaller.prepareToUninstall(descriptorImpl);
            InstalledPluginsState.getInstance().onPluginUninstall(descriptorImpl, needRestartForUninstall);
            if (!needRestartForUninstall) {
                this.myDynamicPluginsToUninstall.add(descriptorImpl);
            }
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
        return needRestartForUninstall;
    }

    @Nullable
    public static IdeaPluginDescriptor findPlugin(@NotNull PluginId id2) {
        IdeaPluginDescriptorImpl descriptor2;
        IdeaPluginDescriptor plugin2;
        if (id2 == null) {
            MyPluginModel.$$$reportNull$$$0(54);
        }
        if ((plugin2 = PluginManagerCore.getPlugin(id2)) == null && PluginManagerCore.isModuleDependency(id2) && (descriptor2 = PluginManagerCore.findPluginByModuleDependency(id2)) != null) {
            return descriptor2;
        }
        return plugin2;
    }

    public boolean hasProblematicDependencies(PluginId pluginId) {
        Set<PluginId> ids = this.getDependentToRequiredListMap().get(pluginId);
        if (ContainerUtil.isEmpty(ids)) {
            return false;
        }
        for (PluginId id2 : ids) {
            IdeaPluginDescriptor plugin2 = MyPluginModel.findPlugin(id2);
            if (plugin2 == null || this.isEnabled(plugin2)) continue;
            return true;
        }
        return false;
    }

    public boolean hasErrors(@NotNull IdeaPluginDescriptor plugin2) {
        if (plugin2 == null) {
            MyPluginModel.$$$reportNull$$$0(55);
        }
        return this.getErrorMessage(plugin2, null) != null;
    }

    @Nullable
    @Nls
    public String getErrorMessage(@NotNull IdeaPluginDescriptor pluginDescriptor, @Nullable Ref<? super @Nls String> enableAction) {
        if (pluginDescriptor == null) {
            MyPluginModel.$$$reportNull$$$0(56);
        }
        if (pluginDescriptor instanceof IdeaPluginDescriptorImpl && ((IdeaPluginDescriptorImpl)pluginDescriptor).isDeleted()) {
            return null;
        }
        if (InstalledPluginsState.getInstance().wasUninstalledWithoutRestart(pluginDescriptor.getPluginId())) {
            return null;
        }
        if (InstalledPluginsState.getInstance().wasInstalledWithoutRestart(pluginDescriptor.getPluginId())) {
            return null;
        }
        String message2 = PluginManagerCore.getShortLoadingErrorMessage(pluginDescriptor);
        PluginId disabledDependency = PluginManagerCore.getFirstDisabledDependency(pluginDescriptor);
        if (disabledDependency != null) {
            Set<PluginId> requiredPlugins = MyPluginModel.filterRequiredPlugins(this.getRequiredPlugins(pluginDescriptor.getPluginId()));
            if (!ContainerUtil.isEmpty(requiredPlugins)) {
                boolean[] enable2 = new boolean[]{true};
                String deps = StringUtil.join(requiredPlugins, id2 -> {
                    IdeaPluginDescriptor plugin2 = MyPluginModel.findPlugin(id2);
                    if (enable2[0] && (plugin2 == null || PluginManagerCore.isIncompatible(plugin2))) {
                        enable2[0] = false;
                    }
                    return StringUtil.wrapWithDoubleQuote((String)(plugin2 != null ? plugin2.getName() : id2.getIdString()));
                }, (String)", ");
                int size = requiredPlugins.size();
                message2 = IdeBundle.message((String)"new.plugin.manager.incompatible.deps.tooltip", (Object[])new Object[]{size, deps});
                if (enable2[0] && enableAction != null) {
                    enableAction.set((Object)IdeBundle.message((String)"new.plugin.manager.incompatible.deps.action", (Object[])new Object[]{size}));
                }
            } else {
                message2 = null;
            }
        }
        return message2;
    }

    @Nullable
    private static Set<PluginId> filterRequiredPlugins(@Nullable Set<PluginId> requiredPlugins) {
        if (ContainerUtil.isEmpty(requiredPlugins)) {
            return requiredPlugins;
        }
        Map<PluginId, IdeaPluginDescriptorImpl> pluginIdMap = PluginManagerCore.buildPluginIdMap();
        return requiredPlugins.stream().filter(id2 -> {
            IdeaPluginDescriptorImpl plugin2 = (IdeaPluginDescriptorImpl)pluginIdMap.get(id2);
            return plugin2 == null || !plugin2.isEnabled();
        }).collect(Collectors.toSet());
    }

    @NotNull
    protected Collection<PluginNode> getCustomRepoPlugins() {
        Collection<PluginNode> collection = CustomPluginRepositoryService.getInstance().getCustomRepositoryPlugins();
        if (collection == null) {
            MyPluginModel.$$$reportNull$$$0(57);
        }
        return collection;
    }

    @NotNull
    List<? extends IdeaPluginDescriptor> getDependents(@NotNull IdeaPluginDescriptor rootDescriptor) {
        if (rootDescriptor == null) {
            MyPluginModel.$$$reportNull$$$0(58);
        }
        ApplicationInfoEx appInfo = ApplicationInfoEx.getInstanceEx();
        PluginId rootId = rootDescriptor.getPluginId();
        Map<PluginId, IdeaPluginDescriptorImpl> pluginIdMap = PluginManagerCore.buildPluginIdMap();
        ArrayList result2 = new ArrayList();
        for (IdeaPluginDescriptor plugin2 : this.getAllPlugins()) {
            IdeaPluginDescriptorImpl pluginDescriptor;
            PluginId pluginId = plugin2.getPluginId();
            if (Objects.equals(pluginId, rootId) || appInfo.isEssentialPlugin(pluginId) || !plugin2.isEnabled() || plugin2.isImplementationDetail() || !(plugin2 instanceof IdeaPluginDescriptorImpl) || (pluginDescriptor = (IdeaPluginDescriptorImpl)plugin2).isDeleted()) continue;
            PluginManagerCore.processAllDependencies(pluginDescriptor, pluginIdMap, descriptor2 -> {
                if (Objects.equals(descriptor2.getPluginId(), rootId)) {
                    result2.add(plugin2);
                    return FileVisitResult.TERMINATE;
                }
                return FileVisitResult.CONTINUE;
            });
        }
        ArrayList arrayList = result2;
        if (arrayList == null) {
            MyPluginModel.$$$reportNull$$$0(59);
        }
        return arrayList;
    }

    @NotNull
    public Icon getIcon(@NotNull IdeaPluginDescriptor descriptor2, boolean big, boolean error2, boolean disabled) {
        String key;
        Icon icon2;
        if (descriptor2 == null) {
            MyPluginModel.$$$reportNull$$$0(60);
        }
        if ((icon2 = this.myIcons.get(key = descriptor2.getPluginId().getIdString() + big + error2 + disabled)) == null && (icon2 = PluginLogo.getIcon(descriptor2, big, error2, disabled)) != PluginLogo.getDefault().getIcon(big, error2, disabled)) {
            this.myIcons.put(key, icon2);
        }
        Icon icon3 = icon2;
        if (icon3 == null) {
            MyPluginModel.$$$reportNull$$$0(61);
        }
        return icon3;
    }

    @NotNull
    private static List<String> getDependenciesOnPlugins(@NotNull Project project) {
        if (project == null) {
            MyPluginModel.$$$reportNull$$$0(62);
        }
        List list2 = ContainerUtil.map(ExternalDependenciesManager.getInstance(project).getDependencies(DependencyOnPlugin.class), DependencyOnPlugin::getPluginId);
        if (list2 == null) {
            MyPluginModel.$$$reportNull$$$0(63);
        }
        return list2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 16: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 37: 
            case 40: 
            case 57: 
            case 59: 
            case 61: 
            case 63: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 16: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 37: 
            case 40: 
            case 57: 
            case 59: 
            case 61: 
            case 63: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callbackData";
                break;
            }
            case 1: 
            case 2: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "topController";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "service";
                break;
            }
            case 5: 
            case 16: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 37: 
            case 40: 
            case 57: 
            case 59: 
            case 61: 
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/plugins/newui/MyPluginModel";
                break;
            }
            case 6: 
            case 7: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 19: 
            case 26: 
            case 27: 
            case 33: 
            case 35: 
            case 36: 
            case 38: 
            case 42: 
            case 43: 
            case 44: 
            case 47: 
            case 48: 
            case 52: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modalityState";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operation";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "panel";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "downloaded";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "installing";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "detailPanel";
                break;
            }
            case 31: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vendors";
                break;
            }
            case 39: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginId";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pair";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptorImpl";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "plugin";
                break;
            }
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginDescriptor";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootDescriptor";
                break;
            }
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/plugins/newui/MyPluginModel";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstallingPlugins";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "finishInstall";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getVendors";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getTags";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstalledDescriptors";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getVendorsCount";
                break;
            }
            case 37: 
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "getCustomRepoPlugins";
                break;
            }
            case 59: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependents";
                break;
            }
            case 61: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
            case 63: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependenciesOnPlugins";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "pluginInstalledFromDisk";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "addComponent";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "removeComponent";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setTopController";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setPluginUpdatesService";
                break;
            }
            case 5: 
            case 16: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 37: 
            case 40: 
            case 57: 
            case 59: 
            case 61: 
            case 63: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isInstallingOrUpdate";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "installOrUpdatePlugin";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "runInstallOperation";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "prepareToInstall";
                break;
            }
            case 13: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "finishInstall";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "clearInstallingProgress";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "addProgress";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "removeProgress";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "addEnabledGroup";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "setDownloadedGroup";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "addDetailPanel";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "appendOrUpdateDescriptor";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getVendorsCount";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "isVendor";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "isEnabled";
                break;
            }
            case 36: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getState";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getProjectDependentState";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "isRequiredPluginForProject";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "requiresRestart";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "isUninstalled";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "addUninstalled";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "setEnabledState";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "enableRequiredPlugins";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "handleBeforeChangeEnableState";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "setCancelInstallCallback";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "runRestartButton";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "uninstallAndUpdateUi";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "performUninstall";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "findPlugin";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "hasErrors";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "getErrorMessage";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "getDependents";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "getIcon";
                break;
            }
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "getDependenciesOnPlugins";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 16: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 37: 
            case 40: 
            case 57: 
            case 59: 
            case 61: 
            case 63: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

