/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins.cl;

import com.intellij.diagnostic.PluginException;
import com.intellij.diagnostic.StartUpMeasurer;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.cl.PluginAwareClassLoader;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.util.ShutDownTracker;
import com.intellij.util.SmartList;
import com.intellij.util.lang.ClassPath;
import com.intellij.util.lang.Resource;
import com.intellij.util.lang.UrlClassLoader;
import com.intellij.util.ui.EDT;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@ApiStatus.Internal
public final class PluginClassLoader
extends UrlClassLoader
implements PluginAwareClassLoader {
    public static final ClassLoader[] EMPTY_CLASS_LOADER_ARRAY = new ClassLoader[0];
    private static final boolean isParallelCapable = PluginClassLoader.registerAsParallelCapable();
    @Nullable
    private static final Writer logStream;
    private static final AtomicInteger instanceIdProducer;
    private static final AtomicInteger parentListCacheIdCounter;
    private static final Set<String> KOTLIN_STDLIB_CLASSES_USED_IN_SIGNATURES;
    private static final ProtectionDomain PROTECTION_DOMAIN;
    private IdeaPluginDescriptorImpl[] parents;
    private volatile ClassLoader[] allParents;
    private volatile int allParentsLastCacheId;
    private final PluginDescriptor pluginDescriptor;
    private final PluginId pluginId;
    private final String packagePrefix;
    private final List<String> libDirectories;
    private final AtomicLong edtTime;
    private final AtomicLong backgroundTime;
    private final AtomicInteger loadedClassCounter;
    @NotNull
    private final ClassLoader coreLoader;
    private final int instanceId;
    private volatile int state;
    private final ResolveScopeManager resolveScopeManager;

    public PluginClassLoader(@NotNull UrlClassLoader.Builder builder2, @NotNull @NotNull IdeaPluginDescriptorImpl @NotNull [] dependencies, @NotNull PluginDescriptor pluginDescriptor, @Nullable Path pluginRoot, @NotNull ClassLoader coreLoader) {
        Path libDir;
        if (builder2 == null) {
            PluginClassLoader.$$$reportNull$$$0(0);
        }
        if (dependencies == null) {
            PluginClassLoader.$$$reportNull$$$0(1);
        }
        if (pluginDescriptor == null) {
            PluginClassLoader.$$$reportNull$$$0(2);
        }
        if (coreLoader == null) {
            PluginClassLoader.$$$reportNull$$$0(3);
        }
        super(builder2, null, isParallelCapable, false);
        this.edtTime = new AtomicLong();
        this.backgroundTime = new AtomicLong();
        this.loadedClassCounter = new AtomicInteger();
        this.state = 1;
        this.instanceId = instanceIdProducer.incrementAndGet();
        this.resolveScopeManager = (p1, p2, p3) -> null;
        this.pluginDescriptor = pluginDescriptor;
        this.pluginId = pluginDescriptor.getPluginId();
        this.packagePrefix = null;
        this.coreLoader = coreLoader;
        this.parents = dependencies;
        this.libDirectories = new SmartList();
        if (pluginRoot != null && Files.exists(libDir = pluginRoot.resolve("lib"), new LinkOption[0])) {
            this.libDirectories.add(libDir.toAbsolutePath().toString());
        }
    }

    public PluginClassLoader(@NotNull List<Path> files2, @NotNull ClassPath classPath, @NotNull @NotNull IdeaPluginDescriptorImpl @NotNull [] dependencies, @NotNull PluginDescriptor pluginDescriptor, @NotNull ClassLoader coreLoader, @Nullable ResolveScopeManager resolveScopeManager, @Nullable String packagePrefix, @NotNull List<String> libDirectories) {
        if (files2 == null) {
            PluginClassLoader.$$$reportNull$$$0(4);
        }
        if (classPath == null) {
            PluginClassLoader.$$$reportNull$$$0(5);
        }
        if (dependencies == null) {
            PluginClassLoader.$$$reportNull$$$0(6);
        }
        if (pluginDescriptor == null) {
            PluginClassLoader.$$$reportNull$$$0(7);
        }
        if (coreLoader == null) {
            PluginClassLoader.$$$reportNull$$$0(8);
        }
        if (libDirectories == null) {
            PluginClassLoader.$$$reportNull$$$0(9);
        }
        super(files2, classPath);
        this.edtTime = new AtomicLong();
        this.backgroundTime = new AtomicLong();
        this.loadedClassCounter = new AtomicInteger();
        this.state = 1;
        this.instanceId = instanceIdProducer.incrementAndGet();
        this.resolveScopeManager = resolveScopeManager == null ? (p1, p2, p3) -> null : resolveScopeManager;
        this.parents = dependencies;
        this.pluginDescriptor = pluginDescriptor;
        this.pluginId = pluginDescriptor.getPluginId();
        this.packagePrefix = packagePrefix == null || packagePrefix.endsWith(".") ? packagePrefix : packagePrefix + '.';
        this.coreLoader = coreLoader;
        this.libDirectories = libDirectories;
    }

    @NotNull
    public List<String> getLibDirectories() {
        List<String> list2 = this.libDirectories;
        if (list2 == null) {
            PluginClassLoader.$$$reportNull$$$0(10);
        }
        return list2;
    }

    @Nullable
    public String getPackagePrefix() {
        return this.packagePrefix;
    }

    @ApiStatus.Internal
    public int getState() {
        return this.state;
    }

    @ApiStatus.Internal
    public void setState(int state) {
        this.state = state;
    }

    public int getInstanceId() {
        return this.instanceId;
    }

    public long getEdtTime() {
        return this.edtTime.get();
    }

    public long getBackgroundTime() {
        return this.backgroundTime.get();
    }

    public long getLoadedClassCount() {
        return this.loadedClassCounter.get();
    }

    public Class<?> loadClass(@NotNull String name, boolean resolve2) throws ClassNotFoundException {
        Class<?> c;
        if (name == null) {
            PluginClassLoader.$$$reportNull$$$0(11);
        }
        if ((c = this.tryLoadingClass(name, false)) == null) {
            PluginClassLoader.flushDebugLog();
            throw new ClassNotFoundException(name + " " + (Object)((Object)this));
        }
        return c;
    }

    @Nullable
    public Class<?> tryLoadingClass(@NotNull String name, boolean forceLoadFromSubPluginClassloader) throws ClassNotFoundException {
        Class<?> c;
        if (name == null) {
            PluginClassLoader.$$$reportNull$$$0(12);
        }
        if (PluginClassLoader.mustBeLoadedByPlatform(name)) {
            return this.coreLoader.loadClass(name);
        }
        long startTime = StartUpMeasurer.measuringPluginStartupCosts ? StartUpMeasurer.getCurrentTime() : -1L;
        PluginException error2 = null;
        try {
            String consistencyError = this.resolveScopeManager.isDefinitelyAlienClass(name, this.packagePrefix, forceLoadFromSubPluginClassloader);
            if (consistencyError == null) {
                c = this.loadClassInsideSelf(name, forceLoadFromSubPluginClassloader);
            } else {
                if (!consistencyError.isEmpty()) {
                    error2 = new PluginException(consistencyError, this.pluginId);
                }
                c = null;
            }
        }
        catch (IOException e) {
            throw new ClassNotFoundException(name, e);
        }
        if (c == null) {
            for (ClassLoader classloader : this.getAllParents()) {
                if (classloader instanceof PluginClassLoader) {
                    try {
                        PluginClassLoader pluginClassLoader = (PluginClassLoader)((Object)classloader);
                        String consistencyError = pluginClassLoader.resolveScopeManager.isDefinitelyAlienClass(name, pluginClassLoader.packagePrefix, forceLoadFromSubPluginClassloader);
                        if (consistencyError != null) {
                            if (consistencyError.isEmpty() || error2 != null) continue;
                            error2 = new PluginException(consistencyError, this.pluginId);
                            continue;
                        }
                        c = pluginClassLoader.loadClassInsideSelf(name, false);
                    }
                    catch (IOException e) {
                        throw new ClassNotFoundException(name, e);
                    }
                    if (c == null) continue;
                    break;
                }
                if (classloader instanceof UrlClassLoader) {
                    try {
                        c = ((UrlClassLoader)classloader).loadClassInsideSelf(name, false);
                    }
                    catch (IOException e) {
                        throw new ClassNotFoundException(name, e);
                    }
                    if (c == null) continue;
                    break;
                }
                try {
                    c = classloader.loadClass(name);
                    if (c == null) continue;
                    break;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            if (error2 != null) {
                throw error2;
            }
        }
        if (startTime != -1L) {
            (EDT.isCurrentThreadEdt() ? this.edtTime : this.backgroundTime).addAndGet(StartUpMeasurer.getCurrentTime() - startTime);
        }
        return c;
    }

    @NotNull
    private @NotNull ClassLoader @NotNull [] getAllParents() {
        ClassLoader classLoader;
        ClassLoader[] result2 = this.allParents;
        if (result2 != null && this.allParentsLastCacheId == parentListCacheIdCounter.get()) {
            if (result2 == null) {
                PluginClassLoader.$$$reportNull$$$0(13);
            }
            return result2;
        }
        if (this.parents.length == 0) {
            result2 = new ClassLoader[]{this.coreLoader};
            this.allParents = result2;
            if (result2 == null) {
                PluginClassLoader.$$$reportNull$$$0(14);
            }
            return result2;
        }
        LinkedHashSet<ClassLoader> parentSet = new LinkedHashSet<ClassLoader>();
        ArrayDeque<ClassLoader> queue2 = new ArrayDeque<ClassLoader>();
        this.collectClassLoaders(queue2);
        while ((classLoader = (ClassLoader)queue2.pollFirst()) != null) {
            if (!parentSet.add(classLoader) || !(classLoader instanceof PluginClassLoader)) continue;
            ((PluginClassLoader)((Object)classLoader)).collectClassLoaders(queue2);
        }
        parentSet.add(this.coreLoader);
        result2 = parentSet.toArray(EMPTY_CLASS_LOADER_ARRAY);
        this.allParents = result2;
        this.allParentsLastCacheId = parentListCacheIdCounter.get();
        if (result2 == null) {
            PluginClassLoader.$$$reportNull$$$0(15);
        }
        return result2;
    }

    private void collectClassLoaders(@NotNull Deque<ClassLoader> queue2) {
        if (queue2 == null) {
            PluginClassLoader.$$$reportNull$$$0(16);
        }
        for (IdeaPluginDescriptorImpl parent : this.parents) {
            ClassLoader classLoader = parent.classLoader;
            if (classLoader == null || classLoader == this.coreLoader) continue;
            queue2.add(classLoader);
        }
    }

    public void clearParentListCache() {
        this.allParents = null;
    }

    private static boolean mustBeLoadedByPlatform(@NonNls String className) {
        if (className.startsWith("java.")) {
            return true;
        }
        return className.startsWith("kotlin.") && (className.startsWith("kotlin.jvm.functions.") || className.startsWith("kotlin.reflect.") && className.indexOf(46, 15) < 0 || KOTLIN_STDLIB_CLASSES_USED_IN_SIGNATURES.contains(className));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Class<?> loadClassInsideSelf(@NotNull String name, boolean forceLoadFromSubPluginClassloader) throws IOException {
        if (name == null) {
            PluginClassLoader.$$$reportNull$$$0(17);
        }
        Object object = this.getClassLoadingLock(name);
        synchronized (object) {
            Class c = this.findLoadedClass(name);
            if (c != null && c.getClassLoader() == this) {
                return c;
            }
            Writer logStream = PluginClassLoader.logStream;
            try {
                c = this.classPath.findClass(name, this.classDataConsumer);
            }
            catch (LinkageError e) {
                if (logStream != null) {
                    this.logClass(name, logStream, e);
                }
                PluginClassLoader.flushDebugLog();
                throw new PluginException("Cannot load class " + name + " (\n  error: " + e.getMessage() + ",\n  classLoader=" + (Object)((Object)this) + "\n)", (Throwable)e, this.pluginId);
            }
            if (c == null) {
                return null;
            }
            this.loadedClassCounter.incrementAndGet();
            if (logStream != null) {
                this.logClass(name, logStream, null);
            }
            return c;
        }
    }

    private void logClass(@NotNull String name, @NotNull Writer logStream, @Nullable LinkageError exception) {
        if (name == null) {
            PluginClassLoader.$$$reportNull$$$0(18);
        }
        if (logStream == null) {
            PluginClassLoader.$$$reportNull$$$0(19);
        }
        try {
            String descriptorPath = ((IdeaPluginDescriptor)this.pluginDescriptor).getDescriptorPath();
            String specifier = descriptorPath == null ? "m" : "sub = " + descriptorPath;
            logStream.write(name + " [" + specifier + "] " + this.pluginId.getIdString() + (this.packagePrefix == null ? "" : ':' + this.packagePrefix) + '\n' + (exception == null ? "" : exception.getMessage()));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Nullable
    public URL findResource(@NotNull String name) {
        if (name == null) {
            PluginClassLoader.$$$reportNull$$$0(20);
        }
        return this.findResource(name, Resource::getURL, ClassLoader::getResource);
    }

    @Nullable
    public InputStream getResourceAsStream(@NotNull String name) {
        if (name == null) {
            PluginClassLoader.$$$reportNull$$$0(21);
        }
        Function<Resource, InputStream> f1 = resource -> {
            try {
                return resource.getInputStream();
            }
            catch (IOException e) {
                Logger.getInstance(PluginClassLoader.class).error((Throwable)e);
                return null;
            }
        };
        BiFunction<ClassLoader, String, InputStream> f2 = (cl, path2) -> {
            try {
                return cl.getResourceAsStream((String)path2);
            }
            catch (Exception e) {
                Logger.getInstance(PluginClassLoader.class).error((Throwable)e);
                return null;
            }
        };
        return this.findResource(name, f1, f2);
    }

    @Nullable
    private <T> T findResource(String name, Function<Resource, T> f1, BiFunction<ClassLoader, String, T> f2) {
        Resource resource;
        String canonicalPath = PluginClassLoader.toCanonicalPath((String)name);
        if (canonicalPath.startsWith("/")) {
            if (!canonicalPath.startsWith("/org/bridj/")) {
                String message2 = "Do not request resource from classloader using path with leading slash";
                Logger.getInstance(PluginClassLoader.class).error(message2, (Throwable)new PluginException(name, this.pluginId));
            }
            canonicalPath = canonicalPath.substring(1);
        }
        if ((resource = this.classPath.findResource(canonicalPath)) != null) {
            return f1.apply(resource);
        }
        for (ClassLoader classloader : this.getAllParents()) {
            if (classloader instanceof PluginClassLoader) {
                resource = ((PluginClassLoader)((Object)classloader)).classPath.findResource(canonicalPath);
                if (resource == null) continue;
                return f1.apply(resource);
            }
            T t = f2.apply(classloader, canonicalPath);
            if (t == null) continue;
            return t;
        }
        return null;
    }

    @NotNull
    public Enumeration<URL> findResources(@NotNull String name) throws IOException {
        if (name == null) {
            PluginClassLoader.$$$reportNull$$$0(22);
        }
        ArrayList<Enumeration<URL>> resources = new ArrayList<Enumeration<URL>>();
        resources.add(this.classPath.getResources(name));
        for (ClassLoader classloader : this.getAllParents()) {
            if (classloader instanceof PluginClassLoader) {
                resources.add(((PluginClassLoader)((Object)classloader)).classPath.getResources(name));
                continue;
            }
            try {
                resources.add(classloader.getResources(name));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return new DeepEnumeration(resources);
    }

    public void addLibDirectories(@NotNull Collection<String> libDirectories) {
        if (libDirectories == null) {
            PluginClassLoader.$$$reportNull$$$0(23);
        }
        this.libDirectories.addAll(libDirectories);
    }

    protected String findLibrary(String libName) {
        if (!this.libDirectories.isEmpty()) {
            String libFileName = System.mapLibraryName(libName);
            ListIterator<String> i2 = this.libDirectories.listIterator(this.libDirectories.size());
            while (i2.hasPrevious()) {
                File libFile = new File(i2.previous(), libFileName);
                if (!libFile.exists()) continue;
                return libFile.getAbsolutePath();
            }
        }
        return null;
    }

    @NotNull
    public PluginId getPluginId() {
        PluginId pluginId = this.pluginId;
        if (pluginId == null) {
            PluginClassLoader.$$$reportNull$$$0(24);
        }
        return pluginId;
    }

    @NotNull
    public PluginDescriptor getPluginDescriptor() {
        PluginDescriptor pluginDescriptor = this.pluginDescriptor;
        if (pluginDescriptor == null) {
            PluginClassLoader.$$$reportNull$$$0(25);
        }
        return pluginDescriptor;
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "(plugin=" + this.pluginDescriptor + ", packagePrefix=" + this.packagePrefix + ", instanceId=" + this.instanceId + ", state=" + (this.state == 1 ? "active" : "unload in progress") + ")";
    }

    @TestOnly
    @ApiStatus.Internal
    @NotNull
    public List<IdeaPluginDescriptorImpl> _getParents() {
        List<IdeaPluginDescriptorImpl> list2 = Collections.unmodifiableList(Arrays.asList(this.parents));
        if (list2 == null) {
            PluginClassLoader.$$$reportNull$$$0(26);
        }
        return list2;
    }

    @ApiStatus.Internal
    public void attachParent(@NotNull IdeaPluginDescriptorImpl parent) {
        if (parent == null) {
            PluginClassLoader.$$$reportNull$$$0(27);
        }
        if (Arrays.stream(this.parents).anyMatch(it -> it == parent)) {
            return;
        }
        int length = this.parents.length;
        IdeaPluginDescriptorImpl[] result2 = new IdeaPluginDescriptorImpl[length + 1];
        System.arraycopy(this.parents, 0, result2, 0, length);
        result2[length] = parent;
        this.parents = result2;
        this.allParents = null;
        parentListCacheIdCounter.incrementAndGet();
    }

    @ApiStatus.Internal
    public boolean detachParent(@NotNull IdeaPluginDescriptorImpl parent) {
        if (parent == null) {
            PluginClassLoader.$$$reportNull$$$0(28);
        }
        for (int i2 = 0; i2 < this.parents.length; ++i2) {
            if (parent != this.parents[i2]) continue;
            int length = this.parents.length;
            IdeaPluginDescriptorImpl[] result2 = new IdeaPluginDescriptorImpl[length - 1];
            System.arraycopy(this.parents, 0, result2, 0, i2);
            System.arraycopy(this.parents, i2 + 1, result2, i2, length - i2 - 1);
            this.parents = result2;
            this.allParents = null;
            parentListCacheIdCounter.incrementAndGet();
            return true;
        }
        return false;
    }

    protected ProtectionDomain getProtectionDomain() {
        return PROTECTION_DOMAIN;
    }

    private static void flushDebugLog() {
        if (logStream != null) {
            try {
                logStream.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    static {
        instanceIdProducer = new AtomicInteger();
        parentListCacheIdCounter = new AtomicInteger();
        PROTECTION_DOMAIN = new ProtectionDomain(new CodeSource(null, (Certificate[])null), null);
        HashSet<String> kotlinStdlibClassesUsedInSignatures = new HashSet<String>(Arrays.asList("kotlin.Function", "kotlin.sequences.Sequence", "kotlin.ranges.IntRange", "kotlin.ranges.IntRange$Companion", "kotlin.ranges.IntProgression", "kotlin.ranges.ClosedRange", "kotlin.ranges.IntProgressionIterator", "kotlin.ranges.IntProgression$Companion", "kotlin.ranges.IntProgression", "kotlin.collections.IntIterator", "kotlin.Lazy", "kotlin.Unit", "kotlin.Pair", "kotlin.Triple", "kotlin.jvm.internal.DefaultConstructorMarker", "kotlin.jvm.internal.ClassBasedDeclarationContainer", "kotlin.properties.ReadWriteProperty", "kotlin.properties.ReadOnlyProperty", "kotlin.coroutines.ContinuationInterceptor", "kotlinx.coroutines.CoroutineDispatcher", "kotlin.coroutines.Continuation", "kotlin.coroutines.CoroutineContext", "kotlin.coroutines.CoroutineContext$Element", "kotlin.coroutines.CoroutineContext$Key"));
        String classes = System.getProperty("idea.kotlin.classes.used.in.signatures");
        if (classes != null) {
            StringTokenizer t = new StringTokenizer(classes, ",");
            while (t.hasMoreTokens()) {
                kotlinStdlibClassesUsedInSignatures.add(t.nextToken());
            }
        }
        KOTLIN_STDLIB_CLASSES_USED_IN_SIGNATURES = kotlinStdlibClassesUsedInSignatures;
        BufferedWriter logStreamCandidate = null;
        String debugFilePath = System.getProperty("plugin.classloader.debug", "");
        if (!debugFilePath.isEmpty()) {
            try {
                if (debugFilePath.startsWith("~/") || debugFilePath.startsWith("~\\")) {
                    debugFilePath = System.getProperty("user.home") + debugFilePath.substring(1);
                }
                logStreamCandidate = Files.newBufferedWriter(Paths.get(debugFilePath, new String[0]), new OpenOption[0]);
                ShutDownTracker.getInstance().registerShutdownTask(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            if (logStream != null) {
                                logStream.close();
                            }
                        }
                        catch (IOException e) {
                            Logger.getInstance(PluginClassLoader.class).error((Throwable)e);
                        }
                    }
                });
            }
            catch (IOException e) {
                Logger.getInstance(PluginClassLoader.class).error((Throwable)e);
            }
        }
        logStream = logStreamCandidate;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 24: 
            case 25: 
            case 26: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 24: 
            case 25: 
            case 26: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependencies";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginDescriptor";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coreLoader";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classPath";
                break;
            }
            case 9: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libDirectories";
                break;
            }
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 24: 
            case 25: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/plugins/cl/PluginClassLoader";
                break;
            }
            case 11: 
            case 12: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "queue";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logStream";
                break;
            }
            case 27: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/plugins/cl/PluginClassLoader";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibDirectories";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllParents";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getPluginId";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getPluginDescriptor";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "_getParents";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 24: 
            case 25: 
            case 26: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "loadClass";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "tryLoadingClass";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "collectClassLoaders";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "loadClassInsideSelf";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "logClass";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "findResource";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getResourceAsStream";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "findResources";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "addLibDirectories";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "attachParent";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "detachParent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 24: 
            case 25: 
            case 26: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class DeepEnumeration
    implements Enumeration<URL> {
        @NotNull
        private final List<? extends Enumeration<URL>> list;
        private int myIndex;

        DeepEnumeration(@NotNull List<? extends Enumeration<URL>> enumerations) {
            if (enumerations == null) {
                DeepEnumeration.$$$reportNull$$$0(0);
            }
            this.list = enumerations;
        }

        @Override
        public boolean hasMoreElements() {
            while (this.myIndex < this.list.size()) {
                Enumeration<URL> e = this.list.get(this.myIndex);
                if (e != null && e.hasMoreElements()) {
                    return true;
                }
                ++this.myIndex;
            }
            return false;
        }

        @Override
        public URL nextElement() {
            if (!this.hasMoreElements()) {
                throw new NoSuchElementException();
            }
            return this.list.get(this.myIndex).nextElement();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "enumerations", "com/intellij/ide/plugins/cl/PluginClassLoader$DeepEnumeration", "<init>"));
        }
    }

    public static interface ResolveScopeManager {
        public String isDefinitelyAlienClass(String var1, String var2, boolean var3);
    }
}

