/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.core.CoreBundle;
import com.intellij.diagnostic.Activity;
import com.intellij.diagnostic.ActivityCategory;
import com.intellij.diagnostic.LoadingState;
import com.intellij.diagnostic.PluginException;
import com.intellij.diagnostic.StartUpMeasurer;
import com.intellij.ide.plugins.CachingSemiGraph;
import com.intellij.ide.plugins.ClassLoaderConfigurator;
import com.intellij.ide.plugins.DescriptorListLoadingContext;
import com.intellij.ide.plugins.DisabledPluginsState;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.ModuleDependenciesDescriptor;
import com.intellij.ide.plugins.PluginContentDescriptor;
import com.intellij.ide.plugins.PluginDependency;
import com.intellij.ide.plugins.PluginDescriptorLoader;
import com.intellij.ide.plugins.PluginLoadingError;
import com.intellij.ide.plugins.PluginLoadingResult;
import com.intellij.ide.plugins.PluginManagerState;
import com.intellij.ide.plugins.PluginSet;
import com.intellij.ide.plugins.cl.PluginAwareClassLoader;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.graph.DFSTBuilder;
import com.intellij.util.lang.Java11Shim;
import com.intellij.util.lang.UrlClassLoader;
import java.awt.GraphicsEnvironment;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Writer;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ForkJoinPool;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;

public final class PluginManagerCore {
    @NonNls
    public static final String META_INF = "META-INF/";
    public static final PluginId CORE_ID = PluginId.getId((String)"com.intellij");
    public static final String CORE_PLUGIN_ID = "com.intellij";
    public static final PluginId JAVA_PLUGIN_ID = PluginId.getId((String)"com.intellij.java");
    static final PluginId JAVA_MODULE_ID = PluginId.getId((String)"com.intellij.modules.java");
    public static final String PLUGIN_XML = "plugin.xml";
    public static final String PLUGIN_XML_PATH = "META-INF/plugin.xml";
    static final PluginId ALL_MODULES_MARKER = PluginId.getId((String)"com.intellij.modules.all");
    public static final String VENDOR_JETBRAINS = "JetBrains";
    public static final String VENDOR_JETBRAINS_SRO = "JetBrains s.r.o.";
    private static final String MODULE_DEPENDENCY_PREFIX = "com.intellij.module";
    public static final PluginId SPECIAL_IDEA_PLUGIN_ID = PluginId.getId((String)"IDEA CORE");
    static final String PROPERTY_PLUGIN_PATH = "plugin.path";
    @NonNls
    static final String DISABLE = "disable";
    @NonNls
    static final String ENABLE = "enable";
    @NonNls
    static final String EDIT = "edit";
    private static final boolean IGNORE_DISABLED_PLUGINS = Boolean.getBoolean("idea.ignore.disabled.plugins");
    private static final MethodType HAS_LOADED_CLASS_METHOD_TYPE = MethodType.methodType(Boolean.TYPE, String.class);
    private static Reference<Map<PluginId, Set<String>>> brokenPluginVersions;
    @Nullable
    private static volatile PluginSet pluginSet;
    private static Map<PluginId, PluginLoadingError> pluginLoadingErrors;
    public static volatile boolean isUnitTestMode;
    @ApiStatus.Internal
    private static final List<Supplier<? extends HtmlChunk>> pluginErrors;
    private static Set<PluginId> ourPluginsToDisable;
    private static Set<PluginId> ourPluginsToEnable;
    @ApiStatus.Internal
    public static boolean ourDisableNonBundledPlugins;
    private static Set<PluginId> ourShadowedBundledPlugins;
    private static Boolean isRunningFromSources;
    private static volatile CompletableFuture<DescriptorListLoadingContext> descriptorListFuture;
    private static BuildNumber ourBuildNumber;

    @NotNull
    public static @NotNull IdeaPluginDescriptor @NotNull [] getPlugins() {
        IdeaPluginDescriptor[] ideaPluginDescriptorArray = PluginManagerCore.getPluginSet().allPlugins.toArray(new IdeaPluginDescriptor[0]);
        if (ideaPluginDescriptorArray == null) {
            PluginManagerCore.$$$reportNull$$$0(0);
        }
        return ideaPluginDescriptorArray;
    }

    @NotNull
    static PluginSet getPluginSet() {
        PluginSet pluginSet = Objects.requireNonNull(PluginManagerCore.pluginSet);
        if (pluginSet == null) {
            PluginManagerCore.$$$reportNull$$$0(1);
        }
        return pluginSet;
    }

    @NotNull
    public static List<? extends IdeaPluginDescriptor> getLoadedPlugins() {
        return PluginManagerCore.getLoadedPlugins(null);
    }

    @ApiStatus.Internal
    @NotNull
    public static List<IdeaPluginDescriptorImpl> getLoadedPlugins(@Nullable ClassLoader coreClassLoader) {
        PluginSet result2 = pluginSet;
        if (result2 != null) {
            List<IdeaPluginDescriptorImpl> list2 = result2.enabledPlugins;
            if (list2 == null) {
                PluginManagerCore.$$$reportNull$$$0(2);
            }
            return list2;
        }
        List<IdeaPluginDescriptorImpl> list3 = PluginManagerCore.loadAndInitializePlugins((DescriptorListLoadingContext)PluginDescriptorLoader.loadDescriptors((boolean)PluginManagerCore.isUnitTestMode, (boolean)PluginManagerCore.isRunningFromSources()), (ClassLoader)(coreClassLoader == null ? PluginManagerCore.class.getClassLoader() : coreClassLoader)).enabledPlugins;
        if (list3 == null) {
            PluginManagerCore.$$$reportNull$$$0(3);
        }
        return list3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @ApiStatus.Internal
    @NotNull
    public static List<HtmlChunk> getAndClearPluginLoadingErrors() {
        List<Supplier<? extends HtmlChunk>> list3 = pluginErrors;
        // MONITORENTER : list3
        List errors = ContainerUtil.map(pluginErrors, Supplier::get);
        pluginErrors.clear();
        List list2 = errors;
        // MONITOREXIT : list3
        if (list2 != null) return list2;
        PluginManagerCore.$$$reportNull$$$0(4);
        return list2;
    }

    @ApiStatus.Internal
    public static boolean arePluginsInitialized() {
        return pluginSet != null;
    }

    @ApiStatus.Internal
    public static void setPluginSet(@NotNull PluginSet value2) {
        if (value2 == null) {
            PluginManagerCore.$$$reportNull$$$0(5);
        }
        pluginSet = value2;
    }

    public static boolean isDisabled(@NotNull PluginId pluginId) {
        if (pluginId == null) {
            PluginManagerCore.$$$reportNull$$$0(6);
        }
        return DisabledPluginsState.isDisabled(pluginId);
    }

    public static boolean isBrokenPlugin(@NotNull IdeaPluginDescriptor descriptor2) {
        if (descriptor2 == null) {
            PluginManagerCore.$$$reportNull$$$0(7);
        }
        PluginId pluginId = descriptor2.getPluginId();
        Set<String> set2 = PluginManagerCore.getBrokenPluginVersions().get(pluginId);
        return set2 != null && set2.contains(descriptor2.getVersion());
    }

    public static void updateBrokenPlugins(Map<PluginId, Set<String>> brokenPlugins2) {
        brokenPluginVersions = new SoftReference<Map<PluginId, Set<String>>>(brokenPlugins2);
        Path updatedBrokenPluginFile = PluginManagerCore.getUpdatedBrokenPluginFile();
        try (DataOutputStream out2 = new DataOutputStream(new BufferedOutputStream(Files.newOutputStream(updatedBrokenPluginFile, new OpenOption[0]), 32000));){
            out2.write(1);
            out2.writeInt(brokenPlugins2.size());
            for (Map.Entry<PluginId, Set<String>> entry2 : brokenPlugins2.entrySet()) {
                out2.writeUTF(entry2.getKey().getIdString());
                out2.writeShort(entry2.getValue().size());
                for (String s : entry2.getValue()) {
                    out2.writeUTF(s);
                }
            }
        }
        catch (NoSuchFileException out2) {
        }
        catch (IOException e) {
            PluginManagerCore.getLogger().error("Failed to read " + updatedBrokenPluginFile, (Throwable)e);
        }
    }

    @NotNull
    static @NotNull Map<@NotNull PluginId, @NotNull Set<String>> getBrokenPluginVersions() {
        Map<PluginId, Set<String>> result2;
        if (IGNORE_DISABLED_PLUGINS) {
            Map<PluginId, Set<String>> map2 = Collections.emptyMap();
            if (map2 == null) {
                PluginManagerCore.$$$reportNull$$$0(8);
            }
            return map2;
        }
        Map<PluginId, Set<String>> map3 = result2 = brokenPluginVersions == null ? null : brokenPluginVersions.get();
        if (result2 == null) {
            result2 = PluginManagerCore.readBrokenPluginFile();
            brokenPluginVersions = new SoftReference<Map<PluginId, Set<String>>>(result2);
        }
        Map<PluginId, Set<String>> map4 = result2;
        if (map4 == null) {
            PluginManagerCore.$$$reportNull$$$0(9);
        }
        return map4;
    }

    /*
     * Exception decompiling
     */
    @NotNull
    private static Map<PluginId, Set<String>> readBrokenPluginFile() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void writePluginsList(@NotNull Collection<PluginId> ids, @NotNull Writer writer) throws IOException {
        if (ids == null) {
            PluginManagerCore.$$$reportNull$$$0(13);
        }
        if (writer == null) {
            PluginManagerCore.$$$reportNull$$$0(14);
        }
        ArrayList<PluginId> sortedIds = new ArrayList<PluginId>(ids);
        sortedIds.sort(null);
        for (PluginId id2 : sortedIds) {
            writer.write(id2.getIdString());
            writer.write(10);
        }
    }

    public static boolean disablePlugin(@NotNull PluginId id2) {
        if (id2 == null) {
            PluginManagerCore.$$$reportNull$$$0(15);
        }
        return DisabledPluginsState.setEnabledState(Collections.singleton(id2), false);
    }

    public static boolean enablePlugin(@NotNull PluginId id2) {
        if (id2 == null) {
            PluginManagerCore.$$$reportNull$$$0(16);
        }
        return DisabledPluginsState.setEnabledState(Collections.singleton(id2), true);
    }

    public static boolean isModuleDependency(@NotNull PluginId dependentPluginId) {
        if (dependentPluginId == null) {
            PluginManagerCore.$$$reportNull$$$0(17);
        }
        return dependentPluginId.getIdString().startsWith(MODULE_DEPENDENCY_PREFIX);
    }

    @ApiStatus.Internal
    @NotNull
    public static PluginException createPluginException(@NotNull String errorMessage, @Nullable Throwable cause, @NotNull Class<?> pluginClass) {
        ClassLoader classLoader;
        if (errorMessage == null) {
            PluginManagerCore.$$$reportNull$$$0(18);
        }
        if (pluginClass == null) {
            PluginManagerCore.$$$reportNull$$$0(19);
        }
        PluginId pluginId = (classLoader = pluginClass.getClassLoader()) instanceof PluginAwareClassLoader ? ((PluginAwareClassLoader)classLoader).getPluginId() : PluginManagerCore.getPluginByClassName(pluginClass.getName());
        return new PluginException(errorMessage, cause, pluginId);
    }

    @Nullable
    public static PluginId getPluginByClassName(@NotNull String className) {
        PluginId id2;
        if (className == null) {
            PluginManagerCore.$$$reportNull$$$0(20);
        }
        return (id2 = PluginManagerCore.getPluginOrPlatformByClassName(className)) != null && !CORE_ID.equals((Object)id2) ? id2 : null;
    }

    @Nullable
    public static PluginId getPluginOrPlatformByClassName(@NotNull String className) {
        PluginDescriptor result2;
        if (className == null) {
            PluginManagerCore.$$$reportNull$$$0(21);
        }
        return (result2 = PluginManagerCore.getPluginDescriptorOrPlatformByClassName(className)) == null ? null : result2.getPluginId();
    }

    @ApiStatus.Internal
    @Nullable
    public static PluginDescriptor getPluginDescriptorOrPlatformByClassName(@NotNull @NonNls String className) {
        PluginSet pluginSet;
        if (className == null) {
            PluginManagerCore.$$$reportNull$$$0(22);
        }
        if ((pluginSet = PluginManagerCore.pluginSet) == null || className.startsWith("java.") || className.startsWith("javax.") || className.startsWith("kotlin.") || className.startsWith("groovy.") || !className.contains(".")) {
            return null;
        }
        IdeaPluginDescriptorImpl result2 = null;
        for (IdeaPluginDescriptorImpl o : pluginSet.enabledPlugins) {
            ClassLoader classLoader = o.getPluginClassLoader();
            if (!PluginManagerCore.hasLoadedClass(className, classLoader)) continue;
            result2 = o;
            break;
        }
        if (result2 == null) {
            return null;
        }
        if (!CORE_ID.equals((Object)result2.getPluginId()) || className.startsWith("com.jetbrains.") || className.startsWith("org.jetbrains.") || className.startsWith("com.intellij.") || className.startsWith("org.intellij.") || className.startsWith("com.android.") || className.startsWith("git4idea.") || className.startsWith("org.angularjs.")) {
            return result2;
        }
        String root = null;
        for (IdeaPluginDescriptorImpl o : pluginSet.enabledPlugins) {
            if (!o.isUseIdeaClassLoader) continue;
            if (root == null && (root = PathManager.getResourceRoot((ClassLoader)result2.getPluginClassLoader(), (String)(className.replace('.', '/') + ".class"))) == null) {
                return null;
            }
            Path path2 = o.getPluginPath();
            if (!root.startsWith(FileUtilRt.toSystemIndependentName((String)path2.toString()))) continue;
            return o;
        }
        return null;
    }

    public static boolean isDevelopedByJetBrains(@NotNull PluginDescriptor plugin2) {
        if (plugin2 == null) {
            PluginManagerCore.$$$reportNull$$$0(23);
        }
        return PluginManagerCore.isDevelopedByJetBrains(plugin2.getVendor()) || PluginManagerCore.isDevelopedByJetBrains(plugin2.getOrganization());
    }

    public static boolean isDevelopedByJetBrains(@Nullable String vendorString) {
        if (vendorString == null) {
            return false;
        }
        if (PluginManagerCore.isVendorJetBrains(vendorString)) {
            return true;
        }
        for (String vendor : StringUtil.split((String)vendorString, (String)",")) {
            String vendorItem = vendor.trim();
            if (!PluginManagerCore.isVendorJetBrains(vendorItem)) continue;
            return true;
        }
        return false;
    }

    public static boolean isVendorJetBrains(@NotNull String vendorItem) {
        if (vendorItem == null) {
            PluginManagerCore.$$$reportNull$$$0(24);
        }
        return VENDOR_JETBRAINS.equals(vendorItem) || VENDOR_JETBRAINS_SRO.equals(vendorItem);
    }

    private static Path getUpdatedBrokenPluginFile() {
        return Paths.get(PathManager.getConfigPath(), new String[0]).resolve("updatedBrokenPlugins.db");
    }

    private static boolean hasLoadedClass(@NotNull String className, @NotNull ClassLoader loader) {
        if (className == null) {
            PluginManagerCore.$$$reportNull$$$0(25);
        }
        if (loader == null) {
            PluginManagerCore.$$$reportNull$$$0(26);
        }
        if (loader instanceof UrlClassLoader) {
            return ((UrlClassLoader)loader).hasLoadedClass(className);
        }
        Class<?> aClass = loader.getClass();
        if (aClass.isAnonymousClass() || aClass.isMemberClass()) {
            aClass = aClass.getSuperclass();
        }
        try {
            return MethodHandles.publicLookup().findVirtual(aClass, "hasLoadedClass", HAS_LOADED_CLASS_METHOD_TYPE).invoke(loader, className);
        }
        catch (IllegalAccessError | IllegalAccessException | NoSuchMethodError throwable) {
        }
        catch (Throwable e) {
            PluginManagerCore.getLogger().error(e);
        }
        return false;
    }

    @Nullable
    static IdeaPluginDescriptorImpl getImplicitDependency(@NotNull IdeaPluginDescriptorImpl descriptor2, @NotNull Supplier<IdeaPluginDescriptorImpl> javaDepGetter) {
        if (descriptor2 == null) {
            PluginManagerCore.$$$reportNull$$$0(27);
        }
        if (javaDepGetter == null) {
            PluginManagerCore.$$$reportNull$$$0(28);
        }
        if (descriptor2.isBundled() || descriptor2.packagePrefix != null) {
            return null;
        }
        PluginId pluginId = descriptor2.getPluginId();
        if (CORE_ID.equals((Object)pluginId) || JAVA_PLUGIN_ID.equals((Object)pluginId)) {
            return null;
        }
        IdeaPluginDescriptorImpl javaDep2 = javaDepGetter.get();
        if (javaDep2 == null) {
            return null;
        }
        return PluginManagerCore.hasModuleDependencies(descriptor2) ? null : javaDep2;
    }

    static boolean hasModuleDependencies(@NotNull IdeaPluginDescriptorImpl descriptor2) {
        if (descriptor2 == null) {
            PluginManagerCore.$$$reportNull$$$0(29);
        }
        for (PluginDependency dependency : descriptor2.pluginDependencies) {
            PluginId dependencyPluginId = dependency.getPluginId();
            if (!JAVA_PLUGIN_ID.equals((Object)dependencyPluginId) && !JAVA_MODULE_ID.equals((Object)dependencyPluginId) && !PluginManagerCore.isModuleDependency(dependencyPluginId)) continue;
            return true;
        }
        return false;
    }

    public static synchronized void invalidatePlugins() {
        pluginSet = null;
        DisabledPluginsState.invalidate();
        ourShadowedBundledPlugins = null;
    }

    private static void logPlugins(@NotNull List<IdeaPluginDescriptorImpl> plugins2, @NotNull Collection<IdeaPluginDescriptorImpl> incompletePlugins) {
        if (plugins2 == null) {
            PluginManagerCore.$$$reportNull$$$0(30);
        }
        if (incompletePlugins == null) {
            PluginManagerCore.$$$reportNull$$$0(31);
        }
        StringBuilder bundled = new StringBuilder();
        StringBuilder disabled = new StringBuilder();
        StringBuilder custom = new StringBuilder();
        HashSet<PluginId> disabledPlugins = new HashSet<PluginId>();
        for (IdeaPluginDescriptor ideaPluginDescriptor : plugins2) {
            StringBuilder target2;
            PluginId pluginId = ideaPluginDescriptor.getPluginId();
            if (!ideaPluginDescriptor.isEnabled()) {
                if (!PluginManagerCore.isDisabled(pluginId)) continue;
                disabledPlugins.add(pluginId);
                target2 = disabled;
            } else if (ideaPluginDescriptor.isBundled() || SPECIAL_IDEA_PLUGIN_ID.equals((Object)pluginId)) {
                StringBuilder target22 = bundled;
            } else {
                target2 = custom;
            }
            PluginManagerCore.appendPlugin(ideaPluginDescriptor, target2);
        }
        for (IdeaPluginDescriptorImpl ideaPluginDescriptorImpl : incompletePlugins) {
            PluginId pluginId = ideaPluginDescriptorImpl.getPluginId();
            if (!PluginManagerCore.isDisabled(pluginId) || disabledPlugins.contains(pluginId)) continue;
            PluginManagerCore.appendPlugin(ideaPluginDescriptorImpl, disabled);
        }
        Logger logger = PluginManagerCore.getLogger();
        logger.info("Loaded bundled plugins: " + bundled);
        if (custom.length() > 0) {
            logger.info("Loaded custom plugins: " + custom);
        }
        if (disabled.length() > 0) {
            logger.info("Disabled plugins: " + disabled);
        }
    }

    private static void appendPlugin(IdeaPluginDescriptor descriptor2, StringBuilder target2) {
        if (target2.length() > 0) {
            target2.append(", ");
        }
        target2.append(descriptor2.getName());
        String version2 = descriptor2.getVersion();
        if (version2 != null) {
            target2.append(" (").append(version2).append(')');
        }
    }

    public static boolean isRunningFromSources() {
        Boolean result2 = isRunningFromSources;
        if (result2 == null) {
            isRunningFromSources = result2 = Boolean.valueOf(Files.isDirectory(Paths.get(PathManager.getHomePath(), ".idea"), new LinkOption[0]));
        }
        return result2;
    }

    @NotNull
    private static List<Supplier<HtmlChunk>> preparePluginsError(@NotNull List<Supplier<@NlsContexts.DetailedDescription String>> globalErrorsSuppliers) {
        if (globalErrorsSuppliers == null) {
            PluginManagerCore.$$$reportNull$$$0(32);
        }
        if (pluginLoadingErrors.isEmpty() && globalErrorsSuppliers.isEmpty()) {
            return new ArrayList<Supplier<HtmlChunk>>();
        }
        List<@NlsContexts.DetailedDescription T> globalErrors = globalErrorsSuppliers.stream().map(Supplier::get).collect(Collectors.toList());
        List loadingErrors = pluginLoadingErrors.entrySet().stream().sorted(Map.Entry.comparingByKey()).map(Map.Entry::getValue).collect(Collectors.toList());
        String logMessage = "Problems found loading plugins:\n  " + Stream.concat(globalErrors.stream(), loadingErrors.stream().map(PluginLoadingError::getInternalMessage)).collect(Collectors.joining("\n  "));
        if (isUnitTestMode || !GraphicsEnvironment.isHeadless()) {
            PluginManagerCore.getLogger().warn(logMessage);
            List<Supplier<HtmlChunk>> list2 = Stream.concat(globalErrors.stream(), loadingErrors.stream().filter(PluginLoadingError::isNotifyUser).map(PluginLoadingError::getDetailedMessage)).map(text2 -> () -> HtmlChunk.text((String)text2)).collect(Collectors.toList());
            if (list2 == null) {
                PluginManagerCore.$$$reportNull$$$0(33);
            }
            return list2;
        }
        PluginManagerCore.getLogger().error(logMessage);
        return new ArrayList<Supplier<HtmlChunk>>();
    }

    @Nullable
    @NlsContexts.Label
    public static String getShortLoadingErrorMessage(@NotNull IdeaPluginDescriptor pluginDescriptor) {
        PluginLoadingError error2;
        if (pluginDescriptor == null) {
            PluginManagerCore.$$$reportNull$$$0(34);
        }
        return (error2 = pluginLoadingErrors.get(pluginDescriptor.getPluginId())) == null ? null : error2.getShortMessage();
    }

    @Nullable
    public static PluginId getFirstDisabledDependency(@NotNull IdeaPluginDescriptor pluginDescriptor) {
        PluginLoadingError error2;
        if (pluginDescriptor == null) {
            PluginManagerCore.$$$reportNull$$$0(35);
        }
        return (error2 = pluginLoadingErrors.get(pluginDescriptor.getPluginId())) == null ? null : error2.disabledDependency;
    }

    private static void checkPluginCycles(@NotNull List<IdeaPluginDescriptorImpl> descriptors2, @NotNull PluginSet pluginSet, @NotNull List<Supplier<@Nls String>> errors, @NotNull Map<PluginId, IdeaPluginDescriptorImpl> idMap) {
        CachingSemiGraph<PluginId> graph2;
        DFSTBuilder builder2;
        if (descriptors2 == null) {
            PluginManagerCore.$$$reportNull$$$0(36);
        }
        if (pluginSet == null) {
            PluginManagerCore.$$$reportNull$$$0(37);
        }
        if (errors == null) {
            PluginManagerCore.$$$reportNull$$$0(38);
        }
        if (idMap == null) {
            PluginManagerCore.$$$reportNull$$$0(39);
        }
        if ((builder2 = new DFSTBuilder(graph2 = CachingSemiGraph.Companion.createPluginIdGraph(descriptors2, pluginSet, true))).isAcyclic()) {
            return;
        }
        for (Collection component2 : builder2.getComponents()) {
            if (component2.size() < 2) continue;
            for (PluginId id3 : component2) {
                IdeaPluginDescriptorImpl plugin2 = pluginSet.findEnabledPlugin(id3);
                if (plugin2 == null) continue;
                plugin2.setEnabled(false);
            }
            String pluginsString = component2.stream().map(it -> "'" + ((IdeaPluginDescriptorImpl)idMap.get(it)).getName() + "'").collect(Collectors.joining(", "));
            errors.add(PluginManagerCore.message("plugin.loading.error.plugins.cannot.be.loaded.because.they.form.a.dependency.cycle", pluginsString));
            StringBuilder detailedMessage = new StringBuilder();
            Function<PluginId, String> pluginToString = id2 -> {
                IdeaPluginDescriptorImpl descriptor2 = (IdeaPluginDescriptorImpl)idMap.get(id2);
                return "id = " + id2.getIdString() + " (" + descriptor2.getName() + ")";
            };
            detailedMessage.append("Detected plugin dependencies cycle details (only related dependencies are included):\n");
            component2.stream().map(p -> new Pair(p, (Object)((String)pluginToString.apply((PluginId)p)))).sorted(Comparator.comparing(p -> (String)p.second, String.CASE_INSENSITIVE_ORDER)).forEach(p -> {
                detailedMessage.append("  ").append((String)p.getSecond()).append(" depends on:\n");
                graph2.getInStream((PluginId)p.first).filter(component2::contains).map(pluginToString).sorted(String.CASE_INSENSITIVE_ORDER).forEach(dep -> detailedMessage.append("    ").append((String)dep).append("\n"));
            });
            PluginManagerCore.getLogger().info(detailedMessage.toString());
        }
    }

    @NotNull
    private static List<Supplier<HtmlChunk>> prepareActions(@NotNull Set<PluginId> disabledIds, @NotNull Set<PluginId> disabledRequiredIds, @NotNull Map<PluginId, ? extends IdeaPluginDescriptor> idMap) {
        if (disabledIds == null) {
            PluginManagerCore.$$$reportNull$$$0(40);
        }
        if (disabledRequiredIds == null) {
            PluginManagerCore.$$$reportNull$$$0(41);
        }
        if (idMap == null) {
            PluginManagerCore.$$$reportNull$$$0(42);
        }
        ArrayList<Supplier<HtmlChunk>> actions2 = new ArrayList<Supplier<HtmlChunk>>();
        if (!disabledIds.isEmpty()) {
            String nameToDisable = PluginManagerCore.getFirstPluginName(disabledIds, idMap, PluginId::getIdString);
            actions2.add(() -> {
                String text2 = nameToDisable != null ? CoreBundle.message((String)"link.text.disable.plugin", (Object[])new Object[]{nameToDisable}) : CoreBundle.message((String)"link.text.disable.not.loaded.plugins", (Object[])new Object[0]);
                return HtmlChunk.link((String)DISABLE, (String)text2);
            });
            if (!disabledRequiredIds.isEmpty()) {
                String nameToEnable = PluginManagerCore.getFirstPluginName(disabledRequiredIds, idMap, __ -> null);
                actions2.add(() -> {
                    String text2 = nameToEnable != null ? CoreBundle.message((String)"link.text.enable.plugin", (Object[])new Object[]{nameToEnable}) : CoreBundle.message((String)"link.text.enable.all.necessary.plugins", (Object[])new Object[0]);
                    return HtmlChunk.link((String)ENABLE, (String)text2);
                });
            }
            actions2.add(() -> HtmlChunk.link((String)EDIT, (String)CoreBundle.message((String)"link.text.open.plugin.manager", (Object[])new Object[0])));
        }
        ArrayList<Supplier<HtmlChunk>> arrayList = actions2;
        if (arrayList == null) {
            PluginManagerCore.$$$reportNull$$$0(43);
        }
        return arrayList;
    }

    @Nullable
    @NlsSafe
    private static String getFirstPluginName(@NotNull Set<PluginId> pluginIds2, @NotNull Map<PluginId, ? extends IdeaPluginDescriptor> idMap, @NotNull Function<? super PluginId, String> defaultName) {
        int size;
        if (pluginIds2 == null) {
            PluginManagerCore.$$$reportNull$$$0(44);
        }
        if (idMap == null) {
            PluginManagerCore.$$$reportNull$$$0(45);
        }
        if (defaultName == null) {
            PluginManagerCore.$$$reportNull$$$0(46);
        }
        if ((size = pluginIds2.size()) == 0) {
            throw new IllegalArgumentException("Plugins set should not be empty");
        }
        if (size == 1) {
            PluginId pluginId = pluginIds2.iterator().next();
            IdeaPluginDescriptor descriptor2 = idMap.get(pluginId);
            return descriptor2 != null ? descriptor2.getName() : defaultName.apply((PluginId)pluginId);
        }
        return null;
    }

    @ApiStatus.Internal
    static synchronized boolean onEnable(boolean enabled) {
        boolean applied;
        Set<PluginId> pluginIds2 = enabled ? ourPluginsToEnable : ourPluginsToDisable;
        ourPluginsToEnable = null;
        ourPluginsToDisable = null;
        boolean bl = applied = pluginIds2 != null;
        if (applied) {
            Map<PluginId, IdeaPluginDescriptorImpl> pluginIdMap = PluginManagerCore.buildPluginIdMap();
            for (PluginId pluginId : pluginIds2) {
                IdeaPluginDescriptor descriptor2 = pluginIdMap.get(pluginId);
                if (descriptor2 == null) continue;
                descriptor2.setEnabled(enabled);
            }
            DisabledPluginsState.setEnabledState(pluginIds2, enabled);
        }
        return applied;
    }

    public static void scheduleDescriptorLoading() {
        PluginManagerCore.getOrScheduleLoading();
    }

    @NotNull
    private static synchronized CompletableFuture<DescriptorListLoadingContext> getOrScheduleLoading() {
        CompletableFuture<DescriptorListLoadingContext> future2 = descriptorListFuture;
        if (future2 != null) {
            CompletableFuture<DescriptorListLoadingContext> completableFuture = future2;
            if (completableFuture == null) {
                PluginManagerCore.$$$reportNull$$$0(47);
            }
            return completableFuture;
        }
        descriptorListFuture = future2 = CompletableFuture.supplyAsync(() -> {
            Activity activity = StartUpMeasurer.startActivity((String)"plugin descriptor loading", (ActivityCategory)ActivityCategory.DEFAULT);
            DescriptorListLoadingContext context2 = PluginDescriptorLoader.loadDescriptors(isUnitTestMode, PluginManagerCore.isRunningFromSources());
            activity.end();
            return context2;
        }, ForkJoinPool.commonPool());
        CompletableFuture<DescriptorListLoadingContext> completableFuture = future2;
        if (completableFuture == null) {
            PluginManagerCore.$$$reportNull$$$0(48);
        }
        return completableFuture;
    }

    @ApiStatus.Internal
    @NotNull
    public static CompletableFuture<List<IdeaPluginDescriptorImpl>> getEnabledPluginRawList() {
        CompletionStage completionStage = PluginManagerCore.getOrScheduleLoading().thenApply(it -> it.result.getEnabledPlugins());
        if (completionStage == null) {
            PluginManagerCore.$$$reportNull$$$0(49);
        }
        return completionStage;
    }

    @ApiStatus.Internal
    @NotNull
    public static CompletableFuture<List<IdeaPluginDescriptorImpl>> initPlugins(@NotNull ClassLoader coreClassLoader) {
        CompletableFuture<DescriptorListLoadingContext> future2;
        if (coreClassLoader == null) {
            PluginManagerCore.$$$reportNull$$$0(50);
        }
        if ((future2 = descriptorListFuture) == null) {
            throw new IllegalStateException("Call scheduleDescriptorLoading() first");
        }
        CompletionStage completionStage = future2.thenApply(context2 -> PluginManagerCore.loadAndInitializePlugins((DescriptorListLoadingContext)context2, (ClassLoader)coreClassLoader).enabledPlugins);
        if (completionStage == null) {
            PluginManagerCore.$$$reportNull$$$0(51);
        }
        return completionStage;
    }

    @NotNull
    public static BuildNumber getBuildNumber() {
        BuildNumber result2 = ourBuildNumber;
        if (result2 == null) {
            result2 = BuildNumber.fromPluginsCompatibleBuild();
            if (result2 == null) {
                if (isUnitTestMode) {
                    result2 = BuildNumber.currentVersion();
                } else {
                    try {
                        result2 = ApplicationInfoImpl.getShadowInstance().getApiVersionAsNumber();
                    }
                    catch (RuntimeException ignore) {
                        result2 = BuildNumber.currentVersion();
                    }
                }
            }
            ourBuildNumber = result2;
        }
        BuildNumber buildNumber = result2;
        if (buildNumber == null) {
            PluginManagerCore.$$$reportNull$$$0(52);
        }
        return buildNumber;
    }

    private static void disableIncompatiblePlugins(@NotNull List<IdeaPluginDescriptorImpl> descriptors2, @NotNull Map<PluginId, IdeaPluginDescriptorImpl> idMap, @NotNull Map<PluginId, PluginLoadingError> errors) {
        boolean isNonBundledPluginDisabled;
        if (descriptors2 == null) {
            PluginManagerCore.$$$reportNull$$$0(53);
        }
        if (idMap == null) {
            PluginManagerCore.$$$reportNull$$$0(54);
        }
        if (errors == null) {
            PluginManagerCore.$$$reportNull$$$0(55);
        }
        if (isNonBundledPluginDisabled = ourDisableNonBundledPlugins) {
            PluginManagerCore.getLogger().info("Running with disableThirdPartyPlugins argument, third-party plugins will be disabled");
        }
        String selectedIds = System.getProperty("idea.load.plugins.id");
        String selectedCategory = System.getProperty("idea.load.plugins.category");
        IdeaPluginDescriptorImpl coreDescriptor = idMap.get(CORE_ID);
        LinkedHashSet<IdeaPluginDescriptorImpl> explicitlyEnabled = null;
        if (selectedIds != null) {
            HashSet set2 = new HashSet();
            for (String it : selectedIds.split(",")) {
                set2.add(PluginId.getId((String)it));
            }
            set2.addAll(ApplicationInfoImpl.getShadowInstance().getEssentialPluginsIds());
            explicitlyEnabled = new LinkedHashSet(set2.size());
            Iterator iterator2 = set2.iterator();
            while (iterator2.hasNext()) {
                PluginId id3 = (PluginId)iterator2.next();
                IdeaPluginDescriptorImpl descriptor2 = idMap.get(id3);
                if (descriptor2 == null) continue;
                explicitlyEnabled.add(descriptor2);
            }
        } else if (selectedCategory != null) {
            explicitlyEnabled = new LinkedHashSet<IdeaPluginDescriptorImpl>();
            for (IdeaPluginDescriptorImpl descriptor3 : descriptors2) {
                if (!selectedCategory.equals(descriptor3.getCategory())) continue;
                explicitlyEnabled.add(descriptor3);
            }
        }
        if (explicitlyEnabled != null) {
            LinkedHashSet<IdeaPluginDescriptorImpl> finalExplicitlyEnabled = explicitlyEnabled;
            HashSet<IdeaPluginDescriptor> depProcessed = new HashSet<IdeaPluginDescriptor>();
            for (IdeaPluginDescriptorImpl descriptor4 : new ArrayList(explicitlyEnabled)) {
                PluginManagerCore.processAllDependencies(descriptor4, idMap, depProcessed, (id2, dependency) -> {
                    finalExplicitlyEnabled.add((IdeaPluginDescriptorImpl)dependency);
                    return FileVisitResult.CONTINUE;
                });
            }
        }
        Map<PluginId, Set<String>> brokenPluginVersions = PluginManagerCore.getBrokenPluginVersions();
        boolean shouldLoadPlugins = Boolean.parseBoolean(System.getProperty("idea.load.plugins", "true"));
        for (IdeaPluginDescriptorImpl descriptor5 : descriptors2) {
            if (descriptor5 == coreDescriptor) continue;
            Set<String> set3 = brokenPluginVersions.get(descriptor5.getPluginId());
            if (set3 != null && set3.contains(descriptor5.getVersion())) {
                descriptor5.setEnabled(false);
                errors.put(descriptor5.getPluginId(), new PluginLoadingError(descriptor5, PluginManagerCore.message("plugin.loading.error.long.marked.as.broken", descriptor5.getName(), descriptor5.getVersion()), PluginManagerCore.message("plugin.loading.error.short.marked.as.broken", new Object[0])));
                continue;
            }
            if (explicitlyEnabled != null) {
                if (explicitlyEnabled.contains(descriptor5)) continue;
                descriptor5.setEnabled(false);
                PluginManagerCore.getLogger().info("Plugin '" + descriptor5.getName() + "' " + (selectedIds != null ? "is not in 'idea.load.plugins.id' system property" : "category doesn't match 'idea.load.plugins.category' system property"));
                continue;
            }
            if (!shouldLoadPlugins) {
                descriptor5.setEnabled(false);
                errors.put(descriptor5.getPluginId(), new PluginLoadingError(descriptor5, PluginManagerCore.message("plugin.loading.error.long.plugin.loading.disabled", descriptor5.getName()), PluginManagerCore.message("plugin.loading.error.short.plugin.loading.disabled", new Object[0])));
                continue;
            }
            if (!isNonBundledPluginDisabled || descriptor5.isBundled()) continue;
            descriptor5.setEnabled(false);
            errors.put(descriptor5.getPluginId(), new PluginLoadingError(descriptor5, PluginManagerCore.message("plugin.loading.error.long.custom.plugin.loading.disabled", descriptor5.getName()), PluginManagerCore.message("plugin.loading.error.short.custom.plugin.loading.disabled", new Object[0]), false, null));
        }
    }

    public static boolean isCompatible(@NotNull IdeaPluginDescriptor descriptor2) {
        if (descriptor2 == null) {
            PluginManagerCore.$$$reportNull$$$0(56);
        }
        return !PluginManagerCore.isIncompatible(descriptor2);
    }

    public static boolean isCompatible(@NotNull IdeaPluginDescriptor descriptor2, @Nullable BuildNumber buildNumber) {
        if (descriptor2 == null) {
            PluginManagerCore.$$$reportNull$$$0(57);
        }
        return !PluginManagerCore.isIncompatible(descriptor2, buildNumber);
    }

    public static boolean isIncompatible(@NotNull IdeaPluginDescriptor descriptor2) {
        if (descriptor2 == null) {
            PluginManagerCore.$$$reportNull$$$0(58);
        }
        return PluginManagerCore.isIncompatible(descriptor2, PluginManagerCore.getBuildNumber());
    }

    public static boolean isIncompatible(@NotNull IdeaPluginDescriptor descriptor2, @Nullable BuildNumber buildNumber) {
        if (descriptor2 == null) {
            PluginManagerCore.$$$reportNull$$$0(59);
        }
        if (buildNumber == null) {
            buildNumber = PluginManagerCore.getBuildNumber();
        }
        return PluginManagerCore.checkBuildNumberCompatibility(descriptor2, buildNumber) != null;
    }

    @Nullable
    public static PluginLoadingError checkBuildNumberCompatibility(@NotNull IdeaPluginDescriptor descriptor2, @NotNull BuildNumber ideBuildNumber) {
        if (descriptor2 == null) {
            PluginManagerCore.$$$reportNull$$$0(60);
        }
        if (ideBuildNumber == null) {
            PluginManagerCore.$$$reportNull$$$0(61);
        }
        String sinceBuild = descriptor2.getSinceBuild();
        String untilBuild = descriptor2.getUntilBuild();
        try {
            BuildNumber untilBuildNumber;
            BuildNumber sinceBuildNumber;
            BuildNumber buildNumber = sinceBuildNumber = sinceBuild == null || sinceBuild.length() == 0 ? null : BuildNumber.fromString((String)sinceBuild, (String)descriptor2.getName(), null);
            if (sinceBuildNumber != null && sinceBuildNumber.compareTo(ideBuildNumber) > 0) {
                return new PluginLoadingError(descriptor2, PluginManagerCore.message("plugin.loading.error.long.incompatible.since.build", descriptor2.getName(), descriptor2.getVersion(), sinceBuild, ideBuildNumber), PluginManagerCore.message("plugin.loading.error.short.incompatible.since.build", sinceBuild));
            }
            BuildNumber buildNumber2 = untilBuildNumber = untilBuild == null || untilBuild.length() == 0 ? null : BuildNumber.fromString((String)untilBuild, (String)descriptor2.getName(), null);
            if (untilBuildNumber != null && untilBuildNumber.compareTo(ideBuildNumber) < 0) {
                return new PluginLoadingError(descriptor2, PluginManagerCore.message("plugin.loading.error.long.incompatible.until.build", descriptor2.getName(), descriptor2.getVersion(), untilBuild, ideBuildNumber), PluginManagerCore.message("plugin.loading.error.short.incompatible.until.build", untilBuild));
            }
            return null;
        }
        catch (Exception e) {
            PluginManagerCore.getLogger().error((Throwable)e);
            return new PluginLoadingError(descriptor2, PluginManagerCore.message("plugin.loading.error.long.failed.to.load.requirements.for.ide.version", descriptor2.getName()), PluginManagerCore.message("plugin.loading.error.short.failed.to.load.requirements.for.ide.version", new Object[0]));
        }
    }

    private static void checkEssentialPluginsAreAvailable(@NotNull Map<PluginId, IdeaPluginDescriptorImpl> idMap) {
        if (idMap == null) {
            PluginManagerCore.$$$reportNull$$$0(62);
        }
        List<PluginId> required = ApplicationInfoImpl.getShadowInstance().getEssentialPluginsIds();
        ArrayList<String> missing = null;
        for (PluginId id2 : required) {
            IdeaPluginDescriptorImpl descriptor2 = idMap.get(id2);
            if (descriptor2 != null && descriptor2.isEnabled()) continue;
            if (missing == null) {
                missing = new ArrayList<String>();
            }
            missing.add(id2.getIdString());
        }
        if (missing != null) {
            throw new EssentialPluginMissingException(missing);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    static PluginManagerState initializePlugins(@NotNull DescriptorListLoadingContext context2, @NotNull ClassLoader coreLoader, boolean checkEssentialPlugins) {
        if (context2 == null) {
            PluginManagerCore.$$$reportNull$$$0(63);
        }
        if (coreLoader == null) {
            PluginManagerCore.$$$reportNull$$$0(64);
        }
        PluginLoadingResult loadingResult2 = context2.result;
        HashMap<PluginId, PluginLoadingError> pluginErrorsById = new HashMap<PluginId, PluginLoadingError>(loadingResult2.getPluginErrors$intellij_platform_core_impl());
        @NotNull List<Supplier<String>> globalErrors = loadingResult2.getGlobalErrors();
        if (loadingResult2.duplicateModuleMap != null) {
            for (Map.Entry<PluginId, List<IdeaPluginDescriptorImpl>> entry2 : loadingResult2.duplicateModuleMap.entrySet()) {
                globalErrors.add(() -> CoreBundle.message((String)"plugin.loading.error.module.declared.by.multiple.plugins", (Object[])new Object[]{entry2.getKey(), ((List)entry2.getValue()).stream().map(IdeaPluginDescriptorImpl::toString).collect(Collectors.joining("\n  "))}));
            }
        }
        ConcurrentHashMap<PluginId, IdeaPluginDescriptorImpl> idMap = loadingResult2.idMap;
        if (checkEssentialPlugins && !idMap.containsKey(CORE_ID)) {
            throw new EssentialPluginMissingException(Collections.singletonList(CORE_ID + " (platform prefix: " + System.getProperty("idea.platform.prefix") + ")"));
        }
        List<IdeaPluginDescriptorImpl> descriptors2 = loadingResult2.getEnabledPlugins();
        PluginSet rawPluginSet = PluginSet.Companion.createRawPluginSet(descriptors2);
        PluginManagerCore.disableIncompatiblePlugins(descriptors2, idMap, pluginErrorsById);
        PluginManagerCore.checkPluginCycles(descriptors2, rawPluginSet, globalErrors, idMap);
        HashMap<PluginId, String> disabledIds = new HashMap<PluginId, String>();
        List<IdeaPluginDescriptorImpl> sortedRequired = rawPluginSet.sortTopologically(descriptors2, false);
        HashMap<PluginId, IdeaPluginDescriptorImpl> enabledPluginIds = new HashMap<PluginId, IdeaPluginDescriptorImpl>();
        HashMap<String, PluginContentDescriptor.ModuleItem> enabledModuleV2Ids = new HashMap<String, PluginContentDescriptor.ModuleItem>();
        HashSet<PluginId> disabledRequiredIds = new HashSet<PluginId>();
        Logger logger = PluginManagerCore.getLogger();
        boolean isDebugLogEnabled = logger.isDebugEnabled() || !System.getProperty("plugin.classloader.debug", "").isEmpty() || isUnitTestMode;
        for (IdeaPluginDescriptorImpl descriptor2 : sortedRequired) {
            boolean wasEnabled = descriptor2.isEnabled();
            if (wasEnabled && PluginManagerCore.computePluginEnabled(descriptor2, enabledPluginIds, enabledModuleV2Ids, idMap, disabledRequiredIds, context2.disabledPlugins, pluginErrorsById)) {
                PluginSet.Companion.addWithV1Modules(enabledPluginIds, descriptor2);
                if (!CORE_ID.equals((Object)descriptor2.getPluginId())) {
                    PluginSet.Companion.checkModules(descriptor2, enabledPluginIds, enabledModuleV2Ids, isDebugLogEnabled, logger);
                    continue;
                }
                for (PluginContentDescriptor.ModuleItem item : descriptor2.content.modules) {
                    enabledModuleV2Ids.put(item.name, item);
                }
                continue;
            }
            descriptor2.setEnabled(false);
            if (!wasEnabled) continue;
            disabledIds.put(descriptor2.getPluginId(), descriptor2.getName());
        }
        List<Supplier<HtmlChunk>> actions2 = PluginManagerCore.prepareActions(disabledIds.keySet(), disabledRequiredIds, idMap);
        pluginLoadingErrors = pluginErrorsById;
        List<Supplier<HtmlChunk>> errorsList = PluginManagerCore.preparePluginsError(globalErrors);
        if (!errorsList.isEmpty()) {
            List<Supplier<? extends HtmlChunk>> wasEnabled = pluginErrors;
            synchronized (wasEnabled) {
                pluginErrors.addAll(errorsList);
                pluginErrors.addAll(actions2);
            }
        }
        List allPlugins = rawPluginSet.sortTopologically(sortedRequired, true);
        List<IdeaPluginDescriptorImpl> enabledPlugins = PluginSet.Companion.getOnlyEnabledPlugins(allPlugins);
        Java11Shim java11Shim = Java11Shim.INSTANCE;
        if (!context2.result.incompletePlugins.isEmpty()) {
            ArrayList<IdeaPluginDescriptorImpl> result2 = new ArrayList<IdeaPluginDescriptorImpl>(allPlugins.size() + context2.result.incompletePlugins.size());
            result2.addAll(allPlugins);
            result2.addAll(context2.result.incompletePlugins.values());
            allPlugins = java11Shim.copyOf(result2);
        }
        PluginSet pluginSet = new PluginSet(allPlugins, java11Shim.copyOf(enabledPlugins), java11Shim.copyOf(enabledModuleV2Ids), java11Shim.copyOf(enabledPluginIds));
        new ClassLoaderConfigurator(pluginSet, coreLoader).configureAll();
        if (checkEssentialPlugins) {
            PluginManagerCore.checkEssentialPluginsAreAvailable(idMap);
        }
        return new PluginManagerState(pluginSet, disabledRequiredIds, java11Shim.copyOf(disabledIds.keySet()));
    }

    @ApiStatus.Internal
    @NotNull
    public static Map<PluginId, IdeaPluginDescriptorImpl> buildPluginIdMap(@NotNull List<IdeaPluginDescriptorImpl> descriptors2) {
        if (descriptors2 == null) {
            PluginManagerCore.$$$reportNull$$$0(65);
        }
        HashMap<PluginId, IdeaPluginDescriptorImpl> idMap = new HashMap<PluginId, IdeaPluginDescriptorImpl>(descriptors2.size());
        Map<PluginId, List<IdeaPluginDescriptorImpl>> duplicateMap = null;
        for (IdeaPluginDescriptorImpl descriptor2 : descriptors2) {
            Map<PluginId, List<IdeaPluginDescriptorImpl>> newDuplicateMap = PluginManagerCore.checkAndPut(descriptor2, descriptor2.getPluginId(), idMap, duplicateMap);
            if (newDuplicateMap != null) {
                duplicateMap = newDuplicateMap;
                continue;
            }
            for (PluginId module : descriptor2.modules) {
                newDuplicateMap = PluginManagerCore.checkAndPut(descriptor2, module, idMap, duplicateMap);
                if (newDuplicateMap == null) continue;
                duplicateMap = newDuplicateMap;
            }
        }
        HashMap<PluginId, IdeaPluginDescriptorImpl> hashMap = idMap;
        if (hashMap == null) {
            PluginManagerCore.$$$reportNull$$$0(66);
        }
        return hashMap;
    }

    @Nullable
    private static Map<PluginId, List<IdeaPluginDescriptorImpl>> checkAndPut(@NotNull IdeaPluginDescriptorImpl descriptor2, @NotNull PluginId id2, @NotNull Map<PluginId, IdeaPluginDescriptorImpl> idMap, @Nullable Map<PluginId, List<IdeaPluginDescriptorImpl>> duplicateMap) {
        List<IdeaPluginDescriptorImpl> duplicates;
        if (descriptor2 == null) {
            PluginManagerCore.$$$reportNull$$$0(67);
        }
        if (id2 == null) {
            PluginManagerCore.$$$reportNull$$$0(68);
        }
        if (idMap == null) {
            PluginManagerCore.$$$reportNull$$$0(69);
        }
        if (duplicateMap != null && (duplicates = duplicateMap.get(id2)) != null) {
            duplicates.add(descriptor2);
            return duplicateMap;
        }
        IdeaPluginDescriptorImpl existingDescriptor = idMap.put(id2, descriptor2);
        if (existingDescriptor == null) {
            return null;
        }
        idMap.remove(id2);
        if (duplicateMap == null) {
            duplicateMap = new LinkedHashMap<PluginId, List<IdeaPluginDescriptorImpl>>();
        }
        ArrayList<IdeaPluginDescriptorImpl> list2 = new ArrayList<IdeaPluginDescriptorImpl>();
        list2.add(existingDescriptor);
        list2.add(descriptor2);
        duplicateMap.put(id2, list2);
        return duplicateMap;
    }

    private static boolean computePluginEnabled(@NotNull IdeaPluginDescriptorImpl descriptor2, @NotNull Map<PluginId, IdeaPluginDescriptorImpl> enabledPluginIds, @NotNull Map<String, PluginContentDescriptor.ModuleItem> enabledModuleV2Ids, @NotNull Map<PluginId, IdeaPluginDescriptorImpl> idMap, @NotNull Set<PluginId> disabledRequiredIds, @NotNull Set<PluginId> disabledPlugins, @NotNull Map<PluginId, PluginLoadingError> errors) {
        if (descriptor2 == null) {
            PluginManagerCore.$$$reportNull$$$0(70);
        }
        if (enabledPluginIds == null) {
            PluginManagerCore.$$$reportNull$$$0(71);
        }
        if (enabledModuleV2Ids == null) {
            PluginManagerCore.$$$reportNull$$$0(72);
        }
        if (idMap == null) {
            PluginManagerCore.$$$reportNull$$$0(73);
        }
        if (disabledRequiredIds == null) {
            PluginManagerCore.$$$reportNull$$$0(74);
        }
        if (disabledPlugins == null) {
            PluginManagerCore.$$$reportNull$$$0(75);
        }
        if (errors == null) {
            PluginManagerCore.$$$reportNull$$$0(76);
        }
        if (CORE_ID.equals((Object)descriptor2.getPluginId())) {
            return true;
        }
        boolean notifyUser = !descriptor2.isImplementationDetail();
        boolean result2 = true;
        for (PluginId pluginId : descriptor2.incompatibilities) {
            if (!enabledPluginIds.containsKey(pluginId) || disabledPlugins.contains(pluginId)) continue;
            result2 = false;
            String presentableName = pluginId.getIdString();
            errors.put(descriptor2.getPluginId(), new PluginLoadingError(descriptor2, PluginManagerCore.message("plugin.loading.error.long.ide.contains.conflicting.module", descriptor2.getName(), presentableName), PluginManagerCore.message("plugin.loading.error.short.ide.contains.conflicting.module", presentableName), notifyUser, null));
        }
        for (PluginDependency pluginDependency : descriptor2.pluginDependencies) {
            PluginId depId = pluginDependency.getPluginId();
            if (pluginDependency.isOptional() || enabledPluginIds.containsKey(depId)) continue;
            result2 = false;
            IdeaPluginDescriptor dep = idMap.get(depId);
            if (dep != null && disabledPlugins.contains(depId)) {
                disabledRequiredIds.add(dep.getPluginId());
            }
            PluginManagerCore.addCannotLoadError(descriptor2, errors, notifyUser, depId, dep);
        }
        for (ModuleDependenciesDescriptor.PluginReference pluginReference : descriptor2.dependencies.plugins) {
            if (enabledPluginIds.containsKey(pluginReference.id)) continue;
            result2 = false;
            IdeaPluginDescriptorImpl dep = idMap.get(pluginReference.id);
            if (dep != null && disabledPlugins.contains(pluginReference.id)) {
                disabledRequiredIds.add(dep.getPluginId());
            }
            PluginManagerCore.addCannotLoadError(descriptor2, errors, notifyUser, pluginReference.id, dep);
        }
        for (ModuleDependenciesDescriptor.ModuleReference moduleReference : descriptor2.dependencies.modules) {
            if (enabledModuleV2Ids.containsKey(moduleReference.name)) continue;
            result2 = false;
            errors.put(descriptor2.getPluginId(), new PluginLoadingError(descriptor2, PluginManagerCore.message("plugin.loading.error.long.depends.on.not.installed.plugin", descriptor2.getName(), moduleReference.name), PluginManagerCore.message("plugin.loading.error.short.depends.on.not.installed.plugin", moduleReference.name), notifyUser, null));
        }
        return result2;
    }

    private static void addCannotLoadError(@NotNull IdeaPluginDescriptorImpl descriptor2, @NotNull Map<PluginId, PluginLoadingError> errors, boolean notifyUser, PluginId depId, @Nullable IdeaPluginDescriptor dep) {
        String depName;
        if (descriptor2 == null) {
            PluginManagerCore.$$$reportNull$$$0(77);
        }
        if (errors == null) {
            PluginManagerCore.$$$reportNull$$$0(78);
        }
        String string = depName = dep == null ? null : dep.getName();
        if (depName == null) {
            @NlsSafe String depPresentableId = depId.getIdString();
            if (errors.containsKey(depId)) {
                PluginLoadingError depError = errors.get(depId);
                String depNameFromError = depError.getPlugin().getName();
                errors.put(descriptor2.getPluginId(), new PluginLoadingError(descriptor2, PluginManagerCore.message("plugin.loading.error.long.depends.on.failed.to.load.plugin", descriptor2.getName(), depNameFromError != null ? depNameFromError : depPresentableId), PluginManagerCore.message("plugin.loading.error.short.depends.on.failed.to.load.plugin", depPresentableId), notifyUser, null));
            } else {
                errors.put(descriptor2.getPluginId(), new PluginLoadingError(descriptor2, PluginManagerCore.message("plugin.loading.error.long.depends.on.not.installed.plugin", descriptor2.getName(), depPresentableId), PluginManagerCore.message("plugin.loading.error.short.depends.on.not.installed.plugin", depPresentableId), notifyUser, null));
            }
        } else {
            errors.put(descriptor2.getPluginId(), new PluginLoadingError(descriptor2, PluginManagerCore.message("plugin.loading.error.long.depends.on.disabled.plugin", descriptor2.getName(), depName), PluginManagerCore.message("plugin.loading.error.short.depends.on.disabled.plugin", depName), notifyUser, dep.getPluginId()));
        }
    }

    @NotNull
    @Nls
    private static Supplier<String> message(final @NotNull @PropertyKey(resourceBundle="messages.CoreBundle") @NotNull @PropertyKey(resourceBundle="messages.CoreBundle") String key, final Object ... params) {
        if (key == null) {
            PluginManagerCore.$$$reportNull$$$0(79);
        }
        if (params == null) {
            PluginManagerCore.$$$reportNull$$$0(80);
        }
        return new Supplier<String>(){

            @Override
            public String get() {
                return CoreBundle.message((String)key, (Object[])params);
            }
        };
    }

    @NotNull
    private static synchronized PluginSet loadAndInitializePlugins(@NotNull DescriptorListLoadingContext context2, @NotNull ClassLoader coreLoader) {
        PluginSet pluginSet;
        if (context2 == null) {
            PluginManagerCore.$$$reportNull$$$0(81);
        }
        if (coreLoader == null) {
            PluginManagerCore.$$$reportNull$$$0(82);
        }
        try {
            Activity activity = StartUpMeasurer.startActivity((String)"plugin initialization", (ActivityCategory)ActivityCategory.DEFAULT);
            PluginManagerState initResult = PluginManagerCore.initializePlugins(context2, coreLoader, !isUnitTestMode);
            PluginLoadingResult result2 = context2.result;
            ourPluginsToDisable = initResult.effectiveDisabledIds;
            ourPluginsToEnable = initResult.disabledRequiredIds;
            ourShadowedBundledPlugins = result2.shadowedBundledIds;
            activity.end();
            activity.setDescription("plugin count: " + initResult.pluginSet.enabledPlugins.size());
            PluginManagerCore.logPlugins(initResult.pluginSet.allPlugins, result2.incompletePlugins.values());
            PluginManagerCore.pluginSet = initResult.pluginSet;
            pluginSet = initResult.pluginSet;
        }
        catch (RuntimeException e) {
            PluginManagerCore.getLogger().error((Throwable)e);
            throw e;
        }
        if (pluginSet == null) {
            PluginManagerCore.$$$reportNull$$$0(83);
        }
        return pluginSet;
    }

    @NotNull
    public static Logger getLogger() {
        Logger logger = Logger.getInstance((String)"#com.intellij.ide.plugins.PluginManager");
        if (logger == null) {
            PluginManagerCore.$$$reportNull$$$0(84);
        }
        return logger;
    }

    @Contract(value="null -> null")
    @Nullable
    public static IdeaPluginDescriptor getPlugin(@Nullable PluginId id2) {
        return id2 != null ? PluginManagerCore.findPlugin(id2) : null;
    }

    @ApiStatus.Internal
    @Nullable
    public static IdeaPluginDescriptorImpl findPlugin(@NotNull PluginId id2) {
        PluginSet pluginSet;
        IdeaPluginDescriptorImpl result2;
        if (id2 == null) {
            PluginManagerCore.$$$reportNull$$$0(85);
        }
        if ((result2 = (pluginSet = PluginManagerCore.getPluginSet()).findEnabledPlugin(id2)) != null) {
            return result2;
        }
        for (IdeaPluginDescriptorImpl plugin2 : pluginSet.allPlugins) {
            if (!id2.equals((Object)plugin2.getPluginId())) continue;
            return plugin2;
        }
        return null;
    }

    @ApiStatus.Internal
    @Nullable
    public static IdeaPluginDescriptorImpl findPluginByModuleDependency(@NotNull PluginId id2) {
        if (id2 == null) {
            PluginManagerCore.$$$reportNull$$$0(86);
        }
        for (IdeaPluginDescriptorImpl descriptor2 : PluginManagerCore.getPluginSet().allPlugins) {
            if (!descriptor2.modules.contains(id2)) continue;
            return descriptor2;
        }
        return null;
    }

    public static boolean isPluginInstalled(@NotNull PluginId id2) {
        PluginSet pluginSet;
        if (id2 == null) {
            PluginManagerCore.$$$reportNull$$$0(87);
        }
        if ((pluginSet = PluginManagerCore.pluginSet) == null) {
            return false;
        }
        if (pluginSet.isPluginEnabled(id2)) {
            return true;
        }
        for (IdeaPluginDescriptor ideaPluginDescriptor : pluginSet.allPlugins) {
            if (!id2.equals((Object)ideaPluginDescriptor.getPluginId())) continue;
            return true;
        }
        return false;
    }

    @ApiStatus.Internal
    @NotNull
    public static Map<PluginId, IdeaPluginDescriptorImpl> buildPluginIdMap() {
        LoadingState.COMPONENTS_REGISTERED.checkOccurred();
        return PluginManagerCore.buildPluginIdMap(Objects.requireNonNull(PluginManagerCore.pluginSet).allPlugins);
    }

    @ApiStatus.Internal
    public static boolean processAllDependencies(@NotNull IdeaPluginDescriptorImpl rootDescriptor, @NotNull Map<PluginId, IdeaPluginDescriptorImpl> idToMap, @NotNull Function<? super IdeaPluginDescriptor, FileVisitResult> consumer) {
        if (rootDescriptor == null) {
            PluginManagerCore.$$$reportNull$$$0(88);
        }
        if (idToMap == null) {
            PluginManagerCore.$$$reportNull$$$0(89);
        }
        if (consumer == null) {
            PluginManagerCore.$$$reportNull$$$0(90);
        }
        return PluginManagerCore.processAllDependencies(rootDescriptor, idToMap, (PluginId id2, IdeaPluginDescriptorImpl descriptor2) -> descriptor2 != null ? (FileVisitResult)((Object)((Object)consumer.apply((IdeaPluginDescriptor)descriptor2))) : FileVisitResult.SKIP_SUBTREE);
    }

    @ApiStatus.Internal
    public static boolean processAllDependencies(@NotNull IdeaPluginDescriptorImpl rootDescriptor, @NotNull Map<PluginId, IdeaPluginDescriptorImpl> idToMap, @NotNull @NotNull BiFunction<@NotNull PluginId, @Nullable IdeaPluginDescriptorImpl, FileVisitResult> consumer) {
        if (rootDescriptor == null) {
            PluginManagerCore.$$$reportNull$$$0(91);
        }
        if (idToMap == null) {
            PluginManagerCore.$$$reportNull$$$0(92);
        }
        if (consumer == null) {
            PluginManagerCore.$$$reportNull$$$0(93);
        }
        return PluginManagerCore.processAllDependencies(rootDescriptor, idToMap, new HashSet<IdeaPluginDescriptor>(), consumer);
    }

    @ApiStatus.Internal
    private static boolean processAllDependencies(@NotNull IdeaPluginDescriptorImpl rootDescriptor, @NotNull Map<PluginId, IdeaPluginDescriptorImpl> idToMap, @NotNull Set<IdeaPluginDescriptor> depProcessed, @NotNull @NotNull BiFunction<@NotNull PluginId, @Nullable IdeaPluginDescriptorImpl, FileVisitResult> consumer) {
        if (rootDescriptor == null) {
            PluginManagerCore.$$$reportNull$$$0(94);
        }
        if (idToMap == null) {
            PluginManagerCore.$$$reportNull$$$0(95);
        }
        if (depProcessed == null) {
            PluginManagerCore.$$$reportNull$$$0(96);
        }
        if (consumer == null) {
            PluginManagerCore.$$$reportNull$$$0(97);
        }
        for (PluginId dependencyId : PluginManagerCore.getNonOptionalDependenciesIds(rootDescriptor)) {
            IdeaPluginDescriptorImpl descriptor2 = idToMap.get(dependencyId);
            PluginId pluginId = descriptor2 == null ? dependencyId : descriptor2.getPluginId();
            switch (consumer.apply(pluginId, descriptor2)) {
                case TERMINATE: {
                    return false;
                }
                case CONTINUE: {
                    if (descriptor2 == null || !depProcessed.add(descriptor2)) break;
                    PluginManagerCore.processAllDependencies(descriptor2, idToMap, depProcessed, consumer);
                    break;
                }
                case SKIP_SUBTREE: {
                    break;
                }
                case SKIP_SIBLINGS: {
                    throw new UnsupportedOperationException("FileVisitResult.SKIP_SIBLINGS is not supported");
                }
            }
        }
        return true;
    }

    @NotNull
    private static List<PluginId> getNonOptionalDependenciesIds(@NotNull IdeaPluginDescriptorImpl descriptor2) {
        if (descriptor2 == null) {
            PluginManagerCore.$$$reportNull$$$0(98);
        }
        ArrayList<PluginId> dependencies = new ArrayList<PluginId>();
        for (PluginDependency dependency : descriptor2.pluginDependencies) {
            if (dependency.isOptional()) continue;
            dependencies.add(dependency.getPluginId());
        }
        for (ModuleDependenciesDescriptor.PluginReference plugin2 : descriptor2.dependencies.plugins) {
            dependencies.add(plugin2.id);
        }
        ArrayList<PluginId> arrayList = dependencies;
        if (arrayList == null) {
            PluginManagerCore.$$$reportNull$$$0(99);
        }
        return arrayList;
    }

    public static synchronized boolean isUpdatedBundledPlugin(@NotNull PluginDescriptor plugin2) {
        if (plugin2 == null) {
            PluginManagerCore.$$$reportNull$$$0(100);
        }
        return ourShadowedBundledPlugins != null && ourShadowedBundledPlugins.contains(plugin2.getPluginId());
    }

    @Deprecated
    public static boolean isDisabled(@NotNull String pluginId) {
        if (pluginId == null) {
            PluginManagerCore.$$$reportNull$$$0(101);
        }
        return PluginManagerCore.isDisabled(PluginId.getId((String)pluginId));
    }

    @Deprecated
    public static boolean disablePlugin(@NotNull String id2) {
        if (id2 == null) {
            PluginManagerCore.$$$reportNull$$$0(102);
        }
        return PluginManagerCore.disablePlugin(PluginId.getId((String)id2));
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    public static boolean enablePlugin(@NotNull String id2) {
        if (id2 == null) {
            PluginManagerCore.$$$reportNull$$$0(103);
        }
        return PluginManagerCore.enablePlugin(PluginId.getId((String)id2));
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.2")
    public static void addDisablePluginListener(@NotNull Runnable listener2) {
        if (listener2 == null) {
            PluginManagerCore.$$$reportNull$$$0(104);
        }
        DisabledPluginsState.addDisablePluginListener(listener2);
    }

    static {
        isUnitTestMode = Boolean.getBoolean("idea.is.unit.test");
        pluginErrors = new ArrayList<Supplier<? extends HtmlChunk>>();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 44: 
            case 45: 
            case 46: 
            case 50: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 44: 
            case 45: 
            case 46: 
            case 50: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/plugins/PluginManagerCore";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 6: 
            case 101: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginId";
                break;
            }
            case 7: 
            case 27: 
            case 29: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 67: 
            case 70: 
            case 77: 
            case 98: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ids";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "writer";
                break;
            }
            case 15: 
            case 16: 
            case 68: 
            case 85: 
            case 86: 
            case 87: 
            case 102: 
            case 103: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependentPluginId";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorMessage";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginClass";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 23: 
            case 100: {
                objectArray2 = objectArray3;
                objectArray3[0] = "plugin";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vendorItem";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loader";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "javaDepGetter";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "plugins";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "incompletePlugins";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "globalErrorsSuppliers";
                break;
            }
            case 34: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginDescriptor";
                break;
            }
            case 36: 
            case 53: 
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginSet";
                break;
            }
            case 38: 
            case 55: 
            case 76: 
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errors";
                break;
            }
            case 39: 
            case 42: 
            case 45: 
            case 54: 
            case 62: 
            case 69: 
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "idMap";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disabledIds";
                break;
            }
            case 41: 
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disabledRequiredIds";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginIds";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultName";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coreClassLoader";
                break;
            }
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ideBuildNumber";
                break;
            }
            case 63: 
            case 81: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 64: 
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coreLoader";
                break;
            }
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "enabledPluginIds";
                break;
            }
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "enabledModuleV2Ids";
                break;
            }
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disabledPlugins";
                break;
            }
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "params";
                break;
            }
            case 88: 
            case 91: 
            case 94: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootDescriptor";
                break;
            }
            case 89: 
            case 92: 
            case 95: {
                objectArray2 = objectArray3;
                objectArray3[0] = "idToMap";
                break;
            }
            case 90: 
            case 93: 
            case 97: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 96: {
                objectArray2 = objectArray3;
                objectArray3[0] = "depProcessed";
                break;
            }
            case 104: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlugins";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPluginSet";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getLoadedPlugins";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getAndClearPluginLoadingErrors";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 44: 
            case 45: 
            case 46: 
            case 50: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/plugins/PluginManagerCore";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getBrokenPluginVersions";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "readBrokenPluginFile";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "preparePluginsError";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareActions";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrScheduleLoading";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnabledPluginRawList";
                break;
            }
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "initPlugins";
                break;
            }
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuildNumber";
                break;
            }
            case 66: {
                objectArray = objectArray2;
                objectArray2[1] = "buildPluginIdMap";
                break;
            }
            case 83: {
                objectArray = objectArray2;
                objectArray2[1] = "loadAndInitializePlugins";
                break;
            }
            case 84: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogger";
                break;
            }
            case 99: {
                objectArray = objectArray2;
                objectArray2[1] = "getNonOptionalDependenciesIds";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setPluginSet";
                break;
            }
            case 6: 
            case 101: {
                objectArray = objectArray;
                objectArray[2] = "isDisabled";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isBrokenPlugin";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "writePluginsList";
                break;
            }
            case 15: 
            case 102: {
                objectArray = objectArray;
                objectArray[2] = "disablePlugin";
                break;
            }
            case 16: 
            case 103: {
                objectArray = objectArray;
                objectArray[2] = "enablePlugin";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isModuleDependency";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "createPluginException";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getPluginByClassName";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getPluginOrPlatformByClassName";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getPluginDescriptorOrPlatformByClassName";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "isDevelopedByJetBrains";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "isVendorJetBrains";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "hasLoadedClass";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getImplicitDependency";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "hasModuleDependencies";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "logPlugins";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "preparePluginsError";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getShortLoadingErrorMessage";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getFirstDisabledDependency";
                break;
            }
            case 36: 
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "checkPluginCycles";
                break;
            }
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "prepareActions";
                break;
            }
            case 44: 
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "getFirstPluginName";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "initPlugins";
                break;
            }
            case 53: 
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "disableIncompatiblePlugins";
                break;
            }
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "isCompatible";
                break;
            }
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "isIncompatible";
                break;
            }
            case 60: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "checkBuildNumberCompatibility";
                break;
            }
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "checkEssentialPluginsAreAvailable";
                break;
            }
            case 63: 
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "initializePlugins";
                break;
            }
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "buildPluginIdMap";
                break;
            }
            case 67: 
            case 68: 
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "checkAndPut";
                break;
            }
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "computePluginEnabled";
                break;
            }
            case 77: 
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "addCannotLoadError";
                break;
            }
            case 79: 
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "message";
                break;
            }
            case 81: 
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "loadAndInitializePlugins";
                break;
            }
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "findPlugin";
                break;
            }
            case 86: {
                objectArray = objectArray;
                objectArray[2] = "findPluginByModuleDependency";
                break;
            }
            case 87: {
                objectArray = objectArray;
                objectArray[2] = "isPluginInstalled";
                break;
            }
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: {
                objectArray = objectArray;
                objectArray[2] = "processAllDependencies";
                break;
            }
            case 98: {
                objectArray = objectArray;
                objectArray[2] = "getNonOptionalDependenciesIds";
                break;
            }
            case 100: {
                objectArray = objectArray;
                objectArray[2] = "isUpdatedBundledPlugin";
                break;
            }
            case 104: {
                objectArray = objectArray;
                objectArray[2] = "addDisablePluginListener";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 44: 
            case 45: 
            case 46: 
            case 50: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class EssentialPluginMissingException
    extends RuntimeException {
        public final List<String> pluginIds;

        EssentialPluginMissingException(@NotNull List<String> ids) {
            if (ids == null) {
                EssentialPluginMissingException.$$$reportNull$$$0(0);
            }
            super("Missing essential plugins: " + String.join((CharSequence)", ", ids));
            this.pluginIds = ids;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ids", "com/intellij/ide/plugins/PluginManagerCore$EssentialPluginMissingException", "<init>"));
        }
    }
}

