/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.execution.process.ProcessIOExecutorService;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.icons.AllIcons;
import com.intellij.ide.CopyProvider;
import com.intellij.ide.DataManager;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.CountComponent;
import com.intellij.ide.plugins.CountIcon;
import com.intellij.ide.plugins.CustomPluginRepositoryService;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.InstalledPluginsState;
import com.intellij.ide.plugins.MultiPanel;
import com.intellij.ide.plugins.PluginEnableDisableAction;
import com.intellij.ide.plugins.PluginHostsConfigurable;
import com.intellij.ide.plugins.PluginInstallCallbackData;
import com.intellij.ide.plugins.PluginInstaller;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginManagerUISettings;
import com.intellij.ide.plugins.PluginNode;
import com.intellij.ide.plugins.RepositoryHelper;
import com.intellij.ide.plugins.certificates.PluginCertificateManager;
import com.intellij.ide.plugins.marketplace.MarketplaceRequests;
import com.intellij.ide.plugins.newui.LicensePanel;
import com.intellij.ide.plugins.newui.LinkComponent;
import com.intellij.ide.plugins.newui.ListPluginComponent;
import com.intellij.ide.plugins.newui.MultiSelectionEventHandler;
import com.intellij.ide.plugins.newui.MyPluginModel;
import com.intellij.ide.plugins.newui.PluginDetailsPageComponent;
import com.intellij.ide.plugins.newui.PluginLogo;
import com.intellij.ide.plugins.newui.PluginPriceService;
import com.intellij.ide.plugins.newui.PluginUpdatesService;
import com.intellij.ide.plugins.newui.PluginsGroup;
import com.intellij.ide.plugins.newui.PluginsGroupComponent;
import com.intellij.ide.plugins.newui.PluginsGroupComponentWithProgress;
import com.intellij.ide.plugins.newui.PluginsTab;
import com.intellij.ide.plugins.newui.SearchPopup;
import com.intellij.ide.plugins.newui.SearchQueryParser;
import com.intellij.ide.plugins.newui.SearchResultPanel;
import com.intellij.ide.plugins.newui.SearchUpDownPopupController;
import com.intellij.ide.plugins.newui.SearchWords;
import com.intellij.ide.plugins.newui.TabbedPaneHeaderComponent;
import com.intellij.ide.plugins.newui.Tags;
import com.intellij.ide.plugins.newui.UIPluginGroup;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CheckedActionGroup;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.updateSettings.impl.UpdateChecker;
import com.intellij.openapi.updateSettings.impl.UpdateSettings;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.JBColor;
import com.intellij.ui.LicensingFacade;
import com.intellij.ui.RelativeFont;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.components.fields.ExtendableTextComponent;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.ui.components.labels.LinkListener;
import com.intellij.ui.popup.PopupFactoryImpl;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.net.HttpConfigurable;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StatusText;
import com.intellij.util.ui.TextTransferable;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.datatransfer.Transferable;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.border.Border;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PluginManagerConfigurable
implements SearchableConfigurable,
Configurable.NoScroll,
Configurable.NoMargin,
Configurable.TopComponentProvider {
    private static final Logger LOG = Logger.getInstance(PluginManagerConfigurable.class);
    public static final String ID = "preferences.pluginManager";
    public static final String SELECTION_TAB_KEY = "PluginConfigurable.selectionTab";
    public static final Color MAIN_BG_COLOR = JBColor.namedColor((String)"Plugins.background", (Color)new JBColor(() -> JBColor.isBright() ? UIUtil.getListBackground() : new Color(0x313335)));
    public static final Color SEARCH_BG_COLOR = JBColor.namedColor((String)"Plugins.SearchField.background", (Color)MAIN_BG_COLOR);
    public static final Color SEARCH_FIELD_BORDER_COLOR = JBColor.namedColor((String)"Plugins.SearchField.borderColor", (Color)new JBColor(0xC5C5C5, 0x515151));
    private static final int MARKETPLACE_TAB = 0;
    private static final int INSTALLED_TAB = 1;
    public static final int ITEMS_PER_GROUP = 9;
    public static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("MMM dd, yyyy");
    private TabbedPaneHeaderComponent myTabHeaderComponent;
    private MultiPanel myCardPanel;
    private PluginsTab myMarketplaceTab;
    private PluginsTab myInstalledTab;
    private PluginsGroupComponentWithProgress myMarketplacePanel;
    private PluginsGroupComponent myInstalledPanel;
    private Runnable myMarketplaceRunnable;
    private SearchResultPanel myMarketplaceSearchPanel;
    private SearchResultPanel myInstalledSearchPanel;
    private final LinkLabel<Object> myUpdateAll = new LinkLabel(IdeBundle.message((String)"plugin.manager.update.all", (Object[])new Object[0]), null);
    private final JLabel myUpdateCounter = new CountComponent();
    private final CountIcon myCountIcon = new CountIcon();
    private final MyPluginModel myPluginModel;
    private PluginUpdatesService myPluginUpdatesService;
    private List<String> myTagsSorted;
    private List<String> myVendorsSorted;
    private DefaultActionGroup myMarketplaceSortByGroup;
    private Consumer<MarketplaceSortByAction> myMarketplaceSortByCallback;
    private LinkComponent myMarketplaceSortByAction;
    private DefaultActionGroup myInstalledSearchGroup;
    private Consumer<InstalledSearchOptionAction> myInstalledSearchCallback;
    private boolean myInstalledSearchSetState = true;
    private String myLaterSearchQuery;

    public PluginManagerConfigurable(@Nullable Project project) {
        this.myPluginModel = new MyPluginModel(project);
    }

    public PluginManagerConfigurable() {
        this((Project)null);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    public PluginManagerConfigurable(PluginManagerUISettings uiSettings) {
        this();
    }

    @NotNull
    public String getId() {
        return ID;
    }

    public String getDisplayName() {
        return IdeBundle.message((String)"title.plugins", (Object[])new Object[0]);
    }

    @NotNull
    public JComponent getCenterComponent(@NotNull Configurable.TopComponentController controller) {
        if (controller == null) {
            PluginManagerConfigurable.$$$reportNull$$$0(0);
        }
        this.myPluginModel.setTopController(controller);
        TabbedPaneHeaderComponent tabbedPaneHeaderComponent = this.myTabHeaderComponent;
        if (tabbedPaneHeaderComponent == null) {
            PluginManagerConfigurable.$$$reportNull$$$0(1);
        }
        return tabbedPaneHeaderComponent;
    }

    @NotNull
    public JComponent getTopComponent() {
        JComponent jComponent = this.getCenterComponent(Configurable.TopComponentController.EMPTY);
        if (jComponent == null) {
            PluginManagerConfigurable.$$$reportNull$$$0(2);
        }
        return jComponent;
    }

    @Nullable
    public JComponent createComponent() {
        this.myTabHeaderComponent = new TabbedPaneHeaderComponent(this.createGearActions(), index2 -> {
            this.myCardPanel.select(index2, true);
            PluginManagerConfigurable.storeSelectionTab(index2);
            String query2 = (index2 == 0 ? this.myInstalledTab : this.myMarketplaceTab).getSearchQuery();
            (index2 == 0 ? this.myMarketplaceTab : this.myInstalledTab).setSearchQuery(query2);
        });
        this.myUpdateAll.setVisible(false);
        this.myUpdateCounter.setVisible(false);
        this.myTabHeaderComponent.addTab(IdeBundle.message((String)"plugin.manager.tab.marketplace", (Object[])new Object[0]), null);
        this.myTabHeaderComponent.addTab(IdeBundle.message((String)"plugin.manager.tab.installed", (Object[])new Object[0]), this.myCountIcon);
        this.myPluginUpdatesService = PluginUpdatesService.connectWithCounter(countValue -> {
            int count = countValue == null ? 0 : countValue;
            String text2 = Integer.toString(count);
            boolean visible = count > 0;
            this.myUpdateAll.setEnabled(true);
            this.myUpdateAll.setVisible(visible);
            this.myUpdateCounter.setText(text2);
            this.myUpdateCounter.setVisible(visible);
            this.myCountIcon.setText(text2);
            this.myTabHeaderComponent.update();
        });
        this.myPluginModel.setPluginUpdatesService(this.myPluginUpdatesService);
        UpdateChecker.updateDescriptorsForInstalledPlugins(InstalledPluginsState.getInstance());
        this.createMarketplaceTab();
        this.createInstalledTab();
        this.myCardPanel = new MultiPanel(){

            @Override
            protected JComponent create(Integer key) {
                if (key == 0) {
                    return PluginManagerConfigurable.this.myMarketplaceTab.createPanel();
                }
                if (key == 1) {
                    return PluginManagerConfigurable.this.myInstalledTab.createPanel();
                }
                return super.create(key);
            }
        };
        this.myCardPanel.setMinimumSize((Dimension)new JBDimension(580, 380));
        this.myCardPanel.setPreferredSize((Dimension)new JBDimension(800, 600));
        this.myTabHeaderComponent.setListener();
        int selectionTab = PluginManagerConfigurable.getStoredSelectionTab();
        this.myTabHeaderComponent.setSelection(selectionTab);
        this.myCardPanel.select(selectionTab, true);
        if (this.myLaterSearchQuery != null) {
            Runnable search2 = this.enableSearch(this.myLaterSearchQuery);
            if (search2 != null) {
                ApplicationManager.getApplication().invokeLater(search2, ModalityState.any());
            }
            this.myLaterSearchQuery = null;
        }
        return this.myCardPanel;
    }

    @NotNull
    private DefaultActionGroup createGearActions() {
        DefaultActionGroup actions2 = new DefaultActionGroup();
        actions2.add((AnAction)new DumbAwareAction(IdeBundle.message((String)"plugin.manager.repositories", (Object[])new Object[0])){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (ShowSettingsUtil.getInstance().editConfigurable((Component)PluginManagerConfigurable.this.myCardPanel, (Configurable)new PluginHostsConfigurable())) {
                    PluginManagerConfigurable.this.resetPanels();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/plugins/PluginManagerConfigurable$2", "actionPerformed"));
            }
        });
        actions2.add((AnAction)new DumbAwareAction(IdeBundle.message((String)"button.http.proxy.settings", (Object[])new Object[0])){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (HttpConfigurable.editConfigurable((JComponent)PluginManagerConfigurable.this.myCardPanel)) {
                    PluginManagerConfigurable.this.resetPanels();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/plugins/PluginManagerConfigurable$3", "actionPerformed"));
            }
        });
        actions2.addSeparator();
        actions2.add((AnAction)new DumbAwareAction(IdeBundle.message((String)"plugin.manager.custom.certificates", (Object[])new Object[0])){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (ShowSettingsUtil.getInstance().editConfigurable((Component)PluginManagerConfigurable.this.myCardPanel, (Configurable)new PluginCertificateManager())) {
                    PluginManagerConfigurable.this.resetPanels();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/plugins/PluginManagerConfigurable$4", "actionPerformed"));
            }
        });
        actions2.add((AnAction)new InstallFromDiskAction());
        actions2.addSeparator();
        actions2.add((AnAction)new ChangePluginStateAction(false));
        actions2.add((AnAction)new ChangePluginStateAction(true));
        DefaultActionGroup defaultActionGroup = actions2;
        if (defaultActionGroup == null) {
            PluginManagerConfigurable.$$$reportNull$$$0(3);
        }
        return defaultActionGroup;
    }

    private static void showRightBottomPopup(final @NotNull Component component2, @NotNull @Nls String title2, @NotNull ActionGroup group2) {
        if (component2 == null) {
            PluginManagerConfigurable.$$$reportNull$$$0(4);
        }
        if (title2 == null) {
            PluginManagerConfigurable.$$$reportNull$$$0(5);
        }
        if (group2 == null) {
            PluginManagerConfigurable.$$$reportNull$$$0(6);
        }
        GroupByActionGroup actions2 = new GroupByActionGroup();
        actions2.addSeparator("  " + title2);
        actions2.addAll(group2);
        DataContext context2 = DataManager.getInstance().getDataContext(component2);
        final PopupFactoryImpl.ActionGroupPopup popup2 = new PopupFactoryImpl.ActionGroupPopup(null, (ActionGroup)actions2, context2, false, false, false, true, null, -1, null, null);
        popup2.addListener(new JBPopupListener(){

            public void beforeShown(@NotNull LightweightWindowEvent event) {
                if (event == null) {
                    5.$$$reportNull$$$0(0);
                }
                Point location = component2.getLocationOnScreen();
                Dimension size = popup2.getSize();
                popup2.setLocation(new Point(location.x + component2.getWidth() - size.width, location.y + component2.getHeight()));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/ide/plugins/PluginManagerConfigurable$5", "beforeShown"));
            }
        });
        popup2.show(component2);
    }

    private void resetPanels() {
        CustomPluginRepositoryService.getInstance().clearCache();
        this.myTagsSorted = null;
        this.myVendorsSorted = null;
        this.myPluginUpdatesService.recalculateUpdates();
        if (this.myMarketplacePanel == null) {
            return;
        }
        int selectionTab = this.myTabHeaderComponent.getSelectionTab();
        if (selectionTab == 0) {
            this.myMarketplaceRunnable.run();
        } else {
            this.myMarketplacePanel.setVisibleRunnable(this.myMarketplaceRunnable);
        }
    }

    private static int getStoredSelectionTab() {
        int value2 = PropertiesComponent.getInstance().getInt(SELECTION_TAB_KEY, 0);
        return value2 < 0 || value2 > 1 ? 0 : value2;
    }

    private static void storeSelectionTab(int value2) {
        PropertiesComponent.getInstance().setValue(SELECTION_TAB_KEY, value2, 0);
    }

    private void createMarketplaceTab() {
        this.myMarketplaceTab = new PluginsTab(){

            @Override
            protected void createSearchTextField(int flyDelay) {
                super.createSearchTextField(250);
                this.mySearchTextField.setHistoryPropertyName("MarketplacePluginsSearchHistory");
            }

            @Override
            @NotNull
            protected PluginDetailsPageComponent createDetailsPanel(@NotNull LinkListener<Object> searchListener) {
                if (searchListener == null) {
                    6.$$$reportNull$$$0(0);
                }
                PluginDetailsPageComponent detailPanel = new PluginDetailsPageComponent(PluginManagerConfigurable.this.myPluginModel, searchListener, true);
                PluginManagerConfigurable.this.myPluginModel.addDetailPanel(detailPanel);
                PluginDetailsPageComponent pluginDetailsPageComponent = detailPanel;
                if (pluginDetailsPageComponent == null) {
                    6.$$$reportNull$$$0(1);
                }
                return pluginDetailsPageComponent;
            }

            @Override
            @NotNull
            protected JComponent createPluginsPanel(@NotNull Consumer<? super PluginsGroupComponent> selectionListener2) {
                if (selectionListener2 == null) {
                    6.$$$reportNull$$$0(2);
                }
                MultiSelectionEventHandler eventHandler = new MultiSelectionEventHandler();
                PluginManagerConfigurable.this.myMarketplacePanel = new PluginsGroupComponentWithProgress(eventHandler){

                    @Override
                    @NotNull
                    protected ListPluginComponent createListComponent(@NotNull IdeaPluginDescriptor descriptor2) {
                        if (descriptor2 == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        return new ListPluginComponent(PluginManagerConfigurable.this.myPluginModel, descriptor2, (LinkListener<Object>)mySearchListener, true);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/ide/plugins/PluginManagerConfigurable$6$1", "createListComponent"));
                    }
                };
                PluginManagerConfigurable.this.myMarketplacePanel.setSelectionListener(selectionListener2);
                PluginManagerConfigurable.registerCopyProvider(PluginManagerConfigurable.this.myMarketplacePanel);
                ((SearchUpDownPopupController)PluginManagerConfigurable.this.myMarketplaceSearchPanel.controller).setEventHandler(eventHandler);
                Runnable runnable2 = () -> {
                    ArrayList groups2 = new ArrayList();
                    try {
                        Map<String, List<PluginNode>> customRepositoriesMap = CustomPluginRepositoryService.getInstance().getCustomRepositoryPluginMap();
                        try {
                            PluginManagerConfigurable.this.addGroupViaLightDescriptor(groups2, IdeBundle.message((String)"plugins.configurable.featured", (Object[])new Object[0]), "is_featured_search=true", "/sortBy:featured");
                            PluginManagerConfigurable.this.addGroupViaLightDescriptor(groups2, IdeBundle.message((String)"plugins.configurable.new.and.updated", (Object[])new Object[0]), "orderBy=update+date", "/sortBy:updated");
                            PluginManagerConfigurable.this.addGroupViaLightDescriptor(groups2, IdeBundle.message((String)"plugins.configurable.top.downloads", (Object[])new Object[0]), "orderBy=downloads", "/sortBy:downloads");
                            PluginManagerConfigurable.this.addGroupViaLightDescriptor(groups2, IdeBundle.message((String)"plugins.configurable.top.rated", (Object[])new Object[0]), "orderBy=rating", "/sortBy:rating");
                        }
                        catch (IOException e) {
                            LOG.info("Main plugin repository is not available ('" + e.getMessage() + "'). Please check your network settings.");
                        }
                        for (String host : UpdateSettings.getInstance().getPluginHosts()) {
                            List<PluginNode> allDescriptors = customRepositoriesMap.get(host);
                            if (allDescriptors == null) continue;
                            PluginManagerConfigurable.this.addGroup(groups2, IdeBundle.message((String)"plugins.configurable.repository.0", (Object[])new Object[]{host}), "/repository:\"" + host + "\"", allDescriptors, group2 -> {
                                PluginsGroup.sortByName(group2.descriptors);
                                return allDescriptors.size() > 9;
                            });
                        }
                    }
                    finally {
                        ApplicationManager.getApplication().invokeLater(() -> {
                            PluginManagerConfigurable.this.myMarketplacePanel.stopLoading();
                            try {
                                PluginLogo.startBatchMode();
                                for (PluginsGroup group2 : groups2) {
                                    PluginManagerConfigurable.this.myMarketplacePanel.addGroup(group2);
                                }
                            }
                            finally {
                                PluginLogo.endBatchMode();
                            }
                            PluginManagerConfigurable.this.myMarketplacePanel.doLayout();
                            PluginManagerConfigurable.this.myMarketplacePanel.initialSelection();
                        }, ModalityState.any());
                    }
                };
                PluginManagerConfigurable.this.myMarketplaceRunnable = () -> {
                    PluginManagerConfigurable.this.myMarketplacePanel.clear();
                    PluginManagerConfigurable.this.myMarketplacePanel.startLoading();
                    ApplicationManager.getApplication().executeOnPooledThread(runnable2);
                };
                PluginManagerConfigurable.this.myMarketplacePanel.getEmptyText().setText(IdeBundle.message((String)"plugins.configurable.marketplace.plugins.not.loaded", (Object[])new Object[0])).appendSecondaryText(IdeBundle.message((String)"message.check.the.internet.connection.and", (Object[])new Object[0]) + " ", StatusText.DEFAULT_ATTRIBUTES, null).appendSecondaryText(IdeBundle.message((String)"message.link.refresh", (Object[])new Object[0]), SimpleTextAttributes.LINK_PLAIN_ATTRIBUTES, e -> PluginManagerConfigurable.this.myMarketplaceRunnable.run());
                ApplicationManager.getApplication().executeOnPooledThread(runnable2);
                JComponent jComponent = PluginManagerConfigurable.createScrollPane(PluginManagerConfigurable.this.myMarketplacePanel, false);
                if (jComponent == null) {
                    6.$$$reportNull$$$0(3);
                }
                return jComponent;
            }

            @Override
            protected void updateMainSelection(@NotNull Consumer<? super PluginsGroupComponent> selectionListener2) {
                if (selectionListener2 == null) {
                    6.$$$reportNull$$$0(4);
                }
                selectionListener2.accept(PluginManagerConfigurable.this.myMarketplacePanel);
            }

            @Override
            @NotNull
            protected SearchResultPanel createSearchPanel(@NotNull Consumer<? super PluginsGroupComponent> selectionListener2) {
                if (selectionListener2 == null) {
                    6.$$$reportNull$$$0(5);
                }
                SearchUpDownPopupController marketplaceController = new SearchUpDownPopupController(this.mySearchTextField){

                    @Override
                    @NotNull
                    protected List<String> getAttributes() {
                        ArrayList<String> attributes2 = new ArrayList<String>();
                        attributes2.add(SearchWords.TAG.getValue());
                        attributes2.add(SearchWords.SORT_BY.getValue());
                        attributes2.add(SearchWords.ORGANIZATION.getValue());
                        if (!UpdateSettings.getInstance().getPluginHosts().isEmpty()) {
                            attributes2.add(SearchWords.REPOSITORY.getValue());
                        }
                        ArrayList<String> arrayList = attributes2;
                        if (arrayList == null) {
                            2.$$$reportNull$$$0(0);
                        }
                        return arrayList;
                    }

                    @Nullable
                    protected List<String> getValues(@NotNull String attribute) {
                        SearchWords word;
                        if (attribute == null) {
                            2.$$$reportNull$$$0(1);
                        }
                        if ((word = SearchWords.find(attribute)) == null) {
                            return null;
                        }
                        switch (word) {
                            case TAG: {
                                if (PluginManagerConfigurable.this.myTagsSorted == null || PluginManagerConfigurable.this.myTagsSorted.isEmpty()) {
                                    HashSet<String> allTags = new HashSet<String>();
                                    for (PluginNode descriptor2 : CustomPluginRepositoryService.getInstance().getCustomRepositoryPlugins()) {
                                        List<String> tags = descriptor2.getTags();
                                        if (tags == null || tags.isEmpty()) continue;
                                        allTags.addAll(tags);
                                    }
                                    try {
                                        ProcessIOExecutorService.INSTANCE.submit(() -> allTags.addAll(MarketplaceRequests.getInstance().getAllPluginsTags())).get();
                                    }
                                    catch (InterruptedException | ExecutionException e) {
                                        LOG.error("Error while getting tags from marketplace", (Throwable)e);
                                    }
                                    PluginManagerConfigurable.this.myTagsSorted = ContainerUtil.sorted(allTags, String::compareToIgnoreCase);
                                }
                                return PluginManagerConfigurable.this.myTagsSorted;
                            }
                            case SORT_BY: {
                                return Arrays.asList("downloads", "name", "rating", "updated");
                            }
                            case ORGANIZATION: {
                                if (PluginManagerConfigurable.this.myVendorsSorted == null || PluginManagerConfigurable.this.myVendorsSorted.isEmpty()) {
                                    LinkedHashSet vendors = new LinkedHashSet();
                                    try {
                                        ProcessIOExecutorService.INSTANCE.submit(() -> vendors.addAll(MarketplaceRequests.getInstance().getAllPluginsVendors())).get();
                                    }
                                    catch (InterruptedException | ExecutionException e) {
                                        LOG.error("Error while getting vendors from marketplace", (Throwable)e);
                                    }
                                    PluginManagerConfigurable.this.myVendorsSorted = new ArrayList<String>(vendors);
                                }
                                return PluginManagerConfigurable.this.myVendorsSorted;
                            }
                            case REPOSITORY: {
                                return UpdateSettings.getInstance().getPluginHosts();
                            }
                        }
                        return null;
                    }

                    @Override
                    protected void showPopupForQuery() {
                        this.showSearchPanel(mySearchTextField.getText());
                    }

                    @Override
                    protected void handleEnter() {
                        if (!mySearchTextField.getText().isEmpty()) {
                            this.handleTrigger("marketplace.suggest.popup.enter");
                        }
                    }

                    @Override
                    protected void handlePopupListFirstSelection() {
                        this.handleTrigger("marketplace.suggest.popup.select");
                    }

                    private void handleTrigger(@NonNls String key) {
                        if (this.myPopup != null && this.myPopup.type == SearchPopup.Type.SearchQuery) {
                            FeatureUsageTracker.getInstance().triggerFeatureUsed(key);
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        RuntimeException runtimeException;
                        Object[] objectArray;
                        Object[] objectArray2;
                        int n2;
                        String string;
                        switch (n) {
                            default: {
                                string = "@NotNull method %s.%s must not return null";
                                break;
                            }
                            case 1: {
                                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                n2 = 2;
                                break;
                            }
                            case 1: {
                                n2 = 3;
                                break;
                            }
                        }
                        Object[] objectArray3 = new Object[n2];
                        switch (n) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "com/intellij/ide/plugins/PluginManagerConfigurable$6$2";
                                break;
                            }
                            case 1: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "attribute";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[1] = "getAttributes";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[1] = "com/intellij/ide/plugins/PluginManagerConfigurable$6$2";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                break;
                            }
                            case 1: {
                                objectArray = objectArray;
                                objectArray[2] = "getValues";
                                break;
                            }
                        }
                        String string2 = String.format(string, objectArray);
                        switch (n) {
                            default: {
                                runtimeException = new IllegalStateException(string2);
                                break;
                            }
                            case 1: {
                                runtimeException = new IllegalArgumentException(string2);
                                break;
                            }
                        }
                        throw runtimeException;
                    }
                };
                PluginManagerConfigurable.this.myMarketplaceSortByGroup = new DefaultActionGroup();
                for (SortBySearchOption option2 : SortBySearchOption.values()) {
                    PluginManagerConfigurable.this.myMarketplaceSortByGroup.addAction((AnAction)new MarketplaceSortByAction(option2));
                }
                PluginManagerConfigurable.this.myMarketplaceSortByAction = new LinkComponent(){

                    protected boolean isInClickableArea(Point pt) {
                        return true;
                    }
                };
                PluginManagerConfigurable.this.myMarketplaceSortByAction.setIcon(new Icon(){

                    @Override
                    public void paintIcon(Component c, Graphics g, int x, int y) {
                        this.getIcon().paintIcon(c, g, x, y + 1);
                    }

                    @Override
                    public int getIconWidth() {
                        return this.getIcon().getIconWidth();
                    }

                    @Override
                    public int getIconHeight() {
                        return this.getIcon().getIconHeight();
                    }

                    @NotNull
                    private Icon getIcon() {
                        Icon icon2 = AllIcons.General.ButtonDropTriangle;
                        if (icon2 == null) {
                            4.$$$reportNull$$$0(0);
                        }
                        return icon2;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/plugins/PluginManagerConfigurable$6$4", "getIcon"));
                    }
                });
                PluginManagerConfigurable.this.myMarketplaceSortByAction.setPaintUnderline(false);
                PluginManagerConfigurable.this.myMarketplaceSortByAction.setIconTextGap(JBUIScale.scale((int)4));
                PluginManagerConfigurable.this.myMarketplaceSortByAction.setHorizontalTextPosition(2);
                PluginManagerConfigurable.this.myMarketplaceSortByAction.setForeground(PluginsGroupComponent.SECTION_HEADER_FOREGROUND);
                PluginManagerConfigurable.this.myMarketplaceSortByAction.setListener((component2, __) -> PluginManagerConfigurable.showRightBottomPopup(component2.getParent().getParent(), IdeBundle.message((String)"plugins.configurable.sort.by", (Object[])new Object[0]), (ActionGroup)PluginManagerConfigurable.this.myMarketplaceSortByGroup), null);
                PluginManagerConfigurable.this.myMarketplaceSortByCallback = updateAction -> {
                    String query2;
                    MarketplaceSortByAction removeAction = null;
                    MarketplaceSortByAction addAction = null;
                    if (updateAction.myState) {
                        for (AnAction action2 : PluginManagerConfigurable.this.myMarketplaceSortByGroup.getChildren(null)) {
                            MarketplaceSortByAction sortByAction = (MarketplaceSortByAction)action2;
                            if (sortByAction == updateAction || !sortByAction.myState) continue;
                            sortByAction.myState = false;
                            removeAction = sortByAction;
                            break;
                        }
                        addAction = updateAction;
                    } else {
                        if (updateAction.myOption == SortBySearchOption.Relevance) {
                            updateAction.myState = true;
                            return;
                        }
                        for (AnAction action3 : PluginManagerConfigurable.this.myMarketplaceSortByGroup.getChildren(null)) {
                            MarketplaceSortByAction sortByAction = (MarketplaceSortByAction)action3;
                            if (sortByAction.myOption != SortBySearchOption.Relevance) continue;
                            sortByAction.myState = true;
                            break;
                        }
                        removeAction = updateAction;
                    }
                    final ArrayList<String> queries = new ArrayList<String>();
                    new SearchQueryParser.Marketplace(this.mySearchTextField.getText()){

                        @Override
                        protected void addToSearchQuery(@NotNull String query2) {
                            if (query2 == null) {
                                5.$$$reportNull$$$0(0);
                            }
                            queries.add(query2);
                        }

                        @Override
                        protected void handleAttribute(@NotNull String name, @NotNull String value2) {
                            if (name == null) {
                                5.$$$reportNull$$$0(1);
                            }
                            if (value2 == null) {
                                5.$$$reportNull$$$0(2);
                            }
                            queries.add(name + SearchQueryParser.wrapAttribute(value2));
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            Object[] objectArray;
                            Object[] objectArray2;
                            Object[] objectArray3 = new Object[3];
                            switch (n) {
                                default: {
                                    objectArray2 = objectArray3;
                                    objectArray3[0] = "query";
                                    break;
                                }
                                case 1: {
                                    objectArray2 = objectArray3;
                                    objectArray3[0] = "name";
                                    break;
                                }
                                case 2: {
                                    objectArray2 = objectArray3;
                                    objectArray3[0] = "value";
                                    break;
                                }
                            }
                            objectArray2[1] = "com/intellij/ide/plugins/PluginManagerConfigurable$6$5";
                            switch (n) {
                                default: {
                                    objectArray = objectArray2;
                                    objectArray2[2] = "addToSearchQuery";
                                    break;
                                }
                                case 1: 
                                case 2: {
                                    objectArray = objectArray2;
                                    objectArray2[2] = "handleAttribute";
                                    break;
                                }
                            }
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                        }
                    };
                    if (removeAction != null && (query2 = removeAction.getQuery()) != null) {
                        queries.remove(query2);
                    }
                    if (addAction != null && (query = addAction.getQuery()) != null) {
                        queries.add(query);
                    }
                    query = StringUtil.join(queries, (String)" ");
                    this.mySearchTextField.setTextIgnoreEvents(query);
                    if (query.isEmpty()) {
                        PluginManagerConfigurable.this.myMarketplaceTab.hideSearchPanel();
                    } else {
                        PluginManagerConfigurable.this.myMarketplaceTab.showSearchPanel(query);
                    }
                };
                MultiSelectionEventHandler eventHandler = new MultiSelectionEventHandler();
                marketplaceController.setSearchResultEventHandler(eventHandler);
                PluginsGroupComponentWithProgress panel2 = new PluginsGroupComponentWithProgress(eventHandler){

                    @Override
                    @NotNull
                    protected ListPluginComponent createListComponent(@NotNull IdeaPluginDescriptor descriptor2) {
                        if (descriptor2 == null) {
                            6.$$$reportNull$$$0(0);
                        }
                        return new ListPluginComponent(PluginManagerConfigurable.this.myPluginModel, descriptor2, (LinkListener<Object>)mySearchListener, true);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/ide/plugins/PluginManagerConfigurable$6$6", "createListComponent"));
                    }
                };
                panel2.setSelectionListener(selectionListener2);
                PluginManagerConfigurable.registerCopyProvider(panel2);
                SearchResultPanel searchResultPanel = PluginManagerConfigurable.this.myMarketplaceSearchPanel = new SearchResultPanel(marketplaceController, panel2, 0, 0){

                    @Override
                    protected void handleQuery(@NotNull String query2, @NotNull PluginsGroup result2) {
                        if (query2 == null) {
                            7.$$$reportNull$$$0(0);
                        }
                        if (result2 == null) {
                            7.$$$reportNull$$$0(1);
                        }
                        try {
                            Map<String, List<PluginNode>> customRepositoriesMap = CustomPluginRepositoryService.getInstance().getCustomRepositoryPluginMap();
                            SearchQueryParser.Marketplace parser = new SearchQueryParser.Marketplace(query2);
                            if (!parser.repositories.isEmpty()) {
                                for (String repository : parser.repositories) {
                                    List<PluginNode> descriptors2 = customRepositoriesMap.get(repository);
                                    if (descriptors2 == null) continue;
                                    if (parser.searchQuery == null) {
                                        result2.descriptors.addAll(descriptors2);
                                        continue;
                                    }
                                    for (PluginNode descriptor3 : descriptors2) {
                                        if (!StringUtil.containsIgnoreCase((String)descriptor3.getName(), (String)parser.searchQuery)) continue;
                                        result2.descriptors.add(descriptor3);
                                    }
                                }
                                ContainerUtil.removeDuplicates(result2.descriptors);
                                result2.sortByName();
                                return;
                            }
                            List<PluginNode> pluginsFromMarketplace = MarketplaceRequests.getInstance().searchPlugins(parser.getUrlQuery(), 10000);
                            List customPlugins = ContainerUtil.flatten(customRepositoriesMap.values());
                            Collection<PluginNode> plugins2 = RepositoryHelper.mergePluginsFromRepositories(pluginsFromMarketplace, customPlugins, false);
                            result2.descriptors.addAll(0, plugins2);
                            if (parser.searchQuery != null) {
                                List descriptors3 = ContainerUtil.filter((Collection)customPlugins, descriptor2 -> StringUtil.containsIgnoreCase((String)descriptor2.getName(), (String)parser.searchQuery));
                                result2.descriptors.addAll(0, descriptors3);
                            }
                            ContainerUtil.removeDuplicates(result2.descriptors);
                            if (!result2.descriptors.isEmpty()) {
                                String title2 = IdeBundle.message((String)"plugin.manager.action.label.sort.by.1", (Object[])new Object[0]);
                                for (AnAction action2 : PluginManagerConfigurable.this.myMarketplaceSortByGroup.getChildren(null)) {
                                    MarketplaceSortByAction sortByAction = (MarketplaceSortByAction)action2;
                                    sortByAction.setState(parser);
                                    if (!sortByAction.myState) continue;
                                    title2 = IdeBundle.message((String)"plugin.manager.action.label.sort.by", (Object[])new Object[]{sortByAction.myOption.myPresentableNameSupplier.get()});
                                }
                                PluginManagerConfigurable.this.myMarketplaceSortByAction.setText(title2);
                                result2.addRightAction((JComponent)((Object)PluginManagerConfigurable.this.myMarketplaceSortByAction));
                            }
                        }
                        catch (IOException e) {
                            LOG.info((Throwable)e);
                            ApplicationManager.getApplication().invokeLater(() -> this.myPanel.getEmptyText().setText(IdeBundle.message((String)"plugins.configurable.search.result.not.loaded", (Object[])new Object[0])).appendSecondaryText(IdeBundle.message((String)"plugins.configurable.check.internet", (Object[])new Object[0]), StatusText.DEFAULT_ATTRIBUTES, null), ModalityState.any());
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[0] = "query";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[0] = "result";
                                break;
                            }
                        }
                        objectArray[1] = "com/intellij/ide/plugins/PluginManagerConfigurable$6$7";
                        objectArray[2] = "handleQuery";
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                };
                if (searchResultPanel == null) {
                    6.$$$reportNull$$$0(6);
                }
                return searchResultPanel;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 6: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 6: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "searchListener";
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/ide/plugins/PluginManagerConfigurable$6";
                        break;
                    }
                    case 2: 
                    case 4: 
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "selectionListener";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/ide/plugins/PluginManagerConfigurable$6";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createDetailsPanel";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createPluginsPanel";
                        break;
                    }
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createSearchPanel";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "createDetailsPanel";
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 6: {
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "createPluginsPanel";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray;
                        objectArray[2] = "updateMainSelection";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray;
                        objectArray[2] = "createSearchPanel";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 6: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    private void createInstalledTab() {
        this.myInstalledSearchGroup = new DefaultActionGroup();
        for (InstalledSearchOption option2 : InstalledSearchOption.values()) {
            this.myInstalledSearchGroup.add((AnAction)new InstalledSearchOptionAction(option2));
        }
        this.myInstalledTab = new PluginsTab(){

            @Override
            protected void createSearchTextField(int flyDelay) {
                super.createSearchTextField(flyDelay);
                JBTextField textField2 = this.mySearchTextField.getTextEditor();
                textField2.putClientProperty((Object)"search.extension", (Object)ExtendableTextComponent.Extension.create((Icon)AllIcons.Actions.More, (Icon)AllIcons.Actions.More, (String)IdeBundle.message((String)"plugins.configurable.search.options", (Object[])new Object[0]), () -> PluginManagerConfigurable.showRightBottomPopup((Component)textField2, IdeBundle.message((String)"plugins.configurable.show", (Object[])new Object[0]), (ActionGroup)PluginManagerConfigurable.this.myInstalledSearchGroup)));
                textField2.putClientProperty((Object)"JTextField.variant", null);
                textField2.putClientProperty((Object)"JTextField.variant", (Object)"search");
                this.mySearchTextField.setHistoryPropertyName("InstalledPluginsSearchHistory");
            }

            @Override
            @NotNull
            protected PluginDetailsPageComponent createDetailsPanel(@NotNull LinkListener<Object> searchListener) {
                if (searchListener == null) {
                    7.$$$reportNull$$$0(0);
                }
                PluginDetailsPageComponent detailPanel = new PluginDetailsPageComponent(PluginManagerConfigurable.this.myPluginModel, searchListener, false);
                PluginManagerConfigurable.this.myPluginModel.addDetailPanel(detailPanel);
                PluginDetailsPageComponent pluginDetailsPageComponent = detailPanel;
                if (pluginDetailsPageComponent == null) {
                    7.$$$reportNull$$$0(1);
                }
                return pluginDetailsPageComponent;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NotNull
            protected JComponent createPluginsPanel(@NotNull Consumer<? super PluginsGroupComponent> selectionListener2) {
                if (selectionListener2 == null) {
                    7.$$$reportNull$$$0(2);
                }
                MultiSelectionEventHandler eventHandler = new MultiSelectionEventHandler();
                PluginManagerConfigurable.this.myInstalledPanel = new PluginsGroupComponent(eventHandler){

                    @Override
                    @NotNull
                    protected ListPluginComponent createListComponent(@NotNull IdeaPluginDescriptor descriptor2) {
                        if (descriptor2 == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        return new ListPluginComponent(PluginManagerConfigurable.this.myPluginModel, descriptor2, (LinkListener<Object>)mySearchListener, false);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/ide/plugins/PluginManagerConfigurable$7$1", "createListComponent"));
                    }
                };
                PluginManagerConfigurable.this.myInstalledPanel.setSelectionListener(selectionListener2);
                PluginManagerConfigurable.registerCopyProvider(PluginManagerConfigurable.this.myInstalledPanel);
                ((SearchUpDownPopupController)PluginManagerConfigurable.this.myInstalledSearchPanel.controller).setEventHandler(eventHandler);
                try {
                    PluginLogo.startBatchMode();
                    PluginsGroup installing = new PluginsGroup(IdeBundle.message((String)"plugins.configurable.installing", (Object[])new Object[0]));
                    installing.descriptors.addAll(MyPluginModel.getInstallingPlugins());
                    if (!installing.descriptors.isEmpty()) {
                        installing.sortByName();
                        installing.titleWithCount();
                        PluginManagerConfigurable.this.myInstalledPanel.addGroup(installing);
                    }
                    PluginsGroup downloaded = new PluginsGroup(IdeBundle.message((String)"plugins.configurable.downloaded", (Object[])new Object[0]));
                    downloaded.descriptors.addAll(InstalledPluginsState.getInstance().getInstalledPlugins());
                    HashMap<@NlsSafe String, ArrayList<IdeaPluginDescriptor>> bundledGroups = new HashMap<String, ArrayList<IdeaPluginDescriptor>>();
                    ApplicationInfoEx appInfo = ApplicationInfoEx.getInstanceEx();
                    int downloadedEnabled = 0;
                    boolean hideImplDetails = PluginManager.getInstance().hideImplementationDetails();
                    String otherCategoryTitle = IdeBundle.message((String)"plugins.configurable.other.bundled", (Object[])new Object[0]);
                    for (IdeaPluginDescriptor descriptor2 : PluginManagerCore.getPlugins()) {
                        if (appInfo.isEssentialPlugin(descriptor2.getPluginId())) continue;
                        if (descriptor2.isBundled()) {
                            if (hideImplDetails && descriptor2.isImplementationDetail()) continue;
                            String category = StringUtil.defaultIfEmpty((String)descriptor2.getCategory(), (String)otherCategoryTitle);
                            ArrayList<IdeaPluginDescriptor> groupDescriptors = (ArrayList<IdeaPluginDescriptor>)bundledGroups.get(category);
                            if (groupDescriptors == null) {
                                groupDescriptors = new ArrayList<IdeaPluginDescriptor>();
                                bundledGroups.put(category, groupDescriptors);
                            }
                            groupDescriptors.add(descriptor2);
                            continue;
                        }
                        downloaded.descriptors.add(descriptor2);
                        if (!descriptor2.isEnabled()) continue;
                        ++downloadedEnabled;
                    }
                    if (!downloaded.descriptors.isEmpty()) {
                        PluginManagerConfigurable.this.myUpdateAll.setListener((LinkListener)new LinkListener<Object>(){

                            public void linkSelected(LinkLabel<Object> aSource, Object aLinkData) {
                                PluginManagerConfigurable.this.myUpdateAll.setEnabled(false);
                                for (UIPluginGroup group2 : PluginManagerConfigurable.this.getInstalledGroups()) {
                                    for (ListPluginComponent plugin2 : group2.plugins) {
                                        plugin2.updatePlugin();
                                    }
                                }
                            }
                        }, null);
                        downloaded.addRightAction((JComponent)PluginManagerConfigurable.this.myUpdateAll);
                        downloaded.addRightAction(PluginManagerConfigurable.this.myUpdateCounter);
                        downloaded.sortByName();
                        downloaded.titleWithCount(downloadedEnabled);
                        PluginManagerConfigurable.this.myInstalledPanel.addGroup(downloaded);
                        PluginManagerConfigurable.this.myPluginModel.addEnabledGroup(downloaded);
                    }
                    PluginManagerConfigurable.this.myPluginModel.setDownloadedGroup(PluginManagerConfigurable.this.myInstalledPanel, downloaded, installing);
                    ArrayList<PluginsGroup> groups2 = new ArrayList<PluginsGroup>();
                    for (Map.Entry entry2 : bundledGroups.entrySet()) {
                        PluginsGroup group3 = new PluginsGroup((String)entry2.getKey()){

                            @Override
                            public void titleWithCount(int enabled) {
                                this.rightAction.setText(enabled == 0 ? IdeBundle.message((String)"plugins.configurable.enable.all", (Object[])new Object[0]) : IdeBundle.message((String)"plugins.configurable.disable.all", (Object[])new Object[0]));
                            }
                        };
                        group3.descriptors.addAll((Collection)entry2.getValue());
                        group3.sortByName();
                        group3.rightAction = new LinkLabel("", null, (__, ___) -> PluginManagerConfigurable.this.myPluginModel.setEnabledState(group2.descriptors, PluginEnableDisableAction.globally(group2.rightAction.getText().startsWith("Enable"))));
                        group3.titleWithEnabled(PluginManagerConfigurable.this.myPluginModel);
                        groups2.add(group3);
                    }
                    ContainerUtil.sort(groups2, (o1, o2) -> StringUtil.compare((String)o1.title, (String)o2.title, (boolean)true));
                    PluginsGroup otherGroup = (PluginsGroup)ContainerUtil.find(groups2, group2 -> group2.title.equals(otherCategoryTitle));
                    if (otherGroup != null) {
                        groups2.remove(otherGroup);
                        groups2.add(otherGroup);
                    }
                    for (PluginsGroup group3 : groups2) {
                        PluginManagerConfigurable.this.myInstalledPanel.addGroup(group3);
                        PluginManagerConfigurable.this.myPluginModel.addEnabledGroup(group3);
                    }
                    PluginManagerConfigurable.this.myPluginUpdatesService.calculateUpdates(updates2 -> {
                        if (ContainerUtil.isEmpty((Collection)updates2)) {
                            PluginManagerConfigurable.clearUpdates(PluginManagerConfigurable.this.myInstalledPanel);
                            PluginManagerConfigurable.clearUpdates(PluginManagerConfigurable.this.myInstalledSearchPanel.getPanel());
                        } else {
                            PluginManagerConfigurable.applyUpdates(PluginManagerConfigurable.this.myInstalledPanel, updates2);
                            PluginManagerConfigurable.applyUpdates(PluginManagerConfigurable.this.myInstalledSearchPanel.getPanel(), updates2);
                        }
                        selectionListener2.accept(PluginManagerConfigurable.this.myInstalledPanel);
                    });
                }
                finally {
                    PluginLogo.endBatchMode();
                }
                JComponent jComponent = PluginManagerConfigurable.createScrollPane(PluginManagerConfigurable.this.myInstalledPanel, true);
                if (jComponent == null) {
                    7.$$$reportNull$$$0(3);
                }
                return jComponent;
            }

            @Override
            protected void updateMainSelection(@NotNull Consumer<? super PluginsGroupComponent> selectionListener2) {
                if (selectionListener2 == null) {
                    7.$$$reportNull$$$0(4);
                }
                selectionListener2.accept(PluginManagerConfigurable.this.myInstalledPanel);
            }

            @Override
            public void hideSearchPanel() {
                super.hideSearchPanel();
                if (PluginManagerConfigurable.this.myInstalledSearchSetState) {
                    for (AnAction action2 : PluginManagerConfigurable.this.myInstalledSearchGroup.getChildren(null)) {
                        ((InstalledSearchOptionAction)action2).setState(null);
                    }
                }
                PluginManagerConfigurable.this.myPluginModel.setInvalidFixCallback(null);
            }

            @Override
            @NotNull
            protected SearchResultPanel createSearchPanel(final @NotNull Consumer<? super PluginsGroupComponent> selectionListener2) {
                if (selectionListener2 == null) {
                    7.$$$reportNull$$$0(5);
                }
                SearchUpDownPopupController installedController = new SearchUpDownPopupController(this.mySearchTextField){

                    @Override
                    @NotNull
                    @NonNls
                    protected List<String> getAttributes() {
                        List<String> list2 = Arrays.asList("/downloaded", "/outdated", "/enabled", "/disabled", "/invalid", "/bundled", SearchWords.ORGANIZATION.getValue(), SearchWords.TAG.getValue());
                        if (list2 == null) {
                            4.$$$reportNull$$$0(0);
                        }
                        return list2;
                    }

                    @Nullable
                    protected SortedSet<String> getValues(@NotNull String attribute) {
                        if (attribute == null) {
                            4.$$$reportNull$$$0(1);
                        }
                        return SearchWords.ORGANIZATION.getValue().equals(attribute) ? PluginManagerConfigurable.this.myPluginModel.getVendors() : (SearchWords.TAG.getValue().equals(attribute) ? PluginManagerConfigurable.this.myPluginModel.getTags() : null);
                    }

                    @Override
                    protected void showPopupForQuery() {
                        this.showSearchPanel(mySearchTextField.getText());
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        RuntimeException runtimeException;
                        Object[] objectArray;
                        Object[] objectArray2;
                        int n2;
                        String string;
                        switch (n) {
                            default: {
                                string = "@NotNull method %s.%s must not return null";
                                break;
                            }
                            case 1: {
                                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                n2 = 2;
                                break;
                            }
                            case 1: {
                                n2 = 3;
                                break;
                            }
                        }
                        Object[] objectArray3 = new Object[n2];
                        switch (n) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "com/intellij/ide/plugins/PluginManagerConfigurable$7$4";
                                break;
                            }
                            case 1: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "attribute";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[1] = "getAttributes";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[1] = "com/intellij/ide/plugins/PluginManagerConfigurable$7$4";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                break;
                            }
                            case 1: {
                                objectArray = objectArray;
                                objectArray[2] = "getValues";
                                break;
                            }
                        }
                        String string2 = String.format(string, objectArray);
                        switch (n) {
                            default: {
                                runtimeException = new IllegalStateException(string2);
                                break;
                            }
                            case 1: {
                                runtimeException = new IllegalArgumentException(string2);
                                break;
                            }
                        }
                        throw runtimeException;
                    }
                };
                MultiSelectionEventHandler eventHandler = new MultiSelectionEventHandler();
                installedController.setSearchResultEventHandler(eventHandler);
                PluginsGroupComponent panel2 = new PluginsGroupComponent(eventHandler){

                    @Override
                    @NotNull
                    protected ListPluginComponent createListComponent(@NotNull IdeaPluginDescriptor descriptor2) {
                        if (descriptor2 == null) {
                            5.$$$reportNull$$$0(0);
                        }
                        return new ListPluginComponent(PluginManagerConfigurable.this.myPluginModel, descriptor2, (LinkListener<Object>)mySearchListener, false);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/ide/plugins/PluginManagerConfigurable$7$5", "createListComponent"));
                    }
                };
                panel2.setSelectionListener(selectionListener2);
                PluginManagerConfigurable.registerCopyProvider(panel2);
                PluginManagerConfigurable.this.myInstalledSearchCallback = updateAction -> {
                    final ArrayList<String> queries = new ArrayList<String>();
                    new SearchQueryParser.Installed(this.mySearchTextField.getText(), (InstalledSearchOptionAction)((Object)updateAction)){
                        final /* synthetic */ InstalledSearchOptionAction val$updateAction;
                        {
                            this.val$updateAction = installedSearchOptionAction;
                            super(query2);
                        }

                        @Override
                        protected void addToSearchQuery(@NotNull String query2) {
                            if (query2 == null) {
                                6.$$$reportNull$$$0(0);
                            }
                            queries.add(query2);
                        }

                        @Override
                        protected void handleAttribute(@NotNull String name, @NotNull String value2) {
                            if (name == null) {
                                6.$$$reportNull$$$0(1);
                            }
                            if (value2 == null) {
                                6.$$$reportNull$$$0(2);
                            }
                            if (!this.val$updateAction.myState) {
                                queries.add(name + (value2.isEmpty() ? "" : SearchQueryParser.wrapAttribute(value2)));
                            }
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            Object[] objectArray;
                            Object[] objectArray2;
                            Object[] objectArray3 = new Object[3];
                            switch (n) {
                                default: {
                                    objectArray2 = objectArray3;
                                    objectArray3[0] = "query";
                                    break;
                                }
                                case 1: {
                                    objectArray2 = objectArray3;
                                    objectArray3[0] = "name";
                                    break;
                                }
                                case 2: {
                                    objectArray2 = objectArray3;
                                    objectArray3[0] = "value";
                                    break;
                                }
                            }
                            objectArray2[1] = "com/intellij/ide/plugins/PluginManagerConfigurable$7$6";
                            switch (n) {
                                default: {
                                    objectArray = objectArray2;
                                    objectArray2[2] = "addToSearchQuery";
                                    break;
                                }
                                case 1: 
                                case 2: {
                                    objectArray = objectArray2;
                                    objectArray2[2] = "handleAttribute";
                                    break;
                                }
                            }
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                        }
                    };
                    if (updateAction.myState) {
                        for (AnAction action2 : PluginManagerConfigurable.this.myInstalledSearchGroup.getChildren(null)) {
                            if (action2 == updateAction) continue;
                            ((InstalledSearchOptionAction)action2).myState = false;
                        }
                        queries.add(updateAction.getQuery());
                    } else {
                        queries.remove(updateAction.getQuery());
                    }
                    try {
                        PluginManagerConfigurable.this.myInstalledSearchSetState = false;
                        String query2 = StringUtil.join(queries, (String)" ");
                        this.mySearchTextField.setTextIgnoreEvents(query2);
                        if (query2.isEmpty()) {
                            PluginManagerConfigurable.this.myInstalledTab.hideSearchPanel();
                        } else {
                            PluginManagerConfigurable.this.myInstalledTab.showSearchPanel(query2);
                        }
                    }
                    finally {
                        PluginManagerConfigurable.this.myInstalledSearchSetState = true;
                    }
                };
                SearchResultPanel searchResultPanel = PluginManagerConfigurable.this.myInstalledSearchPanel = new SearchResultPanel(installedController, panel2, 0, 0){

                    @Override
                    protected void setEmptyText(@NotNull String query2) {
                        if (query2 == null) {
                            7.$$$reportNull$$$0(0);
                        }
                        this.myPanel.getEmptyText().setText(IdeBundle.message((String)"plugins.configurable.nothing.found", (Object[])new Object[0]));
                        if (query2.contains("/downloaded") || query2.contains("/outdated") || query2.contains("/enabled") || query2.contains("/disabled") || query2.contains("/invalid") || query2.contains("/bundled")) {
                            return;
                        }
                        this.myPanel.getEmptyText().appendSecondaryText(IdeBundle.message((String)"plugins.configurable.search.in.marketplace", (Object[])new Object[0]), SimpleTextAttributes.LINK_PLAIN_ATTRIBUTES, e -> PluginManagerConfigurable.this.myTabHeaderComponent.setSelectionWithEvents(0));
                    }

                    @Override
                    protected void handleQuery(@NotNull String query2, @NotNull PluginsGroup result2) {
                        if (query2 == null) {
                            7.$$$reportNull$$$0(1);
                        }
                        if (result2 == null) {
                            7.$$$reportNull$$$0(2);
                        }
                        PluginManagerConfigurable.this.myPluginModel.setInvalidFixCallback(null);
                        SearchQueryParser.Installed parser = new SearchQueryParser.Installed(query2);
                        if (PluginManagerConfigurable.this.myInstalledSearchSetState) {
                            for (AnAction action2 : PluginManagerConfigurable.this.myInstalledSearchGroup.getChildren(null)) {
                                ((InstalledSearchOptionAction)action2).setState(parser);
                            }
                        }
                        List<IdeaPluginDescriptor> descriptors2 = PluginManagerConfigurable.this.myPluginModel.getInstalledDescriptors();
                        if (!parser.vendors.isEmpty()) {
                            Iterator<IdeaPluginDescriptor> I = descriptors2.iterator();
                            while (I.hasNext()) {
                                if (MyPluginModel.isVendor(I.next(), parser.vendors)) continue;
                                I.remove();
                            }
                        }
                        if (!parser.tags.isEmpty()) {
                            Iterator<IdeaPluginDescriptor> I = descriptors2.iterator();
                            while (I.hasNext()) {
                                if (ContainerUtil.intersects(PluginManagerConfigurable.getTags(I.next()), parser.tags)) continue;
                                I.remove();
                            }
                        }
                        Iterator<IdeaPluginDescriptor> I = descriptors2.iterator();
                        while (I.hasNext()) {
                            IdeaPluginDescriptor descriptor2 = I.next();
                            if (parser.attributes) {
                                if (parser.enabled && (!PluginManagerConfigurable.this.myPluginModel.isEnabled(descriptor2) || PluginManagerConfigurable.this.myPluginModel.hasErrors(descriptor2))) {
                                    I.remove();
                                    continue;
                                }
                                if (parser.disabled && (PluginManagerConfigurable.this.myPluginModel.isEnabled(descriptor2) || PluginManagerConfigurable.this.myPluginModel.hasErrors(descriptor2))) {
                                    I.remove();
                                    continue;
                                }
                                if (parser.bundled && !descriptor2.isBundled()) {
                                    I.remove();
                                    continue;
                                }
                                if (parser.downloaded && descriptor2.isBundled()) {
                                    I.remove();
                                    continue;
                                }
                                if (parser.invalid && !PluginManagerConfigurable.this.myPluginModel.hasErrors(descriptor2)) {
                                    I.remove();
                                    continue;
                                }
                                if (parser.needUpdate && !PluginUpdatesService.isNeedUpdate(descriptor2)) {
                                    I.remove();
                                    continue;
                                }
                            }
                            if (parser.searchQuery == null || PluginManagerConfigurable.containsQuery(descriptor2, parser.searchQuery)) continue;
                            I.remove();
                        }
                        result2.descriptors.addAll(descriptors2);
                        if (!result2.descriptors.isEmpty()) {
                            if (parser.invalid) {
                                PluginManagerConfigurable.this.myPluginModel.setInvalidFixCallback(() -> {
                                    PluginsGroup group2 = PluginManagerConfigurable.this.myInstalledSearchPanel.getGroup();
                                    if (group2.ui == null) {
                                        PluginManagerConfigurable.this.myPluginModel.setInvalidFixCallback(null);
                                        return;
                                    }
                                    PluginsGroupComponent resultPanel = PluginManagerConfigurable.this.myInstalledSearchPanel.getPanel();
                                    for (IdeaPluginDescriptor descriptor2 : new ArrayList<IdeaPluginDescriptor>(group2.descriptors)) {
                                        if (PluginManagerConfigurable.this.myPluginModel.hasErrors(descriptor2)) continue;
                                        resultPanel.removeFromGroup(group2, descriptor2);
                                    }
                                    group2.titleWithCount();
                                    PluginManagerConfigurable.this.myInstalledSearchPanel.fullRepaint();
                                    if (group2.descriptors.isEmpty()) {
                                        PluginManagerConfigurable.this.myPluginModel.setInvalidFixCallback(null);
                                        PluginManagerConfigurable.this.myInstalledSearchPanel.removeGroup();
                                    }
                                });
                            } else if (parser.needUpdate) {
                                result2.rightAction = new LinkLabel(IdeBundle.message((String)"plugin.manager.update.all", (Object[])new Object[0]), null, (__, ___) -> {
                                    result2.rightAction.setEnabled(false);
                                    for (ListPluginComponent plugin2 : result2.ui.plugins) {
                                        plugin2.updatePlugin();
                                    }
                                });
                            }
                            Collection<IdeaPluginDescriptor> updates2 = PluginUpdatesService.getUpdates();
                            if (!ContainerUtil.isEmpty(updates2)) {
                                this.myPostFillGroupCallback = () -> {
                                    PluginManagerConfigurable.applyUpdates(this.myPanel, updates2);
                                    selectionListener2.accept(PluginManagerConfigurable.this.myInstalledPanel);
                                };
                            }
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2;
                        Object[] objectArray3 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "query";
                                break;
                            }
                            case 2: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "result";
                                break;
                            }
                        }
                        objectArray2[1] = "com/intellij/ide/plugins/PluginManagerConfigurable$7$7";
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[2] = "setEmptyText";
                                break;
                            }
                            case 1: 
                            case 2: {
                                objectArray = objectArray2;
                                objectArray2[2] = "handleQuery";
                                break;
                            }
                        }
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                };
                if (searchResultPanel == null) {
                    7.$$$reportNull$$$0(6);
                }
                return searchResultPanel;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 6: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 6: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "searchListener";
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/ide/plugins/PluginManagerConfigurable$7";
                        break;
                    }
                    case 2: 
                    case 4: 
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "selectionListener";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/ide/plugins/PluginManagerConfigurable$7";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createDetailsPanel";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createPluginsPanel";
                        break;
                    }
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createSearchPanel";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "createDetailsPanel";
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 6: {
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "createPluginsPanel";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray;
                        objectArray[2] = "updateMainSelection";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray;
                        objectArray[2] = "createSearchPanel";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 6: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        this.myPluginModel.setCancelInstallCallback(descriptor2 -> {
            if (this.myInstalledSearchPanel == null) {
                return;
            }
            PluginsGroup group2 = this.myInstalledSearchPanel.getGroup();
            if (group2.ui != null && group2.ui.findComponent((IdeaPluginDescriptor)descriptor2) != null) {
                this.myInstalledSearchPanel.getPanel().removeFromGroup(group2, (IdeaPluginDescriptor)descriptor2);
                group2.titleWithCount();
                this.myInstalledSearchPanel.fullRepaint();
                if (group2.descriptors.isEmpty()) {
                    this.myInstalledSearchPanel.removeGroup();
                }
            }
        });
    }

    private static boolean containsQuery(IdeaPluginDescriptor descriptor2, String searchQuery) {
        if (StringUtil.containsIgnoreCase((String)descriptor2.getName(), (String)searchQuery)) {
            return true;
        }
        String description = descriptor2.getDescription();
        return description != null && StringUtil.containsIgnoreCase((String)description, (String)searchQuery);
    }

    private static void clearUpdates(@NotNull PluginsGroupComponent panel2) {
        if (panel2 == null) {
            PluginManagerConfigurable.$$$reportNull$$$0(7);
        }
        for (UIPluginGroup group2 : panel2.getGroups()) {
            for (ListPluginComponent plugin2 : group2.plugins) {
                plugin2.setUpdateDescriptor(null);
            }
        }
    }

    private static void applyUpdates(@NotNull PluginsGroupComponent panel2, @NotNull Collection<? extends IdeaPluginDescriptor> updates2) {
        if (panel2 == null) {
            PluginManagerConfigurable.$$$reportNull$$$0(8);
        }
        if (updates2 == null) {
            PluginManagerConfigurable.$$$reportNull$$$0(9);
        }
        block0: for (IdeaPluginDescriptor ideaPluginDescriptor : updates2) {
            for (UIPluginGroup group2 : panel2.getGroups()) {
                ListPluginComponent component2 = group2.findComponent(ideaPluginDescriptor);
                if (component2 == null) continue;
                component2.setUpdateDescriptor(ideaPluginDescriptor);
                continue block0;
            }
        }
    }

    public static void registerCopyProvider(final @NotNull PluginsGroupComponent component2) {
        if (component2 == null) {
            PluginManagerConfigurable.$$$reportNull$$$0(10);
        }
        CopyProvider copyProvider = new CopyProvider(){

            public void performCopy(@NotNull DataContext dataContext) {
                if (dataContext == null) {
                    8.$$$reportNull$$$0(0);
                }
                String text2 = StringUtil.join(component2.getSelection(), pluginComponent -> {
                    IdeaPluginDescriptor descriptor2 = pluginComponent.getPluginDescriptor();
                    return String.format("%s (%s)", descriptor2.getName(), descriptor2.getVersion());
                }, (String)"\n");
                CopyPasteManager.getInstance().setContents((Transferable)new TextTransferable(text2));
            }

            public boolean isCopyEnabled(@NotNull DataContext dataContext) {
                if (dataContext == null) {
                    8.$$$reportNull$$$0(1);
                }
                return !component2.getSelection().isEmpty();
            }

            public boolean isCopyVisible(@NotNull DataContext dataContext) {
                if (dataContext == null) {
                    8.$$$reportNull$$$0(2);
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "dataContext";
                objectArray2[1] = "com/intellij/ide/plugins/PluginManagerConfigurable$8";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "performCopy";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isCopyEnabled";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isCopyVisible";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        DataManager.registerDataProvider((JComponent)((Object)component2), dataId -> PlatformDataKeys.COPY_PROVIDER.is(dataId) ? copyProvider : null);
    }

    @NotNull
    public static List<String> getTags(@NotNull IdeaPluginDescriptor plugin2) {
        if (plugin2 == null) {
            PluginManagerConfigurable.$$$reportNull$$$0(11);
        }
        List<String> tags = null;
        String productCode = plugin2.getProductCode();
        if (plugin2 instanceof PluginNode) {
            tags = ((PluginNode)plugin2).getTags();
            if (productCode != null) {
                if (LicensePanel.isEA2Product(productCode)) {
                    if (tags != null && tags.contains(Tags.Paid.name())) {
                        tags = new ArrayList<String>(tags);
                        tags.remove(Tags.Paid.name());
                    }
                } else {
                    if (tags == null) {
                        List<String> list2 = List.of(Tags.Paid.name());
                        if (list2 == null) {
                            PluginManagerConfigurable.$$$reportNull$$$0(12);
                        }
                        return list2;
                    }
                    if (!tags.contains(Tags.Paid.name())) {
                        tags = new ArrayList<String>(tags);
                        tags.add(Tags.Paid.name());
                    }
                }
            } else {
                if (!LicensePanel.isEA2Product(plugin2.getPluginId().getIdString()) && tags != null && tags.contains(Tags.Paid.name())) {
                    List<String> list3 = List.of(Tags.Paid.name());
                    if (list3 == null) {
                        PluginManagerConfigurable.$$$reportNull$$$0(13);
                    }
                    return list3;
                }
                tags = null;
            }
        } else if (productCode != null && !plugin2.isBundled() && !LicensePanel.isEA2Product(productCode)) {
            String stamp;
            LicensingFacade instance = LicensingFacade.getInstance();
            if (instance != null && (stamp = instance.getConfirmationStamp(productCode)) != null) {
                List<String> list4 = List.of(stamp.startsWith("eval:") ? Tags.Trial.name() : Tags.Purchased.name());
                if (list4 == null) {
                    PluginManagerConfigurable.$$$reportNull$$$0(14);
                }
                return list4;
            }
            List<String> list5 = List.of(Tags.Paid.name());
            if (list5 == null) {
                PluginManagerConfigurable.$$$reportNull$$$0(15);
            }
            return list5;
        }
        if (ContainerUtil.isEmpty(tags)) {
            List<String> list6 = List.of();
            if (list6 == null) {
                PluginManagerConfigurable.$$$reportNull$$$0(16);
            }
            return list6;
        }
        if (tags.size() > 1) {
            if ((tags = new ArrayList<String>(tags)).remove(Tags.EAP.name())) {
                tags.add(0, Tags.EAP.name());
            }
            if (tags.remove(Tags.Paid.name())) {
                tags.add(0, Tags.Paid.name());
            }
        }
        List<String> list7 = tags;
        if (list7 == null) {
            PluginManagerConfigurable.$$$reportNull$$$0(17);
        }
        return list7;
    }

    @NotNull
    public static <T extends Component> T setTinyFont(@NotNull T component2) {
        if (component2 == null) {
            PluginManagerConfigurable.$$$reportNull$$$0(18);
        }
        Object object = SystemInfo.isMac ? RelativeFont.TINY.install(component2) : component2;
        if (object == null) {
            PluginManagerConfigurable.$$$reportNull$$$0(19);
        }
        return object;
    }

    public static int offset5() {
        return JBUIScale.scale((int)5);
    }

    @Messages.YesNoResult
    public static int showRestartDialog() {
        return PluginManagerConfigurable.showRestartDialog(PluginManagerConfigurable.getUpdatesDialogTitle());
    }

    @Messages.YesNoResult
    public static int showRestartDialog(@NotNull @NlsContexts.DialogTitle String title2) {
        if (title2 == null) {
            PluginManagerConfigurable.$$$reportNull$$$0(20);
        }
        return PluginManagerConfigurable.showRestartDialog(title2, PluginManagerConfigurable::getUpdatesDialogMessage);
    }

    @Messages.YesNoResult
    public static int showRestartDialog(@NotNull @NlsContexts.DialogTitle String title2, @NotNull Function<? super String, @Nls String> message2) {
        if (title2 == null) {
            PluginManagerConfigurable.$$$reportNull$$$0(21);
        }
        if (message2 == null) {
            PluginManagerConfigurable.$$$reportNull$$$0(22);
        }
        String action2 = IdeBundle.message((String)(ApplicationManager.getApplication().isRestartCapable() ? "ide.restart.action" : "ide.shutdown.action"), (Object[])new Object[0]);
        return Messages.showYesNoDialog((String)message2.apply(action2), (String)title2, (String)action2, (String)IdeBundle.message((String)"ide.notnow.action", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon());
    }

    public static void shutdownOrRestartApp() {
        PluginManagerConfigurable.shutdownOrRestartApp(PluginManagerConfigurable.getUpdatesDialogTitle());
    }

    public static void shutdownOrRestartApp(@NotNull @NlsContexts.DialogTitle String title2) {
        if (title2 == null) {
            PluginManagerConfigurable.$$$reportNull$$$0(23);
        }
        PluginManagerConfigurable.shutdownOrRestartAppAfterInstall(title2, PluginManagerConfigurable::getUpdatesDialogMessage);
    }

    public static void shutdownOrRestartAppAfterInstall(@NotNull Function<? super String, @Nls String> message2) {
        if (message2 == null) {
            PluginManagerConfigurable.$$$reportNull$$$0(24);
        }
        PluginManagerConfigurable.shutdownOrRestartAppAfterInstall(PluginManagerConfigurable.getUpdatesDialogTitle(), message2);
    }

    static void shutdownOrRestartAppAfterInstall(@NotNull @NlsContexts.DialogTitle String title2, @NotNull Function<? super String, @Nls String> message2) {
        if (title2 == null) {
            PluginManagerConfigurable.$$$reportNull$$$0(25);
        }
        if (message2 == null) {
            PluginManagerConfigurable.$$$reportNull$$$0(26);
        }
        if (PluginManagerConfigurable.showRestartDialog(title2, message2) == 0) {
            ApplicationManagerEx.getApplicationEx().restart(true);
        }
    }

    @Nls
    @NotNull
    static String getUpdatesDialogTitle() {
        String string = IdeBundle.message((String)"updates.dialog.title", (Object[])new Object[]{ApplicationNamesInfo.getInstance().getFullProductName()});
        if (string == null) {
            PluginManagerConfigurable.$$$reportNull$$$0(27);
        }
        return string;
    }

    @Nls
    @NotNull
    static String getUpdatesDialogMessage(@Nls @NotNull String action2) {
        if (action2 == null) {
            PluginManagerConfigurable.$$$reportNull$$$0(28);
        }
        String string = IdeBundle.message((String)"ide.restart.required.message", (Object[])new Object[]{action2, ApplicationNamesInfo.getInstance().getFullProductName()});
        if (string == null) {
            PluginManagerConfigurable.$$$reportNull$$$0(29);
        }
        return string;
    }

    @Deprecated(since="2020.2", forRemoval=true)
    public static void showPluginConfigurable(@Nullable Project project, IdeaPluginDescriptor ... descriptors2) {
        if (descriptors2 == null) {
            PluginManagerConfigurable.$$$reportNull$$$0(30);
        }
        PluginManagerConfigurable.showPluginConfigurable(project, ContainerUtil.map((Object[])descriptors2, PluginDescriptor::getPluginId));
    }

    public static void showPluginConfigurable(@Nullable Project project, @NotNull Collection<PluginId> pluginIds2) {
        if (pluginIds2 == null) {
            PluginManagerConfigurable.$$$reportNull$$$0(31);
        }
        PluginManagerConfigurable configurable2 = new PluginManagerConfigurable(project);
        ShowSettingsUtil.getInstance().editConfigurable(project, (Configurable)configurable2, () -> configurable2.select(pluginIds2));
    }

    public static void showPluginConfigurable(@Nullable Component parent, @Nullable Project project, @NotNull Collection<PluginId> pluginIds2) {
        if (pluginIds2 == null) {
            PluginManagerConfigurable.$$$reportNull$$$0(32);
        }
        if (parent != null) {
            PluginManagerConfigurable configurable2 = new PluginManagerConfigurable(project);
            ShowSettingsUtil.getInstance().editConfigurable(parent, (Configurable)configurable2, () -> configurable2.select(pluginIds2));
        } else {
            PluginManagerConfigurable.showPluginConfigurable(project, pluginIds2);
        }
    }

    public static void showPluginConfigurableAndEnable(@Nullable Project project, @NotNull Set<? extends IdeaPluginDescriptor> descriptors2) {
        if (descriptors2 == null) {
            PluginManagerConfigurable.$$$reportNull$$$0(33);
        }
        PluginManagerConfigurable configurable2 = new PluginManagerConfigurable(project);
        ShowSettingsUtil.getInstance().editConfigurable(project, (Configurable)configurable2, () -> {
            configurable2.myPluginModel.enablePlugins(descriptors2);
            configurable2.select(descriptors2);
        });
    }

    @NotNull
    public static JComponent createScrollPane(@NotNull PluginsGroupComponent panel2, boolean initSelection) {
        if (panel2 == null) {
            PluginManagerConfigurable.$$$reportNull$$$0(34);
        }
        JBScrollPane pane2 = new JBScrollPane((Component)((Object)panel2), 20, 31);
        pane2.setBorder((Border)JBUI.Borders.empty());
        if (initSelection) {
            panel2.initialSelection();
        }
        JBScrollPane jBScrollPane = pane2;
        if (jBScrollPane == null) {
            PluginManagerConfigurable.$$$reportNull$$$0(35);
        }
        return jBScrollPane;
    }

    private void addGroup(@NotNull List<? super PluginsGroup> groups2, @NotNull @Nls String name, @NotNull String showAllQuery, @NotNull List<PluginNode> customPlugins, @NotNull Predicate<? super PluginsGroup> predicate2) {
        if (groups2 == null) {
            PluginManagerConfigurable.$$$reportNull$$$0(36);
        }
        if (name == null) {
            PluginManagerConfigurable.$$$reportNull$$$0(37);
        }
        if (showAllQuery == null) {
            PluginManagerConfigurable.$$$reportNull$$$0(38);
        }
        if (customPlugins == null) {
            PluginManagerConfigurable.$$$reportNull$$$0(39);
        }
        if (predicate2 == null) {
            PluginManagerConfigurable.$$$reportNull$$$0(40);
        }
        PluginsGroup group2 = new PluginsGroup(name);
        Iterator<PluginNode> iterator2 = customPlugins.iterator();
        for (int i2 = 0; iterator2.hasNext() && i2 < 9; ++i2) {
            group2.descriptors.add(iterator2.next());
        }
        if (predicate2.test(group2)) {
            group2.rightAction = new LinkLabel(IdeBundle.message((String)"plugins.configurable.show.all", (Object[])new Object[0]), null, this.myMarketplaceTab.mySearchListener, (Object)showAllQuery);
            group2.rightAction.setBorder((Border)JBUI.Borders.emptyRight((int)5));
        }
        if (!group2.descriptors.isEmpty()) {
            groups2.add(group2);
        }
    }

    private void addGroupViaLightDescriptor(@NotNull List<? super PluginsGroup> groups2, @NotNull @Nls String name, @NotNull @NonNls String query2, @NotNull @NonNls String showAllQuery) throws IOException {
        if (groups2 == null) {
            PluginManagerConfigurable.$$$reportNull$$$0(41);
        }
        if (name == null) {
            PluginManagerConfigurable.$$$reportNull$$$0(42);
        }
        if (query2 == null) {
            PluginManagerConfigurable.$$$reportNull$$$0(43);
        }
        if (showAllQuery == null) {
            PluginManagerConfigurable.$$$reportNull$$$0(44);
        }
        List<PluginNode> pluginNodes = MarketplaceRequests.getInstance().searchPlugins(query2, 18);
        this.addGroup(groups2, name, showAllQuery, pluginNodes, __ -> pluginNodes.size() >= 9);
    }

    @NotNull
    public String getHelpTopic() {
        return ID;
    }

    public void disposeUIResources() {
        InstalledPluginsState pluginsState = InstalledPluginsState.getInstance();
        if (this.myPluginModel.toBackground()) {
            pluginsState.clearShutdownCallback();
        }
        this.myMarketplaceTab.dispose();
        this.myInstalledTab.dispose();
        if (this.myMarketplacePanel != null) {
            this.myMarketplacePanel.dispose();
        }
        if (this.myMarketplaceSearchPanel != null) {
            this.myMarketplaceSearchPanel.dispose();
        }
        this.myPluginUpdatesService.dispose();
        PluginPriceService.cancel();
        pluginsState.runShutdownCallback();
        pluginsState.resetChangesAppliedWithoutRestart();
    }

    public void cancel() {
        this.myPluginModel.cancel(this.myCardPanel);
    }

    public boolean isModified() {
        return this.myPluginModel.isModified();
    }

    public void apply() throws ConfigurationException {
        if (this.myPluginModel.apply(this.myCardPanel)) {
            return;
        }
        if (this.myPluginModel.createShutdownCallback) {
            InstalledPluginsState.getInstance().setShutdownCallback(() -> ApplicationManager.getApplication().invokeLater(() -> PluginManagerConfigurable.shutdownOrRestartApp()));
        }
    }

    public void reset() {
        this.myPluginModel.clear(this.myCardPanel);
    }

    @Deprecated(since="2020.2", forRemoval=true)
    public void select(IdeaPluginDescriptor ... descriptors2) {
        if (descriptors2 == null) {
            PluginManagerConfigurable.$$$reportNull$$$0(45);
        }
        this.select(ContainerUtil.newHashSet((Object[])descriptors2));
    }

    private void select(@NotNull Set<? extends IdeaPluginDescriptor> descriptors2) {
        if (descriptors2 == null) {
            PluginManagerConfigurable.$$$reportNull$$$0(46);
        }
        this.select(ContainerUtil.map(descriptors2, PluginDescriptor::getPluginId));
    }

    private void select(@NotNull Collection<PluginId> pluginIds2) {
        if (pluginIds2 == null) {
            PluginManagerConfigurable.$$$reportNull$$$0(47);
        }
        this.updateSelectionTab(1);
        ArrayList<ListPluginComponent> components = new ArrayList<ListPluginComponent>();
        for (PluginId pluginId : pluginIds2) {
            ListPluginComponent component2 = this.findInstalledPluginById(pluginId);
            if (component2 == null) continue;
            components.add(component2);
        }
        if (!components.isEmpty()) {
            this.myInstalledPanel.setSelection(components);
        }
    }

    @Nullable
    public Runnable enableSearch(String option2) {
        if (this.myTabHeaderComponent == null) {
            this.myLaterSearchQuery = option2;
            return () -> {};
        }
        if (StringUtil.isEmpty((String)option2) && (this.myTabHeaderComponent.getSelectionTab() == 0 || this.myInstalledSearchPanel.isEmpty())) {
            return null;
        }
        return () -> {
            boolean marketplace = option2 != null && option2.startsWith(SearchWords.TAG.getValue());
            this.updateSelectionTab(marketplace ? 0 : 1);
            PluginsTab tab = marketplace ? this.myMarketplaceTab : this.myInstalledTab;
            tab.clearSearchPanel(option2);
            if (!StringUtil.isEmpty((String)option2)) {
                tab.showSearchPanel(option2);
            }
        };
    }

    private void updateSelectionTab(int tab) {
        if (this.myTabHeaderComponent.getSelectionTab() != tab) {
            this.myTabHeaderComponent.setSelectionWithEvents(tab);
        }
    }

    @NotNull
    private List<UIPluginGroup> getInstalledGroups() {
        List<UIPluginGroup> list2 = this.myInstalledPanel.getGroups();
        if (list2 == null) {
            PluginManagerConfigurable.$$$reportNull$$$0(48);
        }
        return list2;
    }

    @Nullable
    private ListPluginComponent findInstalledPluginById(@NotNull PluginId pluginId) {
        if (pluginId == null) {
            PluginManagerConfigurable.$$$reportNull$$$0(49);
        }
        for (UIPluginGroup group2 : this.getInstalledGroups()) {
            ListPluginComponent component2 = group2.findComponent(pluginId);
            if (component2 == null) continue;
            return component2;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 27: 
            case 29: 
            case 35: 
            case 48: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 27: 
            case 29: 
            case 35: 
            case 48: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "controller";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 27: 
            case 29: 
            case 35: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/plugins/PluginManagerConfigurable";
                break;
            }
            case 4: 
            case 10: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 5: 
            case 20: 
            case 21: 
            case 23: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 7: 
            case 8: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "panel";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updates";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "plugin";
                break;
            }
            case 22: 
            case 24: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 30: 
            case 33: 
            case 45: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
            case 31: 
            case 32: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginIds";
                break;
            }
            case 36: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groups";
                break;
            }
            case 37: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 38: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "showAllQuery";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "customPlugins";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "predicate";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "query";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/plugins/PluginManagerConfigurable";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getCenterComponent";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTopComponent";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createGearActions";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getTags";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "setTinyFont";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getUpdatesDialogTitle";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getUpdatesDialogMessage";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "createScrollPane";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstalledGroups";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getCenterComponent";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 27: 
            case 29: 
            case 35: 
            case 48: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "showRightBottomPopup";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "clearUpdates";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "applyUpdates";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "registerCopyProvider";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getTags";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "setTinyFont";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "showRestartDialog";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "shutdownOrRestartApp";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "shutdownOrRestartAppAfterInstall";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getUpdatesDialogMessage";
                break;
            }
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "showPluginConfigurable";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "showPluginConfigurableAndEnable";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "createScrollPane";
                break;
            }
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "addGroup";
                break;
            }
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "addGroupViaLightDescriptor";
                break;
            }
            case 45: 
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "select";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "findInstalledPluginById";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 27: 
            case 29: 
            case 35: 
            case 48: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private final class InstallFromDiskAction
    extends DumbAwareAction {
        private InstallFromDiskAction() {
            super(IdeBundle.messagePointer((String)"action.InstallFromDiskAction.text", (Object[])new Object[0]));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                InstallFromDiskAction.$$$reportNull$$$0(0);
            }
            PluginInstaller.chooseAndInstall(e.getProject(), PluginManagerConfigurable.this.myCardPanel, (file2, parent) -> PluginInstaller.installFromDisk(PluginManagerConfigurable.this.myPluginModel, PluginManagerConfigurable.this.myPluginModel, file2, parent, callbackData -> {
                ListPluginComponent component2;
                PluginManagerConfigurable.this.myPluginModel.pluginInstalledFromDisk((PluginInstallCallbackData)callbackData);
                boolean select2 = PluginManagerConfigurable.this.myInstalledPanel == null;
                PluginManagerConfigurable.this.updateSelectionTab(1);
                PluginManagerConfigurable.this.myInstalledTab.clearSearchPanel("");
                ListPluginComponent listPluginComponent = component2 = select2 ? PluginManagerConfigurable.this.findInstalledPluginById(callbackData.getPluginDescriptor().getPluginId()) : null;
                if (component2 != null) {
                    PluginManagerConfigurable.this.myInstalledPanel.setSelection(component2);
                }
            }));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/plugins/PluginManagerConfigurable$InstallFromDiskAction", "actionPerformed"));
        }
    }

    private final class ChangePluginStateAction
    extends DumbAwareAction {
        private final boolean myEnable;

        private ChangePluginStateAction(boolean enable2) {
            super(enable2 ? IdeBundle.message((String)"plugins.configurable.enable.all.downloaded", (Object[])new Object[0]) : IdeBundle.message((String)"plugins.configurable.disable.all.downloaded", (Object[])new Object[0]));
            this.myEnable = enable2;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                ChangePluginStateAction.$$$reportNull$$$0(0);
            }
            HashSet<IdeaPluginDescriptor> descriptors2 = new HashSet<IdeaPluginDescriptor>();
            PluginsGroup group2 = PluginManagerConfigurable.this.myPluginModel.getDownloadedGroup();
            if (group2 == null || group2.ui == null) {
                ApplicationInfoImpl appInfo = (ApplicationInfoImpl)ApplicationInfo.getInstance();
                for (IdeaPluginDescriptor descriptor2 : PluginManagerCore.getPlugins()) {
                    if (appInfo.isEssentialPlugin(descriptor2.getPluginId()) || descriptor2.isBundled() || descriptor2.isEnabled() == this.myEnable) continue;
                    descriptors2.add(descriptor2);
                }
            } else {
                for (ListPluginComponent component2 : group2.ui.plugins) {
                    IdeaPluginDescriptor plugin2 = component2.getPluginDescriptor();
                    if (PluginManagerConfigurable.this.myPluginModel.isEnabled(plugin2) == this.myEnable) continue;
                    descriptors2.add(plugin2);
                }
            }
            if (!descriptors2.isEmpty()) {
                PluginManagerConfigurable.this.myPluginModel.setEnabledState(descriptors2, PluginEnableDisableAction.globally(this.myEnable));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/plugins/PluginManagerConfigurable$ChangePluginStateAction", "actionPerformed"));
        }
    }

    private static class GroupByActionGroup
    extends DefaultActionGroup
    implements CheckedActionGroup {
        private GroupByActionGroup() {
        }
    }

    private final class InstalledSearchOptionAction
    extends ToggleAction
    implements DumbAware {
        private final InstalledSearchOption myOption;
        private boolean myState;

        private InstalledSearchOptionAction(InstalledSearchOption option2) {
            if (option2 == null) {
                InstalledSearchOptionAction.$$$reportNull$$$0(0);
            }
            super(option2.myPresentableNameSupplier);
            this.myOption = option2;
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            if (e == null) {
                InstalledSearchOptionAction.$$$reportNull$$$0(1);
            }
            return this.myState;
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            if (e == null) {
                InstalledSearchOptionAction.$$$reportNull$$$0(2);
            }
            this.myState = state;
            PluginManagerConfigurable.this.myInstalledSearchCallback.accept(this);
        }

        public void setState(@Nullable SearchQueryParser.Installed parser) {
            if (parser == null) {
                this.myState = false;
                return;
            }
            switch (this.myOption) {
                case Enabled: {
                    this.myState = parser.enabled;
                    break;
                }
                case Disabled: {
                    this.myState = parser.disabled;
                    break;
                }
                case Downloaded: {
                    this.myState = parser.downloaded;
                    break;
                }
                case Bundled: {
                    this.myState = parser.bundled;
                    break;
                }
                case Invalid: {
                    this.myState = parser.invalid;
                    break;
                }
                case NeedUpdate: {
                    this.myState = parser.needUpdate;
                }
            }
        }

        @NotNull
        public String getQuery() {
            Object object = this.myOption == InstalledSearchOption.NeedUpdate ? "/outdated" : "/" + StringUtil.decapitalize((String)this.myOption.name());
            if (object == null) {
                InstalledSearchOptionAction.$$$reportNull$$$0(3);
            }
            return object;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "option";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/plugins/PluginManagerConfigurable$InstalledSearchOptionAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/plugins/PluginManagerConfigurable$InstalledSearchOptionAction";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getQuery";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "isSelected";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "setSelected";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static enum InstalledSearchOption {
        Downloaded(IdeBundle.messagePointer((String)"plugins.configurable.InstalledSearchOption.Downloaded", (Object[])new Object[0])),
        NeedUpdate(IdeBundle.messagePointer((String)"plugins.configurable.InstalledSearchOption.NeedUpdate", (Object[])new Object[0])),
        Enabled(IdeBundle.messagePointer((String)"plugins.configurable.InstalledSearchOption.Enabled", (Object[])new Object[0])),
        Disabled(IdeBundle.messagePointer((String)"plugins.configurable.InstalledSearchOption.Disabled", (Object[])new Object[0])),
        Invalid(IdeBundle.messagePointer((String)"plugins.configurable.InstalledSearchOption.Invalid", (Object[])new Object[0])),
        Bundled(IdeBundle.messagePointer((String)"plugins.configurable.InstalledSearchOption.Bundled", (Object[])new Object[0]));

        private final Supplier<@Nls String> myPresentableNameSupplier;

        private InstalledSearchOption(Supplier<String> name) {
            this.myPresentableNameSupplier = name;
        }
    }

    private final class MarketplaceSortByAction
    extends ToggleAction
    implements DumbAware {
        private final SortBySearchOption myOption;
        private boolean myState;

        private MarketplaceSortByAction(SortBySearchOption option2) {
            if (option2 == null) {
                MarketplaceSortByAction.$$$reportNull$$$0(0);
            }
            super(option2.myPresentableNameSupplier);
            this.myOption = option2;
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            if (e == null) {
                MarketplaceSortByAction.$$$reportNull$$$0(1);
            }
            return this.myState;
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            if (e == null) {
                MarketplaceSortByAction.$$$reportNull$$$0(2);
            }
            this.myState = state;
            PluginManagerConfigurable.this.myMarketplaceSortByCallback.accept(this);
        }

        public void setState(@NotNull SearchQueryParser.Marketplace parser) {
            if (parser == null) {
                MarketplaceSortByAction.$$$reportNull$$$0(3);
            }
            if (this.myOption == SortBySearchOption.Relevance) {
                this.myState = parser.sortBy == null;
                this.getTemplatePresentation().setVisible(parser.sortBy == null || !parser.tags.isEmpty() || !parser.vendors.isEmpty() || parser.searchQuery != null);
            } else {
                this.myState = parser.sortBy != null && this.myOption.name().equalsIgnoreCase(parser.sortBy);
            }
        }

        @Nullable
        public String getQuery() {
            switch (this.myOption) {
                case Downloads: {
                    return "/sortBy:downloads";
                }
                case Name: {
                    return "/sortBy:name";
                }
                case Rating: {
                    return "/sortBy:rating";
                }
                case Updated: {
                    return "/sortBy:updated";
                }
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "option";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parser";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ide/plugins/PluginManagerConfigurable$MarketplaceSortByAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSelected";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setSelected";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setState";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static enum SortBySearchOption {
        Downloads(IdeBundle.messagePointer((String)"plugins.configurable.SortBySearchOption.Downloads", (Object[])new Object[0])),
        Name(IdeBundle.messagePointer((String)"plugins.configurable.SortBySearchOption.Name", (Object[])new Object[0])),
        Rating(IdeBundle.messagePointer((String)"plugins.configurable.SortBySearchOption.Rating", (Object[])new Object[0])),
        Relevance(IdeBundle.messagePointer((String)"plugins.configurable.SortBySearchOption.Relevance", (Object[])new Object[0])),
        Updated(IdeBundle.messagePointer((String)"plugins.configurable.SortBySearchOption.Updated", (Object[])new Object[0]));

        private final Supplier<@Nls String> myPresentableNameSupplier;

        private SortBySearchOption(Supplier<String> supplier2) {
            this.myPresentableNameSupplier = supplier2;
        }
    }
}

