/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.core.CoreBundle;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.IdeaPluginDescriptorImplKt;
import com.intellij.ide.plugins.PluginLoadingError;
import com.intellij.ide.plugins.PluginLoadingResult;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.util.PlatformUtils;
import com.intellij.util.text.VersionComparatorUtil;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B9\u0012\u001a\u0010\u0002\u001a\u0016\u0012\u0004\u0012\u00020\u0004\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00050\u0003\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0016\u0010!\u001a\u00020\u000b2\u0006\u0010\"\u001a\u00020\u00102\u0006\u0010#\u001a\u00020\u000bJ\u001f\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u00102\b\u0010'\u001a\u0004\u0018\u00010\u001cH\u0000\u00a2\u0006\u0002\b(J\u0018\u0010)\u001a\u00020%2\u0006\u0010\"\u001a\u00020\u00102\u0006\u0010*\u001a\u00020\u0004H\u0002J\u0006\u0010+\u001a\u00020,J\u0006\u0010-\u001a\u00020%J\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00100\u0012J\u0012\u0010/\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\b0\u0012J\u0019\u00100\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u001c0\u0003H\u0000\u00a2\u0006\u0002\b1J\u000e\u00102\u001a\u00020\u000b2\u0006\u0010*\u001a\u00020\u0004J\u0010\u00103\u001a\u00020\u000b2\u0006\u0010\"\u001a\u00020\u0010H\u0002J\u0018\u00104\u001a\u00020%2\u0006\u00105\u001a\u0002062\b\u00107\u001a\u0004\u0018\u000108J\u001d\u00109\u001a\u00020%2\u0006\u0010&\u001a\u00020\u00102\u0006\u0010'\u001a\u00020\u001cH\u0000\u00a2\u0006\u0002\b:R\"\u0010\u0002\u001a\u0016\u0012\u0004\u0012\u00020\u0004\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\r\u001a\u0016\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f\u0018\u00010\u000e8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000RJ\u0010\u0013\u001a>\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\u0006 \u0014*\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\b0\b \u0014*\u001e\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\u0006 \u0014*\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\b0\b\u0018\u00010\u00120\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0015\u001a\u00020\u000b8G\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u001c\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00100\u00198\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00100\u00198\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u001c0\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00100\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00040 8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006;"}, d2={"Lcom/intellij/ide/plugins/PluginLoadingResult;", "", "brokenPluginVersions", "", "Lcom/intellij/openapi/extensions/PluginId;", "", "", "productBuildNumber", "Ljava/util/function/Supplier;", "Lcom/intellij/openapi/util/BuildNumber;", "checkModuleDependencies", "", "(Ljava/util/Map;Ljava/util/function/Supplier;Z)V", "duplicateModuleMap", "", "", "Lcom/intellij/ide/plugins/IdeaPluginDescriptorImpl;", "enabledPlugins", "", "globalErrors", "kotlin.jvm.PlatformType", "hasPluginErrors", "getHasPluginErrors", "()Z", "idMap", "Ljava/util/concurrent/ConcurrentHashMap;", "incompletePlugins", "pluginErrors", "Lcom/intellij/ide/plugins/PluginLoadingError;", "plugins", "Ljava/util/HashMap;", "shadowedBundledIds", "Ljava/util/HashSet;", "add", "descriptor", "overrideUseIfCompatible", "addIncompletePlugin", "", "plugin", "error", "addIncompletePlugin$intellij_platform_core_impl", "checkAndAdd", "id", "enabledPluginCount", "", "finishLoading", "getEnabledPlugins", "getGlobalErrors", "getPluginErrors", "getPluginErrors$intellij_platform_core_impl", "isBroken", "isCompatible", "reportCannotLoad", "file", "Ljava/nio/file/Path;", "e", "", "reportIncompatiblePlugin", "reportIncompatiblePlugin$intellij_platform_core_impl", "intellij.platform.core.impl"})
@ApiStatus.Internal
public final class PluginLoadingResult {
    @JvmField
    @NotNull
    public final ConcurrentHashMap<PluginId, IdeaPluginDescriptorImpl> incompletePlugins;
    private final HashMap<PluginId, IdeaPluginDescriptorImpl> plugins;
    @JvmField
    @NotNull
    public final ConcurrentHashMap<PluginId, IdeaPluginDescriptorImpl> idMap;
    @JvmField
    @Nullable
    public Map<PluginId, List<IdeaPluginDescriptorImpl>> duplicateModuleMap;
    private final ConcurrentHashMap<PluginId, PluginLoadingError> pluginErrors;
    private final List<Supplier<String>> globalErrors;
    @JvmField
    @NotNull
    public final HashSet<PluginId> shadowedBundledIds;
    private List<IdeaPluginDescriptorImpl> enabledPlugins;
    private final Map<PluginId, Set<String>> brokenPluginVersions;
    @JvmField
    @NotNull
    public final Supplier<BuildNumber> productBuildNumber;
    private final boolean checkModuleDependencies;

    @TestOnly
    public final boolean getHasPluginErrors() {
        return !this.pluginErrors.isEmpty();
    }

    @NotNull
    public final List<IdeaPluginDescriptorImpl> getEnabledPlugins() {
        List<IdeaPluginDescriptorImpl> list2 = this.enabledPlugins;
        Intrinsics.checkNotNull(list2);
        return list2;
    }

    public final int enabledPluginCount() {
        return this.plugins.size();
    }

    public final void finishLoading() {
        Collection<IdeaPluginDescriptorImpl> collection = this.plugins.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"plugins.values");
        Collection<IdeaPluginDescriptorImpl> $this$toTypedArray$iv = collection;
        boolean $i$f$toTypedArray = false;
        Collection<IdeaPluginDescriptorImpl> thisCollection$iv = $this$toTypedArray$iv;
        IdeaPluginDescriptorImpl[] ideaPluginDescriptorImplArray = thisCollection$iv.toArray(new IdeaPluginDescriptorImpl[0]);
        if (ideaPluginDescriptorImplArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        IdeaPluginDescriptorImpl[] enabledPlugins = ideaPluginDescriptorImplArray;
        this.plugins.clear();
        Arrays.sort(enabledPlugins, Comparator.comparing(finishLoading.1.INSTANCE));
        this.enabledPlugins = Arrays.asList(Arrays.copyOf(enabledPlugins, enabledPlugins.length));
    }

    public final boolean isBroken(@NotNull PluginId id2) {
        Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
        Set<String> set2 = this.brokenPluginVersions.get(id2);
        if (set2 == null) {
            return false;
        }
        Set<String> set3 = set2;
        IdeaPluginDescriptorImpl descriptor2 = this.idMap.get(id2);
        return descriptor2 != null && set3.contains(descriptor2.getVersion());
    }

    @NotNull
    public final Map<PluginId, PluginLoadingError> getPluginErrors$intellij_platform_core_impl() {
        Map<PluginId, PluginLoadingError> map2 = Collections.unmodifiableMap((Map)this.pluginErrors);
        Intrinsics.checkNotNullExpressionValue(map2, (String)"Collections.unmodifiableMap(pluginErrors)");
        return map2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final List<Supplier<String>> getGlobalErrors() {
        List<Supplier<String>> list2 = this.globalErrors;
        Intrinsics.checkNotNullExpressionValue(list2, (String)"globalErrors");
        List<Supplier<String>> list3 = list2;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (list3) {
            boolean bl3 = false;
            List list4 = new ArrayList(this.globalErrors);
            return list4;
        }
    }

    public final void addIncompletePlugin$intellij_platform_core_impl(@NotNull IdeaPluginDescriptorImpl plugin2, @Nullable PluginLoadingError error2) {
        IdeaPluginDescriptorImpl existingIncompletePlugin;
        Intrinsics.checkNotNullParameter((Object)plugin2, (String)"plugin");
        if (!(this.idMap.containsKey(plugin2.getPluginId()) || (existingIncompletePlugin = this.incompletePlugins.get(plugin2.getPluginId())) != null && VersionComparatorUtil.compare((String)plugin2.getVersion(), (String)existingIncompletePlugin.getVersion()) <= 0)) {
            this.incompletePlugins.put(plugin2.getPluginId(), plugin2);
        }
        if (error2 != null) {
            this.pluginErrors.put(plugin2.getPluginId(), error2);
        }
    }

    public final void reportIncompatiblePlugin$intellij_platform_core_impl(@NotNull IdeaPluginDescriptorImpl plugin2, @NotNull PluginLoadingError error2) {
        Intrinsics.checkNotNullParameter((Object)plugin2, (String)"plugin");
        Intrinsics.checkNotNullParameter((Object)error2, (String)"error");
        if (!this.idMap.containsKey(plugin2.getPluginId())) {
            this.pluginErrors.put(plugin2.getPluginId(), error2);
        }
    }

    public final void reportCannotLoad(@NotNull Path file2, @Nullable Throwable e) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        PluginManagerCore.getLogger().warn("Cannot load " + file2, e);
        this.globalErrors.add(new Supplier(file2){
            final /* synthetic */ Path $file;

            @NotNull
            public final String get() {
                return CoreBundle.message((String)"plugin.loading.error.text.file.contains.invalid.plugin.descriptor", (Object[])new Object[]{IdeaPluginDescriptorImplKt.pluginPathToUserString(this.$file)});
            }
            {
                this.$file = path2;
            }
        });
    }

    public final boolean add(@NotNull IdeaPluginDescriptorImpl descriptor2, boolean overrideUseIfCompatible) {
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        PluginId pluginId = descriptor2.getPluginId();
        if (descriptor2.isIncomplete) {
            return true;
        }
        if (this.checkModuleDependencies && !descriptor2.isBundled() && descriptor2.packagePrefix == null && !PluginManagerCore.hasModuleDependencies(descriptor2)) {
            PluginLoadingError error2 = new PluginLoadingError(descriptor2, new Supplier(descriptor2){
                final /* synthetic */ IdeaPluginDescriptorImpl $descriptor;

                @NotNull
                public final String get() {
                    return CoreBundle.message((String)"plugin.loading.error.long.compatible.with.intellij.idea.only", (Object[])new Object[]{this.$descriptor.getName()});
                }
                {
                    this.$descriptor = ideaPluginDescriptorImpl;
                }
            }, add.error.2.INSTANCE, true, null, 16, null);
            this.addIncompletePlugin$intellij_platform_core_impl(descriptor2, error2);
            return false;
        }
        this.pluginErrors.remove(pluginId);
        this.incompletePlugins.remove(pluginId);
        IdeaPluginDescriptorImpl prevDescriptor = this.plugins.put(pluginId, descriptor2);
        if (prevDescriptor == null) {
            this.idMap.put(pluginId, descriptor2);
            for (PluginId module : descriptor2.modules) {
                this.checkAndAdd(descriptor2, module);
            }
            return true;
        }
        if (prevDescriptor.isBundled() || descriptor2.isBundled()) {
            this.shadowedBundledIds.add(pluginId);
        }
        if (this.isCompatible(descriptor2) && (overrideUseIfCompatible || VersionComparatorUtil.compare((String)descriptor2.getVersion(), (String)prevDescriptor.getVersion()) > 0)) {
            PluginManagerCore.getLogger().info(descriptor2.getPluginPath() + " overrides " + prevDescriptor.getPluginPath());
            this.idMap.put(pluginId, descriptor2);
            return true;
        }
        this.plugins.put(pluginId, prevDescriptor);
        return false;
    }

    private final boolean isCompatible(IdeaPluginDescriptorImpl descriptor2) {
        return PluginManagerCore.checkBuildNumberCompatibility(descriptor2, this.productBuildNumber.get()) == null;
    }

    private final void checkAndAdd(IdeaPluginDescriptorImpl descriptor2, PluginId id2) {
        Map<PluginId, List<IdeaPluginDescriptorImpl>> map2 = this.duplicateModuleMap;
        if (map2 != null && (map2 = map2.get(id2)) != null) {
            Map<PluginId, List<IdeaPluginDescriptorImpl>> map3 = map2;
            boolean bl = false;
            boolean bl2 = false;
            Map<PluginId, List<IdeaPluginDescriptorImpl>> duplicates = map3;
            boolean bl3 = false;
            duplicates.add(descriptor2);
            return;
        }
        IdeaPluginDescriptorImpl ideaPluginDescriptorImpl = this.idMap.put(id2, descriptor2);
        if (ideaPluginDescriptorImpl == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)ideaPluginDescriptorImpl, (String)"idMap.put(id, descriptor) ?: return");
        IdeaPluginDescriptorImpl existingDescriptor = ideaPluginDescriptorImpl;
        this.idMap.remove(id2);
        if (this.duplicateModuleMap == null) {
            this.duplicateModuleMap = new LinkedHashMap();
        }
        ArrayList<IdeaPluginDescriptorImpl> list2 = new ArrayList<IdeaPluginDescriptorImpl>(2);
        list2.add(existingDescriptor);
        list2.add(descriptor2);
        Map<PluginId, List<IdeaPluginDescriptorImpl>> map4 = this.duplicateModuleMap;
        Intrinsics.checkNotNull(map4);
        map4.put(id2, list2);
    }

    public PluginLoadingResult(@NotNull Map<PluginId, ? extends Set<String>> brokenPluginVersions, @NotNull Supplier<BuildNumber> productBuildNumber, boolean checkModuleDependencies) {
        Intrinsics.checkNotNullParameter(brokenPluginVersions, (String)"brokenPluginVersions");
        Intrinsics.checkNotNullParameter(productBuildNumber, (String)"productBuildNumber");
        this.brokenPluginVersions = brokenPluginVersions;
        this.productBuildNumber = productBuildNumber;
        this.checkModuleDependencies = checkModuleDependencies;
        this.incompletePlugins = new ConcurrentHashMap();
        this.plugins = new HashMap();
        this.idMap = new ConcurrentHashMap();
        this.pluginErrors = new ConcurrentHashMap();
        this.globalErrors = Collections.synchronizedList(new ArrayList());
        this.shadowedBundledIds = new HashSet();
    }

    public /* synthetic */ PluginLoadingResult(Map map2, Supplier supplier2, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl = !PlatformUtils.isIntelliJ();
        }
        this(map2, supplier2, bl);
    }
}

