/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.PluginEnabler;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.PropertyKey;

public enum PluginEnabledState {
    ENABLED{

        @Override
        @NotNull
        protected @PropertyKey(resourceBundle="messages.IdeBundle") String getPropertyKey() {
            return PluginEnabler.isPerProjectEnabled() ? "plugins.configurable.enabled.for.all.projects" : "plugins.configurable.enabled";
        }
    }
    ,
    ENABLED_FOR_PROJECT{

        @Override
        @NotNull
        protected @PropertyKey(resourceBundle="messages.IdeBundle") String getPropertyKey() {
            return "plugins.configurable.enabled.for.current.project";
        }
    }
    ,
    DISABLED{

        @Override
        @NotNull
        protected @PropertyKey(resourceBundle="messages.IdeBundle") String getPropertyKey() {
            return PluginEnabler.isPerProjectEnabled() ? "plugins.configurable.disabled.for.all.projects" : "plugins.configurable.disabled";
        }
    }
    ,
    DISABLED_FOR_PROJECT{

        @Override
        @NotNull
        protected @PropertyKey(resourceBundle="messages.IdeBundle") String getPropertyKey() {
            return "plugins.configurable.disabled.for.current.project";
        }
    };


    @NotNull
    protected abstract @PropertyKey(resourceBundle="messages.IdeBundle") String getPropertyKey();

    @NotNull
    @Nls
    public String getPresentableText() {
        String string = IdeBundle.message((String)this.getPropertyKey(), (Object[])new Object[0]);
        if (string == null) {
            PluginEnabledState.$$$reportNull$$$0(0);
        }
        return string;
    }

    public boolean isEnabled() {
        return this == ENABLED || this == ENABLED_FOR_PROJECT;
    }

    public boolean isDisabled() {
        return this == DISABLED || this == DISABLED_FOR_PROJECT;
    }

    public boolean isPerProject() {
        return this == ENABLED_FOR_PROJECT || this == DISABLED_FOR_PROJECT;
    }

    @NotNull
    public PluginEnabledState getInverted() {
        return PluginEnabledState.getState(this.isDisabled(), this.isPerProject());
    }

    @NotNull
    public static PluginEnabledState getState(boolean enabled, boolean perProject) {
        return perProject ? (enabled ? ENABLED_FOR_PROJECT : DISABLED_FOR_PROJECT) : PluginEnabledState.globally(enabled);
    }

    @NotNull
    public static PluginEnabledState globally(boolean enabled) {
        PluginEnabledState pluginEnabledState = enabled ? ENABLED : DISABLED;
        if (pluginEnabledState == null) {
            PluginEnabledState.$$$reportNull$$$0(1);
        }
        return pluginEnabledState;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/ide/plugins/PluginEnabledState";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "globally";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

