/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.PluginEnabledState;
import com.intellij.ide.plugins.PluginEnabler;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;

public enum PluginEnableDisableAction {
    ENABLE_GLOBALLY(PluginEnabledState.ENABLED, true){

        @Override
        @NotNull
        protected @PropertyKey(resourceBundle="messages.IdeBundle") String getPropertyKey() {
            return PluginEnabler.isPerProjectEnabled() ? "plugins.configurable.enable.for.all.projects" : "plugins.configurable.enable";
        }

        @Override
        public boolean isApplicable(@NotNull PluginEnabledState state) {
            if (state == null) {
                1.$$$reportNull$$$0(0);
            }
            return state != PluginEnabledState.ENABLED;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/ide/plugins/PluginEnableDisableAction$1", "isApplicable"));
        }
    }
    ,
    ENABLE_FOR_PROJECT(PluginEnabledState.ENABLED_FOR_PROJECT, true){

        @Override
        @NotNull
        protected @PropertyKey(resourceBundle="messages.IdeBundle") String getPropertyKey() {
            return "plugins.configurable.enable.for.current.project";
        }

        @Override
        public boolean isApplicable(@NotNull PluginEnabledState state) {
            if (state == null) {
                2.$$$reportNull$$$0(0);
            }
            return PluginEnabler.isPerProjectEnabled() && !state.isEnabled();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/ide/plugins/PluginEnableDisableAction$2", "isApplicable"));
        }
    }
    ,
    ENABLE_FOR_PROJECT_DISABLE_GLOBALLY(PluginEnabledState.ENABLED_FOR_PROJECT, false){

        @Override
        @NotNull
        protected @PropertyKey(resourceBundle="messages.IdeBundle") String getPropertyKey() {
            return "plugins.configurable.enable.for.current.project.only";
        }

        @Override
        public boolean isApplicable(@NotNull PluginEnabledState state) {
            if (state == null) {
                3.$$$reportNull$$$0(0);
            }
            return PluginEnabler.isPerProjectEnabled() && state == PluginEnabledState.ENABLED;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/ide/plugins/PluginEnableDisableAction$3", "isApplicable"));
        }
    }
    ,
    DISABLE_GLOBALLY(PluginEnabledState.DISABLED, false){

        @Override
        @NotNull
        protected @PropertyKey(resourceBundle="messages.IdeBundle") String getPropertyKey() {
            return PluginEnabler.isPerProjectEnabled() ? "plugins.configurable.disable.for.all.projects" : "plugins.configurable.disable";
        }

        @Override
        public boolean isApplicable(@NotNull PluginEnabledState state) {
            if (state == null) {
                4.$$$reportNull$$$0(0);
            }
            return state != PluginEnabledState.DISABLED;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/ide/plugins/PluginEnableDisableAction$4", "isApplicable"));
        }
    }
    ,
    DISABLE_FOR_PROJECT(PluginEnabledState.DISABLED_FOR_PROJECT, false){

        @Override
        @NotNull
        protected @PropertyKey(resourceBundle="messages.IdeBundle") String getPropertyKey() {
            return "plugins.configurable.disable.for.current.project";
        }

        @Override
        public boolean isApplicable(@NotNull PluginEnabledState state) {
            if (state == null) {
                5.$$$reportNull$$$0(0);
            }
            return PluginEnabler.isPerProjectEnabled() && state.isEnabled();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/ide/plugins/PluginEnableDisableAction$5", "isApplicable"));
        }
    }
    ,
    DISABLE_FOR_PROJECT_ENABLE_GLOBALLY(PluginEnabledState.DISABLED_FOR_PROJECT, true){

        @Override
        @NotNull
        protected @PropertyKey(resourceBundle="messages.IdeBundle") String getPropertyKey() {
            return "plugins.configurable.disable.for.current.project.only";
        }

        @Override
        public boolean isApplicable(@NotNull PluginEnabledState state) {
            if (state == null) {
                6.$$$reportNull$$$0(0);
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/ide/plugins/PluginEnableDisableAction$6", "isApplicable"));
        }
    };

    @NotNull
    private final PluginEnabledState myState;
    private final boolean myIsEnable;

    private PluginEnableDisableAction(PluginEnabledState state, boolean isEnable) {
        if (state == null) {
            PluginEnableDisableAction.$$$reportNull$$$0(0);
        }
        this.myState = state;
        this.myIsEnable = isEnable;
    }

    public abstract boolean isApplicable(@NotNull PluginEnabledState var1);

    @NotNull
    protected abstract @PropertyKey(resourceBundle="messages.IdeBundle") String getPropertyKey();

    @Nullable
    public PluginEnabledState apply(@NotNull PluginEnabledState state) {
        if (state == null) {
            PluginEnableDisableAction.$$$reportNull$$$0(1);
        }
        return this.isApplicable(state) ? this.myState : null;
    }

    public boolean isPerProject() {
        return this.myState.isPerProject();
    }

    public boolean isEnable() {
        return this.myIsEnable;
    }

    public boolean isDisable() {
        return !this.isEnable();
    }

    @NotNull
    @Nls
    public String getPresentableText() {
        String string = IdeBundle.message((String)this.getPropertyKey(), (Object[])new Object[0]);
        if (string == null) {
            PluginEnableDisableAction.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public static PluginEnableDisableAction globally(boolean enable2) {
        PluginEnableDisableAction pluginEnableDisableAction = enable2 ? ENABLE_GLOBALLY : DISABLE_GLOBALLY;
        if (pluginEnableDisableAction == null) {
            PluginEnableDisableAction.$$$reportNull$$$0(3);
        }
        return pluginEnableDisableAction;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/plugins/PluginEnableDisableAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/plugins/PluginEnableDisableAction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableText";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "globally";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "apply";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

