/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.ide.plugins.LanguagePluginDetectionStartupActivity;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginNode;
import com.intellij.ide.plugins.marketplace.FeatureImpl;
import com.intellij.ide.plugins.marketplace.MarketplaceRequests;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.Experiments;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.PluginsAdvertiser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.function.BiConsumer;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00072\u00020\u0001:\u0001\u0007B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/ide/plugins/LanguagePluginDetectionStartupActivity;", "Lcom/intellij/openapi/startup/StartupActivity$Background;", "()V", "runActivity", "", "project", "Lcom/intellij/openapi/project/Project;", "Companion", "intellij.platform.ide.impl"})
public final class LanguagePluginDetectionStartupActivity
implements StartupActivity.Background {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public void runActivity(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (!Experiments.getInstance().isFeatureEnabled("language.detect.notification")) {
            return;
        }
        PluginId pluginId = LanguagePluginDetectionStartupActivity.Companion.findLanguagePluginToInstall();
        if (pluginId == null) {
            return;
        }
        NotificationGroup notificationGroup = NotificationGroupManager.getInstance().getNotificationGroup("Language Plugins Notifications");
        Object[] objectArray = new Object[1];
        ApplicationInfo applicationInfo = ApplicationInfo.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)applicationInfo, (String)"ApplicationInfo.getInstance()");
        objectArray[0] = applicationInfo.getFullApplicationName();
        String string = ApplicationBundle.message((String)"notification.title.language.plugin.enable", (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ApplicationBundle.messag\u2026ce().fullApplicationName)");
        Notification notification = notificationGroup.createNotification(string, NotificationType.INFORMATION);
        NotificationAction action2 = LanguagePluginDetectionStartupActivity.Companion.createSwitchAndRestartAction(new BiConsumer(project, pluginId, notification){
            final /* synthetic */ Project $project;
            final /* synthetic */ PluginId $pluginId;
            final /* synthetic */ Notification $notification;

            public final void accept(@NotNull AnActionEvent $noName_0, @NotNull Notification $noName_1) {
                Intrinsics.checkNotNullParameter((Object)$noName_0, (String)"<anonymous parameter 0>");
                Intrinsics.checkNotNullParameter((Object)$noName_1, (String)"<anonymous parameter 1>");
                PluginsAdvertiser.installAndEnable$default(this.$project, SetsKt.setOf((Object)this.$pluginId), false, new Runnable(this){
                    final /* synthetic */ runActivity.action.1 this$0;

                    public final void run() {
                        this.this$0.$notification.expire();
                        ApplicationManagerEx.getApplicationEx().restart(true);
                    }
                    {
                        this.this$0 = var1_1;
                    }
                }, 4, null);
            }
            {
                this.$project = project;
                this.$pluginId = pluginId;
                this.$notification = notification;
            }
        });
        notification.addAction((AnAction)action2).notify(project);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J%\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u00052\u0016\u0010\u0006\u001a\u0012\u0012\u0006\b\u0000\u0012\u00020\b\u0012\u0006\b\u0000\u0012\u00020\t0\u0007H\u0002J\n\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0002J\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u00a8\u0006\u0011"}, d2={"Lcom/intellij/ide/plugins/LanguagePluginDetectionStartupActivity$Companion;", "", "()V", "createSwitchAndRestartAction", "Lcom/intellij/notification/NotificationAction;", "Lorg/jetbrains/annotations/NotNull;", "action", "Ljava/util/function/BiConsumer;", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "Lcom/intellij/notification/Notification;", "findLanguagePluginToInstall", "Lcom/intellij/openapi/extensions/PluginId;", "getLanguagePlugins", "", "Lcom/intellij/ide/plugins/marketplace/FeatureImpl;", "implementationName", "", "intellij.platform.ide.impl"})
    public static final class Companion {
        private final List<FeatureImpl> getLanguagePlugins(String implementationName) {
            return MarketplaceRequests.Companion.getInstance().getFeatures$intellij_platform_ide_impl("com.intellij.locale", implementationName);
        }

        private final NotificationAction createSwitchAndRestartAction(BiConsumer<? super AnActionEvent, ? super Notification> action2) {
            NotificationAction notificationAction = NotificationAction.create((String)ApplicationBundle.message((String)"notification.action.language.plugin.install.and.enable", (Object[])new Object[0]), action2);
            Intrinsics.checkNotNullExpressionValue((Object)notificationAction, (String)"NotificationAction.creat\u2026le\"),\n      action,\n    )");
            return notificationAction;
        }

        /*
         * WARNING - void declaration
         */
        private final PluginId findLanguagePluginToInstall() {
            Object v7;
            block8: {
                void $this$mapTo$iv$iv;
                List<FeatureImpl> list2;
                Locale locale = Locale.getDefault();
                String string = locale.toLanguageTag();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"locale.toLanguageTag()");
                List<FeatureImpl> list3 = this.getLanguagePlugins(string);
                boolean bl = false;
                if (list3.isEmpty()) {
                    boolean bl2 = false;
                    Locale locale2 = locale;
                    Intrinsics.checkNotNullExpressionValue((Object)locale2, (String)"locale");
                    String string2 = locale2.getLanguage();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"locale.language");
                    list2 = Companion.getLanguagePlugins(string2);
                } else {
                    list2 = list3;
                }
                List matchedLanguagePlugins = list2;
                Iterable $this$map$iv = MarketplaceRequests.Companion.getInstance().searchPlugins("tags=Language%20Pack", 10);
                boolean $i$f$map = false;
                Iterable bl2 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    PluginNode pluginNode = (PluginNode)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl3 = false;
                    PluginId pluginId = it.getPluginId();
                    collection.add(pluginId);
                }
                Iterable $this$firstOrNull$iv = (List)destination$iv$iv;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    boolean bl4;
                    PluginId pluginId;
                    block7: {
                        pluginId = (PluginId)element$iv;
                        boolean bl5 = false;
                        Iterable $this$any$iv = matchedLanguagePlugins;
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl4 = false;
                        } else {
                            for (Object element$iv2 : $this$any$iv) {
                                FeatureImpl it = (FeatureImpl)element$iv2;
                                boolean bl6 = false;
                                String string3 = it.getPluginId();
                                PluginId pluginId2 = pluginId;
                                Intrinsics.checkNotNullExpressionValue((Object)pluginId2, (String)"pluginId");
                                if (!Intrinsics.areEqual((Object)string3, (Object)pluginId2.getIdString())) continue;
                                bl4 = true;
                                break block7;
                            }
                            bl4 = false;
                        }
                    }
                    if (!(bl4 && !PluginManagerCore.isPluginInstalled(pluginId))) continue;
                    v7 = element$iv;
                    break block8;
                }
                v7 = null;
            }
            return v7;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

