/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.ide.plugins.ClassLoaderTreeCheckerKt;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.PluginContentDescriptor;
import com.intellij.ide.plugins.PluginDependency;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginSet;
import com.intellij.ide.plugins.cl.PluginClassLoader;
import com.intellij.util.containers.WeakList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0003H\u0002J\u0010\u0010\u000b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0003H\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/ide/plugins/ClassLoaderTreeChecker;", "", "unloadedMainDescriptor", "Lcom/intellij/ide/plugins/IdeaPluginDescriptorImpl;", "classLoaders", "Lcom/intellij/util/containers/WeakList;", "Lcom/intellij/ide/plugins/cl/PluginClassLoader;", "(Lcom/intellij/ide/plugins/IdeaPluginDescriptorImpl;Lcom/intellij/util/containers/WeakList;)V", "checkThatClassLoaderNotReferencedByPluginClassLoader", "", "descriptor", "checkThatClassloaderNotReferenced", "intellij.platform.ide.impl"})
public final class ClassLoaderTreeChecker {
    private final IdeaPluginDescriptorImpl unloadedMainDescriptor;
    private final WeakList<PluginClassLoader> classLoaders;

    public final void checkThatClassLoaderNotReferencedByPluginClassLoader() {
        if (!(this.unloadedMainDescriptor.classLoader instanceof PluginClassLoader)) {
            return;
        }
        PluginSet pluginSet = PluginManagerCore.getPluginSet();
        Intrinsics.checkNotNullExpressionValue((Object)pluginSet, (String)"PluginManagerCore.getPluginSet()");
        PluginSet pluginSet2 = pluginSet;
        for (IdeaPluginDescriptorImpl ideaPluginDescriptorImpl : pluginSet2.enabledPlugins) {
            this.checkThatClassLoaderNotReferencedByPluginClassLoader(ideaPluginDescriptorImpl);
        }
        for (PluginContentDescriptor.ModuleItem moduleItem : pluginSet2.getUnsortedEnabledModules()) {
            this.checkThatClassloaderNotReferenced(moduleItem.requireDescriptor());
        }
    }

    private final void checkThatClassLoaderNotReferencedByPluginClassLoader(IdeaPluginDescriptorImpl descriptor2) {
        this.checkThatClassloaderNotReferenced(descriptor2);
        for (PluginDependency dependency : descriptor2.pluginDependencies) {
            IdeaPluginDescriptorImpl ideaPluginDescriptorImpl = dependency.subDescriptor;
            if (ideaPluginDescriptorImpl == null) {
                continue;
            }
            this.checkThatClassLoaderNotReferencedByPluginClassLoader(ideaPluginDescriptorImpl);
        }
    }

    private final void checkThatClassloaderNotReferenced(IdeaPluginDescriptorImpl descriptor2) {
        ClassLoader classLoader = descriptor2.classLoader;
        if (!(classLoader instanceof PluginClassLoader)) {
            classLoader = null;
        }
        PluginClassLoader pluginClassLoader = (PluginClassLoader)((Object)classLoader);
        if (pluginClassLoader == null) {
            return;
        }
        PluginClassLoader classLoader2 = pluginClassLoader;
        if (descriptor2 != this.unloadedMainDescriptor) {
            if (this.classLoaders.contains((Object)classLoader2)) {
                ClassLoaderTreeCheckerKt.access$getLOG$p().error((Object)((Object)classLoader2) + " must be unloaded but still referenced");
            }
            if (classLoader2.getPluginDescriptor() == descriptor2 && Intrinsics.areEqual((Object)classLoader2.getPluginId(), (Object)this.unloadedMainDescriptor.getPluginId())) {
                ClassLoaderTreeCheckerKt.access$getLOG$p().error("Classloader of " + descriptor2 + " must be nullified");
            }
        }
        List<IdeaPluginDescriptorImpl> list2 = classLoader2._getParents();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"classLoader._getParents()");
        List<IdeaPluginDescriptorImpl> parents2 = list2;
        for (PluginClassLoader unloadedClassLoader : this.classLoaders) {
            boolean bl;
            block10: {
                Iterable $this$any$iv = parents2;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        IdeaPluginDescriptorImpl it = (IdeaPluginDescriptorImpl)element$iv;
                        boolean bl2 = false;
                        if (!(it.classLoader == unloadedClassLoader)) continue;
                        bl = true;
                        break block10;
                    }
                    bl = false;
                }
            }
            if (!bl) continue;
            ClassLoaderTreeCheckerKt.access$getLOG$p().error((Object)((Object)classLoader2) + " references via parents " + (Object)((Object)unloadedClassLoader) + " that must be unloaded");
        }
        Iterator<IdeaPluginDescriptorImpl> iterator2 = parents2.iterator();
        while (iterator2.hasNext()) {
            IdeaPluginDescriptorImpl parent;
            IdeaPluginDescriptorImpl ideaPluginDescriptorImpl = parent = iterator2.next();
            Intrinsics.checkNotNullExpressionValue((Object)ideaPluginDescriptorImpl, (String)"parent");
            if (!Intrinsics.areEqual((Object)ideaPluginDescriptorImpl.getPluginId(), (Object)this.unloadedMainDescriptor.getPluginId())) continue;
            ClassLoaderTreeCheckerKt.access$getLOG$p().error((Object)((Object)classLoader2) + " references via parents " + parent + " that must be unloaded");
        }
    }

    public ClassLoaderTreeChecker(@NotNull IdeaPluginDescriptorImpl unloadedMainDescriptor, @NotNull WeakList<PluginClassLoader> classLoaders) {
        Intrinsics.checkNotNullParameter((Object)unloadedMainDescriptor, (String)"unloadedMainDescriptor");
        Intrinsics.checkNotNullParameter(classLoaders, (String)"classLoaders");
        this.unloadedMainDescriptor = unloadedMainDescriptor;
        this.classLoaders = classLoaders;
    }
}

