/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.navigationToolbar;

import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.ide.CopyPasteDelegator;
import com.intellij.ide.CopyPasteSupport;
import com.intellij.ide.DataManager;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.IdeView;
import com.intellij.ide.dnd.DnDDragStartBean;
import com.intellij.ide.dnd.DnDSupport;
import com.intellij.ide.dnd.TransferableWrapper;
import com.intellij.ide.navigationToolbar.NavBarIdeView;
import com.intellij.ide.navigationToolbar.NavBarItem;
import com.intellij.ide.navigationToolbar.NavBarListener;
import com.intellij.ide.navigationToolbar.NavBarModel;
import com.intellij.ide.navigationToolbar.NavBarModelExtension;
import com.intellij.ide.navigationToolbar.NavBarPopup;
import com.intellij.ide.navigationToolbar.NavBarPresentation;
import com.intellij.ide.navigationToolbar.NavBarRootPaneExtension;
import com.intellij.ide.navigationToolbar.NavBarUpdateQueue;
import com.intellij.ide.navigationToolbar.ui.NavBarUI;
import com.intellij.ide.navigationToolbar.ui.NavBarUIManager;
import com.intellij.ide.projectView.ProjectView;
import com.intellij.ide.projectView.impl.AbstractProjectViewPane;
import com.intellij.ide.projectView.impl.ProjectRootsUtil;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.customization.CustomActionsSchema;
import com.intellij.ide.util.DeleteHandler;
import com.intellij.internal.statistic.service.fus.collectors.UIEventLogger;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.actions.ModuleDeleteProvider;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.AsyncResult;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDirectoryContainer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.Gray;
import com.intellij.ui.HintHint;
import com.intellij.ui.LightweightHint;
import com.intellij.ui.ListenerUtil;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.PopupMenuListenerAdapter;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBList;
import com.intellij.ui.popup.AbstractPopup;
import com.intellij.ui.popup.PopupOwner;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.accessibility.AccessibleContextUtil;
import com.intellij.util.ui.accessibility.ScreenReader;
import java.awt.AWTEventMulticaster;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.border.LineBorder;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.PanelUI;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NavBarPanel
extends JPanel
implements DataProvider,
PopupOwner,
Disposable,
Queryable {
    private final NavBarModel myModel;
    private final NavBarPresentation myPresentation;
    protected final Project myProject;
    private final ArrayList<NavBarItem> myList;
    private final IdeView myIdeView;
    private FocusListener myNavBarItemFocusListener;
    private LightweightHint myHint;
    private NavBarPopup myNodePopup;
    private JComponent myHintContainer;
    private Component myContextComponent;
    private final NavBarUpdateQueue myUpdateQueue;
    private final Set<PsiFile> myForcedFileUpdateQueue;
    private NavBarItem myContextObject;
    private boolean myDisposed;
    private RelativePoint myLocationCache;

    public NavBarPanel(@NotNull Project project, boolean docked) {
        if (project == null) {
            NavBarPanel.$$$reportNull$$$0(0);
        }
        super(new FlowLayout(0, 0, 0));
        this.myList = new ArrayList();
        this.myHint = null;
        this.myNodePopup = null;
        this.myForcedFileUpdateQueue = new HashSet<PsiFile>();
        this.myDisposed = false;
        this.myProject = project;
        this.myModel = this.createModel();
        this.myIdeView = new NavBarIdeView(this);
        this.myPresentation = new NavBarPresentation(this.myProject);
        this.myUpdateQueue = new NavBarUpdateQueue(this);
        this.installPopupHandler(this, -1);
        this.setOpaque(false);
        if (!docked && StartupUiUtil.isUnderDarcula()) {
            this.setBorder(new LineBorder((Color)Gray._120, 1));
        }
        this.myUpdateQueue.queueModelUpdateFromFocus();
        this.myUpdateQueue.queueRebuildUi();
        Disposer.register((Disposable)project, (Disposable)this);
        AccessibleContextUtil.setName((Component)this, (String)IdeBundle.message((String)"navigation.bar", (Object[])new Object[0]));
    }

    protected boolean allowNavItemsFocus() {
        return ScreenReader.isActive();
    }

    public boolean isFocused() {
        if (this.allowNavItemsFocus()) {
            return UIUtil.isFocusAncestor((Component)this);
        }
        return this.hasFocus();
    }

    public void addNavBarItemFocusListener(@Nullable FocusListener l) {
        if (l == null) {
            return;
        }
        this.myNavBarItemFocusListener = AWTEventMulticaster.add(this.myNavBarItemFocusListener, l);
    }

    public void removeNavBarItemFocusListener(@Nullable FocusListener l) {
        if (l == null) {
            return;
        }
        this.myNavBarItemFocusListener = AWTEventMulticaster.remove(this.myNavBarItemFocusListener, l);
    }

    protected void fireNavBarItemFocusGained(FocusEvent e) {
        FocusListener listener2 = this.myNavBarItemFocusListener;
        if (listener2 != null) {
            listener2.focusGained(e);
        }
    }

    protected void fireNavBarItemFocusLost(FocusEvent e) {
        FocusListener listener2 = this.myNavBarItemFocusListener;
        if (listener2 != null) {
            listener2.focusLost(e);
        }
    }

    protected NavBarModel createModel() {
        return new NavBarModel(this.myProject);
    }

    @Nullable
    public NavBarPopup getNodePopup() {
        return this.myNodePopup;
    }

    public boolean isNodePopupActive() {
        return this.myNodePopup != null && this.myNodePopup.isVisible();
    }

    public LightweightHint getHint() {
        return this.myHint;
    }

    public NavBarPresentation getPresentation() {
        return this.myPresentation;
    }

    public void setContextComponent(@Nullable Component contextComponent) {
        this.myContextComponent = contextComponent;
    }

    public NavBarItem getContextObject() {
        return this.myContextObject;
    }

    public List<NavBarItem> getItems() {
        return Collections.unmodifiableList(this.myList);
    }

    public void addItem(NavBarItem item) {
        this.myList.add(item);
    }

    public void clearItems() {
        NavBarItem[] toDispose = this.myList.toArray(new NavBarItem[0]);
        this.myList.clear();
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            for (NavBarItem item : toDispose) {
                Disposer.dispose((Disposable)item);
            }
        });
        this.getNavBarUI().clearItems();
    }

    @Override
    public void setUI(PanelUI ui2) {
        this.getNavBarUI().clearItems();
        super.setUI(ui2);
    }

    public NavBarUpdateQueue getUpdateQueue() {
        return this.myUpdateQueue;
    }

    public void escape() {
        this.myModel.setSelectedIndex(-1);
        this.hideHint();
        ToolWindowManager.getInstance((Project)this.myProject).activateEditorComponent();
    }

    public void enter() {
        int index2 = this.myModel.getSelectedIndex();
        if (index2 != -1) {
            this.ctrlClick(index2);
        }
    }

    public void moveHome() {
        this.shiftFocus(-this.myModel.getSelectedIndex());
    }

    public void navigate() {
        if (this.myModel.getSelectedIndex() != -1) {
            this.doubleClick(this.myModel.getSelectedIndex());
        }
    }

    public void moveDown() {
        int index2 = this.myModel.getSelectedIndex();
        if (index2 != -1) {
            if (this.myModel.size() - 1 == index2) {
                this.shiftFocus(-1);
                this.ctrlClick(index2 - 1);
            } else {
                this.ctrlClick(index2);
            }
        }
    }

    public void moveEnd() {
        this.shiftFocus(this.myModel.size() - 1 - this.myModel.getSelectedIndex());
    }

    public Project getProject() {
        return this.myProject;
    }

    public NavBarModel getModel() {
        return this.myModel;
    }

    public void dispose() {
        this.cancelPopup();
        this.getNavBarUI().clearItems();
        this.myDisposed = true;
        NavBarListener.unsubscribeFrom(this);
    }

    public boolean isDisposed() {
        return this.myDisposed;
    }

    boolean isSelectedInPopup(Object object) {
        return this.isNodePopupActive() && this.myNodePopup.getList().getSelectedValuesList().contains(object);
    }

    static Object expandDirsWithJustOneSubdir(Object target2) {
        if (target2 instanceof PsiElement && !((PsiElement)target2).isValid()) {
            return target2;
        }
        if (target2 instanceof PsiDirectory) {
            PsiDirectory directory = (PsiDirectory)target2;
            VirtualFile file2 = directory.getVirtualFile();
            while (true) {
                VirtualFile next;
                VirtualFile[] children2;
                VirtualFile child2 = (children2 = file2.getChildren()).length == 1 ? children2[0] : null;
                VirtualFile virtualFile2 = next = child2 != null && child2.isDirectory() && !child2.is(VFileProperty.SYMLINK) ? child2 : null;
                if (next == null) {
                    return ObjectUtils.notNull((Object)directory.getManager().findDirectory(file2), (Object)directory);
                }
                file2 = next;
            }
        }
        return target2;
    }

    protected void updateItems() {
        NavBarRootPaneExtension.NavBarWrapperPanel wrapperPanel;
        for (NavBarItem item : new ArrayList<NavBarItem>(this.myList)) {
            item.update();
        }
        if (UISettings.getInstance().getShowNavigationBar() && (wrapperPanel = (NavBarRootPaneExtension.NavBarWrapperPanel)ComponentUtil.getParentOfType(NavBarRootPaneExtension.NavBarWrapperPanel.class, (Component)this)) != null) {
            wrapperPanel.revalidate();
            wrapperPanel.repaint();
        }
    }

    public void rebuildAndSelectItem(Function<? super List<NavBarItem>, Integer> indexToSelectCallback, boolean showPopup) {
        this.myUpdateQueue.queueModelUpdateFromFocus();
        this.myUpdateQueue.queueRebuildUi();
        this.myUpdateQueue.queueSelect(() -> {
            if (!this.myList.isEmpty()) {
                int index2 = (Integer)indexToSelectCallback.apply(this.myList);
                this.myModel.setSelectedIndex(index2);
                this.requestSelectedItemFocus();
                if (showPopup) {
                    this.ctrlClick(index2);
                }
            }
        });
        this.myUpdateQueue.flush();
    }

    public void rebuildAndSelectTail(boolean requestFocus) {
        this.rebuildAndSelectItem(list2 -> list2.size() - 1, false);
    }

    public void requestSelectedItemFocus() {
        int index2 = this.myModel.getSelectedIndex();
        if (index2 >= 0 && index2 < this.myModel.size() && this.allowNavItemsFocus()) {
            IdeFocusManager.getInstance((Project)this.myProject).requestFocus((Component)((Object)this.getItem(index2)), true);
        } else {
            IdeFocusManager.getInstance((Project)this.myProject).requestFocus((Component)this, true);
        }
    }

    public void moveLeft() {
        this.shiftFocus(-1);
    }

    public void moveRight() {
        this.shiftFocus(1);
    }

    void shiftFocus(int direction) {
        int selectedIndex = this.myModel.getSelectedIndex();
        int index2 = this.myModel.getIndexByModel(selectedIndex + direction);
        this.myModel.setSelectedIndex(index2);
        if (this.allowNavItemsFocus()) {
            this.requestSelectedItemFocus();
        }
    }

    protected void scrollSelectionToVisible() {
        int selectedIndex = this.myModel.getSelectedIndex();
        if (selectedIndex == -1 || selectedIndex >= this.myList.size()) {
            return;
        }
        this.scrollRectToVisible(this.myList.get(selectedIndex).getBounds());
    }

    @Nullable
    private NavBarItem getItem(int index2) {
        if (index2 != -1 && index2 < this.myList.size()) {
            return this.myList.get(index2);
        }
        return null;
    }

    public boolean isInFloatingMode() {
        return this.myHint != null && this.myHint.isVisible();
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.myDisposed || !this.myList.isEmpty()) {
            return super.getPreferredSize();
        }
        NavBarItem item = new NavBarItem(this, null, 0, null);
        Dimension size = item.getPreferredSize();
        ApplicationManager.getApplication().executeOnPooledThread(() -> Disposer.dispose((Disposable)item));
        return size;
    }

    public boolean isRebuildUiNeeded() {
        this.myModel.revalidate();
        if (this.myList.size() == this.myModel.size()) {
            int index2 = 0;
            for (NavBarItem eachLabel : this.myList) {
                Object eachElement = this.myModel.get(index2);
                if (eachLabel.getObject() == null || !eachLabel.getObject().equals(eachElement)) {
                    return true;
                }
                if (eachLabel.getObject() instanceof PsiFile && this.myForcedFileUpdateQueue.remove(eachLabel.getObject())) {
                    return true;
                }
                if (!StringUtil.equals((CharSequence)eachLabel.getText(), (CharSequence)this.getPresentation().getPresentableText(eachElement, false))) {
                    return true;
                }
                if (!Objects.equals(eachLabel.getIcon(), this.getPresentation().getIcon(eachElement))) {
                    return true;
                }
                SimpleTextAttributes modelAttributes1 = this.myPresentation.getTextAttributes(eachElement, true);
                SimpleTextAttributes modelAttributes2 = this.myPresentation.getTextAttributes(eachElement, false);
                SimpleTextAttributes labelAttributes = eachLabel.getAttributes();
                if (!modelAttributes1.toTextAttributes().equals((Object)labelAttributes.toTextAttributes()) && !modelAttributes2.toTextAttributes().equals((Object)labelAttributes.toTextAttributes())) {
                    return true;
                }
                ++index2;
            }
            return false;
        }
        return true;
    }

    void installPopupHandler(final @NotNull JComponent component2, final int index2) {
        if (component2 == null) {
            NavBarPanel.$$$reportNull$$$0(1);
        }
        component2.addMouseListener((MouseListener)new PopupHandler(){

            public void invokePopup(Component comp, int x, int y) {
                ActionGroup actionGroup2 = new ActionGroup(){

                    public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
                        ActionGroup group2;
                        NavBarModelExtension modelExtension;
                        if (e == null) {
                            if (EMPTY_ARRAY == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            return EMPTY_ARRAY;
                        }
                        String popupGroupId = null;
                        Iterator iterator2 = NavBarModelExtension.EP_NAME.getExtensionList().iterator();
                        while (iterator2.hasNext() && (popupGroupId = (modelExtension = (NavBarModelExtension)iterator2.next()).getPopupMenuGroup(NavBarPanel.this)) == null) {
                        }
                        if (popupGroupId == null) {
                            popupGroupId = "NavbarPopupMenu";
                        }
                        AnAction[] anActionArray = (group2 = (ActionGroup)CustomActionsSchema.getInstance().getCorrectedAction(popupGroupId)) == null ? EMPTY_ARRAY : group2.getChildren(e);
                        if (anActionArray == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        return anActionArray;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/navigationToolbar/NavBarPanel$1$1", "getChildren"));
                    }
                };
                ActionPopupMenu popupMenu = ActionManager.getInstance().createActionPopupMenu("NavBar", actionGroup2);
                popupMenu.setTargetComponent(component2);
                JPopupMenu menu = popupMenu.getComponent();
                menu.addPopupMenuListener((PopupMenuListener)new PopupMenuListenerAdapter(){

                    public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                        if (index2 != -1) {
                            NavBarPanel.this.myModel.setSelectedIndex(index2);
                        }
                    }
                });
                menu.show(comp, x, y);
            }
        });
    }

    public void installActions(final int index2, NavBarItem component2) {
        this.installPopupHandler((JComponent)((Object)component2), index2);
        ListenerUtil.addMouseListener((Component)((Object)component2), new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (SystemInfo.isWindows) {
                    this.click(e);
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (!SystemInfo.isWindows) {
                    this.click(e);
                }
            }

            private void click(MouseEvent e) {
                if (e.isConsumed()) {
                    return;
                }
                if (e.isPopupTrigger()) {
                    return;
                }
                if (e.getClickCount() == 1) {
                    NavBarPanel.this.ctrlClick(index2);
                    e.consume();
                } else if (e.getClickCount() == 2 && e.getButton() == 1) {
                    NavBarPanel.this.requestSelectedItemFocus();
                    NavBarPanel.this.doubleClick(index2);
                    e.consume();
                }
            }
        });
        ListenerUtil.addKeyListener((Component)((Object)component2), new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getModifiers() == 0 && e.getKeyCode() == 32) {
                    NavBarPanel.this.ctrlClick(index2);
                    NavBarPanel.this.myModel.setSelectedIndex(index2);
                    e.consume();
                }
            }
        });
    }

    private void installDnD(final int index2, NavBarItem component2) {
        DnDSupport.createBuilder((JComponent)((Object)component2)).setBeanProvider(dnDActionInfo -> new DnDDragStartBean((Object)new TransferableWrapper(){

            @Override
            public List<File> asFileList() {
                Object o = NavBarPanel.this.myModel.get(index2);
                if (o instanceof PsiElement) {
                    VirtualFile vf;
                    VirtualFile virtualFile2 = vf = o instanceof PsiDirectory ? ((PsiDirectory)o).getVirtualFile() : ((PsiElement)o).getContainingFile().getVirtualFile();
                    if (vf != null) {
                        return Collections.singletonList(new File(vf.getPath()).getAbsoluteFile());
                    }
                }
                return Collections.emptyList();
            }

            @Override
            public TreeNode[] getTreeNodes() {
                return null;
            }

            @Override
            public PsiElement[] getPsiElements() {
                return null;
            }
        })).setDisposableParent((Disposable)component2).install();
    }

    private void doubleClick(int index2) {
        this.doubleClick(this.myModel.getElement(index2));
    }

    protected void doubleClick(Object object) {
        Object target2 = ObjectUtils.chooseNotNull((Object)this.getNavigatable(object), (Object)object);
        if (target2 instanceof Navigatable) {
            Navigatable navigatable = (Navigatable)target2;
            if (navigatable.canNavigate()) {
                navigatable.navigate(true);
            }
        } else if (target2 instanceof Module) {
            ProjectView projectView = ProjectView.getInstance(this.myProject);
            AbstractProjectViewPane projectViewPane = projectView.getProjectViewPaneById(projectView.getCurrentViewId());
            if (projectViewPane != null) {
                projectViewPane.selectModule((Module)target2, true);
            }
        } else if (target2 instanceof Project) {
            return;
        }
        this.hideHint(true);
    }

    @Nullable
    private Navigatable getNavigatable(Object object) {
        return (Navigatable)CommonDataKeys.NAVIGATABLE.getData(this.getDataProvider(() -> JBIterable.of((Object)object)));
    }

    private void ctrlClick(int index2) {
        Object object;
        List<Object> objects;
        if (this.isNodePopupActive()) {
            this.cancelPopup();
            if (this.myModel.getSelectedIndex() == index2) {
                return;
            }
        }
        if (!(objects = this.myModel.getChildren(object = this.myModel.getElement(index2))).isEmpty()) {
            Object[] siblings = new Object[objects.size()];
            for (int i2 = 0; i2 < objects.size(); ++i2) {
                siblings[i2] = objects.get(i2);
            }
            NavBarItem item = this.getItem(index2);
            int selectedIndex = index2 < this.myModel.size() - 1 ? objects.indexOf(this.myModel.getElement(index2 + 1)) : 0;
            this.myNodePopup = new NavBarPopup(this, index2, siblings, selectedIndex);
            this.myNodePopup.show(item);
            item.update();
        }
    }

    protected void navigateInsideBar(int sourceItemIndex, Object object, boolean forceNavigate) {
        UIEventLogger.NavBarNavigate.log(this.myProject);
        boolean restorePopup = !forceNavigate && this.shouldRestorePopupOnSelect(object, sourceItemIndex);
        Object obj2 = NavBarPanel.expandDirsWithJustOneSubdir(object);
        this.myContextObject = null;
        this.myUpdateQueue.cancelAllUpdates();
        if (this.myNodePopup != null && this.myNodePopup.isVisible()) {
            this.myUpdateQueue.queueModelUpdateForObject(obj2);
        }
        this.myUpdateQueue.queueRebuildUi();
        this.myUpdateQueue.queueAfterAll(() -> {
            int index2 = this.myModel.indexOf(obj2);
            if (index2 >= 0) {
                this.myModel.setSelectedIndex(index2);
            }
            if (this.myModel.hasChildren(obj2) && restorePopup) {
                this.restorePopup();
            } else {
                this.doubleClick(obj2);
            }
        }, NavBarUpdateQueue.ID.NAVIGATE_INSIDE);
    }

    private boolean shouldRestorePopupOnSelect(Object obj2, int sourceItemIndex) {
        if (sourceItemIndex < this.myModel.size() - 1 && this.myModel.get(sourceItemIndex + 1) == obj2) {
            return true;
        }
        return NavBarPanel.isExpandable(obj2);
    }

    public static boolean isExpandable(Object obj2) {
        if (!(obj2 instanceof PsiElement)) {
            return true;
        }
        PsiElement psiElement = (PsiElement)obj2;
        for (NavBarModelExtension modelExtension : NavBarModelExtension.EP_NAME.getExtensionList()) {
            Boolean expand = modelExtension.shouldExpandOnClick(psiElement);
            if (expand == null) continue;
            return expand;
        }
        return psiElement instanceof PsiDirectory || psiElement instanceof PsiDirectoryContainer;
    }

    void restorePopup() {
        this.cancelPopup();
        this.ctrlClick(this.myModel.getSelectedIndex());
    }

    void cancelPopup() {
        this.cancelPopup(false);
    }

    void cancelPopup(boolean ok) {
        if (this.myNodePopup != null) {
            this.myNodePopup.hide(ok);
            this.myNodePopup = null;
            if (this.allowNavItemsFocus()) {
                this.requestSelectedItemFocus();
            }
        }
    }

    void hideHint() {
        this.hideHint(false);
    }

    protected void hideHint(boolean ok) {
        this.cancelPopup(ok);
        if (this.myHint != null) {
            this.myHint.hide(ok);
            this.myHint = null;
        }
    }

    @Override
    @Nullable
    public Object getData(@NotNull String dataId) {
        if (dataId == null) {
            NavBarPanel.$$$reportNull$$$0(2);
        }
        if (CommonDataKeys.PROJECT.is(dataId)) {
            return !this.myProject.isDisposed() ? this.myProject : null;
        }
        return this.getData(dataId, () -> this.getSelection());
    }

    @Nullable
    private Object getData(@NotNull String dataId, Supplier<JBIterable<?>> selection) {
        if (dataId == null) {
            NavBarPanel.$$$reportNull$$$0(3);
        }
        DataProvider dataProvider = this.getDataProviderInner(selection);
        for (NavBarModelExtension modelExtension : NavBarModelExtension.EP_NAME.getExtensionList()) {
            Object data2 = modelExtension.getData(dataId, dataProvider);
            if (data2 == null) continue;
            return data2;
        }
        return dataProvider.getData(dataId);
    }

    @NotNull
    private DataProvider getDataProvider(Supplier<JBIterable<?>> selection) {
        DataProvider dataProvider = d -> this.getData(d, selection);
        if (dataProvider == null) {
            NavBarPanel.$$$reportNull$$$0(4);
        }
        return dataProvider;
    }

    @NotNull
    private DataProvider getDataProviderInner(Supplier<JBIterable<?>> selection) {
        DataProvider dataProvider = d -> this.getDataImpl(d, this, selection);
        if (dataProvider == null) {
            NavBarPanel.$$$reportNull$$$0(5);
        }
        return dataProvider;
    }

    @NotNull
    JBIterable<?> getSelection() {
        Object value2 = this.myModel.getSelectedValue();
        if (value2 != null) {
            JBIterable jBIterable = JBIterable.of((Object)value2);
            if (jBIterable == null) {
                NavBarPanel.$$$reportNull$$$0(6);
            }
            return jBIterable;
        }
        int size = this.myModel.size();
        JBIterable jBIterable = JBIterable.of(size > 0 ? this.myModel.getElement(size - 1) : null);
        if (jBIterable == null) {
            NavBarPanel.$$$reportNull$$$0(7);
        }
        return jBIterable;
    }

    Object getDataImpl(String dataId, @NotNull JComponent source, @NotNull Supplier<? extends JBIterable<?>> selection) {
        if (source == null) {
            NavBarPanel.$$$reportNull$$$0(8);
        }
        if (selection == null) {
            NavBarPanel.$$$reportNull$$$0(9);
        }
        if (CommonDataKeys.PROJECT.is(dataId)) {
            return !this.myProject.isDisposed() ? this.myProject : null;
        }
        if (LangDataKeys.MODULE.is(dataId)) {
            Module module = (Module)selection.get().filter(Module.class).first();
            if (module != null && !module.isDisposed()) {
                return module;
            }
            PsiElement element2 = (PsiElement)selection.get().filter(PsiElement.class).first();
            if (element2 != null) {
                return ModuleUtilCore.findModuleForPsiElement((PsiElement)element2);
            }
            return null;
        }
        if (LangDataKeys.MODULE_CONTEXT.is(dataId)) {
            VirtualFile dir;
            PsiDirectory directory = (PsiDirectory)selection.get().filter(PsiDirectory.class).first();
            if (directory != null && ProjectRootsUtil.isModuleContentRoot(dir = directory.getVirtualFile(), this.myProject)) {
                return ModuleUtilCore.findModuleForPsiElement((PsiElement)directory);
            }
            return null;
        }
        if (CommonDataKeys.PSI_ELEMENT.is(dataId)) {
            PsiElement element3 = (PsiElement)selection.get().filter(PsiElement.class).first();
            return element3 != null && element3.isValid() ? element3 : null;
        }
        if (LangDataKeys.PSI_ELEMENT_ARRAY.is(dataId)) {
            List result2 = selection.get().filter(PsiElement.class).filter(e -> e != null && e.isValid()).toList();
            return result2.isEmpty() ? null : result2.toArray(PsiElement.EMPTY_ARRAY);
        }
        if (CommonDataKeys.VIRTUAL_FILE_ARRAY.is(dataId)) {
            Set files2 = selection.get().filter(PsiElement.class).filter(e -> e != null && e.isValid()).filterMap(e -> PsiUtilCore.getVirtualFile((PsiElement)e)).toSet();
            return !files2.isEmpty() ? VfsUtilCore.toVirtualFileArray((Collection)files2) : null;
        }
        if (CommonDataKeys.NAVIGATABLE_ARRAY.is(dataId)) {
            List elements = selection.get().filter(Navigatable.class).toList();
            return elements.isEmpty() ? null : elements.toArray(Navigatable.EMPTY_NAVIGATABLE_ARRAY);
        }
        if (PlatformDataKeys.CONTEXT_COMPONENT.is(dataId)) {
            return this;
        }
        if (PlatformDataKeys.CUT_PROVIDER.is(dataId)) {
            return this.getCopyPasteDelegator(source).getCutProvider();
        }
        if (PlatformDataKeys.COPY_PROVIDER.is(dataId)) {
            return this.getCopyPasteDelegator(source).getCopyProvider();
        }
        if (PlatformDataKeys.PASTE_PROVIDER.is(dataId)) {
            return this.getCopyPasteDelegator(source).getPasteProvider();
        }
        if (PlatformDataKeys.DELETE_ELEMENT_PROVIDER.is(dataId)) {
            return selection.get().filter(Module.class).isNotEmpty() ? ModuleDeleteProvider.getInstance() : new DeleteHandler.DefaultDeleteProvider();
        }
        if (LangDataKeys.IDE_VIEW.is(dataId)) {
            return this.myIdeView;
        }
        return null;
    }

    @NotNull
    private CopyPasteSupport getCopyPasteDelegator(@NotNull JComponent source) {
        String key;
        Object result2;
        if (source == null) {
            NavBarPanel.$$$reportNull$$$0(10);
        }
        if (!((result2 = source.getClientProperty(key = "NavBarPanel.copyPasteDelegator")) instanceof CopyPasteSupport)) {
            result2 = new CopyPasteDelegator(this.myProject, source);
            source.putClientProperty(key, result2);
        }
        CopyPasteSupport copyPasteSupport = (CopyPasteSupport)result2;
        if (copyPasteSupport == null) {
            NavBarPanel.$$$reportNull$$$0(11);
        }
        return copyPasteSupport;
    }

    @Override
    public Point getBestPopupPosition() {
        NavBarItem item;
        int index2 = this.myModel.getSelectedIndex();
        int modelSize = this.myModel.size();
        if (index2 == -1) {
            index2 = modelSize - 1;
        }
        if (index2 > -1 && index2 < modelSize && (item = this.getItem(index2)) != null) {
            return new Point(item.getX(), item.getY() + item.getHeight());
        }
        return null;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        NavBarListener.subscribeTo(this);
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        if (this.isDisposeOnRemove() && ScreenUtil.isStandardAddRemoveNotify((Component)this)) {
            Disposer.dispose((Disposable)this);
        }
    }

    protected boolean isDisposeOnRemove() {
        return true;
    }

    public void updateState(boolean show2) {
        if (show2) {
            this.myUpdateQueue.queueModelUpdateFromFocus();
            this.myUpdateQueue.queueRebuildUi();
        }
    }

    public void showHint(@Nullable Editor editor, DataContext dataContext) {
        this.myModel.updateModelAsync(dataContext, () -> {
            if (this.myModel.isEmpty()) {
                return;
            }
            JPanel panel2 = new JPanel(new BorderLayout());
            panel2.add(this);
            panel2.setOpaque(true);
            panel2.setBackground(UIUtil.getListBackground());
            this.myHint = new LightweightHint(panel2){

                @Override
                public void hide() {
                    super.hide();
                    NavBarPanel.this.cancelPopup();
                    Disposer.dispose((Disposable)NavBarPanel.this);
                }
            };
            this.myHint.setForceShowAsPopup(true);
            this.myHint.setFocusRequestor(this);
            KeyboardFocusManager focusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            this.myUpdateQueue.rebuildUi();
            if (editor == null) {
                this.myContextComponent = (Component)PlatformDataKeys.CONTEXT_COMPONENT.getData(dataContext);
                this.getHintContainerShowPoint().doWhenDone(relativePoint -> {
                    Component owner = focusManager.getFocusOwner();
                    Component cmp = relativePoint.getComponent();
                    if (cmp instanceof JComponent && cmp.isShowing()) {
                        this.myHint.show((JComponent)cmp, relativePoint.getPoint().x, relativePoint.getPoint().y, owner instanceof JComponent ? (JComponent)owner : null, new HintHint(relativePoint.getComponent(), relativePoint.getPoint()));
                    }
                });
            } else {
                this.myHintContainer = editor.getContentComponent();
                this.getHintContainerShowPoint().doWhenDone(rp -> {
                    Point p = rp.getPointOn((Component)this.myHintContainer).getPoint();
                    HintHint hintInfo = new HintHint(editor, p);
                    HintManagerImpl.getInstanceImpl().showEditorHint(this.myHint, editor, p, 1, 0, true, hintInfo);
                });
            }
            this.rebuildAndSelectTail(true);
        });
    }

    AsyncResult<RelativePoint> getHintContainerShowPoint() {
        Component c;
        AsyncResult result2 = new AsyncResult();
        if (this.myLocationCache == null) {
            if (this.myHintContainer != null) {
                Point p = AbstractPopup.getCenterOf((Component)this.myHintContainer, this);
                p.y -= this.myHintContainer.getVisibleRect().height / 4;
                this.myLocationCache = RelativePoint.fromScreen((Point)p);
            } else {
                DataManager dataManager = DataManager.getInstance();
                if (this.myContextComponent != null) {
                    DataContext ctx = dataManager.getDataContext(this.myContextComponent);
                    this.myLocationCache = JBPopupFactory.getInstance().guessBestPopupLocation(ctx);
                } else {
                    dataManager.getDataContextFromFocus().doWhenDone(dataContext -> {
                        this.myContextComponent = (Component)PlatformDataKeys.CONTEXT_COMPONENT.getData((DataContext)dataContext);
                        DataContext ctx = dataManager.getDataContext(this.myContextComponent);
                        this.myLocationCache = JBPopupFactory.getInstance().guessBestPopupLocation(ctx);
                    });
                }
            }
        }
        if (!((c = this.myLocationCache.getComponent()) instanceof JComponent) || !c.isShowing()) {
            JComponent ideFrame = WindowManager.getInstance().getIdeFrame(this.getProject()).getComponent();
            JRootPane rootPane = UIUtil.getRootPane((Component)ideFrame);
            this.myLocationCache = JBPopupFactory.getInstance().guessBestPopupLocation((JComponent)rootPane);
        }
        result2.setDone((Object)this.myLocationCache);
        return result2;
    }

    public void putInfo(@NotNull Map<? super String, ? super String> info2) {
        if (info2 == null) {
            NavBarPanel.$$$reportNull$$$0(12);
        }
        StringBuilder result2 = new StringBuilder();
        for (int i2 = 0; i2 < this.myList.size(); ++i2) {
            NavBarItem each = this.myList.get(i2);
            if (each.isSelected()) {
                result2.append("[").append(each.getText()).append("]");
            } else {
                result2.append(each.getText());
            }
            if (i2 >= this.myList.size() - 1) continue;
            result2.append(">");
        }
        info2.put("navBar", result2.toString());
        if (this.isNodePopupActive()) {
            StringBuilder popupText = new StringBuilder();
            JBList<?> list2 = this.myNodePopup.getList();
            for (int i3 = 0; i3 < list2.getModel().getSize(); ++i3) {
                Object eachElement = list2.getModel().getElementAt(i3);
                String text2 = new NavBarItem(this, eachElement, this.myNodePopup, true).getText();
                int selectedIndex = list2.getSelectedIndex();
                if (selectedIndex != -1 && eachElement.equals(list2.getSelectedValue())) {
                    popupText.append("[").append(text2).append("]");
                } else {
                    popupText.append(text2);
                }
                if (i3 >= list2.getModel().getSize() - 1) continue;
                popupText.append(">");
            }
            info2.put("navBarPopup", popupText.toString());
        }
    }

    @NotNull
    public NavBarUI getNavBarUI() {
        NavBarUI navBarUI = NavBarUIManager.getUI();
        if (navBarUI == null) {
            NavBarPanel.$$$reportNull$$$0(13);
        }
        return navBarUI;
    }

    boolean isUpdating() {
        return this.myUpdateQueue.isUpdating();
    }

    void queueFileUpdate(PsiFile psiFile) {
        this.myForcedFileUpdateQueue.add(psiFile);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/navigationToolbar/NavBarPanel";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selection";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/navigationToolbar/NavBarPanel";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataProvider";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataProviderInner";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelection";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getCopyPasteDelegator";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getNavBarUI";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "installPopupHandler";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 13: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getDataImpl";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getCopyPasteDelegator";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "putInfo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

