/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.impl;

import com.intellij.ide.DataManager;
import com.intellij.ide.impl.DataManagerImpl;
import com.intellij.ide.impl.dataRules.GetDataRule;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.util.Map;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;

public class HeadlessDataManager
extends DataManagerImpl {
    private volatile DataProvider myTestDataProvider;
    private volatile boolean myUseProductionDataManager = false;

    @TestOnly
    public void setTestDataProvider(@Nullable DataProvider provider2) {
        this.myTestDataProvider = provider2;
    }

    @TestOnly
    public void setTestDataProvider(@Nullable DataProvider provider2, @NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            HeadlessDataManager.$$$reportNull$$$0(0);
        }
        DataProvider previous = this.myTestDataProvider;
        this.myTestDataProvider = provider2;
        Disposer.register((Disposable)parentDisposable, () -> {
            this.myTestDataProvider = previous;
        });
    }

    @TestOnly
    public static void fallbackToProductionDataManager(@NotNull Disposable disposable2) {
        if (disposable2 == null) {
            HeadlessDataManager.$$$reportNull$$$0(1);
        }
        HeadlessDataManager manager2 = (HeadlessDataManager)DataManager.getInstance();
        if (manager2.myUseProductionDataManager) {
            throw new IllegalStateException("Already called and still not disposed.");
        }
        Disposer.register((Disposable)disposable2, () -> {
            manager2.myUseProductionDataManager = false;
        });
        manager2.myUseProductionDataManager = true;
    }

    @Override
    @NotNull
    public DataContext getDataContext() {
        return new HeadlessContext(this.myTestDataProvider, this.productionDataContext(() -> super.getDataContext()));
    }

    @Override
    @NotNull
    public Promise<DataContext> getDataContextFromFocusAsync() {
        AsyncPromise promise = new AsyncPromise();
        promise.setResult((Object)this.getDataContext());
        AsyncPromise asyncPromise = promise;
        if (asyncPromise == null) {
            HeadlessDataManager.$$$reportNull$$$0(2);
        }
        return asyncPromise;
    }

    @Override
    @NotNull
    public DataContext getDataContext(Component component2) {
        return new HeadlessContext(this.myTestDataProvider, this.productionDataContext(() -> super.getDataContext(component2)));
    }

    @Override
    @NotNull
    public DataContext getDataContext(@NotNull Component component2, int x, int y) {
        if (component2 == null) {
            HeadlessDataManager.$$$reportNull$$$0(3);
        }
        return new HeadlessContext(this.myTestDataProvider, this.productionDataContext(() -> super.getDataContext(component2, x, y)));
    }

    @Nullable
    private DataContext productionDataContext(@NotNull @NotNull Supplier<? extends @NotNull DataContext> dataContextSupplier) {
        if (dataContextSupplier == null) {
            HeadlessDataManager.$$$reportNull$$$0(4);
        }
        return this.myUseProductionDataManager ? dataContextSupplier.get() : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/impl/HeadlessDataManager";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContextSupplier";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/impl/HeadlessDataManager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataContextFromFocusAsync";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setTestDataProvider";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "fallbackToProductionDataManager";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getDataContext";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "productionDataContext";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class HeadlessContext
    implements DataContext,
    UserDataHolder {
        private final DataProvider myProvider;
        private final DataContext myParent;
        private Map<Key<?>, Object> myUserData;

        HeadlessContext(@Nullable DataProvider provider2, @Nullable DataContext parent) {
            this.myProvider = provider2;
            this.myParent = parent;
        }

        @Override
        @Nullable
        public Object getData(@NotNull String dataId) {
            GetDataRule rule;
            Object result2;
            if (dataId == null) {
                HeadlessContext.$$$reportNull$$$0(0);
            }
            if ((result2 = this.getDataFromSelfOrParent(dataId)) == null && (rule = ((DataManagerImpl)DataManager.getInstance()).getDataRule(dataId)) != null) {
                return rule.getData(this::getDataFromSelfOrParent);
            }
            return result2;
        }

        @Nullable
        private Object getDataFromSelfOrParent(@NotNull String dataId) {
            Object result2;
            if (dataId == null) {
                HeadlessContext.$$$reportNull$$$0(1);
            }
            Object object = result2 = this.myProvider == null ? null : this.myProvider.getData(dataId);
            return result2 != null ? result2 : (this.myParent != null ? this.myParent.getData(dataId) : null);
        }

        public <T> T getUserData(@NotNull Key<T> key) {
            if (key == null) {
                HeadlessContext.$$$reportNull$$$0(2);
            }
            return (T)this.getOrCreateMap().get(key);
        }

        public <T> void putUserData(@NotNull Key<T> key, @Nullable T value2) {
            if (key == null) {
                HeadlessContext.$$$reportNull$$$0(3);
            }
            this.getOrCreateMap().put(key, value2);
        }

        @NotNull
        private Map<Key<?>, Object> getOrCreateMap() {
            Map userData = this.myUserData;
            if (userData == null) {
                this.myUserData = userData = ContainerUtil.createWeakValueMap();
            }
            Map map2 = userData;
            if (map2 == null) {
                HeadlessContext.$$$reportNull$$$0(4);
            }
            return map2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataId";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/impl/HeadlessDataManager$HeadlessContext";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/impl/HeadlessDataManager$HeadlessContext";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getOrCreateMap";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getData";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getDataFromSelfOrParent";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getUserData";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "putUserData";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

