/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.gdpr;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.intellij.ide.gdpr.ConfirmedConsent;
import com.intellij.ide.gdpr.Consent;
import com.intellij.ide.gdpr.ConsentAttributes;
import com.intellij.ide.gdpr.ConsentBase;
import com.intellij.ide.gdpr.Version;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.openapi.vfs.CharsetToolkit;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ConsentOptions {
    private static final Logger LOG = Logger.getInstance(ConsentOptions.class);
    private static final String CONSENTS_CONFIRMATION_PROPERTY = "jb.consents.confirmation.enabled";
    private static final String STATISTICS_OPTION_ID = "rsch.send.usage.stat";
    private static final String EAP_FEEDBACK_OPTION_ID = "eap";
    private static final Set<String> PER_PRODUCT_CONSENTS = Set.of("eap");
    private final boolean myIsEAP;
    @Nullable
    private String myProductCodeSuffix;
    private final IOBackend myBackend;

    ConsentOptions(IOBackend backend, boolean isEap) {
        this.myBackend = backend;
        this.myIsEAP = isEap;
    }

    public static ConsentOptions getInstance() {
        return InstanceHolder.ourInstance;
    }

    public boolean isEAP() {
        return this.myIsEAP;
    }

    public void setProductCode(String code) {
        this.myProductCodeSuffix = code != null ? "." + code.toLowerCase(Locale.ENGLISH) : null;
    }

    @Nullable
    public Consent getDefaultUsageStatsConsent() {
        return this.getDefaultConsent(STATISTICS_OPTION_ID);
    }

    @NotNull
    public static Predicate<Consent> condUsageStatsConsent() {
        Predicate<Consent> predicate2 = consent -> STATISTICS_OPTION_ID.equals(consent.getId());
        if (predicate2 == null) {
            ConsentOptions.$$$reportNull$$$0(0);
        }
        return predicate2;
    }

    @NotNull
    public static Predicate<Consent> condEAPFeedbackConsent() {
        Predicate<Consent> predicate2 = consent -> {
            String id2 = consent.getId();
            return id2.startsWith(EAP_FEEDBACK_OPTION_ID) && (id2.length() == EAP_FEEDBACK_OPTION_ID.length() || id2.charAt(EAP_FEEDBACK_OPTION_ID.length()) == '.');
        };
        if (predicate2 == null) {
            ConsentOptions.$$$reportNull$$$0(1);
        }
        return predicate2;
    }

    public Permission isSendingUsageStatsAllowed() {
        return this.getPermission(STATISTICS_OPTION_ID);
    }

    public boolean setSendingUsageStatsAllowed(boolean allowed) {
        return this.setPermission(STATISTICS_OPTION_ID, allowed);
    }

    public Permission isEAPFeedbackAllowed() {
        return this.getPermission(EAP_FEEDBACK_OPTION_ID);
    }

    public boolean setEAPFeedbackAllowed(boolean allowed) {
        return this.setPermission(EAP_FEEDBACK_OPTION_ID, allowed);
    }

    @NotNull
    private Permission getPermission(String consentId) {
        ConfirmedConsent confirmedConsent = this.getConfirmedConsent(consentId);
        Permission permission = confirmedConsent == null ? Permission.UNDEFINED : (confirmedConsent.isAccepted() ? Permission.YES : Permission.NO);
        if (permission == null) {
            ConsentOptions.$$$reportNull$$$0(2);
        }
        return permission;
    }

    private boolean setPermission(String consentId, boolean allowed) {
        Consent defConsent = this.getDefaultConsent(consentId);
        if (defConsent != null && !defConsent.isDeleted()) {
            this.saveConfirmedConsents(Collections.singleton(new ConfirmedConsent(defConsent.getId(), defConsent.getVersion(), allowed, 0L)));
            return true;
        }
        return false;
    }

    private String lookupConsentID(String consentId) {
        String suffix = this.myProductCodeSuffix;
        return suffix != null && PER_PRODUCT_CONSENTS.contains(consentId) ? consentId + suffix : consentId;
    }

    @Nullable
    public String getConfirmedConsentsString() {
        Map<String, Consent> defaults = this.loadDefaultConsents();
        if (!defaults.isEmpty()) {
            String str = ConsentOptions.confirmedConsentToExternalString(this.loadConfirmedConsents().values().stream().filter(c -> {
                Consent def = (Consent)defaults.get(c.getId());
                return def != null && !def.isDeleted();
            }));
            return str.isBlank() ? null : str;
        }
        return null;
    }

    public void applyServerUpdates(@Nullable String json) {
        if (json == null || json.isBlank()) {
            return;
        }
        try {
            Map<String, ConfirmedConsent> confirmed;
            Collection<ConsentAttributes> fromServer = this.fromJson(json);
            Map<String, Consent> defaults = this.loadDefaultConsents();
            if (ConsentOptions.applyServerChangesToDefaults(defaults, fromServer)) {
                this.myBackend.writeDefaultConsents(this.consentsToJson(defaults.values().stream()));
            }
            if (ConsentOptions.applyServerChangesToConfirmedConsents(confirmed = this.loadConfirmedConsents(), fromServer)) {
                this.myBackend.writeConfirmedConsents(ConsentOptions.confirmedConsentToExternalString(confirmed.values().stream()));
            }
        }
        catch (Exception e) {
            LOG.info((Throwable)e);
        }
    }

    @NotNull
    public Pair<List<Consent>, Boolean> getConsents() {
        Pair<List<Consent>, Boolean> pair = this.getConsents(consent -> true);
        if (pair == null) {
            ConsentOptions.$$$reportNull$$$0(3);
        }
        return pair;
    }

    @NotNull
    public Pair<List<Consent>, Boolean> getConsents(@NotNull Predicate<Consent> filter) {
        if (filter == null) {
            ConsentOptions.$$$reportNull$$$0(4);
        }
        Map<String, Consent> allDefaults = this.loadDefaultConsents();
        if (this.myIsEAP) {
            allDefaults.remove(STATISTICS_OPTION_ID);
        } else {
            allDefaults.remove(this.lookupConsentID(EAP_FEEDBACK_OPTION_ID));
        }
        Iterator<Map.Entry<String, Consent>> it = allDefaults.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, Consent> entry2 = it.next();
            if (filter.test(entry2.getValue())) continue;
            it.remove();
        }
        if (allDefaults.isEmpty()) {
            return new Pair(Collections.emptyList(), (Object)Boolean.FALSE);
        }
        Map<String, ConfirmedConsent> allConfirmed = this.loadConfirmedConsents();
        ArrayList<Consent> result2 = new ArrayList<Consent>();
        for (Map.Entry<String, Consent> entry3 : allDefaults.entrySet()) {
            Consent base = entry3.getValue();
            if (base.isDeleted()) continue;
            ConfirmedConsent confirmed = allConfirmed.get(base.getId());
            result2.add(confirmed == null ? base : base.derive(confirmed.isAccepted()));
        }
        result2.sort(Comparator.comparing(ConsentBase::getId));
        boolean confirmationEnabled = Boolean.parseBoolean(System.getProperty(CONSENTS_CONFIRMATION_PROPERTY, "true"));
        return new Pair(result2, (Object)(confirmationEnabled && ConsentOptions.needReconfirm(allDefaults, allConfirmed) ? 1 : 0));
    }

    public void setConsents(@NotNull Collection<Consent> confirmedByUser) {
        List<ConfirmedConsent> result2;
        if (confirmedByUser == null) {
            ConsentOptions.$$$reportNull$$$0(5);
        }
        if (confirmedByUser.isEmpty()) {
            result2 = Collections.emptyList();
        } else {
            ArrayList<ConfirmedConsent> list2 = new ArrayList<ConfirmedConsent>(confirmedByUser.size());
            for (Consent t : confirmedByUser) {
                list2.add(new ConfirmedConsent(t.getId(), t.getVersion(), t.isAccepted(), 0L));
            }
            result2 = list2;
        }
        this.saveConfirmedConsents(result2);
    }

    @Nullable
    private Consent getDefaultConsent(String consentId) {
        return this.loadDefaultConsents().get(this.lookupConsentID(consentId));
    }

    @Nullable
    private ConfirmedConsent getConfirmedConsent(String consentId) {
        Consent defConsent = this.getDefaultConsent(consentId);
        if (defConsent != null && defConsent.isDeleted()) {
            return null;
        }
        return this.loadConfirmedConsents().get(defConsent != null ? defConsent.getId() : this.lookupConsentID(consentId));
    }

    private void saveConfirmedConsents(@NotNull Collection<ConfirmedConsent> updates2) {
        if (updates2 == null) {
            ConsentOptions.$$$reportNull$$$0(6);
        }
        if (!updates2.isEmpty()) {
            try {
                Map<String, ConfirmedConsent> allConfirmed = this.loadConfirmedConsents();
                long stamp = System.currentTimeMillis();
                for (ConfirmedConsent consent : updates2) {
                    consent.setAcceptanceTime(stamp);
                    allConfirmed.put(consent.getId(), consent);
                }
                this.myBackend.writeConfirmedConsents(ConsentOptions.confirmedConsentToExternalString(allConfirmed.values().stream()));
            }
            catch (IOException e) {
                LOG.info((Throwable)e);
            }
        }
    }

    public boolean needsReconfirm(Consent consent) {
        Version defaultVersion;
        if (consent == null || consent.isDeleted() || this.myIsEAP && STATISTICS_OPTION_ID.equals(consent.getId())) {
            return false;
        }
        ConfirmedConsent confirmedConsent = this.loadConfirmedConsents().get(consent.getId());
        if (confirmedConsent == null) {
            return true;
        }
        Version confirmedVersion = confirmedConsent.getVersion();
        return confirmedVersion.isOlder(defaultVersion = consent.getVersion()) && confirmedVersion.getMajor() != defaultVersion.getMajor();
    }

    private static boolean needReconfirm(Map<String, Consent> defaults, Map<String, ConfirmedConsent> confirmed) {
        for (Consent defConsent : defaults.values()) {
            Version defaultVersion;
            if (defConsent.isDeleted()) continue;
            ConfirmedConsent confirmedConsent = confirmed.get(defConsent.getId());
            if (confirmedConsent == null) {
                return true;
            }
            Version confirmedVersion = confirmedConsent.getVersion();
            if (!confirmedVersion.isOlder(defaultVersion = defConsent.getVersion()) || confirmedVersion.getMajor() == defaultVersion.getMajor()) continue;
            return true;
        }
        return false;
    }

    private static boolean applyServerChangesToConfirmedConsents(Map<String, ConfirmedConsent> base, Collection<ConsentAttributes> fromServer) {
        boolean changes = false;
        for (ConsentAttributes update2 : fromServer) {
            ConfirmedConsent change;
            ConfirmedConsent current2 = base.get(update2.consentId);
            if (current2 == null || (change = new ConfirmedConsent(update2)).getVersion().isOlder(current2.getVersion()) || current2.getAcceptanceTime() >= update2.acceptanceTime) continue;
            base.put(change.getId(), change);
            changes = true;
        }
        return changes;
    }

    private static boolean applyServerChangesToDefaults(@NotNull Map<String, Consent> base, @NotNull Collection<ConsentAttributes> fromServer) {
        if (base == null) {
            ConsentOptions.$$$reportNull$$$0(7);
        }
        if (fromServer == null) {
            ConsentOptions.$$$reportNull$$$0(8);
        }
        boolean changes = false;
        for (ConsentAttributes update2 : fromServer) {
            Consent newConsent = new Consent(update2);
            Consent current2 = base.get(newConsent.getId());
            if (current2 == null || newConsent.isDeleted() || !newConsent.getVersion().isNewer(current2.getVersion())) continue;
            base.put(newConsent.getId(), newConsent);
            changes = true;
        }
        return changes;
    }

    @NotNull
    private Collection<ConsentAttributes> fromJson(@Nullable String json) {
        block5: {
            List<ConsentAttributes> list2;
            try {
                ConsentAttributes[] data2;
                ConsentAttributes[] consentAttributesArray = data2 = StringUtilRt.isEmptyOrSpaces((CharSequence)json) ? null : (ConsentAttributes[])new GsonBuilder().disableHtmlEscaping().create().fromJson(json, ConsentAttributes[].class);
                if (data2 == null) break block5;
                for (ConsentAttributes attributes2 : data2) {
                    attributes2.consentId = this.lookupConsentID(attributes2.consentId);
                }
                list2 = Arrays.asList(data2);
            }
            catch (Throwable e) {
                LOG.info(e);
            }
            if (list2 == null) {
                ConsentOptions.$$$reportNull$$$0(9);
            }
            return list2;
        }
        List<ConsentAttributes> list3 = Collections.emptyList();
        if (list3 == null) {
            ConsentOptions.$$$reportNull$$$0(10);
        }
        return list3;
    }

    @NotNull
    private String consentsToJson(@NotNull Stream<Consent> consents) {
        if (consents == null) {
            ConsentOptions.$$$reportNull$$$0(11);
        }
        Gson gson2 = new GsonBuilder().disableHtmlEscaping().create();
        String suffix = this.myProductCodeSuffix;
        String string = gson2.toJson((Object)consents.map(consent -> {
            ConsentAttributes attribs = consent.toConsentAttributes();
            if (suffix != null && attribs.consentId.endsWith(suffix)) {
                attribs.consentId = attribs.consentId.substring(0, attribs.consentId.length() - suffix.length());
            }
            return attribs;
        }).toArray());
        if (string == null) {
            ConsentOptions.$$$reportNull$$$0(12);
        }
        return string;
    }

    @NotNull
    private static String confirmedConsentToExternalString(@NotNull Stream<ConfirmedConsent> consents) {
        if (consents == null) {
            ConsentOptions.$$$reportNull$$$0(13);
        }
        String string = consents.map(ConfirmedConsent::toExternalString).collect(Collectors.joining(";"));
        if (string == null) {
            ConsentOptions.$$$reportNull$$$0(14);
        }
        return string;
    }

    @NotNull
    private Map<String, Consent> loadDefaultConsents() {
        HashMap<String, Consent> result2 = new HashMap<String, Consent>();
        for (ConsentAttributes attributes2 : this.fromJson(this.myBackend.readBundledConsents())) {
            result2.put(attributes2.consentId, new Consent(attributes2));
        }
        try {
            ConsentOptions.applyServerChangesToDefaults(result2, this.fromJson(this.myBackend.readDefaultConsents()));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        HashMap<String, Consent> hashMap = result2;
        if (hashMap == null) {
            ConsentOptions.$$$reportNull$$$0(15);
        }
        return hashMap;
    }

    @NotNull
    private Map<String, ConfirmedConsent> loadConfirmedConsents() {
        HashMap<String, ConfirmedConsent> result2 = new HashMap<String, ConfirmedConsent>();
        try {
            StringTokenizer tokenizer = new StringTokenizer(this.myBackend.readConfirmedConsents(), ";", false);
            while (tokenizer.hasMoreTokens()) {
                ConfirmedConsent consent = ConfirmedConsent.fromString(tokenizer.nextToken());
                if (consent == null) continue;
                result2.put(consent.getId(), consent);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        HashMap<String, ConfirmedConsent> hashMap = result2;
        if (hashMap == null) {
            ConsentOptions.$$$reportNull$$$0(16);
        }
        return hashMap;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 13: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 13: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/gdpr/ConsentOptions";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "confirmedByUser";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updates";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "base";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fromServer";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consents";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "condUsageStatsConsent";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "condEAPFeedbackConsent";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPermission";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getConsents";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/gdpr/ConsentOptions";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "fromJson";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "consentsToJson";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "confirmedConsentToExternalString";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "loadDefaultConsents";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "loadConfirmedConsents";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getConsents";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setConsents";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "saveConfirmedConsents";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "applyServerChangesToDefaults";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "consentsToJson";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "confirmedConsentToExternalString";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 13: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected static interface IOBackend {
        public void writeDefaultConsents(@NotNull String var1) throws IOException;

        @NotNull
        public String readDefaultConsents() throws IOException;

        @NotNull
        public String readBundledConsents();

        public void writeConfirmedConsents(@NotNull String var1) throws IOException;

        @NotNull
        public String readConfirmedConsents() throws IOException;
    }

    public static enum Permission {
        YES,
        NO,
        UNDEFINED;

    }

    private static final class InstanceHolder {
        static final ConsentOptions ourInstance;

        private InstanceHolder() {
        }

        @NotNull
        @NonNls
        private static String getBundledResourcePath() {
            ApplicationInfoEx appInfo = ApplicationInfoImpl.getShadowInstance();
            Object object = appInfo.isVendorJetBrains() ? "consents.json" : "consents-" + appInfo.getShortCompanyName() + ".json";
            if (object == null) {
                InstanceHolder.$$$reportNull$$$0(0);
            }
            return object;
        }

        static {
            ApplicationInfoEx appInfo = ApplicationInfoImpl.getShadowInstance();
            final Path commonDataPath = PathManager.getCommonDataPath();
            ourInstance = new ConsentOptions(new IOBackend(){
                private final Path DEFAULT_CONSENTS_FILE;
                private final Path CONFIRMED_CONSENTS_FILE;
                private final String BUNDLED_CONSENTS_PATH;
                {
                    this.DEFAULT_CONSENTS_FILE = commonDataPath.resolve(ApplicationNamesInfo.getInstance().getLowercaseProductName()).resolve("consentOptions/cached");
                    this.CONFIRMED_CONSENTS_FILE = commonDataPath.resolve("consentOptions/accepted");
                    this.BUNDLED_CONSENTS_PATH = InstanceHolder.getBundledResourcePath();
                }

                @Override
                public void writeDefaultConsents(@NotNull String data2) throws IOException {
                    if (data2 == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    Files.createDirectories(this.DEFAULT_CONSENTS_FILE.getParent(), new FileAttribute[0]);
                    Files.writeString(this.DEFAULT_CONSENTS_FILE, (CharSequence)data2, new OpenOption[0]);
                }

                @Override
                @NotNull
                public String readDefaultConsents() throws IOException {
                    return this.loadText(Files.newInputStream(this.DEFAULT_CONSENTS_FILE, new OpenOption[0]));
                }

                @Override
                @NotNull
                public String readBundledConsents() {
                    return this.loadText(ConsentOptions.class.getClassLoader().getResourceAsStream(this.BUNDLED_CONSENTS_PATH));
                }

                @Override
                public void writeConfirmedConsents(@NotNull String data2) throws IOException {
                    if (data2 == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    Files.createDirectories(this.CONFIRMED_CONSENTS_FILE.getParent(), new FileAttribute[0]);
                    Files.writeString(this.CONFIRMED_CONSENTS_FILE, (CharSequence)data2, new OpenOption[0]);
                }

                @Override
                @NotNull
                public String readConfirmedConsents() throws IOException {
                    return this.loadText(Files.newInputStream(this.CONFIRMED_CONSENTS_FILE, new OpenOption[0]));
                }

                /*
                 * Loose catch block
                 */
                @NotNull
                private String loadText(InputStream stream) {
                    if (stream != null) {
                        String string;
                        InputStream inputStream2;
                        block10: {
                            inputStream2 = CharsetToolkit.inputStreamSkippingBOM((InputStream)stream);
                            string = new String(inputStream2.readAllBytes(), StandardCharsets.UTF_8);
                            if (inputStream2 == null) break block10;
                            inputStream2.close();
                        }
                        String string2 = string;
                        if (string2 == null) {
                            1.$$$reportNull$$$0(2);
                        }
                        return string2;
                        {
                            catch (Throwable throwable) {
                                try {
                                    if (inputStream2 != null) {
                                        try {
                                            inputStream2.close();
                                        }
                                        catch (Throwable throwable2) {
                                            throwable.addSuppressed(throwable2);
                                        }
                                    }
                                    throw throwable;
                                }
                                catch (IOException e) {
                                    LOG.info((Throwable)e);
                                }
                            }
                        }
                    }
                    return "";
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    RuntimeException runtimeException;
                    Object[] objectArray;
                    Object[] objectArray2;
                    int n2;
                    String string;
                    switch (n) {
                        default: {
                            string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                            break;
                        }
                        case 2: {
                            string = "@NotNull method %s.%s must not return null";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            n2 = 3;
                            break;
                        }
                        case 2: {
                            n2 = 2;
                            break;
                        }
                    }
                    Object[] objectArray3 = new Object[n2];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "data";
                            break;
                        }
                        case 2: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/ide/gdpr/ConsentOptions$InstanceHolder$1";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/ide/gdpr/ConsentOptions$InstanceHolder$1";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[1] = "loadText";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "writeDefaultConsents";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray;
                            objectArray[2] = "writeConfirmedConsents";
                            break;
                        }
                        case 2: {
                            break;
                        }
                    }
                    String string2 = String.format(string, objectArray);
                    switch (n) {
                        default: {
                            runtimeException = new IllegalArgumentException(string2);
                            break;
                        }
                        case 2: {
                            runtimeException = new IllegalStateException(string2);
                            break;
                        }
                    }
                    throw runtimeException;
                }
            }, appInfo.isEAP() && appInfo.isVendorJetBrains());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/gdpr/ConsentOptions$InstanceHolder", "getBundledResourcePath"));
        }
    }
}

