/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.fileTemplates.impl;

import com.intellij.DynamicBundle;
import com.intellij.ide.fileTemplates.impl.FileTemplateBase;
import com.intellij.ide.fileTemplates.impl.UrlUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.reference.SoftReference;
import com.intellij.util.ResourceUtil;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.Reference;
import java.net.URL;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultTemplate {
    private static final Logger LOG = Logger.getInstance(DefaultTemplate.class);
    private final String myName;
    private final String myExtension;
    private final URL myTextURL;
    private final String myDescriptionPath;
    private Reference<String> myText;
    @Nullable
    private final URL myDescriptionURL;
    private Reference<String> myDescriptionText;

    public DefaultTemplate(@NotNull String name, @NotNull String extension2, @NotNull URL templateURL, @Nullable URL descriptionURL) {
        if (name == null) {
            DefaultTemplate.$$$reportNull$$$0(0);
        }
        if (extension2 == null) {
            DefaultTemplate.$$$reportNull$$$0(1);
        }
        if (templateURL == null) {
            DefaultTemplate.$$$reportNull$$$0(2);
        }
        this(name, extension2, templateURL, descriptionURL, null);
    }

    DefaultTemplate(@NotNull String name, @NotNull String extension2, @NotNull URL templateURL, @Nullable URL descriptionURL, @Nullable String descriptionPath) {
        if (name == null) {
            DefaultTemplate.$$$reportNull$$$0(3);
        }
        if (extension2 == null) {
            DefaultTemplate.$$$reportNull$$$0(4);
        }
        if (templateURL == null) {
            DefaultTemplate.$$$reportNull$$$0(5);
        }
        this.myName = name;
        this.myExtension = extension2;
        this.myTextURL = templateURL;
        this.myDescriptionURL = descriptionURL;
        this.myDescriptionPath = descriptionPath;
    }

    @NotNull
    @NlsSafe
    private static String loadText(@NotNull ThrowableComputable<String, IOException> computable) {
        if (computable == null) {
            DefaultTemplate.$$$reportNull$$$0(6);
        }
        String text2 = "";
        try {
            text2 = StringUtil.convertLineSeparators((String)((String)computable.compute()));
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
        String string = text2;
        if (string == null) {
            DefaultTemplate.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            DefaultTemplate.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    public String getQualifiedName() {
        String string = FileTemplateBase.getQualifiedName(this.getName(), this.getExtension());
        if (string == null) {
            DefaultTemplate.$$$reportNull$$$0(9);
        }
        return string;
    }

    @NotNull
    public String getExtension() {
        String string = this.myExtension;
        if (string == null) {
            DefaultTemplate.$$$reportNull$$$0(10);
        }
        return string;
    }

    @NotNull
    public URL getTemplateURL() {
        URL uRL = this.myTextURL;
        if (uRL == null) {
            DefaultTemplate.$$$reportNull$$$0(11);
        }
        return uRL;
    }

    @NotNull
    public String getText() {
        String text2 = (String)SoftReference.dereference(this.myText);
        if (text2 == null) {
            text2 = DefaultTemplate.loadText((ThrowableComputable<String, IOException>)((ThrowableComputable)() -> UrlUtil.loadText(this.myTextURL)));
            this.myText = new java.lang.ref.SoftReference<String>(text2);
        }
        String string = text2;
        if (string == null) {
            DefaultTemplate.$$$reportNull$$$0(12);
        }
        return string;
    }

    @NotNull
    @Nls
    public String getDescriptionText() {
        if (this.myDescriptionURL == null) {
            return "";
        }
        String text2 = (String)SoftReference.dereference(this.myDescriptionText);
        if (text2 == null) {
            text2 = DefaultTemplate.loadText((ThrowableComputable<String, IOException>)((ThrowableComputable)() -> {
                InputStream stream;
                ClassLoader langBundleLoader;
                DynamicBundle.LanguageBundleEP langBundle = DynamicBundle.findLanguageBundle();
                PluginDescriptor descriptor2 = langBundle != null ? langBundle.pluginDescriptor : null;
                ClassLoader classLoader = langBundleLoader = descriptor2 != null ? descriptor2.getPluginClassLoader() : null;
                if (langBundleLoader != null && this.myDescriptionPath != null && (stream = langBundleLoader.getResourceAsStream("fileTemplates/" + this.myDescriptionPath)) != null) {
                    return ResourceUtil.loadText((InputStream)stream);
                }
                return UrlUtil.loadText(this.myDescriptionURL);
            }));
            this.myDescriptionText = new java.lang.ref.SoftReference<String>(text2);
        }
        String string = text2;
        if (string == null) {
            DefaultTemplate.$$$reportNull$$$0(13);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateURL";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computable";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/fileTemplates/impl/DefaultTemplate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/fileTemplates/impl/DefaultTemplate";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "loadText";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifiedName";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtension";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getTemplateURL";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescriptionText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "loadText";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

