/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.favoritesTreeView;

import com.intellij.ide.favoritesTreeView.ProjectViewNodeWithChildrenList;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewUtil;
import com.intellij.usages.TextChunk;
import com.intellij.usages.UsageInfo2UsageAdapter;
import com.intellij.usages.UsagePresentation;
import org.jetbrains.annotations.NotNull;

public class UsageProjectTreeNode
extends ProjectViewNodeWithChildrenList<UsageInfo> {
    private final UsagePresentation myUsagePresentation;

    public UsageProjectTreeNode(Project project, @NotNull UsageInfo usage, ViewSettings viewSettings) {
        if (usage == null) {
            UsageProjectTreeNode.$$$reportNull$$$0(0);
        }
        super(project, usage, viewSettings);
        UsageInfo2UsageAdapter adapter = new UsageInfo2UsageAdapter(usage);
        this.myUsagePresentation = adapter.getPresentation();
    }

    public boolean contains(@NotNull VirtualFile file2) {
        UsageInfo info2;
        if (file2 == null) {
            UsageProjectTreeNode.$$$reportNull$$$0(1);
        }
        if ((info2 = (UsageInfo)this.getValue()) == null) {
            return false;
        }
        PsiElement element2 = info2.getElement();
        return element2 != null && file2.equals(element2.getContainingFile().getVirtualFile());
    }

    public String toString() {
        return this.myUsagePresentation.getPlainText();
    }

    protected void update(@NotNull PresentationData presentation2) {
        if (presentation2 == null) {
            UsageProjectTreeNode.$$$reportNull$$$0(2);
        }
        presentation2.setIcon(this.myUsagePresentation.getIcon());
        presentation2.setTooltip(this.myUsagePresentation.getTooltipText());
        Object[] text2 = this.myUsagePresentation.getText();
        UsageProjectTreeNode.updatePresentationWithTextChunks(presentation2, (TextChunk[])text2);
        presentation2.setPresentableText(StringUtil.join((Object[])text2, chunk -> chunk.getText(), (String)""));
    }

    public static void updatePresentationWithTextChunks(PresentationData presentation2, TextChunk[] text2) {
        for (TextChunk chunk : text2) {
            presentation2.addText(chunk.getText(), chunk.getSimpleAttributesIgnoreBackground());
        }
    }

    public void navigate(boolean requestFocus) {
        UsageViewUtil.navigateTo((UsageInfo)this.getValue(), requestFocus);
    }

    public boolean canNavigate() {
        return this.canNavigateToSource();
    }

    public boolean canNavigateToSource() {
        return ((UsageInfo)this.getValue()).getElement().isValid();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usage";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/favoritesTreeView/UsageProjectTreeNode";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "contains";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

