/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.customize;

import com.intellij.ide.customize.IdSet;
import com.intellij.ide.customize.PluginGroupDescription;
import com.intellij.ide.plugins.DisabledPluginsState;
import com.intellij.ide.plugins.IdeaPluginDependency;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.PluginDependency;
import com.intellij.ide.plugins.PluginDescriptorLoader;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginNode;
import com.intellij.ide.plugins.marketplace.MarketplaceRequests;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.swing.Icon;
import javax.swing.SwingWorker;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PluginGroups {
    public static final String CORE = "Core";
    private static final int MAX_DESCR_LENGTH = 55;
    private final List<Group> myTree = new ArrayList<Group>();
    private final Map<PluginId, PluginGroupDescription> myFeaturedPlugins = new LinkedHashMap<PluginId, PluginGroupDescription>();
    private final Map<String, List<IdSet>> myGroups = new LinkedHashMap<String, List<IdSet>>();
    private final Map<String, @Nls String> myDescriptions = new LinkedHashMap<String, String>();
    private final Map<PluginId, PluginNode> myPluginsFromRepository = new HashMap<PluginId, PluginNode>();
    private final Set<PluginId> myDisabledPluginIds = new HashSet<PluginId>(DisabledPluginsState.loadDisabledPlugins());
    private final Map<PluginId, IdeaPluginDescriptorImpl> myEnabledPlugins = PluginDescriptorLoader.loadUncachedDescriptors(PluginManagerCore.isUnitTestMode, PluginManagerCore.isRunningFromSources()).stream().collect(Collectors.toUnmodifiableMap(IdeaPluginDescriptorImpl::getPluginId, Function.identity()));
    private boolean myInitialized;
    private Runnable myLoadingCallback;

    public PluginGroups() {
        SwingWorker<List<PluginNode>, Object> worker = new SwingWorker<List<PluginNode>, Object>(){

            @Override
            @NotNull
            protected List<PluginNode> doInBackground() {
                ArrayList<PluginNode> arrayList;
                try {
                    List<PluginNode> featuredPlugins = MarketplaceRequests.loadLastCompatiblePluginDescriptors(PluginGroups.this.myFeaturedPlugins.keySet());
                    Set<PluginId> dependsIds = featuredPlugins.stream().map(PluginNode::getDependencies).flatMap(Collection::stream).filter(dep -> !dep.isOptional()).map(IdeaPluginDependency::getPluginId).collect(Collectors.toUnmodifiableSet());
                    ArrayList<PluginNode> result2 = new ArrayList<PluginNode>(featuredPlugins);
                    result2.addAll(MarketplaceRequests.loadLastCompatiblePluginDescriptors(dependsIds));
                    arrayList = result2;
                }
                catch (Exception e) {
                    List<PluginNode> list2 = List.of();
                    if (list2 == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return list2;
                }
                if (arrayList == null) {
                    1.$$$reportNull$$$0(0);
                }
                return arrayList;
            }

            @Override
            protected void done() {
                block4: {
                    try {
                        for (PluginNode node : (List)this.get()) {
                            PluginGroups.this.myPluginsFromRepository.put(node.getPluginId(), node);
                        }
                        if (PluginGroups.this.myLoadingCallback != null) {
                            PluginGroups.this.myLoadingCallback.run();
                        }
                    }
                    catch (InterruptedException | ExecutionException e) {
                        if (PluginGroups.this.myLoadingCallback == null) break block4;
                        PluginGroups.this.myLoadingCallback.run();
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/customize/PluginGroups$1", "doInBackground"));
            }
        };
        this.myTree.addAll(this.getInitialGroups());
        LinkedHashMap<String, String> tempFeaturedPlugins = new LinkedHashMap<String, String>();
        this.initGroups(this.myTree, tempFeaturedPlugins);
        for (Map.Entry entry2 : tempFeaturedPlugins.entrySet()) {
            String[] strings = PluginGroups.parseString((String)entry2.getValue());
            PluginGroupDescription description = PluginGroupDescription.create(strings[2], (String)entry2.getKey(), strings[0], strings[1]);
            this.myFeaturedPlugins.put(description.getPluginId(), description);
        }
        worker.execute();
    }

    public void setLoadingCallback(Runnable loadingCallback) {
        this.myLoadingCallback = loadingCallback;
        if (!this.myPluginsFromRepository.isEmpty()) {
            this.myLoadingCallback.run();
        }
    }

    @Deprecated(since="2020.2", forRemoval=true)
    protected void initGroups(@NotNull List<? super Group> groups2, @NotNull Map<String, String> featuredPlugins) {
        if (groups2 == null) {
            PluginGroups.$$$reportNull$$$0(0);
        }
        if (featuredPlugins == null) {
            PluginGroups.$$$reportNull$$$0(1);
        }
        this.initFeaturedPlugins(featuredPlugins);
    }

    @NotNull
    protected List<Group> getInitialGroups() {
        List<Group> list2 = List.of();
        if (list2 == null) {
            PluginGroups.$$$reportNull$$$0(2);
        }
        return list2;
    }

    @Deprecated(since="2020.2", forRemoval=true)
    protected void initFeaturedPlugins(@NotNull Map<String, String> featuredPlugins) {
        if (featuredPlugins == null) {
            PluginGroups.$$$reportNull$$$0(3);
        }
        for (PluginGroupDescription description : this.getInitialFeaturedPlugins()) {
            featuredPlugins.put(description.getName(), description.toString());
        }
    }

    @NotNull
    protected List<PluginGroupDescription> getInitialFeaturedPlugins() {
        List<PluginGroupDescription> list2 = List.of();
        if (list2 == null) {
            PluginGroups.$$$reportNull$$$0(4);
        }
        return list2;
    }

    @Deprecated(since="2020.2", forRemoval=true)
    @NotNull
    @NonNls
    public static String parsePluginId(@NotNull @Nls String string) {
        if (string == null) {
            PluginGroups.$$$reportNull$$$0(5);
        }
        String string2 = PluginGroups.parseString(string)[2];
        if (string2 == null) {
            PluginGroups.$$$reportNull$$$0(6);
        }
        return string2;
    }

    @Deprecated(since="2020.2", forRemoval=true)
    @NotNull
    private static @NotNull String @NotNull [] parseString(@NotNull @Nls String string) {
        if (string == null) {
            PluginGroups.$$$reportNull$$$0(7);
        }
        String[] stringArray = string.split(":", 3);
        if (stringArray == null) {
            PluginGroups.$$$reportNull$$$0(8);
        }
        return stringArray;
    }

    private void initIfNeeded() {
        if (this.myInitialized) {
            return;
        }
        this.myInitialized = true;
        for (Group g : this.myTree) {
            String groupDescription;
            String group2 = g.getId();
            if (CORE.equals(group2)) continue;
            ArrayList<IdSet> idSets = new ArrayList<IdSet>();
            for (String idDescription : g.getPluginIdDescription()) {
                int i2 = idDescription.indexOf(":");
                IdSet idSet = this.createIdSet(i2 > 0 ? idDescription.substring(0, i2) : null, i2 > 0 ? idDescription.substring(i2 + 1) : idDescription);
                if (idSet == null) continue;
                idSets.add(idSet);
            }
            this.myGroups.put(group2, idSets);
            @Nls StringBuilder description = new StringBuilder();
            StringUtil.join(idSets, IdSet::getTitle, (String)", ", (StringBuilder)description);
            if (description.length() > 55) {
                int lastWord = description.lastIndexOf(",", 55);
                description.delete(lastWord, description.length()).append("...");
            }
            if ((groupDescription = g.getDescription()) != null) {
                description = new StringBuilder(groupDescription);
            }
            description.insert(0, "<html><body><center><i>");
            this.myDescriptions.put(group2, description.toString());
        }
    }

    @NotNull
    public List<Group> getTree() {
        this.initIfNeeded();
        List<Group> list2 = this.myTree;
        if (list2 == null) {
            PluginGroups.$$$reportNull$$$0(9);
        }
        return list2;
    }

    @Deprecated(forRemoval=true, since="2020.2")
    public Map<@NlsSafe String, @Nls String> getFeaturedPlugins() {
        return this.myFeaturedPlugins.values().stream().collect(Collectors.toUnmodifiableMap(PluginGroupDescription::getName, PluginGroupDescription::toString));
    }

    @NotNull
    public Map<PluginId, PluginGroupDescription> getFeaturedPluginDescriptions() {
        Map<PluginId, PluginGroupDescription> map2 = Collections.unmodifiableMap(this.myFeaturedPlugins);
        if (map2 == null) {
            PluginGroups.$$$reportNull$$$0(10);
        }
        return map2;
    }

    @Nls
    public String getDescription(String group2) {
        this.initIfNeeded();
        return this.myDescriptions.get(group2);
    }

    public List<IdSet> getSets(String group2) {
        this.initIfNeeded();
        return this.myGroups.get(group2);
    }

    @Nullable
    public final IdeaPluginDescriptor findPlugin(@NotNull PluginId pluginId) {
        if (pluginId == null) {
            PluginGroups.$$$reportNull$$$0(11);
        }
        return this.myEnabledPlugins.get(pluginId);
    }

    public final boolean isIdSetAllEnabled(@NotNull IdSet set2) {
        if (set2 == null) {
            PluginGroups.$$$reportNull$$$0(12);
        }
        for (PluginId id2 : set2.getPluginIds()) {
            if (this.isPluginEnabled(id2)) continue;
            return false;
        }
        return true;
    }

    public final void setIdSetEnabled(@NotNull IdSet set2, boolean enabled) {
        if (set2 == null) {
            PluginGroups.$$$reportNull$$$0(13);
        }
        for (PluginId id2 : set2.getPluginIds()) {
            this.setPluginEnabledWithDependencies(id2, enabled);
        }
    }

    @NotNull
    public final Set<PluginId> getDisabledPluginIds() {
        Set<PluginId> set2 = Collections.unmodifiableSet(this.myDisabledPluginIds);
        if (set2 == null) {
            PluginGroups.$$$reportNull$$$0(14);
        }
        return set2;
    }

    @NotNull
    public final Collection<PluginNode> getPluginsFromRepository() {
        Collection<PluginNode> collection = Collections.unmodifiableCollection(this.myPluginsFromRepository.values());
        if (collection == null) {
            PluginGroups.$$$reportNull$$$0(15);
        }
        return collection;
    }

    public final boolean isPluginEnabled(@NotNull PluginId pluginId) {
        if (pluginId == null) {
            PluginGroups.$$$reportNull$$$0(16);
        }
        this.initIfNeeded();
        return !this.myDisabledPluginIds.contains(pluginId);
    }

    @NotNull
    private Set<PluginId> getAllPluginIds(@NotNull Set<PluginId> pluginIds2) {
        if (pluginIds2 == null) {
            PluginGroups.$$$reportNull$$$0(17);
        }
        HashSet<PluginId> result2 = new HashSet<PluginId>(pluginIds2);
        for (PluginId pluginId : pluginIds2) {
            for (List<IdSet> sets : this.myGroups.values()) {
                for (IdSet set2 : sets) {
                    Set<PluginId> ids = set2.getPluginIds();
                    if (!ids.contains(pluginId)) continue;
                    result2.addAll(ids);
                }
            }
        }
        Set<PluginId> set3 = Collections.unmodifiableSet(result2);
        if (set3 == null) {
            PluginGroups.$$$reportNull$$$0(18);
        }
        return set3;
    }

    public void setPluginEnabledWithDependencies(@NotNull PluginId pluginId, boolean enabled) {
        if (pluginId == null) {
            PluginGroups.$$$reportNull$$$0(19);
        }
        this.initIfNeeded();
        HashSet<PluginId> accumulator = new HashSet<PluginId>();
        if (enabled) {
            this.collectIdsToEnable(pluginId, accumulator);
            this.myDisabledPluginIds.removeAll(this.getAllPluginIds(accumulator));
        } else {
            this.collectIdsToDisable(pluginId, accumulator);
            this.myDisabledPluginIds.addAll(this.getAllPluginIds(accumulator));
        }
    }

    private void collectIdsToEnable(@NotNull PluginId pluginId, @NotNull Set<PluginId> accumulator) {
        if (pluginId == null) {
            PluginGroups.$$$reportNull$$$0(20);
        }
        if (accumulator == null) {
            PluginGroups.$$$reportNull$$$0(21);
        }
        accumulator.add(pluginId);
        IdeaPluginDescriptorImpl descriptor2 = this.myEnabledPlugins.get(pluginId);
        if (descriptor2 == null) {
            return;
        }
        for (PluginDependency dependency : descriptor2.pluginDependencies) {
            if (dependency.isOptional() || dependency.getPluginId().equals((Object)PluginManagerCore.CORE_ID)) continue;
            this.collectIdsToEnable(dependency.getPluginId(), accumulator);
        }
    }

    private void collectIdsToDisable(@NotNull PluginId pluginId, @NotNull Set<PluginId> accumulator) {
        if (pluginId == null) {
            PluginGroups.$$$reportNull$$$0(22);
        }
        if (accumulator == null) {
            PluginGroups.$$$reportNull$$$0(23);
        }
        accumulator.add(pluginId);
        for (IdeaPluginDescriptorImpl descriptor2 : this.myEnabledPlugins.values()) {
            for (PluginDependency dependency : descriptor2.pluginDependencies) {
                if (dependency.isOptional() || !dependency.getPluginId().equals((Object)pluginId)) continue;
                this.collectIdsToDisable(descriptor2.getPluginId(), accumulator);
            }
        }
    }

    @Nullable
    private IdSet createIdSet(@Nls @Nullable String title2, @NonNls @NotNull String ids) {
        if (ids == null) {
            PluginGroups.$$$reportNull$$$0(24);
        }
        Ref firstDescriptor = Ref.create();
        Set<PluginId> pluginIds2 = Arrays.stream(ids.split(",")).distinct().map(PluginId::getId).filter(pluginId -> {
            IdeaPluginDescriptorImpl descriptor2 = this.myEnabledPlugins.get(pluginId);
            firstDescriptor.setIfNull((Object)descriptor2);
            return descriptor2 != null;
        }).collect(Collectors.toUnmodifiableSet());
        int size = pluginIds2.size();
        if (title2 == null && size > 1) {
            throw new IllegalArgumentException("There is no common title for " + size + " ids: " + ids);
        }
        return size != 0 ? new IdSet(pluginIds2, title2 != null ? title2 : ((IdeaPluginDescriptorImpl)firstDescriptor.get()).getName()) : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 14: 
            case 15: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 14: 
            case 15: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groups";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "featuredPlugins";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 14: 
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/customize/PluginGroups";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "string";
                break;
            }
            case 11: 
            case 16: 
            case 19: 
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginId";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "set";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginIds";
                break;
            }
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accumulator";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ids";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/customize/PluginGroups";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getInitialGroups";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getInitialFeaturedPlugins";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "parsePluginId";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "parseString";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getTree";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getFeaturedPluginDescriptions";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisabledPluginIds";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getPluginsFromRepository";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllPluginIds";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "initGroups";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 14: 
            case 15: 
            case 18: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "initFeaturedPlugins";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "parsePluginId";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "parseString";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findPlugin";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isIdSetAllEnabled";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "setIdSetEnabled";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isPluginEnabled";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getAllPluginIds";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "setPluginEnabledWithDependencies";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "collectIdsToEnable";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "collectIdsToDisable";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "createIdSet";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 14: 
            case 15: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class Group {
        @NonNls
        private final String myId;
        @Nls
        private final String myName;
        private final Icon myIcon;
        @Nls
        private final String myDescription;
        private final List<String> myPluginIdDescription;

        @Deprecated
        @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
        public Group(@NonNls @NotNull String name, @Nullable Icon icon2, @Nullable String description, @NonNls @NotNull List<String> pluginIdDescription) {
            if (name == null) {
                Group.$$$reportNull$$$0(0);
            }
            if (pluginIdDescription == null) {
                Group.$$$reportNull$$$0(1);
            }
            this(name, name, icon2, description, pluginIdDescription);
        }

        public Group(@NonNls @NotNull String id2, @Nls @NotNull String name, @Nullable Icon icon2, @Nullable @Nls String description, @NonNls @NotNull List<String> pluginIdDescription) {
            if (id2 == null) {
                Group.$$$reportNull$$$0(2);
            }
            if (name == null) {
                Group.$$$reportNull$$$0(3);
            }
            if (pluginIdDescription == null) {
                Group.$$$reportNull$$$0(4);
            }
            this.myId = id2;
            this.myName = name;
            this.myIcon = icon2;
            this.myDescription = description;
            this.myPluginIdDescription = pluginIdDescription;
        }

        @NonNls
        public String getId() {
            return this.myId;
        }

        @NotNull
        @Nls
        public String getName() {
            String string = this.myName;
            if (string == null) {
                Group.$$$reportNull$$$0(5);
            }
            return string;
        }

        @Nullable
        public Icon getIcon() {
            return this.myIcon;
        }

        @Nullable
        @Nls
        public String getDescription() {
            return this.myDescription;
        }

        @NotNull
        public List<String> getPluginIdDescription() {
            List<String> list2 = this.myPluginIdDescription;
            if (list2 == null) {
                Group.$$$reportNull$$$0(6);
            }
            return list2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: 
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: 
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pluginIdDescription";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "id";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/customize/PluginGroups$Group";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/customize/PluginGroups$Group";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPluginIdDescription";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 5: 
                case 6: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 5: 
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

